/* -*- C++ -*- */
// Option manager for performance tests.

#ifndef _PERFORMANCE_TEST_OPTIONS_H
#define _PERFORMANCE_TEST_OPTIONS_H

#include "ace/config-all.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "ace/Profile_Timer.h"
#include "ace/Log_Msg.h"
#include "ace/Thread_Manager.h"
#include "ace/Atomic_Op.h"
#include "ace/svc_export.h"

#if defined (ACE_HAS_THREADS)

class ACE_Svc_Export Performance_Test_Options
{
public:
  Performance_Test_Options ();
  void   parse_args (int argc, ACE_TCHAR *argv[]);

  void   init ();

  void   start_timer ();
  void   stop_timer ();

  void   thr_count (size_t count);
  size_t thr_count ();

  void   pipe_addr (ACE_TCHAR pipe[]);
  ACE_TCHAR *pipe_addr ();

  void   mapped_file (ACE_TCHAR filename[]);
  ACE_TCHAR *mapped_file ();

  void   service_entry (ACE_TCHAR *service_entry);
  ACE_TCHAR *service_entry ();

  void   sleep_time (size_t count);
  size_t sleep_time ();

  void   logical_connections (size_t count);
  size_t logical_connections ();

  void   physical_connections (size_t count);
  size_t physical_connections ();

  void   consecutive_ports (size_t count);
  size_t consecutive_ports ();

  void   initial_queue_length (size_t length);
  size_t initial_queue_length ();

  void   high_water_mark (size_t size);
  size_t high_water_mark ();

  void   low_water_mark (size_t size);
  size_t low_water_mark ();

  void   msg_size (size_t size);
  size_t msg_size ();

  void   iterations (size_t n);
  size_t iterations ();

  void   n_lwps (size_t n);
  size_t n_lwps ();

  void   t_flags (long flag);
  long   t_flags ();

  size_t count ();

  int    debug ();
  int    verbose ();
  int    do_checksum ();
  int    do_generate ();
  int    do_ack ();
  int    do_delete ();
  int    do_eager_exit ();
  int    do_print_summary ();
  int    do_udp ();
  int    do_xdr ();
  int    do_zero_copy ();
  void   print_results ();

  ACE_Atomic_Op<ACE_Thread_Mutex, size_t> msg_count;        // Keep track of number of messages atomically.
  int *thr_work_count;  // Count activity per-thread.
  int thr_wc_size;           // Max number of threads.

private:
  ACE_Profile_Timer _itimer;            // Keep track of time.
  ACE_TCHAR     *_service_entry;        // Name of the shared object file and shared object.
  ACE_TCHAR     *_mapped_file;          // Name of the mapped file.
  ACE_TCHAR     *_pipe_addr;            // Name of the STREAM pipe.
  size_t        _sleep_time;            // Time to sleep.
  size_t        _n_lwps;                // Number of LWPs.
  size_t        _thr_count;             // Number of threads to spawn.
  long          _t_flags;               // Flags to thr_create().
  size_t        _high_water_mark;       // ACE_Queue high water mark.
  size_t        _low_water_mark;        // ACE_Queue low water mark.
  size_t        _msg_size;              // Size of a message.
  size_t        _initial_queue_length;  // Initial number of items in the queue.
  size_t        _logical_connections;   // Number of logical connections.
  size_t        _physical_connections;  // Number of physical connections.
  size_t        _iterations;            // Number of iterations to run the test program.
  int           _generate;              // Generate the data.
  int           _udp;                   // Use UDP format.
  int           _debugging;             // Extra debugging info.
  int           _verbosity;             // Extra verbose messages.
  int           _ack;                   // Do an acknowledgement.
  int           _checksum;              // Is checksumming enabled?.
  int           _xdr;                   // Is xdr conversion enabled?.
  int           _free_memory;           // Are we freeing up memory?.
  int           _zero_copy;             // Implement a zero-copy driver?.
  int           _print_summary;         // Print a summary of the results only.
  size_t        _consecutive_ports;     // Number of consecutive messages from same port.
  int           _eager_exit;            // Exit eagerly, without cleaning up.
};

// Make this available to any code that wants to see it!
extern ACE_Svc_Export Performance_Test_Options performance_test_options;

#include "Performance_Test_Options.inl"
#endif /* ACE_HAS_THREADS */
#endif /* _PERFORMANCE_TEST_OPTIONS_H */
