#!/usr/bin/python
#
# sysmon client in python
# Ryan Tucker <rtucker@ttgcitn.com>, 22May97
#

import string
import sys
import sysmonlib
import time

hostname = sys.argv[1]

def transtype(typecode):
	if typecode == '1': return 'TCP'
	elif typecode == '2': return 'UDP'
	elif typecode == '3': return 'PING'
	elif typecode == '5': return 'NNTP'
	elif typecode == '6': return 'SMTP'
	elif typecode == '7': return 'IMAP'
	elif typecode == '8': return 'POP3'
	elif typecode == '9': return 'X500'
	else: return 'Unknown'

def transstat(typecode):
	if typecode == '0': return 'OK'
	elif typecode == '1': return 'Conn Refused'
	elif typecode == '2': return 'Unreachable'
	elif typecode == '3': return 'Host Down'
	elif typecode == '4': return 'Timed Out'
	elif typecode == '5': return 'No DNS'
	elif typecode == '6': return 'Unpingable'
	elif typecode == '7': return 'Throttled'
	elif typecode == '8': return 'No Auth'
	elif typecode == '9': return 'No Response'
	elif typecode == '10': return 'In Progress'
	elif typecode == '11': return 'Bad Auth'
	elif typecode == '12': return 'Bad Response'
	elif typecode == '13': return 'Wedged'
	else: return 'Unknown'

def transnotify(notifycode):
	if notifycode == '0':
		return 'No'
	if notifycode == '1':
		return 'Yes'
	return 'Doh'

def transtime(unixtime):
        curtime = time.strftime('%d%b%y %H:%M',time.localtime(unixtime))
	return curtime

print ''
print 'System report from ' + hostname + ' at ' + time.ctime(time.time()) + ':'
print ''
print 'Hostname              Type  Port  Status          Count  Paged  Time'
print '='*77

for i in sysmonlib.sysmon.stat(sysmonlib.sysmon(hostname)):
	print string.ljust(i[0],21)[:21],
	print string.ljust(transtype(i[1]),5),
	print string.ljust(i[2],5),
	print string.ljust(transstat(i[3]),15),
	print string.ljust(i[4],6),
	print string.ljust(transnotify(i[5]),6),
	print transtime(string.atoi(i[6]))

print ''


