
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 1 "cfg-grammar.y"


#include "syslog-ng.h"
#include "cfg.h"
#include "sgroup.h"
#include "dgroup.h"
#include "center.h"
#include "filter.h"
#include "templates.h"
#include "logreader.h"
#include "logparser.h"
#include "logrewrite.h"

#if ENABLE_SSL /* BEGIN MARK: tls */
#include "tlscontext.h"
#endif         /* END MARK */

#include "affile.h"
#include "afinter.h"
#include "afsocket.h"
#include "afinet.h"
#include "afunix.h"
#include "afstreams.h"
#include "afuser.h"
#include "afprog.h"
#if ENABLE_SQL
#include "afsql.h"
#endif

#include "messages.h"

#include "syslog-names.h"

#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* FIXME: the lexer allocates strings with strdup instead of g_strdup,
 * therefore there are unnecessary g_strdup/free pairs in the grammar. These
 * should be removed. */

void yyerror(char *msg);
int yylex();

LogDriver *last_driver;
LogReaderOptions *last_reader_options;
LogWriterOptions *last_writer_options;
LogTemplate *last_template;
SocketOptions *last_sock_options;
LogParser *last_parser;
FilterRE *last_re_filter;
LogRewrite *last_rewrite;
gint last_addr_family = AF_INET;
gchar *last_include_file;

#if ENABLE_SSL
TLSContext *last_tls_context;
#endif


#if ! ENABLE_IPV6
#undef AF_INET6
#define AF_INET6 0; g_assert_not_reached()

#endif

static struct _LogTemplate *
cfg_check_inline_template(GlobalConfig *cfg, const gchar *template_or_name)
{
  struct _LogTemplate *template = cfg_lookup_template(configuration, template_or_name);
  if (template == NULL)
    {
      template = log_template_new(NULL, template_or_name); 
      template->def_inline = TRUE;
    }
  return template;
}

static gboolean
cfg_check_template(LogTemplate *template)
{
  GError *error = NULL;
  if (!log_template_compile(template, &error))
    {
      msg_error("Error compiling template",
                evt_tag_str("template", template->template),
                evt_tag_str("error", error->message),
                NULL);
      g_clear_error(&error);
      return FALSE;
    }
  return TRUE;
}




/* Line 189 of yacc.c  */
#line 172 "cfg-grammar.c"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     KW_SOURCE = 258,
     KW_FILTER = 259,
     KW_PARSER = 260,
     KW_DESTINATION = 261,
     KW_LOG = 262,
     KW_OPTIONS = 263,
     KW_INCLUDE = 264,
     KW_INTERNAL = 265,
     KW_FILE = 266,
     KW_PIPE = 267,
     KW_UNIX_STREAM = 268,
     KW_UNIX_DGRAM = 269,
     KW_TCP = 270,
     KW_UDP = 271,
     KW_TCP6 = 272,
     KW_UDP6 = 273,
     KW_USERTTY = 274,
     KW_DOOR = 275,
     KW_SUN_STREAMS = 276,
     KW_PROGRAM = 277,
     KW_SQL = 278,
     KW_TYPE = 279,
     KW_COLUMNS = 280,
     KW_INDEXES = 281,
     KW_VALUES = 282,
     KW_PASSWORD = 283,
     KW_DATABASE = 284,
     KW_USERNAME = 285,
     KW_TABLE = 286,
     KW_ENCODING = 287,
     KW_DELIMITERS = 288,
     KW_QUOTES = 289,
     KW_QUOTE_PAIRS = 290,
     KW_NULL = 291,
     KW_SYSLOG = 292,
     KW_TRANSPORT = 293,
     KW_FSYNC = 294,
     KW_MARK_FREQ = 295,
     KW_STATS_FREQ = 296,
     KW_STATS_LEVEL = 297,
     KW_FLUSH_LINES = 298,
     KW_SUPPRESS = 299,
     KW_FLUSH_TIMEOUT = 300,
     KW_LOG_MSG_SIZE = 301,
     KW_FILE_TEMPLATE = 302,
     KW_PROTO_TEMPLATE = 303,
     KW_CHAIN_HOSTNAMES = 304,
     KW_NORMALIZE_HOSTNAMES = 305,
     KW_KEEP_HOSTNAME = 306,
     KW_CHECK_HOSTNAME = 307,
     KW_BAD_HOSTNAME = 308,
     KW_KEEP_TIMESTAMP = 309,
     KW_USE_DNS = 310,
     KW_USE_FQDN = 311,
     KW_DNS_CACHE = 312,
     KW_DNS_CACHE_SIZE = 313,
     KW_DNS_CACHE_EXPIRE = 314,
     KW_DNS_CACHE_EXPIRE_FAILED = 315,
     KW_DNS_CACHE_HOSTS = 316,
     KW_PERSIST_ONLY = 317,
     KW_TZ_CONVERT = 318,
     KW_TS_FORMAT = 319,
     KW_FRAC_DIGITS = 320,
     KW_LOG_FIFO_SIZE = 321,
     KW_LOG_DISK_FIFO_SIZE = 322,
     KW_LOG_FETCH_LIMIT = 323,
     KW_LOG_IW_SIZE = 324,
     KW_LOG_PREFIX = 325,
     KW_PROGRAM_OVERRIDE = 326,
     KW_HOST_OVERRIDE = 327,
     KW_THROTTLE = 328,
     KW_TLS = 329,
     KW_PEER_VERIFY = 330,
     KW_KEY_FILE = 331,
     KW_CERT_FILE = 332,
     KW_CA_DIR = 333,
     KW_CRL_DIR = 334,
     KW_TRUSTED_KEYS = 335,
     KW_TRUSTED_DN = 336,
     KW_FLAGS = 337,
     KW_PAD_SIZE = 338,
     KW_TIME_ZONE = 339,
     KW_RECV_TIME_ZONE = 340,
     KW_SEND_TIME_ZONE = 341,
     KW_LOCAL_TIME_ZONE = 342,
     KW_TIME_REOPEN = 343,
     KW_TIME_REAP = 344,
     KW_TIME_SLEEP = 345,
     KW_TMPL_ESCAPE = 346,
     KW_OPTIONAL = 347,
     KW_CREATE_DIRS = 348,
     KW_OWNER = 349,
     KW_GROUP = 350,
     KW_PERM = 351,
     KW_DIR_OWNER = 352,
     KW_DIR_GROUP = 353,
     KW_DIR_PERM = 354,
     KW_TEMPLATE = 355,
     KW_TEMPLATE_ESCAPE = 356,
     KW_FOLLOW_FREQ = 357,
     KW_OVERWRITE_IF_OLDER = 358,
     KW_DEFAULT_FACILITY = 359,
     KW_DEFAULT_LEVEL = 360,
     KW_KEEP_ALIVE = 361,
     KW_MAX_CONNECTIONS = 362,
     KW_LOCALIP = 363,
     KW_IP = 364,
     KW_LOCALPORT = 365,
     KW_PORT = 366,
     KW_DESTPORT = 367,
     KW_IP_TTL = 368,
     KW_SO_BROADCAST = 369,
     KW_IP_TOS = 370,
     KW_SO_SNDBUF = 371,
     KW_SO_RCVBUF = 372,
     KW_SO_KEEPALIVE = 373,
     KW_SPOOF_SOURCE = 374,
     KW_USE_TIME_RECVD = 375,
     KW_FACILITY = 376,
     KW_LEVEL = 377,
     KW_HOST = 378,
     KW_MATCH = 379,
     KW_MESSAGE = 380,
     KW_NETMASK = 381,
     KW_CSV_PARSER = 382,
     KW_VALUE = 383,
     KW_DB_PARSER = 384,
     KW_REWRITE = 385,
     KW_SET = 386,
     KW_SUBST = 387,
     KW_YES = 388,
     KW_NO = 389,
     KW_GC_IDLE_THRESHOLD = 390,
     KW_GC_BUSY_THRESHOLD = 391,
     KW_COMPRESS = 392,
     KW_MAC = 393,
     KW_AUTH = 394,
     KW_ENCRYPT = 395,
     KW_IFDEF = 396,
     KW_ENDIF = 397,
     LL_DOTDOT = 398,
     LL_IDENTIFIER = 399,
     LL_NUMBER = 400,
     LL_FLOAT = 401,
     LL_STRING = 402,
     KW_OR = 403,
     KW_AND = 404,
     KW_NOT = 405
   };
#endif
/* Tokens.  */
#define KW_SOURCE 258
#define KW_FILTER 259
#define KW_PARSER 260
#define KW_DESTINATION 261
#define KW_LOG 262
#define KW_OPTIONS 263
#define KW_INCLUDE 264
#define KW_INTERNAL 265
#define KW_FILE 266
#define KW_PIPE 267
#define KW_UNIX_STREAM 268
#define KW_UNIX_DGRAM 269
#define KW_TCP 270
#define KW_UDP 271
#define KW_TCP6 272
#define KW_UDP6 273
#define KW_USERTTY 274
#define KW_DOOR 275
#define KW_SUN_STREAMS 276
#define KW_PROGRAM 277
#define KW_SQL 278
#define KW_TYPE 279
#define KW_COLUMNS 280
#define KW_INDEXES 281
#define KW_VALUES 282
#define KW_PASSWORD 283
#define KW_DATABASE 284
#define KW_USERNAME 285
#define KW_TABLE 286
#define KW_ENCODING 287
#define KW_DELIMITERS 288
#define KW_QUOTES 289
#define KW_QUOTE_PAIRS 290
#define KW_NULL 291
#define KW_SYSLOG 292
#define KW_TRANSPORT 293
#define KW_FSYNC 294
#define KW_MARK_FREQ 295
#define KW_STATS_FREQ 296
#define KW_STATS_LEVEL 297
#define KW_FLUSH_LINES 298
#define KW_SUPPRESS 299
#define KW_FLUSH_TIMEOUT 300
#define KW_LOG_MSG_SIZE 301
#define KW_FILE_TEMPLATE 302
#define KW_PROTO_TEMPLATE 303
#define KW_CHAIN_HOSTNAMES 304
#define KW_NORMALIZE_HOSTNAMES 305
#define KW_KEEP_HOSTNAME 306
#define KW_CHECK_HOSTNAME 307
#define KW_BAD_HOSTNAME 308
#define KW_KEEP_TIMESTAMP 309
#define KW_USE_DNS 310
#define KW_USE_FQDN 311
#define KW_DNS_CACHE 312
#define KW_DNS_CACHE_SIZE 313
#define KW_DNS_CACHE_EXPIRE 314
#define KW_DNS_CACHE_EXPIRE_FAILED 315
#define KW_DNS_CACHE_HOSTS 316
#define KW_PERSIST_ONLY 317
#define KW_TZ_CONVERT 318
#define KW_TS_FORMAT 319
#define KW_FRAC_DIGITS 320
#define KW_LOG_FIFO_SIZE 321
#define KW_LOG_DISK_FIFO_SIZE 322
#define KW_LOG_FETCH_LIMIT 323
#define KW_LOG_IW_SIZE 324
#define KW_LOG_PREFIX 325
#define KW_PROGRAM_OVERRIDE 326
#define KW_HOST_OVERRIDE 327
#define KW_THROTTLE 328
#define KW_TLS 329
#define KW_PEER_VERIFY 330
#define KW_KEY_FILE 331
#define KW_CERT_FILE 332
#define KW_CA_DIR 333
#define KW_CRL_DIR 334
#define KW_TRUSTED_KEYS 335
#define KW_TRUSTED_DN 336
#define KW_FLAGS 337
#define KW_PAD_SIZE 338
#define KW_TIME_ZONE 339
#define KW_RECV_TIME_ZONE 340
#define KW_SEND_TIME_ZONE 341
#define KW_LOCAL_TIME_ZONE 342
#define KW_TIME_REOPEN 343
#define KW_TIME_REAP 344
#define KW_TIME_SLEEP 345
#define KW_TMPL_ESCAPE 346
#define KW_OPTIONAL 347
#define KW_CREATE_DIRS 348
#define KW_OWNER 349
#define KW_GROUP 350
#define KW_PERM 351
#define KW_DIR_OWNER 352
#define KW_DIR_GROUP 353
#define KW_DIR_PERM 354
#define KW_TEMPLATE 355
#define KW_TEMPLATE_ESCAPE 356
#define KW_FOLLOW_FREQ 357
#define KW_OVERWRITE_IF_OLDER 358
#define KW_DEFAULT_FACILITY 359
#define KW_DEFAULT_LEVEL 360
#define KW_KEEP_ALIVE 361
#define KW_MAX_CONNECTIONS 362
#define KW_LOCALIP 363
#define KW_IP 364
#define KW_LOCALPORT 365
#define KW_PORT 366
#define KW_DESTPORT 367
#define KW_IP_TTL 368
#define KW_SO_BROADCAST 369
#define KW_IP_TOS 370
#define KW_SO_SNDBUF 371
#define KW_SO_RCVBUF 372
#define KW_SO_KEEPALIVE 373
#define KW_SPOOF_SOURCE 374
#define KW_USE_TIME_RECVD 375
#define KW_FACILITY 376
#define KW_LEVEL 377
#define KW_HOST 378
#define KW_MATCH 379
#define KW_MESSAGE 380
#define KW_NETMASK 381
#define KW_CSV_PARSER 382
#define KW_VALUE 383
#define KW_DB_PARSER 384
#define KW_REWRITE 385
#define KW_SET 386
#define KW_SUBST 387
#define KW_YES 388
#define KW_NO 389
#define KW_GC_IDLE_THRESHOLD 390
#define KW_GC_BUSY_THRESHOLD 391
#define KW_COMPRESS 392
#define KW_MAC 393
#define KW_AUTH 394
#define KW_ENCRYPT 395
#define KW_IFDEF 396
#define KW_ENDIF 397
#define LL_DOTDOT 398
#define LL_IDENTIFIER 399
#define LL_NUMBER 400
#define LL_FLOAT 401
#define LL_STRING 402
#define KW_OR 403
#define KW_AND 404
#define KW_NOT 405




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 99 "cfg-grammar.y"

        gint token;
	gint64 num;
	double fnum;
	char *cptr;
	void *ptr;
	FilterExprNode *node;



/* Line 214 of yacc.c  */
#line 519 "cfg-grammar.c"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */


/* Line 264 of yacc.c  */
#line 531 "cfg-grammar.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  58
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   2652

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  156
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  171
/* YYNRULES -- Number of rules.  */
#define YYNRULES  474
/* YYNRULES -- Number of states.  */
#define YYNSTATES  1159

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   405

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     154,   155,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,   151,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   152,     2,   153,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     6,    11,    12,    15,    18,    21,
      24,    27,    30,    33,    36,    39,    44,    50,    56,    61,
      66,    72,    74,    78,    79,    84,    89,    94,    99,   104,
     107,   108,   116,   122,   123,   126,   127,   131,   132,   138,
     142,   143,   148,   153,   158,   163,   168,   173,   175,   180,
     185,   189,   190,   192,   194,   196,   198,   200,   202,   206,
     211,   216,   217,   221,   222,   226,   231,   233,   238,   243,
     244,   250,   251,   257,   258,   264,   265,   271,   272,   276,
     277,   281,   284,   285,   290,   294,   299,   303,   308,   312,
     317,   319,   321,   323,   324,   327,   330,   331,   333,   338,
     343,   348,   353,   355,   357,   358,   361,   364,   365,   367,
     368,   374,   376,   381,   386,   387,   393,   394,   397,   400,
     401,   403,   408,   413,   418,   423,   424,   430,   432,   437,
     438,   442,   444,   449,   451,   452,   456,   459,   460,   462,
     467,   469,   472,   473,   478,   483,   488,   493,   498,   503,
     508,   513,   518,   523,   528,   533,   538,   543,   548,   553,
     558,   563,   568,   573,   578,   583,   586,   587,   591,   592,
     594,   596,   598,   600,   602,   604,   606,   611,   612,   616,
     619,   620,   622,   627,   632,   636,   641,   645,   650,   654,
     659,   663,   668,   672,   677,   681,   686,   691,   696,   701,
     706,   707,   711,   714,   715,   717,   722,   726,   731,   735,
     740,   744,   749,   754,   755,   761,   762,   768,   769,   775,
     776,   782,   783,   787,   788,   792,   795,   796,   798,   800,
     802,   803,   807,   810,   811,   816,   821,   826,   831,   833,
     835,   837,   839,   844,   845,   849,   852,   853,   855,   856,
     862,   867,   872,   873,   877,   880,   881,   883,   888,   893,
     898,   903,   908,   909,   915,   920,   925,   926,   930,   935,
     936,   939,   942,   943,   945,   950,   955,   960,   965,   970,
     975,   980,   985,   990,   995,  1000,  1005,  1010,  1015,  1020,
    1025,  1027,  1030,  1031,  1036,  1041,  1046,  1051,  1056,  1061,
    1066,  1071,  1076,  1081,  1086,  1089,  1090,  1094,  1095,  1100,
    1105,  1110,  1115,  1120,  1125,  1130,  1135,  1140,  1145,  1150,
    1155,  1160,  1165,  1170,  1175,  1180,  1185,  1190,  1195,  1200,
    1205,  1210,  1215,  1220,  1225,  1230,  1234,  1239,  1243,  1248,
    1252,  1257,  1261,  1266,  1270,  1275,  1279,  1284,  1289,  1294,
    1299,  1304,  1309,  1314,  1319,  1324,  1329,  1332,  1333,  1335,
    1340,  1345,  1350,  1355,  1360,  1365,  1370,  1372,  1374,  1377,
    1381,  1385,  1389,  1394,  1399,  1404,  1409,  1414,  1415,  1422,
    1423,  1430,  1431,  1438,  1439,  1446,  1447,  1454,  1457,  1458,
    1460,  1465,  1468,  1469,  1474,  1479,  1482,  1483,  1486,  1488,
    1491,  1493,  1497,  1499,  1500,  1506,  1507,  1513,  1516,  1517,
    1522,  1524,  1529,  1534,  1537,  1538,  1540,  1545,  1550,  1555,
    1560,  1565,  1568,  1569,  1571,  1574,  1575,  1576,  1585,  1586,
    1594,  1597,  1598,  1603,  1608,  1613,  1615,  1617,  1619,  1621,
    1623,  1625,  1627,  1629,  1631,  1633,  1635,  1637,  1639,  1641,
    1643,  1645,  1647,  1649,  1651,  1653,  1655,  1657,  1659,  1661,
    1663,  1665,  1667,  1669,  1671,  1673,  1675,  1677,  1679,  1681,
    1683,  1686,  1687,  1689,  1691
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     157,     0,    -1,   158,    -1,    -1,   160,   151,   159,   158,
      -1,    -1,     3,   161,    -1,     6,   165,    -1,     7,   166,
      -1,     4,   162,    -1,     5,   163,    -1,   130,   164,    -1,
     100,   175,    -1,     8,   174,    -1,     9,   167,    -1,   320,
     152,   181,   153,    -1,   320,   152,   286,   151,   153,    -1,
     320,   152,   301,   151,   153,    -1,   320,   152,   311,   153,
      -1,   320,   152,   230,   153,    -1,   152,   168,   170,   172,
     153,    -1,   320,    -1,   169,   151,   168,    -1,    -1,     3,
     154,   320,   155,    -1,     4,   154,   320,   155,    -1,     5,
     154,   320,   155,    -1,   130,   154,   320,   155,    -1,     6,
     154,   320,   155,    -1,   171,   170,    -1,    -1,     7,   152,
     168,   170,   172,   153,   151,    -1,    82,   154,   173,   155,
     151,    -1,    -1,   320,   173,    -1,    -1,   152,   282,   153,
      -1,    -1,   320,   176,   152,   177,   153,    -1,   178,   151,
     177,    -1,    -1,   100,   154,   320,   155,    -1,   101,   154,
     318,   155,    -1,   116,   154,   145,   155,    -1,   117,   154,
     145,   155,    -1,   114,   154,   318,   155,    -1,   118,   154,
     318,   155,    -1,   179,    -1,   113,   154,   145,   155,    -1,
     115,   154,   145,   155,    -1,   182,   151,   181,    -1,    -1,
     183,    -1,   184,    -1,   190,    -1,   212,    -1,   222,    -1,
     219,    -1,    10,   154,   155,    -1,    11,   154,   185,   155,
      -1,    12,   154,   187,   155,    -1,    -1,   320,   186,   227,
      -1,    -1,   320,   188,   189,    -1,    92,   154,   318,   155,
      -1,   227,    -1,    14,   154,   195,   155,    -1,    13,   154,
     197,   155,    -1,    -1,    16,   191,   154,   201,   155,    -1,
      -1,    15,   192,   154,   206,   155,    -1,    -1,    18,   193,
     154,   201,   155,    -1,    -1,    17,   194,   154,   206,   155,
      -1,    -1,   320,   196,   199,    -1,    -1,   320,   198,   199,
      -1,   200,   199,    -1,    -1,    94,   154,   322,   155,    -1,
      94,   154,   155,    -1,    95,   154,   322,   155,    -1,    95,
     154,   155,    -1,    96,   154,   145,   155,    -1,    96,   154,
     155,    -1,    92,   154,   318,   155,    -1,   211,    -1,   228,
      -1,   179,    -1,    -1,   202,   203,    -1,   204,   203,    -1,
      -1,   205,    -1,   108,   154,   320,   155,    -1,   109,   154,
     320,   155,    -1,   110,   154,   322,   155,    -1,   111,   154,
     322,   155,    -1,   228,    -1,   180,    -1,    -1,   207,   208,
      -1,   209,   208,    -1,    -1,   205,    -1,    -1,    74,   210,
     154,   284,   155,    -1,   211,    -1,   106,   154,   318,   155,
      -1,   107,   154,   145,   155,    -1,    -1,    37,   213,   154,
     214,   155,    -1,    -1,   215,   216,    -1,   217,   216,    -1,
      -1,   205,    -1,    38,   154,   320,   155,    -1,    38,   154,
      15,   155,    -1,    38,   154,    16,   155,    -1,    38,   154,
      74,   155,    -1,    -1,    74,   218,   154,   284,   155,    -1,
     211,    -1,    22,   154,   220,   155,    -1,    -1,   320,   221,
     227,    -1,   141,    -1,    21,   154,   223,   155,    -1,   142,
      -1,    -1,   320,   224,   225,    -1,   226,   225,    -1,    -1,
     141,    -1,    20,   154,   320,   155,    -1,   142,    -1,   228,
     227,    -1,    -1,    69,   154,   145,   155,    -1,    49,   154,
     318,   155,    -1,    50,   154,   318,   155,    -1,    51,   154,
     318,   155,    -1,    56,   154,   318,   155,    -1,    55,   154,
     319,   155,    -1,    57,   154,   318,   155,    -1,    71,   154,
     320,   155,    -1,    72,   154,   320,   155,    -1,    70,   154,
     320,   155,    -1,    84,   154,   320,   155,    -1,    52,   154,
     318,   155,    -1,    82,   154,   229,   155,    -1,    46,   154,
     145,   155,    -1,    68,   154,   145,   155,    -1,    83,   154,
     145,   155,    -1,   102,   154,   146,   155,    -1,   102,   154,
     145,   155,    -1,    54,   154,   318,   155,    -1,    32,   154,
     320,   155,    -1,   105,   154,   325,   155,    -1,   104,   154,
     326,   155,    -1,   320,   229,    -1,    -1,   231,   151,   230,
      -1,    -1,   232,    -1,   237,    -1,   242,    -1,   270,    -1,
     271,    -1,   264,    -1,   274,    -1,    11,   154,   233,   155,
      -1,    -1,   320,   234,   235,    -1,   236,   235,    -1,    -1,
     280,    -1,    92,   154,   318,   155,    -1,    94,   154,   322,
     155,    -1,    94,   154,   155,    -1,    95,   154,   322,   155,
      -1,    95,   154,   155,    -1,    96,   154,   145,   155,    -1,
      96,   154,   155,    -1,    97,   154,   322,   155,    -1,    97,
     154,   155,    -1,    98,   154,   322,   155,    -1,    98,   154,
     155,    -1,    99,   154,   145,   155,    -1,    99,   154,   155,
      -1,    93,   154,   318,   155,    -1,   103,   154,   145,   155,
      -1,    39,   154,   318,   155,    -1,    87,   154,   320,   155,
      -1,    12,   154,   238,   155,    -1,    -1,   320,   239,   240,
      -1,   241,   240,    -1,    -1,   280,    -1,    94,   154,   322,
     155,    -1,    94,   154,   155,    -1,    95,   154,   322,   155,
      -1,    95,   154,   155,    -1,    96,   154,   145,   155,    -1,
      96,   154,   155,    -1,    14,   154,   247,   155,    -1,    13,
     154,   249,   155,    -1,    -1,    16,   243,   154,   253,   155,
      -1,    -1,    15,   244,   154,   258,   155,    -1,    -1,    18,
     245,   154,   253,   155,    -1,    -1,    17,   246,   154,   258,
     155,    -1,    -1,   320,   248,   251,    -1,    -1,   320,   250,
     251,    -1,   251,   252,    -1,    -1,   280,    -1,   263,    -1,
     179,    -1,    -1,   320,   254,   255,    -1,   255,   257,    -1,
      -1,   108,   154,   320,   155,    -1,   110,   154,   322,   155,
      -1,   111,   154,   322,   155,    -1,   112,   154,   322,   155,
      -1,   180,    -1,   280,    -1,   263,    -1,   256,    -1,   119,
     154,   318,   155,    -1,    -1,   320,   259,   260,    -1,   260,
     261,    -1,    -1,   256,    -1,    -1,    74,   262,   154,   284,
     155,    -1,   106,   154,   318,   155,    -1,    37,   154,   265,
     155,    -1,    -1,   320,   266,   267,    -1,   267,   268,    -1,
      -1,   256,    -1,    38,   154,   320,   155,    -1,    38,   154,
      15,   155,    -1,    38,   154,    16,   155,    -1,    38,   154,
      74,   155,    -1,   119,   154,   318,   155,    -1,    -1,    74,
     269,   154,   284,   155,    -1,    19,   154,   320,   155,    -1,
      22,   154,   272,   155,    -1,    -1,   320,   273,   279,    -1,
      23,   154,   275,   155,    -1,    -1,   276,   277,    -1,   278,
     277,    -1,    -1,   141,    -1,    24,   154,   320,   155,    -1,
     123,   154,   320,   155,    -1,   111,   154,   322,   155,    -1,
      30,   154,   320,   155,    -1,    28,   154,   320,   155,    -1,
      29,   154,   320,   155,    -1,    31,   154,   320,   155,    -1,
      25,   154,   323,   155,    -1,    26,   154,   323,   155,    -1,
      27,   154,   323,   155,    -1,    66,   154,   145,   155,    -1,
      67,   154,   145,   155,    -1,    65,   154,   145,   155,    -1,
      84,   154,   320,   155,    -1,    87,   154,   320,   155,    -1,
      36,   154,   320,   155,    -1,   142,    -1,   280,   279,    -1,
      -1,    82,   154,   281,   155,    -1,    66,   154,   145,   155,
      -1,    43,   154,   145,   155,    -1,    45,   154,   145,   155,
      -1,    44,   154,   145,   155,    -1,   100,   154,   320,   155,
      -1,   101,   154,   318,   155,    -1,    84,   154,   320,   155,
      -1,    64,   154,   320,   155,    -1,    65,   154,   145,   155,
      -1,    73,   154,   145,   155,    -1,   320,   281,    -1,    -1,
     283,   151,   282,    -1,    -1,    40,   154,   145,   155,    -1,
      41,   154,   145,   155,    -1,    42,   154,   145,   155,    -1,
      43,   154,   145,   155,    -1,    45,   154,   145,   155,    -1,
      49,   154,   318,   155,    -1,    50,   154,   318,   155,    -1,
      51,   154,   318,   155,    -1,    52,   154,   318,   155,    -1,
      53,   154,   320,   155,    -1,   120,   154,   318,   155,    -1,
      56,   154,   318,   155,    -1,    55,   154,   319,   155,    -1,
      88,   154,   145,   155,    -1,    89,   154,   145,   155,    -1,
      90,   154,   145,   155,    -1,    66,   154,   145,   155,    -1,
      69,   154,   145,   155,    -1,    68,   154,   145,   155,    -1,
      46,   154,   145,   155,    -1,    54,   154,   318,   155,    -1,
      64,   154,   320,   155,    -1,    65,   154,   145,   155,    -1,
     136,   154,   145,   155,    -1,   135,   154,   145,   155,    -1,
      93,   154,   318,   155,    -1,    94,   154,   322,   155,    -1,
      94,   154,   155,    -1,    95,   154,   322,   155,    -1,    95,
     154,   155,    -1,    96,   154,   145,   155,    -1,    96,   154,
     155,    -1,    97,   154,   322,   155,    -1,    97,   154,   155,
      -1,    98,   154,   322,   155,    -1,    98,   154,   155,    -1,
      99,   154,   145,   155,    -1,    99,   154,   155,    -1,    57,
     154,   318,   155,    -1,    58,   154,   145,   155,    -1,    59,
     154,   145,   155,    -1,    60,   154,   145,   155,    -1,    61,
     154,   320,   155,    -1,    47,   154,   320,   155,    -1,    48,
     154,   320,   155,    -1,    85,   154,   320,   155,    -1,    86,
     154,   320,   155,    -1,    87,   154,   320,   155,    -1,   285,
     284,    -1,    -1,   141,    -1,    75,   154,   320,   155,    -1,
      76,   154,   320,   155,    -1,    77,   154,   320,   155,    -1,
      78,   154,   320,   155,    -1,    79,   154,   320,   155,    -1,
      80,   154,   323,   155,    -1,    81,   154,   323,   155,    -1,
     142,    -1,   287,    -1,   150,   286,    -1,   286,   148,   286,
      -1,   286,   149,   286,    -1,   154,   286,   155,    -1,   121,
     154,   298,   155,    -1,   121,   154,   145,   155,    -1,   122,
     154,   299,   155,    -1,     4,   154,   320,   155,    -1,   126,
     154,   320,   155,    -1,    -1,    22,   154,   320,   288,   295,
     155,    -1,    -1,   123,   154,   320,   289,   295,   155,    -1,
      -1,   124,   154,   320,   290,   293,   155,    -1,    -1,   125,
     154,   320,   291,   295,   155,    -1,    -1,     3,   154,   320,
     292,   295,   155,    -1,   294,   293,    -1,    -1,   296,    -1,
     128,   154,   320,   155,    -1,   296,   295,    -1,    -1,    24,
     154,   320,   155,    -1,    82,   154,   297,   155,    -1,   320,
     297,    -1,    -1,   326,   298,    -1,   326,    -1,   300,   299,
      -1,   300,    -1,   325,   143,   325,    -1,   325,    -1,    -1,
     127,   154,   302,   308,   155,    -1,    -1,   129,   154,   303,
     304,   155,    -1,   305,   304,    -1,    -1,    11,   154,   320,
     155,    -1,   307,    -1,    25,   154,   323,   155,    -1,   100,
     154,   320,   155,    -1,   309,   308,    -1,    -1,   306,    -1,
      82,   154,   310,   155,    -1,    33,   154,   320,   155,    -1,
      34,   154,   320,   155,    -1,    35,   154,   320,   155,    -1,
      36,   154,   320,   155,    -1,   320,   310,    -1,    -1,   312,
      -1,   313,   312,    -1,    -1,    -1,   132,   154,   320,   320,
     314,   316,   155,   151,    -1,    -1,   131,   154,   320,   315,
     316,   155,   151,    -1,   317,   316,    -1,    -1,   128,   154,
     320,   155,    -1,    24,   154,   320,   155,    -1,    82,   154,
     297,   155,    -1,   133,    -1,   134,    -1,   145,    -1,   318,
      -1,    62,    -1,   144,    -1,   147,    -1,   321,    -1,     5,
      -1,   130,    -1,     9,    -1,    25,    -1,    33,    -1,    34,
      -1,    35,    -1,    36,    -1,   127,    -1,   129,    -1,    32,
      -1,   131,    -1,   132,    -1,   128,    -1,    71,    -1,    72,
      -1,    38,    -1,    80,    -1,    81,    -1,   125,    -1,    24,
      -1,    23,    -1,   104,    -1,   105,    -1,   320,    -1,   145,
      -1,   324,    -1,   320,   324,    -1,    -1,   320,    -1,   320,
      -1,    37,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   317,   317,   322,   321,   336,   340,   341,   342,   343,
     344,   345,   346,   347,   348,   352,   356,   360,   363,   366,
     370,   374,   377,   378,   382,   383,   384,   385,   386,   390,
     391,   395,   399,   400,   405,   406,   411,   416,   415,   424,
     425,   429,   430,   434,   435,   436,   437,   441,   442,   443,
     447,   448,   452,   453,   454,   455,   456,   457,   461,   465,
     466,   471,   470,   481,   480,   490,   491,   495,   496,   497,
     497,   498,   498,   499,   499,   500,   500,   505,   504,   518,
     517,   531,   532,   536,   537,   538,   539,   540,   541,   542,
     543,   544,   545,   550,   550,   561,   562,   566,   570,   571,
     572,   573,   574,   575,   580,   580,   591,   592,   596,   599,
     598,   611,   615,   616,   620,   620,   625,   625,   636,   637,
     641,   642,   643,   644,   645,   647,   646,   658,   662,   667,
     666,   676,   679,   680,   687,   686,   697,   698,   702,   705,
     706,   712,   713,   717,   718,   719,   720,   721,   722,   723,
     724,   725,   726,   727,   728,   729,   730,   731,   732,   733,
     734,   735,   736,   737,   743,   752,   753,   758,   759,   763,
     764,   765,   766,   767,   768,   770,   775,   780,   779,   790,
     791,   795,   796,   797,   798,   799,   800,   801,   802,   803,
     804,   805,   806,   807,   808,   809,   810,   811,   812,   816,
     821,   820,   831,   832,   836,   837,   838,   839,   840,   841,
     842,   846,   847,   848,   848,   849,   849,   850,   850,   851,
     851,   856,   855,   867,   866,   877,   878,   882,   883,   884,
     889,   888,   901,   902,   907,   908,   909,   910,   911,   912,
     913,   917,   918,   923,   922,   935,   936,   940,   942,   941,
     956,   961,   965,   964,   976,   977,   981,   982,   983,   984,
     985,   986,   988,   987,  1003,  1007,  1012,  1011,  1023,  1028,
    1028,  1037,  1038,  1042,  1045,  1046,  1047,  1048,  1049,  1050,
    1051,  1052,  1053,  1054,  1055,  1056,  1057,  1058,  1059,  1060,
    1062,  1070,  1071,  1075,  1076,  1077,  1078,  1079,  1080,  1088,
    1089,  1090,  1091,  1092,  1096,  1097,  1102,  1103,  1107,  1108,
    1109,  1110,  1111,  1112,  1113,  1114,  1115,  1116,  1117,  1118,
    1119,  1120,  1121,  1122,  1131,  1132,  1133,  1134,  1135,  1136,
    1137,  1138,  1139,  1140,  1141,  1142,  1143,  1144,  1145,  1146,
    1147,  1148,  1149,  1150,  1151,  1152,  1153,  1154,  1155,  1156,
    1158,  1159,  1160,  1161,  1162,  1163,  1168,  1169,  1173,  1177,
    1182,  1187,  1192,  1197,  1202,  1206,  1210,  1218,  1219,  1220,
    1221,  1222,  1226,  1227,  1228,  1229,  1230,  1232,  1231,  1244,
    1243,  1256,  1255,  1279,  1278,  1290,  1289,  1304,  1305,  1309,
    1310,  1314,  1315,  1319,  1324,  1328,  1329,  1334,  1335,  1339,
    1340,  1344,  1348,  1357,  1356,  1363,  1362,  1371,  1372,  1377,
    1381,  1382,  1386,  1399,  1400,  1404,  1405,  1406,  1407,  1408,
    1409,  1413,  1414,  1418,  1422,  1423,  1428,  1427,  1440,  1439,
    1448,  1449,  1453,  1454,  1465,  1469,  1470,  1471,  1475,  1476,
    1480,  1481,  1482,  1487,  1488,  1489,  1490,  1491,  1492,  1493,
    1494,  1495,  1496,  1497,  1498,  1499,  1500,  1501,  1502,  1503,
    1504,  1505,  1506,  1507,  1508,  1509,  1510,  1514,  1515,  1519,
    1523,  1524,  1528,  1545,  1559
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "KW_SOURCE", "KW_FILTER", "KW_PARSER",
  "KW_DESTINATION", "KW_LOG", "KW_OPTIONS", "KW_INCLUDE", "KW_INTERNAL",
  "KW_FILE", "KW_PIPE", "KW_UNIX_STREAM", "KW_UNIX_DGRAM", "KW_TCP",
  "KW_UDP", "KW_TCP6", "KW_UDP6", "KW_USERTTY", "KW_DOOR",
  "KW_SUN_STREAMS", "KW_PROGRAM", "KW_SQL", "KW_TYPE", "KW_COLUMNS",
  "KW_INDEXES", "KW_VALUES", "KW_PASSWORD", "KW_DATABASE", "KW_USERNAME",
  "KW_TABLE", "KW_ENCODING", "KW_DELIMITERS", "KW_QUOTES",
  "KW_QUOTE_PAIRS", "KW_NULL", "KW_SYSLOG", "KW_TRANSPORT", "KW_FSYNC",
  "KW_MARK_FREQ", "KW_STATS_FREQ", "KW_STATS_LEVEL", "KW_FLUSH_LINES",
  "KW_SUPPRESS", "KW_FLUSH_TIMEOUT", "KW_LOG_MSG_SIZE", "KW_FILE_TEMPLATE",
  "KW_PROTO_TEMPLATE", "KW_CHAIN_HOSTNAMES", "KW_NORMALIZE_HOSTNAMES",
  "KW_KEEP_HOSTNAME", "KW_CHECK_HOSTNAME", "KW_BAD_HOSTNAME",
  "KW_KEEP_TIMESTAMP", "KW_USE_DNS", "KW_USE_FQDN", "KW_DNS_CACHE",
  "KW_DNS_CACHE_SIZE", "KW_DNS_CACHE_EXPIRE", "KW_DNS_CACHE_EXPIRE_FAILED",
  "KW_DNS_CACHE_HOSTS", "KW_PERSIST_ONLY", "KW_TZ_CONVERT", "KW_TS_FORMAT",
  "KW_FRAC_DIGITS", "KW_LOG_FIFO_SIZE", "KW_LOG_DISK_FIFO_SIZE",
  "KW_LOG_FETCH_LIMIT", "KW_LOG_IW_SIZE", "KW_LOG_PREFIX",
  "KW_PROGRAM_OVERRIDE", "KW_HOST_OVERRIDE", "KW_THROTTLE", "KW_TLS",
  "KW_PEER_VERIFY", "KW_KEY_FILE", "KW_CERT_FILE", "KW_CA_DIR",
  "KW_CRL_DIR", "KW_TRUSTED_KEYS", "KW_TRUSTED_DN", "KW_FLAGS",
  "KW_PAD_SIZE", "KW_TIME_ZONE", "KW_RECV_TIME_ZONE", "KW_SEND_TIME_ZONE",
  "KW_LOCAL_TIME_ZONE", "KW_TIME_REOPEN", "KW_TIME_REAP", "KW_TIME_SLEEP",
  "KW_TMPL_ESCAPE", "KW_OPTIONAL", "KW_CREATE_DIRS", "KW_OWNER",
  "KW_GROUP", "KW_PERM", "KW_DIR_OWNER", "KW_DIR_GROUP", "KW_DIR_PERM",
  "KW_TEMPLATE", "KW_TEMPLATE_ESCAPE", "KW_FOLLOW_FREQ",
  "KW_OVERWRITE_IF_OLDER", "KW_DEFAULT_FACILITY", "KW_DEFAULT_LEVEL",
  "KW_KEEP_ALIVE", "KW_MAX_CONNECTIONS", "KW_LOCALIP", "KW_IP",
  "KW_LOCALPORT", "KW_PORT", "KW_DESTPORT", "KW_IP_TTL", "KW_SO_BROADCAST",
  "KW_IP_TOS", "KW_SO_SNDBUF", "KW_SO_RCVBUF", "KW_SO_KEEPALIVE",
  "KW_SPOOF_SOURCE", "KW_USE_TIME_RECVD", "KW_FACILITY", "KW_LEVEL",
  "KW_HOST", "KW_MATCH", "KW_MESSAGE", "KW_NETMASK", "KW_CSV_PARSER",
  "KW_VALUE", "KW_DB_PARSER", "KW_REWRITE", "KW_SET", "KW_SUBST", "KW_YES",
  "KW_NO", "KW_GC_IDLE_THRESHOLD", "KW_GC_BUSY_THRESHOLD", "KW_COMPRESS",
  "KW_MAC", "KW_AUTH", "KW_ENCRYPT", "KW_IFDEF", "KW_ENDIF", "LL_DOTDOT",
  "LL_IDENTIFIER", "LL_NUMBER", "LL_FLOAT", "LL_STRING", "KW_OR", "KW_AND",
  "KW_NOT", "';'", "'{'", "'}'", "'('", "')'", "$accept", "start", "stmts",
  "$@1", "stmt", "source_stmt", "filter_stmt", "parser_stmt",
  "rewrite_stmt", "dest_stmt", "log_stmt", "include_stmt", "log_items",
  "log_item", "log_forks", "log_fork", "log_flags", "log_flags_items",
  "options_stmt", "template_stmt", "$@2", "template_items",
  "template_item", "socket_option", "inet_socket_option", "source_items",
  "source_item", "source_afinter", "source_affile", "source_affile_params",
  "$@3", "source_afpipe_params", "$@4", "source_afpipe_options",
  "source_afsocket", "$@5", "$@6", "$@7", "$@8",
  "source_afunix_dgram_params", "$@9", "source_afunix_stream_params",
  "$@10", "source_afunix_options", "source_afunix_option",
  "source_afinet_udp_params", "$@11", "source_afinet_udp_options",
  "source_afinet_udp_option", "source_afinet_option",
  "source_afinet_tcp_params", "$@12", "source_afinet_tcp_options",
  "source_afinet_tcp_option", "$@13", "source_afsocket_stream_params",
  "source_afsyslog", "$@14", "source_afsyslog_params", "$@15",
  "source_afsyslog_options", "source_afsyslog_option", "$@16",
  "source_afprogram", "source_afprogram_params", "$@17",
  "source_afstreams", "source_afstreams_params", "$@18",
  "source_afstreams_options", "source_afstreams_option",
  "source_reader_options", "source_reader_option",
  "source_reader_option_flags", "dest_items", "dest_item", "dest_affile",
  "dest_affile_params", "$@19", "dest_affile_options",
  "dest_affile_option", "dest_afpipe", "dest_afpipe_params", "$@20",
  "dest_afpipe_options", "dest_afpipe_option", "dest_afsocket", "$@21",
  "$@22", "$@23", "$@24", "dest_afunix_dgram_params", "$@25",
  "dest_afunix_stream_params", "$@26", "dest_afunix_options",
  "dest_afunix_option", "dest_afinet_udp_params", "$@27",
  "dest_afinet_udp_options", "dest_afinet_option",
  "dest_afinet_udp_option", "dest_afinet_tcp_params", "$@28",
  "dest_afinet_tcp_options", "dest_afinet_tcp_option", "$@29",
  "dest_afsocket_option", "dest_afsyslog", "dest_afsyslog_params", "$@30",
  "dest_afsyslog_options", "dest_afsyslog_option", "$@31", "dest_afuser",
  "dest_afprogram", "dest_afprogram_params", "$@32", "dest_afsql",
  "dest_afsql_params", "$@33", "dest_afsql_options", "dest_afsql_option",
  "dest_writer_options", "dest_writer_option", "dest_writer_options_flags",
  "options_items", "options_item", "tls_options", "tls_option",
  "filter_expr", "filter_simple_expr", "$@34", "$@35", "$@36", "$@37",
  "$@38", "filter_match_opts", "filter_match_opt", "filter_re_opts",
  "filter_re_opt", "regexp_option_flags", "filter_fac_list",
  "filter_level_list", "filter_level", "parser_expr", "$@39", "$@40",
  "parser_db_opts", "parser_db_opt", "parser_column_opt", "parser_opt",
  "parser_csv_opts", "parser_csv_opt", "parser_csv_flags",
  "rewrite_expr_list", "rewrite_expr_list_build", "rewrite_expr", "$@41",
  "$@42", "rewrite_expr_opts", "rewrite_expr_opt", "yesno", "dnsmode",
  "string", "reserved_words_as_strings", "string_or_number", "string_list",
  "string_list_build", "level_string", "facility_string", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,    59,   123,   125,    40,    41
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   156,   157,   159,   158,   158,   160,   160,   160,   160,
     160,   160,   160,   160,   160,   161,   162,   163,   164,   165,
     166,   167,   168,   168,   169,   169,   169,   169,   169,   170,
     170,   171,   172,   172,   173,   173,   174,   176,   175,   177,
     177,   178,   178,   179,   179,   179,   179,   180,   180,   180,
     181,   181,   182,   182,   182,   182,   182,   182,   183,   184,
     184,   186,   185,   188,   187,   189,   189,   190,   190,   191,
     190,   192,   190,   193,   190,   194,   190,   196,   195,   198,
     197,   199,   199,   200,   200,   200,   200,   200,   200,   200,
     200,   200,   200,   202,   201,   203,   203,   204,   205,   205,
     205,   205,   205,   205,   207,   206,   208,   208,   209,   210,
     209,   209,   211,   211,   213,   212,   215,   214,   216,   216,
     217,   217,   217,   217,   217,   218,   217,   217,   219,   221,
     220,   222,   222,   222,   224,   223,   225,   225,   226,   226,
     226,   227,   227,   228,   228,   228,   228,   228,   228,   228,
     228,   228,   228,   228,   228,   228,   228,   228,   228,   228,
     228,   228,   228,   228,   228,   229,   229,   230,   230,   231,
     231,   231,   231,   231,   231,   231,   232,   234,   233,   235,
     235,   236,   236,   236,   236,   236,   236,   236,   236,   236,
     236,   236,   236,   236,   236,   236,   236,   236,   236,   237,
     239,   238,   240,   240,   241,   241,   241,   241,   241,   241,
     241,   242,   242,   243,   242,   244,   242,   245,   242,   246,
     242,   248,   247,   250,   249,   251,   251,   252,   252,   252,
     254,   253,   255,   255,   256,   256,   256,   256,   256,   256,
     256,   257,   257,   259,   258,   260,   260,   261,   262,   261,
     263,   264,   266,   265,   267,   267,   268,   268,   268,   268,
     268,   268,   269,   268,   270,   271,   273,   272,   274,   276,
     275,   277,   277,   278,   278,   278,   278,   278,   278,   278,
     278,   278,   278,   278,   278,   278,   278,   278,   278,   278,
     278,   279,   279,   280,   280,   280,   280,   280,   280,   280,
     280,   280,   280,   280,   281,   281,   282,   282,   283,   283,
     283,   283,   283,   283,   283,   283,   283,   283,   283,   283,
     283,   283,   283,   283,   283,   283,   283,   283,   283,   283,
     283,   283,   283,   283,   283,   283,   283,   283,   283,   283,
     283,   283,   283,   283,   283,   283,   283,   283,   283,   283,
     283,   283,   283,   283,   283,   283,   284,   284,   285,   285,
     285,   285,   285,   285,   285,   285,   285,   286,   286,   286,
     286,   286,   287,   287,   287,   287,   287,   288,   287,   289,
     287,   290,   287,   291,   287,   292,   287,   293,   293,   294,
     294,   295,   295,   296,   296,   297,   297,   298,   298,   299,
     299,   300,   300,   302,   301,   303,   301,   304,   304,   305,
     306,   306,   307,   308,   308,   309,   309,   309,   309,   309,
     309,   310,   310,   311,   312,   312,   314,   313,   315,   313,
     316,   316,   317,   317,   317,   318,   318,   318,   319,   319,
     320,   320,   320,   321,   321,   321,   321,   321,   321,   321,
     321,   321,   321,   321,   321,   321,   321,   321,   321,   321,
     321,   321,   321,   321,   321,   321,   321,   322,   322,   323,
     324,   324,   325,   326,   326
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     0,     4,     0,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     4,     5,     5,     4,     4,
       5,     1,     3,     0,     4,     4,     4,     4,     4,     2,
       0,     7,     5,     0,     2,     0,     3,     0,     5,     3,
       0,     4,     4,     4,     4,     4,     4,     1,     4,     4,
       3,     0,     1,     1,     1,     1,     1,     1,     3,     4,
       4,     0,     3,     0,     3,     4,     1,     4,     4,     0,
       5,     0,     5,     0,     5,     0,     5,     0,     3,     0,
       3,     2,     0,     4,     3,     4,     3,     4,     3,     4,
       1,     1,     1,     0,     2,     2,     0,     1,     4,     4,
       4,     4,     1,     1,     0,     2,     2,     0,     1,     0,
       5,     1,     4,     4,     0,     5,     0,     2,     2,     0,
       1,     4,     4,     4,     4,     0,     5,     1,     4,     0,
       3,     1,     4,     1,     0,     3,     2,     0,     1,     4,
       1,     2,     0,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     2,     0,     3,     0,     1,
       1,     1,     1,     1,     1,     1,     4,     0,     3,     2,
       0,     1,     4,     4,     3,     4,     3,     4,     3,     4,
       3,     4,     3,     4,     3,     4,     4,     4,     4,     4,
       0,     3,     2,     0,     1,     4,     3,     4,     3,     4,
       3,     4,     4,     0,     5,     0,     5,     0,     5,     0,
       5,     0,     3,     0,     3,     2,     0,     1,     1,     1,
       0,     3,     2,     0,     4,     4,     4,     4,     1,     1,
       1,     1,     4,     0,     3,     2,     0,     1,     0,     5,
       4,     4,     0,     3,     2,     0,     1,     4,     4,     4,
       4,     4,     0,     5,     4,     4,     0,     3,     4,     0,
       2,     2,     0,     1,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       1,     2,     0,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     2,     0,     3,     0,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     3,     4,     3,     4,     3,
       4,     3,     4,     3,     4,     3,     4,     4,     4,     4,
       4,     4,     4,     4,     4,     4,     2,     0,     1,     4,
       4,     4,     4,     4,     4,     4,     1,     1,     2,     3,
       3,     3,     4,     4,     4,     4,     4,     0,     6,     0,
       6,     0,     6,     0,     6,     0,     6,     2,     0,     1,
       4,     2,     0,     4,     4,     2,     0,     2,     1,     2,
       1,     3,     1,     0,     5,     0,     5,     2,     0,     4,
       1,     4,     4,     2,     0,     1,     4,     4,     4,     4,
       4,     2,     0,     1,     2,     0,     0,     8,     0,     7,
       2,     0,     4,     4,     4,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     0,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     2,     0,   443,   445,   464,   463,   446,   453,   447,
     448,   449,   450,   459,   457,   458,   460,   461,   465,   466,
     462,   451,   456,   452,   444,   454,   455,   440,   441,     6,
       0,   442,     9,     0,    10,     0,     7,     0,    23,     8,
     307,    13,    14,    21,    12,    37,    11,     0,     1,     3,
      51,     0,     0,   168,     0,     0,     0,     0,     0,    30,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   425,     5,     0,     0,
       0,     0,     0,    71,    69,    75,    73,     0,     0,   114,
     131,   133,     0,     0,    52,    53,    54,    55,    57,    56,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   367,     0,     0,     0,     0,     0,     0,     0,
     215,   213,   219,   217,     0,     0,     0,     0,     0,     0,
     169,   170,   171,   174,   172,   173,   175,     0,     0,     0,
       0,     0,     0,    33,    30,    23,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    36,   307,
      40,     0,     0,     0,   423,   425,     4,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    15,
      51,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     368,     0,     0,     0,     0,   403,   405,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   269,     0,
      19,   168,     0,     0,     0,     0,     0,    23,     0,     0,
      29,    22,     0,     0,     0,     0,     0,     0,     0,     0,
     435,   436,   437,     0,     0,     0,     0,     0,     0,   439,
     438,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     468,   335,   467,     0,   337,     0,     0,   339,   341,     0,
     343,     0,     0,   345,     0,     0,     0,   306,     0,     0,
       0,     0,     0,     0,    18,   424,    58,     0,    61,     0,
      63,     0,    79,     0,    77,   104,    93,   104,    93,     0,
     134,     0,   129,   116,    50,   385,     0,   377,   474,     0,
       0,   473,   398,     0,   400,   472,   402,   379,   381,   383,
       0,   371,   369,   370,    16,   414,   408,    17,     0,   177,
       0,   200,     0,   223,     0,   221,     0,     0,     0,     0,
       0,     0,   266,     0,   272,     0,   252,   167,    24,    25,
      26,    28,    27,    30,    35,    20,   308,   309,   310,   311,
     312,   327,   351,   352,   313,   314,   315,   316,   317,   328,
     320,   319,   346,   347,   348,   349,   350,   329,   330,   324,
     326,   325,   353,   354,   355,   321,   322,   323,   333,   334,
     336,   338,   340,   342,   344,   318,   332,   331,     0,     0,
      38,    40,   428,     0,    59,   142,    60,   142,    68,    82,
      67,    82,     0,   107,     0,    96,     0,     0,   132,   137,
     128,   142,     0,   119,   392,   375,   392,   373,   372,   397,
     374,   399,     0,   392,   388,   392,   376,     0,     0,     0,
       0,     0,     0,     0,   415,   410,     0,   414,     0,     0,
     408,   176,   180,   199,   203,   212,   226,   211,   226,     0,
     243,     0,   230,     0,     0,   264,   265,   292,   268,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   273,   290,   270,   272,   251,
     255,    33,     0,    35,     0,     0,    39,   431,   426,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      62,   142,     0,    64,    66,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    92,    80,    82,    90,    91,
      78,    72,   109,     0,     0,     0,     0,     0,     0,    47,
     103,   108,   105,   107,   111,   102,    70,    94,    96,    97,
      76,    74,     0,   138,   140,   135,   137,   130,   115,     0,
     125,   120,   127,   117,   119,     0,     0,     0,   392,     0,
     401,     0,     0,     0,   388,   389,     0,   471,     0,     0,
       0,     0,   422,     0,   404,   413,     0,   406,   407,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   178,   180,   181,     0,     0,     0,   201,   203,   204,
     224,   222,   216,   246,   214,   233,   220,   218,   267,   292,
       0,   471,   471,   471,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   271,   253,     0,     0,
      34,    41,    42,     0,     0,     0,     0,   431,   431,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   166,     0,     0,     0,     0,     0,
     141,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    81,     0,     0,     0,     0,     0,     0,     0,
     106,    95,     0,   136,     0,     0,   118,     0,   396,   386,
     391,   378,   380,     0,   382,   387,   384,   471,     0,   469,
       0,     0,     0,     0,     0,   422,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   305,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     179,     0,     0,     0,   202,     0,   229,   225,   228,   227,
     244,   231,   291,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     262,     0,     0,     0,     0,     0,   238,   256,   240,   254,
     239,     0,    32,     0,   396,     0,     0,   430,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   166,     0,     0,     0,     0,
       0,     0,     0,     0,    84,     0,    86,     0,     0,    88,
       0,     0,     0,     0,     0,     0,   357,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   357,     0,
       0,   396,     0,   470,   411,   417,   418,   419,   420,   416,
     421,   412,   409,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   305,     0,     0,     0,     0,   184,     0,   186,
       0,     0,   188,   190,     0,   192,     0,     0,   194,     0,
       0,     0,   206,     0,   208,     0,     0,   210,     0,   248,
     247,   245,     0,   241,   232,   274,   281,   282,   283,   278,
     279,   277,   280,   289,   286,   284,   285,   287,   288,   276,
     275,     0,     0,     0,     0,     0,     0,     0,    31,     0,
       0,     0,   429,     0,   162,   156,   144,   145,   146,   154,
     161,   148,   147,   149,   157,   143,   152,   150,   151,   155,
     165,   158,   153,   160,   159,   164,   163,    65,    89,    83,
      85,    87,   112,   113,    45,    43,    44,    46,     0,     0,
       0,     0,     0,     0,     0,   358,   366,     0,   357,    98,
      99,   100,   101,    48,    49,   139,   122,   123,   124,   121,
       0,   393,   394,   395,   390,   197,   295,   297,   296,   301,
     302,   294,   303,   293,   304,   300,   198,   182,   195,   183,
     185,   187,   189,   191,   193,   298,   299,   196,   205,   207,
     209,     0,     0,     0,     0,     0,     0,     0,   357,     0,
       0,     0,     0,     0,   433,   434,   432,   427,     0,     0,
       0,     0,     0,   471,   471,   110,   356,   126,   250,   357,
       0,   258,   259,   260,   257,     0,   234,   235,   236,   237,
     261,     0,     0,     0,     0,     0,     0,     0,     0,   242,
     263,   359,   360,   361,   362,   363,   364,   365,   249
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    10,    11,   117,    12,    39,    42,    44,    56,    46,
      49,    52,    69,    70,   183,   184,   289,   562,    51,    54,
     115,   350,   351,   619,   620,   132,   133,   134,   135,   357,
     475,   359,   477,   593,   136,   243,   242,   245,   244,   363,
     481,   361,   479,   606,   607,   484,   485,   627,   628,   621,
     482,   483,   622,   623,   773,   608,   137,   248,   492,   493,
     643,   644,   785,   138,   371,   491,   139,   369,   489,   635,
     636,   590,   625,   894,   168,   169,   170,   398,   522,   691,
     692,   171,   400,   524,   697,   698,   172,   273,   272,   275,
     274,   404,   528,   402,   526,   700,   837,   531,   705,   841,
     867,   984,   529,   703,   840,   981,  1102,   868,   173,   415,
     560,   727,   869,  1002,   174,   175,   411,   537,   176,   413,
     414,   557,   558,   708,   870,   951,   113,   114,  1057,  1058,
     151,   152,   496,   503,   504,   505,   494,   653,   654,   647,
     648,   930,   380,   383,   384,   155,   395,   396,   519,   520,
     514,   515,   516,   517,   804,   233,   234,   235,   738,   567,
     736,   737,   310,   311,   332,    41,   333,   798,   799,   386,
     382
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -920
static const yytype_int16 yypact[] =
{
      51,  1959,  1959,  1959,  1959,   -91,   -86,  1959,  1959,  1959,
     109,  -920,   -50,  -920,  -920,  -920,  -920,  -920,  -920,  -920,
    -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,
    -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,
     -31,  -920,  -920,   -16,  -920,   -12,  -920,    -7,    22,  -920,
    2067,  -920,  -920,  -920,  -920,  -920,  -920,     6,  -920,  -920,
      60,    46,   -60,   101,     7,    11,    19,    21,    30,   178,
      35,    33,    36,    44,    49,    50,    55,    64,    67,    69,
      70,    73,    74,    75,    80,    87,    88,    89,    93,    94,
      95,   105,   106,   110,   111,   117,   118,   119,   120,   123,
     129,   130,   132,   133,   134,   140,   142,   144,   145,   146,
     147,   148,   149,    54,   112,   160,   -24,    51,   159,   163,
     164,   168,   169,  -920,  -920,  -920,  -920,   170,   171,  -920,
    -920,  -920,   161,   175,  -920,  -920,  -920,  -920,  -920,  -920,
     173,   176,   177,   179,   180,   181,   182,   185,   189,    46,
      46,   -45,  -920,   190,   194,   199,   200,   201,   202,   203,
    -920,  -920,  -920,  -920,   205,   211,   212,   224,   227,   239,
    -920,  -920,  -920,  -920,  -920,  -920,  -920,  1959,  1959,  1959,
    1959,  1959,   240,   250,   178,    22,   208,   248,   249,   253,
     254,   255,  1959,  1959,   -82,   -82,   -82,   -82,  1959,   -82,
     -23,   -82,   -82,   264,   265,   266,  1959,  1959,   268,   269,
     270,   274,  1959,  1959,  1959,   275,   279,   281,   -82,   257,
     424,   -65,   797,   882,   -61,   -82,   282,   283,  -920,  2067,
      26,   284,   285,   277,  -920,   -24,  -920,   286,  1959,  1959,
    1959,  1959,   288,   289,   290,   291,  1959,  1959,   292,  -920,
      60,  1959,  1959,  1959,  1731,  1959,  1959,  1959,  1959,  1959,
    -920,    71,    46,    46,   287,  -920,  -920,   297,  1959,  1959,
    1959,  1959,   300,   301,   307,   310,  1959,  1959,  -920,  1959,
    -920,   101,   296,   311,   316,   318,   319,    22,   321,   312,
    -920,  -920,   322,   323,   324,   325,   326,   327,   328,   329,
    -920,  -920,  -920,   330,   331,   332,   333,   337,   338,  -920,
    -920,   339,   342,   345,   347,   348,   351,   353,   355,   356,
     357,   358,   359,   360,   361,   362,   363,   364,   365,   366,
    -920,  -920,  -920,   367,  -920,   368,   369,  -920,  -920,   372,
    -920,   375,   377,  -920,   379,   390,   391,  -920,   393,   394,
     397,   414,  1959,  1959,  -920,  -920,  -920,   412,  -920,   415,
    -920,   417,  -920,   418,  -920,  -920,  -920,  -920,  -920,   426,
    -920,   428,  -920,  -920,  -920,  -920,   430,  -920,  -920,   431,
     433,  -920,  1808,   434,  1959,  -920,   294,  -920,  -920,  -920,
     435,  -920,   442,  -920,  -920,   197,   465,  -920,   437,  -920,
     438,  -920,   439,  -920,   443,  -920,  1959,  1959,  1959,  1959,
     444,   445,  -920,   446,   280,   447,  -920,  -920,  -920,  -920,
    -920,  -920,  -920,   178,  1959,  -920,  -920,  -920,  -920,  -920,
    -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,
    -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,
    -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,
    -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  1959,   -82,
    -920,    26,  -920,  1959,  -920,  2547,  -920,  2503,  -920,  2299,
    -920,  2299,   448,  2219,   452,  2375,   453,   454,  -920,    15,
    -920,  2547,   455,  2139,    18,  -920,    18,  -920,  -920,  -920,
    -920,  -920,  1959,    18,     9,    18,  -920,   457,   458,   460,
     462,   463,   466,   467,  -920,  -920,   468,   197,   471,   472,
     465,  -920,   276,  -920,  1972,  -920,  -920,  -920,  -920,   473,
    -920,   474,  -920,   475,   478,  -920,  -920,   352,  -920,   480,
     484,   485,   486,   487,   488,   489,   492,   496,   497,   498,
     499,   500,   501,   514,   515,  -920,  -920,  -920,   280,  -920,
    -920,   250,   516,  1959,   517,   520,  -920,    13,  -920,   522,
     523,   524,   525,   526,   527,   528,   529,   530,   532,   533,
     534,   535,   536,   537,   538,   539,   540,   541,   542,   543,
    -920,  2547,   544,  -920,  -920,   545,   546,   547,   548,   549,
     550,   551,   552,   553,   554,  -920,  -920,  2299,  -920,  -920,
    -920,  -920,  -920,   564,   565,   566,   569,   571,   572,  -920,
    -920,  -920,  -920,  2219,  -920,  -920,  -920,  -920,  2375,  -920,
    -920,  -920,   573,  -920,  -920,  -920,    15,  -920,  -920,   574,
    -920,  -920,  -920,  -920,  2139,   575,   576,   577,    18,   578,
    -920,   579,   581,   582,     9,  -920,   584,  1959,  1959,  1959,
    1959,  1959,  1959,  1959,  -920,  -920,  1959,  -920,  -920,   586,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   600,
     602,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,  -920,   276,  -920,   615,   616,   617,  -920,  1972,  -920,
     531,   531,  -920,  -920,  -920,  -920,  -920,  -920,  -920,   352,
    1959,  1959,  1959,  1959,  1959,  1959,  1959,  1959,  1959,   477,
     481,   627,  1959,  1959,  1882,  1959,  -920,   425,   427,   519,
    -920,  -920,  -920,   621,   622,   623,   624,    13,    13,  1959,
     633,   -82,   -82,   -82,   -82,   -82,   -23,   -82,   -82,   635,
     637,  1959,  1959,  1959,  1959,   639,  1959,     2,  1808,  1959,
    -920,   -82,   -82,   959,  1044,   -59,   -82,   640,   -82,   643,
     644,   -82,  -920,   636,  1959,  1959,  1882,  1882,   646,   648,
    -920,  -920,  1959,  -920,  1583,   641,  -920,  1959,  1959,  -920,
    -920,  -920,  -920,  1959,  -920,  -920,  -920,  1959,   642,  -920,
     645,   650,   652,   653,   654,  1959,   655,   657,   -82,   656,
     658,   668,  1959,   669,   673,   674,  1959,  1959,  1959,   -82,
     -82,  1121,  1198,   -57,  1275,  1352,   -53,  1959,   -82,   679,
    -920,  1429,  1506,   -20,  -920,   671,  -920,  -920,  -920,  -920,
    2430,  1708,  -920,   672,   681,   682,   683,   684,   685,   686,
     687,   688,   689,   690,   694,   695,   696,   697,   698,   680,
    -920,   700,   701,   702,   703,   704,  -920,  -920,  -920,  -920,
    -920,   580,  -920,  1959,  1959,  1959,   585,  -920,   705,   706,
     707,   708,   709,   710,   711,   712,   715,   716,   720,   721,
     724,   725,   726,   727,   728,  1959,   729,   730,   731,   733,
     734,   735,   737,   738,  -920,   740,  -920,   741,   742,  -920,
     743,   744,   745,   748,   749,   753,    53,   754,   755,   756,
     757,   758,   766,   768,   776,   777,   778,   779,    53,   780,
     781,  1959,   782,  -920,  -920,  -920,  -920,  -920,  -920,  -920,
    -920,  -920,  -920,   783,   784,   785,   788,   790,   791,   792,
     793,   794,  1959,   795,   800,   801,   802,  -920,   803,  -920,
     804,   805,  -920,  -920,   806,  -920,   810,   811,  -920,   812,
     814,   815,  -920,   816,  -920,   817,   818,  -920,   -82,  -920,
    -920,  -920,   820,  -920,  -920,  -920,  -920,  -920,  -920,  -920,
    -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,
    -920,  1657,   821,  1959,  1882,  1882,  1882,   -82,  -920,   822,
     823,   824,  -920,   647,  -920,  -920,  -920,  -920,  -920,  -920,
    -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,
    -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,
    -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,   826,   827,
     831,   834,   835,   836,   842,  -920,  -920,   843,    53,  -920,
    -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,
     844,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,
    -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,
    -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,
    -920,   846,   849,   -82,   850,   851,   853,   860,    53,   861,
     862,   863,   864,   865,  -920,  -920,  -920,  -920,  1959,  1959,
    1959,  1959,  1959,  1959,  1959,  -920,  -920,  -920,  -920,    53,
     866,  -920,  -920,  -920,  -920,   867,  -920,  -920,  -920,  -920,
    -920,   868,   869,   870,   873,   877,   878,   879,   880,  -920,
    -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -920,  -920,   568,  -920,  -920,  -920,  -920,  -920,  -920,  -920,
    -920,  -920,  -141,  -920,  -179,  -920,  -126,   236,  -920,  -920,
    -920,   388,  -920,  -465,  -697,   786,  -920,  -920,  -920,  -920,
    -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,
    -920,  -920,  -920,  -452,  -920,   670,  -920,   376,  -920,  -462,
     461,  -920,   419,  -920,  -920,  -461,  -920,  -920,  -920,  -920,
     399,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,   340,
    -920,  -398,  -392,   150,   760,  -920,  -920,  -920,  -920,   354,
    -920,  -920,  -920,  -920,   346,  -920,  -920,  -920,  -920,  -920,
    -920,  -920,  -920,  -920,  -920,   555,  -920,   638,  -920,  -920,
    -691,  -920,   649,  -920,  -920,  -920,  -920,  -547,  -920,  -920,
    -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,  -920,
    -920,   490,  -920,   341,  -484,    99,   825,  -920,  -919,  -920,
    -103,  -920,  -920,  -920,  -920,  -920,  -920,   398,  -920,  -460,
    -480,  -826,   676,   675,  -920,  -920,  -920,  -920,   561,  -920,
    -920,  -920,   556,  -920,   251,  -920,   830,  -920,  -920,  -920,
    -574,  -920,  -184,   309,    -1,  -920,  -158,  -692,   263,  -498,
     303
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const yytype_uint16 yytable[] =
{
      40,    43,    45,    47,   650,   290,    53,    55,    57,  1070,
     303,   304,   305,   306,   605,   308,   605,   312,   313,   844,
     845,   846,   624,   629,   655,    64,    65,    66,    67,   610,
     866,   641,   642,   645,   329,   632,   649,   733,   693,   309,
     699,   344,   645,   651,   291,   656,   260,   261,  1010,   140,
     141,   300,   301,   709,     1,     2,     3,     4,     5,     6,
       7,    48,   335,   302,   339,   341,    50,   153,   142,   154,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   594,
     336,   127,   128,   591,   342,   591,   908,   609,   961,   609,
     337,   646,   967,   637,   343,   734,   909,   129,   962,   591,
     646,    59,   968,   262,   263,  1073,   264,   231,   232,    58,
     300,   301,   156,   157,   158,   159,   160,   161,   162,   163,
     164,    60,   302,   165,   166,   976,   348,   349,  1048,  1049,
    1050,  1051,  1052,  1053,  1054,   977,    61,   652,   167,  1126,
      62,   735,   605,   866,   866,    63,   423,   898,   899,   980,
     983,     8,    68,   838,   838,   772,   633,   634,   116,   392,
     393,   177,   624,   877,   878,   178,   629,   143,   144,   145,
     146,   147,   148,   179,   655,   180,   282,   283,   284,   285,
     286,     9,   641,   642,   181,   182,   185,   186,   790,  1135,
     187,   298,   299,   760,  1055,  1056,   149,   307,   188,   591,
     150,   130,   131,   189,   190,   317,   318,   228,   693,   191,
    1148,   323,   324,   325,   699,   609,   839,   839,   192,   262,
     263,   193,   507,   194,   195,   709,   391,   196,   197,   198,
     508,   509,   510,   511,   199,   836,   836,   358,   360,   362,
     364,   200,   201,   202,   561,   370,   372,   203,   204,   205,
     375,   376,   377,   381,   385,   387,   388,   389,   390,   206,
     207,   901,    13,   229,   208,   209,    14,   399,   401,   403,
     405,   210,   211,   212,   213,   410,   412,   214,   416,   512,
      15,    16,    17,   215,   216,   565,   217,   218,   219,    18,
      19,    20,    21,    22,   220,    23,   221,   513,   222,   223,
     224,   225,   226,   227,   539,   540,   541,   542,   543,   544,
     545,   546,   230,   237,   249,   669,   547,   238,   239,   670,
     671,   672,   240,   241,   246,   247,   250,   251,    24,    25,
     252,   253,   288,   254,   255,   256,   257,    26,    27,   258,
     673,   674,   675,   259,   265,   548,   549,   550,   266,   676,
     267,   472,   473,   292,   268,   269,   270,   271,   677,   276,
     678,    28,    29,   679,   551,   277,   278,   552,   680,   681,
     682,   683,   684,   685,   686,   687,   688,   689,   279,   690,
     280,   381,    30,   385,    31,    32,    33,    34,    35,    36,
     281,   553,   287,   293,   294,   670,   671,   672,   295,   296,
     297,    37,   330,   554,    38,   530,   532,   530,   532,   314,
     315,   316,   331,   319,   320,   321,   673,   674,   675,   322,
     326,   555,   556,   563,   327,   676,   328,   345,   346,    13,
     354,  1146,  1147,    14,   677,   728,   678,   502,   352,   353,
     394,   356,   365,   366,   367,   368,   373,    15,    16,    17,
     397,   418,   688,   689,   406,   407,    18,    19,    20,    21,
      22,   408,    23,   859,   409,   425,   419,   564,   670,   671,
     672,   420,   568,   421,   422,   424,   518,   426,   427,   428,
     429,   430,   431,   432,   433,   434,   435,   436,   437,   673,
     674,   675,   438,   439,   440,    24,    25,   441,   676,   860,
     442,   385,   443,   444,    26,    27,   445,   677,   446,   678,
     447,   448,   449,   450,   451,   452,   453,   454,   455,   456,
     457,   458,   459,   460,   461,   688,   689,   462,    28,    29,
     463,   835,   464,   861,   465,   862,   863,   864,   617,   601,
     618,   602,   603,   604,   865,   466,   467,   468,   469,    30,
     470,    31,    32,    33,    34,    35,    36,   881,   882,   883,
     884,   885,   563,   887,   888,   471,   857,   474,    37,   330,
     476,    38,   478,   480,   670,   671,   672,   902,   903,   334,
     871,   488,   910,   490,   912,   495,   497,   915,   498,   500,
     506,   263,   521,   523,   525,   673,   674,   675,   527,   535,
     536,   538,   559,   611,   676,   905,   907,   626,   630,   631,
     638,   657,   658,   677,   659,   678,   660,   661,   919,   920,
     662,   663,   852,   664,   943,   666,   853,   667,   702,   704,
     706,   688,   689,   707,   710,   955,   956,   835,   711,   712,
     713,   714,   715,   716,   970,   601,   717,   602,   603,   604,
     718,   719,   720,   721,   722,   723,   797,   800,   801,   802,
     803,   805,   806,   958,   960,   807,   964,   966,   724,   725,
     872,   729,   731,   973,   975,   732,   739,   740,   741,   742,
     743,   744,   745,   746,   747,   236,   748,   749,   750,   751,
     752,   753,   754,   755,   756,   757,   758,   759,   761,   762,
     763,   764,   765,   766,   767,   768,   769,   770,   771,   843,
     797,   797,   797,   847,   848,   849,   850,   851,   774,   775,
     776,   855,   856,   777,   858,   778,   779,   782,   784,   787,
     788,  1008,   789,   791,   792,   793,  1012,   794,   879,   796,
     808,   809,   810,   811,   812,   813,   814,   815,   816,   817,
     891,   892,   893,   895,   818,   897,   819,   381,   385,   820,
     821,   822,   823,   824,   825,   826,   827,   828,   829,   831,
     832,   833,   854,   917,   918,   873,   874,   875,   880,   876,
     889,   923,   890,   927,   896,   911,   929,   931,   913,   914,
     916,   921,   932,   922,  1101,   928,   797,   934,  1117,   730,
     935,   944,    13,   945,   805,   936,    14,   937,   938,   939,
     941,   947,   942,   946,   948,   952,   953,   954,   949,   950,
      15,    16,    17,  1113,   971,   978,   969,   985,   486,    18,
      19,    20,    21,    22,  1001,    23,   986,   987,   988,   989,
     990,   991,   992,   993,   994,   995,  1110,  1111,  1112,   996,
     997,   998,   999,  1000,  1003,  1004,  1005,  1006,  1007,   566,
    1013,  1014,  1015,  1016,  1017,  1018,  1019,  1020,    24,    25,
    1021,  1022,  1009,   931,  1011,  1023,  1024,    26,    27,  1025,
    1026,  1027,  1028,  1029,  1031,  1032,  1033,    13,  1034,  1035,
    1036,    14,  1037,  1038,   895,  1039,  1040,  1041,  1042,  1043,
    1044,    28,    29,  1045,  1046,    15,    16,    17,  1047,  1059,
    1060,  1061,  1062,  1063,    18,    19,    20,    21,    22,  1130,
      23,  1064,    30,  1065,    31,    32,    33,    34,    35,    36,
     931,  1066,  1067,  1068,  1069,  1071,  1072,  1074,  1075,  1076,
    1077,    37,   330,  1078,    38,  1079,  1080,  1081,  1082,  1083,
    1085,   952,   338,    24,    25,  1086,  1087,  1088,  1089,  1090,
    1091,  1092,    26,    27,    13,  1093,  1094,  1095,    14,  1096,
    1097,  1098,  1099,  1100,  1103,  1108,   783,  1114,  1115,  1116,
    1118,  1119,    15,    16,    17,  1120,    28,    29,  1121,  1122,
    1123,    18,    19,    20,    21,    22,  1124,    23,  1125,  1127,
    1107,  1128,  1109,  1129,   781,  1131,  1132,    30,  1133,    31,
      32,    33,    34,    35,    36,  1134,  1136,  1137,  1138,  1139,
    1140,  1149,  1150,  1151,  1152,  1153,    37,   330,  1154,    38,
      24,    25,  1155,  1156,  1157,  1158,   374,   340,   487,    26,
      27,   417,   780,   786,   834,  1030,   830,   534,   726,    13,
     842,  1084,   795,    14,   347,   886,   940,   533,   499,   501,
     933,   900,     0,    28,    29,   355,     0,    15,    16,    17,
       0,     0,     0,   665,     0,     0,    18,    19,    20,    21,
      22,   668,    23,   701,    30,     0,    31,    32,    33,    34,
      35,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,   330,     0,    38,     0,     0,     0,
       0,     0,     0,     0,   904,    24,    25,  1141,  1142,  1143,
    1144,  1145,   797,   797,    26,    27,    13,     0,     0,     0,
      14,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    15,    16,    17,     0,    28,    29,
       0,     0,     0,    18,    19,    20,    21,    22,     0,    23,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    30,
       0,    31,    32,    33,    34,    35,    36,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    37,   330,
       0,    38,    24,    25,     0,     0,     0,     0,     0,   906,
       0,    26,    27,    13,     0,     0,     0,    14,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    15,    16,    17,     0,    28,    29,     0,     0,     0,
      18,    19,    20,    21,    22,     0,    23,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    30,     0,    31,    32,
      33,    34,    35,    36,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,   330,     0,    38,    24,
      25,     0,     0,     0,     0,     0,   957,     0,    26,    27,
      13,     0,     0,     0,    14,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    15,    16,
      17,     0,    28,    29,     0,     0,     0,    18,    19,    20,
      21,    22,     0,    23,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    30,     0,    31,    32,    33,    34,    35,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,   330,     0,    38,    24,    25,     0,     0,
       0,     0,     0,   959,     0,    26,    27,    13,     0,     0,
       0,    14,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    15,    16,    17,     0,    28,
      29,     0,     0,     0,    18,    19,    20,    21,    22,     0,
      23,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      30,     0,    31,    32,    33,    34,    35,    36,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    37,
     330,     0,    38,    24,    25,     0,     0,     0,     0,     0,
     963,     0,    26,    27,    13,     0,     0,     0,    14,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    15,    16,    17,     0,    28,    29,     0,     0,
       0,    18,    19,    20,    21,    22,     0,    23,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,    31,
      32,    33,    34,    35,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    37,   330,     0,    38,
      24,    25,     0,     0,     0,     0,     0,   965,     0,    26,
      27,    13,     0,     0,     0,    14,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    15,
      16,    17,     0,    28,    29,     0,     0,     0,    18,    19,
      20,    21,    22,     0,    23,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    30,     0,    31,    32,    33,    34,
      35,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,   330,     0,    38,    24,    25,     0,
       0,     0,     0,     0,   972,     0,    26,    27,    13,     0,
       0,     0,    14,     0,     0,     0,     0,     0,   924,   925,
       0,     0,     0,     0,     0,     0,    15,    16,    17,     0,
      28,    29,     0,     0,     0,    18,    19,    20,    21,    22,
       0,    23,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    30,     0,    31,    32,    33,    34,    35,    36,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      37,   330,     0,    38,    24,    25,     0,   926,     0,     0,
       0,   974,    13,    26,    27,     0,    14,     0,     0,     0,
       0,     0,  1104,  1105,     0,     0,     0,     0,     0,     0,
      15,    16,    17,     0,     0,     0,     0,    28,    29,    18,
      19,    20,    21,    22,     0,    23,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    30,     0,
      31,    32,    33,    34,    35,    36,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    37,    24,    25,
      38,  1106,     0,     0,     0,     0,    13,    26,    27,     0,
      14,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   670,   671,   672,    15,    16,    17,     0,     0,     0,
       0,    28,    29,    18,    19,    20,    21,    22,   378,    23,
       0,     0,   673,   674,   675,     0,     0,     0,     0,     0,
       0,   676,    30,     0,    31,    32,    33,    34,    35,    36,
     677,     0,   678,     0,     0,     0,     0,     0,     0,     0,
       0,    37,    24,    25,    38,     0,     0,     0,   688,   689,
       0,    26,    27,    13,   835,     0,   861,    14,   862,   863,
     864,   617,   601,   618,   602,   603,   604,   982,     0,     0,
       0,    15,    16,    17,     0,    28,    29,     0,     0,     0,
      18,    19,    20,    21,    22,   378,    23,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    30,     0,    31,    32,
      33,    34,    35,    36,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,   379,     0,    38,    24,
      25,     0,     0,     0,     0,     0,     0,    13,    26,    27,
       0,    14,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    15,    16,    17,     0,     0,
       0,     0,    28,    29,    18,    19,    20,    21,    22,     0,
      23,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    30,     0,    31,    32,    33,    34,    35,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    37,    24,    25,    38,     0,     0,     0,     0,
       0,     0,    26,    27,    13,     0,     0,     0,    14,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    15,    16,    17,     0,    28,    29,     0,     0,
       0,    18,    19,    20,    21,    22,     0,    23,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    30,     0,    31,
      32,    33,    34,    35,    36,   670,   671,   672,     0,     0,
       0,     0,     0,     0,     0,     0,    37,   330,     0,    38,
      24,    25,     0,     0,     0,     0,   673,   674,   675,    26,
      27,     0,     0,     0,     0,   676,     0,     0,     0,     0,
       0,     0,     0,     0,   677,     0,   678,     0,     0,     0,
       0,     0,     0,    28,    29,     0,   694,   695,   696,     0,
       0,     0,   688,   689,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    30,     0,    31,    32,    33,    34,
      35,    36,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    37,     0,     0,    38,    71,    72,    73,
      74,     0,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,     0,
       0,    92,    93,    94,     0,    95,    96,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    97,    98,    99,   100,   101,   102,     0,     0,
     103,   104,   105,   106,   107,   108,   109,     0,     0,     0,
       0,   569,     0,     0,     0,     0,     0,   639,     0,     0,
       0,     0,     0,     0,     0,   570,     0,   110,   571,   572,
     573,   574,     0,   575,   576,   577,   578,     0,     0,     0,
       0,     0,   111,   112,     0,     0,     0,   579,   580,   581,
     582,   583,     0,   640,     0,     0,     0,     0,     0,     0,
       0,   584,   585,   586,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   587,     0,   588,   589,   599,   600,   613,   614,   615,
     616,   569,   617,   601,   618,   602,   603,   604,     0,     0,
       0,     0,     0,     0,     0,   570,     0,     0,   571,   572,
     573,   574,     0,   575,   576,   577,   578,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   579,   580,   581,
     582,   583,     0,   612,     0,     0,     0,     0,     0,     0,
       0,   584,   585,   586,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   587,     0,   588,   589,   599,   600,   613,   614,   615,
     616,   569,   617,   601,   618,   602,   603,   604,     0,     0,
       0,     0,     0,     0,     0,   570,     0,     0,   571,   572,
     573,   574,     0,   575,   576,   577,   578,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   579,   580,   581,
     582,   583,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   584,   585,   586,     0,     0,     0,     0,     0,     0,
       0,   595,     0,   596,   597,   598,     0,     0,     0,     0,
       0,   587,     0,   588,   589,   599,   600,   569,     0,     0,
       0,     0,     0,   601,     0,   602,   603,   604,     0,     0,
       0,   570,     0,     0,   571,   572,   573,   574,     0,   575,
     576,   577,   578,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   579,   580,   581,   582,   583,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   584,   585,   586,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   670,   671,   672,     0,   587,     0,   588,
     589,     0,     0,   613,   614,   615,   616,     0,   617,   601,
     618,   602,   603,   604,   673,   674,   675,     0,     0,     0,
       0,     0,     0,   676,   979,     0,     0,     0,     0,     0,
       0,     0,   677,     0,   678,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     688,   689,     0,     0,     0,   569,   835,     0,   861,     0,
     862,   863,   864,   617,   601,   618,   602,   603,   604,   570,
       0,     0,   571,   572,   573,   574,     0,   575,   576,   577,
     578,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   579,   580,   581,   582,   583,     0,     0,     0,   569,
       0,     0,     0,     0,     0,   584,   585,   586,     0,     0,
       0,     0,     0,   570,     0,   592,   571,   572,   573,   574,
       0,   575,   576,   577,   578,   587,     0,   588,   589,     0,
       0,     0,     0,     0,     0,   579,   580,   581,   582,   583,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   584,
     585,   586,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   587,
       0,   588,   589
};

static const yytype_int16 yycheck[] =
{
       1,     2,     3,     4,   502,   184,     7,     8,     9,   928,
     194,   195,   196,   197,   479,   199,   481,   201,   202,   711,
     712,   713,   483,   485,   504,     3,     4,     5,     6,   481,
     727,   493,   493,    24,   218,    20,   496,    24,   522,    62,
     524,   225,    24,   503,   185,   505,   149,   150,   874,     3,
       4,   133,   134,   537,     3,     4,     5,     6,     7,     8,
       9,   152,   220,   145,   222,   223,   152,   127,    22,   129,
      10,    11,    12,    13,    14,    15,    16,    17,    18,   477,
     145,    21,    22,   475,   145,   477,   145,   479,   145,   481,
     155,    82,   145,   491,   155,    82,   155,    37,   155,   491,
      82,   151,   155,   148,   149,   931,   151,   131,   132,     0,
     133,   134,    11,    12,    13,    14,    15,    16,    17,    18,
      19,   152,   145,    22,    23,   145,   100,   101,    75,    76,
      77,    78,    79,    80,    81,   155,   152,   128,    37,  1058,
     152,   128,   607,   840,   841,   152,   287,   145,   146,   840,
     841,   100,   130,   700,   701,   607,   141,   142,   152,   262,
     263,   154,   623,   737,   738,   154,   628,   121,   122,   123,
     124,   125,   126,   154,   654,   154,   177,   178,   179,   180,
     181,   130,   644,   644,   154,     7,   151,   154,   648,  1108,
     154,   192,   193,   591,   141,   142,   150,   198,   154,   591,
     154,   141,   142,   154,   154,   206,   207,   153,   692,   154,
    1129,   212,   213,   214,   698,   607,   700,   701,   154,   148,
     149,   154,    25,   154,   154,   709,   155,   154,   154,   154,
      33,    34,    35,    36,   154,   700,   701,   238,   239,   240,
     241,   154,   154,   154,   423,   246,   247,   154,   154,   154,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   154,
     154,   759,     5,   151,   154,   154,     9,   268,   269,   270,
     271,   154,   154,   154,   154,   276,   277,   154,   279,    82,
      23,    24,    25,   154,   154,   469,   154,   154,   154,    32,
      33,    34,    35,    36,   154,    38,   154,   100,   154,   154,
     154,   154,   154,   154,    24,    25,    26,    27,    28,    29,
      30,    31,   152,   154,   153,    39,    36,   154,   154,    43,
      44,    45,   154,   154,   154,   154,   151,   154,    71,    72,
     154,   154,    82,   154,   154,   154,   154,    80,    81,   154,
      64,    65,    66,   154,   154,    65,    66,    67,   154,    73,
     151,   352,   353,   145,   154,   154,   154,   154,    82,   154,
      84,   104,   105,    87,    84,   154,   154,    87,    92,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   154,   103,
     153,   382,   125,   384,   127,   128,   129,   130,   131,   132,
     151,   111,   152,   145,   145,    43,    44,    45,   145,   145,
     145,   144,   145,   123,   147,   406,   407,   408,   409,   145,
     145,   145,   155,   145,   145,   145,    64,    65,    66,   145,
     145,   141,   142,   424,   145,    73,   145,   145,   145,     5,
     153,  1123,  1124,     9,    82,   561,    84,   143,   154,   154,
     153,   155,   154,   154,   154,   154,   154,    23,    24,    25,
     153,   155,   100,   101,   154,   154,    32,    33,    34,    35,
      36,   154,    38,    38,   154,   153,   155,   468,    43,    44,
      45,   155,   473,   155,   155,   154,    11,   155,   155,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   155,    64,
      65,    66,   155,   155,   155,    71,    72,   155,    73,    74,
     155,   502,   155,   155,    80,    81,   155,    82,   155,    84,
     155,   155,   155,   155,   155,   155,   155,   155,   155,   155,
     155,   155,   155,   155,   155,   100,   101,   155,   104,   105,
     155,   106,   155,   108,   155,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   155,   155,   154,   154,   125,
     153,   127,   128,   129,   130,   131,   132,   741,   742,   743,
     744,   745,   563,   747,   748,   151,   724,   155,   144,   145,
     155,   147,   155,   155,    43,    44,    45,   761,   762,   155,
     153,   155,   766,   155,   768,   155,   155,   771,   155,   155,
     155,   149,   155,   155,   155,    64,    65,    66,   155,   155,
     155,   155,   155,   155,    73,   763,   764,   155,   155,   155,
     155,   154,   154,    82,   154,    84,   154,   154,   776,   777,
     154,   154,   145,   155,   808,   154,   145,   155,   155,   155,
     155,   100,   101,   155,   154,   819,   820,   106,   154,   154,
     154,   154,   154,   154,   828,   114,   154,   116,   117,   118,
     154,   154,   154,   154,   154,   154,   657,   658,   659,   660,
     661,   662,   663,   821,   822,   666,   824,   825,   154,   154,
     151,   155,   155,   831,   832,   155,   154,   154,   154,   154,
     154,   154,   154,   154,   154,   117,   154,   154,   154,   154,
     154,   154,   154,   154,   154,   154,   154,   154,   154,   154,
     154,   154,   154,   154,   154,   154,   154,   154,   154,   710,
     711,   712,   713,   714,   715,   716,   717,   718,   154,   154,
     154,   722,   723,   154,   725,   154,   154,   154,   154,   154,
     154,   151,   155,   155,   155,   154,   151,   155,   739,   155,
     154,   154,   154,   154,   154,   154,   154,   154,   154,   154,
     751,   752,   753,   754,   154,   756,   154,   758,   759,   154,
     154,   154,   154,   154,   154,   154,   154,   154,   154,   154,
     154,   154,   145,   774,   775,   154,   154,   154,   145,   155,
     145,   782,   145,   784,   145,   145,   787,   788,   145,   145,
     154,   145,   793,   145,   978,   154,   797,   155,   151,   563,
     155,   145,     5,   145,   805,   155,     9,   155,   155,   155,
     155,   812,   155,   145,   145,   816,   817,   818,   145,   145,
      23,    24,    25,  1007,   145,   154,   827,   155,   367,    32,
      33,    34,    35,    36,   154,    38,   155,   155,   155,   155,
     155,   155,   155,   155,   155,   155,  1004,  1005,  1006,   155,
     155,   155,   155,   155,   154,   154,   154,   154,   154,   471,
     155,   155,   155,   155,   155,   155,   155,   155,    71,    72,
     155,   155,   873,   874,   875,   155,   155,    80,    81,   155,
     155,   155,   155,   155,   155,   155,   155,     5,   155,   155,
     155,     9,   155,   155,   895,   155,   155,   155,   155,   155,
     155,   104,   105,   155,   155,    23,    24,    25,   155,   155,
     155,   155,   155,   155,    32,    33,    34,    35,    36,  1103,
      38,   155,   125,   155,   127,   128,   129,   130,   131,   132,
     931,   155,   155,   155,   155,   155,   155,   155,   155,   155,
     155,   144,   145,   155,   147,   155,   155,   155,   155,   155,
     155,   952,   155,    71,    72,   155,   155,   155,   155,   155,
     155,   155,    80,    81,     5,   155,   155,   155,     9,   155,
     155,   155,   155,   155,   154,   154,   636,   155,   155,   155,
     154,   154,    23,    24,    25,   154,   104,   105,   154,   154,
     154,    32,    33,    34,    35,    36,   154,    38,   155,   155,
    1001,   155,  1003,   154,   628,   155,   155,   125,   155,   127,
     128,   129,   130,   131,   132,   155,   155,   155,   155,   155,
     155,   155,   155,   155,   155,   155,   144,   145,   155,   147,
      71,    72,   155,   155,   155,   155,   250,   155,   368,    80,
      81,   281,   623,   644,   698,   895,   692,   409,   558,     5,
     709,   952,   654,     9,   229,   746,   805,   408,   382,   384,
     797,   758,    -1,   104,   105,   235,    -1,    23,    24,    25,
      -1,    -1,    -1,   517,    -1,    -1,    32,    33,    34,    35,
      36,   520,    38,   528,   125,    -1,   127,   128,   129,   130,
     131,   132,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   144,   145,    -1,   147,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   155,    71,    72,  1118,  1119,  1120,
    1121,  1122,  1123,  1124,    80,    81,     5,    -1,    -1,    -1,
       9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    23,    24,    25,    -1,   104,   105,
      -1,    -1,    -1,    32,    33,    34,    35,    36,    -1,    38,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   125,
      -1,   127,   128,   129,   130,   131,   132,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   144,   145,
      -1,   147,    71,    72,    -1,    -1,    -1,    -1,    -1,   155,
      -1,    80,    81,     5,    -1,    -1,    -1,     9,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    23,    24,    25,    -1,   104,   105,    -1,    -1,    -1,
      32,    33,    34,    35,    36,    -1,    38,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   125,    -1,   127,   128,
     129,   130,   131,   132,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   144,   145,    -1,   147,    71,
      72,    -1,    -1,    -1,    -1,    -1,   155,    -1,    80,    81,
       5,    -1,    -1,    -1,     9,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    23,    24,
      25,    -1,   104,   105,    -1,    -1,    -1,    32,    33,    34,
      35,    36,    -1,    38,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   125,    -1,   127,   128,   129,   130,   131,
     132,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   144,   145,    -1,   147,    71,    72,    -1,    -1,
      -1,    -1,    -1,   155,    -1,    80,    81,     5,    -1,    -1,
      -1,     9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,   104,
     105,    -1,    -1,    -1,    32,    33,    34,    35,    36,    -1,
      38,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     125,    -1,   127,   128,   129,   130,   131,   132,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   144,
     145,    -1,   147,    71,    72,    -1,    -1,    -1,    -1,    -1,
     155,    -1,    80,    81,     5,    -1,    -1,    -1,     9,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,   104,   105,    -1,    -1,
      -1,    32,    33,    34,    35,    36,    -1,    38,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   125,    -1,   127,
     128,   129,   130,   131,   132,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   144,   145,    -1,   147,
      71,    72,    -1,    -1,    -1,    -1,    -1,   155,    -1,    80,
      81,     5,    -1,    -1,    -1,     9,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    23,
      24,    25,    -1,   104,   105,    -1,    -1,    -1,    32,    33,
      34,    35,    36,    -1,    38,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   125,    -1,   127,   128,   129,   130,
     131,   132,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   144,   145,    -1,   147,    71,    72,    -1,
      -1,    -1,    -1,    -1,   155,    -1,    80,    81,     5,    -1,
      -1,    -1,     9,    -1,    -1,    -1,    -1,    -1,    15,    16,
      -1,    -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,
     104,   105,    -1,    -1,    -1,    32,    33,    34,    35,    36,
      -1,    38,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   125,    -1,   127,   128,   129,   130,   131,   132,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     144,   145,    -1,   147,    71,    72,    -1,    74,    -1,    -1,
      -1,   155,     5,    80,    81,    -1,     9,    -1,    -1,    -1,
      -1,    -1,    15,    16,    -1,    -1,    -1,    -1,    -1,    -1,
      23,    24,    25,    -1,    -1,    -1,    -1,   104,   105,    32,
      33,    34,    35,    36,    -1,    38,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   125,    -1,
     127,   128,   129,   130,   131,   132,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   144,    71,    72,
     147,    74,    -1,    -1,    -1,    -1,     5,    80,    81,    -1,
       9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    43,    44,    45,    23,    24,    25,    -1,    -1,    -1,
      -1,   104,   105,    32,    33,    34,    35,    36,    37,    38,
      -1,    -1,    64,    65,    66,    -1,    -1,    -1,    -1,    -1,
      -1,    73,   125,    -1,   127,   128,   129,   130,   131,   132,
      82,    -1,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   144,    71,    72,   147,    -1,    -1,    -1,   100,   101,
      -1,    80,    81,     5,   106,    -1,   108,     9,   110,   111,
     112,   113,   114,   115,   116,   117,   118,   119,    -1,    -1,
      -1,    23,    24,    25,    -1,   104,   105,    -1,    -1,    -1,
      32,    33,    34,    35,    36,    37,    38,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   125,    -1,   127,   128,
     129,   130,   131,   132,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   144,   145,    -1,   147,    71,
      72,    -1,    -1,    -1,    -1,    -1,    -1,     5,    80,    81,
      -1,     9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    23,    24,    25,    -1,    -1,
      -1,    -1,   104,   105,    32,    33,    34,    35,    36,    -1,
      38,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   125,    -1,   127,   128,   129,   130,   131,
     132,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   144,    71,    72,   147,    -1,    -1,    -1,    -1,
      -1,    -1,    80,    81,     5,    -1,    -1,    -1,     9,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    23,    24,    25,    -1,   104,   105,    -1,    -1,
      -1,    32,    33,    34,    35,    36,    -1,    38,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   125,    -1,   127,
     128,   129,   130,   131,   132,    43,    44,    45,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   144,   145,    -1,   147,
      71,    72,    -1,    -1,    -1,    -1,    64,    65,    66,    80,
      81,    -1,    -1,    -1,    -1,    73,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    82,    -1,    84,    -1,    -1,    -1,
      -1,    -1,    -1,   104,   105,    -1,    94,    95,    96,    -1,
      -1,    -1,   100,   101,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   125,    -1,   127,   128,   129,   130,
     131,   132,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   144,    -1,    -1,   147,    40,    41,    42,
      43,    -1,    45,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    -1,
      -1,    64,    65,    66,    -1,    68,    69,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    85,    86,    87,    88,    89,    90,    -1,    -1,
      93,    94,    95,    96,    97,    98,    99,    -1,    -1,    -1,
      -1,    32,    -1,    -1,    -1,    -1,    -1,    38,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,   120,    49,    50,
      51,    52,    -1,    54,    55,    56,    57,    -1,    -1,    -1,
      -1,    -1,   135,   136,    -1,    -1,    -1,    68,    69,    70,
      71,    72,    -1,    74,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   102,    -1,   104,   105,   106,   107,   108,   109,   110,
     111,    32,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    -1,    54,    55,    56,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    70,
      71,    72,    -1,    74,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   102,    -1,   104,   105,   106,   107,   108,   109,   110,
     111,    32,   113,   114,   115,   116,   117,   118,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      51,    52,    -1,    54,    55,    56,    57,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    70,
      71,    72,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    82,    83,    84,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    92,    -1,    94,    95,    96,    -1,    -1,    -1,    -1,
      -1,   102,    -1,   104,   105,   106,   107,    32,    -1,    -1,
      -1,    -1,    -1,   114,    -1,   116,   117,   118,    -1,    -1,
      -1,    46,    -1,    -1,    49,    50,    51,    52,    -1,    54,
      55,    56,    57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    68,    69,    70,    71,    72,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    82,    83,    84,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    43,    44,    45,    -1,   102,    -1,   104,
     105,    -1,    -1,   108,   109,   110,   111,    -1,   113,   114,
     115,   116,   117,   118,    64,    65,    66,    -1,    -1,    -1,
      -1,    -1,    -1,    73,    74,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    82,    -1,    84,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     100,   101,    -1,    -1,    -1,    32,   106,    -1,   108,    -1,
     110,   111,   112,   113,   114,   115,   116,   117,   118,    46,
      -1,    -1,    49,    50,    51,    52,    -1,    54,    55,    56,
      57,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    68,    69,    70,    71,    72,    -1,    -1,    -1,    32,
      -1,    -1,    -1,    -1,    -1,    82,    83,    84,    -1,    -1,
      -1,    -1,    -1,    46,    -1,    92,    49,    50,    51,    52,
      -1,    54,    55,    56,    57,   102,    -1,   104,   105,    -1,
      -1,    -1,    -1,    -1,    -1,    68,    69,    70,    71,    72,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    82,
      83,    84,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,
      -1,   104,   105
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint16 yystos[] =
{
       0,     3,     4,     5,     6,     7,     8,     9,   100,   130,
     157,   158,   160,     5,     9,    23,    24,    25,    32,    33,
      34,    35,    36,    38,    71,    72,    80,    81,   104,   105,
     125,   127,   128,   129,   130,   131,   132,   144,   147,   161,
     320,   321,   162,   320,   163,   320,   165,   320,   152,   166,
     152,   174,   167,   320,   175,   320,   164,   320,     0,   151,
     152,   152,   152,   152,     3,     4,     5,     6,   130,   168,
     169,    40,    41,    42,    43,    45,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    64,    65,    66,    68,    69,    85,    86,    87,
      88,    89,    90,    93,    94,    95,    96,    97,    98,    99,
     120,   135,   136,   282,   283,   176,   152,   159,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    21,    22,    37,
     141,   142,   181,   182,   183,   184,   190,   212,   219,   222,
       3,     4,    22,   121,   122,   123,   124,   125,   126,   150,
     154,   286,   287,   127,   129,   301,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    22,    23,    37,   230,   231,
     232,   237,   242,   264,   270,   271,   274,   154,   154,   154,
     154,   154,     7,   170,   171,   151,   154,   154,   154,   154,
     154,   154,   154,   154,   154,   154,   154,   154,   154,   154,
     154,   154,   154,   154,   154,   154,   154,   154,   154,   154,
     154,   154,   154,   154,   154,   154,   154,   154,   154,   154,
     154,   154,   154,   154,   154,   154,   154,   154,   153,   151,
     152,   131,   132,   311,   312,   313,   158,   154,   154,   154,
     154,   154,   192,   191,   194,   193,   154,   154,   213,   153,
     151,   154,   154,   154,   154,   154,   154,   154,   154,   154,
     286,   286,   148,   149,   151,   154,   154,   151,   154,   154,
     154,   154,   244,   243,   246,   245,   154,   154,   154,   154,
     153,   151,   320,   320,   320,   320,   320,   152,    82,   172,
     170,   168,   145,   145,   145,   145,   145,   145,   320,   320,
     133,   134,   145,   318,   318,   318,   318,   320,   318,    62,
     318,   319,   318,   318,   145,   145,   145,   320,   320,   145,
     145,   145,   145,   320,   320,   320,   145,   145,   145,   318,
     145,   155,   320,   322,   155,   322,   145,   155,   155,   322,
     155,   322,   145,   155,   318,   145,   145,   282,   100,   101,
     177,   178,   154,   154,   153,   312,   155,   185,   320,   187,
     320,   197,   320,   195,   320,   154,   154,   154,   154,   223,
     320,   220,   320,   154,   181,   320,   320,   320,    37,   145,
     298,   320,   326,   299,   300,   320,   325,   320,   320,   320,
     320,   155,   286,   286,   153,   302,   303,   153,   233,   320,
     238,   320,   249,   320,   247,   320,   154,   154,   154,   154,
     320,   272,   320,   275,   276,   265,   320,   230,   155,   155,
     155,   155,   155,   168,   154,   153,   155,   155,   155,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   155,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   155,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   155,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   154,   154,
     153,   151,   320,   320,   155,   186,   155,   188,   155,   198,
     155,   196,   206,   207,   201,   202,   206,   201,   155,   224,
     155,   221,   214,   215,   292,   155,   288,   155,   155,   298,
     155,   299,   143,   289,   290,   291,   155,    25,    33,    34,
      35,    36,    82,   100,   306,   307,   308,   309,    11,   304,
     305,   155,   234,   155,   239,   155,   250,   155,   248,   258,
     320,   253,   320,   258,   253,   155,   155,   273,   155,    24,
      25,    26,    27,    28,    29,    30,    31,    36,    65,    66,
      67,    84,    87,   111,   123,   141,   142,   277,   278,   155,
     266,   170,   173,   320,   320,   318,   177,   315,   320,    32,
      46,    49,    50,    51,    52,    54,    55,    56,    57,    68,
      69,    70,    71,    72,    82,    83,    84,   102,   104,   105,
     227,   228,    92,   189,   227,    92,    94,    95,    96,   106,
     107,   114,   116,   117,   118,   179,   199,   200,   211,   228,
     199,   155,    74,   108,   109,   110,   111,   113,   115,   179,
     180,   205,   208,   209,   211,   228,   155,   203,   204,   205,
     155,   155,    20,   141,   142,   225,   226,   227,   155,    38,
      74,   205,   211,   216,   217,    24,    82,   295,   296,   295,
     325,   295,   128,   293,   294,   296,   295,   154,   154,   154,
     154,   154,   154,   154,   155,   308,   154,   155,   304,    39,
      43,    44,    45,    64,    65,    66,    73,    82,    84,    87,
      92,    93,    94,    95,    96,    97,    98,    99,   100,   101,
     103,   235,   236,   280,    94,    95,    96,   240,   241,   280,
     251,   251,   155,   259,   155,   254,   155,   155,   279,   280,
     154,   154,   154,   154,   154,   154,   154,   154,   154,   154,
     154,   154,   154,   154,   154,   154,   277,   267,   172,   155,
     173,   155,   155,    24,    82,   128,   316,   317,   314,   154,
     154,   154,   154,   154,   154,   154,   154,   154,   154,   154,
     154,   154,   154,   154,   154,   154,   154,   154,   154,   154,
     227,   154,   154,   154,   154,   154,   154,   154,   154,   154,
     154,   154,   199,   210,   154,   154,   154,   154,   154,   154,
     208,   203,   154,   225,   154,   218,   216,   154,   154,   155,
     295,   155,   155,   154,   155,   293,   155,   320,   323,   324,
     320,   320,   320,   320,   310,   320,   320,   320,   154,   154,
     154,   154,   154,   154,   154,   154,   154,   154,   154,   154,
     154,   154,   154,   154,   154,   154,   154,   154,   154,   154,
     235,   154,   154,   154,   240,   106,   179,   252,   263,   280,
     260,   255,   279,   320,   323,   323,   323,   320,   320,   320,
     320,   320,   145,   145,   145,   320,   320,   322,   320,    38,
      74,   108,   110,   111,   112,   119,   180,   256,   263,   268,
     280,   153,   151,   154,   154,   154,   155,   316,   316,   320,
     145,   318,   318,   318,   318,   318,   319,   318,   318,   145,
     145,   320,   320,   320,   229,   320,   145,   320,   145,   146,
     326,   325,   318,   318,   155,   322,   155,   322,   145,   155,
     318,   145,   318,   145,   145,   318,   154,   320,   320,   322,
     322,   145,   145,   320,    15,    16,    74,   320,   154,   320,
     297,   320,   320,   324,   155,   155,   155,   155,   155,   155,
     310,   155,   155,   318,   145,   145,   145,   320,   145,   145,
     145,   281,   320,   320,   320,   318,   318,   155,   322,   155,
     322,   145,   155,   155,   322,   155,   322,   145,   155,   320,
     318,   145,   155,   322,   155,   322,   145,   155,   154,    74,
     256,   261,   119,   256,   257,   155,   155,   155,   155,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   155,   155,
     155,   154,   269,   154,   154,   154,   154,   154,   151,   320,
     297,   320,   151,   155,   155,   155,   155,   155,   155,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   155,   155,
     229,   155,   155,   155,   155,   155,   155,   155,   155,   155,
     155,   155,   155,   155,   155,   155,   155,   155,    75,    76,
      77,    78,    79,    80,    81,   141,   142,   284,   285,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   155,   155,
     284,   155,   155,   297,   155,   155,   155,   155,   155,   155,
     155,   155,   155,   155,   281,   155,   155,   155,   155,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   155,   155,
     155,   318,   262,   154,    15,    16,    74,   320,   154,   320,
     322,   322,   322,   318,   155,   155,   155,   151,   154,   154,
     154,   154,   154,   154,   154,   155,   284,   155,   155,   154,
     318,   155,   155,   155,   155,   284,   155,   155,   155,   155,
     155,   320,   320,   320,   320,   320,   323,   323,   284,   155,
     155,   155,   155,   155,   155,   155,   155,   155,   155
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
#else
static void
yy_stack_print (yybottom, yytop)
    yytype_int16 *yybottom;
    yytype_int16 *yytop;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}

/* Prevent warnings from -Wmissing-prototypes.  */
#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */


/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*-------------------------.
| yyparse or yypush_parse.  |
`-------------------------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{


    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       `yyss': related to states.
       `yyvs': related to semantic values.

       Refer to the stacks thru separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yytoken = 0;
  yyss = yyssa;
  yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */
  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss_alloc, yyss);
	YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 3:

/* Line 1455 of yacc.c  */
#line 322 "cfg-grammar.y"
    { 
            if (last_include_file && !cfg_lex_process_include(last_include_file)) 
              { 
                free(last_include_file);
                last_include_file = NULL;
                YYERROR; 
              } 
            if (last_include_file)
              {
                free(last_include_file);
                last_include_file = NULL;
              }
          }
    break;

  case 6:

/* Line 1455 of yacc.c  */
#line 340 "cfg-grammar.y"
    { cfg_add_source(configuration, (yyvsp[(2) - (2)].ptr)); }
    break;

  case 7:

/* Line 1455 of yacc.c  */
#line 341 "cfg-grammar.y"
    { cfg_add_dest(configuration, (yyvsp[(2) - (2)].ptr)); }
    break;

  case 8:

/* Line 1455 of yacc.c  */
#line 342 "cfg-grammar.y"
    { cfg_add_connection(configuration, (yyvsp[(2) - (2)].ptr)); }
    break;

  case 9:

/* Line 1455 of yacc.c  */
#line 343 "cfg-grammar.y"
    { cfg_add_filter(configuration, (yyvsp[(2) - (2)].ptr)); }
    break;

  case 10:

/* Line 1455 of yacc.c  */
#line 344 "cfg-grammar.y"
    { cfg_add_parser(configuration, (yyvsp[(2) - (2)].ptr)); }
    break;

  case 11:

/* Line 1455 of yacc.c  */
#line 345 "cfg-grammar.y"
    { cfg_add_rewrite(configuration, (yyvsp[(2) - (2)].ptr)); }
    break;

  case 12:

/* Line 1455 of yacc.c  */
#line 346 "cfg-grammar.y"
    { cfg_add_template(configuration, (yyvsp[(2) - (2)].ptr)); }
    break;

  case 13:

/* Line 1455 of yacc.c  */
#line 347 "cfg-grammar.y"
    {  }
    break;

  case 14:

/* Line 1455 of yacc.c  */
#line 348 "cfg-grammar.y"
    {  }
    break;

  case 15:

/* Line 1455 of yacc.c  */
#line 352 "cfg-grammar.y"
    { (yyval.ptr) = log_source_group_new((yyvsp[(1) - (4)].cptr), (yyvsp[(3) - (4)].ptr)); free((yyvsp[(1) - (4)].cptr)); }
    break;

  case 16:

/* Line 1455 of yacc.c  */
#line 356 "cfg-grammar.y"
    { (yyval.ptr) = log_filter_rule_new((yyvsp[(1) - (5)].cptr), (yyvsp[(3) - (5)].node)); free((yyvsp[(1) - (5)].cptr)); }
    break;

  case 17:

/* Line 1455 of yacc.c  */
#line 360 "cfg-grammar.y"
    { (yyval.ptr) = log_parser_rule_new((yyvsp[(1) - (5)].cptr), (yyvsp[(3) - (5)].ptr)); free((yyvsp[(1) - (5)].cptr)); }
    break;

  case 18:

/* Line 1455 of yacc.c  */
#line 363 "cfg-grammar.y"
    { (yyval.ptr) = log_rewrite_rule_new((yyvsp[(1) - (4)].cptr), (yyvsp[(3) - (4)].ptr)); free((yyvsp[(1) - (4)].cptr)); }
    break;

  case 19:

/* Line 1455 of yacc.c  */
#line 366 "cfg-grammar.y"
    { (yyval.ptr) = log_dest_group_new((yyvsp[(1) - (4)].cptr), (yyvsp[(3) - (4)].ptr)); free((yyvsp[(1) - (4)].cptr)); }
    break;

  case 20:

/* Line 1455 of yacc.c  */
#line 370 "cfg-grammar.y"
    { LogPipeItem *pi = log_pipe_item_append_tail((yyvsp[(2) - (5)].ptr), (yyvsp[(3) - (5)].ptr)); (yyval.ptr) = log_connection_new(pi, (yyvsp[(4) - (5)].num)); }
    break;

  case 21:

/* Line 1455 of yacc.c  */
#line 374 "cfg-grammar.y"
    { last_include_file = (yyvsp[(1) - (1)].cptr); }
    break;

  case 22:

/* Line 1455 of yacc.c  */
#line 377 "cfg-grammar.y"
    { log_pipe_item_append((yyvsp[(1) - (3)].ptr), (yyvsp[(3) - (3)].ptr)); (yyval.ptr) = (yyvsp[(1) - (3)].ptr); }
    break;

  case 23:

/* Line 1455 of yacc.c  */
#line 378 "cfg-grammar.y"
    { (yyval.ptr) = NULL; }
    break;

  case 24:

/* Line 1455 of yacc.c  */
#line 382 "cfg-grammar.y"
    { (yyval.ptr) = log_pipe_item_new(EP_SOURCE, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 25:

/* Line 1455 of yacc.c  */
#line 383 "cfg-grammar.y"
    { (yyval.ptr) = log_pipe_item_new(EP_FILTER, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 26:

/* Line 1455 of yacc.c  */
#line 384 "cfg-grammar.y"
    { (yyval.ptr) = log_pipe_item_new(EP_PARSER, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 27:

/* Line 1455 of yacc.c  */
#line 385 "cfg-grammar.y"
    { (yyval.ptr) = log_pipe_item_new(EP_REWRITE, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 28:

/* Line 1455 of yacc.c  */
#line 386 "cfg-grammar.y"
    { (yyval.ptr) = log_pipe_item_new(EP_DESTINATION, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 29:

/* Line 1455 of yacc.c  */
#line 390 "cfg-grammar.y"
    { log_pipe_item_append((yyvsp[(1) - (2)].ptr), (yyvsp[(2) - (2)].ptr)); (yyval.ptr) = (yyvsp[(1) - (2)].ptr); }
    break;

  case 30:

/* Line 1455 of yacc.c  */
#line 391 "cfg-grammar.y"
    { (yyval.ptr) = NULL; }
    break;

  case 31:

/* Line 1455 of yacc.c  */
#line 395 "cfg-grammar.y"
    { LogPipeItem *pi = log_pipe_item_append_tail((yyvsp[(3) - (7)].ptr), (yyvsp[(4) - (7)].ptr)); (yyval.ptr) = log_pipe_item_new_ref(EP_PIPE, log_connection_new(pi, (yyvsp[(5) - (7)].num))); }
    break;

  case 32:

/* Line 1455 of yacc.c  */
#line 399 "cfg-grammar.y"
    { (yyval.num) = (yyvsp[(3) - (5)].num); }
    break;

  case 33:

/* Line 1455 of yacc.c  */
#line 400 "cfg-grammar.y"
    { (yyval.num) = 0; }
    break;

  case 34:

/* Line 1455 of yacc.c  */
#line 405 "cfg-grammar.y"
    { (yyval.num) = log_connection_lookup_flag((yyvsp[(1) - (2)].cptr)) | (yyvsp[(2) - (2)].num); free((yyvsp[(1) - (2)].cptr)); }
    break;

  case 35:

/* Line 1455 of yacc.c  */
#line 406 "cfg-grammar.y"
    { (yyval.num) = 0; }
    break;

  case 36:

/* Line 1455 of yacc.c  */
#line 411 "cfg-grammar.y"
    { (yyval.ptr) = NULL; }
    break;

  case 37:

/* Line 1455 of yacc.c  */
#line 416 "cfg-grammar.y"
    {
	    last_template = log_template_new((yyvsp[(1) - (1)].cptr), NULL);
	    free((yyvsp[(1) - (1)].cptr));
	  }
    break;

  case 38:

/* Line 1455 of yacc.c  */
#line 420 "cfg-grammar.y"
    { (yyval.ptr) = last_template;  }
    break;

  case 41:

/* Line 1455 of yacc.c  */
#line 429 "cfg-grammar.y"
    { last_template->template = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); if (!cfg_check_template(last_template)) { YYERROR; } }
    break;

  case 42:

/* Line 1455 of yacc.c  */
#line 430 "cfg-grammar.y"
    { log_template_set_escape(last_template, (yyvsp[(3) - (4)].num)); }
    break;

  case 43:

/* Line 1455 of yacc.c  */
#line 434 "cfg-grammar.y"
    { last_sock_options->sndbuf = (yyvsp[(3) - (4)].num); }
    break;

  case 44:

/* Line 1455 of yacc.c  */
#line 435 "cfg-grammar.y"
    { last_sock_options->rcvbuf = (yyvsp[(3) - (4)].num); }
    break;

  case 45:

/* Line 1455 of yacc.c  */
#line 436 "cfg-grammar.y"
    { last_sock_options->broadcast = (yyvsp[(3) - (4)].num); }
    break;

  case 46:

/* Line 1455 of yacc.c  */
#line 437 "cfg-grammar.y"
    { last_sock_options->keepalive = (yyvsp[(3) - (4)].num); }
    break;

  case 48:

/* Line 1455 of yacc.c  */
#line 442 "cfg-grammar.y"
    { ((InetSocketOptions *) last_sock_options)->ttl = (yyvsp[(3) - (4)].num); }
    break;

  case 49:

/* Line 1455 of yacc.c  */
#line 443 "cfg-grammar.y"
    { ((InetSocketOptions *) last_sock_options)->tos = (yyvsp[(3) - (4)].num); }
    break;

  case 50:

/* Line 1455 of yacc.c  */
#line 447 "cfg-grammar.y"
    { if ((yyvsp[(1) - (3)].ptr)) {log_drv_append((yyvsp[(1) - (3)].ptr), (yyvsp[(3) - (3)].ptr)); log_drv_unref((yyvsp[(3) - (3)].ptr)); (yyval.ptr) = (yyvsp[(1) - (3)].ptr); } else { YYERROR; } }
    break;

  case 51:

/* Line 1455 of yacc.c  */
#line 448 "cfg-grammar.y"
    { (yyval.ptr) = NULL; }
    break;

  case 52:

/* Line 1455 of yacc.c  */
#line 452 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 53:

/* Line 1455 of yacc.c  */
#line 453 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 54:

/* Line 1455 of yacc.c  */
#line 454 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 55:

/* Line 1455 of yacc.c  */
#line 455 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 56:

/* Line 1455 of yacc.c  */
#line 456 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 57:

/* Line 1455 of yacc.c  */
#line 457 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 58:

/* Line 1455 of yacc.c  */
#line 461 "cfg-grammar.y"
    { (yyval.ptr) = afinter_sd_new(); }
    break;

  case 59:

/* Line 1455 of yacc.c  */
#line 465 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 60:

/* Line 1455 of yacc.c  */
#line 466 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 61:

/* Line 1455 of yacc.c  */
#line 471 "cfg-grammar.y"
    {
	    last_driver = affile_sd_new((yyvsp[(1) - (1)].cptr), 0); 
	    free((yyvsp[(1) - (1)].cptr)); 
	    last_reader_options = &((AFFileSourceDriver *) last_driver)->reader_options;
	  }
    break;

  case 62:

/* Line 1455 of yacc.c  */
#line 476 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 63:

/* Line 1455 of yacc.c  */
#line 481 "cfg-grammar.y"
    {
	    last_driver = affile_sd_new((yyvsp[(1) - (1)].cptr), AFFILE_PIPE); 
	    free((yyvsp[(1) - (1)].cptr)); 
	    last_reader_options = &((AFFileSourceDriver *) last_driver)->reader_options;
	  }
    break;

  case 64:

/* Line 1455 of yacc.c  */
#line 486 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 65:

/* Line 1455 of yacc.c  */
#line 490 "cfg-grammar.y"
    { last_driver->optional = (yyvsp[(3) - (4)].num); }
    break;

  case 66:

/* Line 1455 of yacc.c  */
#line 491 "cfg-grammar.y"
    {}
    break;

  case 67:

/* Line 1455 of yacc.c  */
#line 495 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 68:

/* Line 1455 of yacc.c  */
#line 496 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 69:

/* Line 1455 of yacc.c  */
#line 497 "cfg-grammar.y"
    { last_addr_family = AF_INET; }
    break;

  case 70:

/* Line 1455 of yacc.c  */
#line 497 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(4) - (5)].ptr); }
    break;

  case 71:

/* Line 1455 of yacc.c  */
#line 498 "cfg-grammar.y"
    { last_addr_family = AF_INET; }
    break;

  case 72:

/* Line 1455 of yacc.c  */
#line 498 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(4) - (5)].ptr); }
    break;

  case 73:

/* Line 1455 of yacc.c  */
#line 499 "cfg-grammar.y"
    { last_addr_family = AF_INET6; }
    break;

  case 74:

/* Line 1455 of yacc.c  */
#line 499 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(4) - (5)].ptr); }
    break;

  case 75:

/* Line 1455 of yacc.c  */
#line 500 "cfg-grammar.y"
    { last_addr_family = AF_INET6; }
    break;

  case 76:

/* Line 1455 of yacc.c  */
#line 500 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(4) - (5)].ptr); }
    break;

  case 77:

/* Line 1455 of yacc.c  */
#line 505 "cfg-grammar.y"
    { 
	    last_driver = afunix_sd_new(
		(yyvsp[(1) - (1)].cptr),
		AFSOCKET_DGRAM | AFSOCKET_LOCAL); 
	    free((yyvsp[(1) - (1)].cptr)); 
	    last_reader_options = &((AFSocketSourceDriver *) last_driver)->reader_options;
	    last_sock_options = &((AFUnixSourceDriver *) last_driver)->sock_options;
	  }
    break;

  case 78:

/* Line 1455 of yacc.c  */
#line 513 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 79:

/* Line 1455 of yacc.c  */
#line 518 "cfg-grammar.y"
    { 
	    last_driver = afunix_sd_new(
		(yyvsp[(1) - (1)].cptr),
		AFSOCKET_STREAM | AFSOCKET_KEEP_ALIVE | AFSOCKET_LOCAL);
	    free((yyvsp[(1) - (1)].cptr));
	    last_reader_options = &((AFSocketSourceDriver *) last_driver)->reader_options;
	    last_sock_options = &((AFUnixSourceDriver *) last_driver)->sock_options;
	  }
    break;

  case 80:

/* Line 1455 of yacc.c  */
#line 526 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 83:

/* Line 1455 of yacc.c  */
#line 536 "cfg-grammar.y"
    { afunix_sd_set_uid(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 84:

/* Line 1455 of yacc.c  */
#line 537 "cfg-grammar.y"
    { afunix_sd_set_uid(last_driver, "-2"); }
    break;

  case 85:

/* Line 1455 of yacc.c  */
#line 538 "cfg-grammar.y"
    { afunix_sd_set_gid(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 86:

/* Line 1455 of yacc.c  */
#line 539 "cfg-grammar.y"
    { afunix_sd_set_gid(last_driver, "-2"); }
    break;

  case 87:

/* Line 1455 of yacc.c  */
#line 540 "cfg-grammar.y"
    { afunix_sd_set_perm(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 88:

/* Line 1455 of yacc.c  */
#line 541 "cfg-grammar.y"
    { afunix_sd_set_perm(last_driver, -2); }
    break;

  case 89:

/* Line 1455 of yacc.c  */
#line 542 "cfg-grammar.y"
    { last_driver->optional = (yyvsp[(3) - (4)].num); }
    break;

  case 90:

/* Line 1455 of yacc.c  */
#line 543 "cfg-grammar.y"
    {}
    break;

  case 91:

/* Line 1455 of yacc.c  */
#line 544 "cfg-grammar.y"
    {}
    break;

  case 92:

/* Line 1455 of yacc.c  */
#line 545 "cfg-grammar.y"
    {}
    break;

  case 93:

/* Line 1455 of yacc.c  */
#line 550 "cfg-grammar.y"
    { 
	    last_driver = afinet_sd_new(last_addr_family,
			NULL, 514,
			AFSOCKET_DGRAM);
	    last_reader_options = &((AFSocketSourceDriver *) last_driver)->reader_options;
	    last_sock_options = &((AFInetSourceDriver *) last_driver)->sock_options.super;
	  }
    break;

  case 94:

/* Line 1455 of yacc.c  */
#line 557 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 98:

/* Line 1455 of yacc.c  */
#line 570 "cfg-grammar.y"
    { afinet_sd_set_localip(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 99:

/* Line 1455 of yacc.c  */
#line 571 "cfg-grammar.y"
    { afinet_sd_set_localip(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 100:

/* Line 1455 of yacc.c  */
#line 572 "cfg-grammar.y"
    { afinet_sd_set_localport(last_driver, (yyvsp[(3) - (4)].cptr), afinet_sd_get_proto_name(last_driver)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 101:

/* Line 1455 of yacc.c  */
#line 573 "cfg-grammar.y"
    { afinet_sd_set_localport(last_driver, (yyvsp[(3) - (4)].cptr), afinet_sd_get_proto_name(last_driver)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 104:

/* Line 1455 of yacc.c  */
#line 580 "cfg-grammar.y"
    { 
	    last_driver = afinet_sd_new(last_addr_family,
			NULL, 514,
			AFSOCKET_STREAM);
	    last_reader_options = &((AFSocketSourceDriver *) last_driver)->reader_options;
	    last_sock_options = &((AFInetSourceDriver *) last_driver)->sock_options.super;
	  }
    break;

  case 105:

/* Line 1455 of yacc.c  */
#line 587 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 109:

/* Line 1455 of yacc.c  */
#line 599 "cfg-grammar.y"
    {
#if ENABLE_SSL
	    last_tls_context = tls_context_new(TM_SERVER);
#endif
	  }
    break;

  case 110:

/* Line 1455 of yacc.c  */
#line 605 "cfg-grammar.y"
    { 
#if ENABLE_SSL
	    afsocket_sd_set_tls_context(last_driver, last_tls_context); 
#endif
          }
    break;

  case 111:

/* Line 1455 of yacc.c  */
#line 611 "cfg-grammar.y"
    {}
    break;

  case 112:

/* Line 1455 of yacc.c  */
#line 615 "cfg-grammar.y"
    { afsocket_sd_set_keep_alive(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 113:

/* Line 1455 of yacc.c  */
#line 616 "cfg-grammar.y"
    { afsocket_sd_set_max_connections(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 114:

/* Line 1455 of yacc.c  */
#line 620 "cfg-grammar.y"
    { last_addr_family = AF_INET; }
    break;

  case 115:

/* Line 1455 of yacc.c  */
#line 620 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(4) - (5)].ptr); }
    break;

  case 116:

/* Line 1455 of yacc.c  */
#line 625 "cfg-grammar.y"
    { 
	    last_driver = afinet_sd_new(last_addr_family,
			NULL, 601,
			AFSOCKET_STREAM | AFSOCKET_SYSLOG_PROTOCOL);
	    last_reader_options = &((AFSocketSourceDriver *) last_driver)->reader_options;
	    last_sock_options = &((AFInetSourceDriver *) last_driver)->sock_options.super;
	  }
    break;

  case 117:

/* Line 1455 of yacc.c  */
#line 632 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 121:

/* Line 1455 of yacc.c  */
#line 642 "cfg-grammar.y"
    { afinet_sd_set_transport(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 122:

/* Line 1455 of yacc.c  */
#line 643 "cfg-grammar.y"
    { afinet_sd_set_transport(last_driver, "tcp"); }
    break;

  case 123:

/* Line 1455 of yacc.c  */
#line 644 "cfg-grammar.y"
    { afinet_sd_set_transport(last_driver, "udp"); }
    break;

  case 124:

/* Line 1455 of yacc.c  */
#line 645 "cfg-grammar.y"
    { afinet_sd_set_transport(last_driver, "tls"); }
    break;

  case 125:

/* Line 1455 of yacc.c  */
#line 647 "cfg-grammar.y"
    {
#if ENABLE_SSL
	    last_tls_context = tls_context_new(TM_SERVER);
#endif
	  }
    break;

  case 126:

/* Line 1455 of yacc.c  */
#line 653 "cfg-grammar.y"
    { 
#if ENABLE_SSL
	    afsocket_sd_set_tls_context(last_driver, last_tls_context); 
#endif
          }
    break;

  case 127:

/* Line 1455 of yacc.c  */
#line 658 "cfg-grammar.y"
    {}
    break;

  case 128:

/* Line 1455 of yacc.c  */
#line 662 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 129:

/* Line 1455 of yacc.c  */
#line 667 "cfg-grammar.y"
    { 
	    last_driver = afprogram_sd_new((yyvsp[(1) - (1)].cptr)); 
	    free((yyvsp[(1) - (1)].cptr)); 
	    last_reader_options = &((AFProgramSourceDriver *) last_driver)->reader_options;
	  }
    break;

  case 130:

/* Line 1455 of yacc.c  */
#line 672 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 131:

/* Line 1455 of yacc.c  */
#line 676 "cfg-grammar.y"
    {
#if ENABLE_SUN_STREAMS
}
    break;

  case 132:

/* Line 1455 of yacc.c  */
#line 679 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 133:

/* Line 1455 of yacc.c  */
#line 680 "cfg-grammar.y"
    {
#endif
}
    break;

  case 134:

/* Line 1455 of yacc.c  */
#line 687 "cfg-grammar.y"
    { 
#if ENABLE_SUN_STREAMS
	    last_driver = afstreams_sd_new((yyvsp[(1) - (1)].cptr)); 
	    free((yyvsp[(1) - (1)].cptr)); 
#endif
	  }
    break;

  case 135:

/* Line 1455 of yacc.c  */
#line 693 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 138:

/* Line 1455 of yacc.c  */
#line 702 "cfg-grammar.y"
    {
#if ENABLE_SUN_STREAMS
}
    break;

  case 139:

/* Line 1455 of yacc.c  */
#line 705 "cfg-grammar.y"
    { afstreams_sd_set_sundoor(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 140:

/* Line 1455 of yacc.c  */
#line 706 "cfg-grammar.y"
    {
#endif
}
    break;

  case 143:

/* Line 1455 of yacc.c  */
#line 717 "cfg-grammar.y"
    { last_reader_options->super.init_window_size = (yyvsp[(3) - (4)].num); }
    break;

  case 144:

/* Line 1455 of yacc.c  */
#line 718 "cfg-grammar.y"
    { last_reader_options->super.chain_hostnames = (yyvsp[(3) - (4)].num); }
    break;

  case 145:

/* Line 1455 of yacc.c  */
#line 719 "cfg-grammar.y"
    { last_reader_options->super.normalize_hostnames = (yyvsp[(3) - (4)].num); }
    break;

  case 146:

/* Line 1455 of yacc.c  */
#line 720 "cfg-grammar.y"
    { last_reader_options->super.keep_hostname = (yyvsp[(3) - (4)].num); }
    break;

  case 147:

/* Line 1455 of yacc.c  */
#line 721 "cfg-grammar.y"
    { last_reader_options->super.use_fqdn = (yyvsp[(3) - (4)].num); }
    break;

  case 148:

/* Line 1455 of yacc.c  */
#line 722 "cfg-grammar.y"
    { last_reader_options->super.use_dns = (yyvsp[(3) - (4)].num); }
    break;

  case 149:

/* Line 1455 of yacc.c  */
#line 723 "cfg-grammar.y"
    { last_reader_options->super.use_dns_cache = (yyvsp[(3) - (4)].num); }
    break;

  case 150:

/* Line 1455 of yacc.c  */
#line 724 "cfg-grammar.y"
    { last_reader_options->super.program_override = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 151:

/* Line 1455 of yacc.c  */
#line 725 "cfg-grammar.y"
    { last_reader_options->super.host_override = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 152:

/* Line 1455 of yacc.c  */
#line 726 "cfg-grammar.y"
    { gchar *p = strrchr((yyvsp[(3) - (4)].cptr), ':'); if (p) *p = 0; last_reader_options->super.program_override = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 153:

/* Line 1455 of yacc.c  */
#line 727 "cfg-grammar.y"
    { last_reader_options->recv_time_zone = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 154:

/* Line 1455 of yacc.c  */
#line 728 "cfg-grammar.y"
    { last_reader_options->check_hostname = (yyvsp[(3) - (4)].num); }
    break;

  case 155:

/* Line 1455 of yacc.c  */
#line 729 "cfg-grammar.y"
    { last_reader_options->options = (yyvsp[(3) - (4)].num); }
    break;

  case 156:

/* Line 1455 of yacc.c  */
#line 730 "cfg-grammar.y"
    { last_reader_options->msg_size = (yyvsp[(3) - (4)].num); }
    break;

  case 157:

/* Line 1455 of yacc.c  */
#line 731 "cfg-grammar.y"
    { last_reader_options->fetch_limit = (yyvsp[(3) - (4)].num); }
    break;

  case 158:

/* Line 1455 of yacc.c  */
#line 732 "cfg-grammar.y"
    { last_reader_options->padding = (yyvsp[(3) - (4)].num); }
    break;

  case 159:

/* Line 1455 of yacc.c  */
#line 733 "cfg-grammar.y"
    { last_reader_options->follow_freq = (long) ((yyvsp[(3) - (4)].fnum) * 1000); }
    break;

  case 160:

/* Line 1455 of yacc.c  */
#line 734 "cfg-grammar.y"
    { last_reader_options->follow_freq = ((yyvsp[(3) - (4)].num) * 1000); }
    break;

  case 161:

/* Line 1455 of yacc.c  */
#line 735 "cfg-grammar.y"
    { last_reader_options->super.keep_timestamp = (yyvsp[(3) - (4)].num); }
    break;

  case 162:

/* Line 1455 of yacc.c  */
#line 736 "cfg-grammar.y"
    { last_reader_options->text_encoding = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 163:

/* Line 1455 of yacc.c  */
#line 738 "cfg-grammar.y"
    {
	    if (last_reader_options->default_pri == 0xFFFF)
	      last_reader_options->default_pri = LOG_USER;
	    last_reader_options->default_pri = (last_reader_options->default_pri & ~7) | (yyvsp[(3) - (4)].num);
          }
    break;

  case 164:

/* Line 1455 of yacc.c  */
#line 744 "cfg-grammar.y"
    {
	    if (last_reader_options->default_pri == 0xFFFF)
	      last_reader_options->default_pri = LOG_NOTICE;
	    last_reader_options->default_pri = (last_reader_options->default_pri & 7) | (yyvsp[(3) - (4)].num);
          }
    break;

  case 165:

/* Line 1455 of yacc.c  */
#line 752 "cfg-grammar.y"
    { (yyval.num) = log_reader_options_lookup_flag((yyvsp[(1) - (2)].cptr)) | (yyvsp[(2) - (2)].num); free((yyvsp[(1) - (2)].cptr)); }
    break;

  case 166:

/* Line 1455 of yacc.c  */
#line 753 "cfg-grammar.y"
    { (yyval.num) = 0; }
    break;

  case 167:

/* Line 1455 of yacc.c  */
#line 758 "cfg-grammar.y"
    { log_drv_append((yyvsp[(1) - (3)].ptr), (yyvsp[(3) - (3)].ptr)); log_drv_unref((yyvsp[(3) - (3)].ptr)); (yyval.ptr) = (yyvsp[(1) - (3)].ptr); }
    break;

  case 168:

/* Line 1455 of yacc.c  */
#line 759 "cfg-grammar.y"
    { (yyval.ptr) = NULL; }
    break;

  case 169:

/* Line 1455 of yacc.c  */
#line 763 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 170:

/* Line 1455 of yacc.c  */
#line 764 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 171:

/* Line 1455 of yacc.c  */
#line 765 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 172:

/* Line 1455 of yacc.c  */
#line 766 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 173:

/* Line 1455 of yacc.c  */
#line 767 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 174:

/* Line 1455 of yacc.c  */
#line 768 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 175:

/* Line 1455 of yacc.c  */
#line 770 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (1)].ptr); }
    break;

  case 176:

/* Line 1455 of yacc.c  */
#line 775 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 177:

/* Line 1455 of yacc.c  */
#line 780 "cfg-grammar.y"
    { 
	    last_driver = affile_dd_new((yyvsp[(1) - (1)].cptr), 0); 
	    free((yyvsp[(1) - (1)].cptr)); 
	    last_writer_options = &((AFFileDestDriver *) last_driver)->writer_options;
	  }
    break;

  case 178:

/* Line 1455 of yacc.c  */
#line 786 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 182:

/* Line 1455 of yacc.c  */
#line 796 "cfg-grammar.y"
    { last_driver->optional = (yyvsp[(3) - (4)].num); }
    break;

  case 183:

/* Line 1455 of yacc.c  */
#line 797 "cfg-grammar.y"
    { affile_dd_set_file_uid(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 184:

/* Line 1455 of yacc.c  */
#line 798 "cfg-grammar.y"
    { affile_dd_set_file_uid(last_driver, "-2"); }
    break;

  case 185:

/* Line 1455 of yacc.c  */
#line 799 "cfg-grammar.y"
    { affile_dd_set_file_gid(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 186:

/* Line 1455 of yacc.c  */
#line 800 "cfg-grammar.y"
    { affile_dd_set_file_gid(last_driver, "-2"); }
    break;

  case 187:

/* Line 1455 of yacc.c  */
#line 801 "cfg-grammar.y"
    { affile_dd_set_file_perm(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 188:

/* Line 1455 of yacc.c  */
#line 802 "cfg-grammar.y"
    { affile_dd_set_file_perm(last_driver, -2); }
    break;

  case 189:

/* Line 1455 of yacc.c  */
#line 803 "cfg-grammar.y"
    { affile_dd_set_dir_uid(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 190:

/* Line 1455 of yacc.c  */
#line 804 "cfg-grammar.y"
    { affile_dd_set_dir_uid(last_driver, "-2"); }
    break;

  case 191:

/* Line 1455 of yacc.c  */
#line 805 "cfg-grammar.y"
    { affile_dd_set_dir_gid(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 192:

/* Line 1455 of yacc.c  */
#line 806 "cfg-grammar.y"
    { affile_dd_set_dir_gid(last_driver, "-2"); }
    break;

  case 193:

/* Line 1455 of yacc.c  */
#line 807 "cfg-grammar.y"
    { affile_dd_set_dir_perm(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 194:

/* Line 1455 of yacc.c  */
#line 808 "cfg-grammar.y"
    { affile_dd_set_dir_perm(last_driver, -2); }
    break;

  case 195:

/* Line 1455 of yacc.c  */
#line 809 "cfg-grammar.y"
    { affile_dd_set_create_dirs(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 196:

/* Line 1455 of yacc.c  */
#line 810 "cfg-grammar.y"
    { affile_dd_set_overwrite_if_older(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 197:

/* Line 1455 of yacc.c  */
#line 811 "cfg-grammar.y"
    { affile_dd_set_fsync(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 198:

/* Line 1455 of yacc.c  */
#line 812 "cfg-grammar.y"
    { affile_dd_set_local_time_zone(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 199:

/* Line 1455 of yacc.c  */
#line 816 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 200:

/* Line 1455 of yacc.c  */
#line 821 "cfg-grammar.y"
    { 
	    last_driver = affile_dd_new((yyvsp[(1) - (1)].cptr), AFFILE_PIPE);
	    free((yyvsp[(1) - (1)].cptr)); 
	    last_writer_options = &((AFFileDestDriver *) last_driver)->writer_options;
	    last_writer_options->flush_lines = 0;
	  }
    break;

  case 201:

/* Line 1455 of yacc.c  */
#line 827 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 205:

/* Line 1455 of yacc.c  */
#line 837 "cfg-grammar.y"
    { affile_dd_set_file_uid(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 206:

/* Line 1455 of yacc.c  */
#line 838 "cfg-grammar.y"
    { affile_dd_set_file_uid(last_driver, "-2"); }
    break;

  case 207:

/* Line 1455 of yacc.c  */
#line 839 "cfg-grammar.y"
    { affile_dd_set_file_gid(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 208:

/* Line 1455 of yacc.c  */
#line 840 "cfg-grammar.y"
    { affile_dd_set_file_gid(last_driver, "-2"); }
    break;

  case 209:

/* Line 1455 of yacc.c  */
#line 841 "cfg-grammar.y"
    { affile_dd_set_file_perm(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 210:

/* Line 1455 of yacc.c  */
#line 842 "cfg-grammar.y"
    { affile_dd_set_file_perm(last_driver, -2); }
    break;

  case 211:

/* Line 1455 of yacc.c  */
#line 846 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 212:

/* Line 1455 of yacc.c  */
#line 847 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 213:

/* Line 1455 of yacc.c  */
#line 848 "cfg-grammar.y"
    { last_addr_family = AF_INET; }
    break;

  case 214:

/* Line 1455 of yacc.c  */
#line 848 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(4) - (5)].ptr); }
    break;

  case 215:

/* Line 1455 of yacc.c  */
#line 849 "cfg-grammar.y"
    { last_addr_family = AF_INET; }
    break;

  case 216:

/* Line 1455 of yacc.c  */
#line 849 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(4) - (5)].ptr); }
    break;

  case 217:

/* Line 1455 of yacc.c  */
#line 850 "cfg-grammar.y"
    { last_addr_family = AF_INET6; }
    break;

  case 218:

/* Line 1455 of yacc.c  */
#line 850 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(4) - (5)].ptr); }
    break;

  case 219:

/* Line 1455 of yacc.c  */
#line 851 "cfg-grammar.y"
    { last_addr_family = AF_INET6; }
    break;

  case 220:

/* Line 1455 of yacc.c  */
#line 851 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(4) - (5)].ptr); }
    break;

  case 221:

/* Line 1455 of yacc.c  */
#line 856 "cfg-grammar.y"
    { 
	    last_driver = afunix_dd_new((yyvsp[(1) - (1)].cptr), AFSOCKET_DGRAM);
	    free((yyvsp[(1) - (1)].cptr));
	    last_writer_options = &((AFSocketDestDriver *) last_driver)->writer_options;
	    last_sock_options = &((AFUnixDestDriver *) last_driver)->sock_options;
	  }
    break;

  case 222:

/* Line 1455 of yacc.c  */
#line 862 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 223:

/* Line 1455 of yacc.c  */
#line 867 "cfg-grammar.y"
    { 
	    last_driver = afunix_dd_new((yyvsp[(1) - (1)].cptr), AFSOCKET_STREAM);
	    free((yyvsp[(1) - (1)].cptr));
	    last_writer_options = &((AFSocketDestDriver *) last_driver)->writer_options;
	    last_sock_options = &((AFUnixDestDriver *) last_driver)->sock_options;
	  }
    break;

  case 224:

/* Line 1455 of yacc.c  */
#line 873 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 230:

/* Line 1455 of yacc.c  */
#line 889 "cfg-grammar.y"
    { 
	    last_driver = afinet_dd_new(last_addr_family,
			(yyvsp[(1) - (1)].cptr), 514,
			AFSOCKET_DGRAM);
	    free((yyvsp[(1) - (1)].cptr));
	    last_writer_options = &((AFSocketDestDriver *) last_driver)->writer_options;
	    last_sock_options = &((AFInetDestDriver *) last_driver)->sock_options.super;
	  }
    break;

  case 231:

/* Line 1455 of yacc.c  */
#line 897 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 234:

/* Line 1455 of yacc.c  */
#line 907 "cfg-grammar.y"
    { afinet_dd_set_localip(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 235:

/* Line 1455 of yacc.c  */
#line 908 "cfg-grammar.y"
    { afinet_dd_set_localport(last_driver, (yyvsp[(3) - (4)].cptr), afinet_dd_get_proto_name(last_driver)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 236:

/* Line 1455 of yacc.c  */
#line 909 "cfg-grammar.y"
    { afinet_dd_set_destport(last_driver, (yyvsp[(3) - (4)].cptr), afinet_dd_get_proto_name(last_driver)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 237:

/* Line 1455 of yacc.c  */
#line 910 "cfg-grammar.y"
    { afinet_dd_set_destport(last_driver, (yyvsp[(3) - (4)].cptr), afinet_dd_get_proto_name(last_driver)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 242:

/* Line 1455 of yacc.c  */
#line 918 "cfg-grammar.y"
    { afinet_dd_set_spoof_source(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 243:

/* Line 1455 of yacc.c  */
#line 923 "cfg-grammar.y"
    { 
	    last_driver = afinet_dd_new(last_addr_family,
			(yyvsp[(1) - (1)].cptr), 514,
			AFSOCKET_STREAM); 
	    free((yyvsp[(1) - (1)].cptr));
	    last_writer_options = &((AFSocketDestDriver *) last_driver)->writer_options;
	    last_sock_options = &((AFInetDestDriver *) last_driver)->sock_options.super;
	  }
    break;

  case 244:

/* Line 1455 of yacc.c  */
#line 931 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 248:

/* Line 1455 of yacc.c  */
#line 942 "cfg-grammar.y"
    {
#if ENABLE_SSL
	    last_tls_context = tls_context_new(TM_CLIENT);
#endif
	  }
    break;

  case 249:

/* Line 1455 of yacc.c  */
#line 948 "cfg-grammar.y"
    { 
#if ENABLE_SSL
	    afsocket_dd_set_tls_context(last_driver, last_tls_context); 
#endif
          }
    break;

  case 250:

/* Line 1455 of yacc.c  */
#line 956 "cfg-grammar.y"
    { afsocket_dd_set_keep_alive(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 251:

/* Line 1455 of yacc.c  */
#line 961 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 252:

/* Line 1455 of yacc.c  */
#line 965 "cfg-grammar.y"
    {
            last_driver = afinet_dd_new(last_addr_family, (yyvsp[(1) - (1)].cptr), 601, AFSOCKET_STREAM | AFSOCKET_SYSLOG_PROTOCOL);
	    last_writer_options = &((AFSocketDestDriver *) last_driver)->writer_options;
	    last_sock_options = &((AFInetDestDriver *) last_driver)->sock_options.super;
	    free((yyvsp[(1) - (1)].cptr));
	  }
    break;

  case 253:

/* Line 1455 of yacc.c  */
#line 971 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 257:

/* Line 1455 of yacc.c  */
#line 982 "cfg-grammar.y"
    { afinet_dd_set_transport(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 258:

/* Line 1455 of yacc.c  */
#line 983 "cfg-grammar.y"
    { afinet_dd_set_transport(last_driver, "tcp"); }
    break;

  case 259:

/* Line 1455 of yacc.c  */
#line 984 "cfg-grammar.y"
    { afinet_dd_set_transport(last_driver, "udp"); }
    break;

  case 260:

/* Line 1455 of yacc.c  */
#line 985 "cfg-grammar.y"
    { afinet_dd_set_transport(last_driver, "tls"); }
    break;

  case 261:

/* Line 1455 of yacc.c  */
#line 986 "cfg-grammar.y"
    { afinet_dd_set_spoof_source(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 262:

/* Line 1455 of yacc.c  */
#line 988 "cfg-grammar.y"
    {
#if ENABLE_SSL
	    last_tls_context = tls_context_new(TM_CLIENT);
#endif
	  }
    break;

  case 263:

/* Line 1455 of yacc.c  */
#line 994 "cfg-grammar.y"
    { 
#if ENABLE_SSL
	    afsocket_dd_set_tls_context(last_driver, last_tls_context); 
#endif
          }
    break;

  case 264:

/* Line 1455 of yacc.c  */
#line 1003 "cfg-grammar.y"
    { (yyval.ptr) = afuser_dd_new((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 265:

/* Line 1455 of yacc.c  */
#line 1007 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 266:

/* Line 1455 of yacc.c  */
#line 1012 "cfg-grammar.y"
    { 
	    last_driver = afprogram_dd_new((yyvsp[(1) - (1)].cptr)); 
	    free((yyvsp[(1) - (1)].cptr)); 
	    last_writer_options = &((AFProgramDestDriver *) last_driver)->writer_options;
	  }
    break;

  case 267:

/* Line 1455 of yacc.c  */
#line 1017 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 268:

/* Line 1455 of yacc.c  */
#line 1023 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(3) - (4)].ptr); }
    break;

  case 269:

/* Line 1455 of yacc.c  */
#line 1028 "cfg-grammar.y"
    {
            #if ENABLE_SQL	
            last_driver = afsql_dd_new();
            #endif /* ENABLE_SQL */
          }
    break;

  case 270:

/* Line 1455 of yacc.c  */
#line 1033 "cfg-grammar.y"
    { (yyval.ptr) = last_driver; }
    break;

  case 273:

/* Line 1455 of yacc.c  */
#line 1042 "cfg-grammar.y"
    { 
#if ENABLE_SQL 
}
    break;

  case 274:

/* Line 1455 of yacc.c  */
#line 1045 "cfg-grammar.y"
    { afsql_dd_set_type(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 275:

/* Line 1455 of yacc.c  */
#line 1046 "cfg-grammar.y"
    { afsql_dd_set_host(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 276:

/* Line 1455 of yacc.c  */
#line 1047 "cfg-grammar.y"
    { afsql_dd_set_port(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 277:

/* Line 1455 of yacc.c  */
#line 1048 "cfg-grammar.y"
    { afsql_dd_set_user(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 278:

/* Line 1455 of yacc.c  */
#line 1049 "cfg-grammar.y"
    { afsql_dd_set_password(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 279:

/* Line 1455 of yacc.c  */
#line 1050 "cfg-grammar.y"
    { afsql_dd_set_database(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 280:

/* Line 1455 of yacc.c  */
#line 1051 "cfg-grammar.y"
    { afsql_dd_set_table(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 281:

/* Line 1455 of yacc.c  */
#line 1052 "cfg-grammar.y"
    { afsql_dd_set_columns(last_driver, (yyvsp[(3) - (4)].ptr)); }
    break;

  case 282:

/* Line 1455 of yacc.c  */
#line 1053 "cfg-grammar.y"
    { afsql_dd_set_indexes(last_driver, (yyvsp[(3) - (4)].ptr)); }
    break;

  case 283:

/* Line 1455 of yacc.c  */
#line 1054 "cfg-grammar.y"
    { afsql_dd_set_values(last_driver, (yyvsp[(3) - (4)].ptr)); }
    break;

  case 284:

/* Line 1455 of yacc.c  */
#line 1055 "cfg-grammar.y"
    { afsql_dd_set_mem_fifo_size(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 285:

/* Line 1455 of yacc.c  */
#line 1056 "cfg-grammar.y"
    { afsql_dd_set_disk_fifo_size(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 286:

/* Line 1455 of yacc.c  */
#line 1057 "cfg-grammar.y"
    { afsql_dd_set_frac_digits(last_driver, (yyvsp[(3) - (4)].num)); }
    break;

  case 287:

/* Line 1455 of yacc.c  */
#line 1058 "cfg-grammar.y"
    { afsql_dd_set_send_time_zone(last_driver,(yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 288:

/* Line 1455 of yacc.c  */
#line 1059 "cfg-grammar.y"
    { afsql_dd_set_local_time_zone(last_driver,(yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 289:

/* Line 1455 of yacc.c  */
#line 1060 "cfg-grammar.y"
    { afsql_dd_set_null_value(last_driver, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 290:

/* Line 1455 of yacc.c  */
#line 1062 "cfg-grammar.y"
    { 
#endif /* ENABLE_SQL */ 
}
    break;

  case 293:

/* Line 1455 of yacc.c  */
#line 1075 "cfg-grammar.y"
    { last_writer_options->options = (yyvsp[(3) - (4)].num); }
    break;

  case 294:

/* Line 1455 of yacc.c  */
#line 1076 "cfg-grammar.y"
    { last_writer_options->mem_fifo_size = (yyvsp[(3) - (4)].num); }
    break;

  case 295:

/* Line 1455 of yacc.c  */
#line 1077 "cfg-grammar.y"
    { last_writer_options->flush_lines = (yyvsp[(3) - (4)].num); }
    break;

  case 296:

/* Line 1455 of yacc.c  */
#line 1078 "cfg-grammar.y"
    { last_writer_options->flush_timeout = (yyvsp[(3) - (4)].num); }
    break;

  case 297:

/* Line 1455 of yacc.c  */
#line 1079 "cfg-grammar.y"
    { last_writer_options->suppress = (yyvsp[(3) - (4)].num); }
    break;

  case 298:

/* Line 1455 of yacc.c  */
#line 1080 "cfg-grammar.y"
    { 
	                                          last_writer_options->template = cfg_check_inline_template(configuration, (yyvsp[(3) - (4)].cptr));
                                                  if (!cfg_check_template(last_writer_options->template))
	                                            {
	                                              YYERROR;
	                                            }
	                                          free((yyvsp[(3) - (4)].cptr));
	                                        }
    break;

  case 299:

/* Line 1455 of yacc.c  */
#line 1088 "cfg-grammar.y"
    { log_writer_options_set_template_escape(last_writer_options, (yyvsp[(3) - (4)].num)); }
    break;

  case 300:

/* Line 1455 of yacc.c  */
#line 1089 "cfg-grammar.y"
    { last_writer_options->send_time_zone = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 301:

/* Line 1455 of yacc.c  */
#line 1090 "cfg-grammar.y"
    { last_writer_options->ts_format = cfg_ts_format_value((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 302:

/* Line 1455 of yacc.c  */
#line 1091 "cfg-grammar.y"
    { last_writer_options->frac_digits = (yyvsp[(3) - (4)].num); }
    break;

  case 303:

/* Line 1455 of yacc.c  */
#line 1092 "cfg-grammar.y"
    { last_writer_options->throttle = (yyvsp[(3) - (4)].num); }
    break;

  case 304:

/* Line 1455 of yacc.c  */
#line 1096 "cfg-grammar.y"
    { (yyval.num) = log_writer_options_lookup_flag((yyvsp[(1) - (2)].cptr)) | (yyvsp[(2) - (2)].num); free((yyvsp[(1) - (2)].cptr)); }
    break;

  case 305:

/* Line 1455 of yacc.c  */
#line 1097 "cfg-grammar.y"
    { (yyval.num) = 0; }
    break;

  case 306:

/* Line 1455 of yacc.c  */
#line 1102 "cfg-grammar.y"
    { (yyval.ptr) = (yyvsp[(1) - (3)].ptr); }
    break;

  case 307:

/* Line 1455 of yacc.c  */
#line 1103 "cfg-grammar.y"
    { (yyval.ptr) = NULL; }
    break;

  case 308:

/* Line 1455 of yacc.c  */
#line 1107 "cfg-grammar.y"
    { configuration->mark_freq = (yyvsp[(3) - (4)].num); }
    break;

  case 309:

/* Line 1455 of yacc.c  */
#line 1108 "cfg-grammar.y"
    { configuration->stats_freq = (yyvsp[(3) - (4)].num); }
    break;

  case 310:

/* Line 1455 of yacc.c  */
#line 1109 "cfg-grammar.y"
    { configuration->stats_level = (yyvsp[(3) - (4)].num); }
    break;

  case 311:

/* Line 1455 of yacc.c  */
#line 1110 "cfg-grammar.y"
    { configuration->flush_lines = (yyvsp[(3) - (4)].num); }
    break;

  case 312:

/* Line 1455 of yacc.c  */
#line 1111 "cfg-grammar.y"
    { configuration->flush_timeout = (yyvsp[(3) - (4)].num); }
    break;

  case 313:

/* Line 1455 of yacc.c  */
#line 1112 "cfg-grammar.y"
    { configuration->chain_hostnames = (yyvsp[(3) - (4)].num); }
    break;

  case 314:

/* Line 1455 of yacc.c  */
#line 1113 "cfg-grammar.y"
    { configuration->normalize_hostnames = (yyvsp[(3) - (4)].num); }
    break;

  case 315:

/* Line 1455 of yacc.c  */
#line 1114 "cfg-grammar.y"
    { configuration->keep_hostname = (yyvsp[(3) - (4)].num); }
    break;

  case 316:

/* Line 1455 of yacc.c  */
#line 1115 "cfg-grammar.y"
    { configuration->check_hostname = (yyvsp[(3) - (4)].num); }
    break;

  case 317:

/* Line 1455 of yacc.c  */
#line 1116 "cfg-grammar.y"
    { cfg_bad_hostname_set(configuration, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 318:

/* Line 1455 of yacc.c  */
#line 1117 "cfg-grammar.y"
    { configuration->use_time_recvd = (yyvsp[(3) - (4)].num); }
    break;

  case 319:

/* Line 1455 of yacc.c  */
#line 1118 "cfg-grammar.y"
    { configuration->use_fqdn = (yyvsp[(3) - (4)].num); }
    break;

  case 320:

/* Line 1455 of yacc.c  */
#line 1119 "cfg-grammar.y"
    { configuration->use_dns = (yyvsp[(3) - (4)].num); }
    break;

  case 321:

/* Line 1455 of yacc.c  */
#line 1120 "cfg-grammar.y"
    { configuration->time_reopen = (yyvsp[(3) - (4)].num); }
    break;

  case 322:

/* Line 1455 of yacc.c  */
#line 1121 "cfg-grammar.y"
    { configuration->time_reap = (yyvsp[(3) - (4)].num); }
    break;

  case 323:

/* Line 1455 of yacc.c  */
#line 1123 "cfg-grammar.y"
    { 
		  configuration->time_sleep = (yyvsp[(3) - (4)].num); 
		  if ((yyvsp[(3) - (4)].num) > 500) 
		    { 
		      msg_notice("The value specified for time_sleep is too large", evt_tag_int("time_sleep", (yyvsp[(3) - (4)].num)), NULL);
		      configuration->time_sleep = 500;
		    }
		}
    break;

  case 324:

/* Line 1455 of yacc.c  */
#line 1131 "cfg-grammar.y"
    { configuration->log_fifo_size = (yyvsp[(3) - (4)].num); }
    break;

  case 325:

/* Line 1455 of yacc.c  */
#line 1132 "cfg-grammar.y"
    { configuration->log_iw_size = (yyvsp[(3) - (4)].num); }
    break;

  case 326:

/* Line 1455 of yacc.c  */
#line 1133 "cfg-grammar.y"
    { configuration->log_fetch_limit = (yyvsp[(3) - (4)].num); }
    break;

  case 327:

/* Line 1455 of yacc.c  */
#line 1134 "cfg-grammar.y"
    { configuration->log_msg_size = (yyvsp[(3) - (4)].num); }
    break;

  case 328:

/* Line 1455 of yacc.c  */
#line 1135 "cfg-grammar.y"
    { configuration->keep_timestamp = (yyvsp[(3) - (4)].num); }
    break;

  case 329:

/* Line 1455 of yacc.c  */
#line 1136 "cfg-grammar.y"
    { configuration->ts_format = cfg_ts_format_value((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 330:

/* Line 1455 of yacc.c  */
#line 1137 "cfg-grammar.y"
    { configuration->frac_digits = (yyvsp[(3) - (4)].num); }
    break;

  case 331:

/* Line 1455 of yacc.c  */
#line 1138 "cfg-grammar.y"
    { /* ignored */; }
    break;

  case 332:

/* Line 1455 of yacc.c  */
#line 1139 "cfg-grammar.y"
    { /* ignored */; }
    break;

  case 333:

/* Line 1455 of yacc.c  */
#line 1140 "cfg-grammar.y"
    { configuration->create_dirs = (yyvsp[(3) - (4)].num); }
    break;

  case 334:

/* Line 1455 of yacc.c  */
#line 1141 "cfg-grammar.y"
    { cfg_file_owner_set(configuration, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 335:

/* Line 1455 of yacc.c  */
#line 1142 "cfg-grammar.y"
    { cfg_file_owner_set(configuration, "-2"); }
    break;

  case 336:

/* Line 1455 of yacc.c  */
#line 1143 "cfg-grammar.y"
    { cfg_file_group_set(configuration, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 337:

/* Line 1455 of yacc.c  */
#line 1144 "cfg-grammar.y"
    { cfg_file_group_set(configuration, "-2"); }
    break;

  case 338:

/* Line 1455 of yacc.c  */
#line 1145 "cfg-grammar.y"
    { cfg_file_perm_set(configuration, (yyvsp[(3) - (4)].num)); }
    break;

  case 339:

/* Line 1455 of yacc.c  */
#line 1146 "cfg-grammar.y"
    { cfg_file_perm_set(configuration, -2); }
    break;

  case 340:

/* Line 1455 of yacc.c  */
#line 1147 "cfg-grammar.y"
    { cfg_dir_owner_set(configuration, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 341:

/* Line 1455 of yacc.c  */
#line 1148 "cfg-grammar.y"
    { cfg_dir_owner_set(configuration, "-2"); }
    break;

  case 342:

/* Line 1455 of yacc.c  */
#line 1149 "cfg-grammar.y"
    { cfg_dir_group_set(configuration, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 343:

/* Line 1455 of yacc.c  */
#line 1150 "cfg-grammar.y"
    { cfg_dir_group_set(configuration, "-2"); }
    break;

  case 344:

/* Line 1455 of yacc.c  */
#line 1151 "cfg-grammar.y"
    { cfg_dir_perm_set(configuration, (yyvsp[(3) - (4)].num)); }
    break;

  case 345:

/* Line 1455 of yacc.c  */
#line 1152 "cfg-grammar.y"
    { cfg_dir_perm_set(configuration, -2); }
    break;

  case 346:

/* Line 1455 of yacc.c  */
#line 1153 "cfg-grammar.y"
    { configuration->use_dns_cache = (yyvsp[(3) - (4)].num); }
    break;

  case 347:

/* Line 1455 of yacc.c  */
#line 1154 "cfg-grammar.y"
    { configuration->dns_cache_size = (yyvsp[(3) - (4)].num); }
    break;

  case 348:

/* Line 1455 of yacc.c  */
#line 1155 "cfg-grammar.y"
    { configuration->dns_cache_expire = (yyvsp[(3) - (4)].num); }
    break;

  case 349:

/* Line 1455 of yacc.c  */
#line 1157 "cfg-grammar.y"
    { configuration->dns_cache_expire_failed = (yyvsp[(3) - (4)].num); }
    break;

  case 350:

/* Line 1455 of yacc.c  */
#line 1158 "cfg-grammar.y"
    { configuration->dns_cache_hosts = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 351:

/* Line 1455 of yacc.c  */
#line 1159 "cfg-grammar.y"
    { configuration->file_template_name = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 352:

/* Line 1455 of yacc.c  */
#line 1160 "cfg-grammar.y"
    { configuration->proto_template_name = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 353:

/* Line 1455 of yacc.c  */
#line 1161 "cfg-grammar.y"
    { configuration->recv_time_zone = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 354:

/* Line 1455 of yacc.c  */
#line 1162 "cfg-grammar.y"
    { configuration->send_time_zone = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 355:

/* Line 1455 of yacc.c  */
#line 1163 "cfg-grammar.y"
    { configuration->local_time_zone = g_strdup((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 358:

/* Line 1455 of yacc.c  */
#line 1173 "cfg-grammar.y"
    { 
#if ENABLE_SSL
}
    break;

  case 359:

/* Line 1455 of yacc.c  */
#line 1178 "cfg-grammar.y"
    { 
	    last_tls_context->verify_mode = tls_lookup_verify_mode((yyvsp[(3) - (4)].cptr)); 
            free((yyvsp[(3) - (4)].cptr)); 
          }
    break;

  case 360:

/* Line 1455 of yacc.c  */
#line 1183 "cfg-grammar.y"
    { 
	    last_tls_context->key_file = g_strdup((yyvsp[(3) - (4)].cptr)); 
            free((yyvsp[(3) - (4)].cptr));
          }
    break;

  case 361:

/* Line 1455 of yacc.c  */
#line 1188 "cfg-grammar.y"
    { 
	    last_tls_context->cert_file = g_strdup((yyvsp[(3) - (4)].cptr)); 
            free((yyvsp[(3) - (4)].cptr));
          }
    break;

  case 362:

/* Line 1455 of yacc.c  */
#line 1193 "cfg-grammar.y"
    { 
	    last_tls_context->ca_dir = g_strdup((yyvsp[(3) - (4)].cptr)); 
            free((yyvsp[(3) - (4)].cptr));
          }
    break;

  case 363:

/* Line 1455 of yacc.c  */
#line 1198 "cfg-grammar.y"
    { 
	    last_tls_context->crl_dir = g_strdup((yyvsp[(3) - (4)].cptr)); 
            free((yyvsp[(3) - (4)].cptr));
          }
    break;

  case 364:

/* Line 1455 of yacc.c  */
#line 1203 "cfg-grammar.y"
    { 
            tls_session_set_trusted_fingerprints(last_tls_context, (yyvsp[(3) - (4)].ptr)); 
          }
    break;

  case 365:

/* Line 1455 of yacc.c  */
#line 1207 "cfg-grammar.y"
    { 
            tls_session_set_trusted_dn(last_tls_context, (yyvsp[(3) - (4)].ptr)); 
          }
    break;

  case 366:

/* Line 1455 of yacc.c  */
#line 1210 "cfg-grammar.y"
    {
#endif
}
    break;

  case 367:

/* Line 1455 of yacc.c  */
#line 1218 "cfg-grammar.y"
    { (yyval.node) = (yyvsp[(1) - (1)].node); if (!(yyvsp[(1) - (1)].node)) return 1; }
    break;

  case 368:

/* Line 1455 of yacc.c  */
#line 1219 "cfg-grammar.y"
    { (yyvsp[(2) - (2)].node)->comp = !((yyvsp[(2) - (2)].node)->comp); (yyval.node) = (yyvsp[(2) - (2)].node); }
    break;

  case 369:

/* Line 1455 of yacc.c  */
#line 1220 "cfg-grammar.y"
    { (yyval.node) = fop_or_new((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 370:

/* Line 1455 of yacc.c  */
#line 1221 "cfg-grammar.y"
    { (yyval.node) = fop_and_new((yyvsp[(1) - (3)].node), (yyvsp[(3) - (3)].node)); }
    break;

  case 371:

/* Line 1455 of yacc.c  */
#line 1222 "cfg-grammar.y"
    { (yyval.node) = (yyvsp[(2) - (3)].node); }
    break;

  case 372:

/* Line 1455 of yacc.c  */
#line 1226 "cfg-grammar.y"
    { (yyval.node) = filter_facility_new((yyvsp[(3) - (4)].num));  }
    break;

  case 373:

/* Line 1455 of yacc.c  */
#line 1227 "cfg-grammar.y"
    { (yyval.node) = filter_facility_new(0x80000000 | (yyvsp[(3) - (4)].num)); }
    break;

  case 374:

/* Line 1455 of yacc.c  */
#line 1228 "cfg-grammar.y"
    { (yyval.node) = filter_level_new((yyvsp[(3) - (4)].num)); }
    break;

  case 375:

/* Line 1455 of yacc.c  */
#line 1229 "cfg-grammar.y"
    { (yyval.node) = filter_call_new((yyvsp[(3) - (4)].cptr), configuration); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 376:

/* Line 1455 of yacc.c  */
#line 1230 "cfg-grammar.y"
    { (yyval.node) = filter_netmask_new((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 377:

/* Line 1455 of yacc.c  */
#line 1232 "cfg-grammar.y"
    { 
	    last_re_filter = (FilterRE *) filter_re_new(LOG_MESSAGE_BUILTIN_FIELD(PROGRAM)); 
          }
    break;

  case 378:

/* Line 1455 of yacc.c  */
#line 1236 "cfg-grammar.y"
    {
            if(!filter_re_set_regexp(last_re_filter, (yyvsp[(3) - (6)].cptr)))
              YYERROR;
            free((yyvsp[(3) - (6)].cptr)); 

            (yyval.node) = &last_re_filter->super;
          }
    break;

  case 379:

/* Line 1455 of yacc.c  */
#line 1244 "cfg-grammar.y"
    {
	    last_re_filter = (FilterRE *) filter_re_new(LOG_MESSAGE_BUILTIN_FIELD(HOST)); 
          }
    break;

  case 380:

/* Line 1455 of yacc.c  */
#line 1248 "cfg-grammar.y"
    {
            if(!filter_re_set_regexp(last_re_filter, (yyvsp[(3) - (6)].cptr)))
              YYERROR;
            free((yyvsp[(3) - (6)].cptr)); 
            
            (yyval.node) = &last_re_filter->super;
          }
    break;

  case 381:

/* Line 1455 of yacc.c  */
#line 1256 "cfg-grammar.y"
    { 
	    last_re_filter = (FilterRE *) filter_match_new(); 
	  }
    break;

  case 382:

/* Line 1455 of yacc.c  */
#line 1260 "cfg-grammar.y"
    {
            if(!filter_re_set_regexp(last_re_filter, (yyvsp[(3) - (6)].cptr)))
              YYERROR;
            free((yyvsp[(3) - (6)].cptr)); 
            (yyval.node) = &last_re_filter->super;
            
            if (last_re_filter->value_name == 0)
              {
                static gboolean warn_written = FALSE;
                
                if (!warn_written)
                  {
                    msg_warning("WARNING: the match() filter without the use of the value() option is deprecated and hinders performance, please update your configuration",
                                NULL);
                    warn_written = TRUE;
                  }
              }
          }
    break;

  case 383:

/* Line 1455 of yacc.c  */
#line 1279 "cfg-grammar.y"
    {
	    last_re_filter = (FilterRE *) filter_re_new(LOG_MESSAGE_BUILTIN_FIELD(MESSAGE)); 
          }
    break;

  case 384:

/* Line 1455 of yacc.c  */
#line 1283 "cfg-grammar.y"
    {
            if(!filter_re_set_regexp(last_re_filter, (yyvsp[(3) - (6)].cptr)))
              YYERROR;
	    free((yyvsp[(3) - (6)].cptr)); 
            (yyval.node) = &last_re_filter->super;
          }
    break;

  case 385:

/* Line 1455 of yacc.c  */
#line 1290 "cfg-grammar.y"
    {
	    last_re_filter = (FilterRE *) filter_re_new(LOG_MESSAGE_BUILTIN_FIELD(SOURCE)); 
            filter_re_set_matcher(last_re_filter, log_matcher_string_new());
          }
    break;

  case 386:

/* Line 1455 of yacc.c  */
#line 1295 "cfg-grammar.y"
    {
            if(!filter_re_set_regexp(last_re_filter, (yyvsp[(3) - (6)].cptr)))
              YYERROR;
	    free((yyvsp[(3) - (6)].cptr)); 
            (yyval.node) = &last_re_filter->super;
          }
    break;

  case 390:

/* Line 1455 of yacc.c  */
#line 1310 "cfg-grammar.y"
    { last_re_filter->value_name = log_msg_translate_value_name((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 393:

/* Line 1455 of yacc.c  */
#line 1320 "cfg-grammar.y"
    { 
            filter_re_set_matcher(last_re_filter, log_matcher_new((yyvsp[(3) - (4)].cptr)));
            free((yyvsp[(3) - (4)].cptr)); 
          }
    break;

  case 394:

/* Line 1455 of yacc.c  */
#line 1324 "cfg-grammar.y"
    { filter_re_set_flags(last_re_filter, (yyvsp[(3) - (4)].num)); }
    break;

  case 395:

/* Line 1455 of yacc.c  */
#line 1328 "cfg-grammar.y"
    { (yyval.num) = log_matcher_lookup_flag((yyvsp[(1) - (2)].cptr)) | (yyvsp[(2) - (2)].num); free((yyvsp[(1) - (2)].cptr)); }
    break;

  case 396:

/* Line 1455 of yacc.c  */
#line 1329 "cfg-grammar.y"
    { (yyval.num) = 0; }
    break;

  case 397:

/* Line 1455 of yacc.c  */
#line 1334 "cfg-grammar.y"
    { (yyval.num) = (1 << ((yyvsp[(1) - (2)].num) >> 3)) | (yyvsp[(2) - (2)].num); }
    break;

  case 398:

/* Line 1455 of yacc.c  */
#line 1335 "cfg-grammar.y"
    { (yyval.num) = (1 << ((yyvsp[(1) - (1)].num) >> 3)); }
    break;

  case 399:

/* Line 1455 of yacc.c  */
#line 1339 "cfg-grammar.y"
    { (yyval.num) = (yyvsp[(1) - (2)].num) | (yyvsp[(2) - (2)].num); }
    break;

  case 400:

/* Line 1455 of yacc.c  */
#line 1340 "cfg-grammar.y"
    { (yyval.num) = (yyvsp[(1) - (1)].num); }
    break;

  case 401:

/* Line 1455 of yacc.c  */
#line 1345 "cfg-grammar.y"
    { 
	    (yyval.num) = syslog_make_range((yyvsp[(1) - (3)].num), (yyvsp[(3) - (3)].num));
	  }
    break;

  case 402:

/* Line 1455 of yacc.c  */
#line 1349 "cfg-grammar.y"
    { 
	    (yyval.num) = 1 << (yyvsp[(1) - (1)].num);
	  }
    break;

  case 403:

/* Line 1455 of yacc.c  */
#line 1357 "cfg-grammar.y"
    { 
            last_parser = (LogParser *) log_csv_parser_new(); 
          }
    break;

  case 404:

/* Line 1455 of yacc.c  */
#line 1361 "cfg-grammar.y"
    { (yyval.ptr) = last_parser; }
    break;

  case 405:

/* Line 1455 of yacc.c  */
#line 1363 "cfg-grammar.y"
    {
            last_parser = (LogParser *) log_db_parser_new();
          }
    break;

  case 406:

/* Line 1455 of yacc.c  */
#line 1367 "cfg-grammar.y"
    { (yyval.ptr) = last_parser; }
    break;

  case 409:

/* Line 1455 of yacc.c  */
#line 1377 "cfg-grammar.y"
    { log_db_parser_set_db_file(((LogDBParser *) last_parser), (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 411:

/* Line 1455 of yacc.c  */
#line 1382 "cfg-grammar.y"
    { log_column_parser_set_columns((LogColumnParser *) last_parser, (yyvsp[(3) - (4)].ptr)); }
    break;

  case 412:

/* Line 1455 of yacc.c  */
#line 1386 "cfg-grammar.y"
    { 
                                                  LogTemplate *template = cfg_check_inline_template(configuration, (yyvsp[(3) - (4)].cptr));
                                                  if (!cfg_check_template(template))
                                                    {
                                                      YYERROR;
                                                    }
                                                  log_parser_set_template(last_parser, template); 
                                                  free((yyvsp[(3) - (4)].cptr)); 
                                                }
    break;

  case 416:

/* Line 1455 of yacc.c  */
#line 1405 "cfg-grammar.y"
    { log_csv_parser_set_flags((LogColumnParser *) last_parser, (yyvsp[(3) - (4)].num)); }
    break;

  case 417:

/* Line 1455 of yacc.c  */
#line 1406 "cfg-grammar.y"
    { log_csv_parser_set_delimiters((LogColumnParser *) last_parser, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 418:

/* Line 1455 of yacc.c  */
#line 1407 "cfg-grammar.y"
    { log_csv_parser_set_quotes((LogColumnParser *) last_parser, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 419:

/* Line 1455 of yacc.c  */
#line 1408 "cfg-grammar.y"
    { log_csv_parser_set_quote_pairs((LogColumnParser *) last_parser, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 420:

/* Line 1455 of yacc.c  */
#line 1409 "cfg-grammar.y"
    { log_csv_parser_set_null_value((LogColumnParser *) last_parser, (yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 421:

/* Line 1455 of yacc.c  */
#line 1413 "cfg-grammar.y"
    { (yyval.num) = log_csv_parser_lookup_flag((yyvsp[(1) - (2)].cptr)) | (yyvsp[(2) - (2)].num); free((yyvsp[(1) - (2)].cptr)); }
    break;

  case 422:

/* Line 1455 of yacc.c  */
#line 1414 "cfg-grammar.y"
    { (yyval.num) = 0; }
    break;

  case 423:

/* Line 1455 of yacc.c  */
#line 1418 "cfg-grammar.y"
    { (yyval.ptr) = g_list_reverse((yyvsp[(1) - (1)].ptr)); }
    break;

  case 424:

/* Line 1455 of yacc.c  */
#line 1422 "cfg-grammar.y"
    { (yyval.ptr) = g_list_append((yyvsp[(2) - (2)].ptr), (yyvsp[(1) - (2)].ptr)); }
    break;

  case 425:

/* Line 1455 of yacc.c  */
#line 1423 "cfg-grammar.y"
    { (yyval.ptr) = NULL; }
    break;

  case 426:

/* Line 1455 of yacc.c  */
#line 1428 "cfg-grammar.y"
    { 
            last_rewrite = log_rewrite_subst_new((yyvsp[(4) - (4)].cptr)); 
            free((yyvsp[(4) - (4)].cptr));  
          }
    break;

  case 427:

/* Line 1455 of yacc.c  */
#line 1433 "cfg-grammar.y"
    { 
            if(!log_rewrite_set_regexp(last_rewrite, (yyvsp[(3) - (8)].cptr)))
              YYERROR;
            free((yyvsp[(3) - (8)].cptr));
            (yyval.ptr) = last_rewrite; 
          }
    break;

  case 428:

/* Line 1455 of yacc.c  */
#line 1440 "cfg-grammar.y"
    {
            last_rewrite = log_rewrite_set_new((yyvsp[(3) - (3)].cptr)); 
            free((yyvsp[(3) - (3)].cptr));
          }
    break;

  case 429:

/* Line 1455 of yacc.c  */
#line 1444 "cfg-grammar.y"
    { (yyval.ptr) = last_rewrite; }
    break;

  case 432:

/* Line 1455 of yacc.c  */
#line 1453 "cfg-grammar.y"
    { last_rewrite->value_name = log_msg_translate_value_name((yyvsp[(3) - (4)].cptr)); free((yyvsp[(3) - (4)].cptr)); }
    break;

  case 433:

/* Line 1455 of yacc.c  */
#line 1455 "cfg-grammar.y"
    { 
            if (strcmp((yyvsp[(3) - (4)].cptr), "glob") == 0)
              {
                msg_error("Rewrite rules do not support glob expressions",
                          NULL);
                YYERROR;
              }
            log_rewrite_set_matcher(last_rewrite, log_matcher_new((yyvsp[(3) - (4)].cptr)));
            free((yyvsp[(3) - (4)].cptr)); 
          }
    break;

  case 434:

/* Line 1455 of yacc.c  */
#line 1465 "cfg-grammar.y"
    { log_rewrite_set_flags(last_rewrite, (yyvsp[(3) - (4)].num)); }
    break;

  case 435:

/* Line 1455 of yacc.c  */
#line 1469 "cfg-grammar.y"
    { (yyval.num) = 1; }
    break;

  case 436:

/* Line 1455 of yacc.c  */
#line 1470 "cfg-grammar.y"
    { (yyval.num) = 0; }
    break;

  case 437:

/* Line 1455 of yacc.c  */
#line 1471 "cfg-grammar.y"
    { (yyval.num) = (yyvsp[(1) - (1)].num); }
    break;

  case 438:

/* Line 1455 of yacc.c  */
#line 1475 "cfg-grammar.y"
    { (yyval.num) = (yyvsp[(1) - (1)].num); }
    break;

  case 439:

/* Line 1455 of yacc.c  */
#line 1476 "cfg-grammar.y"
    { (yyval.num) = 2; }
    break;

  case 442:

/* Line 1455 of yacc.c  */
#line 1482 "cfg-grammar.y"
    { (yyval.cptr) = cfg_lex_get_keyword_string((yyvsp[(1) - (1)].token)); }
    break;

  case 467:

/* Line 1455 of yacc.c  */
#line 1514 "cfg-grammar.y"
    { (yyval.cptr) = (yyvsp[(1) - (1)].cptr); }
    break;

  case 468:

/* Line 1455 of yacc.c  */
#line 1515 "cfg-grammar.y"
    { char buf[32]; snprintf(buf, sizeof(buf), "%" G_GINT64_FORMAT, (yyvsp[(1) - (1)].num)); (yyval.cptr) = strdup(buf); }
    break;

  case 469:

/* Line 1455 of yacc.c  */
#line 1519 "cfg-grammar.y"
    { (yyval.ptr) = g_list_reverse((yyvsp[(1) - (1)].ptr)); }
    break;

  case 470:

/* Line 1455 of yacc.c  */
#line 1523 "cfg-grammar.y"
    { (yyval.ptr) = g_list_append((yyvsp[(2) - (2)].ptr), g_strdup((yyvsp[(1) - (2)].cptr))); free((yyvsp[(1) - (2)].cptr)); }
    break;

  case 471:

/* Line 1455 of yacc.c  */
#line 1524 "cfg-grammar.y"
    { (yyval.ptr) = NULL; }
    break;

  case 472:

/* Line 1455 of yacc.c  */
#line 1529 "cfg-grammar.y"
    {
	    /* return the numeric value of the "level" */
	    int n = syslog_name_lookup_level_by_name((yyvsp[(1) - (1)].cptr));
	    if (n == -1)
	      {
	        msg_error("Unknown priority level",
                          evt_tag_str("priority", (yyvsp[(1) - (1)].cptr)),
                          NULL);
	        YYERROR;
	      }
	    free((yyvsp[(1) - (1)].cptr));
            (yyval.num) = n;
	  }
    break;

  case 473:

/* Line 1455 of yacc.c  */
#line 1546 "cfg-grammar.y"
    {
            /* return the numeric value of facility */
	    int n = syslog_name_lookup_facility_by_name((yyvsp[(1) - (1)].cptr));
	    if (n == -1)
	      {
	        msg_error("Unknown facility",
	                  evt_tag_str("facility", (yyvsp[(1) - (1)].cptr)),
	                  NULL);
                YYERROR;
	      }
	    free((yyvsp[(1) - (1)].cptr));
	    (yyval.num) = n;
	  }
    break;

  case 474:

/* Line 1455 of yacc.c  */
#line 1559 "cfg-grammar.y"
    { (yyval.num) = LOG_SYSLOG; }
    break;



/* Line 1455 of yacc.c  */
#line 6070 "cfg-grammar.c"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (yymsg);
	  }
	else
	  {
	    yyerror (YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  *++yyvsp = yylval;


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined(yyoverflow) || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}



/* Line 1675 of yacc.c  */
#line 1563 "cfg-grammar.y"


extern int linenum;

void 
yyerror(char *msg)
{
  fprintf(stderr, "%s in %s at line %d.\n\n"
                  "syslog-ng documentation: http://www.balabit.com/support/documentation/?product=syslog-ng\n"
                  "mailing list: https://lists.balabit.hu/mailman/listinfo/syslog-ng\n", msg, cfg_lex_get_current_file(), cfg_lex_get_current_lineno());
}


