import SwiftLintCore

struct ProhibitedSuperConfiguration: SeverityBasedRuleConfiguration, Equatable {
    typealias Parent = ProhibitedSuperRule

    @ConfigurationElement(key: "severity")
    private(set) var severityConfiguration = SeverityConfiguration<Parent>(.warning)
    @ConfigurationElement(key: "excluded")
    private(set) var excluded = [String]()
    @ConfigurationElement(key: "included")
    private(set) var included = ["*"]

    private(set) var resolvedMethodNames = [
        // NSFileProviderExtension
        "providePlaceholder(at:completionHandler:)",
        // NSTextInput
        "doCommand(by:)",
        // NSView
        "updateLayer()",
        // UIViewController
        "loadView()"
    ]

    mutating func apply(configuration: Any) throws {
        guard let configuration = configuration as? [String: Any] else {
            throw Issue.unknownConfiguration(ruleID: Parent.identifier)
        }

        if let severityString = configuration[$severityConfiguration] as? String {
            try severityConfiguration.apply(configuration: severityString)
        }

        if let excluded = [String].array(of: configuration[$excluded]) {
            self.excluded = excluded
        }

        if let included = [String].array(of: configuration[$included]) {
            self.included = included
        }

        resolvedMethodNames = calculateResolvedMethodNames()
    }

    private func calculateResolvedMethodNames() -> [String] {
        var names = [String]()
        if included.contains("*") && !excluded.contains("*") {
            names += resolvedMethodNames
        }
        names += included.filter { $0 != "*" }
        names = names.filter { !excluded.contains($0) }
        return names
    }
}
