/* Swfdec
 * Copyright (C) 2007 Pekka Lampila <pekka.lampila@iki.fi>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "swfdec_as_internal.h"
#include "swfdec_debug.h"

// properties
SWFDEC_AS_NATIVE (1105, 101, swfdec_color_transform_get_alphaMultiplier)
void
swfdec_color_transform_get_alphaMultiplier (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ColorTransform.alphaMultiplier (get)");
}

SWFDEC_AS_NATIVE (1105, 102, swfdec_color_transform_set_alphaMultiplier)
void
swfdec_color_transform_set_alphaMultiplier (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ColorTransform.alphaMultiplier (set)");
}

SWFDEC_AS_NATIVE (1105, 103, swfdec_color_transform_get_redMultiplier)
void
swfdec_color_transform_get_redMultiplier (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ColorTransform.redMultiplier (get)");
}

SWFDEC_AS_NATIVE (1105, 104, swfdec_color_transform_set_redMultiplier)
void
swfdec_color_transform_set_redMultiplier (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ColorTransform.redMultiplier (set)");
}

SWFDEC_AS_NATIVE (1105, 105, swfdec_color_transform_get_greenMultiplier)
void
swfdec_color_transform_get_greenMultiplier (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ColorTransform.greenMultiplier (get)");
}

SWFDEC_AS_NATIVE (1105, 106, swfdec_color_transform_set_greenMultiplier)
void
swfdec_color_transform_set_greenMultiplier (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ColorTransform.greenMultiplier (set)");
}

SWFDEC_AS_NATIVE (1105, 107, swfdec_color_transform_get_blueMultiplier)
void
swfdec_color_transform_get_blueMultiplier (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ColorTransform.blueMultiplier (get)");
}

SWFDEC_AS_NATIVE (1105, 108, swfdec_color_transform_set_blueMultiplier)
void
swfdec_color_transform_set_blueMultiplier (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ColorTransform.blueMultiplier (set)");
}

SWFDEC_AS_NATIVE (1105, 109, swfdec_color_transform_get_alphaOffset)
void
swfdec_color_transform_get_alphaOffset (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ColorTransform.alphaOffset (get)");
}

SWFDEC_AS_NATIVE (1105, 110, swfdec_color_transform_set_alphaOffset)
void
swfdec_color_transform_set_alphaOffset (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ColorTransform.alphaOffset (set)");
}

SWFDEC_AS_NATIVE (1105, 111, swfdec_color_transform_get_redOffset)
void
swfdec_color_transform_get_redOffset (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ColorTransform.redOffset (get)");
}

SWFDEC_AS_NATIVE (1105, 112, swfdec_color_transform_set_redOffset)
void
swfdec_color_transform_set_redOffset (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ColorTransform.redOffset (set)");
}

SWFDEC_AS_NATIVE (1105, 113, swfdec_color_transform_get_greenOffset)
void
swfdec_color_transform_get_greenOffset (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ColorTransform.greenOffset (get)");
}

SWFDEC_AS_NATIVE (1105, 114, swfdec_color_transform_set_greenOffset)
void
swfdec_color_transform_set_greenOffset (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ColorTransform.greenOffset (set)");
}

SWFDEC_AS_NATIVE (1105, 115, swfdec_color_transform_get_blueOffset)
void
swfdec_color_transform_get_blueOffset (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ColorTransform.blueOffset (get)");
}

SWFDEC_AS_NATIVE (1105, 116, swfdec_color_transform_set_blueOffset)
void
swfdec_color_transform_set_blueOffset (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ColorTransform.blueOffset (set)");
}

SWFDEC_AS_NATIVE (1105, 117, swfdec_color_transform_get_rgb)
void
swfdec_color_transform_get_rgb (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ColorTransform.rgb (get)");
}

SWFDEC_AS_NATIVE (1105, 118, swfdec_color_transform_set_rgb)
void
swfdec_color_transform_set_rgb (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ColorTransform.rgb (set)");
}

// normal
SWFDEC_AS_NATIVE (1105, 1, swfdec_color_transform_concat)
void
swfdec_color_transform_concat (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ColorTransform.concat");
}

// constructor
SWFDEC_AS_NATIVE (1105, 0, swfdec_color_transform_construct)
void
swfdec_color_transform_construct (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ColorTransform");
}
