/*
 * Decompiled with CFR 0.152.
 */
package smr.JavaDeps;

import java.util.Enumeration;
import java.util.Vector;

class DepNode {
    private Object className;
    private Object classFileName;
    private Object sourceFileName;
    private Vector links;
    private boolean hasNative;
    byte colour;
    static final byte WHITE = 0;
    static final byte GRAY = 1;
    static final byte BLACK = 2;
    static boolean emitComments;
    static String buildCommand;
    static boolean buildStubs;
    static String headerBuildCommand;

    public String toString() {
        return "{classname=" + this.className + ",files=(" + this.sourceFileName + " --> " + this.classFileName + ")}";
    }

    DepNode(String string, String string2, String string3) {
        this.className = string;
        this.classFileName = string2;
        this.sourceFileName = string3;
        this.links = new Vector();
        this.hasNative = false;
        this.colour = 0;
    }

    DepNode(Vector vector) {
        this.className = new Vector();
        this.classFileName = new Vector();
        this.sourceFileName = new Vector();
        this.links = new Vector();
        this.colour = 0;
        this.hasNative = false;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DepNode depNode = (DepNode)enumeration.nextElement();
            if (depNode.isSimple()) {
                this.addClass((String)depNode.className);
                this.addClassFile((String)depNode.classFileName);
                this.addSourceFile((String)depNode.sourceFileName);
            } else {
                this.addClass((Vector)depNode.className);
                this.addClassFile((Vector)depNode.classFileName);
                this.addSourceFile((Vector)depNode.sourceFileName);
            }
            this.addLink(depNode.links);
            if (!depNode.hasNative) continue;
            this.hasNative = true;
        }
    }

    void clearLinks() {
        this.links = new Vector();
    }

    Enumeration adjacent() {
        return this.links.elements();
    }

    void setHasNative() {
        this.hasNative = true;
    }

    String javaFiles() {
        if (this.isSimple()) {
            return (String)this.sourceFileName;
        }
        String string = "";
        Enumeration enumeration = ((Vector)this.sourceFileName).elements();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + (String)enumeration.nextElement() + " ";
        }
        return string;
    }

    String classFiles() {
        if (this.isSimple()) {
            return (String)this.classFileName;
        }
        String string = "";
        Enumeration enumeration = ((Vector)this.classFileName).elements();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + (String)enumeration.nextElement() + " ";
        }
        return string;
    }

    String classNames() {
        if (this.isSimple()) {
            return (String)this.className;
        }
        String string = "";
        Enumeration enumeration = ((Vector)this.className).elements();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + (String)enumeration.nextElement() + " ";
        }
        return string;
    }

    private void printRule(String string, String string2, String string3) {
        System.out.println(String.valueOf(string) + ": " + string2);
        if (string3 != null) {
            System.out.println("\t" + string3);
        }
        System.out.println();
    }

    private static String stubPrefix(String string) {
        return string.replace('.', '_');
    }

    String stubFiles() {
        if (!this.hasNative) {
            return null;
        }
        if (this.isSimple()) {
            String string = DepNode.stubPrefix((String)this.className);
            String string2 = String.valueOf(string) + ".h";
            if (buildStubs) {
                string2 = String.valueOf(string2) + " " + string + ".c";
            }
            return string2;
        }
        String string = "";
        Enumeration enumeration = ((Vector)this.className).elements();
        while (enumeration.hasMoreElements()) {
            String string3 = DepNode.stubPrefix((String)enumeration.nextElement());
            string = String.valueOf(string) + string3 + ".h ";
            if (!buildStubs) continue;
            string = String.valueOf(string) + string3 + ".c ";
        }
        return string;
    }

    private void dumpNative(String string, String string2) {
        String string3 = DepNode.stubPrefix(string);
        this.printRule(String.valueOf(string3) + ".h", string2, String.valueOf(headerBuildCommand) + " " + string);
        if (buildStubs) {
            this.printRule(String.valueOf(string3) + ".c", string2, String.valueOf(headerBuildCommand) + " -stubs " + string);
        }
    }

    public void dump() {
        String string = this.classFiles();
        String string2 = this.javaFiles();
        if (emitComments) {
            System.out.println("# Rules for " + this.classNames());
            System.out.println("#");
        }
        this.printRule(string, string2, buildCommand == null ? null : String.valueOf(buildCommand) + " " + string2);
        Enumeration enumeration = this.links.elements();
        while (enumeration.hasMoreElements()) {
            DepNode depNode = (DepNode)enumeration.nextElement();
            this.printRule(string, depNode.classFiles(), null);
        }
        if (this.hasNative && headerBuildCommand != null) {
            if (this.isSimple()) {
                this.dumpNative((String)this.className, (String)this.classFileName);
            } else {
                int n = 0;
                while (n < ((Vector)this.className).size()) {
                    this.dumpNative((String)((Vector)this.className).elementAt(n), (String)((Vector)this.classFileName).elementAt(n));
                    ++n;
                }
            }
        }
        System.out.println();
    }

    boolean isSimple() {
        return this.className instanceof String;
    }

    boolean isMulti() {
        return this.className instanceof Vector;
    }

    private void becomeMulti() {
        if (this.isMulti()) {
            return;
        }
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(this.className);
        this.className = vector;
        vector = new Vector();
        vector.addElement(this.classFileName);
        this.classFileName = vector;
        vector = new Vector();
        vector.addElement(this.sourceFileName);
        this.sourceFileName = vector;
    }

    void addClass(String string, String string2) {
        this.becomeMulti();
        this.addClass(string);
        this.addClassFile(string2);
    }

    private void addClass(String string) {
        if (!((Vector)this.className).contains(string)) {
            ((Vector)this.className).addElement(string);
        }
    }

    private void addClass(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addClass((String)enumeration.nextElement());
        }
    }

    private void addClassFile(String string) {
        if (!((Vector)this.classFileName).contains(string)) {
            ((Vector)this.classFileName).addElement(string);
        }
    }

    private void addClassFile(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addClassFile((String)enumeration.nextElement());
        }
    }

    private void addSourceFile(String string) {
        if (!((Vector)this.sourceFileName).contains(string)) {
            ((Vector)this.sourceFileName).addElement(string);
        }
    }

    private void addSourceFile(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addSourceFile((String)enumeration.nextElement());
        }
    }

    void addLink(String string) {
        if (!this.links.contains(string)) {
            this.links.addElement(string);
        }
    }

    void addLink(DepNode depNode) {
        if (depNode != this && !this.links.contains(depNode)) {
            this.links.addElement(depNode);
        }
    }

    void addLink(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addLink((DepNode)enumeration.nextElement());
        }
    }

    void replaceLink(DepNode depNode, DepNode depNode2) {
        int n = this.links.indexOf(depNode);
        if (n >= 0) {
            if (this == depNode2 || this.links.contains(depNode2)) {
                this.links.removeElementAt(n);
                return;
            }
            this.links.setElementAt(depNode2, n);
        }
    }

    void replaceLink(Vector vector, DepNode depNode) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.replaceLink((DepNode)enumeration.nextElement(), depNode);
        }
    }
}

