/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.IntNum;

public abstract class Numeric
extends Number {
    public static final int FLOOR = 1;
    public static final int CEILING = 2;
    public static final int TRUNCATE = 3;
    public static final int ROUND = 4;

    public abstract Numeric abs();

    public final Numeric add(Object object2) {
        return this.add(object2, 1);
    }

    public abstract Numeric add(Object var1, int var2);

    public Numeric addReversed(Numeric numeric, int n) {
        throw new IllegalArgumentException();
    }

    public int compare(Object object2) {
        return -3;
    }

    public int compareReversed(Numeric numeric) {
        throw new IllegalArgumentException();
    }

    public abstract Numeric div(Object var1);

    public Numeric divReversed(Numeric numeric) {
        throw new IllegalArgumentException();
    }

    public Numeric div_inv() {
        return IntNum.one().div(this);
    }

    public boolean equals(Object object2) {
        if (object2 == null || !(object2 instanceof Numeric)) {
            return false;
        }
        return this.compare(object2) == 0;
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public boolean geq(Object object2) {
        return this.compare(object2) >= 0;
    }

    public boolean grt(Object object2) {
        return this.compare(object2) > 0;
    }

    public int intValue() {
        return (int)this.longValue();
    }

    public abstract boolean isExact();

    public abstract boolean isZero();

    public long longValue() {
        return (long)this.doubleValue();
    }

    public abstract Numeric mul(Object var1);

    public Numeric mulReversed(Numeric numeric) {
        throw new IllegalArgumentException();
    }

    public Numeric mul_ident() {
        return IntNum.one();
    }

    public abstract Numeric neg();

    public Numeric power(IntNum intNum) {
        if (intNum.isNegative()) {
            return this.power(IntNum.neg(intNum)).div_inv();
        }
        Numeric numeric = this;
        Numeric numeric2 = null;
        while (true) {
            if (intNum.isOdd()) {
                Numeric numeric3 = numeric2 = numeric2 == null ? numeric : numeric2.mul(numeric);
            }
            if ((intNum = IntNum.shift(intNum, -1)).isZero()) break;
            numeric = numeric.mul(numeric);
        }
        return numeric2 == null ? this.mul_ident() : numeric2;
    }

    public final Numeric sub(Object object2) {
        return this.add(object2, -1);
    }

    public String toString() {
        return this.toString(10);
    }

    public abstract String toString(int var1);
}

