/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.util;

import gnu.kawa.util.Sequence;
import gnu.kawa.util.UniformVector;
import gnu.math.DFloNum;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;

public class F32Vector
extends UniformVector
implements Externalizable {
    float[] data;

    public F32Vector() {
    }

    public F32Vector(int n) {
        this.data = new float[n];
    }

    public F32Vector(int n, float f) {
        float[] fArray = new float[n];
        this.data = fArray;
        while (--n >= 0) {
            fArray[n] = f;
        }
    }

    public F32Vector(Sequence sequence) {
        this.data = new float[sequence.length()];
        this.copy(sequence);
    }

    public F32Vector(float[] fArray) {
        this.data = fArray;
    }

    public final float floatValue(int n) {
        return this.data[n];
    }

    public final Object get(int n) {
        return DFloNum.make(this.data[n]);
    }

    public final String getTag() {
        return "f32";
    }

    public final int length() {
        return this.data.length;
    }

    public final void print(int n, PrintWriter printWriter) {
        printWriter.print(this.floatValue(n));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = objectInput.readFloat();
            ++n2;
        }
        this.data = fArray;
    }

    public final void set(int n, float f) {
        this.data[n] = f;
    }

    public final void setElementAt(Object object2, int n) {
        this.data[n] = ((Number)object2).floatValue();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.data.length;
        objectOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            objectOutput.writeFloat(this.data[n2]);
            ++n2;
        }
    }
}

