/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.BufferContent;
import gnu.jemacs.buffer.BufferReader;
import gnu.jemacs.buffer.Signal;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Style;

public final class Marker
implements Position {
    Buffer buffer;
    int position;
    static final int POINT_POSITION_INDEX = -1;
    static final int EMACS_MARK_KIND = 1;

    public Marker() {
    }

    public Marker(Buffer buffer, int n, int n2) {
        this.buffer = buffer;
        this.position = buffer.content.createPosition(n, n2);
    }

    public Marker(Marker marker) {
        this.buffer = marker.buffer;
        if (this.buffer != null) {
            BufferContent bufferContent = this.buffer.content;
            this.position = marker.position == -1 ? bufferContent.createPosition(marker.getOffset(), 2) : bufferContent.copyPosition(marker.position);
        }
    }

    public void backwardChar(int n) {
        int n2 = this.getOffset();
        if (n2 < n) {
            n2 = 0;
            Signal.signal("Beginning of buffer");
        }
        this.setDot(n2 -= n);
    }

    public int currentColumn() {
        return this.buffer.currentColumn(this.getOffset());
    }

    public void deleteChar(int n) {
        int n2 = this.getOffset();
        try {
            if (n < 0) {
                if (n2 - (n = -n) < this.buffer.minDot()) {
                    Signal.signal("Beginning of buffer");
                }
                n2 -= n;
            } else if (n2 + n > this.buffer.maxDot()) {
                Signal.signal("End of buffer");
            }
            this.buffer.remove(n2, n);
            this.buffer.setDot(n2);
        }
        catch (BadLocationException badLocationException) {
            throw new Error("bad location: " + badLocationException);
        }
    }

    public boolean equals(Object object2) {
        if (!(object2 instanceof Marker)) {
            return false;
        }
        Marker marker = (Marker)object2;
        return this.buffer == marker.buffer && this.getOffset() == marker.getOffset();
    }

    public void finalize() {
        if (this.buffer != null) {
            this.buffer.content.releasePosition(this.position);
        }
    }

    public void forwardChar(int n) {
        int n2;
        int n3 = this.getOffset();
        if (n3 + n > (n2 = this.buffer.maxDot())) {
            n3 = n2;
            Signal.signal("End of buffer");
        }
        this.setDot(n3 += n);
    }

    public int forwardLine(int n) {
        long l = this.buffer.forwardLine(n, this.getOffset());
        this.setDot((int)l);
        return (int)(l >> 32);
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public int getOffset() {
        if (this.buffer == null) {
            return -1;
        }
        if (this.position == -1) {
            return this.buffer.curPosition.getDot();
        }
        return this.buffer.content.getPositionOffset(this.position);
    }

    public int getPoint() {
        return 1 + this.getOffset();
    }

    public int hashCode() {
        if (this.buffer == null) {
            return 0;
        }
        return this.buffer.hashCode() ^ this.getOffset();
    }

    public void insert(char c, int n, Style style) {
        if (n < 0) {
            return;
        }
        if (style == null) {
            style = Buffer.defaultStyle;
        }
        int n2 = n > 500 ? 500 : n;
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = n2;
        while (--n3 >= 0) {
            stringBuffer.append(c);
        }
        String string = stringBuffer.toString();
        int n4 = this.getOffset();
        while (true) {
            try {
                this.buffer.insertString(n4, string, style);
            }
            catch (BadLocationException badLocationException) {
                throw new Error("bad location: " + badLocationException);
            }
            n4 += n2;
            if ((n -= n2) == 0) break;
            if (n >= 500) continue;
            n2 = n;
            stringBuffer.setLength(n2);
            string = stringBuffer.toString();
        }
        this.setDot(n4);
    }

    public void insert(String string, Style style) {
        if (style == null) {
            style = Buffer.defaultStyle;
        }
        int n = this.getOffset();
        try {
            this.buffer.insertString(n, string, style);
        }
        catch (BadLocationException badLocationException) {
            throw new Error("bad location: " + badLocationException);
        }
        this.setDot(n += string.length());
    }

    public boolean isBeginningOfLine() {
        int n = this.getOffset();
        return n == 0 || this.buffer.content.charAt(n - 1) == '\n';
    }

    public boolean isEndOfLine() {
        BufferContent bufferContent;
        int n = this.getOffset();
        return n == (bufferContent = this.buffer.content).length() || bufferContent.charAt(n) == '\n';
    }

    public int moveToColumn(int n, boolean bl) {
        int n2;
        int n3 = this.buffer.lineStartOffset(this.getOffset());
        BufferReader bufferReader = new BufferReader(this.buffer, n3, this.buffer.maxDot() - n3);
        int n4 = 0;
        int n5 = n3;
        while ((n2 = bufferReader.read()) >= 0 && n2 != 10) {
            int n6 = this.buffer.charWidth((char)n2, n4);
            ++n5;
            if ((n4 += n6) < n) continue;
            boolean bl2 = n4 > n && bl;
            break;
        }
        this.setDot(n5);
        return n4;
    }

    public void set(Buffer buffer, int n) {
        if (this.position == -1) {
            if (buffer != this.buffer) {
                String string = buffer == null ? "Can't make point-marker point nowhere: " : "Can't change buffer of point-marker: ";
                throw new Error(String.valueOf(string) + this);
            }
            this.buffer.curPosition.setDot(n);
        } else {
            if (this.buffer != null) {
                this.buffer.content.releasePosition(this.position);
            }
            if (buffer == null) {
                this.buffer = null;
                return;
            }
            if (n < 0) {
                n = 0;
            } else {
                int n2 = buffer.content.length();
                if (n > n2) {
                    n = n2;
                }
            }
            this.buffer = buffer;
            this.position = buffer.content.createPosition(n, 1);
        }
    }

    public void setDot(int n) {
        this.set(this.buffer, n);
    }

    public String toString() {
        if (this.buffer == null) {
            return "#<marker in no buffer>";
        }
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append("#<marker at ");
        stringBuffer.append(this.getPoint());
        stringBuffer.append(" in ");
        stringBuffer.append(this.buffer.getName());
        stringBuffer.append('>');
        return stringBuffer.toString();
    }
}

