/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayClassLoader;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.CheckedTarget;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Keyword;
import gnu.expr.Literal;
import gnu.expr.ModuleExp;
import gnu.expr.ObjectExp;
import gnu.expr.ProcInitializer;
import gnu.expr.QuoteExp;
import gnu.expr.ScopeExp;
import gnu.expr.Special;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.kawa.util.LList;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class LambdaExp
extends ScopeExp {
    public String name;
    public Expression body;
    public int min_args;
    public int max_args;
    Variable argsArray;
    private Declaration firstArgsArrayArg;
    public Keyword[] keywords;
    public Expression[] defaultArgs;
    static int counter;
    int id = ++counter;
    Declaration capturedVars;
    Variable heapFrame;
    LambdaExp heapFrameLambda;
    public LambdaExp firstChild;
    public LambdaExp nextSibling;
    static final ApplyExp unknownContinuation;
    ApplyExp returnContinuation;
    Declaration nameDecl;
    public Field closureEnvField;
    public Field staticLinkField;
    Variable closureEnv;
    static final int INLINE_ONLY = 1;
    static final int CAN_READ = 2;
    static final int CAN_CALL = 4;
    static final int IMPORTS_LEX_VARS = 8;
    static final int NEEDS_STATIC_LINK = 16;
    static final int CANNOT_INLINE = 32;
    static final int CLASS_METHOD = 64;
    static final int METHODS_COMPILED = 128;
    static final int NO_FIELD = 256;
    static final int DEFAULT_CAPTURES_ARG = 512;
    protected static final int NEXT_AVAIL_FLAG = 1024;
    public static String fileFunctionName;
    ClassType type = Compilation.typeProcedure;
    int selectorValue;
    Method[] primMethods;
    Variable thisVariable;
    static Method setNameMethod;
    static Method searchForKeywordMethod3;
    static Method searchForKeywordMethod4;
    public static String dumpZipPrefix;
    public static int dumpZipCounter;
    Procedure thisValue;
    Object[] properties;

    static {
        unknownContinuation = new ApplyExp(null, null);
        fileFunctionName = "atFileLevel";
        setNameMethod = null;
    }

    public LambdaExp() {
    }

    public LambdaExp(Expression expression) {
        this.body = expression;
    }

    void addMethodFor(Compilation compilation, ObjectType objectType) {
        ModuleExp moduleExp;
        ClassType classType = compilation.curClass;
        String string = this.getName();
        StringBuffer stringBuffer = new StringBuffer(60);
        LambdaExp lambdaExp = this.outerLambda();
        if (!lambdaExp.isModuleBody() && !(lambdaExp instanceof ObjectExp) || string == null) {
            stringBuffer.append("lambda");
            stringBuffer.append(++compilation.method_counter);
        }
        if (string != null) {
            stringBuffer.append(Compilation.mangleName(string));
        }
        int n = this.keywords == null ? 0 : this.keywords.length;
        int n2 = this.defaultArgs == null ? 0 : this.defaultArgs.length - n;
        int n3 = (this.flags & 0x200) != 0 ? 0 : n2;
        boolean bl = this.max_args < 0 || this.min_args + n3 < this.max_args;
        this.primMethods = new Method[n3 + 1];
        boolean bl2 = this.isClassMethod() || this.thisVariable != null || objectType == classType ? false : (this.nameDecl == null ? true : (this.nameDecl.getFlag(4096) ? false : (this.nameDecl.getFlag(2048) ? true : (this.nameDecl.context instanceof ModuleExp ? (moduleExp = (ModuleExp)this.nameDecl.context).getSuperType() == null && moduleExp.getInterfaces() == null : true))));
        int n4 = (bl2 ? 8 : 0) + (this.nameDecl != null && !this.nameDecl.isPrivate() ? 1 : 0);
        if (!bl2) {
            this.closureEnv = this.declareThis(classType);
        }
        Type type = this.body.getType();
        int n5 = objectType != null && objectType != classType ? 1 : 0;
        int n6 = 0;
        while (n6 <= n3) {
            int n7;
            int n8 = n7 = this.min_args + n6;
            if (n6 == n3 && bl) {
                ++n8;
            }
            Type[] typeArray = new Type[n5 + n8];
            if (n5 > 0) {
                typeArray[0] = objectType;
            }
            Declaration declaration = this.firstDecl();
            int n9 = 0;
            while (n9 < n7) {
                typeArray[n5 + n9++] = declaration.getType();
                declaration = declaration.nextDecl();
            }
            if (n7 < n8) {
                stringBuffer.append("$V");
                string = stringBuffer.toString();
                Type type2 = declaration.getType();
                String string2 = type2.getName();
                if (n > 0 || n3 < n2 || !"gnu.kawa.util.LList".equals(string2) && !"java.lang.Object[]".equals(string2)) {
                    type2 = Compilation.objArrayType;
                    this.argsArray = new Variable("argsArray", Compilation.objArrayType);
                }
                this.firstArgsArrayArg = declaration;
                typeArray[typeArray.length - 1] = type2;
            }
            boolean bl3 = lambdaExp instanceof ObjectExp || lambdaExp instanceof ModuleExp && ((ModuleExp)lambdaExp).getFlag(8192);
            string = stringBuffer.toString();
            if (!bl3) {
                int n10 = 0;
                int n11 = stringBuffer.length();
                block2: while (true) {
                    ClassType classType2 = classType;
                    while (classType2 != null) {
                        if (classType2.getDeclaredMethod(string, typeArray) != null) {
                            stringBuffer.setLength(n11);
                            stringBuffer.append('$');
                            stringBuffer.append(++n10);
                            string = stringBuffer.toString();
                            continue block2;
                        }
                        classType2 = classType2.getSuperclass();
                    }
                    break;
                }
            }
            this.primMethods[n6] = classType.addMethod(string, typeArray, type, n4);
            ++n6;
        }
    }

    public void allocChildClasses(Compilation compilation) {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (this instanceof ModuleExp) {
            ((ModuleExp)this).allocFields(compilation);
        } else {
            object5 = this.getMainMethod();
            object4 = this.firstDecl();
            if (this.isHandlingTailCalls()) {
                this.firstArgsArrayArg = object4;
            }
            while (true) {
                if (object4 == this.firstArgsArrayArg && this.argsArray != null) {
                    this.scope.addVariable(this.argsArray);
                    this.argsArray.setParameter(true);
                    this.argsArray.setArtificial(true);
                }
                if (object4 == null) break;
                object3 = ((Declaration)object4).var;
                if (((Declaration)object4).isSimple() && !((Declaration)object4).isIndirectBinding()) {
                    object3 = ((Declaration)object4).allocateVariable(null);
                } else {
                    object2 = Compilation.mangleName(((Declaration)object4).getName()).intern();
                    ((Declaration)object4).var = this.scope.addVariable(null, ((Declaration)object4).getType(), (String)object2);
                    object3 = ((Declaration)object4).var;
                    ((Variable)object3).setArtificial(true);
                    ((Variable)object3).setParameter(true);
                }
                object4 = ((Declaration)object4).nextDecl();
            }
        }
        this.declareClosureEnv();
        object5 = this.firstChild;
        while (object5 != null) {
            if (!((LambdaExp)object5).getInlineOnly() && ((LambdaExp)object5).isClassGenerated()) {
                compilation.allocClass((LambdaExp)object5);
            }
            object5 = ((LambdaExp)object5).nextSibling;
        }
        this.allocFrame(compilation);
        if (this.getNeedsClosureEnv() && this.isClassGenerated()) {
            object4 = this.outerLambda();
            object3 = ((LambdaExp)object4).heapFrameLambda;
            if (!(object4 instanceof ObjectExp) && object3 != this) {
                if (object3 != null) {
                    object2 = ((LambdaExp)object3).getCompiledClassType(compilation);
                    this.closureEnvField = compilation.curClass.addField("closureEnv", (Type)object2);
                } else if (((LambdaExp)object4).getNeedsStaticLink()) {
                    this.closureEnvField = compilation.curClass.addField("closureEnv", ((LambdaExp)object4).closureEnv.getType());
                }
            }
        }
        object4 = this.firstChild;
        while (object4 != null) {
            if (((LambdaExp)object4).isClassGenerated()) {
                if (((LambdaExp)object4).min_args != ((LambdaExp)object4).max_args || ((LambdaExp)object4).min_args > 4 || ((LambdaExp)object4).isHandlingTailCalls()) {
                    ((LambdaExp)object4).argsArray = new Variable("argsArray", Compilation.objArrayType);
                    ((LambdaExp)object4).firstArgsArrayArg = ((ScopeExp)object4).firstDecl();
                }
            } else if (!((LambdaExp)object4).getInlineOnly()) {
                if (!((LambdaExp)object4).getNeedsClosureEnv()) {
                    object2 = null;
                } else {
                    LambdaExp lambdaExp = this;
                    while (lambdaExp.heapFrame == null) {
                        lambdaExp = lambdaExp.outerLambda();
                    }
                    object2 = (ClassType)lambdaExp.heapFrame.getType();
                }
                ((LambdaExp)object4).addMethodFor(compilation, (ObjectType)object2);
            }
            object4 = ((LambdaExp)object4).nextSibling;
        }
    }

    Field allocFieldFor(Compilation compilation) {
        if (this.nameDecl != null && this.nameDecl.field != null) {
            return this.nameDecl.field;
        }
        String string = this.getName();
        String string2 = string == null ? "lambda" : Compilation.mangleName(string);
        int n = 16;
        if (this.nameDecl != null && this.nameDecl.context instanceof ModuleExp) {
            if (this.nameDecl.getFlag(2048)) {
                n |= 8;
            }
            if (!this.nameDecl.isPrivate()) {
                n |= 1;
            }
        } else {
            string2 = String.valueOf(string2) + "$Fn" + ++compilation.localFieldIndex;
        }
        ClassType classType = Compilation.getMethodProcType(compilation.mainClass);
        Field field = compilation.mainClass.addField(string2, classType, n);
        if (this.nameDecl != null) {
            this.nameDecl.field = field;
        }
        return field;
    }

    public void allocFrame(Compilation compilation) {
        if (this.heapFrame != null) {
            ClassType classType;
            if (this instanceof ModuleExp) {
                classType = this.getCompiledClassType(compilation);
            } else if (this.heapFrameLambda != null) {
                classType = this.heapFrameLambda.getCompiledClassType(compilation);
            } else {
                classType = new ClassType(compilation.generateClassName("frame"));
                classType.setSuper(Type.pointer_type);
                compilation.addClass(classType);
            }
            this.heapFrame.setType(classType);
        }
    }

    void allocParameters(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        int n = 0;
        int n2 = 0;
        codeAttr.locals.enterScope(this.scope);
        if (this.argsArray != null && this.isHandlingTailCalls()) {
            codeAttr.emitLoad(compilation.callStackContext);
            codeAttr.emitGetField(Compilation.argsCallStackField);
            codeAttr.emitStore(this.argsArray);
        }
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            Variable variable = declaration.var;
            if (this.argsArray != null && this.min_args == this.max_args && this.primMethods == null && !this.isHandlingTailCalls()) {
                codeAttr.emitLoad(this.argsArray);
                codeAttr.emitPushInt(n2);
                codeAttr.emitArrayLoad(Type.pointer_type);
                declaration.getType().emitCoerceFromObject(codeAttr);
                codeAttr.emitStore(declaration.getVariable());
            }
            ++n2;
            ++n;
            declaration = declaration.nextDecl();
        }
        if (this.heapFrame != null) {
            this.heapFrame.allocateLocal(codeAttr);
        }
    }

    public ClassType compile(Compilation compilation) {
        ClassType classType = compilation.curClass;
        Method method = compilation.method;
        Variable variable = compilation.callStackContext;
        try {
            ClassType classType2 = compilation.addClass(this);
            Object var7_6 = null;
            compilation.curClass = classType;
            compilation.method = method;
            compilation.callStackContext = variable;
            return classType2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            compilation.curClass = classType;
            compilation.method = method;
            compilation.callStackContext = variable;
            throw throwable;
        }
    }

    public void compile(Compilation compilation, Target target) {
        Type type;
        if (target instanceof IgnoreTarget) {
            return;
        }
        if (this.getInlineOnly()) {
            throw new Error("internal error: compile called for inlineOnly LambdaExp");
        }
        LambdaExp lambdaExp = this.outerLambda();
        CodeAttr codeAttr = compilation.getCode();
        if (!this.isClassGenerated()) {
            type = Compilation.typeModuleMethod;
            if ((this.flags & 0x100) != 0) {
                this.compileAsMethod(compilation);
                ProcInitializer.emitLoadModuleMethod(this, compilation);
            } else {
                Field field = this.compileSetField(compilation);
                if (field.getStaticFlag()) {
                    codeAttr.emitGetStatic(field);
                } else {
                    codeAttr.emitPushThis();
                    codeAttr.emitGetField(field);
                }
            }
        } else if (lambdaExp != null && lambdaExp.heapFrameLambda == this) {
            codeAttr.emitLoad(lambdaExp.heapFrame);
            type = lambdaExp.heapFrame.getType();
        } else {
            type = this.compileAlloc(compilation);
        }
        target.compileFromStack(compilation, type);
    }

    public ClassType compileAlloc(Compilation compilation) {
        ClassType classType = this.compile(compilation);
        CodeAttr codeAttr = compilation.getCode();
        codeAttr.emitNew(classType);
        codeAttr.emitDup(classType);
        codeAttr.emitInvokeSpecial(classType.constructor);
        if (this.closureEnvField != null) {
            codeAttr.emitDup(classType);
            LambdaExp lambdaExp = this.outerLambda();
            codeAttr.emitLoad(lambdaExp.heapFrame != null ? lambdaExp.heapFrame : lambdaExp.closureEnv);
            codeAttr.emitPutField(this.closureEnvField);
        }
        if (this.name != null && !(this instanceof ObjectExp)) {
            if (setNameMethod == null) {
                setNameMethod = Compilation.typeProcedure.getDeclaredMethod("setName", 1);
            }
            codeAttr.emitDup(classType);
            codeAttr.emitPushString(this.name);
            codeAttr.emitInvokeVirtual(setNameMethod);
        }
        return classType;
    }

    void compileAsMethod(Compilation compilation) {
        int n;
        if ((this.flags & 0x80) != 0) {
            return;
        }
        this.flags |= 0x80;
        Method method = compilation.method;
        LambdaExp lambdaExp = compilation.curLambda;
        compilation.curLambda = this;
        Method method2 = this.primMethods[0];
        boolean bl = method2.getStaticFlag();
        Type type = method2.getReturnType();
        Target target = Target.returnValue(type);
        int n2 = this.primMethods.length - 1;
        Type type2 = this.restArgType();
        int[] nArray = null;
        if (n2 > 0) {
            nArray = new int[this.min_args + n2];
            n = 0;
            Declaration declaration = this.firstDecl();
            while (n < this.min_args + n2) {
                nArray[n++] = declaration.flags;
                declaration = declaration.nextDecl();
            }
        }
        n = 0;
        while (n <= n2) {
            compilation.method = this.primMethods[n];
            if (n < n2) {
                Object object2;
                compilation.method.init_param_slots();
                CodeAttr codeAttr = compilation.getCode();
                int n3 = n + 1;
                while (n3 < n2 && this.defaultArgs[n3] instanceof QuoteExp) {
                    ++n3;
                }
                boolean bl2 = !bl;
                boolean bl3 = n3 == n2 && type2 != null;
                Variable variable = codeAttr.getArg(0);
                if (!bl) {
                    codeAttr.emitPushThis();
                    if (this.getNeedsClosureEnv()) {
                        this.closureEnv = variable;
                    }
                    variable = codeAttr.getArg(1);
                }
                Declaration declaration = this.firstDecl();
                int n4 = 0;
                while (n4 < this.min_args + n) {
                    declaration.flags |= 0x40;
                    declaration.var = variable;
                    codeAttr.emitLoad(variable);
                    variable = variable.nextVar();
                    ++n4;
                    declaration = declaration.nextDecl();
                }
                int n5 = n;
                while (n5 < n3) {
                    object2 = StackTarget.getInstance(declaration.getType());
                    this.defaultArgs[n5].compile(compilation, (Target)object2);
                    ++n5;
                    declaration = declaration.nextDecl();
                }
                if (bl3) {
                    String string = type2.getName();
                    if ("gnu.kawa.util.LList".equals(string)) {
                        object2 = new QuoteExp(LList.Empty);
                    } else if ("java.lang.Object[]".equals(string)) {
                        object2 = new QuoteExp(Values.noArgs);
                    } else {
                        throw new Error("unimplemented #!rest type");
                    }
                    ((Expression)object2).compile(compilation, type2);
                }
                if (bl) {
                    codeAttr.emitInvokeStatic(this.primMethods[n3]);
                } else {
                    codeAttr.emitInvokeVirtual(this.primMethods[n3]);
                }
                codeAttr.emitReturn();
                this.closureEnv = null;
            } else {
                if (nArray != null) {
                    int n6 = 0;
                    Declaration declaration = this.firstDecl();
                    while (n6 < this.min_args + n2) {
                        declaration.flags = nArray[n6++];
                        declaration.var = null;
                        declaration = declaration.nextDecl();
                    }
                }
                compilation.method.initCode();
                this.allocChildClasses(compilation);
                this.allocParameters(compilation);
                this.enterFunction(compilation);
                this.body.compileWithPosition(compilation, target);
                this.compileEnd(compilation);
            }
            ++n;
        }
        this.compileChildMethods(compilation);
        compilation.method = method;
        compilation.curLambda = lambdaExp;
    }

    void compileChildMethods(Compilation compilation) {
        LambdaExp lambdaExp = this.firstChild;
        while (lambdaExp != null) {
            if (!(lambdaExp.getCanRead() || lambdaExp.getInlineOnly() || lambdaExp.isHandlingTailCalls())) {
                lambdaExp.compileAsMethod(compilation);
            }
            lambdaExp = lambdaExp.nextSibling;
        }
    }

    public void compileEnd(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        if (compilation.method.reachableHere() && !this.isHandlingTailCalls()) {
            codeAttr.emitReturn();
        }
        codeAttr.popScope();
        if (!Compilation.fewerClasses) {
            codeAttr.popScope();
        }
    }

    public Field compileSetField(Compilation compilation) {
        this.compileAsMethod(compilation);
        compilation.applyMethods.addElement(this);
        return new ProcInitializer((LambdaExp)this, (Compilation)compilation).field;
    }

    public Variable declareClosureEnv() {
        if (this.closureEnv == null && this.getNeedsClosureEnv()) {
            Variable variable;
            LambdaExp lambdaExp = this.outerLambda();
            if (lambdaExp instanceof ObjectExp) {
                lambdaExp = lambdaExp.outerLambda();
            }
            Variable variable2 = variable = lambdaExp.heapFrame != null ? lambdaExp.heapFrame : lambdaExp.closureEnv;
            if (lambdaExp.heapFrameLambda == this || this.isClassMethod()) {
                this.closureEnv = this.declareThis(this.type);
            } else if (lambdaExp.heapFrame == null && !lambdaExp.getNeedsStaticLink() && !(lambdaExp instanceof ModuleExp)) {
                this.closureEnv = null;
            } else if (!this.isClassGenerated() && !this.getInlineOnly()) {
                Method method = this.getMainMethod();
                if (!method.getStaticFlag()) {
                    this.closureEnv = this.declareThis(method.getDeclaringClass());
                } else {
                    Type type = method.getParameterTypes()[0];
                    this.closureEnv = new Variable("closureEnv", type);
                    this.scope.addVariableAfter(null, this.closureEnv);
                    this.closureEnv.setArtificial(true);
                    this.closureEnv.setParameter(true);
                }
            } else {
                LambdaExp lambdaExp2;
                LambdaExp lambdaExp3 = lambdaExp2 = this.getInlineOnly() ? this.getCaller() : null;
                if (lambdaExp == lambdaExp2) {
                    this.closureEnv = variable;
                } else if (lambdaExp2 != null && lambdaExp == lambdaExp2.outerLambdaNotInline()) {
                    this.closureEnv = lambdaExp2.closureEnv;
                } else {
                    this.closureEnv = new Variable("closureEnv", variable.getType());
                    this.scope.addVariable(this.closureEnv);
                    this.closureEnv.setArtificial(true);
                }
            }
        }
        return this.closureEnv;
    }

    public Variable declareThis(ClassType classType) {
        if (this.thisVariable == null) {
            this.thisVariable = new Variable("this");
            this.scope.addVariableAfter(null, this.thisVariable);
            this.thisVariable.setParameter(true);
            this.thisVariable.setArtificial(true);
        }
        if (this.thisVariable.getType() == null) {
            this.thisVariable.setType(classType);
        }
        return this.thisVariable;
    }

    void enterFunction(Compilation compilation) {
        int n;
        int n2;
        Object object2;
        CodeAttr codeAttr = compilation.getCode();
        this.scope.setStartPC(codeAttr.getPC());
        if (this.closureEnv != null && !this.closureEnv.isParameter() && !this.getInlineOnly()) {
            codeAttr.emitPushThis();
            object2 = this.closureEnvField;
            if (object2 == null) {
                object2 = this.outerLambda().closureEnvField;
            }
            codeAttr.emitGetField((Field)object2);
            codeAttr.emitStore(this.closureEnv);
        }
        if (this.heapFrame != null && !Compilation.usingCPStyle()) {
            Object object3;
            object2 = (ClassType)this.heapFrame.getType();
            Declaration declaration = this.capturedVars;
            while (declaration != null) {
                if (declaration.field == null) {
                    Object object4;
                    object3 = Compilation.mangleName(declaration.getName());
                    String string = object3;
                    n2 = 0;
                    while ((object4 = ((ClassType)object2).getField(string)) != null) {
                        string = String.valueOf(object3) + '_' + ++n2;
                    }
                    object4 = declaration.getType();
                    declaration.field = ((ClassType)object2).addField(string, declaration.getType());
                }
                declaration = declaration.nextCapturedVar;
            }
            if (this.closureEnv != null && this.heapFrame != null) {
                this.staticLinkField = ((ClassType)object2).addField("staticLink", this.closureEnv.getType());
            }
            if (!(this instanceof ModuleExp)) {
                if (this.heapFrameLambda != null) {
                    this.heapFrameLambda.compileAlloc(compilation);
                } else {
                    codeAttr.emitNew((ClassType)object2);
                    codeAttr.emitDup((Type)object2);
                    object3 = compilation.generateConstructor((ClassType)object2, null);
                    codeAttr.emitInvokeSpecial((Method)object3);
                }
                if (this.staticLinkField != null) {
                    codeAttr.emitDup(this.heapFrame.getType());
                    codeAttr.emitLoad(this.closureEnv);
                    codeAttr.emitPutField(this.staticLinkField);
                }
                codeAttr.emitStore(this.heapFrame);
            }
        }
        object2 = this.argsArray;
        if (this.min_args == this.max_args && !Compilation.fewerClasses && this.primMethods == null && !this.isHandlingTailCalls()) {
            object2 = null;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        n2 = this.keywords == null ? 0 : this.keywords.length;
        int n6 = n = this.defaultArgs == null ? 0 : this.defaultArgs.length - n2;
        if (this instanceof ModuleExp) {
            return;
        }
        int n7 = -1;
        int n8 = 0;
        Method method = this.getMainMethod();
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            if (declaration == this.firstArgsArrayArg && object2 != null) {
                if (this.primMethods != null) {
                    n7 = n3;
                    n8 = n7 - this.min_args;
                } else {
                    n7 = 0;
                    n8 = 0;
                }
            }
            if (n7 >= 0 || !declaration.isSimple() || declaration.isIndirectBinding()) {
                ClassType classType;
                Type type = declaration.getType();
                Type type2 = classType = method == null || n7 >= 0 ? Type.pointer_type : method.getParameterTypes()[n3];
                if (!declaration.isSimple()) {
                    declaration.loadOwningObject(compilation);
                }
                if (n7 < 0) {
                    codeAttr.emitLoad(declaration.getVariable());
                } else if (n3 < this.min_args) {
                    codeAttr.emitLoad((Variable)object2);
                    codeAttr.emitPushInt(n3);
                    codeAttr.emitArrayLoad(Type.pointer_type);
                } else if (n3 < this.min_args + n) {
                    codeAttr.emitPushInt(n3 - n7);
                    codeAttr.emitLoad((Variable)object2);
                    codeAttr.emitArrayLength();
                    codeAttr.emitIfIntLt();
                    codeAttr.emitLoad((Variable)object2);
                    codeAttr.emitPushInt(n3 - n7);
                    codeAttr.emitArrayLoad(Type.pointer_type);
                    codeAttr.emitElse();
                    this.defaultArgs[n8 + n4++].compile(compilation, type);
                    codeAttr.emitFi();
                } else if (this.max_args < 0 && n3 == this.min_args + n) {
                    codeAttr.emitLoad((Variable)object2);
                    codeAttr.emitPushInt(n3 - n7);
                    codeAttr.emitInvokeStatic(Compilation.makeListMethod);
                    classType = Compilation.scmListType;
                } else {
                    Type[] typeArray;
                    codeAttr.emitLoad((Variable)object2);
                    codeAttr.emitPushInt(this.min_args + n - n7);
                    compilation.compileConstant(this.keywords[n5++]);
                    Expression expression = this.defaultArgs[n8 + n4++];
                    if (expression instanceof QuoteExp) {
                        if (searchForKeywordMethod4 == null) {
                            typeArray = new Type[]{Compilation.objArrayType, Type.int_type, Type.pointer_type, Type.pointer_type};
                            searchForKeywordMethod4 = Compilation.scmKeywordType.addMethod("searchForKeyword", typeArray, Type.pointer_type, 9);
                        }
                        expression.compile(compilation, type);
                        codeAttr.emitInvokeStatic(searchForKeywordMethod4);
                    } else {
                        if (searchForKeywordMethod3 == null) {
                            typeArray = new Type[]{Compilation.objArrayType, Type.int_type, Type.pointer_type};
                            searchForKeywordMethod3 = Compilation.scmKeywordType.addMethod("searchForKeyword", typeArray, Type.pointer_type, 9);
                        }
                        codeAttr.emitInvokeStatic(searchForKeywordMethod3);
                        codeAttr.emitDup(1);
                        compilation.compileConstant(Special.dfault);
                        codeAttr.emitIfEq();
                        codeAttr.emitPop(1);
                        expression.compile(compilation, type);
                        codeAttr.emitFi();
                    }
                }
                if (type != classType) {
                    CheckedTarget.emitCheckedCoerce(compilation, this, n3, type);
                }
                if (declaration.isIndirectBinding()) {
                    declaration.pushIndirectBinding(compilation);
                }
                if (declaration.isSimple()) {
                    codeAttr.emitStore(declaration.getVariable());
                } else {
                    codeAttr.emitPutField(declaration.field);
                }
            }
            ++n3;
            declaration = declaration.nextDecl();
        }
    }

    public Object eval(Environment environment) {
        if (this.thisValue != null) {
            return this.thisValue;
        }
        try {
            Class clazz = this.evalToClass();
            Object t = clazz.newInstance();
            Procedure procedure = (Procedure)t;
            if (procedure.getName() == null) {
                procedure.setName(this.name);
            }
            this.thisValue = procedure;
            return t;
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("class not instantiable: in lambda eval");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("class illegal access: in lambda eval");
        }
    }

    public Class evalToClass() {
        try {
            Object object2;
            Object object3;
            Object object4;
            String string = this.getJavaName();
            Compilation compilation = new Compilation(this, string, null, true);
            byte[][] byArray = new byte[compilation.numClasses][];
            String[] stringArray = new String[compilation.numClasses];
            int n = 0;
            while (n < compilation.numClasses) {
                object4 = compilation.classes[n];
                stringArray[n] = ((Type)object4).getName();
                byArray[n] = ((ClassType)object4).writeToArray();
                ++n;
            }
            if (dumpZipPrefix != null) {
                object4 = new StringBuffer(dumpZipPrefix);
                if (dumpZipCounter >= 0) {
                    ((StringBuffer)object4).append(++dumpZipCounter);
                }
                ((StringBuffer)object4).append(".zip");
                object3 = new FileOutputStream(((StringBuffer)object4).toString());
                object2 = new ZipOutputStream((OutputStream)object3);
                int n2 = 0;
                while (n2 < compilation.numClasses) {
                    String string2 = String.valueOf(stringArray[n2].replace('.', '/')) + ".class";
                    ZipEntry zipEntry = new ZipEntry(string2);
                    zipEntry.setSize(byArray[n2].length);
                    CRC32 cRC32 = new CRC32();
                    cRC32.update(byArray[n2]);
                    zipEntry.setCrc(cRC32.getValue());
                    zipEntry.setMethod(0);
                    ((ZipOutputStream)object2).putNextEntry(zipEntry);
                    ((FilterOutputStream)object2).write(byArray[n2]);
                    ++n2;
                }
                ((ZipOutputStream)object2).close();
            }
            object4 = new ArrayClassLoader(stringArray, byArray);
            object3 = ((ArrayClassLoader)object4).loadClass(string, true);
            object2 = compilation.literalsChain;
            while (object2 != null) {
                try {
                    ((Class)object3).getDeclaredField(((Literal)object2).field.getName()).set(null, ((Literal)object2).value);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new Error("internal error - " + noSuchFieldException);
                }
                object2 = ((Literal)object2).next;
            }
            return object3;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(OutPort.errDefault());
            throw new RuntimeException("I/O error in lambda eval: " + iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("class not found in lambda eval");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("class illegal access: in lambda eval");
        }
    }

    Declaration getArg(int n) {
        Declaration declaration = this.firstDecl();
        while (true) {
            if (declaration == null) {
                throw new Error("internal error - getArg");
            }
            if (n == 0) {
                return declaration;
            }
            --n;
            declaration = declaration.nextDecl();
        }
    }

    public LambdaExp getCaller() {
        return this.returnContinuation.context;
    }

    public final boolean getCanCall() {
        return (this.flags & 4) != 0;
    }

    public final boolean getCanRead() {
        return (this.flags & 2) != 0;
    }

    public ClassType getCompiledClassType(Compilation compilation) {
        if (this.type == Compilation.typeProcedure) {
            throw new Error("internal error: getCompileClassType");
        }
        return this.type;
    }

    public final boolean getImportsLexVars() {
        return (this.flags & 8) != 0;
    }

    public final boolean getInlineOnly() {
        return (this.flags & 1) != 0;
    }

    public String getJavaName() {
        return this.name == null ? "lambda" : Compilation.mangleName(this.name);
    }

    public final Method getMainMethod() {
        Method[] methodArray = this.primMethods;
        return methodArray == null ? null : methodArray[methodArray.length - 1];
    }

    public final Method getMethod(int n) {
        if (this.primMethods == null || this.max_args >= 0 && n > this.max_args) {
            return null;
        }
        int n2 = n - this.min_args;
        if (n2 < 0) {
            return null;
        }
        int n3 = this.primMethods.length;
        return this.primMethods[n2 < n3 ? n2 : n3 - 1];
    }

    public String getName() {
        return this.name;
    }

    public final boolean getNeedsClosureEnv() {
        return (this.flags & 0x18) != 0;
    }

    public final boolean getNeedsStaticLink() {
        return (this.flags & 0x10) != 0;
    }

    public Object getProperty(Object object2, Object object3) {
        if (this.properties != null) {
            int n = this.properties.length;
            while ((n -= 2) >= 0) {
                if (this.properties[n] != object2) continue;
                return this.properties[n + 1];
            }
        }
        return object3;
    }

    int getSelectorValue(Compilation compilation) {
        if (this.selectorValue == 0) {
            this.selectorValue = ++compilation.maxSelectorValue;
        }
        return this.selectorValue;
    }

    public Type getType() {
        return this.type;
    }

    public int incomingArgs() {
        return this.min_args == this.max_args && this.max_args <= 4 && this.max_args > 0 ? this.max_args : 1;
    }

    public final boolean isClassGenerated() {
        return !this.getInlineOnly() && (this.isHandlingTailCalls() || this.isModuleBody() || this instanceof ObjectExp || !this.outerLambda().isModuleBody() && this.getCanRead());
    }

    public final boolean isClassMethod() {
        return (this.flags & 0x40) != 0;
    }

    public final boolean isHandlingTailCalls() {
        return Compilation.usingTailCalls && !this.isModuleBody() && !this.isClassMethod();
    }

    public final boolean isModuleBody() {
        return this instanceof ModuleExp;
    }

    public void loadHeapFrame(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        LambdaExp lambdaExp = compilation.curLambda;
        while (lambdaExp != this && lambdaExp.getInlineOnly()) {
            lambdaExp = lambdaExp.returnContinuation.context;
        }
        if (this == lambdaExp) {
            if (this.heapFrame == null) {
                codeAttr.emitPushThis();
            } else {
                codeAttr.emitLoad(this.heapFrame);
            }
        } else {
            codeAttr.emitLoad(lambdaExp.closureEnv);
            LambdaExp lambdaExp2 = lambdaExp.outerLambda();
            while (lambdaExp2 != this) {
                if (lambdaExp2.staticLinkField != null) {
                    codeAttr.emitGetField(lambdaExp2.staticLinkField);
                }
                lambdaExp2 = lambdaExp2.outerLambda();
            }
        }
    }

    public LambdaExp outerLambda() {
        return this.outer == null ? null : this.outer.currentLambda();
    }

    public LambdaExp outerLambdaNotInline() {
        ScopeExp scopeExp = this;
        while ((scopeExp = scopeExp.outer) != null) {
            ScopeExp scopeExp2;
            if (!(scopeExp instanceof LambdaExp) || ((LambdaExp)(scopeExp2 = scopeExp)).getInlineOnly()) continue;
            return scopeExp2;
        }
        return null;
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("(#%lambda/");
        if (this.name != null) {
            printWriter.print(this.name);
            printWriter.print('/');
        }
        printWriter.print(this.id);
        printWriter.print("/ (");
        Special special = null;
        int n = 0;
        int n2 = 0;
        int n3 = this.keywords == null ? 0 : this.keywords.length;
        int n4 = this.defaultArgs == null ? 0 : this.defaultArgs.length - n3;
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            Special special2 = n < this.min_args ? null : (n < this.min_args + n4 ? Special.optional : (this.max_args < 0 && n == this.min_args + n4 ? Special.rest : Special.key));
            if (n > 0) {
                printWriter.print(' ');
            }
            if (special2 != special) {
                printWriter.print(special2);
                printWriter.print(' ');
            }
            Expression expression = null;
            if (special2 == Special.optional || special2 == Special.key) {
                expression = this.defaultArgs[n2++];
            }
            if (expression != null) {
                printWriter.print('(');
            }
            printWriter.print(declaration.getName());
            if (expression != null && expression != QuoteExp.falseExp) {
                printWriter.print(' ');
                expression.print(printWriter);
                printWriter.print(')');
            }
            ++n;
            special = special2;
            declaration = declaration.nextDecl();
        }
        printWriter.print(") ");
        if (this.body == null) {
            printWriter.print("<null body>");
        } else {
            this.body.print(printWriter);
        }
        printWriter.print(")");
    }

    public final Type restArgType() {
        if (this.min_args == this.max_args) {
            return null;
        }
        if (this.primMethods == null) {
            throw new Error("internal error - restArgType");
        }
        Method[] methodArray = this.primMethods;
        if (this.max_args >= 0 && methodArray.length > this.max_args - this.min_args) {
            return null;
        }
        Type[] typeArray = methodArray[methodArray.length - 1].getParameterTypes();
        return typeArray[typeArray.length - 1];
    }

    void setCallersNeedStaticLink() {
        LambdaExp lambdaExp = this.outerLambda();
        ApplyExp applyExp = this.nameDecl.firstCall;
        while (applyExp != null) {
            LambdaExp lambdaExp2 = applyExp.context;
            while (lambdaExp2 != lambdaExp) {
                lambdaExp2.setNeedsStaticLink();
                lambdaExp2 = lambdaExp2.outerLambda();
            }
            applyExp = applyExp.nextCall;
        }
    }

    public final void setCanCall(boolean bl) {
        this.flags = bl ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public final void setCanRead(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public final void setClassMethod(boolean bl) {
        this.flags = bl ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
    }

    public final void setImportsLexVars() {
        int n = this.flags;
        this.flags |= 8;
        if ((n & 8) == 0 && this.nameDecl != null) {
            this.setCallersNeedStaticLink();
        }
    }

    public final void setImportsLexVars(boolean bl) {
        this.flags = bl ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public final void setInlineOnly(boolean bl) {
        this.setFlag(bl, 1);
    }

    public void setName(String string) {
        this.name = string;
    }

    public final void setNeedsStaticLink() {
        int n = this.flags;
        this.flags |= 0x10;
        if ((n & 0x10) == 0 && this.nameDecl != null) {
            this.setCallersNeedStaticLink();
        }
    }

    public final void setNeedsStaticLink(boolean bl) {
        this.flags = bl ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public synchronized void setProperty(Object object2, Object object3) {
        this.properties = Procedure.setProperty(this.properties, object2, object3);
    }

    public String toString() {
        String string = "LambdaExp/" + this.name + '/' + this.id + '/';
        int n = this.getLine();
        if (n <= 0 && this.body != null) {
            n = this.body.getLine();
        }
        if (n > 0) {
            string = String.valueOf(string) + "l:" + n;
        }
        return string;
    }

    public final boolean variable_args() {
        return this.max_args < 0;
    }

    Object walk(ExpWalker expWalker) {
        return expWalker.walkLambdaExp(this);
    }
}

