#ifndef _SVINEPALSEN_H_
#define _SVINEPALSEN_H_

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#include <sstream>
#include <string>

#include <SDL.h>
#include <SDL_mixer.h>
#include <SDL_image.h>
#include <SDL_ttf.h>
#include <smpeg.h>

#include "CSprite.h"
#include "CSpriteBase.h"
#include "CBigBoom.h"
#include "CEnemyBase.h"

#define BULLETS 5
#define MINISHIP_BULLETS 40
#define ENEMIES 10
#define BOUND_LOW_Y 540
#define BOUND_UP_Y 0
#define BOUND_LEFT_X 0
#define BOUND_RIGHT_X 720

//extern "C" char* gethighscore();

class Svinepalsen {
	//friend CEnemyBase;
	
	public:
		Svinepalsen();
		~Svinepalsen();
	
		short int Sprite_Collide(CSprite &object1, CSprite &object2);
		SDL_Surface * ImageLoad(char *file);
		void DrawIMG(SDL_Surface *img, int x, int y);
		void DrawIMG(SDL_Surface *img, int x, int y, int w, int h, int x2, int y2);
		void DrawScroll();
		void initOpeningScreen();
		char* tostring(int i);
		std::string itos(int arg);
		static void musicDone();
		void initAudio();
		void toggleMusic();
		void playMovie();
		void addBullet();
		void miniship_addBullet();
		void DrawScene();
		void setVideoMode(int setting);
		int mainGame(int argc, char *argv[]);
			
		SDL_Surface *screen;
		float sdlgt;							// Stores the time that has passed
		float dt;									// The time that has elapsed since the previous frame
		int gameover, exploding, score, life, lives;
		CSpriteBase bulletbase;   // The Bullet sprite's base
		CSprite bullets[BULLETS]; // Individual bullets
		int bdraw[BULLETS];       // Shows which elements of the bullets array are in use
		
		CSpriteBase mainship_base;
		CSprite mainship;
		
	private:
		SDL_Surface *back, *smallship, *score_text_surface;
		TTF_Font *ttf_font;
		SDL_Color white;
		SDL_Color shifting;
		SDL_Rect score_text_rect;
		
		SMPEG* mpeg;
		SMPEG_Info mpeg_info;
		
		CEnemyBase alienarmy00;
		CBigBoom enemyBoom;
		
		Mix_Music *music;
		Mix_Chunk *phaser;
		Mix_Chunk *piriphaser;
		
		int td,td2;								// Used when checking the time difference (how much time has passed since last frame)
		int colorspeed;
		
		bool evenodd;
		CSpriteBase miniship_bulletbase;
		CSprite miniship_bullets[MINISHIP_BULLETS];
		int miniship_bdraw[MINISHIP_BULLETS];
		
		float scroll;							// How much has the screen scrolled
		char scorestring[16];
};


#endif 
