/* Copyright (c) 2002 Jonas Jensen. All rights reserved.

This file is part of Svinepalsen.

Svinepalsen is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Svinepalsen is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details. */

#include "svinepalsen.h"

Svinepalsen::Svinepalsen() {
	white.r = 0xFF; white.g = 0xFF; white.b = 0xFF; 
	shifting.r = 204; shifting.g = 44; shifting.b = 44; 
	music = NULL; phaser = NULL; piriphaser = NULL;
	colorspeed = 2; sdlgt = 0; dt = 0; gameover = 0; exploding = 0; td = 0; td2 = 0;
	evenodd = false;
	scroll = 0;
	score = 0;
	life = 250;
	lives = 5;
}

Svinepalsen::~Svinepalsen() {
}

struct circlethingie {
  double x,y,dv;
};
struct circlethingie circle;

short int Svinepalsen::Sprite_Collide(CSprite &object1, CSprite &object2) {
  double left1, left2;
  double right1, right2;
  double top1, top2;
  double bottom1, bottom2;

  left1 =   object1.getx()+object1.getw()*0.1;
  left2 =   object2.getx()+object2.getw()*0.1;
  top1 =    object1.gety()+object1.geth()*0.1;
  top2 =    object2.gety()+object2.geth()*0.1;
  right1 =  object1.getx()+object1.getw()*0.9;
  right2 =  object2.getx()+object2.getw()*0.9;
  bottom1 = object1.gety()+object1.geth()*0.9;
  bottom2 = object2.gety()+object2.geth()*0.9;

  if (bottom1 < top2) return 0;
  if (top1 > bottom2) return 0;
  if (right1 < left2) return 0;
  if (left1 > right2) return 0;

  return 1;
};

SDL_Surface * Svinepalsen::ImageLoad(char *file) {
  SDL_Surface *temp1, *temp2;
  temp1 = IMG_Load(file);
  temp2 = SDL_DisplayFormatAlpha(temp1);
  SDL_FreeSurface(temp1);
  return temp2;
}

void Svinepalsen::DrawIMG(SDL_Surface *img, int x, int y) {
  SDL_Rect dest;
  dest.x = x;
  dest.y = y;
  SDL_BlitSurface(img, NULL, screen, &dest);
}

void Svinepalsen::DrawIMG(SDL_Surface *img, int x, int y, int w, int h, int x2, int y2) {
  SDL_Rect dest;
  dest.x = x;
  dest.y = y;
  SDL_Rect dest2;
  dest2.x = x2;
  dest2.y = y2;
  dest2.w = w;
  dest2.h = h;
  SDL_BlitSurface(img, &dest2, screen, &dest);
}

void Svinepalsen::DrawScroll() {
  if(scroll>3907-600) {
    DrawIMG(back, 0,0,800,(int)(3907-scroll),0,(int)scroll);
    DrawIMG(back, 0,(int)(3907-scroll-1),800,(int)(600-(3907-scroll)),0,0);
  } 
  else {
    DrawIMG(back, 0,0,800,600,0,(int)scroll);
  }
}

void Svinepalsen::initOpeningScreen() {
  SDL_Rect rectang;
  SDL_Surface *openingLogo;
  openingLogo = IMG_Load("data/art/svinepalsen_biglogo02.png");
  
  rectang.x = 0;
  rectang.y = 180;
  rectang.w = 80;
  rectang.h = 50;
  //SDL_FillRect(screen,0,SDL_MapRGB(screen->format,white.r,white.g,white.b));
  SDL_FillRect(screen,0,0);
  SDL_BlitSurface(openingLogo, NULL, screen, &rectang);
  SDL_Flip(screen);
  SDL_Delay(1000);
}

char* Svinepalsen::tostring(int i) {
  static char buffer[20];
  snprintf(buffer,20,"%d",i);
  return buffer;
}

std::string Svinepalsen::itos(int arg) {
  std::ostringstream buffer;
  buffer << arg; // send the int to the ostringstream
  return buffer.str(); // capture the string
}

void Svinepalsen::musicDone() {
  Mix_HaltMusic();
  //Mix_FreeMusic(music);
  //music = NULL;
}

void Svinepalsen::initAudio() {
  if(Mix_OpenAudio(44100, AUDIO_S16SYS, 2, 4096) < 0) {
    printf("Warning: Couldn't set 44100 Hz 16-bit audio\n- Reason: %s\n", SDL_GetError());
  } 
  /* Audio stuff for SMPEG */
  SDL_AudioSpec audiofmt;
  Uint16 format;
  int freq, channels;
  Mix_QuerySpec(&freq, &format, &channels);
  audiofmt.format = format;
  audiofmt.freq = freq;
  audiofmt.channels = channels;
  SMPEG_actualSpec(mpeg, &audiofmt);
  SMPEG_enableaudio(mpeg, 1);
  SMPEG_setdisplay( mpeg, screen, NULL, NULL );
}

void Svinepalsen::toggleMusic() {
  if(music == NULL) {
    music = Mix_LoadMUS("data/audio/accession4.mod"); //accession4.mod
    Mix_PlayMusic(music, -1);
    Mix_HookMusicFinished(&Svinepalsen::musicDone);
		
  }
  else {
    Mix_HaltMusic();
    Mix_FreeMusic(music);
    music = NULL;
  }
}

void Svinepalsen::playMovie() {
  Mix_HookMusic(SMPEG_playAudioSDL, mpeg);
  SMPEG_setdisplay( mpeg, screen, NULL, NULL );
  SMPEG_play(mpeg);
  
  while( SMPEG_status(mpeg) == SMPEG_PLAYING ) {
    SDL_Event event;
    while ( SDL_PollEvent(&event) ) {
      switch (event.type) {
        case SDL_KEYDOWN:
          if ( event.key.keysym.sym == SDLK_ESCAPE ) SMPEG_stop( mpeg );
          break;
        case SDL_MOUSEBUTTONDOWN:
          
        case SDL_QUIT:
          SMPEG_stop( mpeg );
          break;
      }
    }
    SDL_Delay(100);
  }
  SMPEG_rewind(mpeg);
  Mix_HookMusic(NULL, NULL);
}

void Svinepalsen::addBullet() {
  if (evenodd) {
    evenodd = false;
    for(int i=0;i<BULLETS;i++) {
      if(bdraw[i]==0) {
        bullets[i].set(mainship.getx()+33,mainship.gety()+23);
        bdraw[i]=1;
        break;
      }
    }
  }
  else {
    evenodd = true;
    for(int i=0;i<BULLETS;i++) {
      if(bdraw[i]==0) {
        bullets[i].set(mainship.getx()+9,mainship.gety()+23);
        bdraw[i]=1;
        break;
      }
    }
  }
}

void Svinepalsen::miniship_addBullet() {
  for(int i=0;i<MINISHIP_BULLETS;i++) {
    if(miniship_bdraw[i]==0) {
      miniship_bullets[i].set(circle.x+33,circle.y+23);
      miniship_bdraw[i]=1;
      Mix_PlayChannel(-1,piriphaser,0);
      break;
			//i = 10;
    }
  }
}

void Svinepalsen::DrawScene() {
  //SDL_FillRect(screen,0,234234234); //magenta for testing
  SDL_FillRect(screen,0,SDL_MapRGB(screen->format,0,0,0));
  //DrawScroll();
  
  if (life < 0) { life = 250; exploding = 1; mainship.set(400,25); }
  if (exploding > 0 && exploding < 1000) { exploding += (int)dt ; }
  else { exploding = 0; mainship.draw(); }
  
  
  if (shifting.g < 10 ) colorspeed = -colorspeed ;
  else if (shifting.g > 250 ) colorspeed = -colorspeed;
  shifting.g = shifting.g + colorspeed ;
      
  //sprintf(scorestring,"%d",score);
  score_text_surface = TTF_RenderText_Blended(ttf_font, tostring(score) , shifting);
  DrawIMG(score_text_surface,0,0);
  SDL_FreeSurface(score_text_surface);
  
  score_text_surface = TTF_RenderText_Blended(ttf_font, tostring(life), shifting);
  DrawIMG(score_text_surface,0,10); 
  SDL_FreeSurface(score_text_surface);
  
  if(lives>0) {
    for(int i=0;i<lives;i++) {
      DrawIMG(smallship,755-i*25,0);
    }
  }
  
	/*
  if(life>0) {
    for(int i=0;i<life/18;i++) {
      score_text_surface = TTF_RenderText_Blended(ttf_font, "I", shifting);
      //SDL_BlitSurface(score_text_surface, NULL, screen, &score_text_rect);
      SDL_FreeSurface(score_text_surface);
      DrawIMG(score_text_surface,-3+i*8,25);
    }
  }*/
  
  DrawIMG(smallship,(int)circle.x+20,(int)circle.y+10);
  
  for(int i=0;i<BULLETS;i++) {
    if(bdraw[i]==1) bullets[i].draw();
  }
  for(int i=0;i<MINISHIP_BULLETS;i++) {
    if(miniship_bdraw[i]==1) miniship_bullets[i].draw();
  }
  
  alienarmy00.drawOnScene();
  
  SDL_Flip(screen);
}

void Svinepalsen::setVideoMode(int setting) {
	screen=SDL_SetVideoMode(800,600,32,setting); 
  if ( screen == NULL ) {
    printf("Unable to set 800x600 video: %s\n", SDL_GetError());
    exit(1);
  }
}


int Svinepalsen::mainGame(int argc, char *argv[]) {
	srand(time(NULL));
  Uint8* keys;
  bool want_audio = true;
  char *font = NULL;
  char fontsize = 20;
	long frames, starttime;
  int MY_SDL_SCREENSETTINGS = SDL_FULLSCREEN | SDL_HWSURFACE | SDL_DOUBLEBUF;
	
	for (int i=0; i < argc; i++) {
    if(strcmp(argv[i],"--help") == 0) {
      printf("svinepalsen 2003-01-25, space shootemup arcade.\nUsage:\n svinepalsen [options]... [switches]...\n\nOptions:\n -noaudio      no audio\n -window       start in windowed mode\n\nSwitches:\n -font         change default font to specified file\n\nComments can be sent to jonas.jensen@bredband.net\n");
      exit(0);
    }
  }
  
  for (int i=0; i < argc; i++) {
    if(strcmp(argv[i],"-noaudio") == 0) {
      want_audio = false;
      printf("Got %s, skip sound\n", argv[i]);
    }
    if(strcmp(argv[i],"-window") == 0) {
      //MY_SDL_SCREENSETTINGS &= !SDL_FULLSCREEN;    //<-- this is very bad.. it sets everything to zero.
			MY_SDL_SCREENSETTINGS &= ~SDL_FULLSCREEN;
      printf("Got %s, starting windowed mode\n", argv[i]);
    }
    if(strcmp(argv[i],"-font") == 0 && argv[i+1] != NULL) {
      font = (char*)malloc(strlen(argv[i+1])+1);
      strcpy(font,argv[i+1]);
      printf("Font %s initialized\n", font);
    }    
  }
  
  if ( SDL_Init(SDL_INIT_AUDIO | SDL_INIT_VIDEO) == -1 ) {
    printf("Unable to init SDL: %s\n", SDL_GetError());
    exit(-1);
  }
  atexit(SDL_Quit);
	
	setVideoMode(MY_SDL_SCREENSETTINGS); 
	SDL_WM_SetCaption("Svinepalsen","");
	
  mpeg = SMPEG_new( "data/paperclip.mpg" , &mpeg_info, 0 );
  if( !mpeg ) {
    fprintf( stderr, "I'm not so sure about this mpgfile...\n" );
    SDL_Quit();
  }
  
  want_audio ? initAudio() : SMPEG_enableaudio(mpeg, 0);
  
  if ( TTF_Init() < 0 ) {
    fprintf(stderr, "Couldn't initialize TTF: %s\n",SDL_GetError());
    return(2);
  }
  atexit(TTF_Quit);  
  font ? ttf_font = TTF_OpenFont(font, fontsize) : ttf_font = TTF_OpenFont("data/fonts/hackedsignal.ttf", fontsize);
  TTF_SetFontStyle(ttf_font, 0);
  score_text_surface = TTF_RenderText_Blended(ttf_font, "65000", white);
  
  enemyBoom.initBigBoom(&dt,screen);
  alienarmy00.initEnemy(this, screen, &dt, &sdlgt, &mainship, &bullets, &bdraw, &life, &lives, &score, &enemyBoom);   //alienarmy00.initEnemy(screen, &dt, &sdlgt, &vikings1, (CSprite**)&bullets, &life, &score);
  mainship_base.init("data/art/mainship");
  bulletbase.init("data/art/bullets");
  miniship_bulletbase.init("data/art/bullets");
  smallship = IMG_Load("data/art/mainship/smallship2.png");
  //back = IMG_Load("data/bg01.png");
  phaser = Mix_LoadWAV("data/audio/mainphaser.wav");
  piriphaser = Mix_LoadWAV("data/audio/piriphaser.wav");
  mainship.init(&mainship_base,screen);
  mainship.set(400,25);
  mainship.setSpeed(1);
  for(int i=0;i<BULLETS;i++) { 
    bullets[i].init(&bulletbase,screen); 
    bullets[i].setFrame(0);
    bullets[i].stopAnim();
		bdraw[i] = 0;
  }
  for(int i=0;i<MINISHIP_BULLETS;i++) { 
    miniship_bullets[i].init(&miniship_bulletbase,screen); 
    miniship_bullets[i].setFrame(1);
    miniship_bullets[i].stopAnim();
		miniship_bdraw[i] = 0;
  }

  SDL_ShowCursor(0);
  initOpeningScreen();
  toggleMusic();

	circle.dv=0;
	frames=0;
	starttime=SDL_GetTicks();
  bool done=false;
  while(!done) {
    td2=SDL_GetTicks();
    dt=((float)(td2-td))*0.20;
    td=td2;
    sdlgt+=dt*10;
		frames++;
      
    SDL_Event event;    
    while(SDL_PollEvent(&event)) {
      if(event.type == SDL_QUIT) { done = true; }
      if(event.type == SDL_KEYDOWN) {
        if(event.key.keysym.sym == SDLK_ESCAPE ) { done = true; }
        if(event.key.keysym.sym == SDLK_SPACE && exploding == 0) {
          addBullet();
          Mix_PlayChannel(-1,phaser,0);
        }
        if (event.key.keysym.sym == SDLK_m) {
          toggleMusic();
        }
        if (event.key.keysym.sym == SDLK_o) {
          playMovie();
        }
        if (event.key.keysym.sym == SDLK_n) {
          SDL_SaveBMP(screen, "screenshot.bmp");
        }
        if (event.key.keysym.sym == SDLK_c) {
          enemyBoom.count_free();
          //printf(gethighscore());
        }
        if (event.key.keysym.sym == SDLK_f) {
          MY_SDL_SCREENSETTINGS |= SDL_FULLSCREEN;
					setVideoMode(MY_SDL_SCREENSETTINGS);
        }
        if (event.key.keysym.sym == SDLK_w) {
          MY_SDL_SCREENSETTINGS &= !SDL_FULLSCREEN;
          setVideoMode(MY_SDL_SCREENSETTINGS); 
        }
      }
    }
    
    if (exploding == 0) {
      keys = SDL_GetKeyState(NULL);
      if ( keys[SDLK_UP] ) { 
        mainship.yadd((int)(-1*dt));
        if(mainship.gety()<BOUND_UP_Y) mainship.yset(BOUND_UP_Y);
      }
      if ( keys[SDLK_DOWN] ) { 
        mainship.yadd((int)(1*dt));
        if(mainship.gety()>BOUND_LOW_Y) mainship.yset(BOUND_LOW_Y);
      }
      if ( keys[SDLK_LEFT] ) { 
        mainship.xadd((int)(-1*dt));
        if(mainship.getx()<BOUND_LEFT_X) mainship.xset(BOUND_LEFT_X);
      }
      if ( keys[SDLK_RIGHT] ) { 
        mainship.xadd((int)(1*dt));
        if(mainship.getx()>BOUND_RIGHT_X) mainship.xset(BOUND_RIGHT_X);
      }
      if(drand48()*10 > 9.5) miniship_addBullet();
    }
    for(int i=0;i<BULLETS;i++) {
      if(bdraw[i]==1) {
        bullets[i].yadd((int)(1.5*dt));
        if(bullets[i].gety()>BOUND_LOW_Y+50) {
          bdraw[i]=0;
        }
      }
    }
		
    for(int i=0;i<MINISHIP_BULLETS;i++) {
      if(miniship_bdraw[i]==1) {
        miniship_bullets[i].yadd((int)(1.0*dt));
        if(miniship_bullets[i].gety()>BOUND_LOW_Y+50) {
          miniship_bdraw[i]=0;
        }
      }
    }
		
    circle.dv += 0.1;
    circle.y = circle.y + cos(circle.dv)*5 ;
    circle.x = circle.x + sin(circle.dv)*5 ;
    if (mainship.getx() > circle.x) circle.x += (mainship.getx() - circle.x)/40;
    else circle.x -= (circle.x - mainship.getx())/40;
    if (mainship.gety() > circle.y) circle.y +=  (mainship.gety()- circle.y)/40;
    else circle.y -= (circle.y - mainship.gety())/40; 
		
    alienarmy00.nextScene();
		DrawScene();
    
    //scroll += dt;
    //if(scroll>=3907) scroll-=3907;
    //SDL_Delay(1);
  }

	starttime=SDL_GetTicks()-starttime;
	if(!starttime) starttime=1;
	printf("fps = %d\n",(int)(1000*frames/starttime));
	
  Mix_FadeOutMusic(1000);
  SDL_Delay(1000);
	
  SDL_Quit();
	return 1;
}

int main(int argc, char *argv[]) {
	Svinepalsen svinpals;
	svinpals.mainGame(argc, argv);
}




