#ifndef _CENEMYBASE_H_
#define _CENEMYBASE_H_

#include <stdlib.h>
#include <math.h>
#include <SDL.h>
#include <SDL_mixer.h>

#include "CSpriteBase.h"
#include "CSprite.h"
#include "CBigBoom.h"
#include <SDL_ttf.h>
//#include <smpeg.h>
//#include "svinepalsen.h"

#define BULLETS 5
#define MINISHIP_BULLETS 40
#define ENEMIES 10
#define BOUND_LOW_Y 540
#define BOUND_UP_Y 0
#define BOUND_LEFT_X 0
#define BOUND_RIGHT_X 720

class Svinepalsen;

class CEnemyBase
{
  public:
    CEnemyBase();
    ~CEnemyBase();
    void initEnemy(class Svinepalsen *pals, SDL_Surface* scr, float *deltatime, float *time, CSprite* ship, CSprite (*shipbullets)[BULLETS],int (*shipbdraw)[BULLETS], int *life, int *lives, int *score, CBigBoom *eboom);
    void drawOnScene();
    void enemyFire();
    void enemyMovement();
    void nextScene();
    void addEnemy();
  
		Svinepalsen *palsen;
		
  private:  
    SDL_Surface* screen;
  
    CSpriteBase enemybase;
    CSprite enemies[ENEMIES];
    CSpriteBase expcloudbase;
    CSprite expcloud;
    CSpriteBase bulletbase;
    CSprite bullets[BULLETS];
      
    CBigBoom* enemyBoom;
  
    Mix_Chunk *phaser;
    Mix_Chunk *explode;
    Mix_Chunk *walzingout;
  
    int edraw[ENEMIES];
    int espeed[ENEMIES];
    int elife[ENEMIES];
    int einfo[ENEMIES];
    int expdraw;
    int bdraw[BULLETS];
  
    
    Uint32 lastenemy;
    Uint32 lastexplosion;
};

#endif

