
#include <SDL.h>
#include "CSprite.h"
#include "CSpriteBase.h"

class SpriteElement;

class CDynamicSprite {
  public:
    CDynamicSprite(int amount, char* path, SDL_Surface* screen);
    ~CDynamicSprite();
  
  private:
    CSpriteBase cspritebase;
    SpriteElement* listHead;
    SpriteElement* freeHead;
    SpriteElement* lastNod;
};

class SpriteElement {
  friend class CDynamicSprite;

  public:
  SpriteElement(CSpriteBase base, SDL_Surface* screen);
  ~SpriteElement() {  }
  SpriteElement* getNext();
  void setNext(SpriteElement* i);
  
  private:
  SpriteElement* next;
  CSprite csprite;
  bool gen;
  float x,y,dx,dy;
  Uint32 c; 	// when zero, use heatcolor[bangdotlife]
  float life;	// When reduced to 0, set active=0
  float decay; 	// Amount by which to reduce life each time dot is drawn
};

SpriteElement::SpriteElement(CSpriteBase base, SDL_Surface* screen) {
  x = 0; y = 0; dx = 0; dy = 0; c = 0; life = 0; decay = 0; gen = 0; next = 0;
  csprite.init(&base,screen); 
  csprite.setFrame(0);
  csprite.stopAnim();
}

SpriteElement* SpriteElement::getNext() {
  return next;
}

void SpriteElement::setNext(SpriteElement* i) {
  next = i;
}

CDynamicSprite::CDynamicSprite(int amount, char* path, SDL_Surface* screen) {
  cspritebase.init(path); // char* path
	
	listHead = new SpriteElement(cspritebase,screen);
  listHead->setNext(0);
  freeHead = new SpriteElement(cspritebase,screen);
  freeHead->setNext(0);
  
  lastNod = freeHead;
  for (int i=0; i < amount; i++) {	// create amount of sprites.
    SpriteElement* newNod = new SpriteElement(cspritebase,screen);
    lastNod->setNext(newNod);
    lastNod = newNod;
  }
	
  /*int counter = 0;
  Nod* tempNod = freeHead;
  while ( tempNod->getNext() != 0) {
    tempNod = tempNod->getNext();
    counter++;
  }
  printf("%d pixels in buffer\n",counter);*/
}


CDynamicSprite::~CDynamicSprite() { 
  SpriteElement* tempNod;
  while(listHead != 0) {
    tempNod = listHead;
    listHead = listHead->getNext();
    delete tempNod;
  }	
}
