#ifndef _CBIGBOOM_H_
#define _CBIGBOOM_H_

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <vector>
#include <iostream>

#include <SDL.h>
#include <SDL_image.h>

#define RANDOM_LIST_SIZE 100000
#define MAX_BANG_DOTS 300000
#define XSIZE 800
#define YSIZE 600

struct bangdots {
  float x,y,dx,dy;
  Uint32 c; 	// when zero, use heatcolor[bangdotlife]
  float life;	// When reduced to 0, set active=0
  int active;
  float decay; 	// Amount by which to reduce life each time dot is drawn
};

class Nod;

//struct bangdots bdot[MAX_BANG_DOTS], *bdotptr=bdot;

class CBigBoom
{
  public:
    CBigBoom();
    ~CBigBoom();
  
    void initrnd();
    float rnd();
    void makebangdots(int xbang, int ybang, int xvel, int yvel, SDL_Surface *s, int power, int amtdots);
    void draw_bang_dots(SDL_Surface *s, float speed);
    void count_free();
    void DrawBoom();
    int initVideo();
    void initBigBoom(float* maindt, SDL_Surface *s);
    
  private:
    SDL_Surface *screen, *surf_ship;
  
    float random_list[RANDOM_LIST_SIZE];
    float movementrate;
    float sdlgt;           // Stores the time that has passed
    float dt;              // The time that has elapsed since the previous frame
    float *deltatime;
  
    int random_list_pointer;
    int td,td2;          // Used when checking the time difference (how much time has passed since last frame)
    int bd1, bd2;
    int nships,score,initticks,ticks_since_last, last_ticks;
    int bangdotlife, nbangdots;
  
    Uint32 heatcolor[100];
    Nod* listHead;
    Nod* freeHead;
    Nod* lastNod;
    //bangdots bdot[MAX_BANG_DOTS];
    //std::vector<bangdots> bdot;
};

class Nod
{
  friend class CBigBoom;
  public:
  Nod();
  ~Nod() { }
  Nod* getNext();
  void setNext(Nod* i);
  
  private:
  Nod* next;
  bool gen;
  float x,y,dx,dy;
  Uint32 c; 	// when zero, use heatcolor[bangdotlife]
  float life;	// When reduced to 0, set active=0
  float decay; 	// Amount by which to reduce life each time dot is drawn
};

#endif
