// Original ideas from spacerocks aka rockdodger and rewritten by Jonas Jesnen to fit svinepalsen.
// spacerocks.sf.net, svinepalsen.sf.net
// Uint32 *ptr=s->pixels;     part from LIM on #SDL
// for(i=0;i<s->w;i++,p++) pixeltomodify = *p;
// pitch is the actual scanline length in bytes, where w is the visible width of the scanline in pixels

#include "CBigBoom.h"

Nod::Nod()
{
  x = 0;
  y = 0;
  dx = 0;
  dy = 0; 
  c = 0; 
  life = 0;
  decay = 0;
  gen = 0;
  next = 0;
}

Nod* Nod::getNext()
{
  return next;
}

void Nod::setNext(Nod* i)
{
  next = i;
}


CBigBoom::CBigBoom() 
{ 
  sdlgt=0;
  dt=0;
  td=0; td2=0;
  bd1=0; bd2=0;
  
  listHead = new Nod;
  listHead->setNext(0);
  freeHead = new Nod;
  freeHead->setNext(0);
  
  lastNod = freeHead;
  for (int i=0; i < 30000; i++) {
    Nod* newNod = new Nod;
    lastNod->setNext(newNod);
    lastNod = newNod;
  }
  
  /*int counter = 0;
  Nod* tempNod = freeHead;
  while ( tempNod->getNext() != 0) {
    tempNod = tempNod->getNext();
    counter++;
  }
  printf("%d pixels in buffer\n",counter);*/
  
}
CBigBoom::~CBigBoom() 
{ 
  Nod* tempNod;
  while(listHead != 0)
  {
    tempNod = listHead;
    listHead = listHead->getNext();
    delete tempNod;
  }	
}

void CBigBoom::initrnd() {
  int i;
  for (i=0; i<RANDOM_LIST_SIZE; i++) 
  {
    random_list[i] = (float)rand()/(float)RAND_MAX; // (float)rand()/(float)RAND_MAX;
  }
  random_list_pointer=0;
}

float CBigBoom::rnd() {
  ++random_list_pointer;
  if (random_list_pointer>=RANDOM_LIST_SIZE) 
  {
    random_list_pointer=0;
  }
  return random_list[random_list_pointer];
}

void CBigBoom::makebangdots(int xbang, int ybang, int xvel, int yvel, SDL_Surface *s, int power, int amtdots) {
  int x,y;
  Uint32 *rawpixel,c;
  double theta,r;
  bool done=false;
	
  rawpixel = (Uint32 *) s->pixels;

  int begin_generate = SDL_GetTicks();
  while (!done) {
    for (x=0; x < (s->w); x++) {
      for (y=0; y < (s->h); y++) {	   
        c = rawpixel[s->pitch/4*y+x];
        if (c > 900000000) {
          theta = rnd()*3.1415927*2;
          r = 0.2342349913;
          
          Nod* newNod = freeHead->getNext();
          if (freeHead->getNext() == 0) {
            break; // must break because a bool in the while loop will just continue one more time through the code. and that will segfault us ):
          }
          freeHead->setNext(freeHead->getNext()->getNext());

          newNod->dx = (power/5.0)*95.0*cos(theta)*r+xvel ;
          newNod->dy = (power/5.0)*45.0*sin(theta)*r+yvel ;
          newNod->x = x+xbang;
          newNod->y = y+ybang;
          newNod->c = c;
          newNod->life = 80;
          newNod->decay = rnd()*30+1;
          newNod->gen = 1;
          
          Nod* tempNod = listHead;
          
          int endcount = 0;
          while(tempNod->getNext() != 0 && endcount > 1){
            tempNod = tempNod->getNext();
            endcount++;
          }
          newNod->setNext(tempNod->getNext());
          tempNod->setNext(newNod);
          
        }
      }
    }
    //printf("makbangdot time is %d\n",SDL_GetTicks() - begin_generate); 
    if (SDL_GetTicks() - begin_generate > 10) {
      done = true;
    }
  }
  
}

void CBigBoom::draw_bang_dots(SDL_Surface *s, float speed) {
  Uint32 *rawpixel;
  rawpixel = (Uint32 *) s->pixels;
  
  //int counter = 0;
  //printf("-:START:-\n");
  Nod* tempNod = listHead;
  while (tempNod->getNext() != 0)
  { 
    rawpixel[(int)((int)(s->pitch/4)*(int)(tempNod->getNext()->y))+(int)(tempNod->getNext()->x)] = tempNod->getNext()->c; 
    tempNod->getNext()->life -= tempNod->getNext()->decay * speed;
    tempNod->getNext()->x += tempNod->getNext()->dx*speed;
    tempNod->getNext()->y += tempNod->getNext()->dy*speed;
    if (tempNod->getNext()->life < 0 || tempNod->getNext()->x <= 0 || tempNod->getNext()->x >= XSIZE || tempNod->getNext()->y <= 0 || tempNod->getNext()->y >= YSIZE) {  
      Nod* deleteNod = tempNod->getNext();
      tempNod->setNext(tempNod->getNext()->getNext());
      deleteNod->setNext(freeHead->getNext()); //recycle
      freeHead->setNext(deleteNod); //recycle  
    }
    else {
      tempNod = tempNod->getNext();
    }
    //counter++;
  }
  //printf("counter:%d\n",counter);
  //printf("-:STOP:-\n");
}

void CBigBoom::count_free() {
  int counter = 0;
  Nod* tempNod = freeHead;
  while ( tempNod->getNext() != 0) {
    tempNod = tempNod->getNext();
    counter++;
  }
  printf("Count of free Nodes: %d\n",counter);  
}

void CBigBoom::initBigBoom(float* maindt, SDL_Surface *s)
{
  initrnd();
  deltatime = maindt;
}
