/*
 * Decompiled with CFR 0.152.
 */
package it.polito.appeal.traci.protocol;

import de.uniluebeck.itm.tcpip.Storage;
import it.polito.appeal.traci.protocol.Command;
import it.polito.appeal.traci.protocol.ResponseContainer;
import it.polito.appeal.traci.protocol.StatusResponse;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ResponseMessage {
    public static final int[] STATUS_ONLY_RESPONSES = new int[]{127, 195, 194, 196, 199, 200, 202, 204};
    private List<ResponseContainer> pairs = new ArrayList<ResponseContainer>();

    public ResponseMessage(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt() - 4;
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        Storage storage = new Storage(byArray);
        while (storage.validPos()) {
            ResponseContainer responseContainer;
            StatusResponse statusResponse = new StatusResponse(storage);
            if (statusResponse.result() != 0) {
                responseContainer = new ResponseContainer(statusResponse, null);
            } else if (statusResponse.id() == 2) {
                int n2 = storage.readInt();
                ArrayList<Command> arrayList = new ArrayList<Command>(n2);
                for (int i = 0; i < n2; ++i) {
                    arrayList.add(new Command(storage));
                }
                responseContainer = new ResponseContainer(statusResponse, null, arrayList);
            } else {
                responseContainer = this.isStatusOnlyResponse(statusResponse.id()) ? new ResponseContainer(statusResponse, null) : new ResponseContainer(statusResponse, new Command(storage));
            }
            this.pairs.add(responseContainer);
        }
    }

    private boolean isStatusOnlyResponse(int n) {
        for (int n2 : STATUS_ONLY_RESPONSES) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    public List<ResponseContainer> responses() {
        return Collections.unmodifiableList(this.pairs);
    }
}

