/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.ws;

import de.tudresden.sumo.cmd.ArealDetector;
import de.tudresden.sumo.cmd.Edge;
import de.tudresden.sumo.cmd.Gui;
import de.tudresden.sumo.cmd.Inductionloop;
import de.tudresden.sumo.cmd.Junction;
import de.tudresden.sumo.cmd.Lane;
import de.tudresden.sumo.cmd.Multientryexit;
import de.tudresden.sumo.cmd.Poi;
import de.tudresden.sumo.cmd.Polygon;
import de.tudresden.sumo.cmd.Route;
import de.tudresden.sumo.cmd.Simulation;
import de.tudresden.sumo.cmd.Trafficlights;
import de.tudresden.sumo.cmd.Vehicle;
import de.tudresden.sumo.cmd.Vehicletype;
import de.tudresden.sumo.util.ConvertHelper;
import de.tudresden.sumo.util.Sumo;
import de.tudresden.ws.container.SumoBoundingBox;
import de.tudresden.ws.container.SumoColor;
import de.tudresden.ws.container.SumoGeometry;
import de.tudresden.ws.container.SumoPosition2D;
import de.tudresden.ws.container.SumoStringList;
import de.tudresden.ws.container.SumoTLSLogic;
import de.tudresden.ws.log.Log;
import javax.jws.WebMethod;
import javax.jws.WebParam;

public class Traci {
    Sumo sumo;
    Log logger;
    ConvertHelper helper;

    public void init(Sumo sumo, Log log, ConvertHelper convertHelper) {
        this.sumo = sumo;
        this.logger = log;
        this.helper = convertHelper;
    }

    @WebMethod(action="Edge: adapt the Traveltime")
    public void Edge_adaptTraveltime(@WebParam(name="edgeID") String string, @WebParam(name="time") int n) {
        this.sumo.set_cmd(Edge.adaptTraveltime(string, n));
    }

    @WebMethod(action="Edge: setEffort")
    public void Edge_setEffort(@WebParam(name="edgeID") String string, @WebParam(name="effort") double d) {
        this.sumo.set_cmd(Edge.setEffort(string, d));
    }

    @WebMethod(action="Edge: Set a new maximum speed (in m/s) for all lanes of the edge..")
    public void Edge_setMaxSpeed(@WebParam(name="edgeID") String string, @WebParam(name="speed") double d) {
        this.sumo.set_cmd(Edge.setMaxSpeed(string, d));
    }

    @WebMethod(action="Vehicle: add")
    public void Vehicle_add(@WebParam(name="vehID") String string, @WebParam(name="typeID") String string2, @WebParam(name="routeID") String string3, @WebParam(name="depart") int n, @WebParam(name="pos") double d, @WebParam(name="speed") double d2, @WebParam(name="lane") byte by) {
        this.sumo.set_cmd(Vehicle.add(string, string2, string3, n, d, d2, by));
    }

    @WebMethod(action="Vehicle: changeLane")
    public void Vehicle_changeLane(@WebParam(name="vehID") String string, @WebParam(name="laneIndex") byte by, @WebParam(name="duration") int n) {
        this.sumo.set_cmd(Vehicle.changeLane(string, by, n));
    }

    @WebMethod(action="Vehicle: changeTarget")
    public void Vehicle_changeTarget(@WebParam(name="vehID") String string, @WebParam(name="edgeID") String string2) {
        this.sumo.set_cmd(Vehicle.changeTarget(string, string2));
    }

    @WebMethod(action="Vehicle: moveTo")
    public void Vehicle_moveTo(@WebParam(name="vehID") String string, @WebParam(name="laneID") String string2, @WebParam(name="pos") double d) {
        this.sumo.set_cmd(Vehicle.moveTo(string, string2, d));
    }

    @WebMethod(action="Vehicle: moveToVTD")
    public void Vehicle_moveToVTD(@WebParam(name="vehID") String string, @WebParam(name="edgeID") String string2, @WebParam(name="lane") int n, @WebParam(name="x") double d, @WebParam(name="y") double d2) {
        this.sumo.set_cmd(Vehicle.moveToVTD(string, string2, n, d, d2));
    }

    @WebMethod(action="Vehicle: Remove vehicle with the given ID for the give reason.  Reasons are defined in module constants and start with REMOVE_")
    public void Vehicle_remove(@WebParam(name="vehID") String string, @WebParam(name="reason") byte by) {
        this.sumo.set_cmd(Vehicle.remove(string, by));
    }

    @WebMethod(action="Vehicle: rerouteEffort")
    public void Vehicle_rerouteEffort(@WebParam(name="vehID") String string) {
        this.sumo.set_cmd(Vehicle.rerouteEffort(string));
    }

    @WebMethod(action="Vehicle: rerouteTraveltime")
    public void Vehicle_rerouteTraveltime(@WebParam(name="vehID") String string) {
        this.sumo.set_cmd(Vehicle.rerouteTraveltime(string));
    }

    @WebMethod(action="Vehicle: setAccel")
    public void Vehicle_setAccel(@WebParam(name="vehID") String string, @WebParam(name="accel") double d) {
        this.sumo.set_cmd(Vehicle.setAccel(string, d));
    }

    @WebMethod(action="Vehicle: setAdaptedTraveltime")
    public void Vehicle_setAdaptedTraveltime(@WebParam(name="vehID") String string, @WebParam(name="begTime") int n, @WebParam(name="endTime") int n2, @WebParam(name="edgeID") String string2, @WebParam(name="time") double d) {
        this.sumo.set_cmd(Vehicle.setAdaptedTraveltime(string, n, n2, string2, d));
    }

    @WebMethod(action="Vehicle: setColor")
    public void Vehicle_setColor(@WebParam(name="vehID") String string, @WebParam(name="color") SumoColor sumoColor) {
        this.sumo.set_cmd(Vehicle.setColor(string, sumoColor));
    }

    @WebMethod(action="Vehicle: setDecel")
    public void Vehicle_setDecel(@WebParam(name="vehID") String string, @WebParam(name="decel") double d) {
        this.sumo.set_cmd(Vehicle.setDecel(string, d));
    }

    @WebMethod(action="Vehicle: setEffort")
    public void Vehicle_setEffort(@WebParam(name="vehID") String string, @WebParam(name="begTime") int n, @WebParam(name="endTime") int n2, @WebParam(name="edgeID") String string2, @WebParam(name="effort") double d) {
        this.sumo.set_cmd(Vehicle.setEffort(string, n, n2, string2, d));
    }

    @WebMethod(action="Vehicle: setEmissionClass")
    public void Vehicle_setEmissionClass(@WebParam(name="vehID") String string, @WebParam(name="clazz") String string2) {
        this.sumo.set_cmd(Vehicle.setEmissionClass(string, string2));
    }

    @WebMethod(action="Vehicle: setImperfection")
    public void Vehicle_setImperfection(@WebParam(name="vehID") String string, @WebParam(name="imperfection") double d) {
        this.sumo.set_cmd(Vehicle.setImperfection(string, d));
    }

    @WebMethod(action="Vehicle: setLength")
    public void Vehicle_setLength(@WebParam(name="vehID") String string, @WebParam(name="length") double d) {
        this.sumo.set_cmd(Vehicle.setLength(string, d));
    }

    @WebMethod(action="Vehicle: setMaxSpeed")
    public void Vehicle_setMaxSpeed(@WebParam(name="vehID") String string, @WebParam(name="speed") double d) {
        this.sumo.set_cmd(Vehicle.setMaxSpeed(string, d));
    }

    @WebMethod(action="Vehicle: setMinGap")
    public void Vehicle_setMinGap(@WebParam(name="vehID") String string, @WebParam(name="minGap") double d) {
        this.sumo.set_cmd(Vehicle.setMinGap(string, d));
    }

    @WebMethod(action="Vehicle: setRouteID")
    public void Vehicle_setRouteID(@WebParam(name="vehID") String string, @WebParam(name="routeID") String string2) {
        this.sumo.set_cmd(Vehicle.setRouteID(string, string2));
    }

    @WebMethod(action="Vehicle: setShapeClass")
    public void Vehicle_setShapeClass(@WebParam(name="vehID") String string, @WebParam(name="clazz") String string2) {
        this.sumo.set_cmd(Vehicle.setShapeClass(string, string2));
    }

    @WebMethod(action="Vehicle: setSignals")
    public void Vehicle_setSignals(@WebParam(name="vehID") String string, @WebParam(name="signals") String string2) {
        this.sumo.set_cmd(Vehicle.setSignals(string, string2));
    }

    @WebMethod(action="Vehicle: setSpeed")
    public void Vehicle_setSpeed(@WebParam(name="vehID") String string, @WebParam(name="speed") double d) {
        this.sumo.set_cmd(Vehicle.setSpeed(string, d));
    }

    @WebMethod(action="Vehicle: setSpeedDeviation")
    public void Vehicle_setSpeedDeviation(@WebParam(name="vehID") String string, @WebParam(name="deviation") double d) {
        this.sumo.set_cmd(Vehicle.setSpeedDeviation(string, d));
    }

    @WebMethod(action="Vehicle: setSpeedFactor")
    public void Vehicle_setSpeedFactor(@WebParam(name="vehID") String string, @WebParam(name="factor") double d) {
        this.sumo.set_cmd(Vehicle.setSpeedFactor(string, d));
    }

    @WebMethod(action="Vehicle: setStop")
    public void Vehicle_setStop(@WebParam(name="vehID") String string, @WebParam(name="edgeID") String string2, @WebParam(name="pos") double d, @WebParam(name="laneIndex") byte by, @WebParam(name="duration") int n) {
        this.sumo.set_cmd(Vehicle.setStop(string, string2, d, by, n));
    }

    @WebMethod(action="Vehicle: setTau")
    public void Vehicle_setTau(@WebParam(name="vehID") String string, @WebParam(name="tau") double d) {
        this.sumo.set_cmd(Vehicle.setTau(string, d));
    }

    @WebMethod(action="Vehicle: setVehicleClass")
    public void Vehicle_setVehicleClass(@WebParam(name="vehID") String string, @WebParam(name="clazz") String string2) {
        this.sumo.set_cmd(Vehicle.setVehicleClass(string, string2));
    }

    @WebMethod(action="Vehicle: setWidth")
    public void Vehicle_setWidth(@WebParam(name="vehID") String string, @WebParam(name="width") double d) {
        this.sumo.set_cmd(Vehicle.setWidth(string, d));
    }

    @WebMethod(action="Trafficlights: setCompleteRedYellowGreenDefinition")
    public void Trafficlights_setCompleteRedYellowGreenDefinition(@WebParam(name="tlsID") String string, @WebParam(name="tls") SumoTLSLogic sumoTLSLogic) {
        this.sumo.set_cmd(Trafficlights.setCompleteRedYellowGreenDefinition(string, sumoTLSLogic));
    }

    @WebMethod(action="Trafficlights: setPhase")
    public void Trafficlights_setPhase(@WebParam(name="tlsID") String string, @WebParam(name="index") int n) {
        this.sumo.set_cmd(Trafficlights.setPhase(string, n));
    }

    @WebMethod(action="Trafficlights: setPhaseDuration")
    public void Trafficlights_setPhaseDuration(@WebParam(name="tlsID") String string, @WebParam(name="phaseDuration") int n) {
        this.sumo.set_cmd(Trafficlights.setPhaseDuration(string, n));
    }

    @WebMethod(action="Trafficlights: setProgram")
    public void Trafficlights_setProgram(@WebParam(name="tlsID") String string, @WebParam(name="programID") String string2) {
        this.sumo.set_cmd(Trafficlights.setProgram(string, string2));
    }

    @WebMethod(action="Trafficlights: setRedYellowGreenState")
    public void Trafficlights_setRedYellowGreenState(@WebParam(name="tlsID") String string, @WebParam(name="state") String string2) {
        this.sumo.set_cmd(Trafficlights.setRedYellowGreenState(string, string2));
    }

    @WebMethod(action="Vehicletype: setAccel")
    public void Vehicletype_setAccel(@WebParam(name="typeID") String string, @WebParam(name="accel") double d) {
        this.sumo.set_cmd(Vehicletype.setAccel(string, d));
    }

    @WebMethod(action="Vehicletype: setColor")
    public void Vehicletype_setColor(@WebParam(name="typeID") String string, @WebParam(name="color") SumoColor sumoColor) {
        this.sumo.set_cmd(Vehicletype.setColor(string, sumoColor));
    }

    @WebMethod(action="Vehicletype: setDecel")
    public void Vehicletype_setDecel(@WebParam(name="typeID") String string, @WebParam(name="decel") double d) {
        this.sumo.set_cmd(Vehicletype.setDecel(string, d));
    }

    @WebMethod(action="Vehicletype: setEmissionClass")
    public void Vehicletype_setEmissionClass(@WebParam(name="typeID") String string, @WebParam(name="clazz") String string2) {
        this.sumo.set_cmd(Vehicletype.setEmissionClass(string, string2));
    }

    @WebMethod(action="Vehicletype: setImperfection")
    public void Vehicletype_setImperfection(@WebParam(name="typeID") String string, @WebParam(name="imperfection") double d) {
        this.sumo.set_cmd(Vehicletype.setImperfection(string, d));
    }

    @WebMethod(action="Vehicletype: setLength")
    public void Vehicletype_setLength(@WebParam(name="typeID") String string, @WebParam(name="length") double d) {
        this.sumo.set_cmd(Vehicletype.setLength(string, d));
    }

    @WebMethod(action="Vehicletype: setMaxSpeed")
    public void Vehicletype_setMaxSpeed(@WebParam(name="typeID") String string, @WebParam(name="speed") double d) {
        this.sumo.set_cmd(Vehicletype.setMaxSpeed(string, d));
    }

    @WebMethod(action="Vehicletype: setMinGap")
    public void Vehicletype_setMinGap(@WebParam(name="typeID") String string, @WebParam(name="minGap") double d) {
        this.sumo.set_cmd(Vehicletype.setMinGap(string, d));
    }

    @WebMethod(action="Vehicletype: setShapeClass")
    public void Vehicletype_setShapeClass(@WebParam(name="typeID") String string, @WebParam(name="clazz") String string2) {
        this.sumo.set_cmd(Vehicletype.setShapeClass(string, string2));
    }

    @WebMethod(action="Vehicletype: setSpeedDeviation")
    public void Vehicletype_setSpeedDeviation(@WebParam(name="typeID") String string, @WebParam(name="deviation") double d) {
        this.sumo.set_cmd(Vehicletype.setSpeedDeviation(string, d));
    }

    @WebMethod(action="Vehicletype: setSpeedFactor")
    public void Vehicletype_setSpeedFactor(@WebParam(name="typeID") String string, @WebParam(name="factor") double d) {
        this.sumo.set_cmd(Vehicletype.setSpeedFactor(string, d));
    }

    @WebMethod(action="Vehicletype: setTau")
    public void Vehicletype_setTau(@WebParam(name="typeID") String string, @WebParam(name="tau") double d) {
        this.sumo.set_cmd(Vehicletype.setTau(string, d));
    }

    @WebMethod(action="Vehicletype: setVehicleClass")
    public void Vehicletype_setVehicleClass(@WebParam(name="typeID") String string, @WebParam(name="clazz") String string2) {
        this.sumo.set_cmd(Vehicletype.setVehicleClass(string, string2));
    }

    @WebMethod(action="Vehicletype: setWidth")
    public void Vehicletype_setWidth(@WebParam(name="typeID") String string, @WebParam(name="width") double d) {
        this.sumo.set_cmd(Vehicletype.setWidth(string, d));
    }

    @WebMethod(action="Lane: setAllowed")
    public void Lane_setAllowed(@WebParam(name="laneID") String string, @WebParam(name="allowedClasses") SumoStringList sumoStringList) {
        this.sumo.set_cmd(Lane.setAllowed(string, sumoStringList));
    }

    @WebMethod(action="Lane: setDisallowed")
    public void Lane_setDisallowed(@WebParam(name="laneID") String string, @WebParam(name="disallowedClasses") SumoStringList sumoStringList) {
        this.sumo.set_cmd(Lane.setDisallowed(string, sumoStringList));
    }

    @WebMethod(action="Lane: setLength")
    public void Lane_setLength(@WebParam(name="laneID") String string, @WebParam(name="length") double d) {
        this.sumo.set_cmd(Lane.setLength(string, d));
    }

    @WebMethod(action="Lane: setMaxSpeed")
    public void Lane_setMaxSpeed(@WebParam(name="laneID") String string, @WebParam(name="speed") double d) {
        this.sumo.set_cmd(Lane.setMaxSpeed(string, d));
    }

    @WebMethod(action="Polygon: add")
    public void Polygon_add(@WebParam(name="polygonID") String string, @WebParam(name="shape") SumoGeometry sumoGeometry, @WebParam(name="color") SumoColor sumoColor, @WebParam(name="fill") boolean bl, @WebParam(name="polygonType") String string2, @WebParam(name="layer") int n) {
        this.sumo.set_cmd(Polygon.add(string, sumoGeometry, sumoColor, bl, string2, n));
    }

    @WebMethod(action="Polygon: remove")
    public void Polygon_remove(@WebParam(name="polygonID") String string, @WebParam(name="layer") int n) {
        this.sumo.set_cmd(Polygon.remove(string, n));
    }

    @WebMethod(action="Polygon: setColor")
    public void Polygon_setColor(@WebParam(name="polygonID") String string, @WebParam(name="color") SumoColor sumoColor) {
        this.sumo.set_cmd(Polygon.setColor(string, sumoColor));
    }

    @WebMethod(action="Polygon: setShape")
    public void Polygon_setShape(@WebParam(name="polygonID") String string, @WebParam(name="shape") SumoStringList sumoStringList) {
        this.sumo.set_cmd(Polygon.setShape(string, sumoStringList));
    }

    @WebMethod(action="Polygon: setType")
    public void Polygon_setType(@WebParam(name="polygonID") String string, @WebParam(name="polygonType") String string2) {
        this.sumo.set_cmd(Polygon.setType(string, string2));
    }

    @WebMethod(action="Poi: remove")
    public void Poi_remove(@WebParam(name="poiID") String string, @WebParam(name="layer") int n) {
        this.sumo.set_cmd(Poi.remove(string, n));
    }

    @WebMethod(action="Poi: setColor")
    public void Poi_setColor(@WebParam(name="poiID") String string, @WebParam(name="color") SumoColor sumoColor) {
        this.sumo.set_cmd(Poi.setColor(string, sumoColor));
    }

    @WebMethod(action="Poi: setPosition")
    public void Poi_setPosition(@WebParam(name="poiID") String string, @WebParam(name="x") double d, @WebParam(name="y") double d2) {
        this.sumo.set_cmd(Poi.setPosition(string, d, d2));
    }

    @WebMethod(action="Poi: setType")
    public void Poi_setType(@WebParam(name="poiID") String string, @WebParam(name="poiType") String string2) {
        this.sumo.set_cmd(Poi.setType(string, string2));
    }

    @WebMethod(action="Gui: screenshot")
    public void GUI_screenshot(@WebParam(name="viewID") String string, @WebParam(name="filename") String string2) {
        this.sumo.set_cmd(Gui.screenshot(string, string2));
    }

    @WebMethod(action="Gui: Set the current boundary for the given view (see getBoundary()).")
    public void GUI_setBoundary(@WebParam(name="viewID") String string, @WebParam(name="xmin") double d, @WebParam(name="ymin") double d2, @WebParam(name="xmax") double d3, @WebParam(name="ymax") double d4) {
        this.sumo.set_cmd(Gui.setBoundary(string, d, d2, d3, d4));
    }

    @WebMethod(action="Gui: Set the current offset for the given view.")
    public void GUI_setOffset(@WebParam(name="viewID") String string, @WebParam(name="x") double d, @WebParam(name="y") double d2) {
        this.sumo.set_cmd(Gui.setOffset(string, d, d2));
    }

    @WebMethod(action="Gui: Set the current coloring scheme for the given view.")
    public void GUI_setSchema(@WebParam(name="viewID") String string, @WebParam(name="schemeName") String string2) {
        this.sumo.set_cmd(Gui.setSchema(string, string2));
    }

    @WebMethod(action="Gui: Set the current zoom factor for the given view.")
    public void GUI_setZoom(@WebParam(name="viewID") String string, @WebParam(name="zoom") double d) {
        this.sumo.set_cmd(Gui.setZoom(string, d));
    }

    @WebMethod(action="Gui: trackVehicle")
    public void GUI_trackVehicle(@WebParam(name="viewID") String string, @WebParam(name="vehID") String string2) {
        this.sumo.set_cmd(Gui.trackVehicle(string, string2));
    }

    @WebMethod(action="Route: add")
    public void Route_add(@WebParam(name="routeID") String string, @WebParam(name="edges") SumoStringList sumoStringList) {
        this.sumo.set_cmd(Route.add(string, sumoStringList));
    }

    @WebMethod(action="Multientryexit: Returns a list of all e3 detectors in the network.")
    public SumoStringList Multientryexit_getIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(Multientryexit.getIDList()));
    }

    @WebMethod(action="Multientryexit: Returns the number of all e3 detectors in the network.")
    public int Multientryexit_getIDCount() {
        return this.helper.getInt(this.sumo.get_cmd(Multientryexit.getIDCount()));
    }

    @WebMethod(action="Multientryexit: Returns the subscription results for the last time step and the given detector.")
    public int Multientryexit_getLastStepHaltingNumber(@WebParam(name="detID") String string) {
        return this.helper.getInt(this.sumo.get_cmd(Multientryexit.getLastStepHaltingNumber(string)));
    }

    @WebMethod(action="Multientryexit: getLastStepMeanSpeed")
    public double Multientryexit_getLastStepMeanSpeed(@WebParam(name="detID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Multientryexit.getLastStepMeanSpeed(string)));
    }

    @WebMethod(action="Multientryexit: getLastStepVehicleIDs")
    public SumoStringList Multientryexit_getLastStepVehicleIDs(@WebParam(name="detID") String string) {
        return this.helper.getStringList(this.sumo.get_cmd(Multientryexit.getLastStepVehicleIDs(string)));
    }

    @WebMethod(action="Multientryexit: getLastStepVehicleNumber")
    public int Multientryexit_getLastStepVehicleNumber(@WebParam(name="detID") String string) {
        return this.helper.getInt(this.sumo.get_cmd(Multientryexit.getLastStepVehicleNumber(string)));
    }

    @WebMethod(action="Edge: Returns the travel time value (in s) used for (re-)routing")
    public double Edge_getAdaptedTraveltime(@WebParam(name="edgeID") String string, @WebParam(name="time") double d) {
        return this.helper.getDouble(this.sumo.get_cmd(Edge.getAdaptedTraveltime(string, d)));
    }

    @WebMethod(action="Edge: Returns the CO2 emission in mg for the last time step on the given edge.")
    public double Edge_getCO2Emission(@WebParam(name="edgeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Edge.getCO2Emission(string)));
    }

    @WebMethod(action="Edge: Returns the CO emission in mg for the last time step on the given edge.")
    public double Edge_getCOEmission(@WebParam(name="edgeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Edge.getCOEmission(string)));
    }

    @WebMethod(action="Edge: Returns the effort value used for (re-)routing")
    public double Edge_getEffort(@WebParam(name="edgeID") String string, @WebParam(name="time") double d) {
        return this.helper.getDouble(this.sumo.get_cmd(Edge.getEffort(string, d)));
    }

    @WebMethod(action="Edge: Returns the fuel consumption in ml for the last time step on the given edge.")
    public double Edge_getFuelConsumption(@WebParam(name="edgeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Edge.getFuelConsumption(string)));
    }

    @WebMethod(action="Edge: Returns the HC emission in mg for the last time step on the given edge.")
    public double Edge_getHCEmission(@WebParam(name="edgeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Edge.getHCEmission(string)));
    }

    @WebMethod(action="Edge: Returns the number of edges in the network.")
    public int Edge_getIDCount() {
        return this.helper.getInt(this.sumo.get_cmd(Edge.getIDCount()));
    }

    @WebMethod(action="Edge: Returns a list of all edges in the network.")
    public SumoStringList Edge_getIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(Edge.getIDList()));
    }

    @WebMethod(action="Edge: Returns the total number of halting vehicles for the last time step on the given edge.")
    public int Edge_getLastStepHaltingNumber(@WebParam(name="edgeID") String string) {
        return this.helper.getInt(this.sumo.get_cmd(Edge.getLastStepHaltingNumber(string)));
    }

    @WebMethod(action="Edge: Returns the total vehicle length in m for the last time step on the given edge.")
    public double Edge_getLastStepLength(@WebParam(name="edgeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Edge.getLastStepLength(string)));
    }

    @WebMethod(action="Edge: Returns the average speed in m/s for the last time step on the given edge.")
    public double Edge_getLastStepMeanSpeed(@WebParam(name="edgeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Edge.getLastStepMeanSpeed(string)));
    }

    @WebMethod(action="Edge: Returns the occupancy in % for the last time step on the given edge.")
    public double Edge_getLastStepOccupancy(@WebParam(name="edgeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Edge.getLastStepOccupancy(string)));
    }

    @WebMethod(action="Edge: Returns the subscription results for the last time step and the given edge.")
    public SumoStringList Edge_getLastStepVehicleIDs(@WebParam(name="edgeID") String string) {
        return this.helper.getStringList(this.sumo.get_cmd(Edge.getLastStepVehicleIDs(string)));
    }

    @WebMethod(action="Edge: Returns the total number of vehicles for the last time step on the given edge.")
    public int Edge_getLastStepVehicleNumber(@WebParam(name="edgeID") String string) {
        return this.helper.getInt(this.sumo.get_cmd(Edge.getLastStepVehicleNumber(string)));
    }

    @WebMethod(action="Edge: Returns the NOx emission in mg for the last time step on the given edge.")
    public double Edge_getNOxEmission(@WebParam(name="edgeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Edge.getNOxEmission(string)));
    }

    @WebMethod(action="Edge: Returns the noise emission in db for the last time step on the given edge.")
    public double Edge_getNoiseEmission(@WebParam(name="edgeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Edge.getNoiseEmission(string)));
    }

    @WebMethod(action="Edge: Returns the particular matter emission in mg for the last time step on the given edge.")
    public double Edge_getPMxEmission(@WebParam(name="edgeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Edge.getPMxEmission(string)));
    }

    @WebMethod(action="Edge: Returns the estimated travel time in s for the last time step on the given edge.")
    public double Edge_getTraveltime(@WebParam(name="edgeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Edge.getTraveltime(string)));
    }

    @WebMethod(action="Edge: Returns the waiting time in s for the last time step on the given edge.")
    public double Edge_getWaitingTime(@WebParam(name="edgeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Edge.getWaitingTime(string)));
    }

    @WebMethod(action="ArealDetector: getIDList")
    public SumoStringList ArealDetector_getIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(ArealDetector.getIDList()));
    }

    @WebMethod(action="ArealDetector: getIDCount")
    public int ArealDetector_getIDCount() {
        return this.helper.getInt(this.sumo.get_cmd(ArealDetector.getIDCount()));
    }

    @WebMethod(action="ArealDetector: getJamLengthVehicle")
    public int ArealDetector_getJamLengthVehicle(@WebParam(name="loopID") String string) {
        return this.helper.getInt(this.sumo.get_cmd(ArealDetector.getJamLengthVehicle(string)));
    }

    @WebMethod(action="ArealDetector: getJamLengthMeters")
    public double ArealDetector_getJamLengthMeters(@WebParam(name="loopID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(ArealDetector.getJamLengthMeters(string)));
    }

    @WebMethod(action="Vehicle: getAccel")
    public double Vehicle_getAccel(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getAccel(string)));
    }

    @WebMethod(action="Vehicle: getAdaptedTraveltime")
    public double Vehicle_getAdaptedTraveltime(@WebParam(name="vehID") String string, @WebParam(name="time") double d, @WebParam(name="edgeID") String string2) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getAdaptedTraveltime(string, d, string2)));
    }

    @WebMethod(action="Vehicle: getAngle")
    public double Vehicle_getAngle(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getAngle(string)));
    }

    @WebMethod(action="Vehicle: getBestLanes")
    public SumoStringList Vehicle_getBestLanes(@WebParam(name="vehID") String string) {
        return this.helper.getStringList(this.sumo.get_cmd(Vehicle.getBestLanes(string)));
    }

    @WebMethod(action="Vehicle: Returns the CO2 emission in mg for the last time step.")
    public double Vehicle_getCO2Emission(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getCO2Emission(string)));
    }

    @WebMethod(action="Vehicle: Returns the CO emission in mg for the last time step.")
    public double Vehicle_getCOEmission(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getCOEmission(string)));
    }

    @WebMethod(action="Vehicle: getColor")
    public SumoColor Vehicle_getColor(@WebParam(name="vehID") String string) {
        return this.helper.getColor(this.sumo.get_cmd(Vehicle.getColor(string)));
    }

    @WebMethod(action="Vehicle: getDecel")
    public double Vehicle_getDecel(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getDecel(string)));
    }

    @WebMethod(action="Vehicle: getDrivingDistance")
    public double Vehicle_getDrivingDistance(@WebParam(name="vehID") String string, @WebParam(name="edgeID") String string2, @WebParam(name="pos") double d, @WebParam(name="laneID") int n) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getDrivingDistance(string, string2, d, n)));
    }

    @WebMethod(action="Vehicle: Returns the subscription results for the last time step and the given vehicle.")
    public double Vehicle_getDrivingDistance2D(@WebParam(name="vehID") String string, @WebParam(name="x") double d, @WebParam(name="y") double d2) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getDrivingDistance2D(string, d, d2)));
    }

    @WebMethod(action="Vehicle: getEffort")
    public double Vehicle_getEffort(@WebParam(name="vehID") String string, @WebParam(name="time") double d, @WebParam(name="edgeID") String string2) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getEffort(string, d, string2)));
    }

    @WebMethod(action="Vehicle: getEmissionClass")
    public String Vehicle_getEmissionClass(@WebParam(name="vehID") String string) {
        return this.helper.getString(this.sumo.get_cmd(Vehicle.getEmissionClass(string)));
    }

    @WebMethod(action="Vehicle: Returns the fuel consumption in ml for the last time step.")
    public double Vehicle_getFuelConsumption(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getFuelConsumption(string)));
    }

    @WebMethod(action="Vehicle: Returns the HC emission in mg for the last time step.")
    public double Vehicle_getHCEmission(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getHCEmission(string)));
    }

    @WebMethod(action="Vehicle: Returns a list of all known vehicles.")
    public SumoStringList Vehicle_getIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(Vehicle.getIDList()));
    }

    @WebMethod(action="Vehicle: Returns the number of all known vehicles.")
    public int Vehicle_getIDCount() {
        return this.helper.getInt(this.sumo.get_cmd(Vehicle.getIDCount()));
    }

    @WebMethod(action="Vehicle: getImperfection")
    public double Vehicle_getImperfection(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getImperfection(string)));
    }

    @WebMethod(action="Vehicle: getAllowedSpeed")
    public double Vehicle_getAllowedSpeed(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getAllowedSpeed(string)));
    }

    @WebMethod(action="Vehicle: getPersonNumber")
    public int Vehicle_getPersonNumber(@WebParam(name="vehID") String string) {
        return this.helper.getInt(this.sumo.get_cmd(Vehicle.getPersonNumber(string)));
    }

    @WebMethod(action="Vehicle: getDistance")
    public double Vehicle_getDistance(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getDistance(string)));
    }

    @WebMethod(action="Vehicle: getWaitingTime")
    public double Vehicle_getWaitingTime(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getWaitingTime(string)));
    }

    @WebMethod(action="Vehicle: getLaneID")
    public String Vehicle_getLaneID(@WebParam(name="vehID") String string) {
        return this.helper.getString(this.sumo.get_cmd(Vehicle.getLaneID(string)));
    }

    @WebMethod(action="Vehicle: getLaneIndex")
    public int Vehicle_getLaneIndex(@WebParam(name="vehID") String string) {
        return this.helper.getInt(this.sumo.get_cmd(Vehicle.getLaneIndex(string)));
    }

    @WebMethod(action="Vehicle: getLanePosition")
    public double Vehicle_getLanePosition(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getLanePosition(string)));
    }

    @WebMethod(action="Vehicle: getLength")
    public double Vehicle_getLength(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getLength(string)));
    }

    @WebMethod(action="Vehicle: getMaxSpeed")
    public double Vehicle_getMaxSpeed(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getMaxSpeed(string)));
    }

    @WebMethod(action="Vehicle: getMinGap")
    public double Vehicle_getMinGap(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getMinGap(string)));
    }

    @WebMethod(action="Vehicle: Returns the NOx emission in mg for the last time step.")
    public double Vehicle_getNOxEmission(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getNOxEmission(string)));
    }

    @WebMethod(action="Vehicle: Returns the noise emission in db for the last time step.")
    public double Vehicle_getNoiseEmission(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getNoiseEmission(string)));
    }

    @WebMethod(action="Vehicle: Returns the particular matter emission in mg for the last time step.")
    public double Vehicle_getPMxEmission(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getPMxEmission(string)));
    }

    @WebMethod(action="Vehicle: Returns the position of the named vehicle within the last step [m,m].")
    public SumoPosition2D Vehicle_getPosition(@WebParam(name="vehID") String string) {
        return this.helper.getPosition2D(this.sumo.get_cmd(Vehicle.getPosition(string)));
    }

    @WebMethod(action="Vehicle: getRoadID")
    public String Vehicle_getRoadID(@WebParam(name="vehID") String string) {
        return this.helper.getString(this.sumo.get_cmd(Vehicle.getRoadID(string)));
    }

    @WebMethod(action="Vehicle: getRoute")
    public SumoStringList Vehicle_getRoute(@WebParam(name="vehID") String string) {
        return this.helper.getStringList(this.sumo.get_cmd(Vehicle.getRoute(string)));
    }

    @WebMethod(action="Vehicle: getRouteID")
    public String Vehicle_getRouteID(@WebParam(name="vehID") String string) {
        return this.helper.getString(this.sumo.get_cmd(Vehicle.getRouteID(string)));
    }

    @WebMethod(action="Vehicle: getShapeClass")
    public String Vehicle_getShapeClass(@WebParam(name="vehID") String string) {
        return this.helper.getString(this.sumo.get_cmd(Vehicle.getShapeClass(string)));
    }

    @WebMethod(action="Vehicle: getSignals")
    public int Vehicle_getSignals(@WebParam(name="vehID") String string) {
        return this.helper.getInt(this.sumo.get_cmd(Vehicle.getSignals(string)));
    }

    @WebMethod(action="Vehicle: getSpeed")
    public double Vehicle_getSpeed(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getSpeed(string)));
    }

    @WebMethod(action="Vehicle: getSpeedDeviation")
    public double Vehicle_getSpeedDeviation(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getSpeedDeviation(string)));
    }

    @WebMethod(action="Vehicle: getSpeedFactor")
    public double Vehicle_getSpeedFactor(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getSpeedFactor(string)));
    }

    @WebMethod(action="Vehicle: getSpeedWithoutTraCI")
    public double Vehicle_getSpeedWithoutTraCI(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getSpeedWithoutTraCI(string)));
    }

    @WebMethod(action="Vehicle: getTau")
    public double Vehicle_getTau(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getTau(string)));
    }

    @WebMethod(action="Vehicle: getTypeID")
    public String Vehicle_getTypeID(@WebParam(name="vehID") String string) {
        return this.helper.getString(this.sumo.get_cmd(Vehicle.getTypeID(string)));
    }

    @WebMethod(action="Vehicle: getVehicleClass")
    public String Vehicle_getVehicleClass(@WebParam(name="vehID") String string) {
        return this.helper.getString(this.sumo.get_cmd(Vehicle.getVehicleClass(string)));
    }

    @WebMethod(action="Vehicle: getWidth")
    public double Vehicle_getWidth(@WebParam(name="vehID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicle.getWidth(string)));
    }

    @WebMethod(action="Vehicle: isRouteValid")
    public int Vehicle_isRouteValid(@WebParam(name="vehID") String string) {
        return this.helper.getInt(this.sumo.get_cmd(Vehicle.isRouteValid(string)));
    }

    @WebMethod(action="Vehicle: setRoute")
    public int Vehicle_setRoute(@WebParam(name="vehID") String string, @WebParam(name="edgeList") SumoStringList sumoStringList) {
        return this.helper.getInt(this.sumo.get_cmd(Vehicle.setRoute(string, sumoStringList)));
    }

    @WebMethod(action="Vehicle: setLaneChangeMode")
    public int Vehicle_setLaneChangeMode(@WebParam(name="vehID") String string, @WebParam(name="lcm") int n) {
        return this.helper.getInt(this.sumo.get_cmd(Vehicle.setLaneChangeMode(string, n)));
    }

    @WebMethod(action="Vehicle: setType")
    public int Vehicle_setType(@WebParam(name="vehID") String string, @WebParam(name="typeID") String string2) {
        return this.helper.getInt(this.sumo.get_cmd(Vehicle.setType(string, string2)));
    }

    @WebMethod(action="Vehicle: slowDown")
    public int Vehicle_slowDown(@WebParam(name="vehID") String string, @WebParam(name="speed") double d, @WebParam(name="duration") int n) {
        return this.helper.getInt(this.sumo.get_cmd(Vehicle.slowDown(string, d, n)));
    }

    @WebMethod(action="Simulation: convert2D")
    public SumoStringList Simulation_convert2D(@WebParam(name="edgeID") String string, @WebParam(name="pos") double d, @WebParam(name="laneIndex") byte by, @WebParam(name="toGeo") String string2) {
        return this.helper.getStringList(this.sumo.get_cmd(Simulation.convert2D(string, d, by, string2)));
    }

    @WebMethod(action="Simulation: convertGeo")
    public SumoStringList Simulation_convertGeo(@WebParam(name="x") double d, @WebParam(name="y") double d2, @WebParam(name="fromGeo") String string) {
        return this.helper.getStringList(this.sumo.get_cmd(Simulation.convertGeo(d, d2, string)));
    }

    @WebMethod(action="Simulation: convertRoad")
    public SumoPosition2D Simulation_convertRoad(@WebParam(name="x") double d, @WebParam(name="y") double d2, @WebParam(name="isGeo") String string) {
        return this.helper.getPosition2D(this.sumo.get_cmd(Simulation.convertRoad(d, d2, string)));
    }

    @WebMethod(action="Simulation: getArrivedIDList")
    public SumoStringList Simulation_getArrivedIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(Simulation.getArrivedIDList()));
    }

    @WebMethod(action="Simulation: getArrivedNumber")
    public int Simulation_getArrivedNumber() {
        return this.helper.getInt(this.sumo.get_cmd(Simulation.getArrivedNumber()));
    }

    @WebMethod(action="Simulation: getCurrentTime")
    public int Simulation_getCurrentTime() {
        return this.helper.getInt(this.sumo.get_cmd(Simulation.getCurrentTime()));
    }

    @WebMethod(action="Simulation: getBusStopWaiting")
    public int Simulation_getBusStopWaiting() {
        return this.helper.getInt(this.sumo.get_cmd(Simulation.getBusStopWaiting()));
    }

    @WebMethod(action="Simulation: getParkingEndingVehiclesIDList")
    public SumoStringList Simulation_getParkingEndingVehiclesIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(Simulation.getParkingEndingVehiclesIDList()));
    }

    @WebMethod(action="Simulation: getParkingEndingVehiclesNumber")
    public int Simulation_getParkingEndingVehiclesNumber() {
        return this.helper.getInt(this.sumo.get_cmd(Simulation.getParkingEndingVehiclesNumber()));
    }

    @WebMethod(action="Simulation: getParkingStartingVehiclesIDList")
    public SumoStringList Simulation_getParkingStartingVehiclesIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(Simulation.getParkingStartingVehiclesIDList()));
    }

    @WebMethod(action="Simulation: getParkingStartingVehiclesNumber")
    public int Simulation_getParkingStartingVehiclesNumber() {
        return this.helper.getInt(this.sumo.get_cmd(Simulation.getParkingStartingVehiclesNumber()));
    }

    @WebMethod(action="Simulation: getStopEndingVehiclesIDList")
    public SumoStringList Simulation_getStopEndingVehiclesIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(Simulation.getStopEndingVehiclesIDList()));
    }

    @WebMethod(action="Simulation: getStopEndingVehiclesNumber")
    public int Simulation_getStopEndingVehiclesNumber() {
        return this.helper.getInt(this.sumo.get_cmd(Simulation.getStopEndingVehiclesNumber()));
    }

    @WebMethod(action="Simulation: getStopStartingVehiclesIDList")
    public SumoStringList Simulation_getStopStartingVehiclesIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(Simulation.getStopStartingVehiclesIDList()));
    }

    @WebMethod(action="Simulation: getStopStartingVehiclesNumber")
    public int Simulation_getStopStartingVehiclesNumber() {
        return this.helper.getInt(this.sumo.get_cmd(Simulation.getStopStartingVehiclesNumber()));
    }

    @WebMethod(action="Simulation: getDeltaT")
    public int Simulation_getDeltaT() {
        return this.helper.getInt(this.sumo.get_cmd(Simulation.getDeltaT()));
    }

    @WebMethod(action="Simulation: getDepartedIDList")
    public SumoStringList Simulation_getDepartedIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(Simulation.getDepartedIDList()));
    }

    @WebMethod(action="Simulation: getDepartedNumber")
    public int Simulation_getDepartedNumber() {
        return this.helper.getInt(this.sumo.get_cmd(Simulation.getDepartedNumber()));
    }

    @WebMethod(action="Simulation: getDistance2D")
    public double Simulation_getDistance2D(@WebParam(name="x1") double d, @WebParam(name="y1") double d2, @WebParam(name="x2") double d3, @WebParam(name="y2") double d4, @WebParam(name="isGeo") String string, @WebParam(name="isDriving") String string2) {
        return this.helper.getDouble(this.sumo.get_cmd(Simulation.getDistance2D(d, d2, d3, d4, string, string2)));
    }

    @WebMethod(action="Simulation: Returns the subscription results for the last time step.")
    public double Simulation_getDistanceRoad(@WebParam(name="edgeID1") String string, @WebParam(name="pos1") double d, @WebParam(name="edgeID2") String string2, @WebParam(name="pos2") double d2, @WebParam(name="isDriving") String string3) {
        return this.helper.getDouble(this.sumo.get_cmd(Simulation.getDistanceRoad(string, d, string2, d2, string3)));
    }

    @WebMethod(action="Simulation: getEndingTeleportIDList")
    public SumoStringList Simulation_getEndingTeleportIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(Simulation.getEndingTeleportIDList()));
    }

    @WebMethod(action="Simulation: getEndingTeleportNumber")
    public int Simulation_getEndingTeleportNumber() {
        return this.helper.getInt(this.sumo.get_cmd(Simulation.getEndingTeleportNumber()));
    }

    @WebMethod(action="Simulation: getLoadedIDList")
    public SumoStringList Simulation_getLoadedIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(Simulation.getLoadedIDList()));
    }

    @WebMethod(action="Simulation: getLoadedNumber")
    public int Simulation_getLoadedNumber() {
        return this.helper.getInt(this.sumo.get_cmd(Simulation.getLoadedNumber()));
    }

    @WebMethod(action="Simulation: getMinExpectedNumber")
    public int Simulation_getMinExpectedNumber() {
        return this.helper.getInt(this.sumo.get_cmd(Simulation.getMinExpectedNumber()));
    }

    @WebMethod(action="Simulation: getNetBoundary")
    public SumoStringList Simulation_getNetBoundary() {
        return this.helper.getStringList(this.sumo.get_cmd(Simulation.getNetBoundary()));
    }

    @WebMethod(action="Simulation: getStartingTeleportIDList")
    public SumoStringList Simulation_getStartingTeleportIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(Simulation.getStartingTeleportIDList()));
    }

    @WebMethod(action="Simulation: getStartingTeleportNumber")
    public int Simulation_getStartingTeleportNumber() {
        return this.helper.getInt(this.sumo.get_cmd(Simulation.getStartingTeleportNumber()));
    }

    @WebMethod(action="Trafficlights: getCompleteRedYellowGreenDefinition")
    public SumoTLSLogic Trafficlights_getCompleteRedYellowGreenDefinition(@WebParam(name="tlsID") String string) {
        return this.helper.getTLSLogic(this.sumo.get_cmd(Trafficlights.getCompleteRedYellowGreenDefinition(string)));
    }

    @WebMethod(action="Trafficlights: getControlledLanes")
    public SumoStringList Trafficlights_getControlledLanes(@WebParam(name="tlsID") String string) {
        return this.helper.getStringList(this.sumo.get_cmd(Trafficlights.getControlledLanes(string)));
    }

    @WebMethod(action="Trafficlights: getControlledLinks")
    public SumoStringList Trafficlights_getControlledLinks(@WebParam(name="tlsID") String string) {
        return this.helper.getStringList(this.sumo.get_cmd(Trafficlights.getControlledLinks(string)));
    }

    @WebMethod(action="Trafficlights: Returns a list of all traffic lights in the network.")
    public SumoStringList Trafficlights_getIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(Trafficlights.getIDList()));
    }

    @WebMethod(action="Trafficlights: Returns the number of all traffic lights in the network.")
    public int Trafficlights_getIDCount() {
        return this.helper.getInt(this.sumo.get_cmd(Trafficlights.getIDCount()));
    }

    @WebMethod(action="Trafficlights: Returns the next switch")
    public int Trafficlights_getNextSwitch(@WebParam(name="tlsID") String string) {
        return this.helper.getInt(this.sumo.get_cmd(Trafficlights.getNextSwitch(string)));
    }

    @WebMethod(action="Trafficlights: Returns the phase duration")
    public int Trafficlights_getPhaseDuration(@WebParam(name="tlsID") String string) {
        return this.helper.getInt(this.sumo.get_cmd(Trafficlights.getPhaseDuration(string)));
    }

    @WebMethod(action="Trafficlights: getPhase")
    public int Trafficlights_getPhase(@WebParam(name="tlsID") String string) {
        return this.helper.getInt(this.sumo.get_cmd(Trafficlights.getPhase(string)));
    }

    @WebMethod(action="Trafficlights: getProgram")
    public String Trafficlights_getProgram(@WebParam(name="tlsID") String string) {
        return this.helper.getString(this.sumo.get_cmd(Trafficlights.getProgram(string)));
    }

    @WebMethod(action="Trafficlights: getRedYellowGreenState")
    public String Trafficlights_getRedYellowGreenState(@WebParam(name="tlsID") String string) {
        return this.helper.getString(this.sumo.get_cmd(Trafficlights.getRedYellowGreenState(string)));
    }

    @WebMethod(action="Vehicletype: getAccel")
    public double Vehicletype_getAccel(@WebParam(name="typeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicletype.getAccel(string)));
    }

    @WebMethod(action="Vehicletype: Returns the subscription results for the last time step and the given vehicle type.")
    public SumoColor Vehicletype_getColor(@WebParam(name="typeID") String string) {
        return this.helper.getColor(this.sumo.get_cmd(Vehicletype.getColor(string)));
    }

    @WebMethod(action="Vehicletype: getDecel")
    public double Vehicletype_getDecel(@WebParam(name="typeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicletype.getDecel(string)));
    }

    @WebMethod(action="Vehicletype: getEmissionClass")
    public String Vehicletype_getEmissionClass(@WebParam(name="typeID") String string) {
        return this.helper.getString(this.sumo.get_cmd(Vehicletype.getEmissionClass(string)));
    }

    @WebMethod(action="Vehicletype: Returns a list of all known vehicle types.")
    public SumoStringList Vehicletype_getIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(Vehicletype.getIDList()));
    }

    @WebMethod(action="Vehicletype: Returns the number of all known vehicle types.")
    public int Vehicletype_getIDCount() {
        return this.helper.getInt(this.sumo.get_cmd(Vehicletype.getIDCount()));
    }

    @WebMethod(action="Vehicletype: getImperfection")
    public double Vehicletype_getImperfection(@WebParam(name="typeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicletype.getImperfection(string)));
    }

    @WebMethod(action="Vehicletype: getLength")
    public double Vehicletype_getLength(@WebParam(name="typeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicletype.getLength(string)));
    }

    @WebMethod(action="Vehicletype: getMaxSpeed")
    public double Vehicletype_getMaxSpeed(@WebParam(name="typeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicletype.getMaxSpeed(string)));
    }

    @WebMethod(action="Vehicletype: getMinGap")
    public double Vehicletype_getMinGap(@WebParam(name="typeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicletype.getMinGap(string)));
    }

    @WebMethod(action="Vehicletype: getShapeClass")
    public String Vehicletype_getShapeClass(@WebParam(name="typeID") String string) {
        return this.helper.getString(this.sumo.get_cmd(Vehicletype.getShapeClass(string)));
    }

    @WebMethod(action="Vehicletype: getSpeedDeviation")
    public double Vehicletype_getSpeedDeviation(@WebParam(name="typeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicletype.getSpeedDeviation(string)));
    }

    @WebMethod(action="Vehicletype: getSpeedFactor")
    public double Vehicletype_getSpeedFactor(@WebParam(name="typeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicletype.getSpeedFactor(string)));
    }

    @WebMethod(action="Vehicletype: getTau")
    public double Vehicletype_getTau(@WebParam(name="typeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicletype.getTau(string)));
    }

    @WebMethod(action="Vehicletype: getVehicleClass")
    public String Vehicletype_getVehicleClass(@WebParam(name="typeID") String string) {
        return this.helper.getString(this.sumo.get_cmd(Vehicletype.getVehicleClass(string)));
    }

    @WebMethod(action="Vehicletype: getWidth")
    public double Vehicletype_getWidth(@WebParam(name="typeID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Vehicletype.getWidth(string)));
    }

    @WebMethod(action="Lane: getAllowed")
    public SumoStringList Lane_getAllowed(@WebParam(name="laneID") String string) {
        return this.helper.getStringList(this.sumo.get_cmd(Lane.getAllowed(string)));
    }

    @WebMethod(action="Lane: Returns the CO2 emission in mg for the last time step on the given lane.")
    public double Lane_getCO2Emission(@WebParam(name="laneID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Lane.getCO2Emission(string)));
    }

    @WebMethod(action="Lane: Returns the CO emission in mg for the last time step on the given lane.")
    public double Lane_getCOEmission(@WebParam(name="laneID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Lane.getCOEmission(string)));
    }

    @WebMethod(action="Lane: getDisallowed")
    public SumoStringList Lane_getDisallowed(@WebParam(name="laneID") String string) {
        return this.helper.getStringList(this.sumo.get_cmd(Lane.getDisallowed(string)));
    }

    @WebMethod(action="Lane: getEdgeID")
    public String Lane_getEdgeID(@WebParam(name="laneID") String string) {
        return this.helper.getString(this.sumo.get_cmd(Lane.getEdgeID(string)));
    }

    @WebMethod(action="Lane: Returns the fuel consumption in ml for the last time step on the given lane.")
    public double Lane_getFuelConsumption(@WebParam(name="laneID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Lane.getFuelConsumption(string)));
    }

    @WebMethod(action="Lane: Returns the HC emission in mg for the last time step on the given lane.")
    public double Lane_getHCEmission(@WebParam(name="laneID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Lane.getHCEmission(string)));
    }

    @WebMethod(action="Lane: Returns a list of all lanes in the network.")
    public SumoStringList Lane_getIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(Lane.getIDList()));
    }

    @WebMethod(action="Lane: Returns the number of all lanes in the network.")
    public int Lane_getIDCount() {
        return this.helper.getInt(this.sumo.get_cmd(Lane.getIDCount()));
    }

    @WebMethod(action="Lane: Returns the total number of halting vehicles for the last time step on the given lane.")
    public int Lane_getLastStepHaltingNumber(@WebParam(name="laneID") String string) {
        return this.helper.getInt(this.sumo.get_cmd(Lane.getLastStepHaltingNumber(string)));
    }

    @WebMethod(action="Lane: Returns the total vehicle length in m for the last time step on the given lane.")
    public double Lane_getLastStepLength(@WebParam(name="laneID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Lane.getLastStepLength(string)));
    }

    @WebMethod(action="Lane: Returns the average speed in m/s for the last time step on the given lane.")
    public double Lane_getLastStepMeanSpeed(@WebParam(name="laneID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Lane.getLastStepMeanSpeed(string)));
    }

    @WebMethod(action="Lane: Returns the occupancy in % for the last time step on the given lane.")
    public double Lane_getLastStepOccupancy(@WebParam(name="laneID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Lane.getLastStepOccupancy(string)));
    }

    @WebMethod(action="Lane: Returns the subscription results for the last time step and the given lane.")
    public SumoStringList Lane_getLastStepVehicleIDs(@WebParam(name="laneID") String string) {
        return this.helper.getStringList(this.sumo.get_cmd(Lane.getLastStepVehicleIDs(string)));
    }

    @WebMethod(action="Lane: Returns the total number of vehicles for the last time step on the given lane.")
    public int Lane_getLastStepVehicleNumber(@WebParam(name="laneID") String string) {
        return this.helper.getInt(this.sumo.get_cmd(Lane.getLastStepVehicleNumber(string)));
    }

    @WebMethod(action="Lane: getLength")
    public double Lane_getLength(@WebParam(name="laneID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Lane.getLength(string)));
    }

    @WebMethod(action="Lane: getLinkNumber")
    public int Lane_getLinkNumber(@WebParam(name="laneID") String string) {
        return this.helper.getInt(this.sumo.get_cmd(Lane.getLinkNumber(string)));
    }

    @WebMethod(action="Lane: getLinks")
    public SumoStringList Lane_getLinks(@WebParam(name="laneID") String string) {
        return this.helper.getStringList(this.sumo.get_cmd(Lane.getLinks(string)));
    }

    @WebMethod(action="Lane: getMaxSpeed")
    public double Lane_getMaxSpeed(@WebParam(name="laneID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Lane.getMaxSpeed(string)));
    }

    @WebMethod(action="Lane: getWaitingTime")
    public double Lane_getWaitingTime(@WebParam(name="laneID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Lane.getWaitingTime(string)));
    }

    @WebMethod(action="Lane: Returns the NOx emission in mg for the last time step on the given lane.")
    public double Lane_getNOxEmission(@WebParam(name="laneID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Lane.getNOxEmission(string)));
    }

    @WebMethod(action="Lane: Returns the noise emission in db for the last time step on the given lane.")
    public double Lane_getNoiseEmission(@WebParam(name="laneID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Lane.getNoiseEmission(string)));
    }

    @WebMethod(action="Lane: Returns the particular matter emission in mg for the last time step on the given lane.")
    public double Lane_getPMxEmission(@WebParam(name="laneID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Lane.getPMxEmission(string)));
    }

    @WebMethod(action="Lane: getShape")
    public SumoGeometry Lane_getShape(@WebParam(name="laneID") String string) {
        return this.helper.getPolygon(this.sumo.get_cmd(Lane.getShape(string)));
    }

    @WebMethod(action="Lane: Returns the estimated travel time in s for the last time step on the given lane.")
    public double Lane_getTraveltime(@WebParam(name="laneID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Lane.getTraveltime(string)));
    }

    @WebMethod(action="Lane: getWidth")
    public double Lane_getWidth(@WebParam(name="laneID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Lane.getWidth(string)));
    }

    @WebMethod(action="Polygon: Returns the subscription results for the last time step and the given poi.")
    public SumoColor Polygon_getColor(@WebParam(name="polygonID") String string) {
        return this.helper.getColor(this.sumo.get_cmd(Polygon.getColor(string)));
    }

    @WebMethod(action="Polygon: Returns a list of all polygons in the network.")
    public SumoStringList Polygon_getIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(Polygon.getIDList()));
    }

    @WebMethod(action="Polygon: Returns the number of all polygons in the network.")
    public int Polygon_getIDCount() {
        return this.helper.getInt(this.sumo.get_cmd(Polygon.getIDCount()));
    }

    @WebMethod(action="Polygon: getShape")
    public SumoGeometry Polygon_getShape(@WebParam(name="polygonID") String string) {
        return this.helper.getPolygon(this.sumo.get_cmd(Polygon.getShape(string)));
    }

    @WebMethod(action="Polygon: getType")
    public String Polygon_getType(@WebParam(name="polygonID") String string) {
        return this.helper.getString(this.sumo.get_cmd(Polygon.getType(string)));
    }

    @WebMethod(action="Poi: add")
    public int Poi_add(@WebParam(name="poiID") String string, @WebParam(name="x") double d, @WebParam(name="y") double d2, @WebParam(name="color") SumoColor sumoColor, @WebParam(name="poiType") String string2, @WebParam(name="layer") int n) {
        return this.helper.getInt(this.sumo.get_cmd(Poi.add(string, d, d2, sumoColor, string2, n)));
    }

    @WebMethod(action="Poi: Returns the color of the given poi.")
    public SumoColor Poi_getColor(@WebParam(name="poiID") String string) {
        return this.helper.getColor(this.sumo.get_cmd(Poi.getColor(string)));
    }

    @WebMethod(action="Poi: Returns a list of all pois in the network.")
    public SumoStringList Poi_getIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(Poi.getIDList()));
    }

    @WebMethod(action="Poi: Returns the number of all pois in the network.")
    public int Poi_getIDCount() {
        return this.helper.getInt(this.sumo.get_cmd(Poi.getIDCount()));
    }

    @WebMethod(action="Poi: getPosition")
    public SumoPosition2D Poi_getPosition(@WebParam(name="poiID") String string) {
        return this.helper.getPosition2D(this.sumo.get_cmd(Poi.getPosition(string)));
    }

    @WebMethod(action="Poi: getType")
    public String Poi_getType(@WebParam(name="poiID") String string) {
        return this.helper.getString(this.sumo.get_cmd(Poi.getType(string)));
    }

    @WebMethod(action="Junction: Returns a list of all junctions in the network.")
    public SumoStringList Junction_getIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(Junction.getIDList()));
    }

    @WebMethod(action="Junction: getShape")
    public SumoGeometry Junction_getShape(@WebParam(name="junctionID") String string) {
        return this.helper.getPolygon(this.sumo.get_cmd(Junction.getShape(string)));
    }

    @WebMethod(action="Junction: Returns the number of all junctions in the network.")
    public int Junction_getIDCount() {
        return this.helper.getInt(this.sumo.get_cmd(Junction.getIDCount()));
    }

    @WebMethod(action="Junction: Returns the subscription results for the last time step and the given junction.")
    public SumoPosition2D Junction_getPosition(@WebParam(name="junctionID") String string) {
        return this.helper.getPosition2D(this.sumo.get_cmd(Junction.getPosition(string)));
    }

    @WebMethod(action="Gui: Returns the subscription results for the last time step and the given view.")
    public SumoBoundingBox GUI_getBoundary(@WebParam(name="viewID") String string) {
        return this.helper.getBoundingBox(this.sumo.get_cmd(Gui.getBoundary(string)));
    }

    @WebMethod(action="Gui: Returns the list of available views (open windows).")
    public SumoStringList GUI_getIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(Gui.getIDList()));
    }

    @WebMethod(action="Gui: Returns the x and y offset of the center of the current view.")
    public SumoPosition2D GUI_getOffset(@WebParam(name="viewID") String string) {
        return this.helper.getPosition2D(this.sumo.get_cmd(Gui.getOffset(string)));
    }

    @WebMethod(action="Gui: Returns the name of the current coloring scheme.")
    public String GUI_getSchema(@WebParam(name="viewID") String string) {
        return this.helper.getString(this.sumo.get_cmd(Gui.getSchema(string)));
    }

    @WebMethod(action="Gui: Returns the current zoom factor.")
    public double GUI_getZoom(@WebParam(name="viewID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Gui.getZoom(string)));
    }

    @WebMethod(action="Route: Returns the subscription results for the last time step and the given route.")
    public SumoStringList Route_getEdges(@WebParam(name="routeID") String string) {
        return this.helper.getStringList(this.sumo.get_cmd(Route.getEdges(string)));
    }

    @WebMethod(action="Route: Returns a list of all routes in the network.")
    public SumoStringList Route_getIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(Route.getIDList()));
    }

    @WebMethod(action="Route: Returns the number of all routes in the network.")
    public int Route_getIDCount() {
        return this.helper.getInt(this.sumo.get_cmd(Route.getIDCount()));
    }

    @WebMethod(action="Inductionloop: Returns a list of all induction loops in the network.")
    public SumoStringList Inductionloop_getIDList() {
        return this.helper.getStringList(this.sumo.get_cmd(Inductionloop.getIDList()));
    }

    @WebMethod(action="Inductionloop: Returns the number of induction loops in the network.")
    public int Inductionloop_getIDCount() {
        return this.helper.getInt(this.sumo.get_cmd(Inductionloop.getIDCount()));
    }

    @WebMethod(action="Inductionloop: Returns the id of the lane the loop is on.")
    public String Inductionloop_getLaneID(@WebParam(name="loopID") String string) {
        return this.helper.getString(this.sumo.get_cmd(Inductionloop.getLaneID(string)));
    }

    @WebMethod(action="Inductionloop: getLastStepMeanLength")
    public double Inductionloop_getLastStepMeanLength(@WebParam(name="loopID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Inductionloop.getLastStepMeanLength(string)));
    }

    @WebMethod(action="Inductionloop: getLastStepMeanSpeed")
    public double Inductionloop_getLastStepMeanSpeed(@WebParam(name="loopID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Inductionloop.getLastStepMeanSpeed(string)));
    }

    @WebMethod(action="Inductionloop: getLastStepOccupancy")
    public double Inductionloop_getLastStepOccupancy(@WebParam(name="loopID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Inductionloop.getLastStepOccupancy(string)));
    }

    @WebMethod(action="Inductionloop: getLastStepVehicleIDs")
    public SumoStringList Inductionloop_getLastStepVehicleIDs(@WebParam(name="loopID") String string) {
        return this.helper.getStringList(this.sumo.get_cmd(Inductionloop.getLastStepVehicleIDs(string)));
    }

    @WebMethod(action="Inductionloop: getLastStepVehicleNumber")
    public int Inductionloop_getLastStepVehicleNumber(@WebParam(name="loopID") String string) {
        return this.helper.getInt(this.sumo.get_cmd(Inductionloop.getLastStepVehicleNumber(string)));
    }

    @WebMethod(action="Inductionloop: Returns the position measured from the beginning of the lane.")
    public double Inductionloop_getPosition(@WebParam(name="loopID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Inductionloop.getPosition(string)));
    }

    @WebMethod(action="Inductionloop: getTimeSinceDetection")
    public double Inductionloop_getTimeSinceDetection(@WebParam(name="loopID") String string) {
        return this.helper.getDouble(this.sumo.get_cmd(Inductionloop.getTimeSinceDetection(string)));
    }

    @WebMethod(action="Inductionloop: Returns the subscription results for the last time step and the given loop.")
    public int Inductionloop_getVehicleData(@WebParam(name="loopID") SumoStringList sumoStringList) {
        return this.helper.getInt(this.sumo.get_cmd(Inductionloop.getVehicleData(sumoStringList)));
    }
}

