/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.ws;

import de.tudresden.sumo.util.ConvertHelper;
import de.tudresden.sumo.util.Sumo;
import de.tudresden.ws.Service;
import de.tudresden.ws.Traci;
import de.tudresden.ws.conf.Config;
import de.tudresden.ws.log.Log;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.ws.BindingType;

@WebService(serviceName="Sumo-Webservice")
@BindingType(value="http://java.sun.com/xml/ns/jaxws/2003/05/soap/bindings/HTTP/")
public class Service_Impl
extends Traci
implements Service {
    Log logger;
    Config conf;
    Sumo sumo;
    ConvertHelper helper;

    public Service_Impl(Config config) {
        this.conf = config;
        this.logger = config.logger;
        this.conf.refresh_actiontime();
        this.helper = new ConvertHelper(this.logger);
    }

    @Override
    @WebMethod(action="start service")
    public String start(@WebParam(name="user") String string) {
        String string2 = "failed";
        if (!this.conf.running) {
            this.conf.running = true;
            this.logger.write("Benutzer " + string + " startet den " + this.conf.name + " Service", 1);
            this.sumo = new Sumo(this.conf);
            this.sumo.start_ws();
            super.init(this.sumo, this.logger, this.helper);
            this.conf.refresh_actiontime();
            string2 = "success";
        }
        return string2;
    }

    @Override
    @WebMethod(action="stop service")
    public String stop(@WebParam(name="user") String string) {
        this.sumo.stop_instance();
        this.conf.running = false;
        return "success";
    }

    @Override
    @WebMethod(action="status")
    public String get_Status(@WebParam(name="user") String string) {
        this.conf.refresh_actiontime();
        return "Running: " + this.conf.running;
    }

    @Override
    @WebMethod(action="last action time")
    public String LastActionTime() {
        return this.conf.get_actiontime();
    }

    @Override
    @WebMethod(action="version info")
    @WebResult(name="output")
    public String version() {
        return this.conf.version;
    }

    @Override
    @WebMethod(action="activate text output. only for debugging purposes.")
    public String TXT_output(@WebParam(name="active") boolean bl) {
        this.logger.txt_output(bl);
        return "success";
    }

    @Override
    @WebMethod(action="add Options to sumo binary")
    public void addOption(String string, String string2) {
        if (!this.conf.running) {
            this.conf.sumo_output.put(string, string2);
        }
    }

    @Override
    @WebMethod(action="do timestep")
    public void doTimestep() {
        if (this.conf.running) {
            this.sumo.do_timestep();
        }
    }

    @Override
    @WebMethod(action="set the configuration file")
    public void setConfig(@WebParam(name="filename") String string) {
        if (!this.conf.running) {
            Config.config_file = string;
        }
    }

    @Override
    @WebMethod(action="set the sumo binary")
    public void setSumoBinary(@WebParam(name="binary") String string) {
        if (!this.conf.running) {
            Config.sumo_bin = string;
        }
    }
}

