/*
 * Decompiled with CFR 0.152.
 */
package ui.propertypanels;

import classes.Project;
import classes.TypeSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import simulation.VehicleType;
import trafficdefinition.AreaFlow;
import ui.controls.SimTimeEdit;
import ui.dialogs.DlgSelectTypes;

public class PnlAreaFlowProperties
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton btnChangeColor = null;
    private JButton btnSelectVehicleTypes = null;
    private AreaFlow currentAreaFlow = null;
    private JLabel lblBeginTimeTitle = null;
    private JLabel lblColor = null;
    private JLabel lblEndTimeTitle = null;
    private JLabel lblNameTitle = null;
    private JLabel lblNumberOfVehiclesTitle = null;
    private JSpinner spnNumberOfVehicles = null;
    private SimTimeEdit steBeginTime = null;
    private SimTimeEdit steEndTime = null;
    private JTextField txtName = null;
    private JCheckBox chkExportPolygon = null;
    private JCheckBox chkEnabled = null;

    public PnlAreaFlowProperties() {
        this.initialize();
    }

    public void setAreaFlow(AreaFlow areaFlow) {
        this.currentAreaFlow = areaFlow;
        this.txtName.setText(this.currentAreaFlow.getName());
        this.steBeginTime.setValue(this.currentAreaFlow.getBeginTime());
        this.steEndTime.setValue(this.currentAreaFlow.getEndTime());
        this.spnNumberOfVehicles.setValue(this.currentAreaFlow.getNumberOfVehicles());
        this.btnChangeColor.setBackground(this.currentAreaFlow.getColor());
        this.chkExportPolygon.setSelected(this.currentAreaFlow.getExportPolygon());
        this.chkEnabled.setSelected(this.currentAreaFlow.isEnabled());
    }

    private JButton getBtnChangeColor() {
        if (this.btnChangeColor == null) {
            this.btnChangeColor = new JButton();
            this.btnChangeColor.setPreferredSize(new Dimension(86, 20));
            this.btnChangeColor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PnlAreaFlowProperties.this.ChangeColor();
                }
            });
        }
        return this.btnChangeColor;
    }

    private JButton getBtnSelectVehicleTypes() {
        if (this.btnSelectVehicleTypes == null) {
            this.btnSelectVehicleTypes = new JButton();
            this.btnSelectVehicleTypes.setText("Vehicle types...");
            this.btnSelectVehicleTypes.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/vehicletypes.png")));
            this.btnSelectVehicleTypes.setPreferredSize(new Dimension(150, 20));
            this.btnSelectVehicleTypes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PnlAreaFlowProperties.this.SelectVehicleTypes();
                }
            });
        }
        return this.btnSelectVehicleTypes;
    }

    private JSpinner getSpnNumberOfVehicles() {
        if (this.spnNumberOfVehicles == null) {
            this.spnNumberOfVehicles = new JSpinner();
            this.spnNumberOfVehicles.setModel(new SpinnerNumberModel(1, 1, 1000000, 1));
            this.spnNumberOfVehicles.setPreferredSize(new Dimension(70, 20));
            this.spnNumberOfVehicles.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    PnlAreaFlowProperties.this.currentAreaFlow.setNumberOfVehicles((Integer)PnlAreaFlowProperties.this.spnNumberOfVehicles.getValue());
                }
            });
        }
        return this.spnNumberOfVehicles;
    }

    private SimTimeEdit getSteBeginTime() {
        if (this.steBeginTime == null) {
            this.steBeginTime = new SimTimeEdit();
            this.steBeginTime.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    PnlAreaFlowProperties.this.currentAreaFlow.setBeginTime(PnlAreaFlowProperties.this.steBeginTime.getValue());
                }
            });
        }
        return this.steBeginTime;
    }

    private SimTimeEdit getSteEndTime() {
        if (this.steEndTime == null) {
            this.steEndTime = new SimTimeEdit();
            this.steEndTime.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    PnlAreaFlowProperties.this.currentAreaFlow.setEndTime(PnlAreaFlowProperties.this.steEndTime.getValue());
                }
            });
        }
        return this.steEndTime;
    }

    private JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField();
            this.txtName.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    PnlAreaFlowProperties.this.currentAreaFlow.setName(PnlAreaFlowProperties.this.txtName.getText());
                }
            });
        }
        return this.txtName;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 6;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridy = 5;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.insets = new Insets(3, 0, 3, 0);
        gridBagConstraints3.gridy = 2;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.insets = new Insets(3, 0, 3, 0);
        gridBagConstraints4.gridy = 1;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.gridy = 3;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.insets = new Insets(15, 2, 2, 2);
        gridBagConstraints6.fill = 0;
        gridBagConstraints6.gridwidth = 2;
        gridBagConstraints6.anchor = 11;
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.gridy = 7;
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.anchor = 17;
        gridBagConstraints7.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints7.gridy = 4;
        this.lblColor = new JLabel();
        this.lblColor.setText("Color:");
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 1;
        gridBagConstraints8.fill = 1;
        gridBagConstraints8.insets = new Insets(2, 0, 2, 10);
        gridBagConstraints8.gridy = 4;
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.anchor = 17;
        gridBagConstraints9.insets = new Insets(0, 10, 0, 5);
        gridBagConstraints9.gridy = 3;
        this.lblNumberOfVehiclesTitle = new JLabel();
        this.lblNumberOfVehiclesTitle.setText("Number of vehicles:");
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridx = 0;
        gridBagConstraints10.anchor = 18;
        gridBagConstraints10.insets = new Insets(3, 10, 0, 0);
        gridBagConstraints10.gridy = 2;
        this.lblEndTimeTitle = new JLabel();
        this.lblEndTimeTitle.setText("End time:");
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.anchor = 18;
        gridBagConstraints11.insets = new Insets(3, 10, 0, 0);
        gridBagConstraints11.gridy = 1;
        this.lblBeginTimeTitle = new JLabel();
        this.lblBeginTimeTitle.setText("Begin time:");
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.fill = 2;
        gridBagConstraints12.gridy = 0;
        gridBagConstraints12.weightx = 1.0;
        gridBagConstraints12.insets = new Insets(10, 0, 0, 10);
        gridBagConstraints12.gridx = 1;
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 0;
        gridBagConstraints13.anchor = 17;
        gridBagConstraints13.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints13.gridy = 0;
        this.lblNameTitle = new JLabel();
        this.lblNameTitle.setText("Name:");
        this.setSize(300, 254);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblNameTitle, gridBagConstraints13);
        this.add((Component)this.getTxtName(), gridBagConstraints12);
        this.add((Component)this.lblBeginTimeTitle, gridBagConstraints11);
        this.add((Component)this.lblEndTimeTitle, gridBagConstraints10);
        this.add((Component)this.lblNumberOfVehiclesTitle, gridBagConstraints9);
        this.add((Component)this.getBtnChangeColor(), gridBagConstraints8);
        this.add((Component)this.lblColor, gridBagConstraints7);
        this.add((Component)this.getBtnSelectVehicleTypes(), gridBagConstraints6);
        this.add((Component)this.getSpnNumberOfVehicles(), gridBagConstraints5);
        this.add((Component)this.getSteBeginTime(), gridBagConstraints4);
        this.add((Component)this.getSteEndTime(), gridBagConstraints3);
        this.add((Component)this.getChkExportPolygon(), gridBagConstraints2);
        this.add((Component)this.getChkEnabled(), gridBagConstraints);
    }

    protected void ChangeColor() {
        Color color = JColorChooser.showDialog(this, "Select flow color", this.currentAreaFlow.getColor());
        if (color != null) {
            this.currentAreaFlow.setColor(color);
            this.btnChangeColor.setBackground(color);
        }
    }

    protected void SelectVehicleTypes() {
        TypeSelection<VehicleType> typeSelection = new TypeSelection<VehicleType>(Project.getCurrentlyLoadedProject().getVehicleTypes());
        TypeSelection<VehicleType> typeSelection2 = new TypeSelection<VehicleType>(this.currentAreaFlow.getVehicleSelection());
        typeSelection2.addTypesNotInSelection(typeSelection);
        DlgSelectTypes<VehicleType> dlgSelectTypes = new DlgSelectTypes<VehicleType>(typeSelection2);
        dlgSelectTypes.setVisible(true);
        if (dlgSelectTypes.getAnswer() == 0) {
            typeSelection2.removeTypesWithZeroPercentage();
            this.currentAreaFlow.setVehicleSelection(typeSelection2);
        }
    }

    private JCheckBox getChkExportPolygon() {
        if (this.chkExportPolygon == null) {
            this.chkExportPolygon = new JCheckBox();
            this.chkExportPolygon.setText("Export polygon");
            this.chkExportPolygon.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    PnlAreaFlowProperties.this.currentAreaFlow.setExportPolygon(PnlAreaFlowProperties.this.chkExportPolygon.isSelected());
                }
            });
        }
        return this.chkExportPolygon;
    }

    private JCheckBox getChkEnabled() {
        if (this.chkEnabled == null) {
            this.chkEnabled = new JCheckBox();
            this.chkEnabled.setText("Enabled");
            this.chkEnabled.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    PnlAreaFlowProperties.this.currentAreaFlow.setEnabled(PnlAreaFlowProperties.this.chkEnabled.isSelected());
                }
            });
        }
        return this.chkEnabled;
    }
}

