/*
 * Decompiled with CFR 0.152.
 */
package ui.dialogs;

import classes.Pair;
import classes.Project;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import simulation.Simulation;
import trafficdefinition.TrafficDefinitionLayer;
import ui.ExportLayersTableModel;
import ui.controls.SimTimeEdit;

public class DlgExportSimulation
extends JDialog {
    private static final long serialVersionUID = 1L;
    private List<Pair<TrafficDefinitionLayer, Boolean>> layersToExport = new ArrayList<Pair<TrafficDefinitionLayer, Boolean>>();
    private Simulation simulation;
    private int answer = 2;
    private JButton btnBrowse = null;
    private JButton btnCancel = null;
    private JButton btnExport = null;
    private JPanel jContentPane = null;
    private JLabel lblExportPath = null;
    private JLabel lblLayersToExport = null;
    private JTextField txtExportPath = null;
    private JLabel lblName = null;
    private JTextField txtSimulationName = null;
    private SimTimeEdit steBeginTime = null;
    private SimTimeEdit steEndTime = null;
    private JPanel pnlEndTime = null;
    private JPanel pnlBeginTime = null;
    private JCheckBox chkExportPolygons = null;
    private JScrollPane scrlLayersToExport = null;
    private JTable tblLayersToExport = null;
    private JCheckBox chkRoadNetworkSpeedInKMH = null;

    public DlgExportSimulation(Frame frame, Project project) {
        super(frame);
        this.initialize();
        this.simulation = project.getSimulation();
        this.txtExportPath.setText(this.simulation.getExportPath());
        this.txtSimulationName.setText(this.simulation.getName());
        this.steBeginTime.setValue(this.simulation.getBeginTime());
        this.steEndTime.setValue(this.simulation.getEndTime());
        this.chkExportPolygons.setSelected(this.simulation.getExportPolygons());
        this.chkRoadNetworkSpeedInKMH.setSelected(this.simulation.isRoadNetworkSpeedInKMH());
        for (TrafficDefinitionLayer trafficDefinitionLayer : project.getTrafficLayers()) {
            this.layersToExport.add(new Pair<TrafficDefinitionLayer, Boolean>(trafficDefinitionLayer, true));
        }
        this.tblLayersToExport.setModel(new ExportLayersTableModel(this.layersToExport));
    }

    public int getAnswer() {
        return this.answer;
    }

    public List<TrafficDefinitionLayer> getSelectedLayers() {
        ArrayList<TrafficDefinitionLayer> arrayList = new ArrayList<TrafficDefinitionLayer>();
        for (Pair<TrafficDefinitionLayer, Boolean> pair : this.layersToExport) {
            if (!pair.getSecond().booleanValue()) continue;
            arrayList.add(pair.getFirst());
        }
        return arrayList;
    }

    private JButton getBtnBrowse() {
        if (this.btnBrowse == null) {
            this.btnBrowse = new JButton();
            this.btnBrowse.setBounds(new Rectangle(342, 35, 93, 20));
            this.btnBrowse.setText("Browse...");
            this.btnBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DlgExportSimulation.this.BrowseForExportPath();
                }
            });
        }
        return this.btnBrowse;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setBounds(new Rectangle(281, 290, 73, 24));
            this.btnCancel.setText("Cancel");
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DlgExportSimulation.this.CancelExport();
                }
            });
        }
        return this.btnCancel;
    }

    private JButton getBtnExport() {
        if (this.btnExport == null) {
            this.btnExport = new JButton();
            this.btnExport.setBounds(new Rectangle(361, 290, 74, 24));
            this.btnExport.setText("Export");
            this.btnExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DlgExportSimulation.this.Export();
                }
            });
        }
        return this.btnExport;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.lblName = new JLabel();
            this.lblName.setBounds(new Rectangle(9, 63, 112, 23));
            this.lblName.setText("Simulation name:");
            this.lblLayersToExport = new JLabel();
            this.lblLayersToExport.setBounds(new Rectangle(10, 207, 160, 18));
            this.lblLayersToExport.setText("Select layers to export:");
            this.lblExportPath = new JLabel();
            this.lblExportPath.setBounds(new Rectangle(9, 12, 73, 19));
            this.lblExportPath.setText("Export path:");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add((Component)this.lblExportPath, null);
            this.jContentPane.add((Component)this.getTxtExportPath(), null);
            this.jContentPane.add((Component)this.getBtnBrowse(), null);
            this.jContentPane.add((Component)this.lblLayersToExport, null);
            this.jContentPane.add((Component)this.getBtnExport(), null);
            this.jContentPane.add((Component)this.getBtnCancel(), null);
            this.jContentPane.add((Component)this.lblName, null);
            this.jContentPane.add((Component)this.getTxtSimulationName(), null);
            this.jContentPane.add((Component)this.getPnlEndTime(), null);
            this.jContentPane.add((Component)this.getPnlBeginTime(), null);
            this.jContentPane.add((Component)this.getChkExportPolygons(), null);
            this.jContentPane.add((Component)this.getScrlLayersToExport(), null);
            this.jContentPane.add((Component)this.getChkRoadNetworkSpeedInKMH(), null);
        }
        return this.jContentPane;
    }

    private JTextField getTxtExportPath() {
        if (this.txtExportPath == null) {
            this.txtExportPath = new JTextField();
            this.txtExportPath.setBounds(new Rectangle(9, 35, 330, 21));
        }
        return this.txtExportPath;
    }

    private void initialize() {
        this.setSize(448, 352);
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        this.setTitle("Export Simulation");
        this.setContentPane(this.getJContentPane());
    }

    protected void BrowseForExportPath() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Select export path");
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(1);
        if (jFileChooser.showSaveDialog(this) == 0) {
            this.txtExportPath.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    protected void CancelExport() {
        this.answer = 2;
        this.setVisible(false);
    }

    protected void Export() {
        this.answer = 0;
        if (this.txtExportPath.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Please select the export path");
            return;
        }
        if (this.txtSimulationName.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Please enter a name for the simulation");
            return;
        }
        if (this.steEndTime.getValue() <= this.steBeginTime.getValue()) {
            JOptionPane.showMessageDialog(this, "The simulation's end time must be later that its begin time");
            return;
        }
        File file = new File(this.txtExportPath.getText().trim());
        if (!file.exists()) {
            JOptionPane.showMessageDialog(this, "The specified export folder does not exist");
            return;
        }
        this.simulation.setExportPath(file.getAbsolutePath());
        this.simulation.setBeginTime(this.steBeginTime.getValue());
        this.simulation.setEndTime(this.steEndTime.getValue());
        this.simulation.setName(this.txtSimulationName.getText().trim());
        this.simulation.setExportPolygons(this.chkExportPolygons.isSelected());
        this.simulation.setRoadNetworkSpeedInKMH(this.chkRoadNetworkSpeedInKMH.isSelected());
        this.setVisible(false);
    }

    private JTextField getTxtSimulationName() {
        if (this.txtSimulationName == null) {
            this.txtSimulationName = new JTextField();
            this.txtSimulationName.setBounds(new Rectangle(10, 89, 169, 21));
        }
        return this.txtSimulationName;
    }

    private SimTimeEdit getSteBeginTime() {
        if (this.steBeginTime == null) {
            this.steBeginTime = new SimTimeEdit();
        }
        return this.steBeginTime;
    }

    private SimTimeEdit getSteEndTime() {
        if (this.steEndTime == null) {
            this.steEndTime = new SimTimeEdit();
        }
        return this.steEndTime;
    }

    private JPanel getPnlEndTime() {
        if (this.pnlEndTime == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.pnlEndTime = new JPanel();
            this.pnlEndTime.setLayout(new GridBagLayout());
            this.pnlEndTime.setBounds(new Rectangle(223, 120, 206, 77));
            this.pnlEndTime.setBorder(BorderFactory.createTitledBorder(null, "End time", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlEndTime.add((Component)this.getSteEndTime(), gridBagConstraints);
        }
        return this.pnlEndTime;
    }

    private JPanel getPnlBeginTime() {
        if (this.pnlBeginTime == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.pnlBeginTime = new JPanel();
            this.pnlBeginTime.setLayout(new GridBagLayout());
            this.pnlBeginTime.setBounds(new Rectangle(10, 120, 206, 77));
            this.pnlBeginTime.setBorder(BorderFactory.createTitledBorder(null, "Begin time", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.pnlBeginTime.add((Component)this.getSteBeginTime(), gridBagConstraints);
        }
        return this.pnlBeginTime;
    }

    private JCheckBox getChkExportPolygons() {
        if (this.chkExportPolygons == null) {
            this.chkExportPolygons = new JCheckBox();
            this.chkExportPolygons.setBounds(new Rectangle(280, 258, 138, 21));
            this.chkExportPolygons.setText("Export polygons");
        }
        return this.chkExportPolygons;
    }

    private JScrollPane getScrlLayersToExport() {
        if (this.scrlLayersToExport == null) {
            this.scrlLayersToExport = new JScrollPane();
            this.scrlLayersToExport.setBounds(new Rectangle(11, 229, 267, 84));
            this.scrlLayersToExport.setViewportView(this.getTblLayersToExport());
        }
        return this.scrlLayersToExport;
    }

    private JTable getTblLayersToExport() {
        if (this.tblLayersToExport == null) {
            this.tblLayersToExport = new JTable();
        }
        return this.tblLayersToExport;
    }

    private JCheckBox getChkRoadNetworkSpeedInKMH() {
        if (this.chkRoadNetworkSpeedInKMH == null) {
            this.chkRoadNetworkSpeedInKMH = new JCheckBox();
            this.chkRoadNetworkSpeedInKMH.setBounds(new Rectangle(197, 88, 232, 21));
            this.chkRoadNetworkSpeedInKMH.setText("Road network speed in kmh");
        }
        return this.chkRoadNetworkSpeedInKMH;
    }
}

