/*
 * Decompiled with CFR 0.152.
 */
package ui;

import classes.Layer;
import classes.Project;
import classes.ProjectElement;
import enums.SelectionCount;
import interfaces.CurrentLayerChangedListener;
import interfaces.ModifiedCollectionListener;
import interfaces.ProjectChangedListener;
import interfaces.SelectionChangedListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import roadnetwork.Edge;
import roadnetwork.Junction;
import trafficdefinition.Accident;
import trafficdefinition.AreaFlow;
import trafficdefinition.Flow;
import trafficdefinition.HotSpot;
import trafficdefinition.School;
import trafficdefinition.TrafficArea;
import ui.Display;
import ui.propertypanels.PnlAccidentProperties;
import ui.propertypanels.PnlAreaFlowProperties;
import ui.propertypanels.PnlEdgeProperties;
import ui.propertypanels.PnlFlowProperties;
import ui.propertypanels.PnlHotSpotProperties;
import ui.propertypanels.PnlJunctionProperties;
import ui.propertypanels.PnlSchoolProperties;
import ui.propertypanels.PnlTrafficAreaProperties;

public class PnlProperties
extends JPanel
implements ProjectChangedListener,
ModifiedCollectionListener,
CurrentLayerChangedListener,
SelectionChangedListener {
    private static final long serialVersionUID = 1L;
    private JComboBox cmbElements = null;
    private JScrollPane scrollPane = null;
    private JLabel lblMessage = null;
    JComponent currentComponent = null;
    private Layer currentLayer = null;
    private Display mapDisplay = null;
    private JButton btnCenterOnSelectedElement = null;
    private JPanel pnlTop = null;

    public PnlProperties() {
        this.initialize();
        this.getScrollPane().setViewportView(this.getLblMessage());
        this.currentComponent = this.lblMessage;
    }

    public void setMapDisplay(Display display) {
        this.mapDisplay = display;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridy = 0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.gridx = 0;
        this.setSize(300, 200);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getScrollPane(), gridBagConstraints2);
        this.add((Component)this.getPnlTop(), gridBagConstraints);
    }

    private JLabel getLblMessage() {
        if (this.lblMessage == null) {
            this.lblMessage = new JLabel();
            this.lblMessage.setText("No project loaded");
            this.lblMessage.setHorizontalTextPosition(0);
            this.lblMessage.setHorizontalAlignment(0);
        }
        return this.lblMessage;
    }

    private JComboBox getCmbElements() {
        if (this.cmbElements == null) {
            this.cmbElements = new JComboBox();
            this.cmbElements.setPreferredSize(new Dimension(31, 20));
            this.cmbElements.setEnabled(false);
            this.cmbElements.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PnlProperties.this.SelectedElementChanged();
                }
            });
        }
        return this.cmbElements;
    }

    protected void SelectedElementChanged() {
        if (this.cmbElements.getSelectedIndex() != -1) {
            this.currentLayer.SelectElement((ProjectElement)this.cmbElements.getSelectedItem());
            this.mapDisplay.Refresh();
            this.ShowElementProperties((ProjectElement)this.cmbElements.getSelectedItem());
            this.btnCenterOnSelectedElement.setEnabled(true);
        } else {
            this.btnCenterOnSelectedElement.setEnabled(false);
        }
    }

    @Override
    public void SelectionChanged(SelectionCount selectionCount, ProjectElement projectElement) {
        switch (selectionCount) {
            case None: {
                this.cmbElements.setSelectedIndex(-1);
                this.getLblMessage().setText("No items selected");
                this.getScrollPane().setViewportView(this.lblMessage);
                this.currentComponent = this.lblMessage;
                break;
            }
            case Single: {
                this.cmbElements.setSelectedItem(projectElement);
                this.ShowElementProperties(projectElement);
                break;
            }
            case Multiple: {
                this.cmbElements.setSelectedIndex(-1);
                this.getLblMessage().setText("Multiple items selected");
                this.getScrollPane().setViewportView(this.lblMessage);
                this.currentComponent = this.lblMessage;
            }
        }
    }

    private void ShowElementProperties(ProjectElement projectElement) {
        if (projectElement instanceof Edge) {
            PnlEdgeProperties pnlEdgeProperties = new PnlEdgeProperties();
            pnlEdgeProperties.setEdge((Edge)projectElement);
            this.currentComponent = pnlEdgeProperties;
            this.getScrollPane().setViewportView(pnlEdgeProperties);
        } else if (projectElement instanceof Junction) {
            PnlJunctionProperties pnlJunctionProperties = new PnlJunctionProperties();
            pnlJunctionProperties.setJunction((Junction)projectElement);
            this.currentComponent = pnlJunctionProperties;
            this.getScrollPane().setViewportView(pnlJunctionProperties);
        } else if (projectElement instanceof Flow) {
            PnlFlowProperties pnlFlowProperties = new PnlFlowProperties();
            pnlFlowProperties.setFlow((Flow)projectElement);
            this.currentComponent = pnlFlowProperties;
            this.getScrollPane().setViewportView(pnlFlowProperties);
        } else if (projectElement instanceof AreaFlow) {
            PnlAreaFlowProperties pnlAreaFlowProperties = new PnlAreaFlowProperties();
            pnlAreaFlowProperties.setAreaFlow((AreaFlow)projectElement);
            this.currentComponent = pnlAreaFlowProperties;
            this.getScrollPane().setViewportView(pnlAreaFlowProperties);
        } else if (projectElement instanceof HotSpot) {
            PnlHotSpotProperties pnlHotSpotProperties = new PnlHotSpotProperties();
            pnlHotSpotProperties.setHotSpot((HotSpot)projectElement);
            this.currentComponent = pnlHotSpotProperties;
            this.getScrollPane().setViewportView(pnlHotSpotProperties);
        } else if (projectElement instanceof TrafficArea) {
            PnlTrafficAreaProperties pnlTrafficAreaProperties = new PnlTrafficAreaProperties();
            pnlTrafficAreaProperties.setArea((TrafficArea)projectElement);
            this.currentComponent = pnlTrafficAreaProperties;
            this.getScrollPane().setViewportView(pnlTrafficAreaProperties);
        } else if (projectElement instanceof School) {
            PnlSchoolProperties pnlSchoolProperties = new PnlSchoolProperties();
            pnlSchoolProperties.setSchool((School)projectElement);
            this.currentComponent = pnlSchoolProperties;
            this.getScrollPane().setViewportView(pnlSchoolProperties);
        } else if (projectElement instanceof Accident) {
            PnlAccidentProperties pnlAccidentProperties = new PnlAccidentProperties();
            pnlAccidentProperties.setAccident((Accident)projectElement);
            this.currentComponent = pnlAccidentProperties;
            this.getScrollPane().setViewportView(pnlAccidentProperties);
        } else {
            this.getLblMessage().setText("One item selected");
            this.getScrollPane().setViewportView(this.lblMessage);
            this.currentComponent = this.lblMessage;
        }
    }

    @Override
    public void CollectionModified() {
        this.cmbElements.setModel(new DefaultComboBoxModel<Object>(this.currentLayer.getElements().toArray()));
        this.cmbElements.updateUI();
    }

    @Override
    public void CurrentLayerChanged(Layer<? extends ProjectElement> layer) {
        if (this.currentLayer != null) {
            this.currentLayer.removeModifiedCollectionListener(this);
            this.currentLayer.removeSelectionChangedListener(this);
        }
        this.currentLayer = layer;
        this.cmbElements.setModel(new DefaultComboBoxModel<Object>(layer.getElements().toArray()));
        this.cmbElements.setEnabled(true);
        this.cmbElements.setSelectedIndex(-1);
        this.getLblMessage().setText("No items selected");
        this.getScrollPane().setViewportView(this.lblMessage);
        this.currentComponent = this.lblMessage;
        layer.addModifiedCollectionListener(this);
        layer.addSelectionChangedListener(this);
    }

    @Override
    public void ProjectChanged(Project project) {
        if (project == null) {
            this.currentLayer.removeModifiedCollectionListener(this);
            this.currentLayer.removeSelectionChangedListener(this);
            this.currentLayer = null;
            this.cmbElements.setModel(new DefaultComboBoxModel());
            this.cmbElements.setEnabled(false);
            this.getLblMessage().setText("No project loaded");
            this.getScrollPane().setViewportView(this.lblMessage);
            this.currentComponent = this.lblMessage;
        }
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
        }
        return this.scrollPane;
    }

    private JButton getBtnCenterOnSelectedElement() {
        if (this.btnCenterOnSelectedElement == null) {
            this.btnCenterOnSelectedElement = new JButton();
            this.btnCenterOnSelectedElement.setPreferredSize(new Dimension(20, 20));
            this.btnCenterOnSelectedElement.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/centeronelement.png")));
            this.btnCenterOnSelectedElement.setToolTipText("Center on element");
            this.btnCenterOnSelectedElement.setEnabled(false);
            this.btnCenterOnSelectedElement.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PnlProperties.this.CenterOnSelectedElement();
                }
            });
        }
        return this.btnCenterOnSelectedElement;
    }

    protected void CenterOnSelectedElement() {
        this.mapDisplay.CenterAndZoomOnElement((ProjectElement)this.cmbElements.getSelectedItem());
    }

    private JPanel getPnlTop() {
        if (this.pnlTop == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridx = 0;
            this.pnlTop = new JPanel();
            this.pnlTop.setLayout(new GridBagLayout());
            this.pnlTop.setPreferredSize(new Dimension(100, 20));
            this.pnlTop.add((Component)this.getCmbElements(), gridBagConstraints2);
            this.pnlTop.add((Component)this.getBtnCenterOnSelectedElement(), gridBagConstraints);
        }
        return this.pnlTop;
    }
}

