/*
 * Decompiled with CFR 0.152.
 */
package trafficdefinition;

import classes.Pair;
import classes.Project;
import classes.TypeSelection;
import enums.MotionRestriction;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import shapes.Ellipse2DExt;
import shapes.Point2DExt;
import shapes.Rectangle2DExt;
import simulation.VehicleType;
import tdl.XMLHelpers;
import trafficdefinition.Handle;
import trafficdefinition.TrafficDefinitionElement;

public class HotSpot
extends TrafficDefinitionElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Ellipse2DExt area;
    private Point2DExt center;
    private Color color = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
    private boolean DirectionIn = false;
    private int directionInBeginTime = 0;
    private int directionInEndTime = 100;
    private DirectionInTimeType DirectionInType = DirectionInTimeType.TimeOfDepartureFromSource;
    private boolean DirectionOut = false;
    private int directionOutBeginTime = 0;
    private int directionOutEndTime = 100;
    private int numberOfVehicles = 100;
    private double radiusx;
    private double radiusy;
    private TypeSelection<VehicleType> vehicleSelection;

    public HotSpot(Point2D.Double double_) {
        this.name = "Hotspot " + String.valueOf(increment++);
        this.center = new Point2DExt(double_);
        this.area = new Ellipse2DExt();
        this.vehicleSelection = new TypeSelection();
        this.vehicleSelection.add(new Pair<VehicleType, Float>(Project.getCurrentlyLoadedProject().getDefaultVehicleType(), Float.valueOf(1.0f)));
    }

    public HotSpot(HotSpot hotSpot) {
        super(hotSpot);
        this.numberOfVehicles = hotSpot.numberOfVehicles;
        this.color = new Color(hotSpot.color.getRGB());
        this.area = new Ellipse2DExt(hotSpot.area);
        this.center = new Point2DExt(hotSpot.center);
        this.radiusx = hotSpot.radiusx;
        this.radiusy = hotSpot.radiusy;
        this.DirectionIn = hotSpot.DirectionIn;
        this.directionInBeginTime = hotSpot.directionInBeginTime;
        this.directionInEndTime = hotSpot.directionInEndTime;
        this.DirectionInType = hotSpot.DirectionInType;
        this.DirectionOut = hotSpot.DirectionOut;
        this.directionOutBeginTime = hotSpot.directionOutBeginTime;
        this.directionOutEndTime = hotSpot.directionOutEndTime;
        this.vehicleSelection = new TypeSelection<VehicleType>(hotSpot.vehicleSelection);
    }

    @Override
    public void Draw(Graphics2D graphics2D, double d, boolean bl, boolean bl2) {
        Color color = graphics2D.getColor();
        if (!bl2) {
            graphics2D.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 100));
        }
        if (bl2) {
            graphics2D.setColor(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), 200));
        }
        if (this.area != null) {
            graphics2D.fill(this.area);
        }
        super.Draw(graphics2D, d, bl, bl2);
        graphics2D.setColor(color);
    }

    @Override
    public Rectangle2DExt getBounds() {
        Rectangle2D rectangle2D = this.area.getBounds2D();
        return new Rectangle2DExt(rectangle2D.getCenterX(), rectangle2D.getCenterY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public void createHandles() {
        ArrayList<Handle> arrayList = new ArrayList<Handle>();
        Handle handle = new Handle(this.center, "center", MotionRestriction.None);
        Handle handle2 = new Handle(new Point2D.Double(this.center.x + this.radiusx, this.center.y), "XRadius", MotionRestriction.Horizontal);
        Handle handle3 = new Handle(new Point2D.Double(this.center.x, this.center.y + this.radiusy), "YRadius", MotionRestriction.Vertical);
        arrayList.add(handle);
        arrayList.add(handle2);
        arrayList.add(handle3);
        this.addHandles(arrayList);
    }

    public Ellipse2DExt getArea() {
        return this.area;
    }

    public Color getColor() {
        return this.color;
    }

    public int getDirectionInBeginTime() {
        return this.directionInBeginTime;
    }

    public int getDirectionInEndTime() {
        return this.directionInEndTime;
    }

    public DirectionInTimeType getDirectionInType() {
        return this.DirectionInType;
    }

    public int getDirectionOutBeginTime() {
        return this.directionOutBeginTime;
    }

    public int getDirectionOutEndTime() {
        return this.directionOutEndTime;
    }

    public int getNumberOfVehicles() {
        return this.numberOfVehicles;
    }

    @Override
    public String getToolTip() {
        String string = "<html><b>HotSpot</b> " + this.name + "<br>" + "<b>Number of vehicles: </b> " + String.valueOf(this.numberOfVehicles) + "<br>" + "<b>Direction: </b>";
        if (this.DirectionIn) {
            string = string + "Incoming ";
        }
        if (this.DirectionOut) {
            string = string + "Outgoing ";
        }
        return string;
    }

    public TypeSelection<VehicleType> getVehicleSelection() {
        return this.vehicleSelection;
    }

    @Override
    public void handleLocationChanged(Handle handle) {
        if (handle.getName().equals("center")) {
            this.center = new Point2DExt(handle.getLocation());
            ((Handle)this.handles.get("XRadius")).setUnrestrictedLocation(new Point2D.Double(this.center.x + this.radiusx, this.center.y));
            ((Handle)this.handles.get("YRadius")).setUnrestrictedLocation(new Point2D.Double(this.center.x, this.center.y + this.radiusy));
        } else if (handle.getName().equals("XRadius")) {
            this.radiusx = handle.getLocation().x - this.center.x;
        } else if (handle.getName().equals("YRadius")) {
            this.radiusy = handle.getLocation().y - this.center.y;
        }
        this.area.setFrameFromCenter(this.center, new Point2D.Double(this.center.x + this.radiusx, this.center.y + this.radiusy));
    }

    @Override
    public boolean Hit(Point point) {
        return this.area.getBounds2D().contains(point.x, point.y) && this.area.contains(point.x, point.y);
    }

    @Override
    public boolean Hit(Rectangle rectangle) {
        return this.area.intersects(rectangle);
    }

    public boolean isDirectionIn() {
        return this.DirectionIn;
    }

    public boolean isDirectionOut() {
        return this.DirectionOut;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setDirectionIn(boolean bl) {
        this.DirectionIn = bl;
    }

    public void setDirectionInBeginTime(int n) {
        this.directionInBeginTime = n;
    }

    public void setDirectionInEndTime(int n) {
        this.directionInEndTime = n;
    }

    public void setDirectionInType(DirectionInTimeType directionInTimeType) {
        this.DirectionInType = directionInTimeType;
    }

    public void setDirectionOut(boolean bl) {
        this.DirectionOut = bl;
    }

    public void setDirectionOutBeginTime(int n) {
        this.directionOutBeginTime = n;
    }

    public void setDirectionOutEndTime(int n) {
        this.directionOutEndTime = n;
    }

    public void setNumberOfVehicles(int n) {
        this.numberOfVehicles = n;
    }

    public void setRadius(Point2D.Double double_) {
        this.radiusx = double_.x - this.center.x;
        this.radiusy = double_.y - this.center.y;
        this.area.setFrameFromCenter(this.center, new Point2D.Double(this.center.x + this.radiusx, this.center.y + this.radiusy));
    }

    public void setVehicleSelection(TypeSelection<VehicleType> typeSelection) {
        this.vehicleSelection = typeSelection;
    }

    @Override
    public TrafficDefinitionElement elementClone() {
        return new HotSpot(this);
    }

    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<hotspot name=\"" + this.name + "\" incoming=\"" + String.valueOf(this.DirectionIn) + "\" incomingTimeType=\"" + this.DirectionInType.name() + "\" incomingStartingTime=\"" + String.valueOf(this.directionInBeginTime) + "\" incomingEndingTime=\"" + String.valueOf(this.directionInEndTime) + "\" outgoing=\"" + String.valueOf(this.DirectionOut) + "\" outgoingStartingTime=\"" + String.valueOf(this.directionOutBeginTime) + "\" outgoingEndingTime=\"" + String.valueOf(this.directionOutEndTime) + "\" numberOfVehicles=\"" + String.valueOf(this.numberOfVehicles) + "\">\n");
        stringBuilder.append(XMLHelpers.vehicleSelectionToXML("vehicleSelection", this.vehicleSelection));
        stringBuilder.append("<areaShape>");
        stringBuilder.append(XMLHelpers.shapeToXML(this.area));
        stringBuilder.append("</areaShape>\n");
        stringBuilder.append("</hotspot>\n");
        return stringBuilder.toString();
    }

    public static enum DirectionInTimeType {
        TimeOfArrivalToDestination,
        TimeOfDepartureFromSource;

    }
}

