/*
 * Decompiled with CFR 0.152.
 */
package trafficdefinition;

import classes.Pair;
import classes.Project;
import classes.TypeSelection;
import helpers.DrawingHelper;
import helpers.TimeConverter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import roadnetwork.Edge;
import shapes.Line2DExt;
import shapes.Point2DExt;
import shapes.Rectangle2DExt;
import simulation.VehicleType;
import trafficdefinition.Handle;
import trafficdefinition.TrafficDefinitionElement;

public class Flow
extends TrafficDefinitionElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int beginTime = 0;
    private int endTime = 100;
    private int numberOfVehicles = 100;
    private Color color = Color.BLUE;
    private Edge start = null;
    private Edge end = null;
    private TypeSelection<VehicleType> vehicleSelection;
    private Line2DExt shape;
    private Point2DExt from;

    public Flow() {
        this.name = "Flow " + String.valueOf(increment++);
        this.vehicleSelection = new TypeSelection();
        this.vehicleSelection.add(new Pair<VehicleType, Float>(Project.getCurrentlyLoadedProject().getDefaultVehicleType(), Float.valueOf(1.0f)));
    }

    public Flow(Flow flow) {
        super(flow);
        this.beginTime = flow.beginTime;
        this.endTime = flow.endTime;
        this.numberOfVehicles = flow.numberOfVehicles;
        this.color = new Color(flow.color.getRGB());
        this.start = flow.start;
        this.end = flow.end;
        this.shape = new Line2DExt(flow.shape);
        this.from = new Point2DExt(flow.from);
        this.vehicleSelection = new TypeSelection<VehicleType>(flow.vehicleSelection);
        this.SetDependencies();
    }

    @Override
    public void Draw(Graphics2D graphics2D, double d, boolean bl, boolean bl2) {
        Color color = graphics2D.getColor();
        if (!bl2) {
            graphics2D.setColor(this.color);
        }
        if (bl2) {
            graphics2D.setColor(Color.GREEN);
        }
        if (this.shape != null) {
            DrawingHelper.drawArrowHead(graphics2D, this.shape.x1, this.shape.y1, this.shape.x2, this.shape.y2, 1.0f);
            graphics2D.draw(this.shape);
        }
        graphics2D.setColor(color);
    }

    @Override
    public Rectangle2DExt getBounds() {
        return new Rectangle2DExt((Rectangle2D.Double)this.shape.getBounds2D());
    }

    public int getBeginTime() {
        return this.beginTime;
    }

    public Color getColor() {
        return this.color;
    }

    public Edge getEnd() {
        return this.end;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public int getNumberOfVehicles() {
        return this.numberOfVehicles;
    }

    public Edge getStart() {
        return this.start;
    }

    @Override
    public String getToolTip() {
        return "<html><b>Flow</b> " + this.name + "<br>" + "<b>From:</b> " + this.start.getId() + "<br>" + "<b>To:</b> " + this.end.getId() + "<br>" + "<b>Number of vehicles:</b> " + this.numberOfVehicles + "<br>" + "<b>Start time:</b> " + TimeConverter.toString(this.beginTime) + "<br>" + "<b>End time:</b> " + TimeConverter.toString(this.endTime) + "</html>";
    }

    public TypeSelection<VehicleType> getVehicleSelection() {
        return this.vehicleSelection;
    }

    @Override
    public void handleLocationChanged(Handle handle) {
    }

    @Override
    public boolean Hit(Point point) {
        return this.shape.getBounds2D().contains(point.x, point.y) && this.shape.contains(point.x, point.y);
    }

    @Override
    public boolean Hit(Rectangle rectangle) {
        return this.shape.intersects(rectangle);
    }

    public void setBeginTime(int n) {
        this.beginTime = n;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void SetDependencies() {
        this.start.AddDependentTrafficElement(this);
        this.end.AddDependentTrafficElement(this);
    }

    public void ReleaseDependencies() {
        this.start.RemoveDependentTrafficElement(this);
        this.end.RemoveDependentTrafficElement(this);
    }

    public void setEnd(Edge edge) {
        this.end = edge;
    }

    public void setEndTime(int n) {
        this.endTime = n;
    }

    public void setFrom(Point2D.Float float_) {
        this.from = new Point2DExt(float_.x, float_.y);
    }

    public void setNumberOfVehicles(int n) {
        this.numberOfVehicles = n;
    }

    public void setStart(Edge edge) {
        this.start = edge;
    }

    public void setTo(Point2D.Double double_) {
        this.shape = new Line2DExt(this.from, double_);
    }

    public void setVehicleSelection(TypeSelection<VehicleType> typeSelection) {
        this.vehicleSelection = typeSelection;
    }

    @Override
    public TrafficDefinitionElement elementClone() {
        return new Flow(this);
    }

    @Override
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<flow name=\"" + this.name + "\" from=\"" + this.start.getId() + "\" to=\"" + this.end.getId() + "\" startingTime=\"" + String.valueOf(this.beginTime) + "\" endingTime=\"" + String.valueOf(this.endTime) + "\" numberOfVehicles=\"" + String.valueOf(this.numberOfVehicles) + "\">\n");
        stringBuilder.append("<vehicleSelection>\n");
        for (Pair pair : this.vehicleSelection) {
            stringBuilder.append("<selectedVehicle vehicleType=\"" + ((VehicleType)pair.getFirst()).getName() + "\" probability=\"" + ((Float)pair.getSecond()).toString() + "\"/>\n");
        }
        stringBuilder.append("</vehicleSelection>\n");
        stringBuilder.append("</flow>\n");
        return stringBuilder.toString();
    }
}

