/*
 * Decompiled with CFR 0.152.
 */
package tdl;

import classes.Pair;
import classes.TypeSelection;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import simulation.JobType;
import simulation.VehicleType;

public class XMLHelpers {
    public static String shapeToXML(Shape shape) {
        StringBuilder stringBuilder = new StringBuilder();
        PathIterator pathIterator = shape.getPathIterator(new AffineTransform());
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(fArray);
            stringBuilder.append(String.valueOf(fArray[0]) + "," + String.valueOf(fArray[1]));
            pathIterator.next();
            if (pathIterator.isDone()) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static String vehicleSelectionToXML(String string, TypeSelection<VehicleType> typeSelection) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<" + string + ">\n");
        for (Pair pair : typeSelection) {
            stringBuilder.append("<selectedVehicle vehicleType=\"" + ((VehicleType)pair.getFirst()).getName() + "\" probability=\"" + ((Float)pair.getSecond()).toString() + "\"/>\n");
        }
        stringBuilder.append("</" + string + ">\n");
        return stringBuilder.toString();
    }

    public static String jobSelectionToXML(String string, TypeSelection<JobType> typeSelection) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<" + string + ">\n");
        for (Pair pair : typeSelection) {
            stringBuilder.append("<selectedJob jobType=\"" + ((JobType)pair.getFirst()).getName() + "\" probability=\"" + ((Float)pair.getSecond()).toString() + "\"/>\n");
        }
        stringBuilder.append("</" + string + ">\n");
        return stringBuilder.toString();
    }
}

