/*
 * Decompiled with CFR 0.152.
 */
package simulation;

import classes.Constants;
import helpers.MultipleTripExpander;
import helpers.RandomNumberProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import roadnetwork.Edge;
import simulation.Child;
import simulation.House;
import simulation.JobType;
import simulation.Person;
import simulation.Route;
import simulation.SUMOInstructionList;
import simulation.Trip;
import simulation.VehicleType;
import trafficdefinition.School;

public class Adult
extends Person {
    private boolean canDrive;
    private List<Child> childrenToPickupFromSchool = null;
    private List<Child> childrenToTakeToSchool = null;
    private boolean hasJob;
    private House home = null;
    private JobType job;
    private Edge jobLocation = null;
    private VehicleType vehicle = null;

    public Adult(House house, float f, float f2) {
        Random random = RandomNumberProvider.getRandom();
        this.canDrive = random.nextFloat() <= f;
        this.hasJob = random.nextFloat() <= f2;
        this.home = house;
    }

    public boolean canDrive() {
        return this.canDrive;
    }

    public boolean canPickupChildFromSchool(School school) {
        if (this.vehicle == null) {
            return false;
        }
        if (this.childrenToPickupFromSchool != null) {
            return false;
        }
        if (!this.hasJob) {
            return true;
        }
        float f = school.getClosestEdge().DistanceFrom(this.jobLocation);
        int n = Math.round(f / Constants.averageSpeed);
        return this.job.getEndingTime() + n <= school.getTimeClosing() + school.amountOfTimeChildCanWaitAfterSchool();
    }

    public boolean canTakeChildToSchool(School school, int n) {
        if (this.vehicle == null) {
            return false;
        }
        if (this.childrenToTakeToSchool != null) {
            return false;
        }
        if (!this.hasJob) {
            return true;
        }
        if (school.getTimeOpening() < this.job.getStartingTime()) {
            float f = school.getClosestEdge().DistanceFrom(this.jobLocation);
            int n2 = Math.round(f / Constants.averageSpeed);
            if (school.getTimeOpening() + n2 <= this.job.getStartingTime() + n) {
                return true;
            }
        }
        return false;
    }

    public void createTrips(String string, SUMOInstructionList<Trip> sUMOInstructionList, SUMOInstructionList<Route> sUMOInstructionList2, int n) throws Exception {
        Object object;
        int n2;
        int n3;
        int n4;
        int n5;
        float f;
        float f2;
        School school;
        if (this.vehicle == null) {
            return;
        }
        if (this.hasJob && this.childrenToTakeToSchool != null) {
            school = this.childrenToTakeToSchool.get(0).getSchool();
            f2 = this.home.getAddress().DistanceFrom(school.getClosestEdge());
            f = this.home.getAddress().DistanceFrom(this.jobLocation);
            n5 = Math.round((f2 + f) / Constants.averageSpeed);
            n4 = Math.round(f2 / Constants.averageSpeed);
            n3 = Math.round(f / Constants.averageSpeed);
            n2 = this.job.getStartingTime() - school.getTimeOpening();
            int n6 = Math.max(0, school.getTimeOpening() - n4);
            if (n5 + 1200 > n2) {
                object = new ArrayList<Edge>();
                object.add(this.home.getAddress());
                object.add(school.getClosestEdge());
                object.add(this.jobLocation);
                String string2 = MultipleTripExpander.ExpandTrips(object);
                sUMOInstructionList2.add(new Route(n6, "<vehicle id=\"home-school-work-" + String.valueOf(this.home.getId()) + "-" + String.valueOf(n) + "\" type=\"" + this.vehicle.getName() + "\" depart=\"" + String.valueOf(n6) + "\" color=\"" + string + "\">" + "<route color=\"" + string + "\">" + string2 + "</route>" + "</vehicle>"));
            } else {
                object = new ArrayList();
                object.add(this.home.getAddress());
                object.add(school.getClosestEdge());
                object.add(this.home.getAddress());
                String string3 = MultipleTripExpander.ExpandTrips(object);
                sUMOInstructionList2.add(new Route(n6, "<vehicle id=\"home-school-home-" + String.valueOf(this.home.getId()) + "-" + String.valueOf(n) + "\" type=\"" + this.vehicle.getName() + "\" depart=\"" + String.valueOf(n6) + "\" color=\"" + string + "\">" + "<route color=\"" + string + "\">" + string3 + "</route>" + "</vehicle>"));
                int n7 = Math.max(0, this.job.getStartingTime() - n3);
                sUMOInstructionList.add(new Trip(n7, "<trip id=\"house-work-" + String.valueOf(this.home.getId()) + "-" + String.valueOf(n) + "\" depart=\"" + String.valueOf(n7) + "\" from=\"" + this.home.getAddress().getId() + "\" to=\"" + this.jobLocation.getId() + "\" color=\"" + string + "\" type=\"" + this.vehicle.getName() + "\" />\n"));
            }
        } else if (this.hasJob && this.childrenToTakeToSchool == null) {
            float f3 = this.home.getAddress().DistanceFrom(this.jobLocation);
            int n8 = Math.round(f3 / Constants.averageSpeed);
            int n9 = Math.max(0, this.job.getStartingTime() - n8);
            sUMOInstructionList.add(new Trip(n9, "<trip id=\"house-work-" + String.valueOf(this.home.getId()) + "-" + String.valueOf(n) + "\" depart=\"" + String.valueOf(n9) + "\" from=\"" + this.home.getAddress().getId() + "\" to=\"" + this.jobLocation.getId() + "\" color=\"" + string + "\" type=\"" + this.vehicle.getName() + "\" />\n"));
        } else if (!this.hasJob && this.childrenToTakeToSchool != null) {
            school = this.childrenToTakeToSchool.get(0).getSchool();
            f2 = this.home.getAddress().DistanceFrom(school.getClosestEdge());
            int n10 = Math.round(f2 / Constants.averageSpeed);
            n5 = Math.max(0, school.getTimeOpening() - n10);
            ArrayList<Edge> arrayList = new ArrayList<Edge>();
            arrayList.add(this.home.getAddress());
            arrayList.add(school.getClosestEdge());
            arrayList.add(this.home.getAddress());
            String string4 = MultipleTripExpander.ExpandTrips(arrayList);
            sUMOInstructionList2.add(new Route(n5, "<vehicle id=\"home-school-home-" + String.valueOf(this.home.getId()) + "-" + String.valueOf(n) + "\" type=\"" + this.vehicle.getName() + "\" depart=\"" + String.valueOf(n5) + "\" color=\"" + string + "\">" + "<route color=\"" + string + "\">" + string4 + "</route>" + "</vehicle>"));
        }
        if (this.hasJob && this.childrenToPickupFromSchool == null) {
            sUMOInstructionList.add(new Trip(this.job.getEndingTime(), "<trip id=\"work-house-" + String.valueOf(this.home.getId()) + "-" + String.valueOf(n) + "\" depart=\"" + String.valueOf(this.job.getEndingTime()) + "\" from=\"" + this.jobLocation.getId() + "\" to=\"" + this.home.getAddress().getId() + "\" color=\"" + string + "\" type=\"" + this.vehicle.getName() + "\" />\n"));
        } else if (this.hasJob && this.childrenToPickupFromSchool != null) {
            school = this.childrenToPickupFromSchool.get(0).getSchool();
            f2 = this.home.getAddress().DistanceFrom(school.getClosestEdge());
            n5 = Math.round((f2 + (f = (float)this.home.getAddress().DistanceFrom(this.jobLocation))) / Constants.averageSpeed);
            if (n5 + 1200 > (n4 = school.getTimeClosing() - this.job.getEndingTime())) {
                ArrayList<Edge> arrayList = new ArrayList<Edge>();
                arrayList.add(this.jobLocation);
                arrayList.add(school.getClosestEdge());
                arrayList.add(this.home.getAddress());
                String string5 = MultipleTripExpander.ExpandTrips(arrayList);
                sUMOInstructionList2.add(new Route(this.job.getEndingTime(), "<vehicle id=\"work-school-home-" + String.valueOf(this.home.getId()) + "-" + String.valueOf(n) + "\" type=\"" + this.vehicle.getName() + "\" depart=\"" + String.valueOf(this.job.getEndingTime()) + "\" color=\"" + string + "\">" + "<route color=\"" + string + "\">" + string5 + "</route>" + "</vehicle>"));
            } else {
                sUMOInstructionList.add(new Trip(this.job.getEndingTime(), "<trip id=\"work-house-" + String.valueOf(this.home.getId()) + "-" + String.valueOf(n) + "\" depart=\"" + String.valueOf(this.job.getEndingTime()) + "\" from=\"" + this.jobLocation.getId() + "\" to=\"" + this.home.getAddress().getId() + "\" color=\"" + string + "\" type=\"" + this.vehicle.getName() + "\" />\n"));
                n3 = Math.round(f2 / Constants.averageSpeed);
                n2 = Math.max(0, school.getTimeClosing() - n3);
                ArrayList<Edge> arrayList = new ArrayList<Edge>();
                arrayList.add(this.home.getAddress());
                arrayList.add(school.getClosestEdge());
                arrayList.add(this.home.getAddress());
                object = MultipleTripExpander.ExpandTrips(arrayList);
                sUMOInstructionList2.add(new Route(n2, "<vehicle id=\"home-school-home-" + String.valueOf(this.home.getId()) + "-" + String.valueOf(n) + "\" type=\"" + this.vehicle.getName() + "\" depart=\"" + String.valueOf(n2) + "\" color=\"" + string + "\">" + "<route color=\"" + string + "\">" + (String)object + "</route>" + "</vehicle>"));
            }
        } else if (!this.hasJob && this.childrenToPickupFromSchool != null) {
            school = this.childrenToPickupFromSchool.get(0).getSchool();
            f2 = this.home.getAddress().DistanceFrom(school.getClosestEdge());
            int n11 = Math.round(f2 / Constants.averageSpeed);
            n5 = Math.max(0, school.getTimeClosing() - n11);
            ArrayList<Edge> arrayList = new ArrayList<Edge>();
            arrayList.add(this.home.getAddress());
            arrayList.add(school.getClosestEdge());
            arrayList.add(this.home.getAddress());
            String string6 = MultipleTripExpander.ExpandTrips(arrayList);
            sUMOInstructionList2.add(new Route(n5, "<vehicle id=\"home-school-home-" + String.valueOf(this.home.getId()) + "-" + String.valueOf(n) + "\" type=\"" + this.vehicle.getName() + "\" depart=\"" + String.valueOf(n5) + "\" color=\"" + string + "\">" + "<route color=\"" + string + "\">" + string6 + "</route>" + "</vehicle>"));
        }
    }

    public JobType getJob() {
        return this.job;
    }

    public Edge getJobLocation() {
        return this.jobLocation;
    }

    public boolean hasJob() {
        return this.hasJob;
    }

    public void pickupChildrenFromSchool(List<Child> list) {
        this.childrenToPickupFromSchool = list;
    }

    public void setHasJob(boolean bl) {
        this.hasJob = bl;
    }

    public void setJobLocation(JobType jobType, Edge edge) {
        this.jobLocation = edge;
        this.job = jobType;
    }

    public void setVehicle(VehicleType vehicleType) {
        this.vehicle = vehicleType;
    }

    public void takeChildrenToSchool(List<Child> list) {
        this.childrenToTakeToSchool = list;
    }

    public VehicleType getVehicle() {
        return this.vehicle;
    }
}

