/*
 * Decompiled with CFR 0.152.
 */
package shapes;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import shapes.PolygonIterator;

public abstract class Polygon2D
implements Shape,
Serializable {
    protected int _coordCount = 0;
    protected boolean _closed = false;

    public void closePath() {
        if (this.getX(this.getVertexCount() - 1) == this.getX(0) && this.getY(this.getVertexCount() - 1) == this.getY(0)) {
            this._coordCount -= 2;
        }
        this._closed = true;
    }

    @Override
    public boolean contains(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        int n;
        int n2 = 0;
        if (this._coordCount == 0) {
            return false;
        }
        for (n = 1; n < this.getVertexCount(); ++n) {
            d6 = this.getX(n - 1);
            d5 = this.getX(n);
            d4 = this.getY(n - 1);
            d3 = this.getY(n);
            if (!(d < d6) && !(d < d5)) continue;
            if (d2 == d3) {
                ++n2;
                continue;
            }
            if (d2 == d4 || !Line2D.linesIntersect(d, d2, Math.max(d6, d5), d2, d6, d4, d5, d3)) continue;
            ++n2;
        }
        d6 = this.getX(n - 1);
        d5 = this.getY(n - 1);
        d4 = this.getX(0);
        d3 = this.getY(0);
        if ((d < d6 || d < d4) && Line2D.linesIntersect(d, d2, Math.max(d6, d4), d2, d6, d5, d4, d3) && d2 != d5) {
            ++n2;
        }
        return n2 % 2 == 1;
    }

    @Override
    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        double d5 = d + d3;
        double d6 = d2 + d4;
        return this.contains(d, d2) && this.contains(d, d6) && this.contains(d5, d2) && this.contains(d5, d6);
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    @Override
    public abstract Rectangle2D getBounds2D();

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.getPathIterator(affineTransform);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new PolygonIterator(this, affineTransform);
    }

    public int getVertexCount() {
        return this._coordCount / 2;
    }

    public abstract double getX(int var1);

    public abstract double getY(int var1);

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean overlaps(Shape shape) {
        if (this._coordCount == 0) {
            return false;
        }
        return this.getBounds2D().contains(shape.getBounds2D()) || this.intersects(shape.getBounds2D());
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        int n;
        double d5 = d + d3;
        double d6 = d2 + d4;
        if (this._coordCount == 0) {
            return false;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        if (!this.getBounds().intersects(double_)) {
            return false;
        }
        if (this.contains(d, d2) || this.contains(d, d6) || this.contains(d5, d2) || this.contains(d5, d6)) {
            return true;
        }
        for (n = 0; n < this.getVertexCount(); ++n) {
            if (!double_.contains(this.getX(n), this.getY(n))) continue;
            return true;
        }
        for (n = 1; n < this.getVertexCount(); ++n) {
            double d7;
            double d8 = this.getX(n - 1);
            double d9 = this.getX(n);
            double d10 = this.getY(n - 1);
            if (Line2D.linesIntersect(d, d2, d, d6, d8, d10, d9, d7 = this.getY(n))) {
                return true;
            }
            if (Line2D.linesIntersect(d, d6, d5, d6, d8, d10, d9, d7)) {
                return true;
            }
            if (Line2D.linesIntersect(d5, d6, d5, d2, d8, d10, d9, d7)) {
                return true;
            }
            if (!Line2D.linesIntersect(d5, d2, d, d2, d8, d10, d9, d7)) continue;
            return true;
        }
        return false;
    }

    public abstract void lineTo(double var1, double var3);

    public abstract void moveTo(double var1, double var3);

    public void reset() {
        this._coordCount = 0;
        this._closed = false;
    }

    public abstract void setX(int var1, double var2);

    public abstract void setY(int var1, double var2);

    public abstract void transform(AffineTransform var1);

    public abstract void translate(double var1, double var3);

    public String toString() {
        String string = this.getClass().getName() + "[\n";
        for (int i = 0; i < this.getVertexCount(); ++i) {
            string = string + "\t" + this.getX(i) + ", " + this.getY(i) + "\n";
        }
        string = string + "]";
        return string;
    }

    public static class Double
    extends Polygon2D {
        private static final long serialVersionUID = 1L;
        double[] _coords;

        public Double(int n) {
            this._coords = new double[2 * n];
        }

        public Double(double[] dArray) {
            this._coords = dArray;
            this._coordCount = dArray.length;
        }

        public Double() {
            this(2);
        }

        public Double(double d, double d2) {
            this(2);
            this._coords[0] = d;
            this._coords[1] = d2;
            this._coordCount = 2;
        }

        @Override
        public Rectangle2D.Double getBounds2D() {
            if (this._coordCount <= 0) {
                return new Rectangle2D.Double();
            }
            double d = this._coords[0];
            double d2 = this._coords[1];
            double d3 = d;
            double d4 = d2;
            for (int i = 2; i < this._coordCount; ++i) {
                if (this._coords[i] < d) {
                    d = this._coords[i];
                } else if (this._coords[i] > d3) {
                    d3 = this._coords[i];
                }
                ++i;
                if (this._coords[i] < d2) {
                    d2 = this._coords[i];
                    continue;
                }
                if (!(this._coords[i] > d4)) continue;
                d4 = this._coords[i];
            }
            return new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
        }

        @Override
        public int getVertexCount() {
            return this._coordCount / 2;
        }

        @Override
        public double getX(int n) {
            return this._coords[n * 2];
        }

        @Override
        public double getY(int n) {
            return this._coords[n * 2 + 1];
        }

        @Override
        public void lineTo(double d, double d2) {
            if (this._coordCount == this._coords.length) {
                double[] dArray = new double[this._coordCount * 2];
                System.arraycopy(this._coords, 0, dArray, 0, this._coordCount);
                this._coords = dArray;
            }
            this._coords[this._coordCount++] = d;
            this._coords[this._coordCount++] = d2;
        }

        @Override
        public void moveTo(double d, double d2) {
            if (this._coordCount > 0) {
                throw new UnsupportedOperationException("This polygon already has vertices");
            }
            this._coords[0] = d;
            this._coords[1] = d2;
            this._coordCount = 2;
        }

        @Override
        public void setX(int n, double d) {
            this._coords[n * 2] = d;
        }

        @Override
        public void setY(int n, double d) {
            this._coords[n * 2 + 1] = d;
        }

        @Override
        public void transform(AffineTransform affineTransform) {
            affineTransform.transform(this._coords, 0, this._coords, 0, this._coordCount / 2);
        }

        @Override
        public void translate(double d, double d2) {
            int n = 0;
            while (n < this._coordCount) {
                int n2 = n++;
                this._coords[n2] = this._coords[n2] + d;
                int n3 = n++;
                this._coords[n3] = this._coords[n3] + d2;
            }
        }
    }

    public static class Float
    extends Polygon2D {
        private static final long serialVersionUID = 1L;
        float[] _coords;

        public Float(int n) {
            this._coords = new float[2 * n];
        }

        public Float(float[] fArray) {
            this._coords = fArray;
            this._coordCount = fArray.length;
        }

        public Float() {
            this(2);
        }

        public Float(float f, float f2) {
            this(2);
            this._coords[0] = f;
            this._coords[1] = f2;
            this._coordCount = 2;
        }

        @Override
        public Rectangle2D getBounds2D() {
            if (this._coordCount <= 1) {
                return new Rectangle2D.Float();
            }
            float f = this._coords[0];
            float f2 = this._coords[1];
            float f3 = f;
            float f4 = f2;
            for (int i = 2; i < this._coordCount; ++i) {
                if (this._coords[i] < f) {
                    f = this._coords[i];
                } else if (this._coords[i] > f3) {
                    f3 = this._coords[i];
                }
                ++i;
                if (this._coords[i] < f2) {
                    f2 = this._coords[i];
                    continue;
                }
                if (!(this._coords[i] > f4)) continue;
                f4 = this._coords[i];
            }
            return new Rectangle2D.Float(f, f2, f3 - f, f4 - f2);
        }

        @Override
        public double getX(int n) {
            return this._coords[n * 2];
        }

        @Override
        public double getY(int n) {
            return this._coords[n * 2 + 1];
        }

        @Override
        public void lineTo(double d, double d2) {
            if (this._closed) {
                throw new UnsupportedOperationException("This polygon has already been closed");
            }
            if (this._coordCount == this._coords.length) {
                float[] fArray = new float[this._coordCount * 2];
                System.arraycopy(this._coords, 0, fArray, 0, this._coordCount);
                this._coords = fArray;
            }
            this._coords[this._coordCount++] = (float)d;
            this._coords[this._coordCount++] = (float)d2;
        }

        @Override
        public void moveTo(double d, double d2) {
            if (this._coordCount > 0) {
                throw new UnsupportedOperationException("This polygon already has vertices");
            }
            this._coords[0] = (float)d;
            this._coords[1] = (float)d2;
            this._coordCount = 2;
        }

        @Override
        public void setX(int n, double d) {
            this._coords[n * 2] = (float)d;
        }

        @Override
        public void setY(int n, double d) {
            this._coords[n * 2 + 1] = (float)d;
        }

        @Override
        public void transform(AffineTransform affineTransform) {
            affineTransform.transform(this._coords, 0, this._coords, 0, this._coordCount / 2);
        }

        @Override
        public void translate(double d, double d2) {
            float f = (float)d;
            float f2 = (float)d2;
            int n = 0;
            while (n < this._coordCount) {
                int n2 = n++;
                this._coords[n2] = this._coords[n2] + f;
                int n3 = n++;
                this._coords[n3] = this._coords[n3] + f2;
            }
        }
    }
}

