/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Pair;
import helpers.RandomNumberProvider;
import interfaces.SelectableType;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class TypeSelection<T extends SelectableType>
extends ArrayList<Pair<T, Float>> {
    private static final long serialVersionUID = -7955432732064500764L;

    public TypeSelection() {
    }

    public TypeSelection(List<T> list) {
        for (SelectableType selectableType : list) {
            this.add(new Pair<SelectableType, Float>(selectableType, Float.valueOf(0.0f)));
        }
    }

    public TypeSelection(TypeSelection<T> typeSelection) {
        for (Pair pair : typeSelection) {
            this.add(new Pair(pair.getFirst(), pair.getSecond()));
        }
    }

    public void addTypesNotInSelection(TypeSelection<T> typeSelection) {
        for (Pair pair : typeSelection) {
            boolean bl = false;
            for (Pair pair2 : this) {
                if (!((SelectableType)pair.getFirst()).equals(pair2.getFirst())) continue;
                bl = true;
            }
            if (bl) continue;
            this.add(pair);
        }
    }

    public T getRandomType() {
        Random random = RandomNumberProvider.getRandom();
        float f = random.nextFloat();
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (Pair pair : this) {
            f3 = f2 + ((Float)pair.getSecond()).floatValue();
            if (f >= f2 && f <= f3) {
                return (T)((SelectableType)pair.getFirst());
            }
            f2 += ((Float)pair.getSecond()).floatValue();
        }
        return null;
    }

    public float getTotalPercentage() {
        Float f = Float.valueOf(0.0f);
        for (Pair pair : this) {
            f = Float.valueOf(f.floatValue() + ((Float)pair.getSecond()).floatValue());
        }
        return f.floatValue() * 100.0f;
    }

    public void removeTypesWithZeroPercentage() {
        TypeSelection<T> typeSelection = new TypeSelection<T>();
        for (Pair pair : this) {
            if (((Float)pair.getSecond()).floatValue() != 0.0f) continue;
            typeSelection.add(pair);
        }
        this.removeAll(typeSelection);
    }

    public Float getTypePossibility(T t) {
        for (Pair pair : this) {
            if (pair.getFirst() != t) continue;
            return (Float)pair.getSecond();
        }
        return Float.valueOf(0.0f);
    }
}

