/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.visualization.network;

import cadyts.utilities.visualization.network.NetJComponent;
import cadyts.utilities.visualization.network.VisConfig;
import cadyts.utilities.visualization.network.VisNetworkData;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public abstract class RendererA {
    private final VisConfig visConfig;
    private final VisNetworkData netData;
    private NetJComponent component;
    private RendererA prev;

    protected RendererA(VisConfig visConfig, VisNetworkData netData) {
        this.visConfig = visConfig;
        this.netData = netData;
        this.component = null;
        this.prev = null;
    }

    public void append(RendererA rendererBelow) {
        if (this.prev == null) {
            this.prev = rendererBelow;
        } else {
            this.prev.append(rendererBelow);
        }
    }

    public void setTargetComponent(NetJComponent component) {
        if (this.prev != null) {
            this.prev.setTargetComponent(component);
        }
        this.component = component;
    }

    void render(Graphics2D display, AffineTransform boxTransform) {
        if (this.prev != null) {
            this.prev.render(display, boxTransform);
        }
        if (this.component != null) {
            this.myRendering(display, boxTransform);
        }
    }

    protected NetJComponent getNetJComponent() {
        return this.component;
    }

    protected VisConfig getVisConfig() {
        return this.visConfig;
    }

    protected VisNetworkData netData() {
        return this.netData;
    }

    protected abstract void myRendering(Graphics2D var1, AffineTransform var2);
}

