/*
 * Decompiled with CFR 0.152.
 */
package cadyts.supply.network;

import java.util.LinkedHashMap;
import java.util.Map;

public class NetworkElement {
    private final String id;
    private final int hashCode;
    private final Map<String, String> key2key = new LinkedHashMap<String, String>();
    private final Map<String, String> key2attr = new LinkedHashMap<String, String>();

    public NetworkElement(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        this.id = id;
        this.hashCode = id.hashCode();
    }

    NetworkElement(NetworkElement parent) {
        this.id = parent.id;
        this.hashCode = parent.hashCode;
        this.key2key.putAll(parent.key2key);
        this.key2attr.putAll(parent.key2attr);
    }

    private String finalKey(String key) {
        while (this.key2key.containsKey(key)) {
            key = this.key2key.get(key);
        }
        return key;
    }

    public void setAttr(String key, String value) {
        this.key2attr.put(this.finalKey(key), value);
    }

    public void redirectKey(String newKey, String existingKey) {
        this.key2key.put(newKey, existingKey);
    }

    public String getId() {
        return this.id;
    }

    public String getAttr(String key) {
        return this.key2attr.get(this.finalKey(key));
    }

    public boolean equals(Object o) {
        block3: {
            try {
                if (o != null) break block3;
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        NetworkElement other = (NetworkElement)o;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getSimpleName());
        result.append("(id = ");
        result.append(this.id);
        result.append(", attributes = ");
        result.append(this.key2attr.toString());
        result.append(")");
        return result.toString();
    }
}

