/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.proj.Projection;
import com.jhlabs.map.proj.ProjectionException;
import java.awt.geom.Point2D;

public class Eckert2Projection
extends Projection {
    private static final double FXC = 0.46065886596178063;
    private static final double FYC = 1.4472025091165353;
    private static final double C13 = 0.3333333333333333;
    private static final double ONEEPS = 1.0000001;

    public Point2D.Double project(double lplam, double lpphi, Point2D.Double out) {
        out.y = Math.sqrt(4.0 - 3.0 * Math.sin(Math.abs(lpphi)));
        out.x = 0.46065886596178063 * lplam * out.y;
        out.y = 1.4472025091165353 * (2.0 - out.y);
        if (lpphi < 0.0) {
            out.y = -out.y;
        }
        return out;
    }

    public Point2D.Double projectInverse(double xyx, double xyy, Point2D.Double out) {
        out.y = 2.0 - Math.abs(xyy) / 1.4472025091165353;
        out.x = xyx / (0.46065886596178063 * out.y);
        out.y = (4.0 - out.y * out.y) * 0.3333333333333333;
        if (Math.abs(out.y) >= 1.0) {
            if (Math.abs(out.y) > 1.0000001) {
                throw new ProjectionException("I");
            }
            out.y = out.y < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        } else {
            out.y = Math.asin(out.y);
        }
        if (xyy < 0.0) {
            out.y = -out.y;
        }
        return out;
    }

    public boolean hasInverse() {
        return true;
    }

    public String toString() {
        return "Eckert II";
    }
}

