/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.MapMath;
import com.jhlabs.map.proj.Projection;
import com.jhlabs.map.proj.ProjectionException;
import java.awt.geom.Point2D;

public class CylindricalEqualAreaProjection
extends Projection {
    private double qp;
    private double[] apa;
    private double trueScaleLatitude;

    public CylindricalEqualAreaProjection() {
        this(0.0, 0.0, 0.0);
    }

    public CylindricalEqualAreaProjection(double projectionLatitude, double projectionLongitude, double trueScaleLatitude) {
        this.projectionLatitude = projectionLatitude;
        this.projectionLongitude = projectionLongitude;
        this.trueScaleLatitude = trueScaleLatitude;
        this.initialize();
    }

    public void initialize() {
        super.initialize();
        double t = this.trueScaleLatitude;
        this.scaleFactor = Math.cos(t);
        if (this.es != 0.0) {
            t = Math.sin(t);
            this.scaleFactor /= Math.sqrt(1.0 - this.es * t * t);
            this.apa = MapMath.authset(this.es);
            this.qp = MapMath.qsfn(1.0, this.e, this.one_es);
        }
    }

    public Point2D.Double project(double lam, double phi, Point2D.Double xy) {
        if (this.spherical) {
            xy.x = this.scaleFactor * lam;
            xy.y = Math.sin(phi) / this.scaleFactor;
        } else {
            xy.x = this.scaleFactor * lam;
            xy.y = 0.5 * MapMath.qsfn(Math.sin(phi), this.e, this.one_es) / this.scaleFactor;
        }
        return xy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Point2D.Double projectInverse(double x, double y, Point2D.Double lp) {
        if (this.spherical) {
            double d;
            double t = Math.abs(y *= this.scaleFactor);
            if (!(d - 1.0E-10 <= 1.0)) throw new ProjectionException();
            lp.y = t >= 1.0 ? (y < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : Math.asin(y);
            lp.x = x / this.scaleFactor;
            return lp;
        } else {
            lp.y = MapMath.authlat(Math.asin(2.0 * y * this.scaleFactor / this.qp), this.apa);
            lp.x = x / this.scaleFactor;
        }
        return lp;
    }

    public boolean hasInverse() {
        return true;
    }

    public boolean isRectilinear() {
        return true;
    }
}

