/* dhparam.c: initial DH parameters for stunnel */
#include "prototypes.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
DH *get_dh2048(void) {
    static unsigned char dhp_2048[] = {
        0xdf, 0x60, 0xce, 0x2a, 0x84, 0xc3, 0xcd, 0xe3, 0x7c, 0x59, 0x18, 0xec,
        0x76, 0xbe, 0xde, 0x6a, 0xfc, 0x51, 0x29, 0xd2, 0xc4, 0xf2, 0x19, 0xa5,
        0x11, 0x53, 0x36, 0x3f, 0xfd, 0xfd, 0x17, 0x2a, 0xc9, 0x8b, 0xb0, 0xc0,
        0x1e, 0xbe, 0x72, 0x15, 0xa0, 0x6f, 0xac, 0x24, 0xf8, 0x2b, 0x89, 0xce,
        0x61, 0x0f, 0x56, 0xa2, 0x1f, 0x3a, 0x89, 0x50, 0xc1, 0x8a, 0x17, 0x4d,
        0xd9, 0x21, 0xd6, 0x65, 0x09, 0xe2, 0xea, 0xa8, 0x73, 0x1e, 0x66, 0xa2,
        0xba, 0x07, 0xe6, 0x46, 0x6c, 0xe1, 0x1f, 0x16, 0xec, 0x46, 0x3a, 0x6c,
        0xa2, 0xea, 0x8b, 0x05, 0xdb, 0x67, 0x11, 0xfb, 0xea, 0x57, 0xad, 0xcb,
        0x91, 0xd4, 0xab, 0xc7, 0xd5, 0xde, 0x8b, 0xda, 0x01, 0xb4, 0x99, 0x47,
        0x30, 0x33, 0xe0, 0x80, 0xe5, 0x7d, 0x78, 0x08, 0xb4, 0xe1, 0xa5, 0x9d,
        0x22, 0xf2, 0x1e, 0x68, 0xa5, 0xdb, 0xee, 0x3a, 0x85, 0x60, 0x79, 0xcb,
        0x31, 0x3a, 0x46, 0xa4, 0xff, 0x81, 0x31, 0xee, 0xee, 0x93, 0x08, 0x39,
        0x2c, 0xd5, 0x1b, 0xa3, 0x9e, 0xc9, 0xc4, 0x65, 0x7b, 0x0d, 0xb5, 0x61,
        0x29, 0x34, 0xe7, 0xba, 0x8b, 0xd2, 0x1a, 0x6c, 0x95, 0x3f, 0x58, 0x1f,
        0x62, 0xc6, 0xf5, 0x8d, 0x20, 0x0c, 0x2e, 0x31, 0xfb, 0x8d, 0x7c, 0xd3,
        0xd7, 0x0c, 0x72, 0x7b, 0xb5, 0x6a, 0xeb, 0x55, 0x05, 0x0d, 0x6d, 0xe8,
        0x6d, 0x7b, 0x98, 0x16, 0x7d, 0x4f, 0x46, 0x1e, 0x64, 0xb6, 0x89, 0xef,
        0x9c, 0xff, 0xeb, 0x2b, 0x4c, 0x84, 0xc0, 0x97, 0x8d, 0x16, 0xb0, 0x76,
        0x4c, 0x22, 0x20, 0xb5, 0xc0, 0xc7, 0x9d, 0x47, 0xfb, 0xdf, 0xf6, 0x48,
        0xaa, 0x8f, 0x56, 0xad, 0xcc, 0x40, 0x0e, 0x25, 0x7d, 0xa9, 0xb1, 0xc2,
        0x43, 0xf0, 0x6f, 0x4a, 0xb6, 0x54, 0x9f, 0xd7, 0xfb, 0x04, 0x5c, 0x9a,
        0x63, 0x90, 0x14, 0x5b
    };
    static unsigned char dhg_2048[] = {
        0x02
    };
    DH *dh = DH_new();
    BIGNUM *p, *g;

    if (dh == NULL)
        return NULL;
    p = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    g = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (p == NULL || g == NULL
            || !DH_set0_pqg(dh, p, NULL, g)) {
        DH_free(dh);
        BN_free(p);
        BN_free(g);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
/* built for stunnel 5.67 */
