#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0xA3, 0xC8, 0x67, 0xB7, 0xD7, 0x9B, 0x72, 0x5D, 0x38, 0x8C, 
	0x83, 0x63, 0x33, 0xFC, 0xAF, 0xC1, 0xCC, 0x72, 0x68, 0xCD, 
	0x18, 0x69, 0x43, 0xFD, 0xF2, 0x32, 0x41, 0xE5, 0xC0, 0x6D, 
	0x1B, 0xDF, 0x62, 0xEC, 0x1C, 0xDC, 0x6E, 0x71, 0xC7, 0x33, 
	0x3D, 0x49, 0xE1, 0xC7, 0xE0, 0x13, 0x1E, 0x21, 0xC8, 0xFF, 
	0x22, 0xE5, 0xC8, 0x53, 0xED, 0x26, 0xF1, 0x57, 0xB8, 0xEB, 
	0x3F, 0x5B, 0x13, 0x0A, 0x60, 0xE1, 0x2F, 0x42, 0xC9, 0x83, 
	0x23, 0x4F, 0xC9, 0x59, 0xCD, 0x07, 0x28, 0xBA, 0xB5, 0xFA, 
	0x57, 0xE0, 0x02, 0x11, 0x85, 0xF2, 0xF0, 0xC6, 0x37, 0x30, 
	0x20, 0x4A, 0x79, 0xD4, 0xFC, 0x03, 0x4F, 0x5D, 0x1E, 0xBF, 
	0x19, 0x89, 0x20, 0x26, 0x22, 0xDB, 0xFB, 0x29, 0x6F, 0x24, 
	0x71, 0x43, 0xBD, 0xA2, 0x28, 0xD0, 0xB4, 0xE5, 0x8A, 0x0A, 
	0xB8, 0x44, 0x2C, 0x8F, 0x21, 0x5F, 0x5B, 0x1F, 0x6A, 0x14, 
	0xCC, 0xBE, 0xE6, 0x2B, 0x68, 0x43, 0xC8, 0xFB, 0x84, 0xE8, 
	0xFE, 0x97, 0xCE, 0xE5, 0x62, 0x2C, 0x5D, 0x0A, 0xB9, 0xA1, 
	0x86, 0x35, 0xA8, 0x13, 0x40, 0xF8, 0xF0, 0x82, 0x72, 0x1B, 
	0x8E, 0xC1, 0x21, 0xB6, 0x4C, 0x76, 0x74, 0x5F, 0x3F, 0xC9, 
	0x8C, 0xB2, 0xD8, 0x27, 0xAA, 0x04, 0xDC, 0x8A, 0x61, 0x1B, 
	0x00, 0x9C, 0x63, 0x79, 0x9D, 0x46, 0x23, 0xCB, 0x7F, 0x65, 
	0xB8, 0xE2, 0xB9, 0xB7, 0x67, 0x0C, 0xF6, 0x4A, 0xE2, 0x15, 
	0xF1, 0x48, 0xC5, 0x09, 0xD4, 0xFD, 0xC9, 0x5A, 0x01, 0x63, 
	0x26, 0x5B, 0x20, 0x57, 0x82, 0xD8, 0x44, 0xF0, 0x57, 0xA6, 
	0x2F, 0x84, 0xCF, 0x6A, 0xA5, 0xDE, 0xE0, 0x92, 0xC0, 0x6C, 
	0xC5, 0xDB, 0x0D, 0x0B, 0x5D, 0x41, 0x6F, 0x8B, 0xD7, 0x5D, 
	0x1C, 0x18, 0xC2, 0x54, 0x94, 0x5D, 0xD3, 0x5C, 0x82, 0x85, 
	0x79, 0x28, 0x4E, 0xEF, 0x89, 0x13
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DN_new();

    if (dh == NULL)
        return NULL;
    dh->p = BN_bin2bn(dhp_2048, sizeof (dhp_2048), NULL);
    dh->g = BN_bin2bn(dhg_2048, sizeof (dhg_2048), NULL);
    if (!dh->p || !dh->g) {
        DH_free(dh);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
