/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class ArrayUtils {
    private static final Redwood.RedwoodChannels log = Redwood.channels(ArrayUtils.class);

    private ArrayUtils() {
    }

    public static byte[] gapEncode(int[] orig) {
        List<Byte> encodedList = ArrayUtils.gapEncodeList(orig);
        byte[] arr = new byte[encodedList.size()];
        int i = 0;
        for (byte b : encodedList) {
            arr[i++] = b;
        }
        return arr;
    }

    public static List<Byte> gapEncodeList(int[] orig) {
        for (int i = 1; i < orig.length; ++i) {
            if (orig[i] >= orig[i - 1]) continue;
            throw new IllegalArgumentException("Array must be sorted!");
        }
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        int index = 0;
        int prevNum = 0;
        byte currByte = 0;
        for (int f : orig) {
            String n = f == prevNum ? "" : Integer.toString(f - prevNum, 2);
            for (int ii = 0; ii < n.length(); ++ii) {
                if (index == 8) {
                    bytes.add(currByte);
                    currByte = 0;
                    index = 0;
                }
                currByte = (byte)(currByte << 1);
                currByte = (byte)(currByte + 1);
                ++index;
            }
            if (index == 8) {
                bytes.add(currByte);
                currByte = 0;
                index = 0;
            }
            currByte = (byte)(currByte << 1);
            ++index;
            for (int i = 1; i < n.length(); ++i) {
                if (index == 8) {
                    bytes.add(currByte);
                    currByte = 0;
                    index = 0;
                }
                currByte = (byte)(currByte << 1);
                if (n.charAt(i) == '1') {
                    currByte = (byte)(currByte + 1);
                }
                ++index;
            }
            prevNum = f;
        }
        while (index > 0 && index < 9) {
            if (index == 8) {
                bytes.add(currByte);
                break;
            }
            currByte = (byte)(currByte << 1);
            currByte = (byte)(currByte + 1);
            ++index;
        }
        return bytes;
    }

    public static int[] gapDecode(byte[] gapEncoded) {
        return ArrayUtils.gapDecode(gapEncoded, 0, gapEncoded.length);
    }

    public static int[] gapDecode(byte[] gapEncoded, int startIndex, int endIndex) {
        List<Integer> ints = ArrayUtils.gapDecodeList(gapEncoded, startIndex, endIndex);
        int[] arr = new int[ints.size()];
        int index = 0;
        for (int i : ints) {
            arr[index++] = i;
        }
        return arr;
    }

    public static List<Integer> gapDecodeList(byte[] gapEncoded) {
        return ArrayUtils.gapDecodeList(gapEncoded, 0, gapEncoded.length);
    }

    public static List<Integer> gapDecodeList(byte[] gapEncoded, int startIndex, int endIndex) {
        boolean gettingSize = true;
        int size = 0;
        ArrayList<Integer> ints = new ArrayList<Integer>();
        int gap = 0;
        int prevNum = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            byte b = gapEncoded[i];
            for (int index = 7; index >= 0; --index) {
                boolean value;
                boolean bl = value = (b >> index & 1) == 1;
                if (gettingSize) {
                    if (value) {
                        ++size;
                        continue;
                    }
                    if (size == 0) {
                        ints.add(prevNum);
                        continue;
                    }
                    if (size == 1) {
                        ints.add(++prevNum);
                        size = 0;
                        continue;
                    }
                    gettingSize = false;
                    gap = 1;
                    --size;
                    continue;
                }
                gap <<= 1;
                if (value) {
                    ++gap;
                }
                if (--size != 0) continue;
                ints.add(prevNum += gap);
                gettingSize = true;
            }
        }
        return ints;
    }

    public static byte[] deltaEncode(int[] orig) {
        List<Byte> encodedList = ArrayUtils.deltaEncodeList(orig);
        byte[] arr = new byte[encodedList.size()];
        int i = 0;
        for (byte b : encodedList) {
            arr[i++] = b;
        }
        return arr;
    }

    public static List<Byte> deltaEncodeList(int[] orig) {
        for (int i = 1; i < orig.length; ++i) {
            if (orig[i] >= orig[i - 1]) continue;
            throw new IllegalArgumentException("Array must be sorted!");
        }
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        int index = 0;
        int prevNum = 0;
        byte currByte = 0;
        for (int f : orig) {
            int i;
            String n = f == prevNum ? "" : Integer.toString(f - prevNum, 2);
            String n1 = n.isEmpty() ? "" : Integer.toString(n.length(), 2);
            for (int ii = 0; ii < n1.length(); ++ii) {
                if (index == 8) {
                    bytes.add(currByte);
                    currByte = 0;
                    index = 0;
                }
                currByte = (byte)(currByte << 1);
                currByte = (byte)(currByte + 1);
                ++index;
            }
            if (index == 8) {
                bytes.add(currByte);
                currByte = 0;
                index = 0;
            }
            currByte = (byte)(currByte << 1);
            ++index;
            for (i = 1; i < n1.length(); ++i) {
                if (index == 8) {
                    bytes.add(currByte);
                    currByte = 0;
                    index = 0;
                }
                currByte = (byte)(currByte << 1);
                if (n1.charAt(i) == '1') {
                    currByte = (byte)(currByte + 1);
                }
                ++index;
            }
            for (i = 1; i < n.length(); ++i) {
                if (index == 8) {
                    bytes.add(currByte);
                    currByte = 0;
                    index = 0;
                }
                currByte = (byte)(currByte << 1);
                if (n.charAt(i) == '1') {
                    currByte = (byte)(currByte + 1);
                }
                ++index;
            }
            prevNum = f;
        }
        while (index > 0 && index < 9) {
            if (index == 8) {
                bytes.add(currByte);
                break;
            }
            currByte = (byte)(currByte << 1);
            currByte = (byte)(currByte + 1);
            ++index;
        }
        return bytes;
    }

    public static int[] deltaDecode(byte[] deltaEncoded) {
        return ArrayUtils.deltaDecode(deltaEncoded, 0, deltaEncoded.length);
    }

    public static int[] deltaDecode(byte[] deltaEncoded, int startIndex, int endIndex) {
        List<Integer> ints = ArrayUtils.deltaDecodeList(deltaEncoded);
        int[] arr = new int[ints.size()];
        int index = 0;
        for (int i : ints) {
            arr[index++] = i;
        }
        return arr;
    }

    public static List<Integer> deltaDecodeList(byte[] deltaEncoded) {
        return ArrayUtils.deltaDecodeList(deltaEncoded, 0, deltaEncoded.length);
    }

    public static List<Integer> deltaDecodeList(byte[] deltaEncoded, int startIndex, int endIndex) {
        boolean gettingSize1 = true;
        boolean gettingSize2 = false;
        int size1 = 0;
        ArrayList<Integer> ints = new ArrayList<Integer>();
        int gap = 0;
        int size2 = 0;
        int prevNum = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            byte b = deltaEncoded[i];
            for (int index = 7; index >= 0; --index) {
                boolean value;
                boolean bl = value = (b >> index & 1) == 1;
                if (gettingSize1) {
                    if (value) {
                        ++size1;
                        continue;
                    }
                    if (size1 == 0) {
                        ints.add(prevNum);
                        continue;
                    }
                    if (size1 == 1) {
                        ints.add(++prevNum);
                        size1 = 0;
                        continue;
                    }
                    gettingSize1 = false;
                    gettingSize2 = true;
                    size2 = 1;
                    --size1;
                    continue;
                }
                if (gettingSize2) {
                    size2 <<= 1;
                    if (value) {
                        ++size2;
                    }
                    if (--size1 != 0) continue;
                    gettingSize2 = false;
                    gap = 1;
                    --size2;
                    continue;
                }
                gap <<= 1;
                if (value) {
                    ++gap;
                }
                if (--size2 != 0) continue;
                ints.add(prevNum += gap);
                gettingSize1 = true;
            }
        }
        return ints;
    }

    private static byte[] bitSetToByteArray(BitSet bitSet) {
        while (bitSet.length() % 8 != 0) {
            bitSet.set(bitSet.length(), true);
        }
        byte[] array = new byte[bitSet.length() / 8];
        for (int i = 0; i < array.length; ++i) {
            int offset = i * 8;
            int index = 0;
            for (int j = 0; j < 8; ++j) {
                index <<= 1;
                if (!bitSet.get(offset + j)) continue;
                ++index;
            }
            array[i] = (byte)(index - 128);
        }
        return array;
    }

    private static BitSet byteArrayToBitSet(byte[] array) {
        BitSet bitSet = new BitSet();
        int index = 0;
        for (byte b : array) {
            int b1 = b + 128;
            bitSet.set(index++, (b1 >> 7 & 1) == 1);
            bitSet.set(index++, (b1 >> 6 & 1) == 1);
            bitSet.set(index++, (b1 >> 5 & 1) == 1);
            bitSet.set(index++, (b1 >> 4 & 1) == 1);
            bitSet.set(index++, (b1 >> 3 & 1) == 1);
            bitSet.set(index++, (b1 >> 2 & 1) == 1);
            bitSet.set(index++, (b1 >> 1 & 1) == 1);
            bitSet.set(index++, (b1 & 1) == 1);
        }
        return bitSet;
    }

    public static double[] flatten(double[][] array) {
        int size = 0;
        for (double[] a : array) {
            size += a.length;
        }
        double[] newArray = new double[size];
        int i = 0;
        double[][] dArray = array;
        int n = dArray.length;
        for (int j = 0; j < n; ++j) {
            double[] a;
            for (double d : a = dArray[j]) {
                newArray[i++] = d;
            }
        }
        return newArray;
    }

    public static double[][] to2D(double[] array, int dim1Size) {
        int dim2Size = array.length / dim1Size;
        return ArrayUtils.to2D(array, dim1Size, dim2Size);
    }

    public static double[][] to2D(double[] array, int dim1Size, int dim2Size) {
        double[][] newArray = new double[dim1Size][dim2Size];
        int k = 0;
        for (int i = 0; i < newArray.length; ++i) {
            for (int j = 0; j < newArray[i].length; ++j) {
                newArray[i][j] = array[k++];
            }
        }
        return newArray;
    }

    public static double[] removeAt(double[] array, int index) {
        if (array == null) {
            return null;
        }
        if (index < 0 || index >= array.length) {
            return array;
        }
        double[] retVal = new double[array.length - 1];
        for (int i = 0; i < array.length; ++i) {
            if (i < index) {
                retVal[i] = array[i];
                continue;
            }
            if (i <= index) continue;
            retVal[i - 1] = array[i];
        }
        return retVal;
    }

    public static Object[] removeAt(Object[] array, int index) {
        if (array == null) {
            return null;
        }
        if (index < 0 || index >= array.length) {
            return array;
        }
        Object[] retVal = (Object[])Array.newInstance(array[0].getClass(), array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            if (i < index) {
                retVal[i] = array[i];
                continue;
            }
            if (i <= index) continue;
            retVal[i - 1] = array[i];
        }
        return retVal;
    }

    public static String toString(int[][] a) {
        StringBuilder result = new StringBuilder("[");
        for (int i = 0; i < a.length; ++i) {
            result.append(Arrays.toString(a[i]));
            if (i >= a.length - 1) continue;
            result.append(',');
        }
        result.append(']');
        return result.toString();
    }

    public static boolean equalContents(int[][] xs, int[][] ys) {
        if (xs == null) {
            return ys == null;
        }
        if (ys == null) {
            return false;
        }
        if (xs.length != ys.length) {
            return false;
        }
        for (int i = xs.length - 1; i >= 0; --i) {
            if (ArrayUtils.equalContents(xs[i], ys[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[][] xs, double[][] ys) {
        if (xs == null) {
            return ys == null;
        }
        if (ys == null) {
            return false;
        }
        if (xs.length != ys.length) {
            return false;
        }
        for (int i = xs.length - 1; i >= 0; --i) {
            if (Arrays.equals(xs[i], ys[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalContents(int[] xs, int[] ys) {
        if (xs.length != ys.length) {
            return false;
        }
        for (int i = xs.length - 1; i >= 0; --i) {
            if (xs[i] == ys[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(boolean[][] xs, boolean[][] ys) {
        if (xs == null && ys != null) {
            return false;
        }
        if (ys == null) {
            return false;
        }
        if (xs.length != ys.length) {
            return false;
        }
        for (int i = xs.length - 1; i >= 0; --i) {
            if (Arrays.equals(xs[i], ys[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean contains(T[] a, T o) {
        for (T item : a) {
            if (!item.equals(o)) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] concatenate(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static <T> T[] filter(T[] original, Predicate<? super T> filter) {
        T[] result = Arrays.copyOf(original, original.length);
        int size = 0;
        for (T value : original) {
            if (!filter.test(value)) continue;
            result[size] = value;
            ++size;
        }
        if (size == original.length) {
            return result;
        }
        return Arrays.copyOf(result, size);
    }

    public static <T> Set<T> asSet(T[] a) {
        return Generics.newHashSet(Arrays.asList(a));
    }

    public static <T> Set<T> asImmutableSet(T[] a) {
        if (a.length == 0) {
            return Collections.emptySet();
        }
        if (a.length == 1) {
            return Collections.singleton(a[0]);
        }
        return Collections.unmodifiableSet(Generics.newHashSet(Arrays.asList(a)));
    }

    public static void fill(double[][] d, double val) {
        for (double[] aD : d) {
            Arrays.fill(aD, val);
        }
    }

    public static void fill(double[][][] d, double val) {
        for (double[][] aD : d) {
            ArrayUtils.fill(aD, val);
        }
    }

    public static void fill(double[][][][] d, double val) {
        for (double[][][] aD : d) {
            ArrayUtils.fill(aD, val);
        }
    }

    public static void fill(boolean[][] d, boolean val) {
        for (boolean[] aD : d) {
            Arrays.fill(aD, val);
        }
    }

    public static void fill(boolean[][][] d, boolean val) {
        for (boolean[][] aD : d) {
            ArrayUtils.fill(aD, val);
        }
    }

    public static void fill(boolean[][][][] d, boolean val) {
        for (boolean[][][] aD : d) {
            ArrayUtils.fill(aD, val);
        }
    }

    public static double[] toDouble(float[] a) {
        double[] d = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            d[i] = a[i];
        }
        return d;
    }

    public static double[] toDouble(int[] array) {
        double[] rv = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            rv[i] = array[i];
        }
        return rv;
    }

    public static List<Integer> asList(int[] array) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i : array) {
            l.add(i);
        }
        return l;
    }

    public static double[] asPrimitiveDoubleArray(Collection<Double> d) {
        double[] newD = new double[d.size()];
        int i = 0;
        for (Double j : d) {
            newD[i++] = j;
        }
        return newD;
    }

    public static int[] asPrimitiveIntArray(Collection<Integer> d) {
        int[] newI = new int[d.size()];
        int i = 0;
        for (Integer j : d) {
            newI[i++] = j;
        }
        return newI;
    }

    public static long[] copy(long[] arr) {
        if (arr == null) {
            return null;
        }
        long[] newArr = new long[arr.length];
        System.arraycopy(arr, 0, newArr, 0, arr.length);
        return newArr;
    }

    public static int[] copy(int[] i) {
        if (i == null) {
            return null;
        }
        int[] newI = new int[i.length];
        System.arraycopy(i, 0, newI, 0, i.length);
        return newI;
    }

    public static int[][] copy(int[][] i) {
        if (i == null) {
            return null;
        }
        int[][] newI = new int[i.length][];
        for (int j = 0; j < newI.length; ++j) {
            newI[j] = ArrayUtils.copy(i[j]);
        }
        return newI;
    }

    public static double[] copy(double[] d) {
        if (d == null) {
            return null;
        }
        double[] newD = new double[d.length];
        System.arraycopy(d, 0, newD, 0, d.length);
        return newD;
    }

    public static double[][] copy(double[][] d) {
        if (d == null) {
            return null;
        }
        double[][] newD = new double[d.length][];
        for (int i = 0; i < newD.length; ++i) {
            newD[i] = ArrayUtils.copy(d[i]);
        }
        return newD;
    }

    public static double[][][] copy(double[][][] d) {
        if (d == null) {
            return null;
        }
        double[][][] newD = new double[d.length][][];
        for (int i = 0; i < newD.length; ++i) {
            newD[i] = ArrayUtils.copy(d[i]);
        }
        return newD;
    }

    public static float[] copy(float[] d) {
        if (d == null) {
            return null;
        }
        float[] newD = new float[d.length];
        System.arraycopy(d, 0, newD, 0, d.length);
        return newD;
    }

    public static float[][] copy(float[][] d) {
        if (d == null) {
            return null;
        }
        float[][] newD = new float[d.length][];
        for (int i = 0; i < newD.length; ++i) {
            newD[i] = ArrayUtils.copy(d[i]);
        }
        return newD;
    }

    public static float[][][] copy(float[][][] d) {
        if (d == null) {
            return null;
        }
        float[][][] newD = new float[d.length][][];
        for (int i = 0; i < newD.length; ++i) {
            newD[i] = ArrayUtils.copy(d[i]);
        }
        return newD;
    }

    public static String toString(double[][] b) {
        StringBuilder result = new StringBuilder("[");
        for (int i = 0; i < b.length; ++i) {
            result.append(Arrays.toString(b[i]));
            if (i >= b.length - 1) continue;
            result.append(',');
        }
        result.append(']');
        return result.toString();
    }

    public static String toString(boolean[][] b) {
        StringBuilder result = new StringBuilder("[");
        for (int i = 0; i < b.length; ++i) {
            result.append(Arrays.toString(b[i]));
            if (i >= b.length - 1) continue;
            result.append(',');
        }
        result.append(']');
        return result.toString();
    }

    public static long[] toPrimitive(Long[] in) {
        return ArrayUtils.toPrimitive(in, 0L);
    }

    public static int[] toPrimitive(Integer[] in) {
        return ArrayUtils.toPrimitive(in, 0);
    }

    public static short[] toPrimitive(Short[] in) {
        return ArrayUtils.toPrimitive(in, (short)0);
    }

    public static char[] toPrimitive(Character[] in) {
        return ArrayUtils.toPrimitive(in, '\u0000');
    }

    public static double[] toPrimitive(Double[] in) {
        return ArrayUtils.toPrimitive(in, 0.0);
    }

    public static long[] toPrimitive(Long[] in, long valueForNull) {
        if (in == null) {
            return null;
        }
        long[] out2 = new long[in.length];
        for (int i = 0; i < in.length; ++i) {
            Long b = in[i];
            out2[i] = b == null ? valueForNull : b;
        }
        return out2;
    }

    public static int[] toPrimitive(Integer[] in, int valueForNull) {
        if (in == null) {
            return null;
        }
        int[] out2 = new int[in.length];
        for (int i = 0; i < in.length; ++i) {
            Integer b = in[i];
            out2[i] = b == null ? valueForNull : b;
        }
        return out2;
    }

    public static short[] toPrimitive(Short[] in, short valueForNull) {
        if (in == null) {
            return null;
        }
        short[] out2 = new short[in.length];
        for (int i = 0; i < in.length; ++i) {
            Short b = in[i];
            out2[i] = b == null ? valueForNull : b;
        }
        return out2;
    }

    public static char[] toPrimitive(Character[] in, char valueForNull) {
        if (in == null) {
            return null;
        }
        char[] out2 = new char[in.length];
        for (int i = 0; i < in.length; ++i) {
            Character b = in[i];
            out2[i] = b == null ? valueForNull : b.charValue();
        }
        return out2;
    }

    public static double[] toDoubleArray(String[] in) {
        double[] ret = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = Double.parseDouble(in[i]);
        }
        return ret;
    }

    public static double[] toPrimitive(Double[] in, double valueForNull) {
        if (in == null) {
            return null;
        }
        double[] out2 = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            Double b = in[i];
            out2[i] = b == null ? valueForNull : b;
        }
        return out2;
    }

    public static <T extends Comparable<T>> int compareArrays(T[] first, T[] second) {
        List<T> firstAsList = Arrays.asList(first);
        List<T> secondAsList = Arrays.asList(second);
        return CollectionUtils.compareLists(firstAsList, secondAsList);
    }

    public static List<Integer> getSubListIndex(Object[] tofind, Object[] tokens) {
        return ArrayUtils.getSubListIndex(tofind, tokens, o1 -> o1.first().equals(o1.second()));
    }

    public static List<Integer> getSubListIndex(Object[] tofind, Object[] tokens, Predicate<Pair> matchingFunction) {
        if (tofind.length > tokens.length) {
            return null;
        }
        ArrayList<Integer> allIndices = new ArrayList<Integer>();
        boolean matched = false;
        int index = -1;
        int lastUnmatchedIndex = 0;
        int i = 0;
        while (i < tokens.length) {
            int j = 0;
            while (j < tofind.length) {
                if (matchingFunction.test(new Pair<Object, Object>(tofind[j], tokens[i]))) {
                    index = i++;
                    if (++j == tofind.length) {
                        matched = true;
                        break;
                    }
                } else {
                    j = 0;
                    lastUnmatchedIndex = i = lastUnmatchedIndex + 1;
                    index = -1;
                    if (lastUnmatchedIndex == tokens.length) break;
                }
                if (i < tokens.length) continue;
                index = -1;
                break;
            }
            if (i != tokens.length && !matched) continue;
            if (index >= 0) {
                allIndices.add(index - tofind.length + 1);
            }
            matched = false;
            lastUnmatchedIndex = index;
        }
        return allIndices;
    }

    public static double[] normalize(double[] ar) {
        double[] ar2 = new double[ar.length];
        double total = 0.0;
        for (double d : ar) {
            total += d;
        }
        for (int i = 0; i < ar.length; ++i) {
            ar2[i] = ar[i] / total;
        }
        return ar2;
    }

    public static Object[] subArray(Object[] arr, int startindexInclusive, int endindexExclusive) {
        if (arr == null) {
            return arr;
        }
        Class<?> type = arr.getClass().getComponentType();
        if (endindexExclusive < startindexInclusive || startindexInclusive > arr.length - 1) {
            return (Object[])Array.newInstance(type, 0);
        }
        if (endindexExclusive > arr.length) {
            endindexExclusive = arr.length;
        }
        if (startindexInclusive < 0) {
            startindexInclusive = 0;
        }
        Object[] b = (Object[])Array.newInstance(type, endindexExclusive - startindexInclusive);
        System.arraycopy(arr, startindexInclusive, b, 0, endindexExclusive - startindexInclusive);
        return b;
    }

    public static int compareBooleanArrays(boolean[] a1, boolean[] a2) {
        int len = Math.min(a1.length, a2.length);
        for (int i = 0; i < len; ++i) {
            if (!a1[i] && a2[i]) {
                return -1;
            }
            if (!a1[i] || a2[i]) continue;
            return 1;
        }
        if (a1.length < a2.length) {
            return -1;
        }
        if (a1.length > a2.length) {
            return 1;
        }
        return 0;
    }

    public static String toString(double[] doubles, String glue) {
        String s = "";
        for (int i = 0; i < doubles.length; ++i) {
            s = i == 0 ? String.valueOf(doubles[i]) : s + glue + String.valueOf(doubles[i]);
        }
        return s;
    }
}

