/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international;

import edu.stanford.nlp.parser.lexparser.ArabicTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.ChineseTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.EnglishTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.FrenchTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.HebrewTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.NegraPennTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.SpanishTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.util.StringUtils;
import java.util.Arrays;

public enum Language {
    Any(new EnglishTreebankParserParams()),
    Arabic(new ArabicTreebankParserParams()),
    Chinese(new ChineseTreebankParserParams()),
    English(new EnglishTreebankParserParams(){
        {
            this.setGenerateOriginalDependencies(true);
        }
    }),
    German(new NegraPennTreebankParserParams()),
    French(new FrenchTreebankParserParams()),
    Hebrew(new HebrewTreebankParserParams()),
    Spanish(new SpanishTreebankParserParams()),
    UniversalChinese(new ChineseTreebankParserParams()),
    UniversalEnglish(new EnglishTreebankParserParams()),
    Unknown(new EnglishTreebankParserParams());

    public static final String langList;
    public final TreebankLangParserParams params;

    private Language(TreebankLangParserParams params) {
        this.params = params;
    }

    public boolean compatibleWith(Language other) {
        return this == other || this == Any || other == Any;
    }

    static {
        langList = StringUtils.join(Arrays.asList(Language.values()), " ");
    }
}

