/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.optimization.DiffFloatFunction;
import edu.stanford.nlp.optimization.HasFloatInitial;
import java.util.Arrays;

public abstract class AbstractCachingDiffFloatFunction
implements DiffFloatFunction,
HasFloatInitial {
    private float[] lastX = null;
    protected float[] derivative = null;
    protected float value = 0.0f;

    @Override
    public abstract int domainDimension();

    protected abstract void calculate(float[] var1);

    @Override
    public float[] initial() {
        float[] initial = new float[this.domainDimension()];
        return initial;
    }

    protected static void copy(float[] y, float[] x) {
        System.arraycopy(x, 0, y, 0, x.length);
    }

    void ensure(float[] x) {
        if (Arrays.equals(x, this.lastX)) {
            return;
        }
        if (this.lastX == null) {
            this.lastX = new float[this.domainDimension()];
        }
        if (this.derivative == null) {
            this.derivative = new float[this.domainDimension()];
        }
        AbstractCachingDiffFloatFunction.copy(this.lastX, x);
        this.calculate(x);
    }

    @Override
    public float valueAt(float[] x) {
        this.ensure(x);
        return this.value;
    }

    static float norm2(float[] x) {
        float sum = 0.0f;
        for (float aX : x) {
            sum += aX * aX;
        }
        return (float)Math.sqrt(sum);
    }

    @Override
    public float[] derivativeAt(float[] x) {
        this.ensure(x);
        return this.derivative;
    }
}

