/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.optimization.FloatFunction;
import edu.stanford.nlp.util.ConvertByteArray;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;

public class ResultStoringFloatMonitor
implements FloatFunction {
    int i = 0;
    final int outputFreq;
    final String filename;

    public ResultStoringFloatMonitor(int outputFreq, String filename) {
        this.filename = filename.lastIndexOf(46) >= 0 ? filename.substring(0, filename.lastIndexOf(46)) + ".fdat" : filename + ".fdat";
        this.outputFreq = outputFreq;
    }

    @Override
    public float valueAt(float[] x) {
        if (++this.i % this.outputFreq == 0) {
            System.err.print("Storing interim (float) weights to " + this.filename + " ... ");
            try {
                DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(this.filename))));
                ConvertByteArray.saveFloatArr(dos, x);
                dos.close();
            }
            catch (IOException e) {
                System.err.println("ERROR!");
                return 1.0f;
            }
            System.err.println("DONE.");
        }
        return 0.0f;
    }

    @Override
    public int domainDimension() {
        return 0;
    }
}

