/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.io;

import edu.stanford.nlp.io.BZip2PipedOutputStream;
import edu.stanford.nlp.io.EncodingFileReader;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.util.AbstractIterator;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StreamGobbler;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;

public class IOUtils {
    private static final int SLURP_BUFFER_SIZE = 16000;
    private static final int GZIP_FILE_BUFFER_SIZE = 65536;
    public static final String eolChar = System.getProperty("line.separator");
    public static final String defaultEncoding = "utf-8";
    private static final Pattern tab = Pattern.compile("\t");
    private static Set<String> blacklistedPathsToRemove = new HashSet<String>(){
        {
            this.add("/");
            this.add("/u");
            this.add("/u/");
            this.add("/u/nlp");
            this.add("/u/nlp/");
            this.add("/u/nlp/data");
            this.add("/u/nlp/data/");
            this.add("/scr");
            this.add("/scr/");
            this.add("/scr/nlp/data");
            this.add("/scr/nlp/data/");
        }
    };

    private IOUtils() {
    }

    public static File writeObjectToFile(Object o, String filename) throws IOException {
        return IOUtils.writeObjectToFile(o, new File(filename));
    }

    public static File writeObjectToFile(Object o, File file) throws IOException {
        return IOUtils.writeObjectToFile(o, file, false);
    }

    public static File writeObjectToFile(Object o, File file, boolean append) throws IOException {
        OutputStream os = new FileOutputStream(file, append);
        if (file.getName().endsWith(".gz")) {
            os = new GZIPOutputStream(os);
        }
        os = new BufferedOutputStream(os);
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(o);
        oos.close();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeObjectToFileNoExceptions(Object o, String filename) {
        File file = null;
        ObjectOutputStream oos = null;
        try {
            file = new File(filename);
            oos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file))));
            oos.writeObject(o);
            oos.close();
            IOUtils.closeIgnoringExceptions(oos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeIgnoringExceptions(oos);
        }
        return file;
    }

    public static File writeObjectToTempFile(Object o, String filename) throws IOException {
        File file = File.createTempFile(filename, ".tmp");
        file.deleteOnExit();
        IOUtils.writeObjectToFile(o, file);
        return file;
    }

    public static File writeObjectToTempFileNoExceptions(Object o, String filename) {
        try {
            return IOUtils.writeObjectToTempFile(o, filename);
        }
        catch (Exception e) {
            System.err.println("Error writing object to file " + filename);
            e.printStackTrace();
            return null;
        }
    }

    private static OutputStream getBufferedOutputStream(String path) throws IOException {
        FilterOutputStream os = new BufferedOutputStream(new FileOutputStream(path));
        if (path.endsWith(".gz")) {
            os = new GZIPOutputStream(os);
        }
        return os;
    }

    public static void writeStringToFile(String contents, String path, String encoding) throws IOException {
        OutputStream writer = IOUtils.getBufferedOutputStream(path);
        writer.write(contents.getBytes(encoding));
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeStringToFileNoExceptions(String contents, String path, String encoding) {
        FilterOutputStream writer = null;
        try {
            writer = path.endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(path)) : new BufferedOutputStream(new FileOutputStream(path));
            ((OutputStream)writer).write(contents.getBytes(encoding));
            if (writer == null) return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (writer != null) {
                IOUtils.closeIgnoringExceptions(writer);
            }
        }
        IOUtils.closeIgnoringExceptions(writer);
        return;
    }

    public static File writeStringToTempFile(String contents, String path, String encoding) throws IOException {
        File tmp = File.createTempFile(path, ".tmp");
        FilterOutputStream writer = path.endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(tmp)) : new BufferedOutputStream(new FileOutputStream(tmp));
        ((OutputStream)writer).write(contents.getBytes(encoding));
        return tmp;
    }

    public static void writeStringToTempFile(String contents, String path) throws IOException {
        IOUtils.writeStringToTempFile(contents, path, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeStringToTempFileNoExceptions(String contents, String path, String encoding) {
        FilterOutputStream writer = null;
        File tmp = null;
        try {
            tmp = File.createTempFile(path, ".tmp");
            writer = path.endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(tmp)) : new BufferedOutputStream(new FileOutputStream(tmp));
            ((OutputStream)writer).write(contents.getBytes(encoding));
            IOUtils.closeIgnoringExceptions(writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeIgnoringExceptions(writer);
        }
        return tmp;
    }

    public static void writeStringToTempFileNoExceptions(String contents, String path) {
        IOUtils.writeStringToTempFileNoExceptions(contents, path, "UTF-8");
    }

    public static <T> T readObjectFromFile(File file) throws IOException, ClassNotFoundException {
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
            Object o = ois.readObject();
            ois.close();
            return ErasureUtils.uncheckedCast(o);
        }
        catch (ZipException e) {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            Object o = ois.readObject();
            ois.close();
            return ErasureUtils.uncheckedCast(o);
        }
    }

    public static DataInputStream getDataInputStream(String filenameUrlOrClassPath) throws IOException {
        return new DataInputStream(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(filenameUrlOrClassPath));
    }

    public static DataOutputStream getDataOutputStream(String filename) throws IOException {
        return new DataOutputStream(IOUtils.getBufferedOutputStream(filename));
    }

    public static <T> T readObjectFromURLOrClasspathOrFileSystem(String filename) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(filename));
        Object o = ois.readObject();
        ois.close();
        return ErasureUtils.uncheckedCast(o);
    }

    public static <T> T readObjectAnnouncingTimingFromURLOrClasspathOrFileSystem(String msg, String path) {
        T obj;
        try {
            Timing timing = new Timing();
            System.err.print(msg + ' ' + path + " ... ");
            obj = IOUtils.readObjectFromURLOrClasspathOrFileSystem(path);
            timing.done();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeIOException(e);
        }
        return obj;
    }

    public static <T> T readObjectFromObjectStream(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Object o = ois.readObject();
        return ErasureUtils.uncheckedCast(o);
    }

    public static <T> T readObjectFromFile(String filename) throws IOException, ClassNotFoundException {
        return ErasureUtils.uncheckedCast(IOUtils.readObjectFromFile(new File(filename)));
    }

    public static <T> T readObjectFromFileNoExceptions(File file) {
        Object o = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
            o = ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return ErasureUtils.uncheckedCast(o);
    }

    public static int lineCount(String textFileOrUrl) throws IOException {
        BufferedReader r = IOUtils.readerFromString(textFileOrUrl);
        int numLines = 0;
        while (r.readLine() != null) {
            ++numLines;
        }
        return numLines;
    }

    public static ObjectOutputStream writeStreamFromString(String serializePath) throws IOException {
        ObjectOutputStream oos = serializePath.endsWith(".gz") ? new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(serializePath)))) : new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(serializePath)));
        return oos;
    }

    public static ObjectInputStream readStreamFromString(String filenameOrUrl) throws IOException {
        InputStream is = IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(filenameOrUrl);
        return new ObjectInputStream(is);
    }

    private static InputStream findStreamInClasspathOrFileSystem(String name) throws FileNotFoundException {
        InputStream is = IOUtils.class.getClassLoader().getResourceAsStream(name);
        if (is == null && (is = IOUtils.class.getClassLoader().getResourceAsStream(name.replaceAll("\\\\", "/"))) == null) {
            is = IOUtils.class.getClassLoader().getResourceAsStream(name.replaceAll("\\\\", "/").replaceAll("/+", "/"));
        }
        if (is == null) {
            is = new FileInputStream(name);
        }
        if (name.endsWith(".gz")) {
            try {
                return new GZIPInputStream(is);
            }
            catch (IOException e) {
                System.err.println("Resource or file looks like a gzip file, but is not: " + name);
            }
        }
        return is;
    }

    public static boolean existsInClasspathOrFileSystem(String name) {
        InputStream is = IOUtils.class.getClassLoader().getResourceAsStream(name);
        if (is == null) {
            is = IOUtils.class.getClassLoader().getResourceAsStream(name.replaceAll("\\\\", "/"));
        }
        return is != null || new File(name).exists();
    }

    public static InputStream getInputStreamFromURLOrClasspathOrFileSystem(String textFileOrUrl) throws IOException {
        InputStream in;
        if (textFileOrUrl.matches("https?://.*")) {
            URL u = new URL(textFileOrUrl);
            URLConnection uc = u.openConnection();
            in = uc.getInputStream();
            if (textFileOrUrl.endsWith(".gz")) {
                try {
                    in = new GZIPInputStream(in);
                }
                catch (IOException e) {}
            }
        } else {
            try {
                in = IOUtils.findStreamInClasspathOrFileSystem(textFileOrUrl);
            }
            catch (FileNotFoundException e) {
                try {
                    URL u = new URL(textFileOrUrl);
                    URLConnection uc = u.openConnection();
                    in = uc.getInputStream();
                }
                catch (IOException e2) {
                    throw new IOException("Unable to resolve \"" + textFileOrUrl + "\" as either " + "class path, filename or URL");
                }
            }
        }
        in = new BufferedInputStream(in);
        return in;
    }

    public static InputStream inputStreamFromFile(File file) throws RuntimeIOException {
        try {
            FilterInputStream is = new BufferedInputStream(new FileInputStream(file));
            if (file.getName().endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            return is;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static BufferedReader readerFromFile(File file) {
        InputStream is = null;
        try {
            is = IOUtils.inputStreamFromFile(file);
            return new BufferedReader(new InputStreamReader(is, "UTF-8"));
        }
        catch (IOException ioe) {
            IOUtils.closeIgnoringExceptions(is);
            throw new RuntimeIOException(ioe);
        }
    }

    public static BufferedReader readerFromFile(File file, String encoding) {
        InputStream is = null;
        try {
            is = IOUtils.inputStreamFromFile(file);
            if (encoding == null) {
                return new BufferedReader(new InputStreamReader(is));
            }
            return new BufferedReader(new InputStreamReader(is, encoding));
        }
        catch (IOException ioe) {
            IOUtils.closeIgnoringExceptions(is);
            throw new RuntimeIOException(ioe);
        }
    }

    public static BufferedReader readerFromStdin() {
        return new BufferedReader(new InputStreamReader(System.in));
    }

    public static BufferedReader readerFromStdin(String encoding) throws IOException {
        if (encoding == null) {
            return new BufferedReader(new InputStreamReader(System.in));
        }
        return new BufferedReader(new InputStreamReader(System.in, encoding));
    }

    public static BufferedReader readerFromString(String textFileOrUrl) throws IOException {
        return new BufferedReader(new InputStreamReader(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(textFileOrUrl), "UTF-8"));
    }

    public static BufferedReader readerFromString(String textFileOrUrl, String encoding) throws IOException {
        InputStream is = IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(textFileOrUrl);
        if (encoding == null) {
            return new BufferedReader(new InputStreamReader(is));
        }
        return new BufferedReader(new InputStreamReader(is, encoding));
    }

    public static Iterable<String> readLines(String path) {
        return IOUtils.readLines(path, null);
    }

    public static Iterable<String> readLines(String path, String encoding) {
        return new GetLinesIterable(path, null, encoding);
    }

    public static Iterable<String> readLines(File file) {
        return IOUtils.readLines(file, null, null);
    }

    public static Iterable<String> readLines(File file, Class<? extends InputStream> fileInputStreamWrapper) {
        return IOUtils.readLines(file, fileInputStreamWrapper, null);
    }

    public static Iterable<String> readLines(File file, Class<? extends InputStream> fileInputStreamWrapper, String encoding) {
        return new GetLinesIterable(file, fileInputStreamWrapper, encoding);
    }

    public static Iterable<String> getLineIterable(Reader r, boolean includeEol) {
        if (includeEol) {
            return new EolPreservingLineReaderIterable(r);
        }
        return new LineReaderIterable(r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r));
    }

    public static Iterable<String> getLineIterable(Reader r, int bufferSize, boolean includeEol) {
        if (includeEol) {
            return new EolPreservingLineReaderIterable(r, bufferSize);
        }
        return new LineReaderIterable(r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r, bufferSize));
    }

    public static void closeIgnoringExceptions(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static Iterable<File> iterFilesRecursive(File dir) {
        return IOUtils.iterFilesRecursive(dir, (Pattern)null);
    }

    public static Iterable<File> iterFilesRecursive(File dir, String ext) {
        return IOUtils.iterFilesRecursive(dir, Pattern.compile(Pattern.quote(ext) + "$"));
    }

    public static Iterable<File> iterFilesRecursive(final File dir, final Pattern pattern) {
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new AbstractIterator<File>(){
                    private final Queue<File> files;
                    private File file;
                    {
                        this.files = new LinkedList<File>(Collections.singleton(dir));
                        this.file = this.findNext();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.file != null;
                    }

                    @Override
                    public File next() {
                        File result = this.file;
                        if (result == null) {
                            throw new NoSuchElementException();
                        }
                        this.file = this.findNext();
                        return result;
                    }

                    private File findNext() {
                        File next = null;
                        while (!this.files.isEmpty() && next == null) {
                            next = this.files.remove();
                            if (next.isDirectory()) {
                                this.files.addAll(Arrays.asList(next.listFiles()));
                                next = null;
                                continue;
                            }
                            if (pattern == null || pattern.matcher(next.getPath()).find()) continue;
                            next = null;
                        }
                        return next;
                    }
                };
            }
        };
    }

    public static String slurpFile(File file) throws IOException {
        return IOUtils.slurpFile(file, null);
    }

    public static String slurpFile(File file, String encoding) throws IOException {
        return IOUtils.slurpReader(IOUtils.encodedInputStreamReader(new FileInputStream(file), encoding));
    }

    public static String slurpGZippedFile(String filename) throws IOException {
        Reader r = IOUtils.encodedInputStreamReader(new GZIPInputStream(new FileInputStream(filename)), null);
        return IOUtils.slurpReader(r);
    }

    public static String slurpGZippedFile(File file) throws IOException {
        Reader r = IOUtils.encodedInputStreamReader(new GZIPInputStream(new FileInputStream(file)), null);
        return IOUtils.slurpReader(r);
    }

    public static String slurpFile(String filename, String encoding) throws IOException {
        BufferedReader r = IOUtils.readerFromString(filename, encoding);
        return IOUtils.slurpReader(r);
    }

    public static String slurpFileNoExceptions(String filename, String encoding) {
        try {
            return IOUtils.slurpFile(filename, encoding);
        }
        catch (IOException e) {
            throw new RuntimeIOException("slurpFile IO problem", e);
        }
    }

    public static String slurpFile(String filename) throws IOException {
        return IOUtils.slurpFile(filename, defaultEncoding);
    }

    public static String slurpURLNoExceptions(URL u, String encoding) {
        try {
            return IOUtils.slurpURL(u, encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpURL(URL u, String encoding) throws IOException {
        String temp;
        InputStream is;
        String lineSeparator = System.getProperty("line.separator");
        URLConnection uc = u.openConnection();
        uc.setReadTimeout(30000);
        try {
            is = uc.getInputStream();
        }
        catch (SocketTimeoutException e) {
            System.err.println("Time out. Return empty string");
            return "";
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
        StringBuilder buff = new StringBuilder(16000);
        while ((temp = br.readLine()) != null) {
            buff.append(temp);
            buff.append(lineSeparator);
        }
        br.close();
        return buff.toString();
    }

    public static String getUrlEncoding(URLConnection connection) {
        String contentType = connection.getContentType();
        String[] values = contentType.split(";");
        String charset = defaultEncoding;
        for (String value : values) {
            if (!(value = value.trim()).toLowerCase(Locale.ENGLISH).startsWith("charset=")) continue;
            charset = value.substring("charset=".length());
        }
        return charset;
    }

    public static String slurpURL(URL u) throws IOException {
        String temp;
        String lineSeparator = System.getProperty("line.separator");
        URLConnection uc = u.openConnection();
        String encoding = IOUtils.getUrlEncoding(uc);
        InputStream is = uc.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
        StringBuilder buff = new StringBuilder(16000);
        while ((temp = br.readLine()) != null) {
            buff.append(temp);
            buff.append(lineSeparator);
        }
        br.close();
        return buff.toString();
    }

    public static String slurpURLNoExceptions(URL u) {
        try {
            return IOUtils.slurpURL(u);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpURL(String path) throws Exception {
        return IOUtils.slurpURL(new URL(path));
    }

    public static String slurpURLNoExceptions(String path) {
        try {
            return IOUtils.slurpURL(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpFileNoExceptions(File file) {
        try {
            return IOUtils.slurpReader(IOUtils.encodedInputStreamReader(new FileInputStream(file), null));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static String slurpFileNoExceptions(String filename) {
        try {
            return IOUtils.slurpFile(filename);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static String slurpReader(Reader reader) {
        BufferedReader r = new BufferedReader(reader);
        StringBuilder buff = new StringBuilder();
        try {
            int amountRead;
            char[] chars = new char[16000];
            while ((amountRead = r.read(chars, 0, 16000)) >= 0) {
                buff.append(chars, 0, amountRead);
            }
            r.close();
        }
        catch (Exception e) {
            throw new RuntimeIOException("slurpReader IO problem", e);
        }
        return buff.toString();
    }

    public static void writeStreamToStream(InputStream input, OutputStream output) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        while ((len = input.read(buffer)) != -1) {
            output.write(buffer, 0, len);
        }
    }

    public static List<Map<String, String>> readCSVWithHeader(String path, char quoteChar, char escapeChar) throws IOException {
        String[] labels = null;
        ArrayList<Map<String, String>> rows = Generics.newArrayList();
        for (String line : IOUtils.readLines(path)) {
            System.out.println("Splitting " + line);
            if (labels == null) {
                labels = StringUtils.splitOnCharWithQuoting(line, ',', '\"', escapeChar);
                continue;
            }
            String[] cells = StringUtils.splitOnCharWithQuoting(line, ',', quoteChar, escapeChar);
            assert (cells.length == labels.length);
            Map<String, String> cellMap = Generics.newHashMap();
            for (int i = 0; i < labels.length; ++i) {
                cellMap.put(labels[i], cells[i]);
            }
            rows.add(cellMap);
        }
        return rows;
    }

    public static List<Map<String, String>> readCSVWithHeader(String path) throws IOException {
        return IOUtils.readCSVWithHeader(path, '\"', '\"');
    }

    public static LinkedList<String[]> readCSVStrictly(char[] csvContents, int numColumns) {
        StringBuilder[] buffer = new StringBuilder[numColumns];
        buffer[0] = new StringBuilder();
        LinkedList<String[]> lines = new LinkedList<String[]>();
        boolean inQuotes = false;
        boolean nextIsEscaped = false;
        int columnI = 0;
        block6: for (int offset = 0; offset < csvContents.length; ++offset) {
            if (nextIsEscaped) {
                buffer[columnI].append(csvContents[offset]);
                nextIsEscaped = false;
                continue;
            }
            switch (csvContents[offset]) {
                case '\"': {
                    inQuotes = !inQuotes;
                    continue block6;
                }
                case ',': {
                    if (inQuotes) {
                        buffer[columnI].append(',');
                        continue block6;
                    }
                    if (++columnI >= numColumns) {
                        throw new IllegalArgumentException("Too many columns: " + columnI + "/" + numColumns + " (offset: " + offset + ")");
                    }
                    buffer[columnI] = new StringBuilder();
                    continue block6;
                }
                case '\n': {
                    if (inQuotes) {
                        buffer[columnI].append('\n');
                        continue block6;
                    }
                    if (columnI != numColumns - 1) {
                        throw new IllegalArgumentException("Too few columns: " + columnI + "/" + numColumns + " (offset: " + offset + ")");
                    }
                    String[] rtn = new String[buffer.length];
                    for (int i = 0; i < buffer.length; ++i) {
                        rtn[i] = buffer[i].toString();
                    }
                    lines.add(rtn);
                    columnI = 0;
                    buffer[columnI] = new StringBuilder();
                    continue block6;
                }
                case '\\': {
                    nextIsEscaped = true;
                    continue block6;
                }
                default: {
                    buffer[columnI].append(csvContents[offset]);
                }
            }
        }
        return lines;
    }

    public static LinkedList<String[]> readCSVStrictly(String filename, int numColumns) throws IOException {
        return IOUtils.readCSVStrictly(IOUtils.slurpFile(filename).toCharArray(), numColumns);
    }

    public static InputStream getFileInputStream(String filename) throws IOException {
        InputStream in = new FileInputStream(filename);
        if (filename.endsWith(".gz")) {
            in = new GZIPInputStream(in);
        } else if (filename.endsWith(".bz2")) {
            in = IOUtils.getBZip2PipedInputStream(filename);
        }
        return in;
    }

    public static OutputStream getFileOutputStream(String filename) throws IOException {
        OutputStream out2 = new FileOutputStream(filename);
        if (filename.endsWith(".gz")) {
            out2 = new GZIPOutputStream(out2);
        } else if (filename.endsWith(".bz2")) {
            out2 = IOUtils.getBZip2PipedOutputStream(filename);
        }
        return out2;
    }

    public static BufferedReader getBufferedFileReader(String filename) throws IOException {
        return IOUtils.getBufferedFileReader(filename, defaultEncoding);
    }

    public static BufferedReader getBufferedFileReader(String filename, String encoding) throws IOException {
        InputStream in = IOUtils.getFileInputStream(filename);
        return new BufferedReader(new InputStreamReader(in, encoding));
    }

    public static BufferedReader getBufferedReaderFromClasspathOrFileSystem(String filename) throws IOException {
        return IOUtils.getBufferedReaderFromClasspathOrFileSystem(filename, defaultEncoding);
    }

    public static BufferedReader getBufferedReaderFromClasspathOrFileSystem(String filename, String encoding) throws IOException {
        InputStream in = IOUtils.findStreamInClasspathOrFileSystem(filename);
        return new BufferedReader(new InputStreamReader(in, encoding));
    }

    public static PrintWriter getPrintWriter(File textFile) throws IOException {
        return IOUtils.getPrintWriter(textFile, null);
    }

    public static PrintWriter getPrintWriter(File textFile, String encoding) throws IOException {
        File f = textFile.getAbsoluteFile();
        if (encoding == null) {
            encoding = defaultEncoding;
        }
        return new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), encoding)), true);
    }

    public static PrintWriter getPrintWriter(String filename) throws IOException {
        return IOUtils.getPrintWriter(filename, defaultEncoding);
    }

    public static PrintWriter getPrintWriterIgnoringExceptions(String filename) {
        try {
            return IOUtils.getPrintWriter(filename, defaultEncoding);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static PrintWriter getPrintWriterOrDie(String filename) {
        try {
            return IOUtils.getPrintWriter(filename, defaultEncoding);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
    }

    public static PrintWriter getPrintWriter(String filename, String encoding) throws IOException {
        OutputStream out2 = IOUtils.getFileOutputStream(filename);
        if (encoding == null) {
            encoding = defaultEncoding;
        }
        return new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(out2, encoding)), true);
    }

    public static InputStream getBZip2PipedInputStream(String filename) throws IOException {
        String bzcat = System.getProperty("bzcat", "bzcat");
        Runtime rt = Runtime.getRuntime();
        String cmd = bzcat + " " + filename;
        Process p = rt.exec(cmd);
        BufferedWriter errWriter = new BufferedWriter(new OutputStreamWriter(System.err));
        StreamGobbler errGobbler = new StreamGobbler(p.getErrorStream(), errWriter);
        errGobbler.start();
        return p.getInputStream();
    }

    public static OutputStream getBZip2PipedOutputStream(String filename) throws IOException {
        return new BZip2PipedOutputStream(filename);
    }

    public static Set<String> readColumnSet(String infile, int field) throws IOException {
        String line;
        BufferedReader br = IOUtils.getBufferedFileReader(infile);
        Set<String> set = Generics.newHashSet();
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).length() <= 0) continue;
            if (field < 0) {
                set.add(line);
                continue;
            }
            String[] fields = tab.split(line);
            if (field >= fields.length) continue;
            set.add(fields[field]);
        }
        br.close();
        return set;
    }

    public static <C> List<C> readObjectFromColumns(Class objClass, String filename, String[] fieldNames, String delimiter) throws IOException, InstantiationException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, InvocationTargetException {
        String line;
        Pattern delimiterPattern = Pattern.compile(delimiter);
        ArrayList list = new ArrayList();
        BufferedReader br = IOUtils.getBufferedFileReader(filename);
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).length() <= 0) continue;
            Object item = StringUtils.columnStringToObject(objClass, line, delimiterPattern, fieldNames);
            list.add(item);
        }
        br.close();
        return list;
    }

    public static Map<String, String> readMap(String filename) throws IOException {
        Map<String, String> map = Generics.newHashMap();
        try {
            String line;
            BufferedReader br = IOUtils.getBufferedFileReader(filename);
            while ((line = br.readLine()) != null) {
                String[] fields = tab.split(line, 2);
                map.put(fields[0], fields[1]);
            }
            br.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return map;
    }

    public static String stringFromFile(String filename) {
        return IOUtils.stringFromFile(filename, defaultEncoding);
    }

    public static String stringFromFile(String filename, String encoding) {
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            BufferedReader in = new BufferedReader(new EncodingFileReader(filename, encoding));
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append(eolChar);
            }
            in.close();
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> linesFromFile(String filename) {
        return IOUtils.linesFromFile(filename, defaultEncoding);
    }

    public static List<String> linesFromFile(String filename, String encoding) {
        return IOUtils.linesFromFile(filename, encoding, false);
    }

    public static List<String> linesFromFile(String filename, String encoding, boolean ignoreHeader) {
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader in = IOUtils.getBufferedReaderFromClasspathOrFileSystem(filename, encoding);
            int i = 0;
            while ((line = in.readLine()) != null) {
                if (ignoreHeader && ++i == 1) continue;
                lines.add(line);
            }
            in.close();
            return lines;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String backupName(String filename) {
        return IOUtils.backupFile(new File(filename)).toString();
    }

    public static File backupFile(File file) {
        int max = 1000;
        String filename = file.toString();
        File backup = new File(filename + "~");
        if (!backup.exists()) {
            return backup;
        }
        for (int i = 1; i <= max; ++i) {
            backup = new File(filename + ".~" + i + ".~");
            if (backup.exists()) continue;
            return backup;
        }
        return null;
    }

    public static boolean renameToBackupName(File file) {
        return file.renameTo(IOUtils.backupFile(file));
    }

    public static File getJNLPLocalScratch() {
        try {
            String machineName = InetAddress.getLocalHost().getHostName().split("\\.")[0];
            String username = System.getProperty("user.name");
            return new File("/" + machineName + "/scr1/" + username);
        }
        catch (Exception e) {
            return new File("./scr/");
        }
    }

    public static File ensureDir(File tgtDir) throws IOException {
        if (tgtDir.exists()) {
            if (tgtDir.isDirectory()) {
                return tgtDir;
            }
            throw new IOException("Could not create directory " + tgtDir.getAbsolutePath() + ", as a file already exists at that path.");
        }
        if (!tgtDir.mkdirs()) {
            throw new IOException("Could not create directory " + tgtDir.getAbsolutePath());
        }
        return tgtDir;
    }

    public static boolean deleteDirRecursively(File dir) {
        if (dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                boolean success = IOUtils.deleteDirRecursively(f);
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static String getExtension(String fileName) {
        if (!fileName.contains(".")) {
            return null;
        }
        int idx = fileName.lastIndexOf(46);
        return fileName.substring(idx + 1);
    }

    public static Reader encodedInputStreamReader(InputStream stream, String encoding) throws IOException {
        if (encoding == null) {
            return new InputStreamReader(stream);
        }
        return new InputStreamReader(stream, encoding);
    }

    public static Writer encodedOutputStreamWriter(OutputStream stream, String encoding) throws IOException {
        if (encoding == null) {
            return new OutputStreamWriter(stream);
        }
        return new OutputStreamWriter(stream, encoding);
    }

    public static PrintWriter encodedOutputStreamPrintWriter(OutputStream stream, String encoding, boolean autoFlush) throws IOException {
        if (encoding == null) {
            return new PrintWriter(stream, autoFlush);
        }
        return new PrintWriter((Writer)new OutputStreamWriter(stream, encoding), autoFlush);
    }

    private static void copyFile(File source, File target) throws IOException {
        long bytes;
        FileChannel sourceChannel = new FileInputStream(source).getChannel();
        FileChannel targetChannel = new FileOutputStream(target).getChannel();
        long pos = 0L;
        for (long toCopy = sourceChannel.size(); toCopy > 0L; toCopy -= bytes) {
            bytes = sourceChannel.transferTo(pos, toCopy, targetChannel);
            pos += bytes;
        }
        sourceChannel.close();
        targetChannel.close();
    }

    public static void cp(File source, File target, boolean recursive) throws IOException {
        if (source.isDirectory() && !recursive) {
            throw new IOException("cp: omitting directory: " + source);
        }
        if (!target.getParentFile().exists()) {
            throw new IOException("cp: cannot copy to directory: " + recursive + " (parent doesn't exist)");
        }
        if (!target.getParentFile().isDirectory()) {
            throw new IOException("cp: cannot copy to directory: " + recursive + " (parent isn't a directory)");
        }
        File trueTarget = target.exists() && target.isDirectory() ? new File(target.getPath() + File.separator + source.getName()) : target;
        if (source.isFile()) {
            IOUtils.copyFile(source, trueTarget);
        } else if (source.isDirectory()) {
            File[] children = source.listFiles();
            if (children == null) {
                throw new IOException("cp: could not list files in source: " + source);
            }
            if (target.exists()) {
                if (!target.isDirectory()) {
                    throw new IOException("cp: cannot copy directory into regular file: " + target);
                }
                if (trueTarget.exists() && !trueTarget.isDirectory()) {
                    throw new IOException("cp: overwriting a file with a directory: " + trueTarget);
                }
                if (!trueTarget.exists() && !trueTarget.mkdir()) {
                    throw new IOException("cp: could not create directory: " + trueTarget);
                }
            } else {
                assert (trueTarget == target);
                if (!trueTarget.mkdir()) {
                    throw new IOException("cp: could not create target directory: " + trueTarget);
                }
            }
            for (File child : children) {
                File childTarget = new File(trueTarget.getPath() + File.separator + child.getName());
                IOUtils.cp(child, childTarget, recursive);
            }
        } else {
            throw new IOException("cp: unknown file type: " + source);
        }
    }

    public static void cp(File source, File target) throws IOException {
        IOUtils.cp(source, target, false);
    }

    public static String[] tail(File f, int n, String encoding) throws IOException {
        int i;
        if (n == 0) {
            return new String[0];
        }
        RandomAccessFile raf = new RandomAccessFile(f, "r");
        int linesRead = 0;
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        ArrayList<String> linesReversed = new ArrayList<String>();
        long length = raf.length() - 1L;
        raf.seek(length);
        for (long seek = length; seek >= 0L; --seek) {
            raf.seek(seek);
            byte c = raf.readByte();
            if (c == 10) {
                byte[] str = new byte[bytes.size()];
                for (int i2 = 0; i2 < str.length; ++i2) {
                    str[i2] = (Byte)bytes.get(str.length - i2 - 1);
                }
                linesReversed.add(new String(str, encoding));
                bytes = new ArrayList();
                if (++linesRead != n) continue;
                break;
            }
            bytes.add(c);
        }
        if (linesRead < n && bytes.size() > 0) {
            byte[] str = new byte[bytes.size()];
            for (i = 0; i < str.length; ++i) {
                str[i] = (Byte)bytes.get(str.length - i - 1);
            }
            linesReversed.add(new String(str, encoding));
        }
        String[] rtn = new String[linesReversed.size()];
        for (i = 0; i < rtn.length; ++i) {
            rtn[i] = (String)linesReversed.get(rtn.length - i - 1);
        }
        raf.close();
        return rtn;
    }

    public static String[] tail(File f, int n) throws IOException {
        return IOUtils.tail(f, n, defaultEncoding);
    }

    public static void deleteRecursively(File file) {
        File[] children;
        if (blacklistedPathsToRemove.contains(file.getPath())) {
            throw new IllegalArgumentException("You're trying to delete " + file + "! I _really_ don't think you want to do that...");
        }
        int count = 0;
        long size = 0L;
        for (File f : IOUtils.iterFilesRecursive(file)) {
            ++count;
            size += f.length();
        }
        if (count > 100) {
            throw new IllegalArgumentException("Deleting more than 100 files; you should do this manually");
        }
        if (size > 10000000000L) {
            throw new IllegalArgumentException("Deleting more than 10GB; you should do this manually");
        }
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                IOUtils.deleteRecursively(child);
            }
        }
        file.delete();
    }

    public static void console(Consumer<String> callback) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("> ");
        while ((line = reader.readLine()) != null) {
            switch (line.toLowerCase()) {
                case "exit": 
                case "quit": {
                    return;
                }
            }
            callback.accept(line);
            System.out.print("> ");
        }
    }

    private static final class EolPreservingLineReaderIterable
    implements Iterable<String> {
        private final Reader reader;
        private final int bufferSize;

        private EolPreservingLineReaderIterable(Reader reader) {
            this(reader, 16000);
        }

        private EolPreservingLineReaderIterable(Reader reader, int bufferSize) {
            this.reader = reader;
            this.bufferSize = bufferSize;
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                private String next;
                private boolean done = false;
                private StringBuilder sb = new StringBuilder(80);
                private char[] charBuffer = new char[EolPreservingLineReaderIterable.access$500(this)];
                private int charBufferPos = -1;
                private int charsInBuffer = 0;
                boolean lastWasLF = false;

                private String getNext() {
                    try {
                        boolean eolReached;
                        do {
                            if (this.charBufferPos >= 0) continue;
                            this.charsInBuffer = reader.read(this.charBuffer);
                            if (this.charsInBuffer < 0) {
                                if (this.sb.length() > 0) {
                                    String line = this.sb.toString();
                                    this.sb.setLength(0);
                                    return line;
                                }
                                return null;
                            }
                            this.charBufferPos = 0;
                        } while (!(eolReached = this.copyUntilEol()));
                        String line = this.sb.toString();
                        this.sb.setLength(0);
                        return line;
                    }
                    catch (IOException ex) {
                        throw new RuntimeIOException(ex);
                    }
                }

                private boolean copyUntilEol() {
                    for (int i = this.charBufferPos; i < this.charsInBuffer; ++i) {
                        if (this.charBuffer[i] == '\n') {
                            this.sb.append(this.charBuffer, this.charBufferPos, i - this.charBufferPos + 1);
                            this.charBufferPos = i + 1;
                            this.lastWasLF = false;
                            return true;
                        }
                        if (this.lastWasLF && i > this.charBufferPos) {
                            this.sb.append(this.charBuffer, this.charBufferPos, i - this.charBufferPos);
                            this.charBufferPos = i;
                            this.lastWasLF = false;
                            return true;
                        }
                        this.lastWasLF = this.charBuffer[i] == '\r';
                    }
                    this.sb.append(this.charBuffer, this.charBufferPos, this.charsInBuffer - this.charBufferPos);
                    this.charBufferPos = -1;
                    return false;
                }

                @Override
                public boolean hasNext() {
                    if (this.done) {
                        return false;
                    }
                    if (this.next == null) {
                        this.next = this.getNext();
                    }
                    if (this.next == null) {
                        this.done = true;
                    }
                    return !this.done;
                }

                @Override
                public String next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    String res = this.next;
                    this.next = null;
                    return res;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        static /* synthetic */ int access$500(EolPreservingLineReaderIterable x0) {
            return x0.bufferSize;
        }
    }

    private static final class LineReaderIterable
    implements Iterable<String> {
        private final BufferedReader reader;

        private LineReaderIterable(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                private String next = this.getNext();

                private String getNext() {
                    try {
                        return reader.readLine();
                    }
                    catch (IOException ex) {
                        throw new RuntimeIOException(ex);
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public String next() {
                    String nextLine = this.next;
                    if (nextLine == null) {
                        throw new NoSuchElementException();
                    }
                    this.next = this.getNext();
                    return nextLine;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    static class GetLinesIterable
    implements Iterable<String> {
        final File file;
        final String path;
        final Class<? extends InputStream> fileInputStreamWrapper;
        final String encoding;

        GetLinesIterable(File file, Class<? extends InputStream> fileInputStreamWrapper, String encoding) {
            this.file = file;
            this.path = null;
            this.fileInputStreamWrapper = fileInputStreamWrapper;
            this.encoding = encoding;
        }

        GetLinesIterable(String path, Class<? extends InputStream> fileInputStreamWrapper, String encoding) {
            this.file = null;
            this.path = path;
            this.fileInputStreamWrapper = fileInputStreamWrapper;
            this.encoding = encoding;
        }

        private InputStream getStream() throws IOException {
            if (this.file != null) {
                return new FileInputStream(this.file);
            }
            if (this.path != null) {
                return IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(this.path);
            }
            throw new AssertionError((Object)"No known path to read");
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                protected BufferedReader reader = this.getReader();
                protected String line = this.getLine();

                @Override
                public boolean hasNext() {
                    return this.line != null;
                }

                @Override
                public String next() {
                    String nextLine = this.line;
                    if (nextLine == null) {
                        throw new NoSuchElementException();
                    }
                    this.line = this.getLine();
                    return nextLine;
                }

                protected String getLine() {
                    try {
                        String result = this.reader.readLine();
                        if (result == null) {
                            this.reader.close();
                        }
                        return result;
                    }
                    catch (IOException e) {
                        throw new RuntimeIOException(e);
                    }
                }

                protected BufferedReader getReader() {
                    try {
                        InputStream stream = this.getStream();
                        if (fileInputStreamWrapper != null) {
                            stream = fileInputStreamWrapper.getConstructor(InputStream.class).newInstance(stream);
                        }
                        if (encoding == null) {
                            return new BufferedReader(new InputStreamReader(stream));
                        }
                        return new BufferedReader(new InputStreamReader(stream, encoding));
                    }
                    catch (Exception e) {
                        throw new RuntimeIOException(e);
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

