/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PaddedList;
import edu.stanford.nlp.util.TypesafeMap;
import java.util.List;
import java.util.Locale;

public class IOBUtils {
    private IOBUtils() {
    }

    public static <TOK extends CoreMap> void entitySubclassify(List<TOK> tokens, Class<? extends TypesafeMap.Key<String>> key, String backgroundLabel, String style, boolean intern) {
        CoreMap c;
        int i;
        int how;
        String lowerStyle;
        switch (lowerStyle = style.toLowerCase(Locale.ENGLISH)) {
            case "iob1": {
                how = 0;
                break;
            }
            case "iob2": 
            case "bio": {
                how = 1;
                break;
            }
            case "ioe1": {
                how = 2;
                break;
            }
            case "ioe2": {
                how = 3;
                break;
            }
            case "io": {
                how = 4;
                break;
            }
            case "sbieo": 
            case "iobes": {
                how = 5;
                break;
            }
            case "noprefix": {
                how = 6;
                break;
            }
            case "bilou": {
                how = 7;
                break;
            }
            default: {
                throw new IllegalArgumentException("entitySubclassify: unknown style: " + style);
            }
        }
        PaddedList<CoreLabel> paddedTokens = new PaddedList<CoreLabel>(tokens, new CoreLabel());
        int size = paddedTokens.size();
        String[] newAnswers = new String[size];
        for (i = 0; i < size; ++i) {
            char nPrefix;
            String nBase;
            char pPrefix;
            String pBase;
            char prefix;
            String base;
            String nAns;
            c = (CoreMap)paddedTokens.get(i);
            CoreMap p = (CoreMap)paddedTokens.get(i - 1);
            CoreMap n = (CoreMap)paddedTokens.get(i + 1);
            String cAns = (String)c.get(key);
            String pAns = (String)p.get(key);
            if (pAns == null) {
                pAns = backgroundLabel;
            }
            if ((nAns = (String)n.get(key)) == null) {
                nAns = backgroundLabel;
            }
            if (cAns.length() > 2 && cAns.charAt(1) == '-') {
                base = cAns.substring(2, cAns.length());
                prefix = Character.toUpperCase(cAns.charAt(0));
            } else {
                base = cAns;
                prefix = ' ';
            }
            if (pAns.length() > 2 && pAns.charAt(1) == '-') {
                pBase = pAns.substring(2, pAns.length());
                pPrefix = Character.toUpperCase(pAns.charAt(0));
            } else {
                pBase = pAns;
                pPrefix = ' ';
            }
            if (nAns.length() > 2 && nAns.charAt(1) == '-') {
                nBase = nAns.substring(2, nAns.length());
                nPrefix = Character.toUpperCase(nAns.charAt(0));
            } else {
                nBase = nAns;
                nPrefix = ' ';
            }
            boolean isStartAdjacentSame = IOBUtils.isSameEntityBoundary(pBase, pPrefix, base, prefix);
            boolean isEndAdjacentSame = IOBUtils.isSameEntityBoundary(base, prefix, nBase, nPrefix);
            boolean isFirst = IOBUtils.isDifferentEntityBoundary(pBase, base) || isStartAdjacentSame;
            boolean isLast = IOBUtils.isDifferentEntityBoundary(base, nBase) || isEndAdjacentSame;
            String newAnswer = base;
            if (!base.equals(backgroundLabel)) {
                switch (how) {
                    case 0: {
                        if (isStartAdjacentSame) {
                            newAnswer = "B-" + base;
                            break;
                        }
                        newAnswer = "I-" + base;
                        break;
                    }
                    case 1: {
                        if (isFirst) {
                            newAnswer = "B-" + base;
                            break;
                        }
                        newAnswer = "I-" + base;
                        break;
                    }
                    case 2: {
                        if (isEndAdjacentSame) {
                            newAnswer = "E-" + base;
                            break;
                        }
                        newAnswer = "I-" + base;
                        break;
                    }
                    case 3: {
                        if (isLast) {
                            newAnswer = "E-" + base;
                            break;
                        }
                        newAnswer = "I-" + base;
                        break;
                    }
                    case 4: {
                        newAnswer = "I-" + base;
                        break;
                    }
                    case 5: {
                        if (isFirst && isLast) {
                            newAnswer = "S-" + base;
                            break;
                        }
                        if (!isFirst && isLast) {
                            newAnswer = "E-" + base;
                            break;
                        }
                        if (isFirst && !isLast) {
                            newAnswer = "B-" + base;
                            break;
                        }
                        newAnswer = "I-" + base;
                        break;
                    }
                    case 7: {
                        newAnswer = isFirst && isLast ? "U-" + base : (!isFirst && isLast ? "L-" + base : (isFirst && !isLast ? "B-" + base : "I-" + base));
                    }
                }
            }
            if (intern) {
                newAnswer = newAnswer.intern();
            }
            newAnswers[i] = newAnswer;
        }
        for (i = 0; i < size; ++i) {
            c = (CoreMap)tokens.get(i);
            c.set(CoreAnnotations.AnswerAnnotation.class, newAnswers[i]);
        }
    }

    public static boolean isEntityBoundary(String beforeEntity, char beforePrefix, String afterEntity, char afterPrefix) {
        return !beforeEntity.equals(afterEntity) || afterPrefix == 'B' || afterPrefix == 'S' || afterPrefix == 'U' || beforePrefix == 'E' || beforePrefix == 'L' || beforePrefix == 'S' || beforePrefix == 'U';
    }

    public static boolean isSameEntityBoundary(String beforeEntity, char beforePrefix, String afterEntity, char afterPrefix) {
        return beforeEntity.equals(afterEntity) && (afterPrefix == 'B' || afterPrefix == 'S' || afterPrefix == 'U' || beforePrefix == 'E' || beforePrefix == 'L' || beforePrefix == 'S' || beforePrefix == 'U');
    }

    public static boolean isDifferentEntityBoundary(String beforeEntity, String afterEntity) {
        return !beforeEntity.equals(afterEntity);
    }

    public static boolean countEntityResults(List<? extends CoreMap> doc, Counter<String> entityTP, Counter<String> entityFP, Counter<String> entityFN, String background) {
        boolean entityCorrect = true;
        String previousGold = background;
        String previousGuess = background;
        String previousGoldEntity = "";
        String previousGuessEntity = "";
        char previousGoldPrefix = ' ';
        char previousGuessPrefix = ' ';
        for (CoreMap coreMap : doc) {
            boolean guessEnded;
            char guessPrefix;
            String guessEntity;
            char goldPrefix;
            String goldEntity;
            String gold = (String)coreMap.get(CoreAnnotations.GoldAnswerAnnotation.class);
            String guess = (String)coreMap.get(CoreAnnotations.AnswerAnnotation.class);
            if (gold == null || gold.isEmpty()) {
                System.err.println("Missing gold entity");
                return false;
            }
            if (gold.length() > 2 && gold.charAt(1) == '-') {
                goldEntity = gold.substring(2, gold.length());
                goldPrefix = Character.toUpperCase(gold.charAt(0));
            } else {
                goldEntity = gold;
                goldPrefix = ' ';
            }
            if (guess == null || guess.isEmpty()) {
                System.err.println("Missing guess entity");
                return false;
            }
            if (guess.length() > 2 && guess.charAt(1) == '-') {
                guessEntity = guess.substring(2, guess.length());
                guessPrefix = Character.toUpperCase(guess.charAt(0));
            } else {
                guessEntity = guess;
                guessPrefix = ' ';
            }
            boolean newGold = !gold.equals(background) && IOBUtils.isEntityBoundary(previousGoldEntity, previousGoldPrefix, goldEntity, goldPrefix);
            boolean newGuess = !guess.equals(background) && IOBUtils.isEntityBoundary(previousGuessEntity, previousGuessPrefix, guessEntity, guessPrefix);
            boolean goldEnded = !previousGold.equals(background) && IOBUtils.isEntityBoundary(previousGoldEntity, previousGoldPrefix, goldEntity, goldPrefix);
            boolean bl = guessEnded = !previousGuess.equals(background) && IOBUtils.isEntityBoundary(previousGuessEntity, previousGuessPrefix, guessEntity, guessPrefix);
            if (goldEnded) {
                if (guessEnded) {
                    if (entityCorrect) {
                        entityTP.incrementCount(previousGoldEntity);
                    } else {
                        entityFN.incrementCount(previousGoldEntity);
                        entityFP.incrementCount(previousGuessEntity);
                    }
                    entityCorrect = goldEntity.equals(guessEntity);
                } else {
                    entityFN.incrementCount(previousGoldEntity);
                    entityCorrect = gold.equals(background) && guess.equals(background);
                }
            } else if (guessEnded) {
                entityCorrect = false;
                entityFP.incrementCount(previousGuessEntity);
            }
            if (newGold) {
                entityCorrect = newGuess ? guessEntity.equals(goldEntity) : false;
            } else if (newGuess) {
                entityCorrect = false;
            }
            previousGold = gold;
            previousGuess = guess;
            previousGoldEntity = goldEntity;
            previousGuessEntity = guessEntity;
            previousGoldPrefix = goldPrefix;
            previousGuessPrefix = guessPrefix;
        }
        if (!previousGold.equals(background)) {
            if (entityCorrect) {
                entityTP.incrementCount(previousGoldEntity);
            } else {
                entityFN.incrementCount(previousGoldEntity);
            }
        }
        if (!previousGuess.equals(background) && !entityCorrect) {
            entityFP.incrementCount(previousGuessEntity);
        }
        return true;
    }

    public static void main(String[] args) {
        if (args.length != 0) {
            for (String arg : args) {
            }
        }
    }
}

