import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.CoreMatchers.nullValue;
import static org.junit.Assert.assertThat;

import org.junit.Test;
import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.context.JavaConfigApplicationContext;


public class SimpleTest {
	
	public @Test void testBasicJavaConfigScenario() {
		JavaConfigApplicationContext ctx = new JavaConfigApplicationContext(Config.class);
		Service service = ctx.getBean(Service.class);
		assertThat(service, not(nullValue()));
		assertThat(service.getName(), equalTo("svc1"));
	}
	
	@Configuration
	static class Config {
		public @Bean Service exampleService() {
			return new Service("svc1");
		}
	}
	
	
	static class Service {
		private final String name;

		public Service(String name) {
			this.name = name;
		}
		
		public String getName() { return name; }
	}
}
