/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.shell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import jline.console.ConsoleReader;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.CandidateListCompletionHandler;
import jline.console.completer.Completer;
import jline.console.completer.CompletionHandler;
import org.fusesource.jansi.AnsiRenderer;
import org.springframework.boot.cli.command.Command;
import org.springframework.boot.cli.command.CommandFactory;
import org.springframework.boot.cli.command.CommandRunner;
import org.springframework.boot.cli.command.core.HelpCommand;
import org.springframework.boot.cli.command.core.VersionCommand;
import org.springframework.boot.cli.command.shell.AnsiString;
import org.springframework.boot.cli.command.shell.ClearCommand;
import org.springframework.boot.cli.command.shell.CommandCompleter;
import org.springframework.boot.cli.command.shell.EscapeAwareWhiteSpaceArgumentDelimiter;
import org.springframework.boot.cli.command.shell.ExitCommand;
import org.springframework.boot.cli.command.shell.ForkProcessCommand;
import org.springframework.boot.cli.command.shell.PromptCommand;
import org.springframework.boot.cli.command.shell.Shell;
import org.springframework.boot.cli.command.shell.ShellExitException;
import org.springframework.boot.cli.command.shell.ShellPrompts;
import org.springframework.boot.loader.tools.SignalUtils;
import org.springframework.util.StringUtils;

public class Shell {
    private static final Set<Class<?>> NON_FORKED_COMMANDS;
    private final ShellCommandRunner commandRunner;
    private final ConsoleReader consoleReader;
    private final EscapeAwareWhiteSpaceArgumentDelimiter argumentDelimiter = new EscapeAwareWhiteSpaceArgumentDelimiter();
    private final ShellPrompts prompts = new ShellPrompts();

    Shell() throws IOException {
        this.attachSignalHandler();
        this.consoleReader = new ConsoleReader();
        this.commandRunner = this.createCommandRunner();
        this.initializeConsoleReader();
    }

    private ShellCommandRunner createCommandRunner() {
        ShellCommandRunner runner = new ShellCommandRunner(this);
        runner.addCommand((Command)new HelpCommand((CommandRunner)runner));
        runner.addCommands(this.getCommands());
        runner.addAliases("exit", new String[]{"quit"});
        runner.addAliases("help", new String[]{"?"});
        runner.addAliases("clear", new String[]{"cls"});
        return runner;
    }

    private Iterable<Command> getCommands() {
        ArrayList<Command> commands = new ArrayList<Command>();
        ServiceLoader<CommandFactory> factories = ServiceLoader.load(CommandFactory.class, this.getClass().getClassLoader());
        for (CommandFactory factory : factories) {
            for (Command command : factory.getCommands()) {
                commands.add(this.convertToForkCommand(command));
            }
        }
        commands.add((Command)new PromptCommand(this.prompts));
        commands.add((Command)new ClearCommand(this.consoleReader));
        commands.add((Command)new ExitCommand());
        return commands;
    }

    private Command convertToForkCommand(Command command) {
        for (Class nonForked : NON_FORKED_COMMANDS) {
            if (!nonForked.isInstance(command)) continue;
            return command;
        }
        return new ForkProcessCommand(command);
    }

    private void initializeConsoleReader() {
        this.consoleReader.setHistoryEnabled(true);
        this.consoleReader.setBellEnabled(false);
        this.consoleReader.setExpandEvents(false);
        this.consoleReader.addCompleter((Completer)new CommandCompleter(this.consoleReader, (ArgumentCompleter.ArgumentDelimiter)this.argumentDelimiter, (Iterable)this.commandRunner));
        this.consoleReader.setCompletionHandler((CompletionHandler)new CandidateListCompletionHandler());
    }

    private void attachSignalHandler() {
        SignalUtils.attachSignalHandler(() -> this.handleSigInt());
    }

    public void run() throws Exception {
        block2: {
            this.printBanner();
            try {
                this.runInputLoop();
            }
            catch (Exception ex) {
                if (ex instanceof ShellExitException) break block2;
                throw ex;
            }
        }
    }

    private void printBanner() {
        String version = this.getClass().getPackage().getImplementationVersion();
        version = version == null ? "" : " (v" + version + ")";
        System.out.println(this.ansi("Spring Boot", new AnsiRenderer.Code[]{AnsiRenderer.Code.BOLD}).append(version, new AnsiRenderer.Code[]{AnsiRenderer.Code.FAINT}));
        System.out.println(this.ansi("Hit TAB to complete. Type 'help' and hit RETURN for help, and 'exit' to quit.", new AnsiRenderer.Code[0]));
    }

    private void runInputLoop() throws Exception {
        String line;
        while ((line = this.consoleReader.readLine(this.getPrompt())) != null) {
            while (line.endsWith("\\")) {
                line = line.substring(0, line.length() - 1);
                line = line + this.consoleReader.readLine("> ");
            }
            if (!StringUtils.hasLength((String)line)) continue;
            String[] args = this.argumentDelimiter.parseArguments(line);
            this.commandRunner.runAndHandleErrors(args);
        }
    }

    private String getPrompt() {
        String prompt = this.prompts.getPrompt();
        return this.ansi(prompt, new AnsiRenderer.Code[]{AnsiRenderer.Code.FG_BLUE}).toString();
    }

    private AnsiString ansi(String text, AnsiRenderer.Code ... codes) {
        return new AnsiString(this.consoleReader.getTerminal()).append(text, codes);
    }

    protected void handleSigInt() {
        if (this.commandRunner.handleSigInt()) {
            return;
        }
        System.out.println(String.format("%nThanks for using Spring Boot", new Object[0]));
        System.exit(1);
    }

    static {
        HashSet<Class<VersionCommand>> nonForked = new HashSet<Class<VersionCommand>>();
        nonForked.add(VersionCommand.class);
        NON_FORKED_COMMANDS = Collections.unmodifiableSet(nonForked);
    }
}

