/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.run;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import org.springframework.boot.cli.command.run.SpringApplicationRunner;
import org.springframework.boot.cli.command.run.SpringApplicationRunnerConfiguration;
import org.springframework.boot.cli.compiler.GroovyCompiler;
import org.springframework.boot.cli.compiler.GroovyCompilerConfiguration;

public class SpringApplicationRunner {
    private static int watcherCounter = 0;
    private static int runnerCounter = 0;
    private final Object monitor = new Object();
    private final SpringApplicationRunnerConfiguration configuration;
    private final String[] sources;
    private final String[] args;
    private final GroovyCompiler compiler;
    private RunThread runThread;
    private FileWatchThread fileWatchThread;

    SpringApplicationRunner(SpringApplicationRunnerConfiguration configuration, String[] sources, String ... args) {
        this.configuration = configuration;
        this.sources = (String[])sources.clone();
        this.args = (String[])args.clone();
        this.compiler = new GroovyCompiler((GroovyCompilerConfiguration)configuration);
        int level = configuration.getLogLevel().intValue();
        if (level <= Level.FINER.intValue()) {
            System.setProperty("groovy.grape.report.downloads", "true");
            System.setProperty("trace", "true");
        } else if (level <= Level.FINE.intValue()) {
            System.setProperty("debug", "true");
        } else if (level == Level.OFF.intValue()) {
            System.setProperty("spring.main.banner-mode", "OFF");
            System.setProperty("logging.level.ROOT", "OFF");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileAndRun() throws Exception {
        Object object = this.monitor;
        synchronized (object) {
            try {
                this.stop();
                Object[] compiledSources = this.compile();
                this.monitorForChanges();
                this.runThread = new RunThread(this, compiledSources);
                this.runThread.start();
                this.runThread.join();
            }
            catch (Exception ex) {
                if (this.fileWatchThread == null) {
                    throw ex;
                }
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.runThread != null) {
                this.runThread.shutdown();
                this.runThread = null;
            }
        }
    }

    private Object[] compile() throws IOException {
        Object[] compiledSources = this.compiler.compile(this.sources);
        if (compiledSources.length == 0) {
            throw new RuntimeException("No classes found in '" + Arrays.toString(this.sources) + "'");
        }
        return compiledSources;
    }

    private void monitorForChanges() {
        if (this.fileWatchThread == null && this.configuration.isWatchForFileChanges()) {
            this.fileWatchThread = new FileWatchThread(this);
            this.fileWatchThread.start();
        }
    }

    static /* synthetic */ int access$008() {
        return runnerCounter++;
    }

    static /* synthetic */ String[] access$100(SpringApplicationRunner x0) {
        return x0.args;
    }

    static /* synthetic */ int access$208() {
        return watcherCounter++;
    }

    static /* synthetic */ String[] access$300(SpringApplicationRunner x0) {
        return x0.sources;
    }

    static /* synthetic */ GroovyCompiler access$400(SpringApplicationRunner x0) {
        return x0.compiler;
    }
}

