/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.init;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.springframework.boot.cli.command.HelpExample;
import org.springframework.boot.cli.command.OptionParsingCommand;
import org.springframework.boot.cli.command.init.InitializrService;
import org.springframework.boot.cli.command.init.ProjectGenerationRequest;
import org.springframework.boot.cli.command.init.ProjectGenerator;
import org.springframework.boot.cli.command.init.ReportableException;
import org.springframework.boot.cli.command.init.ServiceCapabilitiesReportGenerator;
import org.springframework.boot.cli.command.options.OptionHandler;
import org.springframework.boot.cli.command.status.ExitStatus;
import org.springframework.boot.cli.util.Log;
import org.springframework.util.Assert;

public class InitCommand
extends OptionParsingCommand {
    public InitCommand() {
        this(new InitOptionHandler(new InitializrService()));
    }

    public InitCommand(InitOptionHandler handler) {
        super("init", "Initialize a new project using Spring Initialzr (start.spring.io)", handler);
    }

    @Override
    public String getUsageHelp() {
        return "[options] [location]";
    }

    @Override
    public Collection<HelpExample> getExamples() {
        ArrayList<HelpExample> examples = new ArrayList<HelpExample>();
        examples.add(new HelpExample("To list all the capabilities of the service", "spring init --list"));
        examples.add(new HelpExample("To creates a default project", "spring init"));
        examples.add(new HelpExample("To create a web my-app.zip", "spring init -d=web my-app.zip"));
        examples.add(new HelpExample("To create a web/data-jpa gradle project unpacked", "spring init -d=web,jpa --build=gradle my-dir/"));
        return examples;
    }

    static class InitOptionHandler
    extends OptionHandler {
        private final ServiceCapabilitiesReportGenerator serviceCapabilitiesReport;
        private final ProjectGenerator projectGenerator;
        private OptionSpec<String> target;
        private OptionSpec<Void> listCapabilities;
        private OptionSpec<String> bootVersion;
        private OptionSpec<String> dependencies;
        private OptionSpec<String> javaVersion;
        private OptionSpec<String> packaging;
        private OptionSpec<String> build;
        private OptionSpec<String> format;
        private OptionSpec<String> type;
        private OptionSpec<Void> extract;
        private OptionSpec<Void> force;

        InitOptionHandler(InitializrService initializrService) {
            this.serviceCapabilitiesReport = new ServiceCapabilitiesReportGenerator(initializrService);
            this.projectGenerator = new ProjectGenerator(initializrService);
        }

        @Override
        protected void options() {
            this.target = this.option(Arrays.asList("target"), "URL of the service to use").withRequiredArg().defaultsTo((Object)"https://start.spring.io", (Object[])new String[0]);
            this.listCapabilities = this.option(Arrays.asList("list", "l"), "List the capabilities of the service. Use it to discover the dependencies and the types that are available");
            this.projectGenerationOptions();
            this.otherOptions();
        }

        private void projectGenerationOptions() {
            this.bootVersion = this.option(Arrays.asList("boot-version", "b"), "Spring Boot version to use (for example '1.2.0.RELEASE')").withRequiredArg();
            this.dependencies = this.option(Arrays.asList("dependencies", "d"), "Comma separated list of dependencies to include in the generated project").withRequiredArg();
            this.javaVersion = this.option(Arrays.asList("java-version", "j"), "Java version to use (for example '1.8')").withRequiredArg();
            this.packaging = this.option(Arrays.asList("packaging", "p"), "Packaging type to use (for example 'jar')").withRequiredArg();
            this.build = this.option("build", "The build system to use (for example 'maven' or 'gradle')").withRequiredArg().defaultsTo((Object)"maven", (Object[])new String[0]);
            this.format = this.option("format", "The format of the generated content (for example 'build' for a build file, 'project' for a project archive)").withRequiredArg().defaultsTo((Object)"project", (Object[])new String[0]);
            this.type = this.option(Arrays.asList("type", "t"), "The project type to use. Not normally needed if you use --build and/or --format. Check the capabilities of the service (--list) for more details").withRequiredArg();
        }

        private void otherOptions() {
            this.extract = this.option(Arrays.asList("extract", "x"), "Extract the project archive. Inferred if a location is specified and ends with /");
            this.force = this.option(Arrays.asList("force", "f"), "Force overwrite of existing files");
        }

        @Override
        protected ExitStatus run(OptionSet options) throws Exception {
            try {
                if (options.has(this.listCapabilities)) {
                    this.generateReport(options);
                } else {
                    this.generateProject(options);
                }
                return ExitStatus.OK;
            }
            catch (ReportableException ex) {
                Log.error(ex.getMessage());
                return ExitStatus.ERROR;
            }
            catch (Exception ex) {
                Log.error(ex);
                return ExitStatus.ERROR;
            }
        }

        private void generateReport(OptionSet options) throws IOException {
            Log.info(this.serviceCapabilitiesReport.generate((String)options.valueOf(this.target)));
        }

        protected void generateProject(OptionSet options) throws IOException {
            ProjectGenerationRequest request = this.createProjectGenerationRequest(options);
            this.projectGenerator.generateProject(request, options.has(this.force));
        }

        protected ProjectGenerationRequest createProjectGenerationRequest(OptionSet options) {
            ArrayList nonOptionArguments = new ArrayList(options.nonOptionArguments());
            Assert.isTrue((nonOptionArguments.size() <= 1 ? 1 : 0) != 0, (String)"Only the target location may be specified");
            ProjectGenerationRequest request = new ProjectGenerationRequest();
            request.setServiceUrl((String)options.valueOf(this.target));
            if (options.has(this.bootVersion)) {
                request.setBootVersion((String)options.valueOf(this.bootVersion));
            }
            if (options.has(this.dependencies)) {
                for (String dep : ((String)options.valueOf(this.dependencies)).split(",")) {
                    request.getDependencies().add(dep.trim());
                }
            }
            if (options.has(this.javaVersion)) {
                request.setJavaVersion((String)options.valueOf(this.javaVersion));
            }
            if (options.has(this.packaging)) {
                request.setPackaging((String)options.valueOf(this.packaging));
            }
            request.setBuild((String)options.valueOf(this.build));
            request.setFormat((String)options.valueOf(this.format));
            request.setDetectType(options.has(this.build) || options.has(this.format));
            if (options.has(this.type)) {
                request.setType((String)options.valueOf(this.type));
            }
            request.setExtract(options.has(this.extract));
            if (nonOptionArguments.size() == 1) {
                String output = (String)nonOptionArguments.get(0);
                request.setOutput(output);
            }
            return request;
        }
    }
}

