// A Bison parser, made by GNU Bison 3.0.2.

// Skeleton implementation for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2013 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.

// Take the name prefix into account.
#define yylex   tlyylex

// First part of user declarations.

#line 39 "parsetl.cc" // lalr1.cc:399

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

#include "parsetl.hh"

// User implementation prologue.

#line 53 "parsetl.cc" // lalr1.cc:407
// Unqualified %code blocks.
#line 55 "parsetl.yy" // lalr1.cc:408

/* parsetl.hh and parsedecl.hh include each other recursively.
   We mut ensure that YYSTYPE is declared (by the above %union)
   before parsedecl.hh uses it. */
#include <spot/parsetl/parsedecl.hh>
using namespace spot;

#define missing_right_op_msg(op, str)		\
  error_list.emplace_back(op,			\
    "missing right operand for \"" str "\"");

#define missing_right_op(res, op, str)		\
  do						\
    {						\
      missing_right_op_msg(op, str);		\
      res = fnode::ff();		\
    }						\
  while (0);

// right is missing, so complain and use left.
#define missing_right_binop(res, left, op, str)	\
  do						\
    {						\
      missing_right_op_msg(op, str);		\
      res = left;				\
    }						\
  while (0);

// right is missing, so complain and use false.
#define missing_right_binop_hard(res, left, op, str)	\
  do							\
    {							\
      left->destroy();					\
      missing_right_op(res, op, str);			\
    }							\
  while (0);

  enum parser_type { parser_ltl, parser_bool, parser_sere };

  static formula
  try_recursive_parse(const std::string& str,
		      const spot::location& location,
		      spot::environment& env,
		      bool debug,
		      parser_type type,
		      spot::parse_error_list& error_list)
    {
      // We want to parse a U (b U c) as two until operators applied
      // to the atomic propositions a, b, and c.  We also want to
      // parse a U (b == c) as one until operator applied to the
      // atomic propositions "a" and "b == c".  The only problem is
      // that we do not know anything about "==" or in general about
      // the syntax of atomic proposition of our users.
      //
      // To support that, the lexer will return "b U c" and "b == c"
      // as PAR_BLOCK tokens.  We then try to parse such tokens
      // recursively.  If, as in the case of "b U c", the block is
      // successfully parsed as a formula, we return this formula.
      // Otherwise, we convert the string into an atomic proposition
      // (it's up to the environment to check the syntax of this
      // proposition, and maybe reject it).

      if (str.empty())
	{
	  error_list.emplace_back(location, "unexpected empty block");
	  return nullptr;
	}

      spot::parsed_formula pf;
      switch (type)
	{
	case parser_sere:
	  pf = spot::parse_infix_sere(str, env, debug, true);
	  break;
	case parser_bool:
	  pf = spot::parse_infix_boolean(str, env, debug, true);
	  break;
	case parser_ltl:
	  pf = spot::parse_infix_psl(str, env, debug, true);
	  break;
	}

      if (pf.errors.empty())
	return pf.f;

      auto f = env.require(str);
      if (!f)
	{
	  std::string s = "atomic proposition `";
	  s += str;
	  s += "' rejected by environment `";
	  s += env.name();
	  s += "'";
	  error_list.emplace_back(location, s);
	}
      return f;
    }

#line 154 "parsetl.cc" // lalr1.cc:408


#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> // FIXME: INFRINGES ON USER NAME SPACE.
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K].location)
/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

# ifndef YYLLOC_DEFAULT
#  define YYLLOC_DEFAULT(Current, Rhs, N)                               \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).begin  = YYRHSLOC (Rhs, 1).begin;                   \
          (Current).end    = YYRHSLOC (Rhs, N).end;                     \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).begin = (Current).end = YYRHSLOC (Rhs, 0).end;      \
        }                                                               \
    while (/*CONSTCOND*/ false)
# endif


// Suppress unused-variable warnings by "using" E.
#define YYUSE(E) ((void) (E))

// Enable debugging if requested.
#if YYDEBUG

// A pseudo ostream that takes yydebug_ into account.
# define YYCDEBUG if (yydebug_) (*yycdebug_)

# define YY_SYMBOL_PRINT(Title, Symbol)         \
  do {                                          \
    if (yydebug_)                               \
    {                                           \
      *yycdebug_ << Title << ' ';               \
      yy_print_ (*yycdebug_, Symbol);           \
      *yycdebug_ << std::endl;                  \
    }                                           \
  } while (false)

# define YY_REDUCE_PRINT(Rule)          \
  do {                                  \
    if (yydebug_)                       \
      yy_reduce_print_ (Rule);          \
  } while (false)

# define YY_STACK_PRINT()               \
  do {                                  \
    if (yydebug_)                       \
      yystack_print_ ();                \
  } while (false)

#else // !YYDEBUG

# define YYCDEBUG if (false) std::cerr
# define YY_SYMBOL_PRINT(Title, Symbol)  YYUSE(Symbol)
# define YY_REDUCE_PRINT(Rule)           static_cast<void>(0)
# define YY_STACK_PRINT()                static_cast<void>(0)

#endif // !YYDEBUG

#define yyerrok         (yyerrstatus_ = 0)
#define yyclearin       (yyempty = true)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYRECOVERING()  (!!yyerrstatus_)


namespace tlyy {
#line 240 "parsetl.cc" // lalr1.cc:474

  /* Return YYSTR after stripping away unnecessary quotes and
     backslashes, so that it's suitable for yyerror.  The heuristic is
     that double-quoting is unnecessary unless the string contains an
     apostrophe, a comma, or backslash (other than backslash-backslash).
     YYSTR is taken from yytname.  */
  std::string
  parser::yytnamerr_ (const char *yystr)
  {
    if (*yystr == '"')
      {
        std::string yyr = "";
        char const *yyp = yystr;

        for (;;)
          switch (*++yyp)
            {
            case '\'':
            case ',':
              goto do_not_strip_quotes;

            case '\\':
              if (*++yyp != '\\')
                goto do_not_strip_quotes;
              // Fall through.
            default:
              yyr += *yyp;
              break;

            case '"':
              return yyr;
            }
      do_not_strip_quotes: ;
      }

    return yystr;
  }


  /// Build a parser object.
  parser::parser (spot::parse_error_list &error_list_yyarg, spot::environment &parse_environment_yyarg, spot::formula &result_yyarg)
    :
#if YYDEBUG
      yydebug_ (false),
      yycdebug_ (&std::cerr),
#endif
      error_list (error_list_yyarg),
      parse_environment (parse_environment_yyarg),
      result (result_yyarg)
  {}

  parser::~parser ()
  {}


  /*---------------.
  | Symbol types.  |
  `---------------*/

  inline
  parser::syntax_error::syntax_error (const location_type& l, const std::string& m)
    : std::runtime_error (m)
    , location (l)
  {}

  // basic_symbol.
  template <typename Base>
  inline
  parser::basic_symbol<Base>::basic_symbol ()
    : value ()
  {}

  template <typename Base>
  inline
  parser::basic_symbol<Base>::basic_symbol (const basic_symbol& other)
    : Base (other)
    , value ()
    , location (other.location)
  {
    value = other.value;
  }


  template <typename Base>
  inline
  parser::basic_symbol<Base>::basic_symbol (typename Base::kind_type t, const semantic_type& v, const location_type& l)
    : Base (t)
    , value (v)
    , location (l)
  {}


  /// Constructor for valueless symbols.
  template <typename Base>
  inline
  parser::basic_symbol<Base>::basic_symbol (typename Base::kind_type t, const location_type& l)
    : Base (t)
    , value ()
    , location (l)
  {}

  template <typename Base>
  inline
  parser::basic_symbol<Base>::~basic_symbol ()
  {
  }

  template <typename Base>
  inline
  void
  parser::basic_symbol<Base>::move (basic_symbol& s)
  {
    super_type::move(s);
    value = s.value;
    location = s.location;
  }

  // by_type.
  inline
  parser::by_type::by_type ()
     : type (empty)
  {}

  inline
  parser::by_type::by_type (const by_type& other)
    : type (other.type)
  {}

  inline
  parser::by_type::by_type (token_type t)
    : type (yytranslate_ (t))
  {}

  inline
  void
  parser::by_type::move (by_type& that)
  {
    type = that.type;
    that.type = empty;
  }

  inline
  int
  parser::by_type::type_get () const
  {
    return type;
  }


  // by_state.
  inline
  parser::by_state::by_state ()
    : state (empty)
  {}

  inline
  parser::by_state::by_state (const by_state& other)
    : state (other.state)
  {}

  inline
  void
  parser::by_state::move (by_state& that)
  {
    state = that.state;
    that.state = empty;
  }

  inline
  parser::by_state::by_state (state_type s)
    : state (s)
  {}

  inline
  parser::symbol_number_type
  parser::by_state::type_get () const
  {
    return state == empty ? 0 : yystos_[state];
  }

  inline
  parser::stack_symbol_type::stack_symbol_type ()
  {}


  inline
  parser::stack_symbol_type::stack_symbol_type (state_type s, symbol_type& that)
    : super_type (s, that.location)
  {
    value = that.value;
    // that is emptied.
    that.type = empty;
  }

  inline
  parser::stack_symbol_type&
  parser::stack_symbol_type::operator= (const stack_symbol_type& that)
  {
    state = that.state;
    value = that.value;
    location = that.location;
    return *this;
  }


  template <typename Base>
  inline
  void
  parser::yy_destroy_ (const char* yymsg, basic_symbol<Base>& yysym) const
  {
    if (yymsg)
      YY_SYMBOL_PRINT (yymsg, yysym);

    // User destructor.
    switch (yysym.type_get ())
    {
            case 9: // "(...) block"

#line 235 "parsetl.yy" // lalr1.cc:599
        { delete (yysym.value.str); }
#line 461 "parsetl.cc" // lalr1.cc:599
        break;

      case 10: // "{...} block"

#line 235 "parsetl.yy" // lalr1.cc:599
        { delete (yysym.value.str); }
#line 468 "parsetl.cc" // lalr1.cc:599
        break;

      case 11: // "{...}! block"

#line 235 "parsetl.yy" // lalr1.cc:599
        { delete (yysym.value.str); }
#line 475 "parsetl.cc" // lalr1.cc:599
        break;

      case 46: // "atomic proposition"

#line 235 "parsetl.yy" // lalr1.cc:599
        { delete (yysym.value.str); }
#line 482 "parsetl.cc" // lalr1.cc:599
        break;

      case 83: // booleanatom

#line 236 "parsetl.yy" // lalr1.cc:599
        { (yysym.value.ltl)->destroy(); }
#line 489 "parsetl.cc" // lalr1.cc:599
        break;

      case 84: // sere

#line 236 "parsetl.yy" // lalr1.cc:599
        { (yysym.value.ltl)->destroy(); }
#line 496 "parsetl.cc" // lalr1.cc:599
        break;

      case 85: // bracedsere

#line 236 "parsetl.yy" // lalr1.cc:599
        { (yysym.value.ltl)->destroy(); }
#line 503 "parsetl.cc" // lalr1.cc:599
        break;

      case 86: // parenthesedsubformula

#line 236 "parsetl.yy" // lalr1.cc:599
        { (yysym.value.ltl)->destroy(); }
#line 510 "parsetl.cc" // lalr1.cc:599
        break;

      case 87: // boolformula

#line 236 "parsetl.yy" // lalr1.cc:599
        { (yysym.value.ltl)->destroy(); }
#line 517 "parsetl.cc" // lalr1.cc:599
        break;

      case 88: // subformula

#line 236 "parsetl.yy" // lalr1.cc:599
        { (yysym.value.ltl)->destroy(); }
#line 524 "parsetl.cc" // lalr1.cc:599
        break;

      case 89: // lbtformula

#line 236 "parsetl.yy" // lalr1.cc:599
        { (yysym.value.ltl)->destroy(); }
#line 531 "parsetl.cc" // lalr1.cc:599
        break;


      default:
        break;
    }
  }

#if YYDEBUG
  template <typename Base>
  void
  parser::yy_print_ (std::ostream& yyo,
                                     const basic_symbol<Base>& yysym) const
  {
    std::ostream& yyoutput = yyo;
    YYUSE (yyoutput);
    symbol_number_type yytype = yysym.type_get ();
    yyo << (yytype < yyntokens_ ? "token" : "nterm")
        << ' ' << yytname_[yytype] << " ("
        << yysym.location << ": ";
    switch (yytype)
    {
            case 9: // "(...) block"

#line 238 "parsetl.yy" // lalr1.cc:617
        { debug_stream() << *(yysym.value.str); }
#line 558 "parsetl.cc" // lalr1.cc:617
        break;

      case 10: // "{...} block"

#line 238 "parsetl.yy" // lalr1.cc:617
        { debug_stream() << *(yysym.value.str); }
#line 565 "parsetl.cc" // lalr1.cc:617
        break;

      case 11: // "{...}! block"

#line 238 "parsetl.yy" // lalr1.cc:617
        { debug_stream() << *(yysym.value.str); }
#line 572 "parsetl.cc" // lalr1.cc:617
        break;

      case 39: // "number for square bracket operator"

#line 241 "parsetl.yy" // lalr1.cc:617
        { debug_stream() << (yysym.value.num); }
#line 579 "parsetl.cc" // lalr1.cc:617
        break;

      case 46: // "atomic proposition"

#line 238 "parsetl.yy" // lalr1.cc:617
        { debug_stream() << *(yysym.value.str); }
#line 586 "parsetl.cc" // lalr1.cc:617
        break;

      case 77: // sqbracketargs

#line 242 "parsetl.yy" // lalr1.cc:617
        { debug_stream() << (yysym.value.minmax).min << ".." << (yysym.value.minmax).max; }
#line 593 "parsetl.cc" // lalr1.cc:617
        break;

      case 78: // gotoargs

#line 242 "parsetl.yy" // lalr1.cc:617
        { debug_stream() << (yysym.value.minmax).min << ".." << (yysym.value.minmax).max; }
#line 600 "parsetl.cc" // lalr1.cc:617
        break;

      case 80: // starargs

#line 242 "parsetl.yy" // lalr1.cc:617
        { debug_stream() << (yysym.value.minmax).min << ".." << (yysym.value.minmax).max; }
#line 607 "parsetl.cc" // lalr1.cc:617
        break;

      case 81: // fstarargs

#line 242 "parsetl.yy" // lalr1.cc:617
        { debug_stream() << (yysym.value.minmax).min << ".." << (yysym.value.minmax).max; }
#line 614 "parsetl.cc" // lalr1.cc:617
        break;

      case 82: // equalargs

#line 242 "parsetl.yy" // lalr1.cc:617
        { debug_stream() << (yysym.value.minmax).min << ".." << (yysym.value.minmax).max; }
#line 621 "parsetl.cc" // lalr1.cc:617
        break;

      case 83: // booleanatom

#line 239 "parsetl.yy" // lalr1.cc:617
        { print_psl(debug_stream(), formula((yysym.value.ltl))); }
#line 628 "parsetl.cc" // lalr1.cc:617
        break;

      case 84: // sere

#line 240 "parsetl.yy" // lalr1.cc:617
        { print_sere(debug_stream(), formula((yysym.value.ltl))); }
#line 635 "parsetl.cc" // lalr1.cc:617
        break;

      case 85: // bracedsere

#line 240 "parsetl.yy" // lalr1.cc:617
        { print_sere(debug_stream(), formula((yysym.value.ltl))); }
#line 642 "parsetl.cc" // lalr1.cc:617
        break;

      case 86: // parenthesedsubformula

#line 239 "parsetl.yy" // lalr1.cc:617
        { print_psl(debug_stream(), formula((yysym.value.ltl))); }
#line 649 "parsetl.cc" // lalr1.cc:617
        break;

      case 87: // boolformula

#line 239 "parsetl.yy" // lalr1.cc:617
        { print_psl(debug_stream(), formula((yysym.value.ltl))); }
#line 656 "parsetl.cc" // lalr1.cc:617
        break;

      case 88: // subformula

#line 239 "parsetl.yy" // lalr1.cc:617
        { print_psl(debug_stream(), formula((yysym.value.ltl))); }
#line 663 "parsetl.cc" // lalr1.cc:617
        break;

      case 89: // lbtformula

#line 239 "parsetl.yy" // lalr1.cc:617
        { print_psl(debug_stream(), formula((yysym.value.ltl))); }
#line 670 "parsetl.cc" // lalr1.cc:617
        break;


      default:
        break;
    }
    yyo << ')';
  }
#endif

  inline
  void
  parser::yypush_ (const char* m, state_type s, symbol_type& sym)
  {
    stack_symbol_type t (s, sym);
    yypush_ (m, t);
  }

  inline
  void
  parser::yypush_ (const char* m, stack_symbol_type& s)
  {
    if (m)
      YY_SYMBOL_PRINT (m, s);
    yystack_.push (s);
  }

  inline
  void
  parser::yypop_ (unsigned int n)
  {
    yystack_.pop (n);
  }

#if YYDEBUG
  std::ostream&
  parser::debug_stream () const
  {
    return *yycdebug_;
  }

  void
  parser::set_debug_stream (std::ostream& o)
  {
    yycdebug_ = &o;
  }


  parser::debug_level_type
  parser::debug_level () const
  {
    return yydebug_;
  }

  void
  parser::set_debug_level (debug_level_type l)
  {
    yydebug_ = l;
  }
#endif // YYDEBUG

  inline parser::state_type
  parser::yy_lr_goto_state_ (state_type yystate, int yysym)
  {
    int yyr = yypgoto_[yysym - yyntokens_] + yystate;
    if (0 <= yyr && yyr <= yylast_ && yycheck_[yyr] == yystate)
      return yytable_[yyr];
    else
      return yydefgoto_[yysym - yyntokens_];
  }

  inline bool
  parser::yy_pact_value_is_default_ (int yyvalue)
  {
    return yyvalue == yypact_ninf_;
  }

  inline bool
  parser::yy_table_value_is_error_ (int yyvalue)
  {
    return yyvalue == yytable_ninf_;
  }

  int
  parser::parse ()
  {
    /// Whether yyla contains a lookahead.
    bool yyempty = true;

    // State.
    int yyn;
    /// Length of the RHS of the rule being reduced.
    int yylen = 0;

    // Error handling.
    int yynerrs_ = 0;
    int yyerrstatus_ = 0;

    /// The lookahead symbol.
    symbol_type yyla;

    /// The locations where the error started and ended.
    stack_symbol_type yyerror_range[3];

    /// The return value of parse ().
    int yyresult;

    // FIXME: This shoud be completely indented.  It is not yet to
    // avoid gratuitous conflicts when merging into the master branch.
    try
      {
    YYCDEBUG << "Starting parse" << std::endl;


    /* Initialize the stack.  The initial state will be set in
       yynewstate, since the latter expects the semantical and the
       location values to have been already stored, initialize these
       stacks with a primary value.  */
    yystack_.clear ();
    yypush_ (YY_NULLPTR, 0, yyla);

    // A new symbol was pushed on the stack.
  yynewstate:
    YYCDEBUG << "Entering state " << yystack_[0].state << std::endl;

    // Accept?
    if (yystack_[0].state == yyfinal_)
      goto yyacceptlab;

    goto yybackup;

    // Backup.
  yybackup:

    // Try to take a decision without lookahead.
    yyn = yypact_[yystack_[0].state];
    if (yy_pact_value_is_default_ (yyn))
      goto yydefault;

    // Read a lookahead token.
    if (yyempty)
      {
        YYCDEBUG << "Reading a token: ";
        try
          {
            yyla.type = yytranslate_ (yylex (&yyla.value, &yyla.location, error_list));
          }
        catch (const syntax_error& yyexc)
          {
            error (yyexc);
            goto yyerrlab1;
          }
        yyempty = false;
      }
    YY_SYMBOL_PRINT ("Next token is", yyla);

    /* If the proper action on seeing token YYLA.TYPE is to reduce or
       to detect an error, take that action.  */
    yyn += yyla.type_get ();
    if (yyn < 0 || yylast_ < yyn || yycheck_[yyn] != yyla.type_get ())
      goto yydefault;

    // Reduce or error.
    yyn = yytable_[yyn];
    if (yyn <= 0)
      {
        if (yy_table_value_is_error_ (yyn))
          goto yyerrlab;
        yyn = -yyn;
        goto yyreduce;
      }

    // Discard the token being shifted.
    yyempty = true;

    // Count tokens shifted since error; after three, turn off error status.
    if (yyerrstatus_)
      --yyerrstatus_;

    // Shift the lookahead token.
    yypush_ ("Shifting", yyn, yyla);
    goto yynewstate;

  /*-----------------------------------------------------------.
  | yydefault -- do the default action for the current state.  |
  `-----------------------------------------------------------*/
  yydefault:
    yyn = yydefact_[yystack_[0].state];
    if (yyn == 0)
      goto yyerrlab;
    goto yyreduce;

  /*-----------------------------.
  | yyreduce -- Do a reduction.  |
  `-----------------------------*/
  yyreduce:
    yylen = yyr2_[yyn];
    {
      stack_symbol_type yylhs;
      yylhs.state = yy_lr_goto_state_(yystack_[yylen].state, yyr1_[yyn]);
      /* If YYLEN is nonzero, implement the default value of the
         action: '$$ = $1'.  Otherwise, use the top of the stack.

         Otherwise, the following line sets YYLHS.VALUE to garbage.
         This behavior is undocumented and Bison users should not rely
         upon it.  */
      if (yylen)
        yylhs.value = yystack_[yylen - 1].value;
      else
        yylhs.value = yystack_[0].value;

      // Compute the default @$.
      {
        slice<stack_symbol_type, stack_type> slice (yystack_, yylen);
        YYLLOC_DEFAULT (yylhs.location, slice, yylen);
      }

      // Perform the reduction.
      YY_REDUCE_PRINT (yyn);
      try
        {
          switch (yyn)
            {
  case 2:
#line 246 "parsetl.yy" // lalr1.cc:847
    {
		result = formula((yystack_[1].value.ltl));
		YYACCEPT;
	      }
#line 900 "parsetl.cc" // lalr1.cc:847
    break;

  case 3:
#line 251 "parsetl.yy" // lalr1.cc:847
    {
		result = nullptr;
		YYABORT;
	      }
#line 909 "parsetl.cc" // lalr1.cc:847
    break;

  case 4:
#line 256 "parsetl.yy" // lalr1.cc:847
    {
		result = formula((yystack_[1].value.ltl));
		YYACCEPT;
	      }
#line 918 "parsetl.cc" // lalr1.cc:847
    break;

  case 5:
#line 261 "parsetl.yy" // lalr1.cc:847
    { YYABORT; }
#line 924 "parsetl.cc" // lalr1.cc:847
    break;

  case 6:
#line 263 "parsetl.yy" // lalr1.cc:847
    {
		result = formula((yystack_[1].value.ltl));
		YYACCEPT;
	      }
#line 933 "parsetl.cc" // lalr1.cc:847
    break;

  case 7:
#line 268 "parsetl.yy" // lalr1.cc:847
    {
		result = nullptr;
		YYABORT;
	      }
#line 942 "parsetl.cc" // lalr1.cc:847
    break;

  case 8:
#line 273 "parsetl.yy" // lalr1.cc:847
    {
		result = formula((yystack_[1].value.ltl));
		YYACCEPT;
	      }
#line 951 "parsetl.cc" // lalr1.cc:847
    break;

  case 9:
#line 278 "parsetl.yy" // lalr1.cc:847
    { YYABORT; }
#line 957 "parsetl.cc" // lalr1.cc:847
    break;

  case 10:
#line 280 "parsetl.yy" // lalr1.cc:847
    {
		result = formula((yystack_[1].value.ltl));
		YYACCEPT;
	      }
#line 966 "parsetl.cc" // lalr1.cc:847
    break;

  case 11:
#line 285 "parsetl.yy" // lalr1.cc:847
    {
		result = nullptr;
		YYABORT;
	      }
#line 975 "parsetl.cc" // lalr1.cc:847
    break;

  case 12:
#line 290 "parsetl.yy" // lalr1.cc:847
    {
		result = formula((yystack_[1].value.ltl));
		YYACCEPT;
	      }
#line 984 "parsetl.cc" // lalr1.cc:847
    break;

  case 13:
#line 295 "parsetl.yy" // lalr1.cc:847
    { YYABORT; }
#line 990 "parsetl.cc" // lalr1.cc:847
    break;

  case 14:
#line 297 "parsetl.yy" // lalr1.cc:847
    {
		result = formula((yystack_[1].value.ltl));
		YYACCEPT;
	      }
#line 999 "parsetl.cc" // lalr1.cc:847
    break;

  case 15:
#line 302 "parsetl.yy" // lalr1.cc:847
    {
		result = nullptr;
		YYABORT;
	      }
#line 1008 "parsetl.cc" // lalr1.cc:847
    break;

  case 16:
#line 307 "parsetl.yy" // lalr1.cc:847
    {
		result = formula((yystack_[1].value.ltl));
		YYACCEPT;
	      }
#line 1017 "parsetl.cc" // lalr1.cc:847
    break;

  case 17:
#line 312 "parsetl.yy" // lalr1.cc:847
    { YYABORT; }
#line 1023 "parsetl.cc" // lalr1.cc:847
    break;

  case 18:
#line 315 "parsetl.yy" // lalr1.cc:847
    {
		error_list.emplace_back(yylhs.location, "empty input");
		result = nullptr;
	      }
#line 1032 "parsetl.cc" // lalr1.cc:847
    break;

  case 19:
#line 321 "parsetl.yy" // lalr1.cc:847
    {
		error_list.emplace_back(yystack_[1].location, "ignoring trailing garbage");
	      }
#line 1040 "parsetl.cc" // lalr1.cc:847
    break;

  case 26:
#line 332 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.minmax).min = (yystack_[3].value.num); (yylhs.value.minmax).max = (yystack_[1].value.num); }
#line 1046 "parsetl.cc" // lalr1.cc:847
    break;

  case 27:
#line 334 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.minmax).min = (yystack_[2].value.num); (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1052 "parsetl.cc" // lalr1.cc:847
    break;

  case 28:
#line 336 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.minmax).min = 0U; (yylhs.value.minmax).max = (yystack_[1].value.num); }
#line 1058 "parsetl.cc" // lalr1.cc:847
    break;

  case 29:
#line 338 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.minmax).min = 0U; (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1064 "parsetl.cc" // lalr1.cc:847
    break;

  case 30:
#line 340 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.minmax).min = (yylhs.value.minmax).max = (yystack_[1].value.num); }
#line 1070 "parsetl.cc" // lalr1.cc:847
    break;

  case 31:
#line 344 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.minmax).min = (yystack_[3].value.num); (yylhs.value.minmax).max = (yystack_[1].value.num); }
#line 1076 "parsetl.cc" // lalr1.cc:847
    break;

  case 32:
#line 346 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.minmax).min = (yystack_[2].value.num); (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1082 "parsetl.cc" // lalr1.cc:847
    break;

  case 33:
#line 348 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.minmax).min = 1U; (yylhs.value.minmax).max = (yystack_[1].value.num); }
#line 1088 "parsetl.cc" // lalr1.cc:847
    break;

  case 34:
#line 350 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.minmax).min = 1U; (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1094 "parsetl.cc" // lalr1.cc:847
    break;

  case 35:
#line 352 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.minmax).min = (yylhs.value.minmax).max = 1U; }
#line 1100 "parsetl.cc" // lalr1.cc:847
    break;

  case 36:
#line 354 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.minmax).min = (yylhs.value.minmax).max = (yystack_[1].value.num); }
#line 1106 "parsetl.cc" // lalr1.cc:847
    break;

  case 37:
#line 356 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back(yylhs.location, "treating this goto block as [->]");
             (yylhs.value.minmax).min = (yylhs.value.minmax).max = 1U; }
#line 1113 "parsetl.cc" // lalr1.cc:847
    break;

  case 38:
#line 359 "parsetl.yy" // lalr1.cc:847
    { error_list.
	       emplace_back(yylhs.location, "missing closing bracket for goto operator");
	     (yylhs.value.minmax).min = (yylhs.value.minmax).max = 0U; }
#line 1121 "parsetl.cc" // lalr1.cc:847
    break;

  case 41:
#line 366 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.minmax).min = 0U; (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1127 "parsetl.cc" // lalr1.cc:847
    break;

  case 42:
#line 368 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.minmax).min = 1U; (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1133 "parsetl.cc" // lalr1.cc:847
    break;

  case 43:
#line 370 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.minmax) = (yystack_[0].value.minmax); }
#line 1139 "parsetl.cc" // lalr1.cc:847
    break;

  case 44:
#line 372 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back(yylhs.location, "treating this star block as [*]");
              (yylhs.value.minmax).min = 0U; (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1146 "parsetl.cc" // lalr1.cc:847
    break;

  case 45:
#line 375 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back(yylhs.location, "missing closing bracket for star");
	      (yylhs.value.minmax).min = (yylhs.value.minmax).max = 0U; }
#line 1153 "parsetl.cc" // lalr1.cc:847
    break;

  case 46:
#line 379 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.minmax).min = 0U; (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1159 "parsetl.cc" // lalr1.cc:847
    break;

  case 47:
#line 381 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.minmax).min = 1U; (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1165 "parsetl.cc" // lalr1.cc:847
    break;

  case 48:
#line 383 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.minmax) = (yystack_[0].value.minmax); }
#line 1171 "parsetl.cc" // lalr1.cc:847
    break;

  case 49:
#line 385 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back
		(yylhs.location, "treating this fusion-star block as [:*]");
              (yylhs.value.minmax).min = 0U; (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1179 "parsetl.cc" // lalr1.cc:847
    break;

  case 50:
#line 389 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back
		(yylhs.location, "missing closing bracket for fusion-star");
	      (yylhs.value.minmax).min = (yylhs.value.minmax).max = 0U; }
#line 1187 "parsetl.cc" // lalr1.cc:847
    break;

  case 51:
#line 394 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.minmax) = (yystack_[0].value.minmax); }
#line 1193 "parsetl.cc" // lalr1.cc:847
    break;

  case 52:
#line 396 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back(yylhs.location, "treating this equal block as [*]");
              (yylhs.value.minmax).min = 0U; (yylhs.value.minmax).max = fnode::unbounded(); }
#line 1200 "parsetl.cc" // lalr1.cc:847
    break;

  case 53:
#line 399 "parsetl.yy" // lalr1.cc:847
    { error_list.
		emplace_back(yylhs.location, "missing closing bracket for equal operator");
	      (yylhs.value.minmax).min = (yylhs.value.minmax).max = 0U; }
#line 1208 "parsetl.cc" // lalr1.cc:847
    break;

  case 54:
#line 405 "parsetl.yy" // lalr1.cc:847
    {
		(yylhs.value.ltl) = parse_environment.require(*(yystack_[0].value.str)).to_node_();
		if (! (yylhs.value.ltl))
		  {
		    std::string s = "unknown atomic proposition `";
		    s += *(yystack_[0].value.str);
		    s += "' in environment `";
		    s += parse_environment.name();
		    s += "'";
		    error_list.emplace_back(yystack_[0].location, s);
		    delete (yystack_[0].value.str);
		    YYERROR;
		  }
		else
		  delete (yystack_[0].value.str);
	      }
#line 1229 "parsetl.cc" // lalr1.cc:847
    break;

  case 55:
#line 422 "parsetl.yy" // lalr1.cc:847
    {
		(yylhs.value.ltl) = parse_environment.require(*(yystack_[1].value.str)).to_node_();
		if (! (yylhs.value.ltl))
		  {
		    std::string s = "unknown atomic proposition `";
		    s += *(yystack_[1].value.str);
		    s += "' in environment `";
		    s += parse_environment.name();
		    s += "'";
		    error_list.emplace_back(yystack_[1].location, s);
		    delete (yystack_[1].value.str);
		    YYERROR;
		  }
		else
		  delete (yystack_[1].value.str);
	      }
#line 1250 "parsetl.cc" // lalr1.cc:847
    break;

  case 56:
#line 439 "parsetl.yy" // lalr1.cc:847
    {
		(yylhs.value.ltl) = parse_environment.require(*(yystack_[1].value.str)).to_node_();
		if (! (yylhs.value.ltl))
		  {
		    std::string s = "unknown atomic proposition `";
		    s += *(yystack_[1].value.str);
		    s += "' in environment `";
		    s += parse_environment.name();
		    s += "'";
		    error_list.emplace_back(yystack_[1].location, s);
		    delete (yystack_[1].value.str);
		    YYERROR;
		  }
		else
		  delete (yystack_[1].value.str);
		(yylhs.value.ltl) = fnode::unop(op::Not, (yylhs.value.ltl));
	      }
#line 1272 "parsetl.cc" // lalr1.cc:847
    break;

  case 57:
#line 457 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::tt(); }
#line 1278 "parsetl.cc" // lalr1.cc:847
    break;

  case 58:
#line 459 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::ff(); }
#line 1284 "parsetl.cc" // lalr1.cc:847
    break;

  case 60:
#line 463 "parsetl.yy" // lalr1.cc:847
    {
		if ((yystack_[0].value.ltl)->is_boolean())
		  {
		    (yylhs.value.ltl) = fnode::unop(op::Not, (yystack_[0].value.ltl));
		  }
		else
		  {
		    error_list.emplace_back(yystack_[0].location,
                       "not a boolean expression: inside a SERE `!' can only "
                       "be applied to a Boolean expression");
		    error_list.emplace_back(yylhs.location, "treating this block as false");
		    (yystack_[0].value.ltl)->destroy();
		    (yylhs.value.ltl) = fnode::ff();
		  }
	      }
#line 1304 "parsetl.cc" // lalr1.cc:847
    break;

  case 62:
#line 480 "parsetl.yy" // lalr1.cc:847
    {
		(yylhs.value.ltl) =
		  try_recursive_parse(*(yystack_[0].value.str), yystack_[0].location, parse_environment,
				      debug_level(), parser_sere, error_list)
		  .to_node_();
		delete (yystack_[0].value.str);
		if (!(yylhs.value.ltl))
		  YYERROR;
	      }
#line 1318 "parsetl.cc" // lalr1.cc:847
    break;

  case 63:
#line 490 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = (yystack_[1].value.ltl); }
#line 1324 "parsetl.cc" // lalr1.cc:847
    break;

  case 64:
#line 492 "parsetl.yy" // lalr1.cc:847
    { error_list.
		  emplace_back(yylhs.location,
			       "treating this parenthetical block as false");
		(yylhs.value.ltl) = fnode::ff();
	      }
#line 1334 "parsetl.cc" // lalr1.cc:847
    break;

  case 65:
#line 498 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back(yystack_[2].location + yystack_[1].location, "missing closing parenthesis");
		(yylhs.value.ltl) = (yystack_[1].value.ltl);
	      }
#line 1342 "parsetl.cc" // lalr1.cc:847
    break;

  case 66:
#line 502 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back(yylhs.location,
                    "missing closing parenthesis, "
		    "treating this parenthetical block as false");
		(yylhs.value.ltl) = fnode::ff();
	      }
#line 1352 "parsetl.cc" // lalr1.cc:847
    break;

  case 67:
#line 508 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::multop(op::AndRat, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1358 "parsetl.cc" // lalr1.cc:847
    break;

  case 68:
#line 510 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location,
				    "length-matching and operator"); }
#line 1365 "parsetl.cc" // lalr1.cc:847
    break;

  case 69:
#line 513 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::multop(op::AndNLM, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1371 "parsetl.cc" // lalr1.cc:847
    break;

  case 70:
#line 515 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location,
                                    "non-length-matching and operator"); }
#line 1378 "parsetl.cc" // lalr1.cc:847
    break;

  case 71:
#line 518 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::multop(op::OrRat, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1384 "parsetl.cc" // lalr1.cc:847
    break;

  case 72:
#line 520 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "or operator"); }
#line 1390 "parsetl.cc" // lalr1.cc:847
    break;

  case 73:
#line 522 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::multop(op::Concat, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1396 "parsetl.cc" // lalr1.cc:847
    break;

  case 74:
#line 524 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "concat operator"); }
#line 1402 "parsetl.cc" // lalr1.cc:847
    break;

  case 75:
#line 526 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::multop(op::Fusion, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1408 "parsetl.cc" // lalr1.cc:847
    break;

  case 76:
#line 528 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "fusion operator"); }
#line 1414 "parsetl.cc" // lalr1.cc:847
    break;

  case 77:
#line 530 "parsetl.yy" // lalr1.cc:847
    {
		if ((yystack_[0].value.minmax).max < (yystack_[0].value.minmax).min)
		  {
		    error_list.emplace_back(yystack_[0].location, "reversed range");
		    std::swap((yystack_[0].value.minmax).max, (yystack_[0].value.minmax).min);
		  }
		(yylhs.value.ltl) = fnode::bunop(op::Star, fnode::tt(), (yystack_[0].value.minmax).min, (yystack_[0].value.minmax).max);
	      }
#line 1427 "parsetl.cc" // lalr1.cc:847
    break;

  case 78:
#line 539 "parsetl.yy" // lalr1.cc:847
    {
		if ((yystack_[0].value.minmax).max < (yystack_[0].value.minmax).min)
		  {
		    error_list.emplace_back(yystack_[0].location, "reversed range");
		    std::swap((yystack_[0].value.minmax).max, (yystack_[0].value.minmax).min);
		  }
		(yylhs.value.ltl) = fnode::bunop(op::Star, (yystack_[1].value.ltl), (yystack_[0].value.minmax).min, (yystack_[0].value.minmax).max);
	      }
#line 1440 "parsetl.cc" // lalr1.cc:847
    break;

  case 79:
#line 548 "parsetl.yy" // lalr1.cc:847
    {
		if ((yystack_[0].value.minmax).max < (yystack_[0].value.minmax).min)
		  {
		    error_list.emplace_back(yystack_[0].location, "reversed range");
		    std::swap((yystack_[0].value.minmax).max, (yystack_[0].value.minmax).min);
		  }
		(yylhs.value.ltl) = fnode::bunop(op::FStar, (yystack_[1].value.ltl), (yystack_[0].value.minmax).min, (yystack_[0].value.minmax).max);
	      }
#line 1453 "parsetl.cc" // lalr1.cc:847
    break;

  case 80:
#line 557 "parsetl.yy" // lalr1.cc:847
    {
		if ((yystack_[0].value.minmax).max < (yystack_[0].value.minmax).min)
		  {
		    error_list.emplace_back(yystack_[0].location, "reversed range");
		    std::swap((yystack_[0].value.minmax).max, (yystack_[0].value.minmax).min);
		  }
		if ((yystack_[1].value.ltl)->is_boolean())
		  {
		    (yylhs.value.ltl) = formula::sugar_equal(formula((yystack_[1].value.ltl)),
					      (yystack_[0].value.minmax).min, (yystack_[0].value.minmax).max).to_node_();
		  }
		else
		  {
		    error_list.emplace_back(yystack_[1].location,
				"not a boolean expression: [=...] can only "
				"be applied to a Boolean expression");
		    error_list.emplace_back(yylhs.location,
				"treating this block as false");
		    (yystack_[1].value.ltl)->destroy();
		    (yylhs.value.ltl) = fnode::ff();
		  }
	      }
#line 1480 "parsetl.cc" // lalr1.cc:847
    break;

  case 81:
#line 580 "parsetl.yy" // lalr1.cc:847
    {
		if ((yystack_[0].value.minmax).max < (yystack_[0].value.minmax).min)
		  {
		    error_list.emplace_back(yystack_[0].location, "reversed range");
		    std::swap((yystack_[0].value.minmax).max, (yystack_[0].value.minmax).min);
		  }
		if ((yystack_[1].value.ltl)->is_boolean())
		  {
		    (yylhs.value.ltl) = formula::sugar_goto(formula((yystack_[1].value.ltl)),
					     (yystack_[0].value.minmax).min, (yystack_[0].value.minmax).max).to_node_();
		  }
		else
		  {
		    error_list.emplace_back(yystack_[1].location,
				"not a boolean expression: [->...] can only "
				"be applied to a Boolean expression");
		    error_list.emplace_back(yylhs.location,
				"treating this block as false");
		    (yystack_[1].value.ltl)->destroy();
		    (yylhs.value.ltl) = fnode::ff();
		  }
	      }
#line 1507 "parsetl.cc" // lalr1.cc:847
    break;

  case 82:
#line 603 "parsetl.yy" // lalr1.cc:847
    {
		if ((yystack_[2].value.ltl)->is_boolean() && (yystack_[0].value.ltl)->is_boolean())
		  {
		    (yylhs.value.ltl) = fnode::binop(op::Xor, (yystack_[2].value.ltl), (yystack_[0].value.ltl));
		  }
		else
		  {
		    if (!(yystack_[2].value.ltl)->is_boolean())
		      {
			error_list.emplace_back(yystack_[2].location,
                         "not a boolean expression: inside SERE `<->' can only "
                         "be applied to Boolean expressions");
                      }
		    if (!(yystack_[0].value.ltl)->is_boolean())
		      {
			error_list.emplace_back(yystack_[0].location,
                         "not a boolean expression: inside SERE `<->' can only "
                         "be applied to Boolean expressions");
                      }
		    error_list.emplace_back(yylhs.location, "treating this block as false");
		    (yystack_[2].value.ltl)->destroy();
		    (yystack_[0].value.ltl)->destroy();
		    (yylhs.value.ltl) = fnode::ff();
		  }
	      }
#line 1537 "parsetl.cc" // lalr1.cc:847
    break;

  case 83:
#line 629 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "xor operator"); }
#line 1543 "parsetl.cc" // lalr1.cc:847
    break;

  case 84:
#line 631 "parsetl.yy" // lalr1.cc:847
    {
		if ((yystack_[2].value.ltl)->is_boolean())
		  {
		    (yylhs.value.ltl) = fnode::binop(op::Implies, (yystack_[2].value.ltl), (yystack_[0].value.ltl));
		  }
		else
		  {
		    if (!(yystack_[2].value.ltl)->is_boolean())
		      {
			error_list.emplace_back(yystack_[2].location,
                         "not a boolean expression: inside SERE `->' can only "
                         "be applied to a Boolean expression");
                      }
		    error_list.emplace_back(yylhs.location, "treating this block as false");
		    (yystack_[2].value.ltl)->destroy();
		    (yystack_[0].value.ltl)->destroy();
		    (yylhs.value.ltl) = fnode::ff();
		  }
	      }
#line 1567 "parsetl.cc" // lalr1.cc:847
    break;

  case 85:
#line 651 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "implication operator"); }
#line 1573 "parsetl.cc" // lalr1.cc:847
    break;

  case 86:
#line 653 "parsetl.yy" // lalr1.cc:847
    {
		if ((yystack_[2].value.ltl)->is_boolean() && (yystack_[0].value.ltl)->is_boolean())
		  {
		    (yylhs.value.ltl) = fnode::binop(op::Equiv, (yystack_[2].value.ltl), (yystack_[0].value.ltl));
		  }
		else
		  {
		    if (!(yystack_[2].value.ltl)->is_boolean())
		      {
			error_list.emplace_back(yystack_[2].location,
                         "not a boolean expression: inside SERE `<->' can only "
                         "be applied to Boolean expressions");
                      }
		    if (!(yystack_[0].value.ltl)->is_boolean())
		      {
			error_list.emplace_back(yystack_[0].location,
                         "not a boolean expression: inside SERE `<->' can only "
                         "be applied to Boolean expressions");
                      }
		    error_list.emplace_back(yylhs.location, "treating this block as false");
		    (yystack_[2].value.ltl)->destroy();
		    (yystack_[0].value.ltl)->destroy();
		    (yylhs.value.ltl) = fnode::ff();
		  }
	      }
#line 1603 "parsetl.cc" // lalr1.cc:847
    break;

  case 87:
#line 679 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "equivalent operator"); }
#line 1609 "parsetl.cc" // lalr1.cc:847
    break;

  case 88:
#line 682 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = (yystack_[1].value.ltl); }
#line 1615 "parsetl.cc" // lalr1.cc:847
    break;

  case 89:
#line 684 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back(yystack_[1].location, "ignoring this");
		(yylhs.value.ltl) = (yystack_[2].value.ltl);
	      }
#line 1623 "parsetl.cc" // lalr1.cc:847
    break;

  case 90:
#line 688 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back(yylhs.location,
					"treating this brace block as false");
		(yylhs.value.ltl) = fnode::ff();
	      }
#line 1632 "parsetl.cc" // lalr1.cc:847
    break;

  case 91:
#line 693 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back(yystack_[2].location + yystack_[1].location,
					"missing closing brace");
		(yylhs.value.ltl) = (yystack_[1].value.ltl);
	      }
#line 1641 "parsetl.cc" // lalr1.cc:847
    break;

  case 92:
#line 698 "parsetl.yy" // lalr1.cc:847
    { error_list. emplace_back(yystack_[1].location,
                  "ignoring trailing garbage and missing closing brace");
		(yylhs.value.ltl) = (yystack_[2].value.ltl);
	      }
#line 1650 "parsetl.cc" // lalr1.cc:847
    break;

  case 93:
#line 703 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back(yylhs.location,
                    "missing closing brace, "
		    "treating this brace block as false");
		(yylhs.value.ltl) = fnode::ff();
	      }
#line 1660 "parsetl.cc" // lalr1.cc:847
    break;

  case 94:
#line 709 "parsetl.yy" // lalr1.cc:847
    {
		(yylhs.value.ltl) = try_recursive_parse(*(yystack_[0].value.str), yystack_[0].location, parse_environment,
					 debug_level(),
					 parser_sere, error_list).to_node_();
		delete (yystack_[0].value.str);
		if (!(yylhs.value.ltl))
		  YYERROR;
	      }
#line 1673 "parsetl.cc" // lalr1.cc:847
    break;

  case 95:
#line 719 "parsetl.yy" // lalr1.cc:847
    {
		(yylhs.value.ltl) = try_recursive_parse(*(yystack_[0].value.str), yystack_[0].location, parse_environment,
					 debug_level(), parser_ltl, error_list)
		  .to_node_();
		delete (yystack_[0].value.str);
		if (!(yylhs.value.ltl))
		  YYERROR;
	      }
#line 1686 "parsetl.cc" // lalr1.cc:847
    break;

  case 96:
#line 728 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = (yystack_[1].value.ltl); }
#line 1692 "parsetl.cc" // lalr1.cc:847
    break;

  case 97:
#line 730 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back(yystack_[1].location, "ignoring this");
		(yylhs.value.ltl) = (yystack_[2].value.ltl);
	      }
#line 1700 "parsetl.cc" // lalr1.cc:847
    break;

  case 98:
#line 734 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back(yylhs.location,
		 "treating this parenthetical block as false");
		(yylhs.value.ltl) = fnode::ff();
	      }
#line 1709 "parsetl.cc" // lalr1.cc:847
    break;

  case 99:
#line 739 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back(yystack_[2].location + yystack_[1].location, "missing closing parenthesis");
		(yylhs.value.ltl) = (yystack_[1].value.ltl);
	      }
#line 1717 "parsetl.cc" // lalr1.cc:847
    break;

  case 100:
#line 743 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back(yystack_[1].location,
                "ignoring trailing garbage and missing closing parenthesis");
		(yylhs.value.ltl) = (yystack_[2].value.ltl);
	      }
#line 1726 "parsetl.cc" // lalr1.cc:847
    break;

  case 101:
#line 748 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back(yylhs.location,
                    "missing closing parenthesis, "
		    "treating this parenthetical block as false");
		(yylhs.value.ltl) = fnode::ff();
	      }
#line 1736 "parsetl.cc" // lalr1.cc:847
    break;

  case 103:
#line 757 "parsetl.yy" // lalr1.cc:847
    {
		(yylhs.value.ltl) = try_recursive_parse(*(yystack_[0].value.str), yystack_[0].location, parse_environment,
					 debug_level(), parser_bool, error_list)
		  .to_node_();
		delete (yystack_[0].value.str);
		if (!(yylhs.value.ltl))
		  YYERROR;
	      }
#line 1749 "parsetl.cc" // lalr1.cc:847
    break;

  case 104:
#line 766 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = (yystack_[1].value.ltl); }
#line 1755 "parsetl.cc" // lalr1.cc:847
    break;

  case 105:
#line 768 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back(yystack_[1].location, "ignoring this");
		(yylhs.value.ltl) = (yystack_[2].value.ltl);
	      }
#line 1763 "parsetl.cc" // lalr1.cc:847
    break;

  case 106:
#line 772 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back(yylhs.location,
		 "treating this parenthetical block as false");
		(yylhs.value.ltl) = fnode::ff();
	      }
#line 1772 "parsetl.cc" // lalr1.cc:847
    break;

  case 107:
#line 777 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back(yystack_[2].location + yystack_[1].location,
					"missing closing parenthesis");
		(yylhs.value.ltl) = (yystack_[1].value.ltl);
	      }
#line 1781 "parsetl.cc" // lalr1.cc:847
    break;

  case 108:
#line 782 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back(yystack_[1].location,
                "ignoring trailing garbage and missing closing parenthesis");
		(yylhs.value.ltl) = (yystack_[2].value.ltl);
	      }
#line 1790 "parsetl.cc" // lalr1.cc:847
    break;

  case 109:
#line 787 "parsetl.yy" // lalr1.cc:847
    { error_list.emplace_back(yylhs.location,
                    "missing closing parenthesis, "
		    "treating this parenthetical block as false");
		(yylhs.value.ltl) = fnode::ff();
	      }
#line 1800 "parsetl.cc" // lalr1.cc:847
    break;

  case 110:
#line 793 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::multop(op::And, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1806 "parsetl.cc" // lalr1.cc:847
    break;

  case 111:
#line 795 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "and operator"); }
#line 1812 "parsetl.cc" // lalr1.cc:847
    break;

  case 112:
#line 797 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::multop(op::And, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1818 "parsetl.cc" // lalr1.cc:847
    break;

  case 113:
#line 799 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "and operator"); }
#line 1824 "parsetl.cc" // lalr1.cc:847
    break;

  case 114:
#line 801 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::multop(op::And, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1830 "parsetl.cc" // lalr1.cc:847
    break;

  case 115:
#line 803 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "and operator"); }
#line 1836 "parsetl.cc" // lalr1.cc:847
    break;

  case 116:
#line 805 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::multop(op::Or, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1842 "parsetl.cc" // lalr1.cc:847
    break;

  case 117:
#line 807 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "or operator"); }
#line 1848 "parsetl.cc" // lalr1.cc:847
    break;

  case 118:
#line 809 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::Xor, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 1854 "parsetl.cc" // lalr1.cc:847
    break;

  case 119:
#line 811 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "xor operator"); }
#line 1860 "parsetl.cc" // lalr1.cc:847
    break;

  case 120:
#line 813 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::Implies, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 1866 "parsetl.cc" // lalr1.cc:847
    break;

  case 121:
#line 815 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "implication operator"); }
#line 1872 "parsetl.cc" // lalr1.cc:847
    break;

  case 122:
#line 817 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::Equiv, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 1878 "parsetl.cc" // lalr1.cc:847
    break;

  case 123:
#line 819 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "equivalent operator"); }
#line 1884 "parsetl.cc" // lalr1.cc:847
    break;

  case 124:
#line 821 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::unop(op::Not, (yystack_[0].value.ltl)); }
#line 1890 "parsetl.cc" // lalr1.cc:847
    break;

  case 125:
#line 823 "parsetl.yy" // lalr1.cc:847
    { missing_right_op((yylhs.value.ltl), yystack_[1].location, "not operator"); }
#line 1896 "parsetl.cc" // lalr1.cc:847
    break;

  case 128:
#line 828 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::multop(op::And, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1902 "parsetl.cc" // lalr1.cc:847
    break;

  case 129:
#line 830 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "and operator"); }
#line 1908 "parsetl.cc" // lalr1.cc:847
    break;

  case 130:
#line 832 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::multop(op::And, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1914 "parsetl.cc" // lalr1.cc:847
    break;

  case 131:
#line 834 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "and operator"); }
#line 1920 "parsetl.cc" // lalr1.cc:847
    break;

  case 132:
#line 836 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::multop(op::And, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1926 "parsetl.cc" // lalr1.cc:847
    break;

  case 133:
#line 838 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "and operator"); }
#line 1932 "parsetl.cc" // lalr1.cc:847
    break;

  case 134:
#line 840 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::multop(op::Or, {(yystack_[2].value.ltl), (yystack_[0].value.ltl)}); }
#line 1938 "parsetl.cc" // lalr1.cc:847
    break;

  case 135:
#line 842 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "or operator"); }
#line 1944 "parsetl.cc" // lalr1.cc:847
    break;

  case 136:
#line 844 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::Xor, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 1950 "parsetl.cc" // lalr1.cc:847
    break;

  case 137:
#line 846 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "xor operator"); }
#line 1956 "parsetl.cc" // lalr1.cc:847
    break;

  case 138:
#line 848 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::Implies, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 1962 "parsetl.cc" // lalr1.cc:847
    break;

  case 139:
#line 850 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "implication operator"); }
#line 1968 "parsetl.cc" // lalr1.cc:847
    break;

  case 140:
#line 852 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::Equiv, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 1974 "parsetl.cc" // lalr1.cc:847
    break;

  case 141:
#line 854 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "equivalent operator"); }
#line 1980 "parsetl.cc" // lalr1.cc:847
    break;

  case 142:
#line 856 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::U, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 1986 "parsetl.cc" // lalr1.cc:847
    break;

  case 143:
#line 858 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "until operator"); }
#line 1992 "parsetl.cc" // lalr1.cc:847
    break;

  case 144:
#line 860 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::R, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 1998 "parsetl.cc" // lalr1.cc:847
    break;

  case 145:
#line 862 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "release operator"); }
#line 2004 "parsetl.cc" // lalr1.cc:847
    break;

  case 146:
#line 864 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::W, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 2010 "parsetl.cc" // lalr1.cc:847
    break;

  case 147:
#line 866 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "weak until operator"); }
#line 2016 "parsetl.cc" // lalr1.cc:847
    break;

  case 148:
#line 868 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::M, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 2022 "parsetl.cc" // lalr1.cc:847
    break;

  case 149:
#line 870 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location, "strong release operator"); }
#line 2028 "parsetl.cc" // lalr1.cc:847
    break;

  case 150:
#line 872 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::unop(op::F, (yystack_[0].value.ltl)); }
#line 2034 "parsetl.cc" // lalr1.cc:847
    break;

  case 151:
#line 874 "parsetl.yy" // lalr1.cc:847
    { missing_right_op((yylhs.value.ltl), yystack_[1].location, "sometimes operator"); }
#line 2040 "parsetl.cc" // lalr1.cc:847
    break;

  case 152:
#line 876 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::unop(op::G, (yystack_[0].value.ltl)); }
#line 2046 "parsetl.cc" // lalr1.cc:847
    break;

  case 153:
#line 878 "parsetl.yy" // lalr1.cc:847
    { missing_right_op((yylhs.value.ltl), yystack_[1].location, "always operator"); }
#line 2052 "parsetl.cc" // lalr1.cc:847
    break;

  case 154:
#line 880 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::unop(op::X, (yystack_[0].value.ltl)); }
#line 2058 "parsetl.cc" // lalr1.cc:847
    break;

  case 155:
#line 882 "parsetl.yy" // lalr1.cc:847
    { missing_right_op((yylhs.value.ltl), yystack_[1].location, "next operator"); }
#line 2064 "parsetl.cc" // lalr1.cc:847
    break;

  case 156:
#line 884 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::unop(op::Not, (yystack_[0].value.ltl)); }
#line 2070 "parsetl.cc" // lalr1.cc:847
    break;

  case 157:
#line 886 "parsetl.yy" // lalr1.cc:847
    { missing_right_op((yylhs.value.ltl), yystack_[1].location, "not operator"); }
#line 2076 "parsetl.cc" // lalr1.cc:847
    break;

  case 158:
#line 888 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::unop(op::Closure, (yystack_[0].value.ltl)); }
#line 2082 "parsetl.cc" // lalr1.cc:847
    break;

  case 159:
#line 890 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::UConcat, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 2088 "parsetl.cc" // lalr1.cc:847
    break;

  case 160:
#line 892 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::UConcat, (yystack_[1].value.ltl), (yystack_[0].value.ltl)); }
#line 2094 "parsetl.cc" // lalr1.cc:847
    break;

  case 161:
#line 894 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop_hard((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location,
				    "universal overlapping concat operator"); }
#line 2101 "parsetl.cc" // lalr1.cc:847
    break;

  case 162:
#line 897 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::EConcat, (yystack_[2].value.ltl), (yystack_[0].value.ltl)); }
#line 2107 "parsetl.cc" // lalr1.cc:847
    break;

  case 163:
#line 899 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop_hard((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location,
				    "existential overlapping concat operator");
	      }
#line 2115 "parsetl.cc" // lalr1.cc:847
    break;

  case 164:
#line 904 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::UConcat,
				  fnode::multop(op::Concat, {(yystack_[2].value.ltl), fnode::tt()}),
				  (yystack_[0].value.ltl)); }
#line 2123 "parsetl.cc" // lalr1.cc:847
    break;

  case 165:
#line 908 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop_hard((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location,
				  "universal non-overlapping concat operator");
	      }
#line 2131 "parsetl.cc" // lalr1.cc:847
    break;

  case 166:
#line 913 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::EConcat,
				  fnode::multop(op::Concat, {(yystack_[2].value.ltl), fnode::tt()}),
				  (yystack_[0].value.ltl)); }
#line 2139 "parsetl.cc" // lalr1.cc:847
    break;

  case 167:
#line 917 "parsetl.yy" // lalr1.cc:847
    { missing_right_binop_hard((yylhs.value.ltl), (yystack_[2].value.ltl), yystack_[1].location,
				"existential non-overlapping concat operator");
	      }
#line 2147 "parsetl.cc" // lalr1.cc:847
    break;

  case 168:
#line 922 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::EConcat, (yystack_[1].value.ltl), fnode::tt()); }
#line 2153 "parsetl.cc" // lalr1.cc:847
    break;

  case 169:
#line 924 "parsetl.yy" // lalr1.cc:847
    {
		(yylhs.value.ltl) = try_recursive_parse(*(yystack_[0].value.str), yystack_[0].location, parse_environment,
					 debug_level(), parser_sere, error_list)
		  .to_node_();
		delete (yystack_[0].value.str);
		if (!(yylhs.value.ltl))
		  YYERROR;
		(yylhs.value.ltl) = fnode::binop(op::EConcat, (yylhs.value.ltl), fnode::tt());
	      }
#line 2167 "parsetl.cc" // lalr1.cc:847
    break;

  case 170:
#line 935 "parsetl.yy" // lalr1.cc:847
    {
		(yylhs.value.ltl) = parse_environment.require(*(yystack_[0].value.str)).to_node_();
		if (! (yylhs.value.ltl))
		  {
		    std::string s = "atomic proposition `";
		    s += *(yystack_[0].value.str);
		    s += "' rejected by environment `";
		    s += parse_environment.name();
		    s += "'";
		    error_list.emplace_back(yystack_[0].location, s);
		    delete (yystack_[0].value.str);
		    YYERROR;
		  }
		else
		  delete (yystack_[0].value.str);
	      }
#line 2188 "parsetl.cc" // lalr1.cc:847
    break;

  case 171:
#line 952 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::unop(op::Not, (yystack_[0].value.ltl)); }
#line 2194 "parsetl.cc" // lalr1.cc:847
    break;

  case 172:
#line 954 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::multop(op::And, {(yystack_[1].value.ltl), (yystack_[0].value.ltl)}); }
#line 2200 "parsetl.cc" // lalr1.cc:847
    break;

  case 173:
#line 956 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::multop(op::Or, {(yystack_[1].value.ltl), (yystack_[0].value.ltl)}); }
#line 2206 "parsetl.cc" // lalr1.cc:847
    break;

  case 174:
#line 958 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::Xor, (yystack_[1].value.ltl), (yystack_[0].value.ltl)); }
#line 2212 "parsetl.cc" // lalr1.cc:847
    break;

  case 175:
#line 960 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::Implies, (yystack_[1].value.ltl), (yystack_[0].value.ltl)); }
#line 2218 "parsetl.cc" // lalr1.cc:847
    break;

  case 176:
#line 962 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::Equiv, (yystack_[1].value.ltl), (yystack_[0].value.ltl)); }
#line 2224 "parsetl.cc" // lalr1.cc:847
    break;

  case 177:
#line 964 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::unop(op::X, (yystack_[0].value.ltl)); }
#line 2230 "parsetl.cc" // lalr1.cc:847
    break;

  case 178:
#line 966 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::unop(op::F, (yystack_[0].value.ltl)); }
#line 2236 "parsetl.cc" // lalr1.cc:847
    break;

  case 179:
#line 968 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::unop(op::G, (yystack_[0].value.ltl)); }
#line 2242 "parsetl.cc" // lalr1.cc:847
    break;

  case 180:
#line 970 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::U, (yystack_[1].value.ltl), (yystack_[0].value.ltl)); }
#line 2248 "parsetl.cc" // lalr1.cc:847
    break;

  case 181:
#line 972 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::R, (yystack_[1].value.ltl), (yystack_[0].value.ltl)); }
#line 2254 "parsetl.cc" // lalr1.cc:847
    break;

  case 182:
#line 974 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::R, (yystack_[1].value.ltl), (yystack_[0].value.ltl)); }
#line 2260 "parsetl.cc" // lalr1.cc:847
    break;

  case 183:
#line 976 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::W, (yystack_[1].value.ltl), (yystack_[0].value.ltl)); }
#line 2266 "parsetl.cc" // lalr1.cc:847
    break;

  case 184:
#line 978 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::binop(op::M, (yystack_[1].value.ltl), (yystack_[0].value.ltl)); }
#line 2272 "parsetl.cc" // lalr1.cc:847
    break;

  case 185:
#line 980 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::tt(); }
#line 2278 "parsetl.cc" // lalr1.cc:847
    break;

  case 186:
#line 982 "parsetl.yy" // lalr1.cc:847
    { (yylhs.value.ltl) = fnode::ff(); }
#line 2284 "parsetl.cc" // lalr1.cc:847
    break;


#line 2288 "parsetl.cc" // lalr1.cc:847
            default:
              break;
            }
        }
      catch (const syntax_error& yyexc)
        {
          error (yyexc);
          YYERROR;
        }
      YY_SYMBOL_PRINT ("-> $$ =", yylhs);
      yypop_ (yylen);
      yylen = 0;
      YY_STACK_PRINT ();

      // Shift the result of the reduction.
      yypush_ (YY_NULLPTR, yylhs);
    }
    goto yynewstate;

  /*--------------------------------------.
  | yyerrlab -- here on detecting error.  |
  `--------------------------------------*/
  yyerrlab:
    // If not already recovering from an error, report this error.
    if (!yyerrstatus_)
      {
        ++yynerrs_;
        error (yyla.location, yysyntax_error_ (yystack_[0].state,
                                           yyempty ? yyempty_ : yyla.type_get ()));
      }


    yyerror_range[1].location = yyla.location;
    if (yyerrstatus_ == 3)
      {
        /* If just tried and failed to reuse lookahead token after an
           error, discard it.  */

        // Return failure if at end of input.
        if (yyla.type_get () == yyeof_)
          YYABORT;
        else if (!yyempty)
          {
            yy_destroy_ ("Error: discarding", yyla);
            yyempty = true;
          }
      }

    // Else will try to reuse lookahead token after shifting the error token.
    goto yyerrlab1;


  /*---------------------------------------------------.
  | yyerrorlab -- error raised explicitly by YYERROR.  |
  `---------------------------------------------------*/
  yyerrorlab:

    /* Pacify compilers like GCC when the user code never invokes
       YYERROR and the label yyerrorlab therefore never appears in user
       code.  */
    if (false)
      goto yyerrorlab;
    yyerror_range[1].location = yystack_[yylen - 1].location;
    /* Do not reclaim the symbols of the rule whose action triggered
       this YYERROR.  */
    yypop_ (yylen);
    yylen = 0;
    goto yyerrlab1;

  /*-------------------------------------------------------------.
  | yyerrlab1 -- common code for both syntax error and YYERROR.  |
  `-------------------------------------------------------------*/
  yyerrlab1:
    yyerrstatus_ = 3;   // Each real token shifted decrements this.
    {
      stack_symbol_type error_token;
      for (;;)
        {
          yyn = yypact_[yystack_[0].state];
          if (!yy_pact_value_is_default_ (yyn))
            {
              yyn += yyterror_;
              if (0 <= yyn && yyn <= yylast_ && yycheck_[yyn] == yyterror_)
                {
                  yyn = yytable_[yyn];
                  if (0 < yyn)
                    break;
                }
            }

          // Pop the current state because it cannot handle the error token.
          if (yystack_.size () == 1)
            YYABORT;

          yyerror_range[1].location = yystack_[0].location;
          yy_destroy_ ("Error: popping", yystack_[0]);
          yypop_ ();
          YY_STACK_PRINT ();
        }

      yyerror_range[2].location = yyla.location;
      YYLLOC_DEFAULT (error_token.location, yyerror_range, 2);

      // Shift the error token.
      error_token.state = yyn;
      yypush_ ("Shifting", error_token);
    }
    goto yynewstate;

    // Accept.
  yyacceptlab:
    yyresult = 0;
    goto yyreturn;

    // Abort.
  yyabortlab:
    yyresult = 1;
    goto yyreturn;

  yyreturn:
    if (!yyempty)
      yy_destroy_ ("Cleanup: discarding lookahead", yyla);

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYABORT or YYACCEPT.  */
    yypop_ (yylen);
    while (1 < yystack_.size ())
      {
        yy_destroy_ ("Cleanup: popping", yystack_[0]);
        yypop_ ();
      }

    return yyresult;
  }
    catch (...)
      {
        YYCDEBUG << "Exception caught: cleaning lookahead and stack"
                 << std::endl;
        // Do not try to display the values of the reclaimed symbols,
        // as their printer might throw an exception.
        if (!yyempty)
          yy_destroy_ (YY_NULLPTR, yyla);

        while (1 < yystack_.size ())
          {
            yy_destroy_ (YY_NULLPTR, yystack_[0]);
            yypop_ ();
          }
        throw;
      }
  }

  void
  parser::error (const syntax_error& yyexc)
  {
    error (yyexc.location, yyexc.what());
  }

  // Generate an error message.
  std::string
  parser::yysyntax_error_ (state_type yystate, symbol_number_type yytoken) const
  {
    std::string yyres;
    // Number of reported tokens (one for the "unexpected", one per
    // "expected").
    size_t yycount = 0;
    // Its maximum.
    enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
    // Arguments of yyformat.
    char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];

    /* There are many possibilities here to consider:
       - If this state is a consistent state with a default action, then
         the only way this function was invoked is if the default action
         is an error action.  In that case, don't check for expected
         tokens because there are none.
       - The only way there can be no lookahead present (in yytoken) is
         if this state is a consistent state with a default action.
         Thus, detecting the absence of a lookahead is sufficient to
         determine that there is no unexpected or expected token to
         report.  In that case, just report a simple "syntax error".
       - Don't assume there isn't a lookahead just because this state is
         a consistent state with a default action.  There might have
         been a previous inconsistent state, consistent state with a
         non-default action, or user semantic action that manipulated
         yyla.  (However, yyla is currently not documented for users.)
       - Of course, the expected token list depends on states to have
         correct lookahead information, and it depends on the parser not
         to perform extra reductions after fetching a lookahead from the
         scanner and before detecting a syntax error.  Thus, state
         merging (from LALR or IELR) and default reductions corrupt the
         expected token list.  However, the list is correct for
         canonical LR with one exception: it will still contain any
         token that will not be accepted due to an error action in a
         later state.
    */
    if (yytoken != yyempty_)
      {
        yyarg[yycount++] = yytname_[yytoken];
        int yyn = yypact_[yystate];
        if (!yy_pact_value_is_default_ (yyn))
          {
            /* Start YYX at -YYN if negative to avoid negative indexes in
               YYCHECK.  In other words, skip the first -YYN actions for
               this state because they are default actions.  */
            int yyxbegin = yyn < 0 ? -yyn : 0;
            // Stay within bounds of both yycheck and yytname.
            int yychecklim = yylast_ - yyn + 1;
            int yyxend = yychecklim < yyntokens_ ? yychecklim : yyntokens_;
            for (int yyx = yyxbegin; yyx < yyxend; ++yyx)
              if (yycheck_[yyx + yyn] == yyx && yyx != yyterror_
                  && !yy_table_value_is_error_ (yytable_[yyx + yyn]))
                {
                  if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                    {
                      yycount = 1;
                      break;
                    }
                  else
                    yyarg[yycount++] = yytname_[yyx];
                }
          }
      }

    char const* yyformat = YY_NULLPTR;
    switch (yycount)
      {
#define YYCASE_(N, S)                         \
        case N:                               \
          yyformat = S;                       \
        break
        YYCASE_(0, YY_("syntax error"));
        YYCASE_(1, YY_("syntax error, unexpected %s"));
        YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
        YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
        YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
        YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
      }

    // Argument number.
    size_t yyi = 0;
    for (char const* yyp = yyformat; *yyp; ++yyp)
      if (yyp[0] == '%' && yyp[1] == 's' && yyi < yycount)
        {
          yyres += yytnamerr_ (yyarg[yyi++]);
          ++yyp;
        }
      else
        yyres += *yyp;
    return yyres;
  }


  const signed char parser::yypact_ninf_ = -123;

  const signed char parser::yytable_ninf_ = -25;

  const short int
  parser::yypact_[] =
  {
     175,   379,   176,   407,   414,     3,   -40,   460,  -123,  -123,
    -123,   467,   493,   521,   549,   577,   -26,  -123,  -123,  -123,
    -123,  -123,  -123,   160,  -123,   246,  -123,  1246,  1246,  1246,
    1246,  1246,  1246,  1246,  1246,  1246,  1246,  1246,  1246,  1246,
    1246,  -123,  -123,  -123,  -123,    17,   584,  -123,   467,  1245,
    -123,  -123,  -123,    65,  -123,  -123,  -123,  -123,  -123,   336,
    -123,   661,  -123,   689,  -123,  -123,  -123,   381,  -123,  -123,
      -4,    20,     6,   288,  -123,  -123,  -123,  -123,  -123,  -123,
    -123,  -123,  -123,  -123,   610,   638,   666,   694,  -123,   722,
     750,   778,   806,   834,   862,   890,   918,   946,   974,  1002,
    -123,  -123,  -123,  1246,  1246,  1246,  1246,  1246,  -123,  -123,
    -123,  1246,  1246,  1246,  1246,  1246,  -123,  -123,     4,  1214,
     313,  -123,    38,   -18,   -10,  -123,    40,    32,  -123,  1009,
    1035,  1061,  1087,  1113,  1139,  -123,  -123,    69,    99,   110,
    1165,  1191,  -123,  -123,  -123,  -123,  -123,  -123,     7,   430,
    -123,  -123,   717,   745,   773,   801,   829,   857,   885,  -123,
    -123,  -123,  -123,     8,  -123,  -123,  -123,  -123,    18,  -123,
    -123,  -123,  -123,  1354,  -123,  1354,  -123,  1354,  -123,  1354,
    -123,  1363,  -123,   231,  -123,   123,  -123,   123,  -123,  1354,
    -123,  1354,  -123,   202,  -123,   202,  -123,   202,  -123,   202,
    -123,   202,  -123,  -123,  -123,  -123,  -123,  -123,  -123,  -123,
    -123,  -123,  -123,  -123,  -123,  -123,  -123,  -123,   149,    67,
      75,  -123,  -123,  -123,  -123,  1310,  -123,  1331,  -123,  1321,
    -123,  1321,  -123,  1301,  -123,  1301,    83,    88,  -123,   103,
     102,  -123,   127,  -123,   -16,   189,   133,   122,  -123,  1251,
    -123,  1301,  -123,  -123,    16,  -123,  -123,  -123,   146,  -123,
     101,  -123,   162,  -123,   162,  -123,   261,  -123,   261,  -123,
    -123,  -123,  -123,  -123,  -123,   163,  -123,  -123,  -123,  -123,
    -123,  -123,  -123,  -123,   211,   208,   218,  -123,  -123,  -123,
    -123,  -123,   219,  -123,  -123,  -123
  };

  const unsigned char
  parser::yydefact_[] =
  {
       0,     0,     0,     0,     0,     0,     0,     0,    95,    94,
     169,     0,     0,     0,     0,     0,    54,    57,    58,    18,
       5,     3,   126,   158,   127,     0,   170,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   185,   186,    17,    15,     0,     0,    62,     0,     0,
      39,    40,    42,     0,    13,    11,    41,    77,    59,     0,
      61,     0,   103,     0,     9,     7,   102,     0,     1,    19,
       0,     0,     0,     0,   151,   150,   153,   152,   155,   154,
     157,   156,    56,    55,     0,     0,     0,     0,   160,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       2,     4,   171,     0,     0,     0,     0,     0,   177,   178,
     179,     0,     0,     0,     0,     0,    14,    16,     0,     0,
       0,    60,    25,     0,    20,    23,     0,     0,    43,     0,
       0,     0,     0,     0,     0,    46,    47,     0,     0,     0,
       0,     0,    10,    12,    81,    78,    79,    80,     0,     0,
     125,   124,     0,     0,     0,     0,     0,     0,     0,     6,
       8,    98,   101,     0,    96,    99,    90,    93,     0,    88,
     168,    91,   161,   159,   163,   162,   165,   164,   167,   166,
     135,   134,   137,   136,   129,   128,   131,   130,   139,   138,
     141,   140,   143,   142,   145,   144,   147,   146,   149,   148,
     133,   132,   172,   173,   174,   175,   176,   180,   181,   182,
     183,   184,    64,    66,    63,    65,    44,    30,    20,     0,
       0,    21,    29,    45,    72,    71,    83,    82,    68,    67,
      70,    69,    85,    84,    87,    86,    25,     0,    48,    25,
       0,    51,    25,    35,     0,    20,     0,     0,    74,    73,
      76,    75,   106,   109,     0,   104,   107,   117,   116,   119,
     118,   111,   110,   113,   112,   121,   120,   123,   122,   115,
     114,    97,   100,    89,    92,     0,    27,    28,    49,    50,
      52,    53,    37,    36,    20,     0,     0,    34,    38,   105,
     108,    26,     0,    32,    33,    31
  };

  const short int
  parser::yypgoto_[] =
  {
    -123,  -123,    70,    50,  -122,  -123,   -41,   -92,  -123,  -123,
     -59,  -123,  -123,     2,    66,    53,    10,   -29,    -5,   181
  };

  const short int
  parser::yydefgoto_[] =
  {
      -1,     5,    20,    21,   125,   126,   127,   128,   144,    56,
      57,   146,   147,    22,    59,    23,    24,    67,    25,    45
  };

  const short int
  parser::yytable_[] =
  {
     145,   219,    71,    68,   161,    58,    66,    75,    77,    79,
      81,    69,   212,    58,   145,   252,   271,   246,     6,   166,
     217,   163,   283,   218,   289,   284,    82,    83,   164,   220,
     221,   273,   149,    88,   151,    89,    90,    91,    92,    93,
      94,    95,    96,    97,    98,   238,   241,   162,    58,    99,
      58,    58,    44,    55,    65,   213,    60,   167,   253,   272,
     145,   145,   145,    66,    60,    66,   122,   290,   116,   274,
     236,   165,    43,    54,    64,   101,   216,    73,   222,   173,
     175,   177,   179,   223,   181,   183,   185,   187,   189,   191,
     193,   195,   197,   199,   201,   117,   237,   240,   247,    60,
     239,    60,    60,   -22,   123,   276,   124,   -22,   123,   143,
     124,   242,   119,   277,   120,   121,   -24,   160,   154,   155,
     -24,   278,   285,   258,   260,   262,   264,   266,   268,   270,
     158,    58,    58,    58,    58,    58,    58,   -22,   123,   279,
     124,   280,    58,    58,    95,    96,    97,    98,   243,   244,
     -24,   245,    99,   281,    66,    66,    66,    66,    66,    66,
      66,   -24,   153,   154,   155,   282,   145,     7,   145,     8,
     145,   287,   145,   288,   145,   158,   145,     6,     1,     2,
       3,     4,    60,    60,    60,    60,    60,    60,   275,   221,
     145,   158,   145,    60,    60,   225,   227,   229,   231,   233,
     235,   291,    84,    85,    86,    87,   249,   251,   102,   103,
     104,   105,   106,   107,   108,   109,   110,   111,   112,   113,
     114,   115,    26,    95,    96,    97,    98,    19,   286,   221,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,   293,     6,    91,    92,
     292,   221,    95,    96,    97,    98,   294,   295,     0,     0,
      99,    89,    90,    91,    92,    93,    94,    95,    96,    97,
      98,     0,     0,     0,     0,    99,   152,   153,   154,   155,
     156,   157,     0,     0,   202,   203,   204,   205,   206,   168,
     158,     0,   207,   208,   209,   210,   211,   100,     0,     0,
       0,   169,   170,   129,   130,   131,   132,   133,   134,     0,
       0,     0,     0,     0,   168,     0,     0,    50,    51,   135,
      52,   136,    53,   137,   138,   139,   169,     0,   129,   130,
     131,   132,   133,   134,     0,   140,   141,     6,     0,   171,
       0,     0,    50,    51,   135,    52,   136,    53,   137,   138,
     139,   129,   130,   131,   132,   133,   134,     0,     0,     0,
     140,   141,     0,     0,   171,    50,    51,   135,    52,   136,
      53,   137,   138,   139,     0,     0,     0,     0,     0,     0,
       6,     0,     6,   140,   141,     0,     7,   142,     8,     9,
      10,    11,     0,     0,     0,     0,   152,   153,   154,   155,
     156,   157,     0,     0,    12,    13,    14,    15,     6,     0,
     158,     0,     0,     0,    46,     6,    47,     9,     0,    48,
       0,    61,     0,    62,     0,    16,     0,     0,    17,    18,
      19,   254,   159,     0,     0,    49,    50,    51,   255,    52,
       0,    53,    63,     0,     0,   152,   153,   154,   155,   156,
     157,     0,     0,    16,     0,     0,    17,    18,    19,   158,
      16,    70,     0,    17,    18,    19,     0,     7,    72,     8,
       9,    10,    11,     0,    46,     0,    47,     9,     0,    48,
       0,   256,     0,     0,     0,    12,    13,    14,    15,     0,
       0,     0,     0,     0,    74,    49,    50,    51,     0,    52,
       7,    53,     8,     9,    10,    11,    16,     0,     0,    17,
      18,     0,     0,    16,     0,     0,    17,    18,    12,    13,
      14,    15,    76,     0,     0,     0,     0,     0,     7,     0,
       8,     9,    10,    11,     0,     0,     0,     0,     0,    16,
       0,     0,    17,    18,     0,     0,    12,    13,    14,    15,
      78,     0,     0,     0,     0,     0,     7,     0,     8,     9,
      10,    11,     0,     0,     0,     0,     0,    16,     0,     0,
      17,    18,     0,     0,    12,    13,    14,    15,    80,     0,
       0,     0,     0,     0,     7,   118,     8,     9,    10,    11,
       0,    46,     0,    47,     9,    16,    48,     0,    17,    18,
       0,     0,    12,    13,    14,    15,     0,     0,     0,     0,
       0,   172,    49,    50,    51,     0,    52,     7,    53,     8,
       9,    10,    11,    16,     0,     0,    17,    18,     0,     0,
      16,     0,     0,    17,    18,    12,    13,    14,    15,   174,
       0,     0,     0,     0,     0,     7,     0,     8,     9,    10,
      11,     0,     0,     0,     0,     0,    16,     0,     0,    17,
      18,     0,   148,    12,    13,    14,    15,   176,    61,     0,
      62,     0,     0,     7,     0,     8,     9,    10,    11,     0,
       0,     0,     0,     0,    16,     0,     0,    17,    18,    63,
     150,    12,    13,    14,    15,   178,    61,     0,    62,     0,
       0,     7,     0,     8,     9,    10,    11,    16,     0,     0,
      17,    18,    16,     0,     0,    17,    18,    63,   257,    12,
      13,    14,    15,   180,    61,     0,    62,     0,     0,     7,
       0,     8,     9,    10,    11,    16,     0,     0,    17,    18,
      16,     0,     0,    17,    18,    63,   259,    12,    13,    14,
      15,   182,    61,     0,    62,     0,     0,     7,     0,     8,
       9,    10,    11,    16,     0,     0,    17,    18,    16,     0,
       0,    17,    18,    63,   261,    12,    13,    14,    15,   184,
      61,     0,    62,     0,     0,     7,     0,     8,     9,    10,
      11,    16,     0,     0,    17,    18,    16,     0,     0,    17,
      18,    63,   263,    12,    13,    14,    15,   186,    61,     0,
      62,     0,     0,     7,     0,     8,     9,    10,    11,    16,
       0,     0,    17,    18,    16,     0,     0,    17,    18,    63,
     265,    12,    13,    14,    15,   188,    61,     0,    62,     0,
       0,     7,     0,     8,     9,    10,    11,    16,     0,     0,
      17,    18,    16,     0,     0,    17,    18,    63,   267,    12,
      13,    14,    15,   190,    61,     0,    62,     0,     0,     7,
       0,     8,     9,    10,    11,    16,     0,     0,    17,    18,
      16,     0,     0,    17,    18,    63,   269,    12,    13,    14,
      15,   192,    61,     0,    62,     0,     0,     7,     0,     8,
       9,    10,    11,    16,     0,     0,    17,    18,    16,     0,
       0,    17,    18,    63,     0,    12,    13,    14,    15,   194,
       0,     0,     0,     0,     0,     7,     0,     8,     9,    10,
      11,    16,     0,     0,    17,    18,    16,     0,     0,    17,
      18,     0,     0,    12,    13,    14,    15,   196,     0,     0,
       0,     0,     0,     7,     0,     8,     9,    10,    11,     0,
       0,     0,     0,     0,    16,     0,     0,    17,    18,     0,
       0,    12,    13,    14,    15,   198,     0,     0,     0,     0,
       0,     7,     0,     8,     9,    10,    11,     0,     0,     0,
       0,     0,    16,     0,     0,    17,    18,     0,     0,    12,
      13,    14,    15,   200,     0,     0,     0,     0,     0,     7,
     224,     8,     9,    10,    11,     0,    46,     0,    47,     9,
      16,    48,     0,    17,    18,     0,     0,    12,    13,    14,
      15,     0,     0,     0,     0,     0,   226,    49,    50,    51,
       0,    52,    46,    53,    47,     9,     0,    48,    16,     0,
       0,    17,    18,     0,     0,    16,     0,     0,    17,    18,
       0,     0,   228,    49,    50,    51,     0,    52,    46,    53,
      47,     9,     0,    48,     0,     0,     0,     0,     0,     0,
       0,    16,     0,     0,    17,    18,     0,     0,   230,    49,
      50,    51,     0,    52,    46,    53,    47,     9,     0,    48,
       0,     0,     0,     0,     0,     0,     0,    16,     0,     0,
      17,    18,     0,     0,   232,    49,    50,    51,     0,    52,
      46,    53,    47,     9,     0,    48,     0,     0,     0,     0,
       0,     0,     0,    16,     0,     0,    17,    18,     0,     0,
     234,    49,    50,    51,     0,    52,    46,    53,    47,     9,
       0,    48,     0,     0,     0,     0,     0,     0,     0,    16,
       0,     0,    17,    18,     0,     0,   248,    49,    50,    51,
       0,    52,    46,    53,    47,     9,     0,    48,     0,     0,
       0,     0,     0,     0,     0,    16,     0,     0,    17,    18,
       0,     0,   250,    49,    50,    51,     0,    52,    46,    53,
      47,     9,     0,    48,     0,     0,     0,     0,     0,     0,
       0,    16,     0,     0,    17,    18,     0,     0,     0,    49,
      50,    51,   214,    52,     0,    53,     0,     0,     0,   129,
     130,   131,   132,   133,   134,     0,     0,    16,     0,     0,
      17,    18,     0,    50,    51,   135,    52,   136,    53,   137,
     138,   139,    46,     0,    47,     9,     0,    48,     0,     0,
       0,   140,   141,     0,     0,   215,   129,   130,   131,   132,
     133,   134,     0,    49,    50,    51,     0,    52,     0,    53,
      50,    51,   135,    52,   136,    53,   137,   138,   139,     0,
       0,    16,    26,     0,    17,    18,     0,     0,     0,   141,
      27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    38,    39,    40,    41,    42,   129,   130,   131,   132,
     133,   134,     0,     0,     0,     0,   130,   131,   132,     0,
      50,    51,   135,    52,   136,    53,   137,   138,   139,    50,
      51,   135,    52,   136,    53,   137,   138,   139,   131,   132,
      50,    51,   135,    52,   136,    53,   137,   138,   139,     0,
      50,    51,   135,    52,   136,    53,   137,   138,   139,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    90,
      91,    92,     0,    99,    95,    96,    97,    98,     0,     0,
       0,     0,    99
  };

  const short int
  parser::yycheck_[] =
  {
      59,   123,     7,     0,     8,     3,     4,    12,    13,    14,
      15,    51,     8,    11,    73,     8,     8,   139,     1,    13,
      38,     1,    38,    41,     8,    41,    52,    53,     8,    39,
      40,    13,    61,    23,    63,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,   137,   138,    51,    46,    29,
      48,    49,     2,     3,     4,    51,     3,    51,    51,    51,
     119,   120,   121,    61,    11,    63,     1,    51,    51,    51,
       1,    51,     2,     3,     4,    25,    38,    11,    38,    84,
      85,    86,    87,    51,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,    45,   137,   138,   139,    46,
       1,    48,    49,    38,    39,    38,    41,    38,    39,    59,
      41,     1,    46,    38,    48,    49,    51,    67,    17,    18,
      51,    38,   244,   152,   153,   154,   155,   156,   157,   158,
      29,   129,   130,   131,   132,   133,   134,    38,    39,    51,
      41,    38,   140,   141,    21,    22,    23,    24,    38,    39,
      51,    41,    29,    51,   152,   153,   154,   155,   156,   157,
     158,    51,    16,    17,    18,    38,   225,     7,   227,     9,
     229,    38,   231,    51,   233,    29,   235,     1,     3,     4,
       5,     6,   129,   130,   131,   132,   133,   134,    39,    40,
     249,    29,   251,   140,   141,   129,   130,   131,   132,   133,
     134,    38,    42,    43,    44,    45,   140,   141,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      39,    40,    46,    21,    22,    23,    24,    51,    39,    40,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    38,     1,    17,    18,
      39,    40,    21,    22,    23,    24,    38,    38,    -1,    -1,
      29,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    -1,    -1,    -1,    -1,    29,    15,    16,    17,    18,
      19,    20,    -1,    -1,   103,   104,   105,   106,   107,     1,
      29,    -1,   111,   112,   113,   114,   115,    51,    -1,    -1,
      -1,    13,    14,    15,    16,    17,    18,    19,    20,    -1,
      -1,    -1,    -1,    -1,     1,    -1,    -1,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    13,    -1,    15,    16,
      17,    18,    19,    20,    -1,    47,    48,     1,    -1,    51,
      -1,    -1,    29,    30,    31,    32,    33,    34,    35,    36,
      37,    15,    16,    17,    18,    19,    20,    -1,    -1,    -1,
      47,    48,    -1,    -1,    51,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    -1,    -1,    -1,    -1,    -1,    -1,
       1,    -1,     1,    47,    48,    -1,     7,    51,     9,    10,
      11,    12,    -1,    -1,    -1,    -1,    15,    16,    17,    18,
      19,    20,    -1,    -1,    25,    26,    27,    28,     1,    -1,
      29,    -1,    -1,    -1,     7,     1,     9,    10,    -1,    12,
      -1,     7,    -1,     9,    -1,    46,    -1,    -1,    49,    50,
      51,     1,    51,    -1,    -1,    28,    29,    30,     8,    32,
      -1,    34,    28,    -1,    -1,    15,    16,    17,    18,    19,
      20,    -1,    -1,    46,    -1,    -1,    49,    50,    51,    29,
      46,     1,    -1,    49,    50,    51,    -1,     7,     1,     9,
      10,    11,    12,    -1,     7,    -1,     9,    10,    -1,    12,
      -1,    51,    -1,    -1,    -1,    25,    26,    27,    28,    -1,
      -1,    -1,    -1,    -1,     1,    28,    29,    30,    -1,    32,
       7,    34,     9,    10,    11,    12,    46,    -1,    -1,    49,
      50,    -1,    -1,    46,    -1,    -1,    49,    50,    25,    26,
      27,    28,     1,    -1,    -1,    -1,    -1,    -1,     7,    -1,
       9,    10,    11,    12,    -1,    -1,    -1,    -1,    -1,    46,
      -1,    -1,    49,    50,    -1,    -1,    25,    26,    27,    28,
       1,    -1,    -1,    -1,    -1,    -1,     7,    -1,     9,    10,
      11,    12,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,
      49,    50,    -1,    -1,    25,    26,    27,    28,     1,    -1,
      -1,    -1,    -1,    -1,     7,     1,     9,    10,    11,    12,
      -1,     7,    -1,     9,    10,    46,    12,    -1,    49,    50,
      -1,    -1,    25,    26,    27,    28,    -1,    -1,    -1,    -1,
      -1,     1,    28,    29,    30,    -1,    32,     7,    34,     9,
      10,    11,    12,    46,    -1,    -1,    49,    50,    -1,    -1,
      46,    -1,    -1,    49,    50,    25,    26,    27,    28,     1,
      -1,    -1,    -1,    -1,    -1,     7,    -1,     9,    10,    11,
      12,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,
      50,    -1,     1,    25,    26,    27,    28,     1,     7,    -1,
       9,    -1,    -1,     7,    -1,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,    28,
       1,    25,    26,    27,    28,     1,     7,    -1,     9,    -1,
      -1,     7,    -1,     9,    10,    11,    12,    46,    -1,    -1,
      49,    50,    46,    -1,    -1,    49,    50,    28,     1,    25,
      26,    27,    28,     1,     7,    -1,     9,    -1,    -1,     7,
      -1,     9,    10,    11,    12,    46,    -1,    -1,    49,    50,
      46,    -1,    -1,    49,    50,    28,     1,    25,    26,    27,
      28,     1,     7,    -1,     9,    -1,    -1,     7,    -1,     9,
      10,    11,    12,    46,    -1,    -1,    49,    50,    46,    -1,
      -1,    49,    50,    28,     1,    25,    26,    27,    28,     1,
       7,    -1,     9,    -1,    -1,     7,    -1,     9,    10,    11,
      12,    46,    -1,    -1,    49,    50,    46,    -1,    -1,    49,
      50,    28,     1,    25,    26,    27,    28,     1,     7,    -1,
       9,    -1,    -1,     7,    -1,     9,    10,    11,    12,    46,
      -1,    -1,    49,    50,    46,    -1,    -1,    49,    50,    28,
       1,    25,    26,    27,    28,     1,     7,    -1,     9,    -1,
      -1,     7,    -1,     9,    10,    11,    12,    46,    -1,    -1,
      49,    50,    46,    -1,    -1,    49,    50,    28,     1,    25,
      26,    27,    28,     1,     7,    -1,     9,    -1,    -1,     7,
      -1,     9,    10,    11,    12,    46,    -1,    -1,    49,    50,
      46,    -1,    -1,    49,    50,    28,     1,    25,    26,    27,
      28,     1,     7,    -1,     9,    -1,    -1,     7,    -1,     9,
      10,    11,    12,    46,    -1,    -1,    49,    50,    46,    -1,
      -1,    49,    50,    28,    -1,    25,    26,    27,    28,     1,
      -1,    -1,    -1,    -1,    -1,     7,    -1,     9,    10,    11,
      12,    46,    -1,    -1,    49,    50,    46,    -1,    -1,    49,
      50,    -1,    -1,    25,    26,    27,    28,     1,    -1,    -1,
      -1,    -1,    -1,     7,    -1,     9,    10,    11,    12,    -1,
      -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,    -1,
      -1,    25,    26,    27,    28,     1,    -1,    -1,    -1,    -1,
      -1,     7,    -1,     9,    10,    11,    12,    -1,    -1,    -1,
      -1,    -1,    46,    -1,    -1,    49,    50,    -1,    -1,    25,
      26,    27,    28,     1,    -1,    -1,    -1,    -1,    -1,     7,
       1,     9,    10,    11,    12,    -1,     7,    -1,     9,    10,
      46,    12,    -1,    49,    50,    -1,    -1,    25,    26,    27,
      28,    -1,    -1,    -1,    -1,    -1,     1,    28,    29,    30,
      -1,    32,     7,    34,     9,    10,    -1,    12,    46,    -1,
      -1,    49,    50,    -1,    -1,    46,    -1,    -1,    49,    50,
      -1,    -1,     1,    28,    29,    30,    -1,    32,     7,    34,
       9,    10,    -1,    12,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    46,    -1,    -1,    49,    50,    -1,    -1,     1,    28,
      29,    30,    -1,    32,     7,    34,     9,    10,    -1,    12,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,
      49,    50,    -1,    -1,     1,    28,    29,    30,    -1,    32,
       7,    34,     9,    10,    -1,    12,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    46,    -1,    -1,    49,    50,    -1,    -1,
       1,    28,    29,    30,    -1,    32,     7,    34,     9,    10,
      -1,    12,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    46,
      -1,    -1,    49,    50,    -1,    -1,     1,    28,    29,    30,
      -1,    32,     7,    34,     9,    10,    -1,    12,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    46,    -1,    -1,    49,    50,
      -1,    -1,     1,    28,    29,    30,    -1,    32,     7,    34,
       9,    10,    -1,    12,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    46,    -1,    -1,    49,    50,    -1,    -1,    -1,    28,
      29,    30,     8,    32,    -1,    34,    -1,    -1,    -1,    15,
      16,    17,    18,    19,    20,    -1,    -1,    46,    -1,    -1,
      49,    50,    -1,    29,    30,    31,    32,    33,    34,    35,
      36,    37,     7,    -1,     9,    10,    -1,    12,    -1,    -1,
      -1,    47,    48,    -1,    -1,    51,    15,    16,    17,    18,
      19,    20,    -1,    28,    29,    30,    -1,    32,    -1,    34,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    -1,
      -1,    46,    46,    -1,    49,    50,    -1,    -1,    -1,    48,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    15,    16,    17,    18,
      19,    20,    -1,    -1,    -1,    -1,    16,    17,    18,    -1,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    29,
      30,    31,    32,    33,    34,    35,    36,    37,    17,    18,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    -1,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    16,
      17,    18,    -1,    29,    21,    22,    23,    24,    -1,    -1,
      -1,    -1,    29
  };

  const unsigned char
  parser::yystos_[] =
  {
       0,     3,     4,     5,     6,    71,     1,     7,     9,    10,
      11,    12,    25,    26,    27,    28,    46,    49,    50,    51,
      72,    73,    83,    85,    86,    88,    46,    54,    55,    56,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    69,    72,    73,    89,     7,     9,    12,    28,
      29,    30,    32,    34,    72,    73,    79,    80,    83,    84,
      85,     7,     9,    28,    72,    73,    83,    87,     0,    51,
       1,    88,     1,    84,     1,    88,     1,    88,     1,    88,
       1,    88,    52,    53,    42,    43,    44,    45,    86,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    29,
      51,    73,    89,    89,    89,    89,    89,    89,    89,    89,
      89,    89,    89,    89,    89,    89,    51,    73,     1,    84,
      84,    84,     1,    39,    41,    74,    75,    76,    77,    15,
      16,    17,    18,    19,    20,    31,    33,    35,    36,    37,
      47,    48,    51,    73,    78,    80,    81,    82,     1,    87,
       1,    87,    15,    16,    17,    18,    19,    20,    29,    51,
      73,     8,    51,     1,     8,    51,    13,    51,     1,    13,
      14,    51,     1,    88,     1,    88,     1,    88,     1,    88,
       1,    88,     1,    88,     1,    88,     1,    88,     1,    88,
       1,    88,     1,    88,     1,    88,     1,    88,     1,    88,
       1,    88,    89,    89,    89,    89,    89,    89,    89,    89,
      89,    89,     8,    51,     8,    51,    38,    38,    41,    74,
      39,    40,    38,    51,     1,    84,     1,    84,     1,    84,
       1,    84,     1,    84,     1,    84,     1,    76,    77,     1,
      76,    77,     1,    38,    39,    41,    74,    76,     1,    84,
       1,    84,     8,    51,     1,     8,    51,     1,    87,     1,
      87,     1,    87,     1,    87,     1,    87,     1,    87,     1,
      87,     8,    51,    13,    51,    39,    38,    38,    38,    51,
      38,    51,    38,    38,    41,    74,    39,    38,    51,     8,
      51,    38,    39,    38,    38,    38
  };

  const unsigned char
  parser::yyr1_[] =
  {
       0,    70,    71,    71,    71,    71,    71,    71,    71,    71,
      71,    71,    71,    71,    71,    71,    71,    71,    72,    73,
      74,    74,    75,    75,    76,    76,    77,    77,    77,    77,
      77,    78,    78,    78,    78,    78,    78,    78,    78,    79,
      79,    80,    80,    80,    80,    80,    81,    81,    81,    81,
      81,    82,    82,    82,    83,    83,    83,    83,    83,    84,
      84,    84,    84,    84,    84,    84,    84,    84,    84,    84,
      84,    84,    84,    84,    84,    84,    84,    84,    84,    84,
      84,    84,    84,    84,    84,    84,    84,    84,    85,    85,
      85,    85,    85,    85,    85,    86,    86,    86,    86,    86,
      86,    86,    87,    87,    87,    87,    87,    87,    87,    87,
      87,    87,    87,    87,    87,    87,    87,    87,    87,    87,
      87,    87,    87,    87,    87,    87,    88,    88,    88,    88,
      88,    88,    88,    88,    88,    88,    88,    88,    88,    88,
      88,    88,    88,    88,    88,    88,    88,    88,    88,    88,
      88,    88,    88,    88,    88,    88,    88,    88,    88,    88,
      88,    88,    88,    88,    88,    88,    88,    88,    88,    88,
      89,    89,    89,    89,    89,    89,    89,    89,    89,    89,
      89,    89,    89,    89,    89,    89,    89
  };

  const unsigned char
  parser::yyr2_[] =
  {
       0,     2,     3,     2,     3,     2,     3,     2,     3,     2,
       3,     2,     3,     2,     3,     2,     3,     2,     1,     2,
       1,     2,     0,     1,     0,     1,     4,     3,     3,     2,
       2,     5,     4,     4,     3,     2,     3,     3,     3,     1,
       1,     1,     1,     2,     3,     3,     1,     1,     2,     3,
       3,     2,     3,     3,     1,     2,     2,     1,     1,     1,
       2,     1,     1,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     1,     2,     2,
       2,     2,     3,     3,     3,     3,     3,     3,     3,     4,
       3,     3,     4,     3,     1,     1,     3,     4,     3,     3,
       4,     3,     1,     1,     3,     4,     3,     3,     4,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     2,     2,     1,     1,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       2,     2,     2,     2,     2,     2,     2,     2,     1,     3,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     1,
       1,     2,     3,     3,     3,     3,     3,     2,     2,     2,
       3,     3,     3,     3,     3,     1,     1
  };



  // YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
  // First, the terminals, then, starting at \a yyntokens_, nonterminals.
  const char*
  const parser::yytname_[] =
  {
  "$end", "error", "$undefined", "\"LTL start marker\"",
  "\"LBT start marker\"", "\"SERE start marker\"",
  "\"BOOLEAN start marker\"", "\"opening parenthesis\"",
  "\"closing parenthesis\"", "\"(...) block\"", "\"{...} block\"",
  "\"{...}! block\"", "\"opening brace\"", "\"closing brace\"",
  "\"closing brace-bang\"", "\"or operator\"", "\"xor operator\"",
  "\"and operator\"", "\"short and operator\"", "\"implication operator\"",
  "\"equivalent operator\"", "\"until operator\"", "\"release operator\"",
  "\"weak until operator\"", "\"strong release operator\"",
  "\"sometimes operator\"", "\"always operator\"", "\"next operator\"",
  "\"not operator\"", "\"star operator\"", "\"bracket star operator\"",
  "\"bracket fusion-star operator\"", "\"plus operator\"",
  "\"fusion-plus operator\"", "\"opening bracket for star operator\"",
  "\"opening bracket for fusion-star operator\"",
  "\"opening bracket for equal operator\"",
  "\"opening bracket for goto operator\"", "\"closing bracket\"",
  "\"number for square bracket operator\"", "\"unbounded mark\"",
  "\"separator for square bracket operator\"",
  "\"universal concat operator\"", "\"existential concat operator\"",
  "\"universal non-overlapping concat operator\"",
  "\"existential non-overlapping concat operator\"",
  "\"atomic proposition\"", "\"concat operator\"", "\"fusion operator\"",
  "\"constant true\"", "\"constant false\"", "\"end of formula\"",
  "\"negative suffix\"", "\"positive suffix\"", "'!'", "'&'", "'|'", "'^'",
  "'i'", "'e'", "'X'", "'F'", "'G'", "'U'", "'V'", "'R'", "'W'", "'M'",
  "'t'", "'f'", "$accept", "result", "emptyinput", "enderror",
  "OP_SQBKT_SEP_unbounded", "OP_SQBKT_SEP_opt", "error_opt",
  "sqbracketargs", "gotoargs", "kleen_star", "starargs", "fstarargs",
  "equalargs", "booleanatom", "sere", "bracedsere",
  "parenthesedsubformula", "boolformula", "subformula", "lbtformula", YY_NULLPTR
  };

#if YYDEBUG
  const unsigned short int
  parser::yyrline_[] =
  {
       0,   245,   245,   250,   255,   260,   262,   267,   272,   277,
     279,   284,   289,   294,   296,   301,   306,   311,   314,   320,
     326,   326,   327,   327,   328,   328,   331,   333,   335,   337,
     339,   343,   345,   347,   349,   351,   353,   355,   358,   363,
     363,   365,   367,   369,   371,   374,   378,   380,   382,   384,
     388,   393,   395,   398,   404,   421,   438,   456,   458,   461,
     462,   478,   479,   489,   491,   497,   501,   507,   509,   512,
     514,   517,   519,   521,   523,   525,   527,   529,   538,   547,
     556,   579,   602,   628,   630,   650,   652,   678,   681,   683,
     687,   692,   697,   702,   708,   718,   727,   729,   733,   738,
     742,   747,   755,   756,   765,   767,   771,   776,   781,   786,
     792,   794,   796,   798,   800,   802,   804,   806,   808,   810,
     812,   814,   816,   818,   820,   822,   825,   826,   827,   829,
     831,   833,   835,   837,   839,   841,   843,   845,   847,   849,
     851,   853,   855,   857,   859,   861,   863,   865,   867,   869,
     871,   873,   875,   877,   879,   881,   883,   885,   887,   889,
     891,   893,   896,   898,   902,   907,   911,   916,   920,   923,
     934,   951,   953,   955,   957,   959,   961,   963,   965,   967,
     969,   971,   973,   975,   977,   979,   981
  };

  // Print the state stack on the debug stream.
  void
  parser::yystack_print_ ()
  {
    *yycdebug_ << "Stack now";
    for (stack_type::const_iterator
           i = yystack_.begin (),
           i_end = yystack_.end ();
         i != i_end; ++i)
      *yycdebug_ << ' ' << i->state;
    *yycdebug_ << std::endl;
  }

  // Report on the debug stream that the rule \a yyrule is going to be reduced.
  void
  parser::yy_reduce_print_ (int yyrule)
  {
    unsigned int yylno = yyrline_[yyrule];
    int yynrhs = yyr2_[yyrule];
    // Print the symbols being reduced, and their result.
    *yycdebug_ << "Reducing stack by rule " << yyrule - 1
               << " (line " << yylno << "):" << std::endl;
    // The symbols being reduced.
    for (int yyi = 0; yyi < yynrhs; yyi++)
      YY_SYMBOL_PRINT ("   $" << yyi + 1 << " =",
                       yystack_[(yynrhs) - (yyi + 1)]);
  }
#endif // YYDEBUG

  // Symbol number corresponding to token number t.
  inline
  parser::token_number_type
  parser::yytranslate_ (int t)
  {
    static
    const token_number_type
    translate_table[] =
    {
     0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    54,     2,     2,     2,     2,    55,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      61,    62,     2,     2,     2,     2,     2,    67,     2,     2,
       2,     2,    65,     2,     2,    63,    64,    66,    60,     2,
       2,     2,     2,     2,    57,     2,     2,     2,     2,     2,
       2,    59,    69,     2,     2,    58,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,    68,     2,     2,     2,
       2,     2,     2,     2,    56,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53
    };
    const unsigned int user_token_number_max_ = 308;
    const token_number_type undef_token_ = 2;

    if (static_cast<int>(t) <= yyeof_)
      return yyeof_;
    else if (static_cast<unsigned int> (t) <= user_token_number_max_)
      return translate_table[t];
    else
      return undef_token_;
  }


} // tlyy
#line 3151 "parsetl.cc" // lalr1.cc:1155
#line 985 "parsetl.yy" // lalr1.cc:1156


void
tlyy::parser::error(const location_type& location, const std::string& message)
{
  error_list.emplace_back(location, message);
}

namespace spot
{
  parsed_formula
  parse_infix_psl(const std::string& ltl_string,
		  environment& env,
		  bool debug, bool lenient)
  {
    parsed_formula result(ltl_string);
    flex_set_buffer(ltl_string,
		    tlyy::parser::token::START_LTL,
		    lenient);
    tlyy::parser parser(result.errors, env, result.f);
    parser.set_debug_level(debug);
    parser.parse();
    flex_unset_buffer();
    return result;
  }

  parsed_formula
  parse_infix_boolean(const std::string& ltl_string,
		      environment& env,
		      bool debug, bool lenient)
  {
    parsed_formula result(ltl_string);
    flex_set_buffer(ltl_string,
		    tlyy::parser::token::START_BOOL,
		    lenient);
    tlyy::parser parser(result.errors, env, result.f);
    parser.set_debug_level(debug);
    parser.parse();
    flex_unset_buffer();
    return result;
  }

  parsed_formula
  parse_prefix_ltl(const std::string& ltl_string,
		   environment& env,
		   bool debug)
  {
    parsed_formula result(ltl_string);
    flex_set_buffer(ltl_string,
		    tlyy::parser::token::START_LBT,
		    false);
    tlyy::parser parser(result.errors, env, result.f);
    parser.set_debug_level(debug);
    parser.parse();
    flex_unset_buffer();
    return result;
  }

  parsed_formula
  parse_infix_sere(const std::string& sere_string,
		   environment& env,
		   bool debug,
		   bool lenient)
  {
    parsed_formula result(sere_string);
    flex_set_buffer(sere_string,
		    tlyy::parser::token::START_SERE,
		    lenient);
    tlyy::parser parser(result.errors, env, result.f);
    parser.set_debug_level(debug);
    parser.parse();
    flex_unset_buffer();
    return result;
  }

  formula
  parse_formula(const std::string& ltl_string, environment& env)
  {
    parsed_formula pf = parse_infix_psl(ltl_string, env);
    std::ostringstream s;
    if (pf.format_errors(s))
      {
	parsed_formula pg = parse_prefix_ltl(ltl_string, env);
	if (pg.errors.empty())
	  return pg.f;
	else
	  throw parse_error(s.str());
      }
    return pf.f;
  }
}

// Local Variables:
// mode: c++
// End:
