<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>
<tagfile>
  <compound kind="file">
    <name>parseaut.hh</name>
    <path>/build/spot/spot/parseaut/</path>
    <filename>parseaut_8hh</filename>
    <class kind="struct">hoayy_support::result_</class>
    <class kind="struct">hoayy_support::result_::state_info</class>
    <class kind="struct">hoayy_support::result_::prop_info</class>
    <class kind="class">hoayy::parser</class>
    <class kind="union">hoayy::parser::semantic_type</class>
    <class kind="struct">hoayy::parser::syntax_error</class>
    <class kind="struct">hoayy::parser::token</class>
    <class kind="struct">hoayy::parser::basic_symbol</class>
    <class kind="struct">hoayy::parser::by_type</class>
  </compound>
  <compound kind="file">
    <name>parsetl.hh</name>
    <path>/build/spot/spot/parsetl/</path>
    <filename>parsetl_8hh</filename>
    <includes id="formula_8hh" name="formula.hh" local="no" imported="no">spot/tl/formula.hh</includes>
    <class kind="struct">minmax_t</class>
    <class kind="class">tlyy::parser</class>
    <class kind="union">tlyy::parser::semantic_type</class>
    <class kind="struct">tlyy::parser::syntax_error</class>
    <class kind="struct">tlyy::parser::token</class>
    <class kind="struct">tlyy::parser::basic_symbol</class>
    <class kind="struct">tlyy::parser::by_type</class>
  </compound>
  <compound kind="file">
    <name>formula.hh</name>
    <path>/build/spot/spot/tl/</path>
    <filename>formula_8hh</filename>
    <class kind="class">spot::fnode</class>
    <class kind="struct">spot::formula_ptr_less_than_bool_first</class>
    <class kind="class">spot::formula</class>
    <class kind="class">spot::formula::formula_child_iterator</class>
    <class kind="struct">std::hash&lt; spot::formula &gt;</class>
    <member kind="enumeration">
      <type></type>
      <name>op</name>
      <anchorfile>group__tl__essentials.html</anchorfile>
      <anchor>ga770300a8f53109afba0868269371e442</anchor>
      <arglist></arglist>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a633de4b0c14ca52ea2432a3c8a5c4c31">ff</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442aaccc9105df5383111407fd5b41255e23">tt</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442ad2b875464b1dbe5f78c6adbb289c098d">eword</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a62c428533830d84fd8bc77bf402512fc">ap</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442aa74c05d080620f087c4e523977230666">Not</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a02129bb861061d1a052c592e2dc6b383">X</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a800618943025315f869e4e1f09471012">F</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442adfcf28d0734569a6a693bc8194de62bf">G</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442aaf4bb376939e77df0e7c2332b837a866">Closure</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a49b896944db944beb13a670a7b626824">NegClosure</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a6d8ef00a66fa645c3788efa3cab843a5">NegClosureMarked</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a76feb79109026728a20736a8c6504548">Xor</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442aef634d4bb5af5448f6c1d9c786ab63fe">Implies</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a405b480b56dd17b4829251e904d51417">Equiv</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a4c614360da93c0a041b22e537de151eb">U</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442ae1e1d3d40573127e9ee0480caf1283d6">R</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a61e9c06ea9a85a5088a499df6458d276">W</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a69691c7bdcc3ce6d5d8a1361f22d04ac">M</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a580f3581efb595b2ee46b3f1e9f3d380">EConcat</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a15264d76946af4c2832500762655fba5">EConcatMarked</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a3163428cfb5853cb11d4c5bfa2384b7a">UConcat</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a3a2d5fe857d8f9541136a124c2edec6c">Or</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a9284c10af2accfe937ea66f1af92f97e">OrRat</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442ac33315685a0cba3ce53be378b3c7874b">And</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442adac487087bfcbf63bd1139d3eec72e9e">AndRat</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442ac4ad0c8da839d549728bf3d3f67d02b8">AndNLM</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442ae20f0f2826a6549809f050b86274567f">Concat</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442aadc69293e8fd256b2609664f1e11cb53">Fusion</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a26f93e6e68e28a698377e941cb59f29a">Star</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a605a2a5c6dc4d5e2c026ee1467af4073">FStar</enumvalue>
    </member>
  </compound>
  <compound kind="group">
    <name>misc_tools</name>
    <title>Miscellaneous helper functions</title>
    <filename>group__misc__tools.html</filename>
    <subgroup>hash_funcs</subgroup>
    <subgroup>random</subgroup>
    <class kind="struct">spot::bdd_less_than</class>
    <class kind="struct">spot::bdd_hash</class>
    <class kind="struct">spot::char_ptr_less_than</class>
    <class kind="class">spot::minato_isop</class>
    <class kind="class">spot::option_map</class>
    <class kind="struct">spot::stopwatch</class>
    <class kind="class">spot::temporary_file</class>
    <class kind="class">spot::trival</class>
    <member kind="function">
      <type>const char *</type>
      <name>version</name>
      <anchorfile>group__misc__tools.html</anchorfile>
      <anchor>ga85c83eb1d18703782d129dbe4a518fca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_bare_word</name>
      <anchorfile>group__misc__tools.html</anchorfile>
      <anchor>gaae6fadac6a2f91d7b8e27b3eb6ad647e</anchor>
      <arglist>(const char *str)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>quote_unless_bare_word</name>
      <anchorfile>group__misc__tools.html</anchorfile>
      <anchor>ga4731f21b7b43332b5c7b5bc63c6d67e6</anchor>
      <arglist>(const std::string &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_spin_ap</name>
      <anchorfile>group__misc__tools.html</anchorfile>
      <anchor>gab2c9c9f65ad822c5dee5443cb4467c8e</anchor>
      <arglist>(const char *str)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>escape_rfc4180</name>
      <anchorfile>group__misc__tools.html</anchorfile>
      <anchor>gaf73a29efffe9d1b2cf376a97f65dcc1a</anchor>
      <arglist>(std::ostream &amp;os, const std::string &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>escape_latex</name>
      <anchorfile>group__misc__tools.html</anchorfile>
      <anchor>ga679d5dc83a7262d09a39e3232e07c57f</anchor>
      <arglist>(std::ostream &amp;os, const std::string &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>escape_html</name>
      <anchorfile>group__misc__tools.html</anchorfile>
      <anchor>gae959d25b2c55674bb5f3fa92e8d3b059</anchor>
      <arglist>(std::ostream &amp;os, const std::string &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>escape_str</name>
      <anchorfile>group__misc__tools.html</anchorfile>
      <anchor>ga84a8b196e2ec651f0fd039c70c7ff6cb</anchor>
      <arglist>(std::ostream &amp;os, const std::string &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>escape_str</name>
      <anchorfile>group__misc__tools.html</anchorfile>
      <anchor>gad4b0b4fae7b93db7d704a5fef6e021c6</anchor>
      <arglist>(const std::string &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>quote_shell_string</name>
      <anchorfile>group__misc__tools.html</anchorfile>
      <anchor>gaad8c0d04c0c1647677756e5ee20cf8f0</anchor>
      <arglist>(std::ostream &amp;os, const char *str)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>int_array_array_compress2</name>
      <anchorfile>group__misc__tools.html</anchorfile>
      <anchor>ga5253b7b9fd60f3285091b39a1f1b815d</anchor>
      <arglist>(const int *array, size_t n, int *dest, size_t &amp;dest_size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>int_array_array_decompress2</name>
      <anchorfile>group__misc__tools.html</anchorfile>
      <anchor>gaed78e6934b190995ba5a162ad0e76560</anchor>
      <arglist>(const int *array, size_t array_size, int *res, size_t size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>int_vector_vector_compress</name>
      <anchorfile>group__misc__tools.html</anchorfile>
      <anchor>ga86ac44d535ef8f28e5d81a2edf907065</anchor>
      <arglist>(const std::vector&lt; int &gt; &amp;input, std::vector&lt; unsigned int &gt; &amp;output)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>int_vector_vector_decompress</name>
      <anchorfile>group__misc__tools.html</anchorfile>
      <anchor>gade72f3d754ef89b594db989893ee3e7b</anchor>
      <arglist>(const std::vector&lt; unsigned int &gt; &amp;array, std::vector&lt; int &gt; &amp;output, size_t size)</arglist>
    </member>
    <member kind="function">
      <type>const std::vector&lt; unsigned int &gt; *</type>
      <name>int_array_vector_compress</name>
      <anchorfile>group__misc__tools.html</anchorfile>
      <anchor>gae8556060f7963410dd8c52d2426d7269</anchor>
      <arglist>(const int *array, size_t n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>int_vector_array_decompress</name>
      <anchorfile>group__misc__tools.html</anchorfile>
      <anchor>ga6c161d70b36c5637b6511f2192f2d9bf</anchor>
      <arglist>(const std::vector&lt; unsigned int &gt; *array, int *res, size_t size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>int_array_array_compress</name>
      <anchorfile>group__misc__tools.html</anchorfile>
      <anchor>ga72a6bb80b592f562634a6bd8aedd9ff6</anchor>
      <arglist>(const int *array, size_t n, int *dest, size_t &amp;dest_size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>int_array_array_decompress</name>
      <anchorfile>group__misc__tools.html</anchorfile>
      <anchor>gad595c02553de6187297d09d2b47c995c</anchor>
      <arglist>(const int *array, size_t array_size, int *res, size_t size)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>hash_funcs</name>
    <title>Hashing functions</title>
    <filename>group__hash__funcs.html</filename>
    <class kind="struct">spot::ptr_hash</class>
    <class kind="struct">spot::identity_hash</class>
    <class kind="struct">spot::state_ptr_hash</class>
    <class kind="struct">spot::state_shared_ptr_hash</class>
    <member kind="typedef">
      <type>std::hash&lt; std::string &gt;</type>
      <name>string_hash</name>
      <anchorfile>group__hash__funcs.html</anchorfile>
      <anchor>ga9e084716c663a3de1ad67a201dffd483</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>wang32_hash</name>
      <anchorfile>group__hash__funcs.html</anchorfile>
      <anchor>ga9422ff0c16df957910dd4a0275d9f726</anchor>
      <arglist>(size_t key)</arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>knuth32_hash</name>
      <anchorfile>group__hash__funcs.html</anchorfile>
      <anchor>gaea94dbea4a286b0bde253baf07e7a56e</anchor>
      <arglist>(size_t key)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>random</name>
    <title>Random functions</title>
    <filename>group__random.html</filename>
    <member kind="function">
      <type>void</type>
      <name>srand</name>
      <anchorfile>group__random.html</anchorfile>
      <anchor>ga539812ab355a561fee1ecbfe60b276e4</anchor>
      <arglist>(unsigned int seed)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rrand</name>
      <anchorfile>group__random.html</anchorfile>
      <anchor>ga86ce713fe60de9af440a7331de74aa1a</anchor>
      <arglist>(int min, int max)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mrand</name>
      <anchorfile>group__random.html</anchorfile>
      <anchor>gafe8da996f40caa7d188f6b408ae62904</anchor>
      <arglist>(int max)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>drand</name>
      <anchorfile>group__random.html</anchorfile>
      <anchor>ga42801cd81368df5c1c61aa1626e299ff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>nrand</name>
      <anchorfile>group__random.html</anchorfile>
      <anchor>ga978e1c6fb8f447274a05ddd3f87ce58b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>bmrand</name>
      <anchorfile>group__random.html</anchorfile>
      <anchor>ga0130217a19e5156f796ab774dca4b08c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>prand</name>
      <anchorfile>group__random.html</anchorfile>
      <anchor>ga816b558a7c64daca3a2a018704377dac</anchor>
      <arglist>(double p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mrandom_shuffle</name>
      <anchorfile>group__random.html</anchorfile>
      <anchor>gad59703ea48f6e9e2fd4995d0c9c64df8</anchor>
      <arglist>(iterator_type &amp;&amp;first, iterator_type &amp;&amp;last)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>ta</name>
    <title>TA (Testing Automata)</title>
    <filename>group__ta.html</filename>
    <subgroup>ta_essentials</subgroup>
    <subgroup>ta_representation</subgroup>
    <subgroup>ta_algorithms</subgroup>
  </compound>
  <compound kind="group">
    <name>tl</name>
    <title>Temporal Logic</title>
    <filename>group__tl.html</filename>
    <subgroup>tl_essentials</subgroup>
    <subgroup>tl_io</subgroup>
    <subgroup>tl_rewriting</subgroup>
    <subgroup>tl_misc</subgroup>
  </compound>
  <compound kind="group">
    <name>twa</name>
    <title>TωA (Transition-based ω-Automata)</title>
    <filename>group__twa.html</filename>
    <subgroup>kripke</subgroup>
    <subgroup>twa_essentials</subgroup>
    <subgroup>twa_representation</subgroup>
    <subgroup>twa_algorithms</subgroup>
  </compound>
  <compound kind="group">
    <name>kripke</name>
    <title>Kripke Structures</title>
    <filename>group__kripke.html</filename>
    <class kind="class">spot::fair_kripke_succ_iterator</class>
    <class kind="class">spot::fair_kripke</class>
    <class kind="class">spot::kripke_succ_iterator</class>
    <class kind="class">spot::kripke</class>
  </compound>
  <compound kind="group">
    <name>twa_io</name>
    <title>Input/Output of TωA</title>
    <filename>group__twa__io.html</filename>
    <class kind="struct">spot::parsed_aut</class>
    <class kind="struct">spot::automaton_parser_options</class>
    <class kind="class">spot::automaton_stream_parser</class>
    <member kind="typedef">
      <type>std::pair&lt; spot::location, std::string &gt;</type>
      <name>parse_aut_error</name>
      <anchorfile>group__twa__io.html</anchorfile>
      <anchor>gaf57f3520c892161c4197ee71960443ca</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; parse_aut_error &gt;</type>
      <name>parse_aut_error_list</name>
      <anchorfile>group__twa__io.html</anchorfile>
      <anchor>ga0d5b2f9769b968431172d37f587a2329</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>parsed_aut_ptr</type>
      <name>parse_aut</name>
      <anchorfile>group__twa__io.html</anchorfile>
      <anchor>ga7ddd70d2b02e1234814a2f7fa6afe052</anchor>
      <arglist>(const std::string &amp;filename, const bdd_dict_ptr &amp;dict, environment &amp;env=default_environment::instance(), automaton_parser_options opts={})</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>print_dot</name>
      <anchorfile>group__twa__io.html</anchorfile>
      <anchor>ga58dcb4c038a9c20f88139848ee4e2f0d</anchor>
      <arglist>(std::ostream &amp;os, const const_twa_ptr &amp;g, const char *options=nullptr)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>print_hoa</name>
      <anchorfile>group__twa__io.html</anchorfile>
      <anchor>gaf5fb4262f7a46d100bc1a7975d44586f</anchor>
      <arglist>(std::ostream &amp;os, const const_twa_ptr &amp;g, const char *opt=nullptr)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>print_lbtt</name>
      <anchorfile>group__twa__io.html</anchorfile>
      <anchor>ga0c63491369437ff718af540220040461</anchor>
      <arglist>(std::ostream &amp;os, const const_twa_ptr &amp;g, const char *opt=nullptr)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>print_never_claim</name>
      <anchorfile>group__twa__io.html</anchorfile>
      <anchor>gad759a198ae9e5ae2f58db4f11f43f1d1</anchor>
      <arglist>(std::ostream &amp;os, const const_twa_ptr &amp;g, const char *opt=nullptr)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>ta_essentials</name>
    <title>Essential TA types</title>
    <filename>group__ta__essentials.html</filename>
    <class kind="class">spot::ta</class>
    <class kind="class">spot::ta_succ_iterator</class>
    <class kind="class">spot::tgta</class>
  </compound>
  <compound kind="group">
    <name>ta_representation</name>
    <title>TA representations</title>
    <filename>group__ta__representation.html</filename>
    <class kind="class">spot::ta_explicit</class>
    <class kind="class">spot::state_ta_explicit</class>
    <class kind="struct">spot::state_ta_explicit::transition</class>
    <class kind="class">spot::tgta_explicit</class>
  </compound>
  <compound kind="group">
    <name>ta_algorithms</name>
    <title>TA algorithms</title>
    <filename>group__ta__algorithms.html</filename>
    <subgroup>ta_io</subgroup>
    <subgroup>tgba_ta</subgroup>
    <subgroup>ta_generic</subgroup>
    <subgroup>ta_reduction</subgroup>
    <subgroup>ta_misc</subgroup>
    <subgroup>ta_emptiness_check</subgroup>
  </compound>
  <compound kind="group">
    <name>ta_io</name>
    <title>Input/Output of TA</title>
    <filename>group__ta__io.html</filename>
  </compound>
  <compound kind="group">
    <name>tgba_ta</name>
    <title>Transforming TGBA into TA</title>
    <filename>group__tgba__ta.html</filename>
    <member kind="function">
      <type>ta_explicit_ptr</type>
      <name>tgba_to_ta</name>
      <anchorfile>group__tgba__ta.html</anchorfile>
      <anchor>gad8018db50c89a2618e99072e54a2a400</anchor>
      <arglist>(const const_twa_ptr &amp;tgba_to_convert, bdd atomic_propositions_set, bool degeneralized=true, bool artificial_initial_state_mode=true, bool single_pass_emptiness_check=false, bool artificial_livelock_state_mode=false, bool no_livelock=false)</arglist>
    </member>
    <member kind="function">
      <type>tgta_explicit_ptr</type>
      <name>tgba_to_tgta</name>
      <anchorfile>group__tgba__ta.html</anchorfile>
      <anchor>ga83d0c1c4fa63d0fab745d08949d7746f</anchor>
      <arglist>(const const_twa_ptr &amp;tgba_to_convert, bdd atomic_propositions_set)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>ta_generic</name>
    <title>Algorithm patterns</title>
    <filename>group__ta__generic.html</filename>
    <class kind="class">spot::ta_reachable_iterator</class>
    <class kind="class">spot::ta_reachable_iterator_depth_first</class>
    <class kind="class">spot::ta_reachable_iterator_breadth_first</class>
  </compound>
  <compound kind="group">
    <name>ta_reduction</name>
    <title>TA simplifications</title>
    <filename>group__ta__reduction.html</filename>
    <member kind="function">
      <type>ta_explicit_ptr</type>
      <name>minimize_ta</name>
      <anchorfile>group__ta__reduction.html</anchorfile>
      <anchor>ga35537bd3daf5f2d9ad8cf8fcfd5779db</anchor>
      <arglist>(const const_ta_ptr &amp;ta_)</arglist>
    </member>
    <member kind="function">
      <type>tgta_explicit_ptr</type>
      <name>minimize_tgta</name>
      <anchorfile>group__ta__reduction.html</anchorfile>
      <anchor>ga2186d83718c40248cb5a3827c1c28797</anchor>
      <arglist>(const const_tgta_explicit_ptr &amp;tgta_)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>ta_misc</name>
    <title>Miscellaneous algorithms on TA</title>
    <filename>group__ta__misc.html</filename>
    <class kind="struct">spot::ta_statistics</class>
    <member kind="function">
      <type>ta_statistics</type>
      <name>stats_reachable</name>
      <anchorfile>group__ta__misc.html</anchorfile>
      <anchor>gaa81c227ad2b88a19b984369ccee77461</anchor>
      <arglist>(const const_ta_ptr &amp;t)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>ta_emptiness_check</name>
    <title>Emptiness-checks</title>
    <filename>group__ta__emptiness__check.html</filename>
    <subgroup>ta_emptiness_check_algorithms</subgroup>
    <class kind="class">spot::state_ta_product</class>
    <class kind="class">spot::ta_product</class>
  </compound>
  <compound kind="group">
    <name>ta_emptiness_check_algorithms</name>
    <title>Emptiness-check algorithms</title>
    <filename>group__ta__emptiness__check__algorithms.html</filename>
  </compound>
  <compound kind="group">
    <name>tl_misc</name>
    <title>Miscellaneous Algorithms for Formulas</title>
    <filename>group__tl__misc.html</filename>
    <member kind="typedef">
      <type>std::set&lt; formula &gt;</type>
      <name>atomic_prop_set</name>
      <anchorfile>group__tl__misc.html</anchorfile>
      <anchor>gac7ad1babcd9452273eb0aa18ef34bfab</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>atomic_prop_set</type>
      <name>create_atomic_prop_set</name>
      <anchorfile>group__tl__misc.html</anchorfile>
      <anchor>ga1e5dc35c5d41a135c17ade246111f0fb</anchor>
      <arglist>(unsigned n)</arglist>
    </member>
    <member kind="function">
      <type>atomic_prop_set *</type>
      <name>atomic_prop_collect</name>
      <anchorfile>group__tl__misc.html</anchorfile>
      <anchor>ga10d99d88d084d657ddba2bb69f22e75b</anchor>
      <arglist>(formula f, atomic_prop_set *s=nullptr)</arglist>
    </member>
    <member kind="function">
      <type>bdd</type>
      <name>atomic_prop_collect_as_bdd</name>
      <anchorfile>group__tl__misc.html</anchorfile>
      <anchor>ga4eba46a65ee958dabf02d1d80d993072</anchor>
      <arglist>(formula f, const twa_ptr &amp;a)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>length</name>
      <anchorfile>group__tl__misc.html</anchorfile>
      <anchor>ga42c6508f1df9741dd3c40a1f9f79400b</anchor>
      <arglist>(formula f)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>length_boolone</name>
      <anchorfile>group__tl__misc.html</anchorfile>
      <anchor>ga5a214e3392fc66d1f9449202f777fe58</anchor>
      <arglist>(formula f)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>tl_essentials</name>
    <title>Essential Temporal Logic Types</title>
    <filename>group__tl__essentials.html</filename>
    <class kind="class">spot::formula</class>
    <class kind="class">spot::formula::formula_child_iterator</class>
    <member kind="enumeration">
      <type></type>
      <name>op</name>
      <anchorfile>group__tl__essentials.html</anchorfile>
      <anchor>ga770300a8f53109afba0868269371e442</anchor>
      <arglist></arglist>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a633de4b0c14ca52ea2432a3c8a5c4c31">ff</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442aaccc9105df5383111407fd5b41255e23">tt</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442ad2b875464b1dbe5f78c6adbb289c098d">eword</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a62c428533830d84fd8bc77bf402512fc">ap</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442aa74c05d080620f087c4e523977230666">Not</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a02129bb861061d1a052c592e2dc6b383">X</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a800618943025315f869e4e1f09471012">F</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442adfcf28d0734569a6a693bc8194de62bf">G</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442aaf4bb376939e77df0e7c2332b837a866">Closure</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a49b896944db944beb13a670a7b626824">NegClosure</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a6d8ef00a66fa645c3788efa3cab843a5">NegClosureMarked</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a76feb79109026728a20736a8c6504548">Xor</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442aef634d4bb5af5448f6c1d9c786ab63fe">Implies</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a405b480b56dd17b4829251e904d51417">Equiv</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a4c614360da93c0a041b22e537de151eb">U</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442ae1e1d3d40573127e9ee0480caf1283d6">R</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a61e9c06ea9a85a5088a499df6458d276">W</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a69691c7bdcc3ce6d5d8a1361f22d04ac">M</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a580f3581efb595b2ee46b3f1e9f3d380">EConcat</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a15264d76946af4c2832500762655fba5">EConcatMarked</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a3163428cfb5853cb11d4c5bfa2384b7a">UConcat</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a3a2d5fe857d8f9541136a124c2edec6c">Or</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a9284c10af2accfe937ea66f1af92f97e">OrRat</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442ac33315685a0cba3ce53be378b3c7874b">And</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442adac487087bfcbf63bd1139d3eec72e9e">AndRat</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442ac4ad0c8da839d549728bf3d3f67d02b8">AndNLM</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442ae20f0f2826a6549809f050b86274567f">Concat</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442aadc69293e8fd256b2609664f1e11cb53">Fusion</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a26f93e6e68e28a698377e941cb59f29a">Star</enumvalue>
      <enumvalue file="group__tl__essentials.html" anchor="gga770300a8f53109afba0868269371e442a605a2a5c6dc4d5e2c026ee1467af4073">FStar</enumvalue>
    </member>
  </compound>
  <compound kind="group">
    <name>tl_io</name>
    <title>Input and Output of Formulas</title>
    <filename>group__tl__io.html</filename>
    <class kind="struct">spot::parsed_formula</class>
    <class kind="class">spot::random_formula</class>
    <class kind="struct">spot::random_formula::op_proba</class>
    <class kind="class">spot::random_ltl</class>
    <class kind="class">spot::random_boolean</class>
    <class kind="class">spot::random_sere</class>
    <class kind="class">spot::random_psl</class>
    <member kind="typedef">
      <type>std::pair&lt; location, std::string &gt;</type>
      <name>one_parse_error</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>ga2e7a9441c463fd30ddea7f707a2f6c45</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::list&lt; one_parse_error &gt;</type>
      <name>parse_error_list</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>gaf647a52f0450d0e1b42b7f4fbd31ec9f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>print_dot_psl</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>gae19ac563945e5cf3478d2acb63a17005</anchor>
      <arglist>(std::ostream &amp;os, formula f)</arglist>
    </member>
    <member kind="function">
      <type>parsed_formula</type>
      <name>parse_infix_psl</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>gadf461e56ae02af07eada0b081aca019d</anchor>
      <arglist>(const std::string &amp;ltl_string, environment &amp;env=default_environment::instance(), bool debug=false, bool lenient=false)</arglist>
    </member>
    <member kind="function">
      <type>parsed_formula</type>
      <name>parse_infix_boolean</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>ga289478b9929eb5231570aa393a349901</anchor>
      <arglist>(const std::string &amp;ltl_string, environment &amp;env=default_environment::instance(), bool debug=false, bool lenient=false)</arglist>
    </member>
    <member kind="function">
      <type>parsed_formula</type>
      <name>parse_prefix_ltl</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>ga94b5ed9d7ec12d265ac4de123a4e9b5c</anchor>
      <arglist>(const std::string &amp;ltl_string, environment &amp;env=default_environment::instance(), bool debug=false)</arglist>
    </member>
    <member kind="function">
      <type>formula</type>
      <name>parse_formula</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>gaac89abbef7d72e9bccd11a43bc38823c</anchor>
      <arglist>(const std::string &amp;ltl_string, environment &amp;env=default_environment::instance())</arglist>
    </member>
    <member kind="function">
      <type>parsed_formula</type>
      <name>parse_infix_sere</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>gad589b14c8934214420560a5bc6a5b80e</anchor>
      <arglist>(const std::string &amp;sere_string, environment &amp;env=default_environment::instance(), bool debug=false, bool lenient=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fix_utf8_locations</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>gaec46efb9a97eedb90c824abced64a1bf</anchor>
      <arglist>(const std::string &amp;input_string, parse_error_list &amp;error_list)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>print_psl</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>gac1909c7c0ab3505fc23ad90377b45eee</anchor>
      <arglist>(std::ostream &amp;os, formula f, bool full_parent=false)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>str_psl</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>gaf5e8cd2ee25525ea437348144387ad7e</anchor>
      <arglist>(formula f, bool full_parent=false)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>print_utf8_psl</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>ga9b2c240ad9bc6321aa1bf50c1f2c2d55</anchor>
      <arglist>(std::ostream &amp;os, formula f, bool full_parent=false)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>str_utf8_psl</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>ga6f35405fad8b2e798d4fd755450c573e</anchor>
      <arglist>(formula f, bool full_parent=false)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>print_sere</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>ga928fc60d694c57a4bf28370c5b53f432</anchor>
      <arglist>(std::ostream &amp;os, formula f, bool full_parent=false)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>str_sere</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>ga2bd0fbba3d12fa30549fb84fe8fa6b53</anchor>
      <arglist>(formula f, bool full_parent=false)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>print_utf8_sere</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>gaf7c7218a6bfb6fefcfa7a6ef832b1e18</anchor>
      <arglist>(std::ostream &amp;os, formula f, bool full_parent=false)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>str_utf8_sere</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>gaac308d047e8b57045de12db529aec2c2</anchor>
      <arglist>(formula f, bool full_parent=false)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>print_spin_ltl</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>ga9f8ab6ecb27cf3db99fba5655eaa184f</anchor>
      <arglist>(std::ostream &amp;os, formula f, bool full_parent=false)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>str_spin_ltl</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>ga909be94c7d2f509c27a93e1ed2bab447</anchor>
      <arglist>(formula f, bool full_parent=false)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>print_wring_ltl</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>gadf28d343e4fe44c1f191de839e075cbc</anchor>
      <arglist>(std::ostream &amp;os, formula f)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>str_wring_ltl</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>gab9ec5a9602e1b7f656e7432ca202db34</anchor>
      <arglist>(formula f)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>print_latex_psl</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>ga87edef920c1aa94dee80c15eac0353b9</anchor>
      <arglist>(std::ostream &amp;os, formula f, bool full_parent=false)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>str_latex_psl</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>gabea4ddcf26a0bb9af1a3d09d60209540</anchor>
      <arglist>(formula f, bool full_parent=false)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>print_latex_sere</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>gaa799448ca8fd32e12852f128a4193f79</anchor>
      <arglist>(std::ostream &amp;os, formula f, bool full_parent=false)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>str_latex_sere</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>ga3244959de065ac3fb8146567146c2740</anchor>
      <arglist>(formula f, bool full_parent=false)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>print_sclatex_psl</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>gad5f4551a08874343bca15245039895f2</anchor>
      <arglist>(std::ostream &amp;os, formula f, bool full_parent=false)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>str_sclatex_psl</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>gabb4b3fb4ba6a9144361aa13c02a07d28</anchor>
      <arglist>(formula f, bool full_parent=false)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>print_sclatex_sere</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>ga6685d7987d462fbaed3826d2329d041d</anchor>
      <arglist>(std::ostream &amp;os, formula f, bool full_parent=false)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>str_sclatex_sere</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>ga77e9e425e19da9766ead16141cf2ae0a</anchor>
      <arglist>(formula f, bool full_parent=false)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>print_lbt_ltl</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>ga7a0a47f9b8c7c410210bb1daccbada54</anchor>
      <arglist>(std::ostream &amp;os, formula f)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>str_lbt_ltl</name>
      <anchorfile>group__tl__io.html</anchorfile>
      <anchor>ga232a1cc3c42618ce2a4e732c654c96c1</anchor>
      <arglist>(formula f)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>tl_rewriting</name>
    <title>Rewriting Algorithms for Formulas</title>
    <filename>group__tl__rewriting.html</filename>
    <class kind="class">spot::tl_simplifier</class>
    <class kind="class">spot::unabbreviator</class>
    <member kind="function">
      <type>formula</type>
      <name>mark_concat_ops</name>
      <anchorfile>group__tl__rewriting.html</anchorfile>
      <anchor>gae55a5d2bcb08fa6cd5ef3acf5087e578</anchor>
      <arglist>(formula f)</arglist>
    </member>
    <member kind="function">
      <type>formula</type>
      <name>negative_normal_form</name>
      <anchorfile>group__tl__rewriting.html</anchorfile>
      <anchor>gac3eedb942a2f74a57b36f22d3b1dee6d</anchor>
      <arglist>(formula f, bool negated=false)</arglist>
    </member>
    <member kind="function">
      <type>formula</type>
      <name>relabel</name>
      <anchorfile>group__tl__rewriting.html</anchorfile>
      <anchor>ga9c3fd68661d5312cd4bdb09ba69d8ba8</anchor>
      <arglist>(formula f, relabeling_style style, relabeling_map *m=nullptr)</arglist>
    </member>
    <member kind="function">
      <type>formula</type>
      <name>relabel_bse</name>
      <anchorfile>group__tl__rewriting.html</anchorfile>
      <anchor>gabb67c5e4031288d03a3bf95fa1597e57</anchor>
      <arglist>(formula f, relabeling_style style, relabeling_map *m=nullptr)</arglist>
    </member>
    <member kind="function">
      <type>formula</type>
      <name>unabbreviate</name>
      <anchorfile>group__tl__rewriting.html</anchorfile>
      <anchor>gafc353f999ab1bab155def38d1a2b4c04</anchor>
      <arglist>(formula in, const char *opt=default_unabbrev_string)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>twa_essentials</name>
    <title>Essential TωA types</title>
    <filename>group__twa__essentials.html</filename>
    <class kind="class">spot::bdd_dict</class>
    <class kind="struct">spot::bdd_dict::bdd_info</class>
    <class kind="class">spot::state</class>
    <class kind="struct">spot::state_ptr_less_than</class>
    <class kind="struct">spot::state_ptr_equal</class>
    <class kind="struct">spot::state_ptr_hash</class>
    <class kind="class">spot::state_unicity_table</class>
    <class kind="struct">spot::state_shared_ptr_less_than</class>
    <class kind="struct">spot::state_shared_ptr_equal</class>
    <class kind="struct">spot::state_shared_ptr_hash</class>
    <class kind="class">spot::twa_succ_iterator</class>
    <class kind="class">spot::twa</class>
    <class kind="struct">spot::twa::prop_set</class>
  </compound>
  <compound kind="group">
    <name>twa_representation</name>
    <title>TωA representations</title>
    <filename>group__twa__representation.html</filename>
  </compound>
  <compound kind="group">
    <name>twa_algorithms</name>
    <title>TωA algorithms</title>
    <filename>group__twa__algorithms.html</filename>
    <subgroup>twa_on_the_fly_algorithms</subgroup>
    <subgroup>twa_io</subgroup>
    <subgroup>twa_ltl</subgroup>
    <subgroup>twa_generic</subgroup>
    <subgroup>twa_reduction</subgroup>
    <subgroup>twa_misc</subgroup>
    <subgroup>emptiness_check</subgroup>
    <member kind="function">
      <type>twa_graph_ptr</type>
      <name>tgba_determinize</name>
      <anchorfile>group__twa__algorithms.html</anchorfile>
      <anchor>gab76611c2c0190972d38569eedd318a8a</anchor>
      <arglist>(const const_twa_graph_ptr &amp;aut, bool pretty_print=false, bool use_scc=true, bool use_simulation=true, bool use_stutter=true)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>twa_on_the_fly_algorithms</name>
    <title>TωA on-the-fly algorithms</title>
    <filename>group__twa__on__the__fly__algorithms.html</filename>
    <class kind="class">spot::state_product</class>
  </compound>
  <compound kind="group">
    <name>twa_ltl</name>
    <title>Translating LTL formulas into TωA</title>
    <filename>group__twa__ltl.html</filename>
    <class kind="class">spot::translator</class>
    <member kind="function">
      <type>taa_tgba_formula_ptr</type>
      <name>ltl_to_taa</name>
      <anchorfile>group__twa__ltl.html</anchorfile>
      <anchor>gad6f4600d264a6df21f0abcb9a7afdde3</anchor>
      <arglist>(formula f, const bdd_dict_ptr &amp;dict, bool refined_rules=false)</arglist>
    </member>
    <member kind="function">
      <type>twa_graph_ptr</type>
      <name>ltl_to_tgba_fm</name>
      <anchorfile>group__twa__ltl.html</anchorfile>
      <anchor>gafd4b8ecd68be3352e4d647044b4b7d39</anchor>
      <arglist>(formula f, const bdd_dict_ptr &amp;dict, bool exprop=false, bool symb_merge=true, bool branching_postponement=false, bool fair_loop_approx=false, const atomic_prop_set *unobs=nullptr, tl_simplifier *simplifier=nullptr, bool unambiguous=false)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>twa_generic</name>
    <title>Algorithm patterns</title>
    <filename>group__twa__generic.html</filename>
    <class kind="class">spot::twa_reachable_iterator</class>
    <class kind="class">spot::twa_reachable_iterator_breadth_first</class>
    <class kind="class">spot::twa_reachable_iterator_depth_first</class>
    <class kind="struct">spot::twa_reachable_iterator_depth_first::stack_item</class>
    <class kind="class">spot::twa_reachable_iterator_depth_first_stack</class>
  </compound>
  <compound kind="group">
    <name>twa_reduction</name>
    <title>TωA simplifications</title>
    <filename>group__twa__reduction.html</filename>
    <class kind="class">spot::postprocessor</class>
    <member kind="function">
      <type>twa_graph_ptr</type>
      <name>minimize_monitor</name>
      <anchorfile>group__twa__reduction.html</anchorfile>
      <anchor>ga70b93116665f790576e529d2927314d7</anchor>
      <arglist>(const const_twa_graph_ptr &amp;a)</arglist>
    </member>
    <member kind="function">
      <type>twa_graph_ptr</type>
      <name>minimize_wdba</name>
      <anchorfile>group__twa__reduction.html</anchorfile>
      <anchor>ga7b7b1e1792a03e186a3ca639f33978c9</anchor>
      <arglist>(const const_twa_graph_ptr &amp;a)</arglist>
    </member>
    <member kind="function">
      <type>twa_graph_ptr</type>
      <name>minimize_obligation</name>
      <anchorfile>group__twa__reduction.html</anchorfile>
      <anchor>ga543d045266fb429908041c15cee4fb83</anchor>
      <arglist>(const const_twa_graph_ptr &amp;aut_f, formula f=nullptr, const_twa_graph_ptr aut_neg_f=nullptr, bool reject_bigger=false)</arglist>
    </member>
    <member kind="function">
      <type>twa_graph_ptr</type>
      <name>simulation</name>
      <anchorfile>group__twa__reduction.html</anchorfile>
      <anchor>ga5b03bdcc14d765feb878aa437b845acd</anchor>
      <arglist>(const const_twa_graph_ptr &amp;automaton)</arglist>
    </member>
    <member kind="function">
      <type>twa_graph_ptr</type>
      <name>cosimulation</name>
      <anchorfile>group__twa__reduction.html</anchorfile>
      <anchor>ga348e7ea8d6c137cb1eb3776917790429</anchor>
      <arglist>(const const_twa_graph_ptr &amp;automaton)</arglist>
    </member>
    <member kind="function">
      <type>twa_graph_ptr</type>
      <name>cosimulation_sba</name>
      <anchorfile>group__twa__reduction.html</anchorfile>
      <anchor>gab63cf71f9f0b570b2c27ce6c76075eff</anchor>
      <arglist>(const const_twa_graph_ptr &amp;automaton)</arglist>
    </member>
    <member kind="function">
      <type>twa_graph_ptr</type>
      <name>iterated_simulations</name>
      <anchorfile>group__twa__reduction.html</anchorfile>
      <anchor>ga015e8cafa7602f8bef1954dbb698a237</anchor>
      <arglist>(const const_twa_graph_ptr &amp;automaton)</arglist>
    </member>
    <member kind="function">
      <type>twa_graph_ptr</type>
      <name>iterated_simulations_sba</name>
      <anchorfile>group__twa__reduction.html</anchorfile>
      <anchor>ga28224796930acb24af1f415e28335bac</anchor>
      <arglist>(const const_twa_graph_ptr &amp;automaton)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>twa_misc</name>
    <title>Miscellaneous algorithms on TωA</title>
    <filename>group__twa__misc.html</filename>
    <class kind="class">spot::bfs_steps</class>
    <class kind="struct">spot::twa_statistics</class>
    <class kind="struct">spot::twa_sub_statistics</class>
    <class kind="class">spot::printable_formula</class>
    <class kind="class">spot::stat_printer</class>
    <member kind="function">
      <type>bool</type>
      <name>is_isomorphic</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>ga1517671dae9e24214418ab565b516257</anchor>
      <arglist>(const const_twa_graph_ptr aut)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>are_isomorphic</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>ga0e1216c4bd264ac030492a3489295e54</anchor>
      <arglist>(const const_twa_graph_ptr ref, const const_twa_graph_ptr aut)</arglist>
    </member>
    <member kind="function">
      <type>twa_graph_ptr</type>
      <name>canonicalize</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>ga1a76bf3168f004d7da9d6751d1d28ef1</anchor>
      <arglist>(twa_graph_ptr aut)</arglist>
    </member>
    <member kind="function">
      <type>twa_graph_ptr</type>
      <name>copy</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>ga3aa1148298030a7e027ce1258db7e0f9</anchor>
      <arglist>(const const_twa_ptr &amp;aut, twa::prop_set p, bool preserve_names=false, unsigned max_states=-1U)</arglist>
    </member>
    <member kind="function">
      <type>twa_graph_ptr</type>
      <name>degeneralize</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>ga2532a4fef7c9b7c26d3c59b3bf2edb8f</anchor>
      <arglist>(const const_twa_graph_ptr &amp;a, bool use_z_lvl=true, bool use_cust_acc_orders=false, int use_lvl_cache=1, bool skip_levels=true, bool ignaccsl=false)</arglist>
    </member>
    <member kind="function">
      <type>unsigned</type>
      <name>count_nondet_states</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>ga2c8177a46547417e339a9b30dffc103f</anchor>
      <arglist>(const const_twa_graph_ptr &amp;aut)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_deterministic</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>ga18dece4cedaec6211534bf6251a42648</anchor>
      <arglist>(const const_twa_graph_ptr &amp;aut)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>highlight_nondet_states</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>gacdb9c7127211cac77e8d1f04f2edbb1a</anchor>
      <arglist>(twa_graph_ptr &amp;aut, unsigned color)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>highlight_nondet_edges</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>ga4dbb4eb1ad02368da796fc32d6da633a</anchor>
      <arglist>(twa_graph_ptr &amp;aut, unsigned color)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_unambiguous</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>ga81729f55d9927e57cc5cda0ee10e2721</anchor>
      <arglist>(const const_twa_graph_ptr &amp;aut)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>check_unambiguous</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>ga94dd8a9d93434af080cbdf17b19d2ad4</anchor>
      <arglist>(const twa_graph_ptr &amp;aut)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>scc_has_rejecting_cycle</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>ga1d6c074906652b7d96d93a1aa7ad192d</anchor>
      <arglist>(scc_info &amp;map, unsigned scc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_inherently_weak_scc</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>gaf4867080f33ce1eab0e13030ac198098</anchor>
      <arglist>(scc_info &amp;map, unsigned scc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_weak_scc</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>gadc7e390f2570b79fe4bc365ecad7704c</anchor>
      <arglist>(scc_info &amp;map, unsigned scc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_complete_scc</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>gab99e2e804df5916d51ef0ba03e40da3c</anchor>
      <arglist>(scc_info &amp;map, unsigned scc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_terminal_scc</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>ga9516954d0b2cc6b3072cb60cfeb1933b</anchor>
      <arglist>(scc_info &amp;map, unsigned scc)</arglist>
    </member>
    <member kind="function">
      <type>twa_graph_ptr</type>
      <name>random_graph</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>ga39cf0138551ca959003240124c5956cb</anchor>
      <arglist>(int n, float d, const atomic_prop_set *ap, const bdd_dict_ptr &amp;dict, unsigned n_accs=0, float a=0.1, float t=0.5, bool deterministic=false, bool state_acc=false, bool colored=false)</arglist>
    </member>
    <member kind="function">
      <type>twa_statistics</type>
      <name>stats_reachable</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>ga9ee1795ccf7880f19003d047dddc2276</anchor>
      <arglist>(const const_twa_ptr &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>twa_sub_statistics</type>
      <name>sub_stats_reachable</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>gae7d3a6cd02025bcfe67487b8e7eedc98</anchor>
      <arglist>(const const_twa_ptr &amp;g)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>strip_acceptance_here</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>ga2095ba23baa14b20a4f995713e2326cb</anchor>
      <arglist>(twa_graph_ptr a)</arglist>
    </member>
    <member kind="function">
      <type>twa_graph_ptr</type>
      <name>tgba_powerset</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>ga89dc339aaff3e1aa63dee0ce6f3b7957</anchor>
      <arglist>(const const_twa_graph_ptr &amp;aut, power_map &amp;pm, bool merge=true)</arglist>
    </member>
    <member kind="function">
      <type>twa_graph_ptr</type>
      <name>tgba_powerset</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>ga8d8654d1b175b4b06cc5f1083e621e10</anchor>
      <arglist>(const const_twa_graph_ptr &amp;aut)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>emptiness_check</name>
    <title>Emptiness-checks</title>
    <filename>group__emptiness__check.html</filename>
    <subgroup>emptiness_check_algorithms</subgroup>
    <subgroup>twa_run</subgroup>
    <subgroup>emptiness_check_stats</subgroup>
    <class kind="class">spot::emptiness_check_result</class>
    <class kind="class">spot::emptiness_check</class>
    <class kind="class">spot::emptiness_check_instantiator</class>
    <member kind="function">
      <type>emptiness_check_instantiator_ptr</type>
      <name>make_emptiness_check_instantiator</name>
      <anchorfile>group__emptiness__check.html</anchorfile>
      <anchor>gad299fa630e42713e43cb5a5f38f63eb8</anchor>
      <arglist>(const char *name, const char **err)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>emptiness_check_algorithms</name>
    <title>Emptiness-check algorithms</title>
    <filename>group__emptiness__check__algorithms.html</filename>
    <class kind="class">spot::couvreur99_check</class>
    <class kind="class">spot::couvreur99_check_shy</class>
    <class kind="struct">spot::couvreur99_check_shy::successor</class>
    <class kind="struct">spot::couvreur99_check_shy::todo_item</class>
    <member kind="function">
      <type>emptiness_check_ptr</type>
      <name>couvreur99</name>
      <anchorfile>group__emptiness__check__algorithms.html</anchorfile>
      <anchor>ga026a0e3dd5dc257c97de8d75fb015bac</anchor>
      <arglist>(const const_twa_ptr &amp;a, option_map options=option_map())</arglist>
    </member>
    <member kind="function">
      <type>emptiness_check_ptr</type>
      <name>explicit_gv04_check</name>
      <anchorfile>group__emptiness__check__algorithms.html</anchorfile>
      <anchor>gac3e72fafbf92d4ebdf2d75190fb5cadb</anchor>
      <arglist>(const const_twa_ptr &amp;a, option_map o=option_map())</arglist>
    </member>
    <member kind="function">
      <type>emptiness_check_ptr</type>
      <name>explicit_magic_search</name>
      <anchorfile>group__emptiness__check__algorithms.html</anchorfile>
      <anchor>ga8fda77b1ad04eed2b48d155d5f18b1a8</anchor>
      <arglist>(const const_twa_ptr &amp;a, option_map o=option_map())</arglist>
    </member>
    <member kind="function">
      <type>emptiness_check_ptr</type>
      <name>bit_state_hashing_magic_search</name>
      <anchorfile>group__emptiness__check__algorithms.html</anchorfile>
      <anchor>gae9abf939edf6d063b06b99592afc6ff8</anchor>
      <arglist>(const const_twa_ptr &amp;a, size_t size, option_map o=option_map())</arglist>
    </member>
    <member kind="function">
      <type>emptiness_check_ptr</type>
      <name>magic_search</name>
      <anchorfile>group__emptiness__check__algorithms.html</anchorfile>
      <anchor>ga3572fd66b5f82cb52b8f3e5e520193a5</anchor>
      <arglist>(const const_twa_ptr &amp;a, option_map o=option_map())</arglist>
    </member>
    <member kind="function">
      <type>emptiness_check_ptr</type>
      <name>explicit_se05_search</name>
      <anchorfile>group__emptiness__check__algorithms.html</anchorfile>
      <anchor>ga71b8fba396e979d5ced58189e5bb791a</anchor>
      <arglist>(const const_twa_ptr &amp;a, option_map o=option_map())</arglist>
    </member>
    <member kind="function">
      <type>emptiness_check_ptr</type>
      <name>bit_state_hashing_se05_search</name>
      <anchorfile>group__emptiness__check__algorithms.html</anchorfile>
      <anchor>ga6da2c32f18c0764841a5accc56454e15</anchor>
      <arglist>(const const_twa_ptr &amp;a, size_t size, option_map o=option_map())</arglist>
    </member>
    <member kind="function">
      <type>emptiness_check_ptr</type>
      <name>se05</name>
      <anchorfile>group__emptiness__check__algorithms.html</anchorfile>
      <anchor>ga148336dbc6ed66c4557366aadbddc723</anchor>
      <arglist>(const const_twa_ptr &amp;a, option_map o)</arglist>
    </member>
    <member kind="function">
      <type>emptiness_check_ptr</type>
      <name>explicit_tau03_search</name>
      <anchorfile>group__emptiness__check__algorithms.html</anchorfile>
      <anchor>ga505e4650e4a161ded68c66a8fc343398</anchor>
      <arglist>(const const_twa_ptr &amp;a, option_map o=option_map())</arglist>
    </member>
    <member kind="function">
      <type>emptiness_check_ptr</type>
      <name>explicit_tau03_opt_search</name>
      <anchorfile>group__emptiness__check__algorithms.html</anchorfile>
      <anchor>ga4f0b66268cf3c5af23ca513672353ce9</anchor>
      <arglist>(const const_twa_ptr &amp;a, option_map o=option_map())</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>twa_run</name>
    <title>TωA runs and supporting functions</title>
    <filename>group__twa__run.html</filename>
    <class kind="struct">spot::twa_run</class>
    <class kind="struct">spot::twa_run::step</class>
  </compound>
  <compound kind="group">
    <name>emptiness_check_stats</name>
    <title>Emptiness-check statistics</title>
    <filename>group__emptiness__check__stats.html</filename>
    <class kind="struct">spot::unsigned_statistics</class>
    <class kind="class">spot::unsigned_statistics_copy</class>
    <class kind="class">spot::ec_statistics</class>
    <class kind="class">spot::ars_statistics</class>
    <class kind="class">spot::acss_statistics</class>
  </compound>
  <compound kind="struct">
    <name>minmax_t</name>
    <filename>structminmax__t.html</filename>
  </compound>
  <compound kind="class">
    <name>hoayy::parser</name>
    <filename>classhoayy_1_1parser.html</filename>
    <class kind="struct">hoayy::parser::basic_symbol</class>
    <class kind="struct">hoayy::parser::by_type</class>
    <class kind="union">hoayy::parser::semantic_type</class>
    <class kind="struct">hoayy::parser::syntax_error</class>
    <class kind="struct">hoayy::parser::token</class>
    <member kind="typedef">
      <type>spot::location</type>
      <name>location_type</name>
      <anchorfile>classhoayy_1_1parser.html</anchorfile>
      <anchor>a7ae2d389718dc438202707c829319f7c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>token::yytokentype</type>
      <name>token_type</name>
      <anchorfile>classhoayy_1_1parser.html</anchorfile>
      <anchor>a66a4de560df0ce611b8752c7a4a8e932</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>symbol_number_type</name>
      <anchorfile>classhoayy_1_1parser.html</anchorfile>
      <anchor>a93f607e148ba621da50c6a5ddd0d97b4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>unsigned char</type>
      <name>token_number_type</name>
      <anchorfile>classhoayy_1_1parser.html</anchorfile>
      <anchor>ab967aad4c9489a115598d2f4f2781b66</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_symbol&lt; by_type &gt;</type>
      <name>symbol_type</name>
      <anchorfile>classhoayy_1_1parser.html</anchorfile>
      <anchor>a750a06563abd48390cece0aed8b87411</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>debug_level_type</name>
      <anchorfile>classhoayy_1_1parser.html</anchorfile>
      <anchor>abe89d0775770f7329589922d85e5a2a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>parser</name>
      <anchorfile>classhoayy_1_1parser.html</anchorfile>
      <anchor>a252339486a1f27cbc4414497468976b1</anchor>
      <arglist>(result_ &amp;res_yyarg, spot::location initial_loc_yyarg)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>parse</name>
      <anchorfile>classhoayy_1_1parser.html</anchorfile>
      <anchor>a953e0b0aa2a74f86cffbebe4ebf828e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>debug_stream</name>
      <anchorfile>classhoayy_1_1parser.html</anchorfile>
      <anchor>a14bd2f0cc80abe77707cd4683aed35a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_debug_stream</name>
      <anchorfile>classhoayy_1_1parser.html</anchorfile>
      <anchor>a845520f9e1eb738f2a45e3e192264e51</anchor>
      <arglist>(std::ostream &amp;)</arglist>
    </member>
    <member kind="function">
      <type>debug_level_type</type>
      <name>debug_level</name>
      <anchorfile>classhoayy_1_1parser.html</anchorfile>
      <anchor>a96e8dc71c12d88903d64b7247caf5091</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_debug_level</name>
      <anchorfile>classhoayy_1_1parser.html</anchorfile>
      <anchor>ae37002a25ba4cb0f198d011e1c1adb6d</anchor>
      <arglist>(debug_level_type l)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>error</name>
      <anchorfile>classhoayy_1_1parser.html</anchorfile>
      <anchor>aee3b2cb886c031a5b875240a033c6209</anchor>
      <arglist>(const location_type &amp;loc, const std::string &amp;msg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>error</name>
      <anchorfile>classhoayy_1_1parser.html</anchorfile>
      <anchor>a23dd7f426ae1035dccc9caa263421d98</anchor>
      <arglist>(const syntax_error &amp;err)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>hoayy::parser::basic_symbol</name>
    <filename>structhoayy_1_1parser_1_1basic__symbol.html</filename>
    <templarg>Base</templarg>
    <member kind="typedef">
      <type>Base</type>
      <name>super_type</name>
      <anchorfile>structhoayy_1_1parser_1_1basic__symbol.html</anchorfile>
      <anchor>a1baec4dd0a9af7fcec41641cc5ba04cf</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>basic_symbol</name>
      <anchorfile>structhoayy_1_1parser_1_1basic__symbol.html</anchorfile>
      <anchor>a38aeb5d1b5421c3d50d2e774236eae91</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>basic_symbol</name>
      <anchorfile>structhoayy_1_1parser_1_1basic__symbol.html</anchorfile>
      <anchor>a9486f360726442b35de26209f91d213f</anchor>
      <arglist>(const basic_symbol &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>basic_symbol</name>
      <anchorfile>structhoayy_1_1parser_1_1basic__symbol.html</anchorfile>
      <anchor>a7400b376ab51cfdc3beaa7aaa0d38a5f</anchor>
      <arglist>(typename Base::kind_type t, const location_type &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>basic_symbol</name>
      <anchorfile>structhoayy_1_1parser_1_1basic__symbol.html</anchorfile>
      <anchor>adae0954b6579110610e9dc464075b901</anchor>
      <arglist>(typename Base::kind_type t, const semantic_type &amp;v, const location_type &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>move</name>
      <anchorfile>structhoayy_1_1parser_1_1basic__symbol.html</anchorfile>
      <anchor>a8c7084839a00bb96b98da338ae96d2da</anchor>
      <arglist>(basic_symbol &amp;s)</arglist>
    </member>
    <member kind="variable">
      <type>semantic_type</type>
      <name>value</name>
      <anchorfile>structhoayy_1_1parser_1_1basic__symbol.html</anchorfile>
      <anchor>aa008f995fbf279fb8f55df69498745d8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>location_type</type>
      <name>location</name>
      <anchorfile>structhoayy_1_1parser_1_1basic__symbol.html</anchorfile>
      <anchor>a384f0d6669dad830f48bc54997f240c8</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>hoayy::parser::by_type</name>
    <filename>structhoayy_1_1parser_1_1by__type.html</filename>
    <member kind="typedef">
      <type>token_type</type>
      <name>kind_type</name>
      <anchorfile>structhoayy_1_1parser_1_1by__type.html</anchorfile>
      <anchor>a22572fd13e1e44f55e438cba1433bd87</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>by_type</name>
      <anchorfile>structhoayy_1_1parser_1_1by__type.html</anchorfile>
      <anchor>a1da9ba5d805117d81531baf61c9484c4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>by_type</name>
      <anchorfile>structhoayy_1_1parser_1_1by__type.html</anchorfile>
      <anchor>a5f37a02014cd2aa93d761e7947af5243</anchor>
      <arglist>(const by_type &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>by_type</name>
      <anchorfile>structhoayy_1_1parser_1_1by__type.html</anchorfile>
      <anchor>a36fb00b28d6a22397fb3ba474ad2aec8</anchor>
      <arglist>(kind_type t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>move</name>
      <anchorfile>structhoayy_1_1parser_1_1by__type.html</anchorfile>
      <anchor>aba79ebb237d8aab984a05c57ae66bd28</anchor>
      <arglist>(by_type &amp;that)</arglist>
    </member>
    <member kind="function">
      <type>symbol_number_type</type>
      <name>type_get</name>
      <anchorfile>structhoayy_1_1parser_1_1by__type.html</anchorfile>
      <anchor>a673de8e54c20b3975eda93c74893e9ea</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>token_type</type>
      <name>token</name>
      <anchorfile>structhoayy_1_1parser_1_1by__type.html</anchorfile>
      <anchor>a9420358c384a3b50bb09b41459e01eae</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>token_number_type</type>
      <name>type</name>
      <anchorfile>structhoayy_1_1parser_1_1by__type.html</anchorfile>
      <anchor>a7c7f8c9dd527016c2c556847488909f6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="union">
    <name>hoayy::parser::semantic_type</name>
    <filename>unionhoayy_1_1parser_1_1semantic__type.html</filename>
  </compound>
  <compound kind="struct">
    <name>hoayy::parser::syntax_error</name>
    <filename>structhoayy_1_1parser_1_1syntax__error.html</filename>
  </compound>
  <compound kind="struct">
    <name>hoayy::parser::token</name>
    <filename>structhoayy_1_1parser_1_1token.html</filename>
  </compound>
  <compound kind="class">
    <name>hoayy::slice</name>
    <filename>classhoayy_1_1slice.html</filename>
    <templarg></templarg>
    <templarg></templarg>
  </compound>
  <compound kind="class">
    <name>hoayy::stack</name>
    <filename>classhoayy_1_1stack.html</filename>
    <templarg>T</templarg>
    <templarg></templarg>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classhoayy_1_1stack.html</anchorfile>
      <anchor>a2d3fc799be347171e5f1496ab3f8b591</anchor>
      <arglist>(T &amp;t)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>hoayy_support::result_</name>
    <filename>structhoayy__support_1_1result__.html</filename>
    <class kind="struct">hoayy_support::result_::prop_info</class>
    <class kind="struct">hoayy_support::result_::state_info</class>
  </compound>
  <compound kind="struct">
    <name>hoayy_support::result_::prop_info</name>
    <filename>structhoayy__support_1_1result___1_1prop__info.html</filename>
  </compound>
  <compound kind="struct">
    <name>hoayy_support::result_::state_info</name>
    <filename>structhoayy__support_1_1result___1_1state__info.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::acc_cond</name>
    <filename>classspot_1_1acc__cond.html</filename>
    <class kind="struct">spot::acc_cond::acc_code</class>
    <class kind="union">spot::acc_cond::acc_word</class>
    <class kind="struct">spot::acc_cond::mark_t</class>
  </compound>
  <compound kind="struct">
    <name>spot::acc_cond::acc_code</name>
    <filename>structspot_1_1acc__cond_1_1acc__code.html</filename>
    <member kind="function">
      <type></type>
      <name>acc_code</name>
      <anchorfile>structspot_1_1acc__cond_1_1acc__code.html</anchorfile>
      <anchor>aa236e3aad85281f4b292e9a5f78404eb</anchor>
      <arglist>(const char *input)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>acc_code</name>
      <anchorfile>structspot_1_1acc__cond_1_1acc__code.html</anchorfile>
      <anchor>a84caf675c0406874d4c537994da61d29</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="union">
    <name>spot::acc_cond::acc_word</name>
    <filename>unionspot_1_1acc__cond_1_1acc__word.html</filename>
  </compound>
  <compound kind="struct">
    <name>spot::acc_cond::mark_t</name>
    <filename>structspot_1_1acc__cond_1_1mark__t.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::acss_statistics</name>
    <filename>classspot_1_1acss__statistics.html</filename>
    <base>spot::ars_statistics</base>
    <member kind="function" virtualness="pure">
      <type>virtual unsigned</type>
      <name>acss_states</name>
      <anchorfile>classspot_1_1acss__statistics.html</anchorfile>
      <anchor>a013cda6ae3aece6bbb7ffbc61a33fffb</anchor>
      <arglist>() const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::ars_statistics</name>
    <filename>classspot_1_1ars__statistics.html</filename>
    <base>spot::unsigned_statistics</base>
  </compound>
  <compound kind="struct">
    <name>spot::automaton_parser_options</name>
    <filename>structspot_1_1automaton__parser__options.html</filename>
    <member kind="variable">
      <type>bool</type>
      <name>ignore_abort</name>
      <anchorfile>structspot_1_1automaton__parser__options.html</anchorfile>
      <anchor>a8425c0ae87992cd896b1d7d01fae2911</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>debug</name>
      <anchorfile>structspot_1_1automaton__parser__options.html</anchorfile>
      <anchor>a31f989764577e2890067fe808e50d3fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>trust_hoa</name>
      <anchorfile>structspot_1_1automaton__parser__options.html</anchorfile>
      <anchor>a20ffb1a2807fe800d3b89cfbb3f6045e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>raise_errors</name>
      <anchorfile>structspot_1_1automaton__parser__options.html</anchorfile>
      <anchor>aca612f0ee657f37d1badc997afcc00ed</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>want_kripke</name>
      <anchorfile>structspot_1_1automaton__parser__options.html</anchorfile>
      <anchor>a42356bf01d72a6ec3867fa93ffd2febb</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::automaton_stream_parser</name>
    <filename>classspot_1_1automaton__stream__parser.html</filename>
    <member kind="function">
      <type></type>
      <name>automaton_stream_parser</name>
      <anchorfile>classspot_1_1automaton__stream__parser.html</anchorfile>
      <anchor>a24a0eee2660cf7f5374c641340b2b08b</anchor>
      <arglist>(const std::string &amp;filename, automaton_parser_options opts={})</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>automaton_stream_parser</name>
      <anchorfile>classspot_1_1automaton__stream__parser.html</anchorfile>
      <anchor>a152031002190162f457d48d31c780390</anchor>
      <arglist>(int fd, const std::string &amp;filename, automaton_parser_options opts={})</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>automaton_stream_parser</name>
      <anchorfile>classspot_1_1automaton__stream__parser.html</anchorfile>
      <anchor>ab69c6b1cdaddde470779a101cffe16a7</anchor>
      <arglist>(const char *data, const std::string &amp;filename, automaton_parser_options opts={})</arglist>
    </member>
    <member kind="function">
      <type>parsed_aut_ptr</type>
      <name>parse</name>
      <anchorfile>classspot_1_1automaton__stream__parser.html</anchorfile>
      <anchor>a8494e1d1c6587e562c403f40cee758c5</anchor>
      <arglist>(const bdd_dict_ptr &amp;dict, environment &amp;env=default_environment::instance())</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::barand</name>
    <filename>classspot_1_1barand.html</filename>
    <templarg>gen</templarg>
  </compound>
  <compound kind="class">
    <name>spot::bdd_dict</name>
    <filename>classspot_1_1bdd__dict.html</filename>
    <class kind="struct">spot::bdd_dict::bdd_info</class>
    <member kind="typedef">
      <type>std::map&lt; formula, int &gt;</type>
      <name>fv_map</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>a4a0c2d1aac827bd1df08091417b56ab2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::map&lt; int, formula &gt;</type>
      <name>vf_map</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>a49f3da9b2603e193f412b87277d189c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>std::set&lt; const void * &gt;</type>
      <name>ref_set</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>a015d330da101dd646875b8ed1613a2d6</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~bdd_dict</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>af6f03983c2f4647cf0a192d5868c1b14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unregister_all_my_variables</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>a64b9d9dcc789312a700519388faf40e8</anchor>
      <arglist>(const void *me)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>dump</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>ad5ce6572f9b85f7996f391276ea024f0</anchor>
      <arglist>(std::ostream &amp;os) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>assert_emptiness</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>a24d18da7cfd50865e23c32195e13f4d4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>register_proposition</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>a61e3d0ba1b765a3118d02ce147de0326</anchor>
      <arglist>(formula f, const void *for_me)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>register_proposition</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>a676b233c5a86b721b2e5466ef45c4c6a</anchor>
      <arglist>(formula f, std::shared_ptr&lt; T &gt; for_me)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>has_registered_proposition</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>a84b9cd4b3aff9911a9ab88512701f2d0</anchor>
      <arglist>(formula f, const void *me)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>has_registered_proposition</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>a7ba2189f3d2a83184d9c0baeea6342d4</anchor>
      <arglist>(formula f, std::shared_ptr&lt; T &gt; for_me)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>register_acceptance_variable</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>a178f861dd8f92c74235bd1d06d1cf3d1</anchor>
      <arglist>(formula f, const void *for_me)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>register_acceptance_variable</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>aea05f88cf69ae6d69f6deeb003c03776</anchor>
      <arglist>(formula f, std::shared_ptr&lt; T &gt; for_me)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>register_anonymous_variables</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>a7075f190e5d3a4face68a7a6e129eb95</anchor>
      <arglist>(int n, const void *for_me)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>register_anonymous_variables</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>ac95b78c3bbe1deb24901ed3a9b33ec75</anchor>
      <arglist>(int n, std::shared_ptr&lt; T &gt; for_me)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>register_all_variables_of</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>af7e1e37179f390322da4d4cbf134b282</anchor>
      <arglist>(const void *from_other, const void *for_me)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>register_all_variables_of</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>a82b6d9ccbc004146f25004496447c230</anchor>
      <arglist>(const void *from_other, std::shared_ptr&lt; T &gt; for_me)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>register_all_variables_of</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>a37347b7eca75dee887bdbffee6a980a6</anchor>
      <arglist>(std::shared_ptr&lt; T &gt; from_other, const void *for_me)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>register_all_variables_of</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>ad3b7c0358d6954cf6b9c84d9c24c87b2</anchor>
      <arglist>(std::shared_ptr&lt; T &gt; from_other, std::shared_ptr&lt; U &gt; for_me)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>register_all_propositions_of</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>a9458b22f9411ad3299b3bc4d538d24ff</anchor>
      <arglist>(const void *from_other, const void *for_me)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>register_all_propositions_of</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>a15c98cd0342bb977bb25ba1aeaac5b92</anchor>
      <arglist>(const void *from_other, std::shared_ptr&lt; T &gt; for_me)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>register_all_propositions_of</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>a35b3db4ea7b998b3c87c17246e4a6acf</anchor>
      <arglist>(std::shared_ptr&lt; T &gt; from_other, const void *for_me)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>register_all_propositions_of</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>a0edcf2fd422fb51b3c14a9f99cdd68fb</anchor>
      <arglist>(std::shared_ptr&lt; T &gt; from_other, std::shared_ptr&lt; U &gt; for_me)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unregister_variable</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>aa502521a61d81107e8c7ce5fab09ed7c</anchor>
      <arglist>(int var, const void *me)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unregister_variable</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>a5ea0b8ca41d9c4a72d8de94575050af6</anchor>
      <arglist>(int var, std::shared_ptr&lt; T &gt; me)</arglist>
    </member>
    <member kind="variable">
      <type>fv_map</type>
      <name>var_map</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>a9f47535b3c6ca438bb58975a240d783f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>fv_map</type>
      <name>acc_map</name>
      <anchorfile>classspot_1_1bdd__dict.html</anchorfile>
      <anchor>adea537e22c5889d908170b17ab8e8fd0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>spot::bdd_dict::bdd_info</name>
    <filename>structspot_1_1bdd__dict_1_1bdd__info.html</filename>
  </compound>
  <compound kind="struct">
    <name>spot::bdd_hash</name>
    <filename>structspot_1_1bdd__hash.html</filename>
  </compound>
  <compound kind="struct">
    <name>spot::bdd_less_than</name>
    <filename>structspot_1_1bdd__less__than.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::bfs_steps</name>
    <filename>classspot_1_1bfs__steps.html</filename>
    <member kind="function">
      <type>const state *</type>
      <name>search</name>
      <anchorfile>classspot_1_1bfs__steps.html</anchorfile>
      <anchor>ad5ce671417580b3115dc4658534c20f4</anchor>
      <arglist>(const state *start, twa_run::steps &amp;l)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual const state *</type>
      <name>filter</name>
      <anchorfile>classspot_1_1bfs__steps.html</anchorfile>
      <anchor>a12319da13fb0fde22376522fc416e833</anchor>
      <arglist>(const state *s)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>match</name>
      <anchorfile>classspot_1_1bfs__steps.html</anchorfile>
      <anchor>ac1fec3d68aad29e5dd4ef2ea1f66b4a4</anchor>
      <arglist>(twa_run::step &amp;step, const state *dest)=0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>finalize</name>
      <anchorfile>classspot_1_1bfs__steps.html</anchorfile>
      <anchor>aafa77f7559b8a46df9007e00b403ff99</anchor>
      <arglist>(const std::map&lt; const state *, twa_run::step, state_ptr_less_than &gt; &amp;father, const twa_run::step &amp;s, const state *start, twa_run::steps &amp;l)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const_twa_ptr</type>
      <name>a_</name>
      <anchorfile>classspot_1_1bfs__steps.html</anchorfile>
      <anchor>ae946a187607b497d3740cd9c16678799</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::bitvect</name>
    <filename>classspot_1_1bitvect.html</filename>
    <member kind="function">
      <type>void</type>
      <name>reserve_blocks</name>
      <anchorfile>classspot_1_1bitvect.html</anchorfile>
      <anchor>a1683bdf11b2ac71217e5614975c8e038</anchor>
      <arglist>(size_t new_block_count)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push_back</name>
      <anchorfile>classspot_1_1bitvect.html</anchorfile>
      <anchor>abdb21a168eb3e8da6c7446e7d4c7a87a</anchor>
      <arglist>(bool val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push_back</name>
      <anchorfile>classspot_1_1bitvect.html</anchorfile>
      <anchor>a37494e4c54d0ef32b4666f42b0d896e5</anchor>
      <arglist>(block_t data, unsigned count)</arglist>
    </member>
    <member kind="friend">
      <type>friend bitvect *</type>
      <name>make_bitvect</name>
      <anchorfile>classspot_1_1bitvect.html</anchorfile>
      <anchor>a086c21dc0b76db27d956db51351e61da</anchor>
      <arglist>(size_t bitcount)</arglist>
    </member>
    <member kind="friend">
      <type>friend std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classspot_1_1bitvect.html</anchorfile>
      <anchor>a35bbf9d192ce72495485b9f356e3a2d8</anchor>
      <arglist>(std::ostream &amp;, const bitvect &amp;)</arglist>
    </member>
    <member kind="friend" protection="private">
      <type>friend bitvect_array *</type>
      <name>make_bitvect_array</name>
      <anchorfile>classspot_1_1bitvect.html</anchorfile>
      <anchor>a4b9e54a150a91d7b8ddbdebb732134a0</anchor>
      <arglist>(size_t bitcount, size_t vectcount)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::bitvect_array</name>
    <filename>classspot_1_1bitvect__array.html</filename>
    <member kind="function">
      <type>size_t</type>
      <name>size</name>
      <anchorfile>classspot_1_1bitvect__array.html</anchorfile>
      <anchor>a2853984ba77df3d952dc968fbdad5b05</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bitvect &amp;</type>
      <name>at</name>
      <anchorfile>classspot_1_1bitvect__array.html</anchorfile>
      <anchor>a3145640ee8a128d8fa3c192ce21a3e6f</anchor>
      <arglist>(const size_t index)</arglist>
    </member>
    <member kind="function">
      <type>const bitvect &amp;</type>
      <name>at</name>
      <anchorfile>classspot_1_1bitvect__array.html</anchorfile>
      <anchor>ab18b7087548c49947f0498ca03ec7152</anchor>
      <arglist>(const size_t index) const </arglist>
    </member>
    <member kind="friend">
      <type>friend bitvect_array *</type>
      <name>make_bitvect_array</name>
      <anchorfile>classspot_1_1bitvect__array.html</anchorfile>
      <anchor>a4b9e54a150a91d7b8ddbdebb732134a0</anchor>
      <arglist>(size_t bitcount, size_t vectcount)</arglist>
    </member>
    <member kind="friend">
      <type>friend std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classspot_1_1bitvect__array.html</anchorfile>
      <anchor>a08823944594cc1b802a039c2ca29ae72</anchor>
      <arglist>(std::ostream &amp;, const bitvect_array &amp;)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>spot::char_ptr_less_than</name>
    <filename>structspot_1_1char__ptr__less__than.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::clause_counter</name>
    <filename>classspot_1_1clause__counter.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::couvreur99_check</name>
    <filename>classspot_1_1couvreur99__check.html</filename>
    <base>spot::emptiness_check</base>
    <base>spot::ec_statistics</base>
    <member kind="function" virtualness="virtual">
      <type>virtual emptiness_check_result_ptr</type>
      <name>check</name>
      <anchorfile>classspot_1_1couvreur99__check.html</anchorfile>
      <anchor>ad625e560dfe1932819efe98b5d038cf6</anchor>
      <arglist>() override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual std::ostream &amp;</type>
      <name>print_stats</name>
      <anchorfile>classspot_1_1couvreur99__check.html</anchorfile>
      <anchor>a97a15765dd30aafa2484218760eab20b</anchor>
      <arglist>(std::ostream &amp;os) const override</arglist>
    </member>
    <member kind="function">
      <type>std::shared_ptr&lt; const couvreur99_check_status &gt;</type>
      <name>result</name>
      <anchorfile>classspot_1_1couvreur99__check.html</anchorfile>
      <anchor>accdc6085653427c91a66d2604064cd8d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const const_twa_ptr &amp;</type>
      <name>automaton</name>
      <anchorfile>classspot_1_1emptiness__check.html</anchorfile>
      <anchor>a3d3eddd7ca43c166d0a1a0ab605b56a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const option_map &amp;</type>
      <name>options</name>
      <anchorfile>classspot_1_1emptiness__check.html</anchorfile>
      <anchor>a892ab07ce172c1d6deda9f0802b9eaa6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>parse_options</name>
      <anchorfile>classspot_1_1emptiness__check.html</anchorfile>
      <anchor>ad0e61dab3b4593d493da86ee625a25c3</anchor>
      <arglist>(char *options)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>safe</name>
      <anchorfile>classspot_1_1emptiness__check.html</anchorfile>
      <anchor>a217e667676d60e9f6f4fa7ba923925c0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const unsigned_statistics *</type>
      <name>statistics</name>
      <anchorfile>classspot_1_1emptiness__check.html</anchorfile>
      <anchor>a35f1119514acb36b217a7701bbf4b6f0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ec_statistics *</type>
      <name>emptiness_check_statistics</name>
      <anchorfile>classspot_1_1emptiness__check.html</anchorfile>
      <anchor>a31f2a4dd1bf87aa339fdb8178fb43e89</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>options_updated</name>
      <anchorfile>classspot_1_1emptiness__check.html</anchorfile>
      <anchor>aac525dce9e038b424a1f680b797e2639</anchor>
      <arglist>(const option_map &amp;old)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>remove_component</name>
      <anchorfile>classspot_1_1couvreur99__check.html</anchorfile>
      <anchor>a3b48d6451f133c57c7d62b8946d6339b</anchor>
      <arglist>(const state *start_delete)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>poprem_</name>
      <anchorfile>classspot_1_1couvreur99__check.html</anchorfile>
      <anchor>a13a1e31c34889d7a97cea7c7a0097416</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>unsigned</type>
      <name>removed_components</name>
      <anchorfile>classspot_1_1couvreur99__check.html</anchorfile>
      <anchor>afef1267ab1a6dbb03961e88cc718da42</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const_twa_ptr</type>
      <name>a_</name>
      <anchorfile>classspot_1_1emptiness__check.html</anchorfile>
      <anchor>a11c9edfa94d5693fac86bed37f03df72</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>option_map</type>
      <name>o_</name>
      <anchorfile>classspot_1_1emptiness__check.html</anchorfile>
      <anchor>a2bf27940474ed0e6ea39a6f8b6c7fcc0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::couvreur99_check_result</name>
    <filename>classspot_1_1couvreur99__check__result.html</filename>
    <base>spot::emptiness_check_result</base>
    <base>spot::acss_statistics</base>
    <member kind="function" virtualness="virtual">
      <type>virtual twa_run_ptr</type>
      <name>accepting_run</name>
      <anchorfile>classspot_1_1couvreur99__check__result.html</anchorfile>
      <anchor>a3ce51f644e0c230335b683cd7fb7993a</anchor>
      <arglist>() override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual unsigned</type>
      <name>acss_states</name>
      <anchorfile>classspot_1_1couvreur99__check__result.html</anchorfile>
      <anchor>a4095c5b7435d1e4ae8f71d6512dd5d16</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function">
      <type>const const_twa_ptr &amp;</type>
      <name>automaton</name>
      <anchorfile>classspot_1_1emptiness__check__result.html</anchorfile>
      <anchor>a8645285ce1efc3a2e3b77c98113b2836</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const option_map &amp;</type>
      <name>options</name>
      <anchorfile>classspot_1_1emptiness__check__result.html</anchorfile>
      <anchor>a5480637d90d73e3e67e2891cb7468d20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>parse_options</name>
      <anchorfile>classspot_1_1emptiness__check__result.html</anchorfile>
      <anchor>a66f0c4f9074073e8d26ac764d6103d9f</anchor>
      <arglist>(char *options)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const unsigned_statistics *</type>
      <name>statistics</name>
      <anchorfile>classspot_1_1emptiness__check__result.html</anchorfile>
      <anchor>a0d0bebd88677d1a0221f8263692f1b17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>accepting_cycle</name>
      <anchorfile>classspot_1_1couvreur99__check__result.html</anchorfile>
      <anchor>aacf9472e522e742957e29d29453f64a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>options_updated</name>
      <anchorfile>classspot_1_1emptiness__check__result.html</anchorfile>
      <anchor>a3ed3330145ca9d988eeca2e5bf773dad</anchor>
      <arglist>(const option_map &amp;old)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const_twa_ptr</type>
      <name>a_</name>
      <anchorfile>classspot_1_1emptiness__check__result.html</anchorfile>
      <anchor>ac27262b9cca1c8e48db1390a9f44945e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>option_map</type>
      <name>o_</name>
      <anchorfile>classspot_1_1emptiness__check__result.html</anchorfile>
      <anchor>a42a0ad82518ab92ce6ea2166c119e4cc</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::couvreur99_check_shy</name>
    <filename>classspot_1_1couvreur99__check__shy.html</filename>
    <base>spot::couvreur99_check</base>
    <class kind="struct">spot::couvreur99_check_shy::successor</class>
    <class kind="struct">spot::couvreur99_check_shy::todo_item</class>
    <member kind="function" virtualness="virtual">
      <type>virtual emptiness_check_result_ptr</type>
      <name>check</name>
      <anchorfile>classspot_1_1couvreur99__check__shy.html</anchorfile>
      <anchor>ad67caf82a98fe4db27cdcd231adcf6f1</anchor>
      <arglist>() override</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>dump_queue</name>
      <anchorfile>classspot_1_1couvreur99__check__shy.html</anchorfile>
      <anchor>a4df98a24aa2099c639d6f8dfdc4224a4</anchor>
      <arglist>(std::ostream &amp;os=std::cerr)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>group_</name>
      <anchorfile>classspot_1_1couvreur99__check__shy.html</anchorfile>
      <anchor>a112c0863e8f602e5dddcc222d4250b7a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>spot::couvreur99_check_shy::successor</name>
    <filename>structspot_1_1couvreur99__check__shy_1_1successor.html</filename>
  </compound>
  <compound kind="struct">
    <name>spot::couvreur99_check_shy::todo_item</name>
    <filename>structspot_1_1couvreur99__check__shy_1_1todo__item.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::couvreur99_check_status</name>
    <filename>classspot_1_1couvreur99__check__status.html</filename>
    <member kind="function">
      <type>void</type>
      <name>print_stats</name>
      <anchorfile>classspot_1_1couvreur99__check__status.html</anchorfile>
      <anchor>ac85eb5d7ae5fe26defdf157f12a57e2f</anchor>
      <arglist>(std::ostream &amp;os) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>states</name>
      <anchorfile>classspot_1_1couvreur99__check__status.html</anchorfile>
      <anchor>ac0dad048c592f621dd9cbc8e76c72d3d</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::declarative_environment</name>
    <filename>classspot_1_1declarative__environment.html</filename>
    <base>spot::environment</base>
    <member kind="function">
      <type>bool</type>
      <name>declare</name>
      <anchorfile>classspot_1_1declarative__environment.html</anchorfile>
      <anchor>a6aa21cad8a26f3f2c04febde7c785eff</anchor>
      <arglist>(const std::string &amp;prop_str)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual formula</type>
      <name>require</name>
      <anchorfile>classspot_1_1declarative__environment.html</anchorfile>
      <anchor>a4a602d6c804add1b91992dd56d308623</anchor>
      <arglist>(const std::string &amp;prop_str) override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const std::string &amp;</type>
      <name>name</name>
      <anchorfile>classspot_1_1declarative__environment.html</anchorfile>
      <anchor>a52066a7872c4506306fa613004c5e85a</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function">
      <type>const prop_map &amp;</type>
      <name>get_prop_map</name>
      <anchorfile>classspot_1_1declarative__environment.html</anchorfile>
      <anchor>adcd8d9b34f601b98214790d50839d64f</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::default_environment</name>
    <filename>classspot_1_1default__environment.html</filename>
    <base>spot::environment</base>
    <member kind="function" virtualness="virtual">
      <type>virtual formula</type>
      <name>require</name>
      <anchorfile>classspot_1_1default__environment.html</anchorfile>
      <anchor>a6e126e3ae068227adad825e6d18c8e20</anchor>
      <arglist>(const std::string &amp;prop_str) override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const std::string &amp;</type>
      <name>name</name>
      <anchorfile>classspot_1_1default__environment.html</anchorfile>
      <anchor>a11311693d8f75f1277d989556008fb08</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static default_environment &amp;</type>
      <name>instance</name>
      <anchorfile>classspot_1_1default__environment.html</anchorfile>
      <anchor>af132fafa370903c62fc7b7e6cf535000</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::digraph</name>
    <filename>singletonspot_1_1digraph.html</filename>
    <templarg>State_Data</templarg>
    <templarg>Edge_Data</templarg>
    <templarg>Alternating</templarg>
    <member kind="function">
      <type></type>
      <name>digraph</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>aaff2eb62baef2959314b8e989fd65d96</anchor>
      <arglist>(unsigned max_states=10, unsigned max_trans=0)</arglist>
    </member>
    <member kind="function">
      <type>unsigned</type>
      <name>num_states</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>af98549f87b5fbbab40d8f7a1abfc4c30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned</type>
      <name>num_edges</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>a002378568330f7a05eab94094f6081d6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>state</type>
      <name>new_state</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>a87e60d47427cb8d5b498ac29fb69bf42</anchor>
      <arglist>(Args &amp;&amp;...args)</arglist>
    </member>
    <member kind="function">
      <type>state</type>
      <name>new_states</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>a1f8df6606e7a0e7cfeacf1d0a46d66af</anchor>
      <arglist>(unsigned n, Args &amp;&amp;...args)</arglist>
    </member>
    <member kind="function">
      <type>edge</type>
      <name>new_edge</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>a7b20c0cf33e6d03d8af344132625be2d</anchor>
      <arglist>(state src, out_state dst, Args &amp;&amp;...args)</arglist>
    </member>
    <member kind="function">
      <type>state</type>
      <name>index_of_state</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>a4f5d9f801253c60ed5aeef3ceb073c69</anchor>
      <arglist>(const state_storage_t &amp;ss) const </arglist>
    </member>
    <member kind="function">
      <type>edge</type>
      <name>index_of_edge</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>ad5d9d80f3feae0266d01d021dee7c6a1</anchor>
      <arglist>(const edge_storage_t &amp;tt) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_valid_edge</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>ac7d92efc6b4e365540813a13b83a9791</anchor>
      <arglist>(edge t) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>dump_storage</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>a2200468e984d4296f1461919cccf048f</anchor>
      <arglist>(std::ostream &amp;o) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_dead_edges_</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>ae25586c093c0b215dac4cc5f8c8e356a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sort_edges_</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>a01518414dfc082ad1771a1c0354bcc15</anchor>
      <arglist>(Predicate p=Predicate())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>chain_edges_</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>abda4786e4a5be6152a8e90220063f19f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rename_states_</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>a6872e7f91442e0365e931465d4932cc0</anchor>
      <arglist>(const std::vector&lt; unsigned &gt; &amp;newst)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>defrag_states</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>ae09ad72c73ebbbbe0f2a8c45ff43bc0e</anchor>
      <arglist>(std::vector&lt; unsigned &gt; &amp;&amp;newst, unsigned used_states)</arglist>
    </member>
    <member kind="function">
      <type>state_storage_t &amp;</type>
      <name>state_storage</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>ada650fde4f2b94e220113cbe43d947e1</anchor>
      <arglist>(state s)</arglist>
    </member>
    <member kind="function">
      <type>const state_storage_t &amp;</type>
      <name>state_storage</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>adc648cefd8a0130c125215ed8f25b7c3</anchor>
      <arglist>(state s) const </arglist>
    </member>
    <member kind="function">
      <type>state_storage_t::data_t &amp;</type>
      <name>state_data</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>ab74da1c09a4f7b2024beaae6ea784477</anchor>
      <arglist>(state s)</arglist>
    </member>
    <member kind="function">
      <type>const state_storage_t::data_t &amp;</type>
      <name>state_data</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>a8b60e4ec351e0c7fd1519994a72f1911</anchor>
      <arglist>(state s) const </arglist>
    </member>
    <member kind="function">
      <type>edge_storage_t &amp;</type>
      <name>edge_storage</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>af4d10bdc5ff9bdb54e0e8f0d7c004e9f</anchor>
      <arglist>(edge s)</arglist>
    </member>
    <member kind="function">
      <type>const edge_storage_t &amp;</type>
      <name>edge_storage</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>afaa88f8a784cf575a286a205e8664746</anchor>
      <arglist>(edge s) const </arglist>
    </member>
    <member kind="function">
      <type>edge_storage_t::data_t &amp;</type>
      <name>edge_data</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>ac9d03c15214fe2f5051b8e91da4595e8</anchor>
      <arglist>(edge s)</arglist>
    </member>
    <member kind="function">
      <type>const edge_storage_t::data_t &amp;</type>
      <name>edge_data</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>a6fe590521829013fc36dbf3c46c87bcd</anchor>
      <arglist>(edge s) const </arglist>
    </member>
    <member kind="function">
      <type>internal::state_out&lt; digraph &gt;</type>
      <name>out</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>a9b0ab1be114cfba4d7328d1c76bebd92</anchor>
      <arglist>(state src)</arglist>
    </member>
    <member kind="function">
      <type>internal::state_out&lt; digraph &gt;</type>
      <name>out</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>a039e8f569a09f131353ba636e21e2292</anchor>
      <arglist>(state_storage_t &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>internal::state_out&lt; const digraph &gt;</type>
      <name>out</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>a71db87d949d17da87c0fdfccf1407899</anchor>
      <arglist>(state src) const </arglist>
    </member>
    <member kind="function">
      <type>internal::state_out&lt; const digraph &gt;</type>
      <name>out</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>a33622848e1e511f3d124188476226caf</anchor>
      <arglist>(state_storage_t &amp;src) const </arglist>
    </member>
    <member kind="function">
      <type>internal::killer_edge_iterator&lt; digraph &gt;</type>
      <name>out_iteraser</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>aad7337cfb54c9bd572fa8d3595e67f70</anchor>
      <arglist>(state_storage_t &amp;src)</arglist>
    </member>
    <member kind="function">
      <type>internal::killer_edge_iterator&lt; digraph &gt;</type>
      <name>out_iteraser</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>a4c30b65e1a9b34229eb68db4d33f1345</anchor>
      <arglist>(state src)</arglist>
    </member>
    <member kind="function">
      <type>const state_vector &amp;</type>
      <name>states</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>a26f0114bf2e3c0fd88ba383fbf3b3dab</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>state_vector &amp;</type>
      <name>states</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>af4397da3799a7a9570157249e74bd0e6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>internal::all_trans&lt; const digraph &gt;</type>
      <name>edges</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>ab27c51c9274f6825c0d607d686d2125d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>internal::all_trans&lt; digraph &gt;</type>
      <name>edges</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>ad47ff1f56a0babfeba615773db903bac</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const edge_vector_t &amp;</type>
      <name>edge_vector</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>ae2e5b9f82d82371a5471e642d90b5603</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>edge_vector_t &amp;</type>
      <name>edge_vector</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>afe759f30540d80394bf5863c5012a7c5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_dead_edge</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>abdc232311dd2c0d5a557cb943f08cdbe</anchor>
      <arglist>(unsigned t) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_dead_edge</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>a4f63971ee653c5067bd9eb03a1c01122</anchor>
      <arglist>(const edge_storage_t &amp;t) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static constexpr bool</type>
      <name>alternating</name>
      <anchorfile>singletonspot_1_1digraph.html</anchorfile>
      <anchor>aaa7cd9837143610a3e324c17e553fb19</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::ec_statistics</name>
    <filename>classspot_1_1ec__statistics.html</filename>
    <base>spot::unsigned_statistics</base>
  </compound>
  <compound kind="class">
    <name>spot::emptiness_check</name>
    <filename>classspot_1_1emptiness__check.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual emptiness_check_result_ptr</type>
      <name>check</name>
      <anchorfile>classspot_1_1emptiness__check.html</anchorfile>
      <anchor>af2f35aee494d0feaa37bd2da393502eb</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual std::ostream &amp;</type>
      <name>print_stats</name>
      <anchorfile>classspot_1_1emptiness__check.html</anchorfile>
      <anchor>a67a72e44b2fa859aef3c23c052512924</anchor>
      <arglist>(std::ostream &amp;os) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::emptiness_check_instantiator</name>
    <filename>classspot_1_1emptiness__check__instantiator.html</filename>
    <member kind="function">
      <type>emptiness_check_ptr</type>
      <name>instantiate</name>
      <anchorfile>classspot_1_1emptiness__check__instantiator.html</anchorfile>
      <anchor>a5f213c5ad4c6f6f385da33e205d5dd08</anchor>
      <arglist>(const const_twa_ptr &amp;a) const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>min_sets</name>
      <anchorfile>classspot_1_1emptiness__check__instantiator.html</anchorfile>
      <anchor>a555c776058ff797cc8b6f6d5f62f16da</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>max_sets</name>
      <anchorfile>classspot_1_1emptiness__check__instantiator.html</anchorfile>
      <anchor>a3778c3d09f45202d067675c49a9d765c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const option_map &amp;</type>
      <name>options</name>
      <anchorfile>classspot_1_1emptiness__check__instantiator.html</anchorfile>
      <anchor>a795a1701f756da2019925528248697e7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>option_map &amp;</type>
      <name>options</name>
      <anchorfile>classspot_1_1emptiness__check__instantiator.html</anchorfile>
      <anchor>a94c541281a8ddc037242ebc1c1621710</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::emptiness_check_result</name>
    <filename>classspot_1_1emptiness__check__result.html</filename>
    <member kind="function" virtualness="virtual">
      <type>virtual twa_run_ptr</type>
      <name>accepting_run</name>
      <anchorfile>classspot_1_1emptiness__check__result.html</anchorfile>
      <anchor>a497d89941e08f1e934b99da87d2a77d3</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::enumerate_cycles</name>
    <filename>classspot_1_1enumerate__cycles.html</filename>
    <class kind="struct">spot::enumerate_cycles::dfs_entry</class>
    <class kind="struct">spot::enumerate_cycles::state_info</class>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>classspot_1_1enumerate__cycles.html</anchorfile>
      <anchor>a8183feda2fb77c100c3b5ec23701ab44</anchor>
      <arglist>(unsigned scc)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>cycle_found</name>
      <anchorfile>classspot_1_1enumerate__cycles.html</anchorfile>
      <anchor>a7343a1c3fbfb0dc40c93c13a32da6aab</anchor>
      <arglist>(unsigned start)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>spot::enumerate_cycles::dfs_entry</name>
    <filename>structspot_1_1enumerate__cycles_1_1dfs__entry.html</filename>
  </compound>
  <compound kind="struct">
    <name>spot::enumerate_cycles::state_info</name>
    <filename>structspot_1_1enumerate__cycles_1_1state__info.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::environment</name>
    <filename>classspot_1_1environment.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual formula</type>
      <name>require</name>
      <anchorfile>classspot_1_1environment.html</anchorfile>
      <anchor>ad9597177678501d5f7a9debe8462c1ac</anchor>
      <arglist>(const std::string &amp;prop_str)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual const std::string &amp;</type>
      <name>name</name>
      <anchorfile>classspot_1_1environment.html</anchorfile>
      <anchor>ac293ae426b384ad0c0806e81e97b61e6</anchor>
      <arglist>() const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::exclusive_ap</name>
    <filename>classspot_1_1exclusive__ap.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::fair_kripke</name>
    <filename>classspot_1_1fair__kripke.html</filename>
    <base>spot::twa</base>
    <member kind="function" virtualness="pure">
      <type>virtual bdd</type>
      <name>state_condition</name>
      <anchorfile>classspot_1_1fair__kripke.html</anchorfile>
      <anchor>ab82a2fe269593fecab7c63d0c4c9ac03</anchor>
      <arglist>(const state *s) const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual acc_cond::mark_t</type>
      <name>state_acceptance_mark</name>
      <anchorfile>classspot_1_1fair__kripke.html</anchorfile>
      <anchor>a4a27986ed4291292ec5312ca03d5ae5b</anchor>
      <arglist>(const state *s) const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual const state *</type>
      <name>get_init_state</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a14d78145c692f853278f4bf6ed2b29a9</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual twa_succ_iterator *</type>
      <name>succ_iter</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>aa4fbf0e6d8e7cfeeacc533ebd0aa1789</anchor>
      <arglist>(const state *local_state) const =0</arglist>
    </member>
    <member kind="function">
      <type>internal::twa_succ_iterable</type>
      <name>succ</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a92b36c73c4ccec81b2fd3b6c9f0a50eb</anchor>
      <arglist>(const state *s) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>release_iter</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a7184271f974c51f3e82738f34c84499f</anchor>
      <arglist>(twa_succ_iterator *i) const </arglist>
    </member>
    <member kind="function">
      <type>bdd_dict_ptr</type>
      <name>get_dict</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a6cc8f9637ce85fd6f73799a0711dec05</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unregister_ap</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>aa894cadf4f669d8dbf713e6d61795630</anchor>
      <arglist>(int num)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>register_aps_from_dict</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>ad7067f2beeee73198a6a4d0f324f711a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const std::vector&lt; formula &gt; &amp;</type>
      <name>ap</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a50a583451e00f93bdc3cad74db00e771</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bdd</type>
      <name>ap_vars</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>aa38e224d70f8e041a7fef642bc9f2907</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual std::string</type>
      <name>format_state</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>aabef489f505ec22f9889bdf50895b9d1</anchor>
      <arglist>(const state *s) const =0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual state *</type>
      <name>project_state</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>aab8602d37c22ac8f86ff09a2e53dc217</anchor>
      <arglist>(const state *s, const const_twa_ptr &amp;t) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>is_empty</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a3092e4272829662cad040d8bfc0ab117</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual twa_run_ptr</type>
      <name>accepting_run</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>aa9bc8f5fe29c436073033e34f593bcde</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual twa_word_ptr</type>
      <name>accepting_word</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>ad9553c94ca5d273ee1b823acd9a9dcf0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned</type>
      <name>num_sets</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a1174a068b02a5119eaa40d9c0b427b68</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const acc_cond::acc_code &amp;</type>
      <name>get_acceptance</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a1d4fe547707a2e2910551fb5cd39e106</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_acceptance</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a09d8c50ffda9f409bb813c53df93f227</anchor>
      <arglist>(unsigned num, const acc_cond::acc_code &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_acceptance_of</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a01271d216f812be788ac411e6bb20a8f</anchor>
      <arglist>(const const_twa_ptr &amp;a)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_ap_of</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a7926e060735f32917854af70f907accb</anchor>
      <arglist>(const const_twa_ptr &amp;a)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_generalized_buchi</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a1bc1101f35afe718accd802c63685270</anchor>
      <arglist>(unsigned num)</arglist>
    </member>
    <member kind="function">
      <type>acc_cond::mark_t</type>
      <name>set_buchi</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a23b29bb361b17a9871a2fcd0e097ec67</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_named_prop</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a3097bccdb5fcba9bf9bc60063db77f29</anchor>
      <arglist>(std::string s, void *val, std::function&lt; void(void *)&gt; destructor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_named_prop</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a655805e78acd341da38ca215454008f4</anchor>
      <arglist>(std::string s, T *val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_named_prop</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a490b3a9cef9d5b231e30a4ec963a425f</anchor>
      <arglist>(std::string s, std::nullptr_t)</arglist>
    </member>
    <member kind="function">
      <type>T *</type>
      <name>get_named_prop</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a6fa756678405321db8f7e17c62cf3806</anchor>
      <arglist>(std::string s) const </arglist>
    </member>
    <member kind="function">
      <type>T *</type>
      <name>get_or_set_named_prop</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a43c802c348c15f486614ec21208fa874</anchor>
      <arglist>(std::string s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>release_named_properties</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a2dee95ed9d469a4da407d6088e0580ac</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>trival</type>
      <name>prop_state_acc</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a4e21bef11cf3d2aba286f61d5909aec5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prop_state_acc</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>abe0d5e640c21c8d6fab43df7d7001a3c</anchor>
      <arglist>(trival val)</arglist>
    </member>
    <member kind="function">
      <type>trival</type>
      <name>is_sba</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>ab0af6ec5240265093fe9ceede58f91f9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>trival</type>
      <name>prop_inherently_weak</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a5c08582f41447180a4063b98f507c011</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prop_inherently_weak</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a1850a0bb85ec6526f7ca4863f78572b0</anchor>
      <arglist>(trival val)</arglist>
    </member>
    <member kind="function">
      <type>trival</type>
      <name>prop_terminal</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a16ac88655241376a0e49678a2e84444b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prop_terminal</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a006729811b4ca447cdb02829e2343c83</anchor>
      <arglist>(trival val)</arglist>
    </member>
    <member kind="function">
      <type>trival</type>
      <name>prop_weak</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>ad045d1171016ff8420396b0ee6c205e6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prop_weak</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a3ba2ef700165105280b9246fda22a056</anchor>
      <arglist>(trival val)</arglist>
    </member>
    <member kind="function">
      <type>trival</type>
      <name>prop_deterministic</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a65404a76be7c72cd3439d09732264f8e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prop_deterministic</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a27c710a71afbf5ea047c5c172a0a9729</anchor>
      <arglist>(trival val)</arglist>
    </member>
    <member kind="function">
      <type>trival</type>
      <name>prop_unambiguous</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a44a3edd809856ea709b315cb0d3afee6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prop_unambiguous</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a9a401d2e9873ba96647ec462577e86ae</anchor>
      <arglist>(trival val)</arglist>
    </member>
    <member kind="function">
      <type>trival</type>
      <name>prop_stutter_invariant</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a800096e376da3f039c40b6f815696ee2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prop_stutter_invariant</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a6a7b4031e7bfad8713ae104d9874ff5b</anchor>
      <arglist>(trival val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prop_copy</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a9b1b06784f1d4d6619a7c8354a0bea43</anchor>
      <arglist>(const const_twa_ptr &amp;other, prop_set p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prop_keep</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a1fd081b053b10a7970fc158eb3bf66bf</anchor>
      <arglist>(prop_set p)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>register_ap</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>afe579bbb98cf4d4a67f5f1f567528da3</anchor>
      <arglist>(formula ap)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>register_ap</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>ae9776f338295ea9de3df69910e78eb60</anchor>
      <arglist>(std::string ap)</arglist>
    </member>
    <member kind="function">
      <type>const acc_cond &amp;</type>
      <name>acc</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a1b65aaf3dc7ab7f7155a6703f67f0c90</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>acc_cond &amp;</type>
      <name>acc</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a1966a5426ae470f2b9386e4472a62664</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>twa_succ_iterator *</type>
      <name>iter_cache_</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>aecc23c52ddd73c38a928a260b4048baa</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bdd_dict_ptr</type>
      <name>dict_</name>
      <anchorfile>classspot_1_1twa.html</anchorfile>
      <anchor>a3889d03daa1f45b944ee2e82ab8ee118</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::fair_kripke_succ_iterator</name>
    <filename>classspot_1_1fair__kripke__succ__iterator.html</filename>
    <base>spot::twa_succ_iterator</base>
    <member kind="function">
      <type></type>
      <name>fair_kripke_succ_iterator</name>
      <anchorfile>classspot_1_1fair__kripke__succ__iterator.html</anchorfile>
      <anchor>a7de60d611bc5102de3f2aa763498a445</anchor>
      <arglist>(const bdd &amp;cond, acc_cond::mark_t acc_cond)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bdd</type>
      <name>cond</name>
      <anchorfile>classspot_1_1fair__kripke__succ__iterator.html</anchorfile>
      <anchor>a5151afec7e994c73b2939927aab9ca5e</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual acc_cond::mark_t</type>
      <name>acc</name>
      <anchorfile>classspot_1_1fair__kripke__succ__iterator.html</anchorfile>
      <anchor>af70f30de8bb54d50516c46086f3d0c98</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>first</name>
      <anchorfile>classspot_1_1twa__succ__iterator.html</anchorfile>
      <anchor>a7d9aaac752c5b34be38267f8a13b542e</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>next</name>
      <anchorfile>classspot_1_1twa__succ__iterator.html</anchorfile>
      <anchor>a9786d3e185bbfede3171f6048ab986b5</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>done</name>
      <anchorfile>classspot_1_1twa__succ__iterator.html</anchorfile>
      <anchor>a63532b642dfe79f45f200f3db65a889f</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual const state *</type>
      <name>dst</name>
      <anchorfile>classspot_1_1twa__succ__iterator.html</anchorfile>
      <anchor>a6160d66164efff504984e255ada14c65</anchor>
      <arglist>() const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::fixed_size_pool</name>
    <filename>classspot_1_1fixed__size__pool.html</filename>
    <member kind="function">
      <type></type>
      <name>fixed_size_pool</name>
      <anchorfile>classspot_1_1fixed__size__pool.html</anchorfile>
      <anchor>a6a4e2ff7241946bb41b10ad29016d415</anchor>
      <arglist>(size_t size)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~fixed_size_pool</name>
      <anchorfile>classspot_1_1fixed__size__pool.html</anchorfile>
      <anchor>a186aa1b99e7caa7a8924dc5afae6c188</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>allocate</name>
      <anchorfile>classspot_1_1fixed__size__pool.html</anchorfile>
      <anchor>a12378ce82675d629e94180fe4a8d955d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deallocate</name>
      <anchorfile>classspot_1_1fixed__size__pool.html</anchorfile>
      <anchor>a3d2cbc9689e5bb4a9c56573711787261</anchor>
      <arglist>(const void *ptr)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::fnode</name>
    <filename>classspot_1_1fnode.html</filename>
    <member kind="function">
      <type>const fnode *</type>
      <name>clone</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a36590e6d1a34b63f5f58ab3bb830158e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>destroy</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a897f0dad92112a7ad0872ec47ca789a0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>op</type>
      <name>kind</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a90792cd0318d49b41ec8002f8973bb5c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>kindstr</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>af6f9549af90540bdf36e27bf28bbf8c8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>acb3be3bbc72fc374c19c5822890097ff</anchor>
      <arglist>(op o) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a93eb9135a1a94635d99d159f8a502516</anchor>
      <arglist>(op o1, op o2) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a808c1f0c3d5f82d5182c01d3da1e779e</anchor>
      <arglist>(std::initializer_list&lt; op &gt; l) const </arglist>
    </member>
    <member kind="function">
      <type>const fnode *</type>
      <name>get_child_of</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a1d4c5ba7b6c205f452bd44e871a63429</anchor>
      <arglist>(op o) const </arglist>
    </member>
    <member kind="function">
      <type>const fnode *</type>
      <name>get_child_of</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>ad3627312ee037295fe850a94217b0209</anchor>
      <arglist>(std::initializer_list&lt; op &gt; l) const </arglist>
    </member>
    <member kind="function">
      <type>unsigned</type>
      <name>min</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>ac9e672b9092bb7d7331eced7f723838b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned</type>
      <name>max</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a33cf7f6c24f924624a50af844081d6e6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned</type>
      <name>size</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a24ae11a777687b87325b1aef2f1ffc1f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>id</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a41dac588248f33354b557909b35ae116</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const fnode *const *</type>
      <name>begin</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a64855a27f405b4360d8b5bffae2a25c3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const fnode *const *</type>
      <name>end</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>ab323a52251d016cd69e8dc6c1b7044a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const fnode *</type>
      <name>nth</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>acc8f4bbb31ad9e2a4fde157f77ee3e5b</anchor>
      <arglist>(unsigned i) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_ff</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a0fb4c12605a3ed0d19e2959f52afcfef</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_tt</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>aad22dfa6a6fb9b862b4f70e26ebed447</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_eword</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a60907a07c8d7379a8e2eaf8a6620136a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_constant</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a67c69be5c8ce4daa4ee2312f3f6ca462</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_Kleene_star</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a104d792d41e0e58ad319979352673446</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>ap_name</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>ab9e5d100c8be22a75239ce948e040ddf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>dump</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a54025af1244c03070d37dc1037795a86</anchor>
      <arglist>(std::ostream &amp;os) const </arglist>
    </member>
    <member kind="function">
      <type>const fnode *</type>
      <name>all_but</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a0038fe5febb7dfc3771e7dc42cc8bc74</anchor>
      <arglist>(unsigned i) const </arglist>
    </member>
    <member kind="function">
      <type>unsigned</type>
      <name>boolean_count</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a7f87caf4c2d6cafd006ad15c07cfdeec</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const fnode *</type>
      <name>boolean_operands</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>ae55c9939f71f21eec7fefbe1779202be</anchor>
      <arglist>(unsigned *width=nullptr) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_boolean</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a215793a6c0572c6f71fa61bc2aa6d911</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_sugar_free_boolean</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>abf22e1ac5d962458e0b1433df3ff8b64</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_in_nenoform</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a6ff42159ced5b835e24a8f08074972cc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_syntactic_stutter_invariant</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>ab806a319fdeb5765a2fa2fb4d2fc8a42</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_sugar_free_ltl</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a9b7dd2f8dd73fb0665e9b74ec64c6d3b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_ltl_formula</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>af708c2107c0c1b49a0727586fec4d82b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_psl_formula</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>ab0f20276fa39827912fbd9fe2ee1660f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_sere_formula</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>af8af61a77be0d899dc103d968d51d7fe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_finite</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a4504883f700719cd676b14b1beb30ad3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_eventual</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>ad2ea008a4c73073c116e55db3d2bce4d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_universal</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a8fad5db7b8fea7bbab732d4a6f752617</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_syntactic_safety</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a55caed641f8cb7a51b35c335847c2dd0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_syntactic_guarantee</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>ac57ad988a5e379dcf668019806c57a2b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_syntactic_obligation</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a794870603ff7249ab41c5f694ffa5bad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_syntactic_recurrence</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a9b116c9c6ff33a0333924e76e27e46a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_syntactic_persistence</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a385e6dd9126da748367ab59051a6d7e1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_marked</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>af94d24036329b044cc2fb083d61231d7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>accepts_eword</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>aec65bed743ff0f9281150e898b63a721</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_lbt_atomic_props</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a13f4c80ef836e6079babfea0d5953798</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_spin_atomic_props</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a72bb8873113bffcd8f0f1f5353d35f40</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static constexpr uint8_t</type>
      <name>unbounded</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a293c84605153e8e773bd3cc056846ba6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const fnode *</type>
      <name>ap</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>af0fdd3fdc0852fb7d182c8fcad309602</anchor>
      <arglist>(const std::string &amp;name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const fnode *</type>
      <name>unop</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>ab4afcc96178e76986d085620f750c3c1</anchor>
      <arglist>(op o, const fnode *f)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const fnode *</type>
      <name>binop</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a90e6622cc2729ebd71b3c45c7293c101</anchor>
      <arglist>(op o, const fnode *f, const fnode *g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const fnode *</type>
      <name>multop</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>ad23440db992349ed3fb9c9c070274612</anchor>
      <arglist>(op o, std::vector&lt; const fnode * &gt; l)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const fnode *</type>
      <name>bunop</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>ab5ad3c536ca0fdda6ea290abd40880da</anchor>
      <arglist>(op o, const fnode *f, uint8_t min, uint8_t max=unbounded())</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const fnode *</type>
      <name>ff</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a3cba2a54290364d4ae8ae5e3f934a6a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const fnode *</type>
      <name>tt</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a5f321d20ad9af18e6f4ce8af14d56596</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const fnode *</type>
      <name>eword</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a2dcd81078641ad5d28c8757599801295</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const fnode *</type>
      <name>one_star</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>aa12efb78c1e5c5ab1308633a570e9cc8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>instances_check</name>
      <anchorfile>classspot_1_1fnode.html</anchorfile>
      <anchor>a568e66c7d9e64c791f9e0b6d52ace7b8</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::formater</name>
    <filename>classspot_1_1formater.html</filename>
    <member kind="function">
      <type>bool</type>
      <name>has</name>
      <anchorfile>classspot_1_1formater.html</anchorfile>
      <anchor>a3ee523bf70b7d9ba9e350534334e2633</anchor>
      <arglist>(char c) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>declare</name>
      <anchorfile>classspot_1_1formater.html</anchorfile>
      <anchor>a1fd3752a72f250ba8d73cbbede1d9868</anchor>
      <arglist>(char c, const printable *f)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_output</name>
      <anchorfile>classspot_1_1formater.html</anchorfile>
      <anchor>a2d321a5ed339b3bf33869dc3c8933e2e</anchor>
      <arglist>(std::ostream &amp;output)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>format</name>
      <anchorfile>classspot_1_1formater.html</anchorfile>
      <anchor>a64b02cc1c3804b490463888757be35bb</anchor>
      <arglist>(const char *fmt)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>format</name>
      <anchorfile>classspot_1_1formater.html</anchorfile>
      <anchor>a2aec18e8b23e0fff4e6641846e16d67d</anchor>
      <arglist>(std::ostream &amp;output, const char *fmt)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>format</name>
      <anchorfile>classspot_1_1formater.html</anchorfile>
      <anchor>a5bae69390fc6e76ceea86eca57cbf888</anchor>
      <arglist>(const std::string &amp;fmt)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>format</name>
      <anchorfile>classspot_1_1formater.html</anchorfile>
      <anchor>af6cabca4ec183a6fdf0827575516b43b</anchor>
      <arglist>(std::ostream &amp;output, const std::string &amp;fmt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scan</name>
      <anchorfile>classspot_1_1formater.html</anchorfile>
      <anchor>a663f4c6946ced8761ca87af81c526bbb</anchor>
      <arglist>(const char *fmt, std::vector&lt; bool &gt; &amp;has) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scan</name>
      <anchorfile>classspot_1_1formater.html</anchorfile>
      <anchor>ae2d1611e50c0e327a1b8b3b41487fbdc</anchor>
      <arglist>(const std::string &amp;fmt, std::vector&lt; bool &gt; &amp;has) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prime</name>
      <anchorfile>classspot_1_1formater.html</anchorfile>
      <anchor>af760bacb505f4262d8ba966993b16253</anchor>
      <arglist>(const char *fmt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prime</name>
      <anchorfile>classspot_1_1formater.html</anchorfile>
      <anchor>ad4519a348ab6df362c10dab6d3b60b35</anchor>
      <arglist>(const std::string &amp;fmt)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::formula</name>
    <filename>classspot_1_1formula.html</filename>
    <class kind="class">spot::formula::formula_child_iterator</class>
    <member kind="function">
      <type></type>
      <name>formula</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a3650f240a95e6bbdcb1dca3be137556d</anchor>
      <arglist>(const fnode *f) noexcept</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>formula</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ab84f2356783f4bc25e14af1b594ebb7e</anchor>
      <arglist>(std::nullptr_t) noexcept</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>formula</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>af352261e4161eae7dafa8977282c917b</anchor>
      <arglist>() noexcept</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>formula</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>aa5e7ac85105631e206b3a1f20e95d68e</anchor>
      <arglist>(const formula &amp;f) noexcept</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>formula</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a32ee7e855d716a65a1f6b28b83fd84de</anchor>
      <arglist>(formula &amp;&amp;f) noexcept</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~formula</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ade25a9fcbb23e731fce9aeec55c85904</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const formula &amp;</type>
      <name>operator=</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ac1779d59f21d2b9cacf5ebff75a02e5f</anchor>
      <arglist>(std::nullptr_t)</arglist>
    </member>
    <member kind="function">
      <type>const fnode *</type>
      <name>to_node_</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ae5a935c3549c9ad4964f132a21f5a649</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>op</type>
      <name>kind</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a1737422f6d91ea685e1bfac3974f7c40</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>kindstr</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ab3dc04972fefa8131af242b63f1ad29c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a237905dc0f433f2349aa7271f9c67416</anchor>
      <arglist>(op o) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a02b80d4d603b1e08a18766502831dcf3</anchor>
      <arglist>(op o1, op o2) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a22183eee275b9614d4a2039c34d292c5</anchor>
      <arglist>(std::initializer_list&lt; op &gt; l) const </arglist>
    </member>
    <member kind="function">
      <type>formula</type>
      <name>get_child_of</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>aa67a5698f89859b7cf1571b6305f6efe</anchor>
      <arglist>(op o) const </arglist>
    </member>
    <member kind="function">
      <type>formula</type>
      <name>get_child_of</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a4fe69abfcde797f2a2a32186cf6360bf</anchor>
      <arglist>(std::initializer_list&lt; op &gt; l) const </arglist>
    </member>
    <member kind="function">
      <type>unsigned</type>
      <name>min</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a55e8852e3e6049f75c474811b5c5b16c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned</type>
      <name>max</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>aa11728db924688b6ec5c22a8eadd32d8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned</type>
      <name>size</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>acdcfff906333e868bf1f020f98dca4b5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>id</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a537cfc653fdc65cfd61450227eb6bdab</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>formula_child_iterator</type>
      <name>begin</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a709b848acbb03811df01abdd307767d3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>formula_child_iterator</type>
      <name>end</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>aefb02f4e6ee7fcf827d107dfe0304620</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>formula</type>
      <name>operator[]</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a57297c94508ccbd9b4f3741520a81467</anchor>
      <arglist>(unsigned i) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_ff</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ab0ea84a42fd9f9361157e9f1d97d1849</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_tt</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>aea22729747d45aaacf554914653a74f6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_eword</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>acf87bf96b5da0c2cf4d3b5d16d348e1f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_constant</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a5fc8c292f02ade3d70cb22a663da032c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_Kleene_star</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a594c7bcbc8391b5f06136f8db18d4410</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_literal</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a163547a4b19fedf0556ade342bfcb9de</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const std::string &amp;</type>
      <name>ap_name</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a22389de0de474d9fc750d00e1095a21f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>dump</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a2b542843c8a2779a67f4452ba2003393</anchor>
      <arglist>(std::ostream &amp;os) const </arglist>
    </member>
    <member kind="function">
      <type>formula</type>
      <name>all_but</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a8f625fb5f7d836931139c57ff7adbc40</anchor>
      <arglist>(unsigned i) const </arglist>
    </member>
    <member kind="function">
      <type>unsigned</type>
      <name>boolean_count</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a2d8743e9eadb3f4e60a1d4916912acda</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>formula</type>
      <name>boolean_operands</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ab6012adc8217c03d77c0ccf81fa7b096</anchor>
      <arglist>(unsigned *width=nullptr) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_boolean</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a7682ec28561f2951eff300a162bfd7a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_sugar_free_boolean</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a6aa281e00b591e43806939a7795137d2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_in_nenoform</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a2b084e6a415641fe32b7273e7085f5b6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_syntactic_stutter_invariant</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a396a8d34603183d9065a398f93e744ba</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_sugar_free_ltl</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a6a116bacbdf8e7eb219c2e4e2e637281</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_ltl_formula</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a063af41d02d27ec40df9a829e6cbef2e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_psl_formula</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>af5c7d121cdf4af044bc94a50b5e34d84</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_sere_formula</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a4d02526b80113f8ac2c0197a8276c48c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_finite</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a4c181a6e8fc32189262be8cdceb71a79</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_eventual</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ac529e5c84820fca23d55bab0a8eae3f3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_universal</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a9f1ceade62bbe4f05512f6453304c831</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_syntactic_safety</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a10f3083518ec65320fd05b6192892065</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_syntactic_guarantee</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a09d58ad10b79f7b93467752aa9120171</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_syntactic_obligation</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ade537aa28016b8b08b7742ed1861973e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_syntactic_recurrence</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a67d4b19fcf2a1d03faa0d425236e98a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_syntactic_persistence</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a6ef3ef4a63a894cdecc778afb8a286ab</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_marked</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a5651320ad0922b6926f12e11c04347c1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>accepts_eword</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ad5018c2b4981216a92dc1a1577fbcd3d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_lbt_atomic_props</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a846065e8b839eff0829321e1407218b0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_spin_atomic_props</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a8f364dd8d8bc89817204a7eeb576625d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>formula</type>
      <name>map</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ac77243059ef0a74c931ba5c5a0d022f6</anchor>
      <arglist>(Trans trans)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>traverse</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a223adfdfffd057e26630dd01671611a4</anchor>
      <arglist>(Func func)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static constexpr uint8_t</type>
      <name>unbounded</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a568cccf8ab356e4fc1bf51d0dfde3ed4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>ap</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ab98bd271b42803536d4d8343fe073338</anchor>
      <arglist>(const std::string &amp;name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>ap</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>aaea70bc0f7eed7f79a2b505521e1a183</anchor>
      <arglist>(const formula &amp;a)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>sugar_goto</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a35c167d8250c218189ec59a5715e5332</anchor>
      <arglist>(const formula &amp;b, uint8_t min, uint8_t max)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>sugar_equal</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a6fd73e2c6725dda6a8ec362b68036f85</anchor>
      <arglist>(const formula &amp;b, uint8_t min, uint8_t max)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>ff</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a7c2db3fddaf3894c1e882fb1e038b002</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>tt</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>aee20bbf397a14b3544606f45f4c074fc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>eword</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a62fe088667ee5af3308e2968ba90023e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>one_star</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a5327adea33c1c81f73e4b7fc58720d16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>unop</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>af929523d6cae3203d20616bd8b1bdf6e</anchor>
      <arglist>(op o, const formula &amp;f)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>unop</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a6076a523eccc53cc40bf121a6ed8121d</anchor>
      <arglist>(op o, formula &amp;&amp;f)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Not</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a74822aeec9d41149e0beb682bc7cfc17</anchor>
      <arglist>(const formula &amp;f)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Not</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>abf9c92a1e32cc5becc1ca13898a944b6</anchor>
      <arglist>(formula &amp;&amp;f)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>X</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a48b3bf58299703b00dffd64f64d5d3d5</anchor>
      <arglist>(const formula &amp;f)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>X</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a66df3a2dcbe10a68cd276eb02bdf5d71</anchor>
      <arglist>(formula &amp;&amp;f)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>F</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a294c3bf02c9552861252e6e05b699d29</anchor>
      <arglist>(const formula &amp;f)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>F</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ae2fb4e4a62e18e529f00401f243d2700</anchor>
      <arglist>(formula &amp;&amp;f)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>G</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a3d04b46615516d3d24f2de7ca8037de0</anchor>
      <arglist>(const formula &amp;f)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>G</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a96d7994f9aa0db3707140e11281e639d</anchor>
      <arglist>(formula &amp;&amp;f)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Closure</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ac066a5fc4122558246002d00027326b6</anchor>
      <arglist>(const formula &amp;f)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Closure</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ad0b8d72c9bb2f8bf25be889d333c3425</anchor>
      <arglist>(formula &amp;&amp;f)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>NegClosure</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a9944e90b9b13fda2bfcc6cd76510cb7e</anchor>
      <arglist>(const formula &amp;f)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>NegClosure</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ab14d40139d07f5537f66dc6e95ea3256</anchor>
      <arglist>(formula &amp;&amp;f)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>NegClosureMarked</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>af389399d493c0559fe423375c3edcec0</anchor>
      <arglist>(const formula &amp;f)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>NegClosureMarked</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a7d58d0d0e93f397f2da14b377f2722d6</anchor>
      <arglist>(formula &amp;&amp;f)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>binop</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a22a260c7ca7c013b2b85c9f6a5cbb07b</anchor>
      <arglist>(op o, const formula &amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>binop</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a81d49d5486cb5dfc94c047306acbc7ca</anchor>
      <arglist>(op o, const formula &amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>binop</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>aeaa31b72b596b7b207e7d4dc0ca423d7</anchor>
      <arglist>(op o, formula &amp;&amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>binop</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>aa9bd4bfe1c0d8ee6b429b889aee20d5d</anchor>
      <arglist>(op o, formula &amp;&amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Xor</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a01a38bdfd89a2d654e42061076f2c9d7</anchor>
      <arglist>(const formula &amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Xor</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a0ac7e4ca73e43973898b3e69e3dd8fcc</anchor>
      <arglist>(const formula &amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Xor</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a38e9a406b6a5d662504b46d02666dcdf</anchor>
      <arglist>(formula &amp;&amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Xor</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a12bda8ec8752616d027f0fddd625c3e6</anchor>
      <arglist>(formula &amp;&amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Implies</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a01aad3fd13d83ef7bab09ba04668bbf2</anchor>
      <arglist>(const formula &amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Implies</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a5c5503203e169633f5d5a975bfdaca68</anchor>
      <arglist>(const formula &amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Implies</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a50669743213aef3ef38d552e051809cd</anchor>
      <arglist>(formula &amp;&amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Implies</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ac09b5fd992b78050753651eabf18a8ef</anchor>
      <arglist>(formula &amp;&amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Equiv</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a8abf13e6582d549e5aa12c4ba12bc997</anchor>
      <arglist>(const formula &amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Equiv</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a0914d75486eac8a2d22fcd87edcf797f</anchor>
      <arglist>(const formula &amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Equiv</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a6deda1f83eb7eb4847e84b3f26162974</anchor>
      <arglist>(formula &amp;&amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Equiv</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ad1ed0c56dbdde363a3b05846a4a407da</anchor>
      <arglist>(formula &amp;&amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>U</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a35c4334f1dd6b5448c009b94b403bfbe</anchor>
      <arglist>(const formula &amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>U</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a2e64b39eb06fb28b067fc6b9857f08da</anchor>
      <arglist>(const formula &amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>U</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a0fa1d0aed98505b0c33f4ca5adf831ab</anchor>
      <arglist>(formula &amp;&amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>U</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a7ce32445949d1e633cba5b4b2bd706c4</anchor>
      <arglist>(formula &amp;&amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>R</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ad9d9f94b30466969ed548c48784d8963</anchor>
      <arglist>(const formula &amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>R</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>afb6e4c0fe8a7c04aad474c1e96b828c4</anchor>
      <arglist>(const formula &amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>R</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a3b4b5dd56cee11dbb9579a5366a42133</anchor>
      <arglist>(formula &amp;&amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>R</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>aab42645f3b6d7161686d0b734845d01c</anchor>
      <arglist>(formula &amp;&amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>W</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ae04bc5ea3bbdd6024937eb19f144adf4</anchor>
      <arglist>(const formula &amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>W</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a2b72a36c07f7fbcf60df872d650a8c10</anchor>
      <arglist>(const formula &amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>W</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a5f777b65aa5c75fdfc9ca3250b994c3b</anchor>
      <arglist>(formula &amp;&amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>W</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>af7b6e78b168c2bdb8b18c3e8e5634ce4</anchor>
      <arglist>(formula &amp;&amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>M</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a7f964442cad433459626d35326508523</anchor>
      <arglist>(const formula &amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>M</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a16a721795d5d7ba84d8a67de8fa97049</anchor>
      <arglist>(const formula &amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>M</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a5216b7c8543e4b9b02978efbfa6b8343</anchor>
      <arglist>(formula &amp;&amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>M</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a6ab58ef602ef6711cfeca93d89ab02fd</anchor>
      <arglist>(formula &amp;&amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>EConcat</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a7d547a94d10b105d3cf0dfcd17488135</anchor>
      <arglist>(const formula &amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>EConcat</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>abe8905f6509e02b1db605da649225ed1</anchor>
      <arglist>(const formula &amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>EConcat</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a8a4155e7974a4145591f81b469d04c90</anchor>
      <arglist>(formula &amp;&amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>EConcat</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a50de506960f8e329d678204f35c121ab</anchor>
      <arglist>(formula &amp;&amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>EConcatMarked</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a9163c602c84837e1b667b159987c424c</anchor>
      <arglist>(const formula &amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>EConcatMarked</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ada34ebc425d71c676c3451b2e0258ff9</anchor>
      <arglist>(const formula &amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>EConcatMarked</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a1d5dc949600da9b3080dfc8883b32c21</anchor>
      <arglist>(formula &amp;&amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>EConcatMarked</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a926decfe64f6a62c7eae0c91bcf05a7a</anchor>
      <arglist>(formula &amp;&amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>UConcat</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a4b909bf6b451e28df9e7d3e8305578a1</anchor>
      <arglist>(const formula &amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>UConcat</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a7c3d213444118ee9d3a401eabd73383b</anchor>
      <arglist>(const formula &amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>UConcat</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>aad6b4c5d2d991d781c9cdcd2c7f22932</anchor>
      <arglist>(formula &amp;&amp;f, const formula &amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>UConcat</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a36e20c8209f4fcd1f7f375d34e1b2998</anchor>
      <arglist>(formula &amp;&amp;f, formula &amp;&amp;g)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>multop</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a8b35c64d4544732bbd03e65a0b785a90</anchor>
      <arglist>(op o, const std::vector&lt; formula &gt; &amp;l)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>multop</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a294a16e8be634c2d41b971468035a628</anchor>
      <arglist>(op o, std::vector&lt; formula &gt; &amp;&amp;l)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Or</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a9e4fa36b8a3e0752207a4d4557a61e8e</anchor>
      <arglist>(const std::vector&lt; formula &gt; &amp;l)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Or</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a9c5fab39d8d3586e593d813089ffd44f</anchor>
      <arglist>(std::vector&lt; formula &gt; &amp;&amp;l)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>OrRat</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a86b1a7d47bdf317deb2d91ae971fa07e</anchor>
      <arglist>(const std::vector&lt; formula &gt; &amp;l)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>OrRat</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a68cb3a02b332fd1110b3dca8a8cdb906</anchor>
      <arglist>(std::vector&lt; formula &gt; &amp;&amp;l)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>And</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ab0735a509d3c2fb321bf733e3dc3efc3</anchor>
      <arglist>(const std::vector&lt; formula &gt; &amp;l)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>And</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ad87d9bc43ff1c36db47c18102f86321f</anchor>
      <arglist>(std::vector&lt; formula &gt; &amp;&amp;l)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>AndRat</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ab017414daa053f381eb8e17ecfd613dd</anchor>
      <arglist>(const std::vector&lt; formula &gt; &amp;l)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>AndRat</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a3e686f301e2d0b9d93a7e2412c65278c</anchor>
      <arglist>(std::vector&lt; formula &gt; &amp;&amp;l)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>AndNLM</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a3e51b998c3ec965861d0822e7bfcac41</anchor>
      <arglist>(const std::vector&lt; formula &gt; &amp;l)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>AndNLM</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ab5e78b00fc4f4a5ddc056608e91f9075</anchor>
      <arglist>(std::vector&lt; formula &gt; &amp;&amp;l)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Concat</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>aafff06af8c61d25eac09ef67e6f96ce9</anchor>
      <arglist>(const std::vector&lt; formula &gt; &amp;l)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Concat</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a1cab72102ccb7b59f5b7ce1e0bdaf8cc</anchor>
      <arglist>(std::vector&lt; formula &gt; &amp;&amp;l)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Fusion</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a79019c0498b6d2e786a57f0d0cdfca41</anchor>
      <arglist>(const std::vector&lt; formula &gt; &amp;l)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Fusion</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a9b1052927ee10978c8359b8b1fb08349</anchor>
      <arglist>(std::vector&lt; formula &gt; &amp;&amp;l)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>bunop</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ab2d4f82bf07c87fef630e4385badd136</anchor>
      <arglist>(op o, const formula &amp;f, uint8_t min=0U, uint8_t max=unbounded())</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>bunop</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>ad9d85f4a15d89cdc535bd00e7f00c6e4</anchor>
      <arglist>(op o, formula &amp;&amp;f, uint8_t min=0U, uint8_t max=unbounded())</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Star</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a6d8ab98a44fc64093425f3a8cbc87ca3</anchor>
      <arglist>(const formula &amp;f, uint8_t min=0U, uint8_t max=unbounded())</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>Star</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>addb2d6e0fba15f48b54eb32257628ee2</anchor>
      <arglist>(formula &amp;&amp;f, uint8_t min=0U, uint8_t max=unbounded())</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>FStar</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a4bf212e51557a5fe3073021f80d38e16</anchor>
      <arglist>(const formula &amp;f, uint8_t min=0U, uint8_t max=unbounded())</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static formula</type>
      <name>FStar</name>
      <anchorfile>classspot_1_1formula.html</anchorfile>
      <anchor>a6b8037998ed74dc4d9ad0f9196c537e9</anchor>
      <arglist>(formula &amp;&amp;f, uint8_t min=0U, uint8_t max=unbounded())</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::formula::formula_child_iterator</name>
    <filename>classspot_1_1formula_1_1formula__child__iterator.html</filename>
  </compound>
  <compound kind="struct">
    <name>spot::formula_ptr_less_than_bool_first</name>
    <filename>structspot_1_1formula__ptr__less__than__bool__first.html</filename>
  </compound>
  <compound kind="struct">
    <name>spot::hoa_abort</name>
    <filename>structspot_1_1hoa__abort.html</filename>
  </compound>
  <compound kind="struct">
    <name>spot::identity_hash</name>
    <filename>structspot_1_1identity__hash.html</filename>
    <templarg></templarg>
  </compound>
  <compound kind="class">
    <name>spot::isomorphism_checker</name>
    <filename>classspot_1_1isomorphism__checker.html</filename>
    <member kind="function">
      <type>bool</type>
      <name>is_isomorphic</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>ga1517671dae9e24214418ab565b516257</anchor>
      <arglist>(const const_twa_graph_ptr aut)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>are_isomorphic</name>
      <anchorfile>group__twa__misc.html</anchorfile>
      <anchor>ga0e1216c4bd264ac030492a3489295e54</anchor>
      <arglist>(const const_twa_graph_ptr ref, const const_twa_graph_ptr aut)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::kripke</name>
    <filename>classspot_1_1kripke.html</filename>
    <base>spot::fair_kripke</base>
    <member kind="function" virtualness="virtual">
      <type>virtual acc_cond::mark_t</type>
      <name>state_acceptance_mark</name>
      <anchorfile>classspot_1_1kripke.html</anchorfile>
      <anchor>ae249bc55d48c09888013275ceff90a18</anchor>
      <arglist>(const state *) const override</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::kripke_graph</name>
    <filename>classspot_1_1kripke__graph.html</filename>
    <base>spot::kripke</base>
    <member kind="function" virtualness="virtual">
      <type>virtual const kripke_graph_state *</type>
      <name>get_init_state</name>
      <anchorfile>classspot_1_1kripke__graph.html</anchorfile>
      <anchor>aa8cf67b8b7f7bf3c30c30a005ff82429</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual kripke_graph_succ_iterator&lt; graph_t &gt; *</type>
      <name>succ_iter</name>
      <anchorfile>classspot_1_1kripke__graph.html</anchorfile>
      <anchor>a3f1537d6da246c88758046790992a49c</anchor>
      <arglist>(const spot::state *st) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual std::string</type>
      <name>format_state</name>
      <anchorfile>classspot_1_1kripke__graph.html</anchorfile>
      <anchor>a984d822e89344d3fcf6670d99c37fc29</anchor>
      <arglist>(const state *st) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bdd</type>
      <name>state_condition</name>
      <anchorfile>classspot_1_1kripke__graph.html</anchorfile>
      <anchor>af7d7b73d9402f75d1551bca2194b8fe3</anchor>
      <arglist>(const state *s) const override</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>spot::kripke_graph_state</name>
    <filename>structspot_1_1kripke__graph__state.html</filename>
    <base>spot::state</base>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>compare</name>
      <anchorfile>structspot_1_1kripke__graph__state.html</anchorfile>
      <anchor>a8c36cf05ecd924880b8302b28a44fd48</anchor>
      <arglist>(const spot::state *other) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual size_t</type>
      <name>hash</name>
      <anchorfile>structspot_1_1kripke__graph__state.html</anchorfile>
      <anchor>a110cd012db94d2181bb2eaadf825a6bf</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual kripke_graph_state *</type>
      <name>clone</name>
      <anchorfile>structspot_1_1kripke__graph__state.html</anchorfile>
      <anchor>a3322f9148bc8c057351d56e5ece413b3</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>destroy</name>
      <anchorfile>structspot_1_1kripke__graph__state.html</anchorfile>
      <anchor>a551b7b51d39e2668332fed280bd3901f</anchor>
      <arglist>() const override</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::kripke_graph_succ_iterator</name>
    <filename>classspot_1_1kripke__graph__succ__iterator.html</filename>
    <templarg>Graph</templarg>
    <base>spot::kripke_succ_iterator</base>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>first</name>
      <anchorfile>classspot_1_1kripke__graph__succ__iterator.html</anchorfile>
      <anchor>a5939b4e9071e82d293e1027679c53fc5</anchor>
      <arglist>() override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>next</name>
      <anchorfile>classspot_1_1kripke__graph__succ__iterator.html</anchorfile>
      <anchor>ac2a3cf3c304d55e7a757bded9d024ee3</anchor>
      <arglist>() override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>done</name>
      <anchorfile>classspot_1_1kripke__graph__succ__iterator.html</anchorfile>
      <anchor>a60f5e75c81f95cc58e0d246c4948fe6e</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual kripke_graph_state *</type>
      <name>dst</name>
      <anchorfile>classspot_1_1kripke__graph__succ__iterator.html</anchorfile>
      <anchor>af850c82c02d049351a9fb55720f267ef</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bdd</type>
      <name>cond</name>
      <anchorfile>classspot_1_1kripke__succ__iterator.html</anchorfile>
      <anchor>a486ffc7629fc113cf7659af1d7e17f6e</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual acc_cond::mark_t</type>
      <name>acc</name>
      <anchorfile>classspot_1_1kripke__succ__iterator.html</anchorfile>
      <anchor>af4dd792198d83b4ef2ff7ee34d7bf9fa</anchor>
      <arglist>() const override</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::kripke_succ_iterator</name>
    <filename>classspot_1_1kripke__succ__iterator.html</filename>
    <base>spot::twa_succ_iterator</base>
    <member kind="function">
      <type></type>
      <name>kripke_succ_iterator</name>
      <anchorfile>classspot_1_1kripke__succ__iterator.html</anchorfile>
      <anchor>ad9e251d935e182910c21e05cb85e75d4</anchor>
      <arglist>(const bdd &amp;cond)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::language_containment_checker</name>
    <filename>classspot_1_1language__containment__checker.html</filename>
    <member kind="function">
      <type></type>
      <name>language_containment_checker</name>
      <anchorfile>classspot_1_1language__containment__checker.html</anchorfile>
      <anchor>a051289e5eceda3ed625eaea60d95a642</anchor>
      <arglist>(bdd_dict_ptr dict=make_bdd_dict(), bool exprop=false, bool symb_merge=true, bool branching_postponement=false, bool fair_loop_approx=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>classspot_1_1language__containment__checker.html</anchorfile>
      <anchor>a20571e0ae499e3cd411205ea7b2ef0b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>contained</name>
      <anchorfile>classspot_1_1language__containment__checker.html</anchorfile>
      <anchor>a4b1b8a39532533eb5a11537113bcb941</anchor>
      <arglist>(formula l, formula g)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>neg_contained</name>
      <anchorfile>classspot_1_1language__containment__checker.html</anchorfile>
      <anchor>aab88467844a1dcfc7d67a6a17ca92e0e</anchor>
      <arglist>(formula l, formula g)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>contained_neg</name>
      <anchorfile>classspot_1_1language__containment__checker.html</anchorfile>
      <anchor>a96863928cad9bdb6d05069c98f7160b3</anchor>
      <arglist>(formula l, formula g)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>classspot_1_1language__containment__checker.html</anchorfile>
      <anchor>ab1bcbe6a4fd7abc7fcfb89a7a68d868b</anchor>
      <arglist>(formula l, formula g)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::ltsmin_model</name>
    <filename>classspot_1_1ltsmin__model.html</filename>
    <member kind="function">
      <type>int</type>
      <name>state_size</name>
      <anchorfile>classspot_1_1ltsmin__model.html</anchorfile>
      <anchor>aa0244749e3cee56afcce27667253d8a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>state_variable_name</name>
      <anchorfile>classspot_1_1ltsmin__model.html</anchorfile>
      <anchor>a2cf303ed80369a1ee6ba738ad219bc15</anchor>
      <arglist>(int var) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>state_variable_type</name>
      <anchorfile>classspot_1_1ltsmin__model.html</anchorfile>
      <anchor>a0143b58958947f7a4fbc7309ee07cf1d</anchor>
      <arglist>(int var) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>type_count</name>
      <anchorfile>classspot_1_1ltsmin__model.html</anchorfile>
      <anchor>a674a46273d2e59bc5d6f09f33ed29341</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>type_name</name>
      <anchorfile>classspot_1_1ltsmin__model.html</anchorfile>
      <anchor>ab964678288dadb009c6f2070d05e725a</anchor>
      <arglist>(int type) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>type_value_count</name>
      <anchorfile>classspot_1_1ltsmin__model.html</anchorfile>
      <anchor>a64b9cc60aa3576bd797ad7398b64e7ee</anchor>
      <arglist>(int type)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>type_value_name</name>
      <anchorfile>classspot_1_1ltsmin__model.html</anchorfile>
      <anchor>abec0e52dea3204f4b386ca8918709d10</anchor>
      <arglist>(int type, int val)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::mark_tools</name>
    <filename>classspot_1_1mark__tools.html</filename>
    <member kind="function">
      <type>formula</type>
      <name>mark_concat_ops</name>
      <anchorfile>group__tl__rewriting.html</anchorfile>
      <anchor>gae55a5d2bcb08fa6cd5ef3acf5087e578</anchor>
      <arglist>(formula f)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::minato_isop</name>
    <filename>classspot_1_1minato__isop.html</filename>
    <member kind="function">
      <type></type>
      <name>minato_isop</name>
      <anchorfile>classspot_1_1minato__isop.html</anchorfile>
      <anchor>a219911ee13dbbe288f7ec765bf4eab93</anchor>
      <arglist>(bdd input)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>minato_isop</name>
      <anchorfile>classspot_1_1minato__isop.html</anchorfile>
      <anchor>a2962f8b4798aad61c41aa2e1124581f2</anchor>
      <arglist>(bdd input, bdd vars)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>minato_isop</name>
      <anchorfile>classspot_1_1minato__isop.html</anchorfile>
      <anchor>a43e575064d8ee6e4810f77ccfacf13d5</anchor>
      <arglist>(bdd input_min, bdd input_max, bool)</arglist>
    </member>
    <member kind="function">
      <type>bdd</type>
      <name>next</name>
      <anchorfile>classspot_1_1minato__isop.html</anchorfile>
      <anchor>af3b6eb9c04010f353116a38ed670b7e7</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::multiple_size_pool</name>
    <filename>classspot_1_1multiple__size__pool.html</filename>
    <member kind="function">
      <type></type>
      <name>multiple_size_pool</name>
      <anchorfile>classspot_1_1multiple__size__pool.html</anchorfile>
      <anchor>ae56659d9df67d2439688a685d4871588</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~multiple_size_pool</name>
      <anchorfile>classspot_1_1multiple__size__pool.html</anchorfile>
      <anchor>a438325e77081406270ccfd860cec5ddf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>allocate</name>
      <anchorfile>classspot_1_1multiple__size__pool.html</anchorfile>
      <anchor>a179d051d39ac6ac65b8d9688b421152c</anchor>
      <arglist>(size_t size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deallocate</name>
      <anchorfile>classspot_1_1multiple__size__pool.html</anchorfile>
      <anchor>ab4090c05e6a847fa02d6364e653b3d49</anchor>
      <arglist>(const void *ptr, size_t size)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::named_graph</name>
    <filename>classspot_1_1named__graph.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="function">
      <type>bool</type>
      <name>alias_state</name>
      <anchorfile>classspot_1_1named__graph.html</anchorfile>
      <anchor>a7f0e8b42fa8812322e42aa2386a08c32</anchor>
      <arglist>(state s, name newname)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::open_temporary_file</name>
    <filename>classspot_1_1open__temporary__file.html</filename>
    <base>spot::temporary_file</base>
  </compound>
  <compound kind="class">
    <name>spot::option_map</name>
    <filename>classspot_1_1option__map.html</filename>
    <member kind="function">
      <type>const char *</type>
      <name>parse_options</name>
      <anchorfile>classspot_1_1option__map.html</anchorfile>
      <anchor>acb6b25bf19608a1927e5d8daaba72a05</anchor>
      <arglist>(const char *options)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get</name>
      <anchorfile>classspot_1_1option__map.html</anchorfile>
      <anchor>a9b3db963d1cca0285d320bf5ea616d8c</anchor>
      <arglist>(const char *option, int def=0) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_str</name>
      <anchorfile>classspot_1_1option__map.html</anchorfile>
      <anchor>a37decc6787a6e4c0fbdd26d7314e9338</anchor>
      <arglist>(const char *option, std::string def={}) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator[]</name>
      <anchorfile>classspot_1_1option__map.html</anchorfile>
      <anchor>adbe2aa8f513c8f4251b6f78f722c3cdf</anchor>
      <arglist>(const char *option) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>set</name>
      <anchorfile>classspot_1_1option__map.html</anchorfile>
      <anchor>ad9fb6b43a106db55f9b84b59ed766646</anchor>
      <arglist>(const char *option, int val, int def=0)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>set_str</name>
      <anchorfile>classspot_1_1option__map.html</anchorfile>
      <anchor>a4d8d4504019adb99748d763c5040420a</anchor>
      <arglist>(const char *option, std::string val, std::string def={})</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>report_unused_options</name>
      <anchorfile>classspot_1_1option__map.html</anchorfile>
      <anchor>a7ad9708a61f98196cf46d566b787f829</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classspot_1_1option__map.html</anchorfile>
      <anchor>a54ca434ab0eec0f87e1b5bcf71f50785</anchor>
      <arglist>(const option_map &amp;o)</arglist>
    </member>
    <member kind="function">
      <type>int &amp;</type>
      <name>operator[]</name>
      <anchorfile>classspot_1_1option__map.html</anchorfile>
      <anchor>a6855a963741c87f0dcb89fe12f98e849</anchor>
      <arglist>(const char *option)</arglist>
    </member>
    <member kind="friend">
      <type>friend std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>classspot_1_1option__map.html</anchorfile>
      <anchor>aff406edae234bc7fe98f6eea26adfbca</anchor>
      <arglist>(std::ostream &amp;os, const option_map &amp;m)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>spot::pair_hash</name>
    <filename>structspot_1_1pair__hash.html</filename>
  </compound>
  <compound kind="struct">
    <name>spot::parse_error</name>
    <filename>structspot_1_1parse__error.html</filename>
  </compound>
  <compound kind="struct">
    <name>spot::parsed_aut</name>
    <filename>structspot_1_1parsed__aut.html</filename>
    <member kind="function">
      <type>bool</type>
      <name>format_errors</name>
      <anchorfile>structspot_1_1parsed__aut.html</anchorfile>
      <anchor>a2586cab6fd3ea4adf35986187598fc7f</anchor>
      <arglist>(std::ostream &amp;os)</arglist>
    </member>
    <member kind="variable">
      <type>twa_graph_ptr</type>
      <name>aut</name>
      <anchorfile>structspot_1_1parsed__aut.html</anchorfile>
      <anchor>ac0c56e6bcaf8c32024df7869a2d0d2e5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>kripke_graph_ptr</type>
      <name>ks</name>
      <anchorfile>structspot_1_1parsed__aut.html</anchorfile>
      <anchor>a137c878c9b71f3f23b5bd24e78bccebf</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>aborted</name>
      <anchorfile>structspot_1_1parsed__aut.html</anchorfile>
      <anchor>ae2be3ebe7dc882df0fd11f3afb5e8893</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>spot::location</type>
      <name>loc</name>
      <anchorfile>structspot_1_1parsed__aut.html</anchorfile>
      <anchor>a0fdf812bc9697c713a2b5adf897e0da3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>parsed_aut_type</type>
      <name>type</name>
      <anchorfile>structspot_1_1parsed__aut.html</anchorfile>
      <anchor>a16dfcb277323771d3ac26ea535080ea3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const std::string</type>
      <name>filename</name>
      <anchorfile>structspot_1_1parsed__aut.html</anchorfile>
      <anchor>a35a3aaa0ba0aa044d1a38008c4530792</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>parse_aut_error_list</type>
      <name>errors</name>
      <anchorfile>structspot_1_1parsed__aut.html</anchorfile>
      <anchor>a444e53e64b16042f874a64476f38ad93</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>spot::parsed_formula</name>
    <filename>structspot_1_1parsed__formula.html</filename>
    <member kind="function">
      <type>bool</type>
      <name>format_errors</name>
      <anchorfile>structspot_1_1parsed__formula.html</anchorfile>
      <anchor>ae5a7383fb8eb2058540442b0090791f1</anchor>
      <arglist>(std::ostream &amp;os)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>format_errors</name>
      <anchorfile>structspot_1_1parsed__formula.html</anchorfile>
      <anchor>aaaa38ed77cc1c8965c043b1f71ca8083</anchor>
      <arglist>(std::ostream &amp;os, const std::string &amp;input, unsigned shift)</arglist>
    </member>
    <member kind="variable">
      <type>formula</type>
      <name>f</name>
      <anchorfile>structspot_1_1parsed__formula.html</anchorfile>
      <anchor>a26f98670c7a180712983f4efb77c6cb1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>std::string</type>
      <name>input</name>
      <anchorfile>structspot_1_1parsed__formula.html</anchorfile>
      <anchor>a998a54352419a48a6a6c50653d399b17</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>parse_error_list</type>
      <name>errors</name>
      <anchorfile>structspot_1_1parsed__formula.html</anchorfile>
      <anchor>a7434f0c64850c13b4976b34b1c27949e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::postprocessor</name>
    <filename>classspot_1_1postprocessor.html</filename>
    <member kind="function">
      <type></type>
      <name>postprocessor</name>
      <anchorfile>classspot_1_1postprocessor.html</anchorfile>
      <anchor>a52c3e55c328dc539570ea13124c93883</anchor>
      <arglist>(const option_map *opt=nullptr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_type</name>
      <anchorfile>classspot_1_1postprocessor.html</anchorfile>
      <anchor>adfe4389388a824a09a1b34aa30652f48</anchor>
      <arglist>(output_type type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_pref</name>
      <anchorfile>classspot_1_1postprocessor.html</anchorfile>
      <anchor>a1d11317115fdc3615576c78b23730092</anchor>
      <arglist>(output_pref pref)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_level</name>
      <anchorfile>classspot_1_1postprocessor.html</anchorfile>
      <anchor>abec9eedb477a3cd30bb643ef24541fcc</anchor>
      <arglist>(optimization_level level)</arglist>
    </member>
    <member kind="function">
      <type>twa_graph_ptr</type>
      <name>run</name>
      <anchorfile>classspot_1_1postprocessor.html</anchorfile>
      <anchor>ad690646034b5ca8e991e908d9db46fd0</anchor>
      <arglist>(twa_graph_ptr input, formula f=nullptr)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>spot::power_map</name>
    <filename>structspot_1_1power__map.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::printable</name>
    <filename>classspot_1_1printable.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::printable_formula</name>
    <filename>classspot_1_1printable__formula.html</filename>
    <base>printable_value&lt; formula &gt;</base>
  </compound>
  <compound kind="class">
    <name>spot::printable_id</name>
    <filename>classspot_1_1printable__id.html</filename>
    <base>spot::printable</base>
  </compound>
  <compound kind="class">
    <name>spot::printable_percent</name>
    <filename>classspot_1_1printable__percent.html</filename>
    <base>spot::printable</base>
  </compound>
  <compound kind="class">
    <name>spot::printable_value</name>
    <filename>classspot_1_1printable__value.html</filename>
    <templarg>T</templarg>
    <base>spot::printable</base>
  </compound>
  <compound kind="struct">
    <name>spot::ptr_hash</name>
    <filename>structspot_1_1ptr__hash.html</filename>
    <templarg></templarg>
  </compound>
  <compound kind="class">
    <name>spot::randltlgenerator</name>
    <filename>classspot_1_1randltlgenerator.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::random_boolean</name>
    <filename>classspot_1_1random__boolean.html</filename>
    <base>spot::random_formula</base>
    <member kind="function">
      <type></type>
      <name>random_boolean</name>
      <anchorfile>classspot_1_1random__boolean.html</anchorfile>
      <anchor>a26232b43770954e44a9a4663053b0b5a</anchor>
      <arglist>(const atomic_prop_set *ap)</arglist>
    </member>
    <member kind="function">
      <type>const atomic_prop_set *</type>
      <name>ap</name>
      <anchorfile>classspot_1_1random__formula.html</anchorfile>
      <anchor>a7db10ce7bc117f642b790bc059a8a767</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>formula</type>
      <name>generate</name>
      <anchorfile>classspot_1_1random__formula.html</anchorfile>
      <anchor>a24f75c2a247586e87508e26b81e5085b</anchor>
      <arglist>(int n) const </arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>dump_priorities</name>
      <anchorfile>classspot_1_1random__formula.html</anchorfile>
      <anchor>a729d74e67e6defe7b98528aee6c89faa</anchor>
      <arglist>(std::ostream &amp;os) const </arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>parse_options</name>
      <anchorfile>classspot_1_1random__formula.html</anchorfile>
      <anchor>a2624129e08fc685f8a3c1a6f38808438</anchor>
      <arglist>(char *options)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::random_formula</name>
    <filename>classspot_1_1random__formula.html</filename>
    <class kind="struct">spot::random_formula::op_proba</class>
  </compound>
  <compound kind="struct">
    <name>spot::random_formula::op_proba</name>
    <filename>structspot_1_1random__formula_1_1op__proba.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::random_ltl</name>
    <filename>classspot_1_1random__ltl.html</filename>
    <base>spot::random_formula</base>
    <member kind="function">
      <type></type>
      <name>random_ltl</name>
      <anchorfile>classspot_1_1random__ltl.html</anchorfile>
      <anchor>ab62bca7a0dc5954cf48d275f75550659</anchor>
      <arglist>(const atomic_prop_set *ap)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::random_psl</name>
    <filename>classspot_1_1random__psl.html</filename>
    <base>spot::random_ltl</base>
    <member kind="function">
      <type></type>
      <name>random_psl</name>
      <anchorfile>classspot_1_1random__psl.html</anchorfile>
      <anchor>af7b808fba9101dc6bb7b9a3e6417c7a0</anchor>
      <arglist>(const atomic_prop_set *ap)</arglist>
    </member>
    <member kind="variable">
      <type>random_sere</type>
      <name>rs</name>
      <anchorfile>classspot_1_1random__psl.html</anchorfile>
      <anchor>a646dc78f619a02a8319e734bb8254efd</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::random_sere</name>
    <filename>classspot_1_1random__sere.html</filename>
    <base>spot::random_formula</base>
    <member kind="function">
      <type></type>
      <name>random_sere</name>
      <anchorfile>classspot_1_1random__sere.html</anchorfile>
      <anchor>adcddaf288a73d50ad16a2424fab62a00</anchor>
      <arglist>(const atomic_prop_set *ap)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::remove_ap</name>
    <filename>classspot_1_1remove__ap.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::satsolver</name>
    <filename>classspot_1_1satsolver.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::scc_info</name>
    <filename>classspot_1_1scc__info.html</filename>
    <class kind="class">spot::scc_info::scc_node</class>
    <member kind="function">
      <type>unsigned</type>
      <name>initial</name>
      <anchorfile>classspot_1_1scc__info.html</anchorfile>
      <anchor>a0a21fe8dc68f5ad39184bb9a2e2f4465</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; std::set&lt; acc_cond::mark_t &gt; &gt;</type>
      <name>used_acc</name>
      <anchorfile>classspot_1_1scc__info.html</anchorfile>
      <anchor>a8d6f55e487cbbf359d94bd1c5673c021</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::scc_info::scc_node</name>
    <filename>classspot_1_1scc__info_1_1scc__node.html</filename>
    <member kind="function">
      <type>bool</type>
      <name>is_accepting</name>
      <anchorfile>classspot_1_1scc__info_1_1scc__node.html</anchorfile>
      <anchor>a18b842c88d48acbea6353083fa6dbf53</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_rejecting</name>
      <anchorfile>classspot_1_1scc__info_1_1scc__node.html</anchorfile>
      <anchor>a7488eb4028955fbe5bb8c9ff290d903e</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::scc_stack</name>
    <filename>classspot_1_1scc__stack.html</filename>
    <class kind="struct">spot::scc_stack::connected_component</class>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classspot_1_1scc__stack.html</anchorfile>
      <anchor>ab41e8e1aad7d4ca3940f1eaf8064a0c2</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function">
      <type>connected_component &amp;</type>
      <name>top</name>
      <anchorfile>classspot_1_1scc__stack.html</anchorfile>
      <anchor>a9fb956e08441d13f89442ac99974b6af</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const connected_component &amp;</type>
      <name>top</name>
      <anchorfile>classspot_1_1scc__stack.html</anchorfile>
      <anchor>a1fcb202de7bce708b0616ce9ad9a1bdb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop</name>
      <anchorfile>classspot_1_1scc__stack.html</anchorfile>
      <anchor>a2da83367ca277053968ff856f3c6295b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>size</name>
      <anchorfile>classspot_1_1scc__stack.html</anchorfile>
      <anchor>a627055834783bbe23e93aa061bc5f7d3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::list&lt; const state * &gt; &amp;</type>
      <name>rem</name>
      <anchorfile>classspot_1_1scc__stack.html</anchorfile>
      <anchor>a74f1cf725431e87096f4823bc0d19bcf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>unsigned</type>
      <name>clear_rem</name>
      <anchorfile>classspot_1_1scc__stack.html</anchorfile>
      <anchor>a939ef574064e26b22df1a48d3e52cf27</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>empty</name>
      <anchorfile>classspot_1_1scc__stack.html</anchorfile>
      <anchor>af60619c5be8a175029f309481f56588f</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>spot::scc_stack::connected_component</name>
    <filename>structspot_1_1scc__stack_1_1connected__component.html</filename>
    <member kind="variable">
      <type>int</type>
      <name>index</name>
      <anchorfile>structspot_1_1scc__stack_1_1connected__component.html</anchorfile>
      <anchor>a58d4077c0bb19d470764be5e79a9adf0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>acc_cond::mark_t</type>
      <name>condition</name>
      <anchorfile>structspot_1_1scc__stack_1_1connected__component.html</anchorfile>
      <anchor>af4acf5e6e8af65a7ff88d372de7313b1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::scc_stack_ta</name>
    <filename>classspot_1_1scc__stack__ta.html</filename>
    <class kind="struct">spot::scc_stack_ta::connected_component</class>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classspot_1_1scc__stack__ta.html</anchorfile>
      <anchor>a728b9f4a4c7e88f62f6b7ca873cdabb7</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function">
      <type>connected_component &amp;</type>
      <name>top</name>
      <anchorfile>classspot_1_1scc__stack__ta.html</anchorfile>
      <anchor>a7890d4b313efcdb53a6581d2b0f453dc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const connected_component &amp;</type>
      <name>top</name>
      <anchorfile>classspot_1_1scc__stack__ta.html</anchorfile>
      <anchor>a200119230a7af3a3c5b5bb7ed1eba567</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop</name>
      <anchorfile>classspot_1_1scc__stack__ta.html</anchorfile>
      <anchor>a60865fb164be8b7fe75f8bf772992ed0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>size</name>
      <anchorfile>classspot_1_1scc__stack__ta.html</anchorfile>
      <anchor>a5c80fb3fafd706a720fcd00b2b838493</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::list&lt; const state * &gt; &amp;</type>
      <name>rem</name>
      <anchorfile>classspot_1_1scc__stack__ta.html</anchorfile>
      <anchor>a61d71e91360da1731177fa644e43d102</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>empty</name>
      <anchorfile>classspot_1_1scc__stack__ta.html</anchorfile>
      <anchor>a595d6e7699cd03fcf8e2127f2b9c6ee4</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>spot::scc_stack_ta::connected_component</name>
    <filename>structspot_1_1scc__stack__ta_1_1connected__component.html</filename>
    <member kind="variable">
      <type>int</type>
      <name>index</name>
      <anchorfile>structspot_1_1scc__stack__ta_1_1connected__component.html</anchorfile>
      <anchor>a8b831f37dc942f8f33d4a48376161e43</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>acc_cond::mark_t</type>
      <name>condition</name>
      <anchorfile>structspot_1_1scc__stack__ta_1_1connected__component.html</anchorfile>
      <anchor>a7994a074e5817bc2fa53bba81dc97ba2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::set_state</name>
    <filename>classspot_1_1set__state.html</filename>
    <base>spot::state</base>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>compare</name>
      <anchorfile>classspot_1_1set__state.html</anchorfile>
      <anchor>aab88efdaed8515a019636f3783551ecb</anchor>
      <arglist>(const spot::state *) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual size_t</type>
      <name>hash</name>
      <anchorfile>classspot_1_1set__state.html</anchorfile>
      <anchor>a81b450032e1348b57e38210ea58180d1</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual set_state *</type>
      <name>clone</name>
      <anchorfile>classspot_1_1set__state.html</anchorfile>
      <anchor>a09ad9bc2013690e458eb65c96dc41ac8</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>destroy</name>
      <anchorfile>classspot_1_1state.html</anchorfile>
      <anchor>afa00fb3e8019389e2b6fbec0b5e40ded</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::stat_printer</name>
    <filename>classspot_1_1stat__printer.html</filename>
    <base protection="protected">spot::formater</base>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>print</name>
      <anchorfile>classspot_1_1stat__printer.html</anchorfile>
      <anchor>ab20ec16ab2b47f39025fc07302df164c</anchor>
      <arglist>(const const_twa_graph_ptr &amp;aut, formula f=nullptr, double run_time=-1.)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::state</name>
    <filename>classspot_1_1state.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>compare</name>
      <anchorfile>classspot_1_1state.html</anchorfile>
      <anchor>af3a06cae8daa3aa622f83873e983b75c</anchor>
      <arglist>(const state *other) const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual size_t</type>
      <name>hash</name>
      <anchorfile>classspot_1_1state.html</anchorfile>
      <anchor>a453665382e0f590fab7d6608e690729f</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual state *</type>
      <name>clone</name>
      <anchorfile>classspot_1_1state.html</anchorfile>
      <anchor>a761dcaab0d082dd18db5f6ebf7c38ce0</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~state</name>
      <anchorfile>classspot_1_1state.html</anchorfile>
      <anchor>a93b28d1aa2200cccdb4159bcf3e7b761</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::state_product</name>
    <filename>classspot_1_1state__product.html</filename>
    <base>spot::state</base>
    <member kind="function">
      <type></type>
      <name>state_product</name>
      <anchorfile>classspot_1_1state__product.html</anchorfile>
      <anchor>a65592b138d1d074ec2e44f1a46a76906</anchor>
      <arglist>(const state *left, const state *right, fixed_size_pool *pool)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>destroy</name>
      <anchorfile>classspot_1_1state__product.html</anchorfile>
      <anchor>a58afa65f59e60cd9ceb7999a13e48e12</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>compare</name>
      <anchorfile>classspot_1_1state__product.html</anchorfile>
      <anchor>a8aeb8af80e79dc1d663bc00815f5d52c</anchor>
      <arglist>(const state *other) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual size_t</type>
      <name>hash</name>
      <anchorfile>classspot_1_1state__product.html</anchorfile>
      <anchor>a50108b3799bfbee2b2eac6d7f41bdfde</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual state_product *</type>
      <name>clone</name>
      <anchorfile>classspot_1_1state__product.html</anchorfile>
      <anchor>ad813ee4cdc9e5b8f5e6805e835d963c1</anchor>
      <arglist>() const override</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>spot::state_ptr_equal</name>
    <filename>structspot_1_1state__ptr__equal.html</filename>
  </compound>
  <compound kind="struct">
    <name>spot::state_ptr_hash</name>
    <filename>structspot_1_1state__ptr__hash.html</filename>
  </compound>
  <compound kind="struct">
    <name>spot::state_ptr_less_than</name>
    <filename>structspot_1_1state__ptr__less__than.html</filename>
  </compound>
  <compound kind="struct">
    <name>spot::state_shared_ptr_equal</name>
    <filename>structspot_1_1state__shared__ptr__equal.html</filename>
  </compound>
  <compound kind="struct">
    <name>spot::state_shared_ptr_hash</name>
    <filename>structspot_1_1state__shared__ptr__hash.html</filename>
  </compound>
  <compound kind="struct">
    <name>spot::state_shared_ptr_less_than</name>
    <filename>structspot_1_1state__shared__ptr__less__than.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::state_ta_explicit</name>
    <filename>classspot_1_1state__ta__explicit.html</filename>
    <base>spot::state</base>
    <class kind="struct">spot::state_ta_explicit::transition</class>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>compare</name>
      <anchorfile>classspot_1_1state__ta__explicit.html</anchorfile>
      <anchor>ad818d3fa86aeb66e2f3c146a4a2ee6ef</anchor>
      <arglist>(const spot::state *other) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual size_t</type>
      <name>hash</name>
      <anchorfile>classspot_1_1state__ta__explicit.html</anchorfile>
      <anchor>ad11c50f54de46989c32bf2b4df855b18</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual state_ta_explicit *</type>
      <name>clone</name>
      <anchorfile>classspot_1_1state__ta__explicit.html</anchorfile>
      <anchor>a0318a96799c25499a39012c5f877c2ae</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>destroy</name>
      <anchorfile>classspot_1_1state__ta__explicit.html</anchorfile>
      <anchor>ac8b7431081776bc220aafd049e24ba3e</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_hole_state</name>
      <anchorfile>classspot_1_1state__ta__explicit.html</anchorfile>
      <anchor>a3437056558cd4120fe240ff794cf959c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>delete_stuttering_and_hole_successors</name>
      <anchorfile>classspot_1_1state__ta__explicit.html</anchorfile>
      <anchor>a9f61e901935f09e3c2118a0e3df7a364</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>spot::state_ta_explicit::transition</name>
    <filename>structspot_1_1state__ta__explicit_1_1transition.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::state_ta_product</name>
    <filename>classspot_1_1state__ta__product.html</filename>
    <base>spot::state</base>
    <member kind="function">
      <type></type>
      <name>state_ta_product</name>
      <anchorfile>classspot_1_1state__ta__product.html</anchorfile>
      <anchor>a444db3f7d63bfa1129fa50ae77d33eda</anchor>
      <arglist>(const state *ta_state, const state *kripke_state)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>state_ta_product</name>
      <anchorfile>classspot_1_1state__ta__product.html</anchorfile>
      <anchor>a9556804b0a24a9122fa193234aaf4909</anchor>
      <arglist>(const state_ta_product &amp;o)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>compare</name>
      <anchorfile>classspot_1_1state__ta__product.html</anchorfile>
      <anchor>a333d24652fc281bef497eb5e5aeac9c0</anchor>
      <arglist>(const state *other) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual size_t</type>
      <name>hash</name>
      <anchorfile>classspot_1_1state__ta__product.html</anchorfile>
      <anchor>a69ad362086ad27d33b08fa157d0e998d</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual state_ta_product *</type>
      <name>clone</name>
      <anchorfile>classspot_1_1state__ta__product.html</anchorfile>
      <anchor>ab8d261cdf9902367c28cd570497d8a5d</anchor>
      <arglist>() const override</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::state_unicity_table</name>
    <filename>classspot_1_1state__unicity__table.html</filename>
    <member kind="function">
      <type>const state *</type>
      <name>operator()</name>
      <anchorfile>classspot_1_1state__unicity__table.html</anchorfile>
      <anchor>ada6da8c1e4d3245b8b13e9241369dcd0</anchor>
      <arglist>(const state *s)</arglist>
    </member>
    <member kind="function">
      <type>const state *</type>
      <name>is_new</name>
      <anchorfile>classspot_1_1state__unicity__table.html</anchorfile>
      <anchor>aa9d074c927559042c46ef6e3fb2b05d4</anchor>
      <arglist>(const state *s)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>spot::stopwatch</name>
    <filename>structspot_1_1stopwatch.html</filename>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>structspot_1_1stopwatch.html</anchorfile>
      <anchor>a11d6179774829f77287f54f2464a4db7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>stop</name>
      <anchorfile>structspot_1_1stopwatch.html</anchorfile>
      <anchor>af06f1a9166ffbd9f96bbf6a7d6fbf34e</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::ta</name>
    <filename>classspot_1_1ta.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual const_states_set_t</type>
      <name>get_initial_states_set</name>
      <anchorfile>classspot_1_1ta.html</anchorfile>
      <anchor>a2bad6fdade5c5d40ebfe933140bd9a4b</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const spot::state *</type>
      <name>get_artificial_initial_state</name>
      <anchorfile>classspot_1_1ta.html</anchorfile>
      <anchor>a7ab39669a60b0796aa24837a63cb589d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual ta_succ_iterator *</type>
      <name>succ_iter</name>
      <anchorfile>classspot_1_1ta.html</anchorfile>
      <anchor>af0b2f71c85c0dd17b850197537a383bc</anchor>
      <arglist>(const spot::state *state) const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual ta_succ_iterator *</type>
      <name>succ_iter</name>
      <anchorfile>classspot_1_1ta.html</anchorfile>
      <anchor>af9ebc32d6cc33044f538c25b07eb09bd</anchor>
      <arglist>(const spot::state *state, bdd changeset) const =0</arglist>
    </member>
    <member kind="function">
      <type>bdd_dict_ptr</type>
      <name>get_dict</name>
      <anchorfile>classspot_1_1ta.html</anchorfile>
      <anchor>aa24999943bd1f2a2a7855b35e9139473</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual std::string</type>
      <name>format_state</name>
      <anchorfile>classspot_1_1ta.html</anchorfile>
      <anchor>a075f7fdb44428659a16484170477e77e</anchor>
      <arglist>(const spot::state *s) const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>is_accepting_state</name>
      <anchorfile>classspot_1_1ta.html</anchorfile>
      <anchor>a05398307c3e98a177f7f182b2becb6ee</anchor>
      <arglist>(const spot::state *s) const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>is_livelock_accepting_state</name>
      <anchorfile>classspot_1_1ta.html</anchorfile>
      <anchor>a5e2b5e5f1ad31adbc157571d88007b01</anchor>
      <arglist>(const spot::state *s) const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>is_initial_state</name>
      <anchorfile>classspot_1_1ta.html</anchorfile>
      <anchor>a9291b601b2c32aa38c04feeb5f48a703</anchor>
      <arglist>(const spot::state *s) const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bdd</type>
      <name>get_state_condition</name>
      <anchorfile>classspot_1_1ta.html</anchorfile>
      <anchor>a807b62b44071746902e7d5e76b7fefad</anchor>
      <arglist>(const spot::state *s) const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>free_state</name>
      <anchorfile>classspot_1_1ta.html</anchorfile>
      <anchor>a83fe8227b08e5d5ae575fddec620d85c</anchor>
      <arglist>(const spot::state *s) const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::ta_check</name>
    <filename>classspot_1_1ta__check.html</filename>
    <base>spot::ec_statistics</base>
    <member kind="function">
      <type>bool</type>
      <name>check</name>
      <anchorfile>classspot_1_1ta__check.html</anchorfile>
      <anchor>a8b47c3754e2cb997e1b99ba0b4e821f7</anchor>
      <arglist>(bool disable_second_pass=false, bool disable_heuristic_for_livelock_detection=false)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>livelock_detection</name>
      <anchorfile>classspot_1_1ta__check.html</anchorfile>
      <anchor>a24e626b9f67584930dbddf0bda660774</anchor>
      <arglist>(const const_ta_product_ptr &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>print_stats</name>
      <anchorfile>classspot_1_1ta__check.html</anchorfile>
      <anchor>aed52ad14ed9247f3c1033eb1ab4f46ed</anchor>
      <arglist>(std::ostream &amp;os) const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>bool</type>
      <name>heuristic_livelock_detection</name>
      <anchorfile>classspot_1_1ta__check.html</anchorfile>
      <anchor>a3edf36945b1f3334c40c77b00fd3dbd2</anchor>
      <arglist>(const state *stuttering_succ, hash_type &amp;h, int h_livelock_root, std::set&lt; const state *, state_ptr_less_than &gt; liveset_curr)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const_ta_product_ptr</type>
      <name>a_</name>
      <anchorfile>classspot_1_1ta__check.html</anchorfile>
      <anchor>a7374320d3295564a913a3d49d5d23540</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>option_map</type>
      <name>o_</name>
      <anchorfile>classspot_1_1ta__check.html</anchorfile>
      <anchor>ac07d98b416c4f77f9ef9a33688d09e9c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::ta_explicit</name>
    <filename>classspot_1_1ta__explicit.html</filename>
    <base>spot::ta</base>
    <member kind="function" virtualness="virtual">
      <type>virtual const_states_set_t</type>
      <name>get_initial_states_set</name>
      <anchorfile>classspot_1_1ta__explicit.html</anchorfile>
      <anchor>a40900cf660d13efb1ff9a1de130761f4</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ta_succ_iterator *</type>
      <name>succ_iter</name>
      <anchorfile>classspot_1_1ta__explicit.html</anchorfile>
      <anchor>a18b3e301c2283556086e8a7d4d8ae523</anchor>
      <arglist>(const spot::state *s) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ta_succ_iterator *</type>
      <name>succ_iter</name>
      <anchorfile>classspot_1_1ta__explicit.html</anchorfile>
      <anchor>a4a0fb6ebf88d53dfaba9b77375dad7a4</anchor>
      <arglist>(const spot::state *s, bdd condition) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual std::string</type>
      <name>format_state</name>
      <anchorfile>classspot_1_1ta__explicit.html</anchorfile>
      <anchor>a4246dbd19c1f40af16beaaac05092142</anchor>
      <arglist>(const spot::state *s) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>is_accepting_state</name>
      <anchorfile>classspot_1_1ta__explicit.html</anchorfile>
      <anchor>a3cbe89bdc37616235b888db762bec432</anchor>
      <arglist>(const spot::state *s) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>is_livelock_accepting_state</name>
      <anchorfile>classspot_1_1ta__explicit.html</anchorfile>
      <anchor>a820d7a2527d11d844759c0040a2c5367</anchor>
      <arglist>(const spot::state *s) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>is_initial_state</name>
      <anchorfile>classspot_1_1ta__explicit.html</anchorfile>
      <anchor>a269b59e948ba80944e3f9818ad735fbe</anchor>
      <arglist>(const spot::state *s) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bdd</type>
      <name>get_state_condition</name>
      <anchorfile>classspot_1_1ta__explicit.html</anchorfile>
      <anchor>ad1313c78374f37733d131dd79852b58c</anchor>
      <arglist>(const spot::state *s) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>free_state</name>
      <anchorfile>classspot_1_1ta__explicit.html</anchorfile>
      <anchor>acdaffe754158cbdce07ecd45a203ad83</anchor>
      <arglist>(const spot::state *s) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual spot::state *</type>
      <name>get_artificial_initial_state</name>
      <anchorfile>classspot_1_1ta__explicit.html</anchorfile>
      <anchor>a7eed3b662336a92daa5db8d41888e61a</anchor>
      <arglist>() const override</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::ta_explicit_succ_iterator</name>
    <filename>classspot_1_1ta__explicit__succ__iterator.html</filename>
    <base>spot::ta_succ_iterator</base>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>first</name>
      <anchorfile>classspot_1_1ta__explicit__succ__iterator.html</anchorfile>
      <anchor>ac2a3d26974a92555617ba65d8ddd2b57</anchor>
      <arglist>() override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>next</name>
      <anchorfile>classspot_1_1ta__explicit__succ__iterator.html</anchorfile>
      <anchor>a25e0aac064b0950eaebae99fb450e5ba</anchor>
      <arglist>() override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>done</name>
      <anchorfile>classspot_1_1ta__explicit__succ__iterator.html</anchorfile>
      <anchor>a61eb39a733d72245942fff33e9ac8d21</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const state *</type>
      <name>dst</name>
      <anchorfile>classspot_1_1ta__explicit__succ__iterator.html</anchorfile>
      <anchor>acd8e0f235e52de49f6ecce3c8c6d7d47</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bdd</type>
      <name>cond</name>
      <anchorfile>classspot_1_1ta__explicit__succ__iterator.html</anchorfile>
      <anchor>a4bd3c774b2f4421f240d430512d9cf88</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual acc_cond::mark_t</type>
      <name>acc</name>
      <anchorfile>classspot_1_1ta__explicit__succ__iterator.html</anchorfile>
      <anchor>abad53ebd624062b4736d23feec7c3ed7</anchor>
      <arglist>() const override</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::ta_product</name>
    <filename>classspot_1_1ta__product.html</filename>
    <base>spot::ta</base>
    <member kind="function">
      <type></type>
      <name>ta_product</name>
      <anchorfile>classspot_1_1ta__product.html</anchorfile>
      <anchor>a77ec3f71695534f7f437db50cc8ce53c</anchor>
      <arglist>(const const_ta_ptr &amp;testing_automaton, const const_kripke_ptr &amp;kripke_structure)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ta::const_states_set_t</type>
      <name>get_initial_states_set</name>
      <anchorfile>classspot_1_1ta__product.html</anchorfile>
      <anchor>a92f00ad47842081cd614b91792885c62</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ta_succ_iterator_product *</type>
      <name>succ_iter</name>
      <anchorfile>classspot_1_1ta__product.html</anchorfile>
      <anchor>a38f2da01556e0bac727b3bbf144d85c0</anchor>
      <arglist>(const spot::state *s) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ta_succ_iterator_product *</type>
      <name>succ_iter</name>
      <anchorfile>classspot_1_1ta__product.html</anchorfile>
      <anchor>afe341cef726baa0e5539134d90c94f0e</anchor>
      <arglist>(const spot::state *s, bdd changeset) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual std::string</type>
      <name>format_state</name>
      <anchorfile>classspot_1_1ta__product.html</anchorfile>
      <anchor>a8c37c7e597b5d493d6df66bdd168cb30</anchor>
      <arglist>(const spot::state *s) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>is_accepting_state</name>
      <anchorfile>classspot_1_1ta__product.html</anchorfile>
      <anchor>a9d4d39d7c5bedd705656abcfa1ac4b2c</anchor>
      <arglist>(const spot::state *s) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>is_livelock_accepting_state</name>
      <anchorfile>classspot_1_1ta__product.html</anchorfile>
      <anchor>a03309e9a570b23695d5a34e575e52673</anchor>
      <arglist>(const spot::state *s) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>is_initial_state</name>
      <anchorfile>classspot_1_1ta__product.html</anchorfile>
      <anchor>a757cca88be04fcf8176971cf7b69cad0</anchor>
      <arglist>(const spot::state *s) const override</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_hole_state_in_ta_component</name>
      <anchorfile>classspot_1_1ta__product.html</anchorfile>
      <anchor>aa96a939ff8b51b1f4b1655f59a77466d</anchor>
      <arglist>(const spot::state *s) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bdd</type>
      <name>get_state_condition</name>
      <anchorfile>classspot_1_1ta__product.html</anchorfile>
      <anchor>a5c521565dcf05666a6c4657b3a1ca5a0</anchor>
      <arglist>(const spot::state *s) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>free_state</name>
      <anchorfile>classspot_1_1ta__product.html</anchorfile>
      <anchor>ae96c3d616452566825d23f6bc452af2a</anchor>
      <arglist>(const spot::state *s) const override</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::ta_reachable_iterator</name>
    <filename>classspot_1_1ta__reachable__iterator.html</filename>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>classspot_1_1ta__reachable__iterator.html</anchorfile>
      <anchor>a454e2ac517cf0d7e95512e227672b2a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>want_state</name>
      <anchorfile>classspot_1_1ta__reachable__iterator.html</anchorfile>
      <anchor>aa680ef6988f48589b2e702895698a144</anchor>
      <arglist>(const state *s) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>start</name>
      <anchorfile>classspot_1_1ta__reachable__iterator.html</anchorfile>
      <anchor>af891fcf3bba10f78aecf301ad2235cb5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>end</name>
      <anchorfile>classspot_1_1ta__reachable__iterator.html</anchorfile>
      <anchor>afd74b5f21e08ed690fc4a765494652c9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>process_state</name>
      <anchorfile>classspot_1_1ta__reachable__iterator.html</anchorfile>
      <anchor>ab9c235e497cef942c159a98ebb0da95b</anchor>
      <arglist>(const state *s, int n)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>process_link</name>
      <anchorfile>classspot_1_1ta__reachable__iterator.html</anchorfile>
      <anchor>af7cad569c3866860816852f186959c0f</anchor>
      <arglist>(int in, int out, const ta_succ_iterator *si)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>add_state</name>
      <anchorfile>classspot_1_1ta__reachable__iterator.html</anchorfile>
      <anchor>a5aaf7153ecc48357214f22977e4e0e1a</anchor>
      <arglist>(const state *s)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual const state *</type>
      <name>next_state</name>
      <anchorfile>classspot_1_1ta__reachable__iterator.html</anchorfile>
      <anchor>aeb2902e9e8c6e5770de07543fbeb4a19</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const_ta_ptr</type>
      <name>t_automata_</name>
      <anchorfile>classspot_1_1ta__reachable__iterator.html</anchorfile>
      <anchor>a663d91a4d62226abdf16fa38298a7a14</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>state_map&lt; int &gt;</type>
      <name>seen</name>
      <anchorfile>classspot_1_1ta__reachable__iterator.html</anchorfile>
      <anchor>a9e2a1a5181f0e15cb3e2c0e19abd1975</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::ta_reachable_iterator_breadth_first</name>
    <filename>classspot_1_1ta__reachable__iterator__breadth__first.html</filename>
    <base>spot::ta_reachable_iterator</base>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>add_state</name>
      <anchorfile>classspot_1_1ta__reachable__iterator__breadth__first.html</anchorfile>
      <anchor>a49db63ccdb82b2875571c0ceaa329ffc</anchor>
      <arglist>(const state *s) override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const state *</type>
      <name>next_state</name>
      <anchorfile>classspot_1_1ta__reachable__iterator__breadth__first.html</anchorfile>
      <anchor>a3b6351d7ff2a5eb73156f8bd097a3f8b</anchor>
      <arglist>() override</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::deque&lt; const state * &gt;</type>
      <name>todo</name>
      <anchorfile>classspot_1_1ta__reachable__iterator__breadth__first.html</anchorfile>
      <anchor>ad5d8d1df09d1b416f000d7501db45621</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::ta_reachable_iterator_depth_first</name>
    <filename>classspot_1_1ta__reachable__iterator__depth__first.html</filename>
    <base>spot::ta_reachable_iterator</base>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>add_state</name>
      <anchorfile>classspot_1_1ta__reachable__iterator__depth__first.html</anchorfile>
      <anchor>a0eacf1f539d888dcfb47be0f609932e5</anchor>
      <arglist>(const state *s) override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const state *</type>
      <name>next_state</name>
      <anchorfile>classspot_1_1ta__reachable__iterator__depth__first.html</anchorfile>
      <anchor>ad6629635185dce71dea9e25b094ab179</anchor>
      <arglist>() override</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::stack&lt; const state * &gt;</type>
      <name>todo</name>
      <anchorfile>classspot_1_1ta__reachable__iterator__depth__first.html</anchorfile>
      <anchor>a5cdfa0bc2aafdc0a09dd9098df181581</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>spot::ta_statistics</name>
    <filename>structspot_1_1ta__statistics.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::ta_succ_iterator</name>
    <filename>classspot_1_1ta__succ__iterator.html</filename>
    <base>spot::twa_succ_iterator</base>
    <member kind="function" virtualness="pure">
      <type>virtual bdd</type>
      <name>cond</name>
      <anchorfile>classspot_1_1twa__succ__iterator.html</anchorfile>
      <anchor>af2a0d7e1e05a2e7f3438b04d4170d34f</anchor>
      <arglist>() const =0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual acc_cond::mark_t</type>
      <name>acc</name>
      <anchorfile>classspot_1_1twa__succ__iterator.html</anchorfile>
      <anchor>a0971f76215dbd04b96840a7bea81d386</anchor>
      <arglist>() const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::ta_succ_iterator_product</name>
    <filename>classspot_1_1ta__succ__iterator__product.html</filename>
    <base>spot::ta_succ_iterator</base>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>first</name>
      <anchorfile>classspot_1_1ta__succ__iterator__product.html</anchorfile>
      <anchor>a2e1ffbe5e836ffcd8fc0b9378a578709</anchor>
      <arglist>() override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>next</name>
      <anchorfile>classspot_1_1ta__succ__iterator__product.html</anchorfile>
      <anchor>a559e6cfbe3c1fa842855af0e581242b3</anchor>
      <arglist>() override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>done</name>
      <anchorfile>classspot_1_1ta__succ__iterator__product.html</anchorfile>
      <anchor>a35e59e351933ba15a817d7d7292a363d</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual state_ta_product *</type>
      <name>dst</name>
      <anchorfile>classspot_1_1ta__succ__iterator__product.html</anchorfile>
      <anchor>a2f9bc4a87504b50bf61aab6d09600bdf</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bdd</type>
      <name>cond</name>
      <anchorfile>classspot_1_1ta__succ__iterator__product.html</anchorfile>
      <anchor>aa2ecc9b66a61728de7506017f22a69ab</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual acc_cond::mark_t</type>
      <name>acc</name>
      <anchorfile>classspot_1_1ta__succ__iterator__product.html</anchorfile>
      <anchor>ab3c0ecc35c1b6ff2bb2bfc5e9cf57385</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_stuttering_transition</name>
      <anchorfile>classspot_1_1ta__succ__iterator__product.html</anchorfile>
      <anchor>a64ce6c7b3838bca19775335083ed224b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>step_</name>
      <anchorfile>classspot_1_1ta__succ__iterator__product.html</anchorfile>
      <anchor>ab6ab78f0e28cd4ed299b823e87b894ed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>bool</type>
      <name>next_non_stuttering_</name>
      <anchorfile>classspot_1_1ta__succ__iterator__product.html</anchorfile>
      <anchor>aac888408715c51588f013ea8b7c42264</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>next_kripke_dest</name>
      <anchorfile>classspot_1_1ta__succ__iterator__product.html</anchorfile>
      <anchor>aa9a5b882202a3dbc21fafe551d4d5b21</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::ta_succ_iterator_product_by_changeset</name>
    <filename>classspot_1_1ta__succ__iterator__product__by__changeset.html</filename>
    <base>spot::ta_succ_iterator_product</base>
    <member kind="function">
      <type>void</type>
      <name>next_kripke_dest</name>
      <anchorfile>classspot_1_1ta__succ__iterator__product__by__changeset.html</anchorfile>
      <anchor>a449b12f79b48528fc82f29d390daac32</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::taa_succ_iterator</name>
    <filename>classspot_1_1taa__succ__iterator.html</filename>
    <base>spot::twa_succ_iterator</base>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>first</name>
      <anchorfile>classspot_1_1taa__succ__iterator.html</anchorfile>
      <anchor>af21be319800f73df4ba26cee55f4a387</anchor>
      <arglist>() override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>next</name>
      <anchorfile>classspot_1_1taa__succ__iterator.html</anchorfile>
      <anchor>a38733e79636efc0c526acc53f9bf9138</anchor>
      <arglist>() override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>done</name>
      <anchorfile>classspot_1_1taa__succ__iterator.html</anchorfile>
      <anchor>af0db6cfd6878e347431ab18c9e5d09aa</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual set_state *</type>
      <name>dst</name>
      <anchorfile>classspot_1_1taa__succ__iterator.html</anchorfile>
      <anchor>aea25c6ed0f7d47d9eb369fe606ad35b1</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bdd</type>
      <name>cond</name>
      <anchorfile>classspot_1_1taa__succ__iterator.html</anchorfile>
      <anchor>ab069dfbd2ad26c9d10effa8c2b347841</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual acc_cond::mark_t</type>
      <name>acc</name>
      <anchorfile>classspot_1_1taa__succ__iterator.html</anchorfile>
      <anchor>abfd726166ec5046ab39b303554839715</anchor>
      <arglist>() const override</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::taa_tgba</name>
    <filename>classspot_1_1taa__tgba.html</filename>
    <base>spot::twa</base>
    <class kind="struct">spot::taa_tgba::transition</class>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~taa_tgba</name>
      <anchorfile>classspot_1_1taa__tgba.html</anchorfile>
      <anchor>ab6956a578c9071cc0bd0b052529b800a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual spot::state *</type>
      <name>get_init_state</name>
      <anchorfile>classspot_1_1taa__tgba.html</anchorfile>
      <anchor>ab9376fad3b35149998a29c5b300b16bc</anchor>
      <arglist>() const overridefinal</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual twa_succ_iterator *</type>
      <name>succ_iter</name>
      <anchorfile>classspot_1_1taa__tgba.html</anchorfile>
      <anchor>a43b58be4172efc1e88e0645adab581a7</anchor>
      <arglist>(const spot::state *state) const overridefinal</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>spot::taa_tgba::transition</name>
    <filename>structspot_1_1taa__tgba_1_1transition.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::taa_tgba_formula</name>
    <filename>classspot_1_1taa__tgba__formula.html</filename>
    <base>taa_tgba_labelled&lt; formula &gt;</base>
    <member kind="function" virtualness="virtual">
      <type>virtual std::string</type>
      <name>format_state</name>
      <anchorfile>classspot_1_1taa__tgba__labelled.html</anchorfile>
      <anchor>a0e1b836223ff95c99d90235925175f3f</anchor>
      <arglist>(const spot::state *s) const override</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>output</name>
      <anchorfile>classspot_1_1taa__tgba__labelled.html</anchorfile>
      <anchor>aa212700e63fa71487610d6ba9ea7bbae</anchor>
      <arglist>(std::ostream &amp;os) const</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual std::string</type>
      <name>label_to_string</name>
      <anchorfile>classspot_1_1taa__tgba__formula.html</anchorfile>
      <anchor>a98052d3d83ad12f08475733043ae83ee</anchor>
      <arglist>(const label_t &amp;label) const override</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::taa_tgba_labelled</name>
    <filename>classspot_1_1taa__tgba__labelled.html</filename>
    <templarg>label</templarg>
    <base>spot::taa_tgba</base>
    <member kind="function" virtualness="virtual">
      <type>virtual std::string</type>
      <name>format_state</name>
      <anchorfile>classspot_1_1taa__tgba__labelled.html</anchorfile>
      <anchor>a0e1b836223ff95c99d90235925175f3f</anchor>
      <arglist>(const spot::state *s) const override</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>output</name>
      <anchorfile>classspot_1_1taa__tgba__labelled.html</anchorfile>
      <anchor>aa212700e63fa71487610d6ba9ea7bbae</anchor>
      <arglist>(std::ostream &amp;os) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="pure">
      <type>virtual std::string</type>
      <name>label_to_string</name>
      <anchorfile>classspot_1_1taa__tgba__labelled.html</anchorfile>
      <anchor>aee7a2391cb0fffbaf0461ed9dcc1b28e</anchor>
      <arglist>(const label_t &amp;lbl) const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::taa_tgba_string</name>
    <filename>classspot_1_1taa__tgba__string.html</filename>
    <base>taa_tgba_labelled&lt; std::string &gt;</base>
    <member kind="function" virtualness="virtual">
      <type>virtual std::string</type>
      <name>format_state</name>
      <anchorfile>classspot_1_1taa__tgba__labelled.html</anchorfile>
      <anchor>a0e1b836223ff95c99d90235925175f3f</anchor>
      <arglist>(const spot::state *s) const override</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>output</name>
      <anchorfile>classspot_1_1taa__tgba__labelled.html</anchorfile>
      <anchor>aa212700e63fa71487610d6ba9ea7bbae</anchor>
      <arglist>(std::ostream &amp;os) const</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual std::string</type>
      <name>label_to_string</name>
      <anchorfile>classspot_1_1taa__tgba__string.html</anchorfile>
      <anchor>ad00414eb636a9749c2d4b9562de8840b</anchor>
      <arglist>(const std::string &amp;label) const override</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::temporary_file</name>
    <filename>classspot_1_1temporary__file.html</filename>
    <base>spot::printable</base>
  </compound>
  <compound kind="class">
    <name>spot::tgta</name>
    <filename>classspot_1_1tgta.html</filename>
    <base>spot::twa</base>
    <member kind="function" virtualness="pure">
      <type>virtual twa_succ_iterator *</type>
      <name>succ_iter_by_changeset</name>
      <anchorfile>classspot_1_1tgta.html</anchorfile>
      <anchor>a4a1fb4042c7b97f1b7cd9f8da696025d</anchor>
      <arglist>(const spot::state *s, bdd change_set) const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::tgta_explicit</name>
    <filename>classspot_1_1tgta__explicit.html</filename>
    <base>spot::tgta</base>
    <member kind="function" virtualness="virtual">
      <type>virtual spot::state *</type>
      <name>get_init_state</name>
      <anchorfile>classspot_1_1tgta__explicit.html</anchorfile>
      <anchor>a99281fb6bd205c8030487915f5215a8f</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual twa_succ_iterator *</type>
      <name>succ_iter</name>
      <anchorfile>classspot_1_1tgta__explicit.html</anchorfile>
      <anchor>a1cc4b54ccd98b3f825f8dd8fb88b92df</anchor>
      <arglist>(const spot::state *local_state) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual std::string</type>
      <name>format_state</name>
      <anchorfile>classspot_1_1tgta__explicit.html</anchorfile>
      <anchor>ad63a8aec0b6c5fd163189b3d498c244c</anchor>
      <arglist>(const spot::state *s) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual twa_succ_iterator *</type>
      <name>succ_iter_by_changeset</name>
      <anchorfile>classspot_1_1tgta__explicit.html</anchorfile>
      <anchor>a64ff7c1638f76b8c2ae27296c8e50362</anchor>
      <arglist>(const spot::state *s, bdd change_set) const override</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::tgta_product</name>
    <filename>classspot_1_1tgta__product.html</filename>
    <base>spot::twa_product</base>
    <member kind="function" virtualness="virtual">
      <type>virtual const state *</type>
      <name>get_init_state</name>
      <anchorfile>classspot_1_1tgta__product.html</anchorfile>
      <anchor>aacc9d9deece18717bc663af70e97f898</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual twa_succ_iterator *</type>
      <name>succ_iter</name>
      <anchorfile>classspot_1_1tgta__product.html</anchorfile>
      <anchor>a46a476754355d7bc4004c27f4e1f051c</anchor>
      <arglist>(const state *local_state) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual std::string</type>
      <name>format_state</name>
      <anchorfile>classspot_1_1twa__product.html</anchorfile>
      <anchor>a21164a4a9c2aa6ba13dcc9470d5ec641</anchor>
      <arglist>(const state *state) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual state *</type>
      <name>project_state</name>
      <anchorfile>classspot_1_1twa__product.html</anchorfile>
      <anchor>af4da102503e91884b59b898d1843f938</anchor>
      <arglist>(const state *s, const const_twa_ptr &amp;t) const override</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::tgta_succ_iterator_product</name>
    <filename>classspot_1_1tgta__succ__iterator__product.html</filename>
    <base>spot::twa_succ_iterator</base>
    <member kind="function">
      <type>bool</type>
      <name>first</name>
      <anchorfile>classspot_1_1tgta__succ__iterator__product.html</anchorfile>
      <anchor>aa3edbd56d21d4d0a725d2e51730f66ff</anchor>
      <arglist>() override</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>next</name>
      <anchorfile>classspot_1_1tgta__succ__iterator__product.html</anchorfile>
      <anchor>a7fe80b9b1629e91461bc9f3d11e06585</anchor>
      <arglist>() override</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>done</name>
      <anchorfile>classspot_1_1tgta__succ__iterator__product.html</anchorfile>
      <anchor>a06a019d7278a40be802c09732e2871ea</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function">
      <type>state_product *</type>
      <name>dst</name>
      <anchorfile>classspot_1_1tgta__succ__iterator__product.html</anchorfile>
      <anchor>a8c41129c569980c7711b199cfc2c0b77</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function">
      <type>bdd</type>
      <name>cond</name>
      <anchorfile>classspot_1_1tgta__succ__iterator__product.html</anchorfile>
      <anchor>a12b8868552bc9c810a9ca0ff9bd0f925</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function">
      <type>acc_cond::mark_t</type>
      <name>acc</name>
      <anchorfile>classspot_1_1tgta__succ__iterator__product.html</anchorfile>
      <anchor>a680bf2d5fde7edf98c0da31ebe4795e9</anchor>
      <arglist>() const override</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>spot::time_info</name>
    <filename>structspot_1_1time__info.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::timer</name>
    <filename>classspot_1_1timer.html</filename>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>classspot_1_1timer.html</anchorfile>
      <anchor>a55c6674711dab0e67008dc378011e46d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop</name>
      <anchorfile>classspot_1_1timer.html</anchorfile>
      <anchor>a34330e7a7a879a13b2dfb60df84867cd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>clock_t</type>
      <name>utime</name>
      <anchorfile>classspot_1_1timer.html</anchorfile>
      <anchor>aaab40549d862ebfbb7d07ccf0ba4a129</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>clock_t</type>
      <name>stime</name>
      <anchorfile>classspot_1_1timer.html</anchorfile>
      <anchor>a87c8d0c9bed27d39846f0ec421daffbb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_running</name>
      <anchorfile>classspot_1_1timer.html</anchorfile>
      <anchor>a868bfb05189f521d08dfb274b93b459a</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::timer_map</name>
    <filename>classspot_1_1timer__map.html</filename>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>classspot_1_1timer__map.html</anchorfile>
      <anchor>a85d4bf24749d93be6dcbb5e66aacd249</anchor>
      <arglist>(const std::string &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop</name>
      <anchorfile>classspot_1_1timer__map.html</anchorfile>
      <anchor>a709679565ddbc19293c6f63138367911</anchor>
      <arglist>(const std::string &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cancel</name>
      <anchorfile>classspot_1_1timer__map.html</anchorfile>
      <anchor>ab35d7a8e21cc87716039cecd5040856e</anchor>
      <arglist>(const std::string &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>const spot::timer &amp;</type>
      <name>timer</name>
      <anchorfile>classspot_1_1timer__map.html</anchorfile>
      <anchor>a0b2786417c063a93c851174df0ef2071</anchor>
      <arglist>(const std::string &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>spot::timer &amp;</type>
      <name>timer</name>
      <anchorfile>classspot_1_1timer__map.html</anchorfile>
      <anchor>a02d67150c7c115d2f06ae49ef1dadc19</anchor>
      <arglist>(const std::string &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>empty</name>
      <anchorfile>classspot_1_1timer__map.html</anchorfile>
      <anchor>a60fd945cfdc64df8e7ca1bc3a975c346</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>print</name>
      <anchorfile>classspot_1_1timer__map.html</anchorfile>
      <anchor>afafd3d361715574ade84ffd0fc74c15e</anchor>
      <arglist>(std::ostream &amp;os) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset_all</name>
      <anchorfile>classspot_1_1timer__map.html</anchorfile>
      <anchor>af2293403679d234d686f650ba564cf35</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::tl_simplifier</name>
    <filename>classspot_1_1tl__simplifier.html</filename>
    <member kind="function">
      <type>formula</type>
      <name>simplify</name>
      <anchorfile>classspot_1_1tl__simplifier.html</anchorfile>
      <anchor>a31a9439603b494c7471b1ad096179886</anchor>
      <arglist>(formula f)</arglist>
    </member>
    <member kind="function">
      <type>formula</type>
      <name>negative_normal_form</name>
      <anchorfile>classspot_1_1tl__simplifier.html</anchorfile>
      <anchor>af54641348858cba748eff71a883c0891</anchor>
      <arglist>(formula f, bool negated=false)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>syntactic_implication</name>
      <anchorfile>classspot_1_1tl__simplifier.html</anchorfile>
      <anchor>a4b18eec50d0ec475e32f332988a2bf57</anchor>
      <arglist>(formula f, formula g)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>syntactic_implication_neg</name>
      <anchorfile>classspot_1_1tl__simplifier.html</anchorfile>
      <anchor>af14e8f46b2ca0ff0960fbcb7ebd3beec</anchor>
      <arglist>(formula f, formula g, bool right)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>are_equivalent</name>
      <anchorfile>classspot_1_1tl__simplifier.html</anchorfile>
      <anchor>aac64a911b153ff5bfa7a6ec180bdc1c1</anchor>
      <arglist>(formula f, formula g)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>implication</name>
      <anchorfile>classspot_1_1tl__simplifier.html</anchorfile>
      <anchor>a1fbead526cd20c73943d9087103c68f3</anchor>
      <arglist>(formula f, formula g)</arglist>
    </member>
    <member kind="function">
      <type>bdd</type>
      <name>as_bdd</name>
      <anchorfile>classspot_1_1tl__simplifier.html</anchorfile>
      <anchor>ae622c701bcb741505e3d67118c61226c</anchor>
      <arglist>(formula f)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear_as_bdd_cache</name>
      <anchorfile>classspot_1_1tl__simplifier.html</anchorfile>
      <anchor>af958933b935de67f110248ee8cf03230</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bdd_dict_ptr</type>
      <name>get_dict</name>
      <anchorfile>classspot_1_1tl__simplifier.html</anchorfile>
      <anchor>a7b8d80e50c40cf1998564f4013ac13ef</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>formula</type>
      <name>star_normal_form</name>
      <anchorfile>classspot_1_1tl__simplifier.html</anchorfile>
      <anchor>ae14c6fbd84c0a5c11e16f5675050c590</anchor>
      <arglist>(formula f)</arglist>
    </member>
    <member kind="function">
      <type>formula</type>
      <name>boolean_to_isop</name>
      <anchorfile>classspot_1_1tl__simplifier.html</anchorfile>
      <anchor>a35693db9bb5da20a0f6aec3f6c33dd82</anchor>
      <arglist>(formula f)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print_stats</name>
      <anchorfile>classspot_1_1tl__simplifier.html</anchorfile>
      <anchor>a1fa5c7a8ef4e6a72b553b4fbc674e6b7</anchor>
      <arglist>(std::ostream &amp;os) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::tl_simplifier_options</name>
    <filename>classspot_1_1tl__simplifier__options.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::translator</name>
    <filename>classspot_1_1translator.html</filename>
    <base protection="protected">spot::postprocessor</base>
    <member kind="function">
      <type>twa_graph_ptr</type>
      <name>run</name>
      <anchorfile>classspot_1_1translator.html</anchorfile>
      <anchor>a36cdf71031732eddd084eb3abbbb5738</anchor>
      <arglist>(formula f)</arglist>
    </member>
    <member kind="function">
      <type>twa_graph_ptr</type>
      <name>run</name>
      <anchorfile>classspot_1_1translator.html</anchorfile>
      <anchor>af9776dbeeba8298615e912633e9e4c47</anchor>
      <arglist>(formula *f)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::trival</name>
    <filename>classspot_1_1trival.html</filename>
    <member kind="function">
      <type>constexpr bool</type>
      <name>is_known</name>
      <anchorfile>classspot_1_1trival.html</anchorfile>
      <anchor>acf97d72ee84a8f3e683499092190c3c7</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::twa</name>
    <filename>classspot_1_1twa.html</filename>
    <class kind="struct">spot::twa::prop_set</class>
  </compound>
  <compound kind="struct">
    <name>spot::twa::prop_set</name>
    <filename>structspot_1_1twa_1_1prop__set.html</filename>
    <member kind="function" static="yes">
      <type>static prop_set</type>
      <name>all</name>
      <anchorfile>structspot_1_1twa_1_1prop__set.html</anchorfile>
      <anchor>a3ce0e16114416fc77107dd64f9b17513</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>state_based</name>
      <anchorfile>structspot_1_1twa_1_1prop__set.html</anchorfile>
      <anchor>ad44a0435a381b3d76fbf0978c9a2fd51</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>inherently_weak</name>
      <anchorfile>structspot_1_1twa_1_1prop__set.html</anchorfile>
      <anchor>a54d24d215020e87c2b487b5457f274ff</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>deterministic</name>
      <anchorfile>structspot_1_1twa_1_1prop__set.html</anchorfile>
      <anchor>a1c2e6cb5a11f3adcd93bc59d2a3bfad3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>stutter_inv</name>
      <anchorfile>structspot_1_1twa_1_1prop__set.html</anchorfile>
      <anchor>a3b3bdcb3ed2d6bc440177b7932df0b0c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::twa_graph</name>
    <filename>classspot_1_1twa__graph.html</filename>
    <base>spot::twa</base>
  </compound>
  <compound kind="struct">
    <name>spot::twa_graph_edge_data</name>
    <filename>structspot_1_1twa__graph__edge__data.html</filename>
  </compound>
  <compound kind="struct">
    <name>spot::twa_graph_state</name>
    <filename>structspot_1_1twa__graph__state.html</filename>
    <base>spot::state</base>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>compare</name>
      <anchorfile>structspot_1_1twa__graph__state.html</anchorfile>
      <anchor>a63b6d885e865618b4d5d838f453fe9d3</anchor>
      <arglist>(const spot::state *other) const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual size_t</type>
      <name>hash</name>
      <anchorfile>structspot_1_1twa__graph__state.html</anchorfile>
      <anchor>a8ab419fc23e3cd68f32c39cc9564ebba</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual twa_graph_state *</type>
      <name>clone</name>
      <anchorfile>structspot_1_1twa__graph__state.html</anchorfile>
      <anchor>aff4c16cd6c8c3c1c02c7a8224c554f93</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>destroy</name>
      <anchorfile>structspot_1_1twa__graph__state.html</anchorfile>
      <anchor>a02596c86fa52c4321bff99ba9834f296</anchor>
      <arglist>() const override</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::twa_graph_succ_iterator</name>
    <filename>classspot_1_1twa__graph__succ__iterator.html</filename>
    <templarg>Graph</templarg>
    <base>spot::twa_succ_iterator</base>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>first</name>
      <anchorfile>classspot_1_1twa__graph__succ__iterator.html</anchorfile>
      <anchor>a4d6a357594bf678eb28620b916f8b14f</anchor>
      <arglist>() override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>next</name>
      <anchorfile>classspot_1_1twa__graph__succ__iterator.html</anchorfile>
      <anchor>a0f9abb4ae3dce020cdd24798218b1339</anchor>
      <arglist>() override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>done</name>
      <anchorfile>classspot_1_1twa__graph__succ__iterator.html</anchorfile>
      <anchor>aff5668e1bfcec55120ab995b239ece41</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const twa_graph_state *</type>
      <name>dst</name>
      <anchorfile>classspot_1_1twa__graph__succ__iterator.html</anchorfile>
      <anchor>af054df07c54407a21e1d41f72fea6d9b</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bdd</type>
      <name>cond</name>
      <anchorfile>classspot_1_1twa__graph__succ__iterator.html</anchorfile>
      <anchor>a18353cedebb3011e8ef17fc0865daeb6</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual acc_cond::mark_t</type>
      <name>acc</name>
      <anchorfile>classspot_1_1twa__graph__succ__iterator.html</anchorfile>
      <anchor>a4bded820c89b3fa392e26d6c8d552b1a</anchor>
      <arglist>() const override</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::twa_product</name>
    <filename>classspot_1_1twa__product.html</filename>
    <base>spot::twa</base>
    <member kind="function">
      <type></type>
      <name>twa_product</name>
      <anchorfile>classspot_1_1twa__product.html</anchorfile>
      <anchor>a4ff48bb71ea35d909cc68344074e6d53</anchor>
      <arglist>(const const_twa_ptr &amp;left, const const_twa_ptr &amp;right)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const state *</type>
      <name>get_init_state</name>
      <anchorfile>classspot_1_1twa__product.html</anchorfile>
      <anchor>a65a1a8a63a90b14a1b375d1ec828d77e</anchor>
      <arglist>() const override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual twa_succ_iterator *</type>
      <name>succ_iter</name>
      <anchorfile>classspot_1_1twa__product.html</anchorfile>
      <anchor>ac8c0c2e5660407e359a3f32ffd38cc42</anchor>
      <arglist>(const state *state) const override</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::twa_product_init</name>
    <filename>classspot_1_1twa__product__init.html</filename>
    <base>spot::twa_product</base>
    <member kind="function" virtualness="virtual">
      <type>virtual const state *</type>
      <name>get_init_state</name>
      <anchorfile>classspot_1_1twa__product__init.html</anchorfile>
      <anchor>a3c5d03014a9c6b5580b7f6277f2f37d2</anchor>
      <arglist>() const override</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::twa_reachable_iterator</name>
    <filename>classspot_1_1twa__reachable__iterator.html</filename>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>run</name>
      <anchorfile>classspot_1_1twa__reachable__iterator.html</anchorfile>
      <anchor>a75e77d55cc2523e8be1dbf2b3e4c9def</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>want_state</name>
      <anchorfile>classspot_1_1twa__reachable__iterator.html</anchorfile>
      <anchor>a01b46befb57b668024316d3725ae8434</anchor>
      <arglist>(const state *s) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>start</name>
      <anchorfile>classspot_1_1twa__reachable__iterator.html</anchorfile>
      <anchor>a793fb62286bb5014b4e60319dd7485b8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>end</name>
      <anchorfile>classspot_1_1twa__reachable__iterator.html</anchorfile>
      <anchor>a7178a6b38b0ad2509a9bb656ce2a41e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>process_state</name>
      <anchorfile>classspot_1_1twa__reachable__iterator.html</anchorfile>
      <anchor>a2c0a626666402b9219b16d93dfad3b5e</anchor>
      <arglist>(const state *s, int n, twa_succ_iterator *si)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>process_link</name>
      <anchorfile>classspot_1_1twa__reachable__iterator.html</anchorfile>
      <anchor>a5c6462a1e2f76efc40eda33fc1bdb9bd</anchor>
      <arglist>(const state *in_s, int in, const state *out_s, int out, const twa_succ_iterator *si)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>add_state</name>
      <anchorfile>classspot_1_1twa__reachable__iterator.html</anchorfile>
      <anchor>a6edeab3311fbe25029982e10ed8ea614</anchor>
      <arglist>(const state *s)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual const state *</type>
      <name>next_state</name>
      <anchorfile>classspot_1_1twa__reachable__iterator.html</anchorfile>
      <anchor>ac583782082990b0cc0bb530284bc96cc</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const_twa_ptr</type>
      <name>aut_</name>
      <anchorfile>classspot_1_1twa__reachable__iterator.html</anchorfile>
      <anchor>af53f89d407fc398dbd4cc3f3ed627117</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>state_map&lt; int &gt;</type>
      <name>seen</name>
      <anchorfile>classspot_1_1twa__reachable__iterator.html</anchorfile>
      <anchor>a099217c22aba4b4453d9d46b2f3acc92</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::twa_reachable_iterator_breadth_first</name>
    <filename>classspot_1_1twa__reachable__iterator__breadth__first.html</filename>
    <base>spot::twa_reachable_iterator</base>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>add_state</name>
      <anchorfile>classspot_1_1twa__reachable__iterator__breadth__first.html</anchorfile>
      <anchor>a0dae17176fd9e6f277fd43a2b2689ad8</anchor>
      <arglist>(const state *s) override</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const state *</type>
      <name>next_state</name>
      <anchorfile>classspot_1_1twa__reachable__iterator__breadth__first.html</anchorfile>
      <anchor>aa93760bf2dbcb1ae0e901b6496aebd91</anchor>
      <arglist>() override</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::deque&lt; const state * &gt;</type>
      <name>todo</name>
      <anchorfile>classspot_1_1twa__reachable__iterator__breadth__first.html</anchorfile>
      <anchor>ab6ebf0b28669e1436c738fbfc8cbd6e4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::twa_reachable_iterator_depth_first</name>
    <filename>classspot_1_1twa__reachable__iterator__depth__first.html</filename>
    <class kind="struct">spot::twa_reachable_iterator_depth_first::stack_item</class>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>run</name>
      <anchorfile>classspot_1_1twa__reachable__iterator__depth__first.html</anchorfile>
      <anchor>a4e2fec29e60a22a1e3de42cdad537973</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>want_state</name>
      <anchorfile>classspot_1_1twa__reachable__iterator__depth__first.html</anchorfile>
      <anchor>a173db4178ef57ca2010143b98e4e2938</anchor>
      <arglist>(const state *s) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>start</name>
      <anchorfile>classspot_1_1twa__reachable__iterator__depth__first.html</anchorfile>
      <anchor>af3a3ee8c5e64cd137a7bc9e6c6ea9e2b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>end</name>
      <anchorfile>classspot_1_1twa__reachable__iterator__depth__first.html</anchorfile>
      <anchor>ab4329147bf9780d95cc875fc5e150c61</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>process_state</name>
      <anchorfile>classspot_1_1twa__reachable__iterator__depth__first.html</anchorfile>
      <anchor>a5175b7764296a8b608286c6e3517798a</anchor>
      <arglist>(const state *s, int n, twa_succ_iterator *si)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>process_link</name>
      <anchorfile>classspot_1_1twa__reachable__iterator__depth__first.html</anchorfile>
      <anchor>aabdb15cefe355463a217608b5bb9078a</anchor>
      <arglist>(const state *in_s, int in, const state *out_s, int out, const twa_succ_iterator *si)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>push</name>
      <anchorfile>classspot_1_1twa__reachable__iterator__depth__first.html</anchorfile>
      <anchor>a09c669bff9c52a1d6b08a2ed05c61609</anchor>
      <arglist>(const state *s, int sn)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>pop</name>
      <anchorfile>classspot_1_1twa__reachable__iterator__depth__first.html</anchorfile>
      <anchor>a482b31a07fd481e71b91ce119188e4b8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const_twa_ptr</type>
      <name>aut_</name>
      <anchorfile>classspot_1_1twa__reachable__iterator__depth__first.html</anchorfile>
      <anchor>ac34661b92d3fbc1c76180c88ffb86f00</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>state_map&lt; int &gt;</type>
      <name>seen</name>
      <anchorfile>classspot_1_1twa__reachable__iterator__depth__first.html</anchorfile>
      <anchor>ace05793d528361ace8492ec1c699ceb6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::deque&lt; stack_item &gt;</type>
      <name>todo</name>
      <anchorfile>classspot_1_1twa__reachable__iterator__depth__first.html</anchorfile>
      <anchor>ad9fc34acd352024f3c4e79e6d3475fab</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>spot::twa_reachable_iterator_depth_first::stack_item</name>
    <filename>structspot_1_1twa__reachable__iterator__depth__first_1_1stack__item.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::twa_reachable_iterator_depth_first_stack</name>
    <filename>classspot_1_1twa__reachable__iterator__depth__first__stack.html</filename>
    <base>spot::twa_reachable_iterator_depth_first</base>
    <member kind="function">
      <type>bool</type>
      <name>on_stack</name>
      <anchorfile>classspot_1_1twa__reachable__iterator__depth__first__stack.html</anchorfile>
      <anchor>ae7f2120f2c7eb4c9e6256825e112f936</anchor>
      <arglist>(int sn) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>push</name>
      <anchorfile>classspot_1_1twa__reachable__iterator__depth__first__stack.html</anchorfile>
      <anchor>ab28ad833749e485aaf8f3c51854ca9f1</anchor>
      <arglist>(const state *s, int sn) override</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>pop</name>
      <anchorfile>classspot_1_1twa__reachable__iterator__depth__first__stack.html</anchorfile>
      <anchor>a211c9d25d3e359a300c6beedac993f38</anchor>
      <arglist>() override</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>spot::twa_run</name>
    <filename>structspot_1_1twa__run.html</filename>
    <class kind="struct">spot::twa_run::step</class>
    <member kind="function">
      <type>twa_run_ptr</type>
      <name>reduce</name>
      <anchorfile>structspot_1_1twa__run.html</anchorfile>
      <anchor>a10f958fbafa981bee090cf6357bef862</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>twa_run_ptr</type>
      <name>project</name>
      <anchorfile>structspot_1_1twa__run.html</anchorfile>
      <anchor>a193e709bb5f5ae044b682dcffb8d1d8b</anchor>
      <arglist>(const const_twa_ptr &amp;other, bool right=false)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>replay</name>
      <anchorfile>structspot_1_1twa__run.html</anchorfile>
      <anchor>a0179599b9785ee16015ec3aa31340e76</anchor>
      <arglist>(std::ostream &amp;os, bool debug=false) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>highlight</name>
      <anchorfile>structspot_1_1twa__run.html</anchorfile>
      <anchor>a0babc635d669be228a804fec8fcbfc0a</anchor>
      <arglist>(unsigned color)</arglist>
    </member>
    <member kind="function">
      <type>twa_graph_ptr</type>
      <name>as_twa</name>
      <anchorfile>structspot_1_1twa__run.html</anchorfile>
      <anchor>a7e343f84b0627b9d9102a8144f5d0b7d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="friend">
      <type>friend std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>structspot_1_1twa__run.html</anchorfile>
      <anchor>ac1a4c33d84599179329ef86a0c4931bd</anchor>
      <arglist>(std::ostream &amp;os, const twa_run &amp;run)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>spot::twa_run::step</name>
    <filename>structspot_1_1twa__run_1_1step.html</filename>
  </compound>
  <compound kind="struct">
    <name>spot::twa_statistics</name>
    <filename>structspot_1_1twa__statistics.html</filename>
  </compound>
  <compound kind="struct">
    <name>spot::twa_sub_statistics</name>
    <filename>structspot_1_1twa__sub__statistics.html</filename>
    <base>spot::twa_statistics</base>
  </compound>
  <compound kind="class">
    <name>spot::twa_succ_iterator</name>
    <filename>classspot_1_1twa__succ__iterator.html</filename>
  </compound>
  <compound kind="struct">
    <name>spot::twa_word</name>
    <filename>structspot_1_1twa__word.html</filename>
    <member kind="function">
      <type>void</type>
      <name>simplify</name>
      <anchorfile>structspot_1_1twa__word.html</anchorfile>
      <anchor>adfed12cbdd7132ed588c1d74d3ea001f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>twa_graph_ptr</type>
      <name>as_automaton</name>
      <anchorfile>structspot_1_1twa__word.html</anchorfile>
      <anchor>ac6c56ec32408ed889875c94c94dbbdf3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="friend">
      <type>friend std::ostream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchorfile>structspot_1_1twa__word.html</anchorfile>
      <anchor>a435e342c5fa24189656eabb898ca3f32</anchor>
      <arglist>(std::ostream &amp;os, const twa_word &amp;w)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>spot::unabbreviator</name>
    <filename>classspot_1_1unabbreviator.html</filename>
    <member kind="function">
      <type></type>
      <name>unabbreviator</name>
      <anchorfile>classspot_1_1unabbreviator.html</anchorfile>
      <anchor>a4a75cc9ceb9d31893a3d616f4b106c37</anchor>
      <arglist>(const char *opt=default_unabbrev_string)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>spot::unsigned_statistics</name>
    <filename>structspot_1_1unsigned__statistics.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::unsigned_statistics_copy</name>
    <filename>classspot_1_1unsigned__statistics__copy.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::internal::all_edge_iterator</name>
    <filename>classspot_1_1internal_1_1all__edge__iterator.html</filename>
    <templarg></templarg>
  </compound>
  <compound kind="class">
    <name>spot::internal::all_trans</name>
    <filename>classspot_1_1internal_1_1all__trans.html</filename>
    <templarg></templarg>
  </compound>
  <compound kind="struct">
    <name>spot::internal::boxed_label</name>
    <filename>structspot_1_1internal_1_1boxed__label.html</filename>
    <templarg></templarg>
    <templarg>boxed</templarg>
  </compound>
  <compound kind="struct">
    <name>spot::internal::boxed_label&lt; Data, false &gt;</name>
    <filename>structspot_1_1internal_1_1boxed__label_3_01Data_00_01false_01_4.html</filename>
    <templarg></templarg>
  </compound>
  <compound kind="struct">
    <name>spot::internal::boxed_label&lt; void, true &gt;</name>
    <filename>structspot_1_1internal_1_1boxed__label_3_01void_00_01true_01_4.html</filename>
  </compound>
  <compound kind="struct">
    <name>spot::internal::distate_storage</name>
    <filename>structspot_1_1internal_1_1distate__storage.html</filename>
    <templarg></templarg>
    <templarg></templarg>
  </compound>
  <compound kind="class">
    <name>spot::internal::edge_iterator</name>
    <filename>classspot_1_1internal_1_1edge__iterator.html</filename>
    <templarg></templarg>
  </compound>
  <compound kind="struct">
    <name>spot::internal::edge_storage</name>
    <filename>structspot_1_1internal_1_1edge__storage.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
    <templarg></templarg>
  </compound>
  <compound kind="struct">
    <name>spot::internal::first_is_base_of</name>
    <filename>structspot_1_1internal_1_1first__is__base__of.html</filename>
    <templarg></templarg>
    <templarg>Args</templarg>
  </compound>
  <compound kind="struct">
    <name>spot::internal::first_is_base_of&lt; Of, Arg1, Args...&gt;</name>
    <filename>structspot_1_1internal_1_1first__is__base__of_3_01Of_00_01Arg1_00_01Args_8_8_8_4.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <templarg>Args</templarg>
  </compound>
  <compound kind="class">
    <name>spot::internal::killer_edge_iterator</name>
    <filename>classspot_1_1internal_1_1killer__edge__iterator.html</filename>
    <templarg></templarg>
    <base>spot::internal::edge_iterator</base>
  </compound>
  <compound kind="class">
    <name>spot::internal::state_out</name>
    <filename>classspot_1_1internal_1_1state__out.html</filename>
    <templarg></templarg>
  </compound>
  <compound kind="struct">
    <name>spot::internal::succ_iterator</name>
    <filename>structspot_1_1internal_1_1succ__iterator.html</filename>
  </compound>
  <compound kind="class">
    <name>spot::internal::twa_succ_iterable</name>
    <filename>classspot_1_1internal_1_1twa__succ__iterable.html</filename>
  </compound>
  <compound kind="struct">
    <name>std::hash&lt; spot::acc_cond::mark_t &gt;</name>
    <filename>structstd_1_1hash_3_01spot_1_1acc__cond_1_1mark__t_01_4.html</filename>
  </compound>
  <compound kind="struct">
    <name>std::hash&lt; spot::formula &gt;</name>
    <filename>structstd_1_1hash_3_01spot_1_1formula_01_4.html</filename>
  </compound>
  <compound kind="class">
    <name>tlyy::parser</name>
    <filename>classtlyy_1_1parser.html</filename>
    <class kind="struct">tlyy::parser::basic_symbol</class>
    <class kind="struct">tlyy::parser::by_type</class>
    <class kind="union">tlyy::parser::semantic_type</class>
    <class kind="struct">tlyy::parser::syntax_error</class>
    <class kind="struct">tlyy::parser::token</class>
    <member kind="typedef">
      <type>spot::location</type>
      <name>location_type</name>
      <anchorfile>classtlyy_1_1parser.html</anchorfile>
      <anchor>af64c7b83fb40b5bb8e9d09e57445dd79</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>token::yytokentype</type>
      <name>token_type</name>
      <anchorfile>classtlyy_1_1parser.html</anchorfile>
      <anchor>a4ff2b5f82a633beba28c1e8cb90a10bb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>symbol_number_type</name>
      <anchorfile>classtlyy_1_1parser.html</anchorfile>
      <anchor>a06b4c536c9fc88397aa285b7ad012f01</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>unsigned char</type>
      <name>token_number_type</name>
      <anchorfile>classtlyy_1_1parser.html</anchorfile>
      <anchor>ae7dd2c76bb0d0d2f6d52fa16d7ede700</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>basic_symbol&lt; by_type &gt;</type>
      <name>symbol_type</name>
      <anchorfile>classtlyy_1_1parser.html</anchorfile>
      <anchor>ab23171a99ff68620fa64a5379c7319fb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>debug_level_type</name>
      <anchorfile>classtlyy_1_1parser.html</anchorfile>
      <anchor>a45fa9b9953e7b3ed08573eae2bea05de</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>parser</name>
      <anchorfile>classtlyy_1_1parser.html</anchorfile>
      <anchor>a024c2f28a9b0ff21683618a2c6260360</anchor>
      <arglist>(spot::parse_error_list &amp;error_list_yyarg, spot::environment &amp;parse_environment_yyarg, spot::formula &amp;result_yyarg)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>parse</name>
      <anchorfile>classtlyy_1_1parser.html</anchorfile>
      <anchor>ae962b5296d0034214b36341f7e6c0ce1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::ostream &amp;</type>
      <name>debug_stream</name>
      <anchorfile>classtlyy_1_1parser.html</anchorfile>
      <anchor>a33abeee9d14d56199492ee123b735dce</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_debug_stream</name>
      <anchorfile>classtlyy_1_1parser.html</anchorfile>
      <anchor>a9308a5690f67344e5f35925f147f8f84</anchor>
      <arglist>(std::ostream &amp;)</arglist>
    </member>
    <member kind="function">
      <type>debug_level_type</type>
      <name>debug_level</name>
      <anchorfile>classtlyy_1_1parser.html</anchorfile>
      <anchor>a0417bc24bd0d9f731a75bf5e3dc15383</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_debug_level</name>
      <anchorfile>classtlyy_1_1parser.html</anchorfile>
      <anchor>a0cc25fa34bf1345e1919f357e747f2c3</anchor>
      <arglist>(debug_level_type l)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>error</name>
      <anchorfile>classtlyy_1_1parser.html</anchorfile>
      <anchor>a5c310e9aff695c2baf3e7d814a6ebc33</anchor>
      <arglist>(const location_type &amp;loc, const std::string &amp;msg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>error</name>
      <anchorfile>classtlyy_1_1parser.html</anchorfile>
      <anchor>afd6d51fc38d1cfc78bac9634474c5625</anchor>
      <arglist>(const syntax_error &amp;err)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>tlyy::parser::basic_symbol</name>
    <filename>structtlyy_1_1parser_1_1basic__symbol.html</filename>
    <templarg>Base</templarg>
    <member kind="typedef">
      <type>Base</type>
      <name>super_type</name>
      <anchorfile>structtlyy_1_1parser_1_1basic__symbol.html</anchorfile>
      <anchor>acdaf4b7519e31c8558dc2034d1adfe7b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>basic_symbol</name>
      <anchorfile>structtlyy_1_1parser_1_1basic__symbol.html</anchorfile>
      <anchor>acee00a5bede162fb983d11565faa9c4b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>basic_symbol</name>
      <anchorfile>structtlyy_1_1parser_1_1basic__symbol.html</anchorfile>
      <anchor>a4a80b4343d045d538a3ba49554b7d599</anchor>
      <arglist>(const basic_symbol &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>basic_symbol</name>
      <anchorfile>structtlyy_1_1parser_1_1basic__symbol.html</anchorfile>
      <anchor>af2d0ae552305a3ac5802afdb01ce769d</anchor>
      <arglist>(typename Base::kind_type t, const location_type &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>basic_symbol</name>
      <anchorfile>structtlyy_1_1parser_1_1basic__symbol.html</anchorfile>
      <anchor>ab24d87332212bfed378a1cf72095103a</anchor>
      <arglist>(typename Base::kind_type t, const semantic_type &amp;v, const location_type &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>move</name>
      <anchorfile>structtlyy_1_1parser_1_1basic__symbol.html</anchorfile>
      <anchor>ace9c2bf180d04244f77986d5670ebf7e</anchor>
      <arglist>(basic_symbol &amp;s)</arglist>
    </member>
    <member kind="variable">
      <type>semantic_type</type>
      <name>value</name>
      <anchorfile>structtlyy_1_1parser_1_1basic__symbol.html</anchorfile>
      <anchor>a1b8b186225f3f5dba2d2c94e78251566</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>location_type</type>
      <name>location</name>
      <anchorfile>structtlyy_1_1parser_1_1basic__symbol.html</anchorfile>
      <anchor>a8a7b46edafd7bac6b1dc80dc5947703b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>tlyy::parser::by_type</name>
    <filename>structtlyy_1_1parser_1_1by__type.html</filename>
    <member kind="typedef">
      <type>token_type</type>
      <name>kind_type</name>
      <anchorfile>structtlyy_1_1parser_1_1by__type.html</anchorfile>
      <anchor>a502abfa5aa71f12aad47a02e5fde0cdc</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>by_type</name>
      <anchorfile>structtlyy_1_1parser_1_1by__type.html</anchorfile>
      <anchor>aa4de39d9c1d4ac2167d67f92b1caf69a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>by_type</name>
      <anchorfile>structtlyy_1_1parser_1_1by__type.html</anchorfile>
      <anchor>ab7efb794ba2f553446ba71b2beed2302</anchor>
      <arglist>(const by_type &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>by_type</name>
      <anchorfile>structtlyy_1_1parser_1_1by__type.html</anchorfile>
      <anchor>a4d8ea7d1297ccc74e8894a79f708a0e2</anchor>
      <arglist>(kind_type t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>move</name>
      <anchorfile>structtlyy_1_1parser_1_1by__type.html</anchorfile>
      <anchor>a2f98a3e6d8bde7bf1a16e201460ec749</anchor>
      <arglist>(by_type &amp;that)</arglist>
    </member>
    <member kind="function">
      <type>symbol_number_type</type>
      <name>type_get</name>
      <anchorfile>structtlyy_1_1parser_1_1by__type.html</anchorfile>
      <anchor>ac60aaee6d0cfaf4fe07130c601703634</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>token_type</type>
      <name>token</name>
      <anchorfile>structtlyy_1_1parser_1_1by__type.html</anchorfile>
      <anchor>a18d892ad0f6ccc5ca30ab70d7ba2c8fa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>token_number_type</type>
      <name>type</name>
      <anchorfile>structtlyy_1_1parser_1_1by__type.html</anchorfile>
      <anchor>ab8aa32736bdf15df1e5f6659db07166e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="union">
    <name>tlyy::parser::semantic_type</name>
    <filename>uniontlyy_1_1parser_1_1semantic__type.html</filename>
  </compound>
  <compound kind="struct">
    <name>tlyy::parser::syntax_error</name>
    <filename>structtlyy_1_1parser_1_1syntax__error.html</filename>
  </compound>
  <compound kind="struct">
    <name>tlyy::parser::token</name>
    <filename>structtlyy_1_1parser_1_1token.html</filename>
  </compound>
  <compound kind="class">
    <name>tlyy::slice</name>
    <filename>classtlyy_1_1slice.html</filename>
    <templarg></templarg>
    <templarg></templarg>
  </compound>
  <compound kind="class">
    <name>tlyy::stack</name>
    <filename>classtlyy_1_1stack.html</filename>
    <templarg>T</templarg>
    <templarg></templarg>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classtlyy_1_1stack.html</anchorfile>
      <anchor>acca1accef824728257ef8b7404c9c99b</anchor>
      <arglist>(T &amp;t)</arglist>
    </member>
  </compound>
  <compound kind="dir">
    <name>spot/graph</name>
    <path>/build/spot/spot/graph/</path>
    <filename>dir_7ab4f617266355ed5c221bf7b058bc69.html</filename>
    <file>graph.hh</file>
    <file>ngraph.hh</file>
  </compound>
  <compound kind="dir">
    <name>spot/twaalgos/gtec</name>
    <path>/build/spot/spot/twaalgos/gtec/</path>
    <filename>dir_509fd621eb4b88fbef9362b303a865bf.html</filename>
    <file>ce.hh</file>
    <file>gtec.hh</file>
    <file>sccstack.hh</file>
    <file>status.hh</file>
  </compound>
  <compound kind="dir">
    <name>spot/kripke</name>
    <path>/build/spot/spot/kripke/</path>
    <filename>dir_23a86271b32d8d348801e565fb2252c0.html</filename>
    <file>fairkripke.hh</file>
    <file>fwd.hh</file>
    <file>kripke.hh</file>
    <file>kripkegraph.hh</file>
  </compound>
  <compound kind="dir">
    <name>spot/ltsmin</name>
    <path>/build/spot/spot/ltsmin/</path>
    <filename>dir_6335c1b2caec4516b40e4d4518522806.html</filename>
    <file>ltsmin.hh</file>
  </compound>
  <compound kind="dir">
    <name>spot/misc</name>
    <path>/build/spot/spot/misc/</path>
    <filename>dir_20ac7f11cbcdef1ad5d89ea75a24172b.html</filename>
    <file>bareword.hh</file>
    <file>bddlt.hh</file>
    <file>bitvect.hh</file>
    <file>casts.hh</file>
    <file>common.hh</file>
    <file>escape.hh</file>
    <file>fixpool.hh</file>
    <file>formater.hh</file>
    <file>hash.hh</file>
    <file>hashfunc.hh</file>
    <file>intvcmp2.hh</file>
    <file>intvcomp.hh</file>
    <file>ltstr.hh</file>
    <file>memusage.hh</file>
    <file>minato.hh</file>
    <file>mspool.hh</file>
    <file>optionmap.hh</file>
    <file>random.hh</file>
    <file>satsolver.hh</file>
    <file>timer.hh</file>
    <file>tmpfile.hh</file>
    <file>trival.hh</file>
    <file>version.hh</file>
  </compound>
  <compound kind="dir">
    <name>spot/parseaut</name>
    <path>/build/spot/spot/parseaut/</path>
    <filename>dir_3f0274f6a6e7012e39ea452d0a2cdde6.html</filename>
    <file>parseaut.hh</file>
    <file>parsedecl.hh</file>
    <file>public.hh</file>
    <file>stack.hh</file>
  </compound>
  <compound kind="dir">
    <name>spot/parsetl</name>
    <path>/build/spot/spot/parsetl/</path>
    <filename>dir_591716afbcf98a0b73045f5173d88f1d.html</filename>
    <file>parsedecl.hh</file>
    <file>parsetl.hh</file>
    <file>stack.hh</file>
  </compound>
  <compound kind="dir">
    <name>spot</name>
    <path>/build/spot/spot/</path>
    <filename>dir_62559c1653fb310d0d3a445c9a87ebba.html</filename>
    <dir>spot/graph</dir>
    <dir>spot/kripke</dir>
    <dir>spot/ltsmin</dir>
    <dir>spot/misc</dir>
    <dir>spot/parseaut</dir>
    <dir>spot/parsetl</dir>
    <dir>spot/ta</dir>
    <dir>spot/taalgos</dir>
    <dir>spot/tl</dir>
    <dir>spot/twa</dir>
    <dir>spot/twaalgos</dir>
  </compound>
  <compound kind="dir">
    <name>spot/ta</name>
    <path>/build/spot/spot/ta/</path>
    <filename>dir_7f75c59ab64951c2291ab9ad5cc251e6.html</filename>
    <file>ta.hh</file>
    <file>taexplicit.hh</file>
    <file>taproduct.hh</file>
    <file>tgta.hh</file>
    <file>tgtaexplicit.hh</file>
    <file>tgtaproduct.hh</file>
  </compound>
  <compound kind="dir">
    <name>spot/taalgos</name>
    <path>/build/spot/spot/taalgos/</path>
    <filename>dir_421ae94bc22deede4a728f3bcab3ee7f.html</filename>
    <file>dot.hh</file>
    <file>emptinessta.hh</file>
    <file>minimize.hh</file>
    <file>reachiter.hh</file>
    <file>statessetbuilder.hh</file>
    <file>stats.hh</file>
    <file>tgba2ta.hh</file>
  </compound>
  <compound kind="dir">
    <name>spot/tl</name>
    <path>/build/spot/spot/tl/</path>
    <filename>dir_93fd705537400b58c3342a07c12364b4.html</filename>
    <file>apcollect.hh</file>
    <file>contain.hh</file>
    <file>declenv.hh</file>
    <file>defaultenv.hh</file>
    <file>dot.hh</file>
    <file>environment.hh</file>
    <file>exclusive.hh</file>
    <file>formula.hh</file>
    <file>length.hh</file>
    <file>mark.hh</file>
    <file>mutation.hh</file>
    <file>nenoform.hh</file>
    <file>parse.hh</file>
    <file>print.hh</file>
    <file>randomltl.hh</file>
    <file>relabel.hh</file>
    <file>remove_x.hh</file>
    <file>simplify.hh</file>
    <file>snf.hh</file>
    <file>unabbrev.hh</file>
  </compound>
  <compound kind="dir">
    <name>spot/twa</name>
    <path>/build/spot/spot/twa/</path>
    <filename>dir_5a3cb91a066cb9cbb14e2c7015ed7816.html</filename>
    <file>acc.hh</file>
    <file>bdddict.hh</file>
    <file>bddprint.hh</file>
    <file>formula2bdd.hh</file>
    <file>fwd.hh</file>
    <file>taatgba.hh</file>
    <file>twa.hh</file>
    <file>twagraph.hh</file>
    <file>twaproduct.hh</file>
  </compound>
  <compound kind="dir">
    <name>spot/twaalgos</name>
    <path>/build/spot/spot/twaalgos/</path>
    <filename>dir_bf22716de48fb925dfac158392d4a72f.html</filename>
    <dir>spot/twaalgos/gtec</dir>
    <file>are_isomorphic.hh</file>
    <file>bfssteps.hh</file>
    <file>canonicalize.hh</file>
    <file>cleanacc.hh</file>
    <file>complement.hh</file>
    <file>complete.hh</file>
    <file>compsusp.hh</file>
    <file>copy.hh</file>
    <file>cycles.hh</file>
    <file>degen.hh</file>
    <file>determinize.hh</file>
    <file>dot.hh</file>
    <file>dtbasat.hh</file>
    <file>dtwasat.hh</file>
    <file>emptiness.hh</file>
    <file>emptiness_stats.hh</file>
    <file>gv04.hh</file>
    <file>hoa.hh</file>
    <file>isdet.hh</file>
    <file>isunamb.hh</file>
    <file>isweakscc.hh</file>
    <file>lbtt.hh</file>
    <file>ltl2taa.hh</file>
    <file>ltl2tgba_fm.hh</file>
    <file>magic.hh</file>
    <file>mask.hh</file>
    <file>minimize.hh</file>
    <file>neverclaim.hh</file>
    <file>postproc.hh</file>
    <file>powerset.hh</file>
    <file>product.hh</file>
    <file>randomgraph.hh</file>
    <file>randomize.hh</file>
    <file>reachiter.hh</file>
    <file>relabel.hh</file>
    <file>remfin.hh</file>
    <file>remprop.hh</file>
    <file>sbacc.hh</file>
    <file>sccfilter.hh</file>
    <file>sccinfo.hh</file>
    <file>se05.hh</file>
    <file>sepsets.hh</file>
    <file>simulation.hh</file>
    <file>stats.hh</file>
    <file>strength.hh</file>
    <file>stripacc.hh</file>
    <file>stutter.hh</file>
    <file>tau03.hh</file>
    <file>tau03opt.hh</file>
    <file>totgba.hh</file>
    <file>translate.hh</file>
    <file>word.hh</file>
  </compound>
  <compound kind="page">
    <name>index</name>
    <title>Spot Library Documentation</title>
    <filename>index</filename>
    <docanchor file="index" title="The Spot Library">overview</docanchor>
    <docanchor file="index" title="This Document">thisdoc</docanchor>
    <docanchor file="index" title="Handy starting points">pointers</docanchor>
  </compound>
</tagfile>
