#!/usr/bin/perl -w

BEGIN { 
  warn "\nThis test will be slow.  Please be patient.  Thanks!\n";
}

use strict;
use lib qw( t t/lib);

use SpidyTest;
use Test::More tests => $SpidyTest::TEST_URL ? 340 : 201; #'no_plan';

SpidyTest::skipping( 340 - 201 ) unless $SpidyTest::TEST_URL;
                        
use Cwd;
my $path = cwd();

SpidyTest::cleanup( files(), dirs() );

# /usr/bin/perl -I`pwd` ./spider --file t/xml/test.xml \
#                         --filePath t/relative \
#                         --sizes teeny,medium,large \
#                         --inputImagePath ./Spidy/Icons \
#                         --outputImagePathType relative

is_deeply( [ split /\n/, `/usr/bin/perl -I$path ./spider --file t/xml/test.xml \\
                             --filePath t/relative \\
                             --sizes teeny,medium,large \\
                             --inputImagePath ./Spidy/Icons \\
                             --outputImagePathType relative` ], [ grep { !/small/ } @{output()} ], "creating test \"relative\" gallery");

SpidyTest::count( "$path/t/relative", 67 );

SpidyTest::check_files( [ grep { !/small/ } @{files()} ], [ grep { !/small/ } @{dirs()} ] );

SpidyTest::check_url( "$path/t/relative/index.html" ) if $SpidyTest::TEST_URL;

is( -s "$path/t/relative/teeny_index.html", -s "$path/t/relative/index.html", "testing defaulting sizes option");

SpidyTest::cleanup( files(), dirs() );

# /usr/bin/perl -I`pwd` ./spider --file t/xml/test_relative.xml
#
is_deeply( [ split /\n/, `/usr/bin/perl -I$path ./spider --file t/xml/test_relative.xml` ], output(), "creating test \"relative in xml\" gallery");

SpidyTest::count( "$path/t/relative", 84 );

SpidyTest::check_files( files(), dirs() );

SpidyTest::check_url( "$path/t/relative/index.html" ) if $SpidyTest::TEST_URL;

SpidyTest::cleanup( files(), dirs() );

sub files {
  return [ qw( 
    t/relative/set1/subset1/thumb/000000/nothing.gif
    t/relative/set1/subset1/thumb/000000/line_000000.gif
    t/relative/set1/subset1/teeny/nothing.gif
    t/relative/set1/subset1/teeny/line_000000.gif
    t/relative/set1/subset1/small/nothing.gif
    t/relative/set1/subset1/small/line_000000.gif
    t/relative/set1/subset1/medium/nothing.gif
    t/relative/set1/subset1/medium/line_000000.gif
    t/relative/set1/subset1/large/nothing.gif
    t/relative/set1/subset1/large/line_000000.gif
    t/relative/set1/subset1/teeny_index.html
    t/relative/set1/subset1/small_index.html
    t/relative/set1/subset1/medium_index.html
    t/relative/set1/subset1/large_index.html
    t/relative/set1/subset1/teeny_nothing.html
    t/relative/set1/subset1/small_nothing.html
    t/relative/set1/subset1/medium_nothing.html
    t/relative/set1/subset1/large_nothing.html
    t/relative/set1/subset1/teeny_line_000000.html
    t/relative/set1/subset1/small_line_000000.html
    t/relative/set1/subset1/medium_line_000000.html
    t/relative/set1/subset1/large_line_000000.html
    t/relative/set1/subset2/thumb/000000/up_one_000000.gif
    t/relative/set1/subset2/thumb/000000/up_one_FFFFFF.gif
    t/relative/set1/subset2/teeny/up_one_000000.gif
    t/relative/set1/subset2/teeny/up_one_FFFFFF.gif
    t/relative/set1/subset2/small/up_one_000000.gif
    t/relative/set1/subset2/small/up_one_FFFFFF.gif
    t/relative/set1/subset2/medium/up_one_000000.gif
    t/relative/set1/subset2/medium/up_one_FFFFFF.gif
    t/relative/set1/subset2/large/up_one_000000.gif
    t/relative/set1/subset2/large/up_one_FFFFFF.gif
    t/relative/set1/subset2/teeny_index.html
    t/relative/set1/subset2/small_index.html
    t/relative/set1/subset2/medium_index.html
    t/relative/set1/subset2/large_index.html
    t/relative/set1/subset2/teeny_up_one_000000.html
    t/relative/set1/subset2/small_up_one_000000.html
    t/relative/set1/subset2/medium_up_one_000000.html
    t/relative/set1/subset2/large_up_one_000000.html
    t/relative/set1/subset2/teeny_up_one_FFFFFF.html
    t/relative/set1/subset2/small_up_one_FFFFFF.html
    t/relative/set1/subset2/medium_up_one_FFFFFF.html
    t/relative/set1/subset2/large_up_one_FFFFFF.html
    t/relative/set1/teeny_index.html
    t/relative/set1/small_index.html
    t/relative/set1/medium_index.html
    t/relative/set1/large_index.html
    t/relative/set2/thumb/000000/line_FFFFFF.gif
    t/relative/set2/thumb/000000/up_one_FFFFFF.gif
    t/relative/set2/teeny/line_FFFFFF.gif
    t/relative/set2/teeny/up_one_FFFFFF.gif
    t/relative/set2/small/line_FFFFFF.gif
    t/relative/set2/small/up_one_FFFFFF.gif
    t/relative/set2/medium/line_FFFFFF.gif
    t/relative/set2/medium/up_one_FFFFFF.gif
    t/relative/set2/large/line_FFFFFF.gif
    t/relative/set2/large/up_one_FFFFFF.gif
    t/relative/set2/teeny_index.html
    t/relative/set2/small_index.html
    t/relative/set2/medium_index.html
    t/relative/set2/large_index.html
    t/relative/set2/teeny_line_FFFFFF.html
    t/relative/set2/small_line_FFFFFF.html
    t/relative/set2/medium_line_FFFFFF.html
    t/relative/set2/large_line_FFFFFF.html
    t/relative/set2/teeny_up_one_FFFFFF.html
    t/relative/set2/small_up_one_FFFFFF.html
    t/relative/set2/medium_up_one_FFFFFF.html
    t/relative/set2/large_up_one_FFFFFF.html
    t/relative/teeny_index.html
    t/relative/small_index.html
    t/relative/medium_index.html
    t/relative/large_index.html
    t/relative/icons/line_000000.gif
    t/relative/icons/line_FFFFFF.gif
    t/relative/icons/nothing.gif
    t/relative/icons/up_one_000000.gif
    t/relative/icons/up_one_FFFFFF.gif
    t/relative/set1/subset1/index.html
    t/relative/set1/subset2/index.html
    t/relative/set1/index.html
    t/relative/set2/index.html
    t/relative/index.html
  ) ];
}

sub dirs {
  return [ reverse qw(
    t/relative/
    t/relative/icons
    t/relative/set1
    t/relative/set1/subset1
    t/relative/set1/subset1/large
    t/relative/set1/subset1/medium
    t/relative/set1/subset1/small
    t/relative/set1/subset1/teeny
    t/relative/set1/subset1/thumb
    t/relative/set1/subset1/thumb/000000
    t/relative/set1/subset2
    t/relative/set1/subset2/large
    t/relative/set1/subset2/medium
    t/relative/set1/subset2/small
    t/relative/set1/subset2/teeny
    t/relative/set1/subset2/thumb
    t/relative/set1/subset2/thumb/000000
    t/relative/set2
    t/relative/set2/large
    t/relative/set2/medium
    t/relative/set2/small
    t/relative/set2/teeny
    t/relative/set2/thumb
    t/relative/set2/thumb/000000
  ) ];
}

sub output {
  my $convert = SpidyTest::which('convert');
  return [ split /\n/, <<EOF ];
mkdir t/relative
mkdir t/relative/set1
mkdir t/relative/set1/subset1
mkdir t/relative/set1/subset1/thumb
mkdir t/relative/set1/subset1/thumb/000000
creating temporary file t/relative/set1/subset1/thumb/nothing.gif
$convert -geometry 60x60 -quality 80 ./Spidy/Icons/nothing.gif t/relative/set1/subset1/thumb/nothing.gif
$convert -bordercolor #000000 -border 01x01 t/relative/set1/subset1/thumb/nothing.gif t/relative/set1/subset1/thumb/000000/nothing.gif
deleting temporary file t/relative/set1/subset1/thumb/nothing.gif
mkdir t/relative/set1/subset1/teeny
$convert -geometry 250x200 -quality 80 ./Spidy/Icons/nothing.gif t/relative/set1/subset1/teeny/nothing.gif
mkdir t/relative/set1/subset1/small
$convert -geometry 400x300 -quality 80 ./Spidy/Icons/nothing.gif t/relative/set1/subset1/small/nothing.gif
mkdir t/relative/set1/subset1/medium
$convert -geometry 500x400 -quality 80 ./Spidy/Icons/nothing.gif t/relative/set1/subset1/medium/nothing.gif
mkdir t/relative/set1/subset1/large
$convert -geometry 800x600 -quality 90 ./Spidy/Icons/nothing.gif t/relative/set1/subset1/large/nothing.gif
creating temporary file t/relative/set1/subset1/thumb/line_000000.gif
$convert -geometry 60x60 -quality 80 ./Spidy/Icons/line_000000.gif t/relative/set1/subset1/thumb/line_000000.gif
$convert -bordercolor #000000 -border 01x29 t/relative/set1/subset1/thumb/line_000000.gif t/relative/set1/subset1/thumb/000000/line_000000.gif
deleting temporary file t/relative/set1/subset1/thumb/line_000000.gif
$convert -geometry 250x200 -quality 80 ./Spidy/Icons/line_000000.gif t/relative/set1/subset1/teeny/line_000000.gif
$convert -geometry 400x300 -quality 80 ./Spidy/Icons/line_000000.gif t/relative/set1/subset1/small/line_000000.gif
$convert -geometry 500x400 -quality 80 ./Spidy/Icons/line_000000.gif t/relative/set1/subset1/medium/line_000000.gif
$convert -geometry 800x600 -quality 90 ./Spidy/Icons/line_000000.gif t/relative/set1/subset1/large/line_000000.gif
mkdir t/relative/set1/subset2
mkdir t/relative/set1/subset2/thumb
mkdir t/relative/set1/subset2/thumb/000000
creating temporary file t/relative/set1/subset2/thumb/up_one_000000.gif
$convert -geometry 60x60 -quality 80 ./Spidy/Icons/up_one_000000.gif t/relative/set1/subset2/thumb/up_one_000000.gif
$convert -bordercolor #000000 -border 01x01 t/relative/set1/subset2/thumb/up_one_000000.gif t/relative/set1/subset2/thumb/000000/up_one_000000.gif
deleting temporary file t/relative/set1/subset2/thumb/up_one_000000.gif
mkdir t/relative/set1/subset2/teeny
$convert -geometry 250x200 -quality 80 ./Spidy/Icons/up_one_000000.gif t/relative/set1/subset2/teeny/up_one_000000.gif
mkdir t/relative/set1/subset2/small
$convert -geometry 400x300 -quality 80 ./Spidy/Icons/up_one_000000.gif t/relative/set1/subset2/small/up_one_000000.gif
mkdir t/relative/set1/subset2/medium
$convert -geometry 500x400 -quality 80 ./Spidy/Icons/up_one_000000.gif t/relative/set1/subset2/medium/up_one_000000.gif
mkdir t/relative/set1/subset2/large
$convert -geometry 800x600 -quality 90 ./Spidy/Icons/up_one_000000.gif t/relative/set1/subset2/large/up_one_000000.gif
creating temporary file t/relative/set1/subset2/thumb/up_one_FFFFFF.gif
$convert -geometry 60x60 -quality 80 ./Spidy/Icons/up_one_FFFFFF.gif t/relative/set1/subset2/thumb/up_one_FFFFFF.gif
$convert -bordercolor #000000 -border 01x01 t/relative/set1/subset2/thumb/up_one_FFFFFF.gif t/relative/set1/subset2/thumb/000000/up_one_FFFFFF.gif
deleting temporary file t/relative/set1/subset2/thumb/up_one_FFFFFF.gif
$convert -geometry 250x200 -quality 80 ./Spidy/Icons/up_one_FFFFFF.gif t/relative/set1/subset2/teeny/up_one_FFFFFF.gif
$convert -geometry 400x300 -quality 80 ./Spidy/Icons/up_one_FFFFFF.gif t/relative/set1/subset2/small/up_one_FFFFFF.gif
$convert -geometry 500x400 -quality 80 ./Spidy/Icons/up_one_FFFFFF.gif t/relative/set1/subset2/medium/up_one_FFFFFF.gif
$convert -geometry 800x600 -quality 90 ./Spidy/Icons/up_one_FFFFFF.gif t/relative/set1/subset2/large/up_one_FFFFFF.gif
mkdir t/relative/set2
mkdir t/relative/set2/thumb
mkdir t/relative/set2/thumb/000000
creating temporary file t/relative/set2/thumb/line_FFFFFF.gif
$convert -geometry 60x60 -quality 80 ./Spidy/Icons/line_FFFFFF.gif t/relative/set2/thumb/line_FFFFFF.gif
$convert -bordercolor #000000 -border 01x29 t/relative/set2/thumb/line_FFFFFF.gif t/relative/set2/thumb/000000/line_FFFFFF.gif
deleting temporary file t/relative/set2/thumb/line_FFFFFF.gif
mkdir t/relative/set2/teeny
$convert -geometry 250x200 -quality 80 ./Spidy/Icons/line_FFFFFF.gif t/relative/set2/teeny/line_FFFFFF.gif
mkdir t/relative/set2/small
$convert -geometry 400x300 -quality 80 ./Spidy/Icons/line_FFFFFF.gif t/relative/set2/small/line_FFFFFF.gif
mkdir t/relative/set2/medium
$convert -geometry 500x400 -quality 80 ./Spidy/Icons/line_FFFFFF.gif t/relative/set2/medium/line_FFFFFF.gif
mkdir t/relative/set2/large
$convert -geometry 800x600 -quality 90 ./Spidy/Icons/line_FFFFFF.gif t/relative/set2/large/line_FFFFFF.gif
creating temporary file t/relative/set2/thumb/up_one_FFFFFF.gif
$convert -geometry 60x60 -quality 80 ./Spidy/Icons/up_one_FFFFFF.gif t/relative/set2/thumb/up_one_FFFFFF.gif
$convert -bordercolor #000000 -border 01x01 t/relative/set2/thumb/up_one_FFFFFF.gif t/relative/set2/thumb/000000/up_one_FFFFFF.gif
deleting temporary file t/relative/set2/thumb/up_one_FFFFFF.gif
$convert -geometry 250x200 -quality 80 ./Spidy/Icons/up_one_FFFFFF.gif t/relative/set2/teeny/up_one_FFFFFF.gif
$convert -geometry 400x300 -quality 80 ./Spidy/Icons/up_one_FFFFFF.gif t/relative/set2/small/up_one_FFFFFF.gif
$convert -geometry 500x400 -quality 80 ./Spidy/Icons/up_one_FFFFFF.gif t/relative/set2/medium/up_one_FFFFFF.gif
$convert -geometry 800x600 -quality 90 ./Spidy/Icons/up_one_FFFFFF.gif t/relative/set2/large/up_one_FFFFFF.gif
Creating t/relative/teeny_index.html
Loading template $path/Spidy/Templates/group.tmpl
Creating t/relative/small_index.html
Creating t/relative/index.html
Creating t/relative/medium_index.html
Creating t/relative/large_index.html
Creating t/relative/set1/teeny_index.html
Creating t/relative/set1/small_index.html
Creating t/relative/set1/index.html
Creating t/relative/set1/medium_index.html
Creating t/relative/set1/large_index.html
Creating t/relative/set1/subset1/teeny_index.html
Creating t/relative/set1/subset1/small_index.html
Creating t/relative/set1/subset1/index.html
Creating t/relative/set1/subset1/medium_index.html
Creating t/relative/set1/subset1/large_index.html
Creating t/relative/set1/subset1/teeny_nothing.html
Loading template $path/Spidy/Templates/image.tmpl
Creating t/relative/set1/subset1/small_nothing.html
Creating t/relative/set1/subset1/medium_nothing.html
Creating t/relative/set1/subset1/large_nothing.html
Creating t/relative/set1/subset1/teeny_line_000000.html
Creating t/relative/set1/subset1/small_line_000000.html
Creating t/relative/set1/subset1/medium_line_000000.html
Creating t/relative/set1/subset1/large_line_000000.html
Creating t/relative/set1/subset2/teeny_index.html
Creating t/relative/set1/subset2/small_index.html
Creating t/relative/set1/subset2/index.html
Creating t/relative/set1/subset2/medium_index.html
Creating t/relative/set1/subset2/large_index.html
Creating t/relative/set1/subset2/teeny_up_one_000000.html
Creating t/relative/set1/subset2/small_up_one_000000.html
Creating t/relative/set1/subset2/medium_up_one_000000.html
Creating t/relative/set1/subset2/large_up_one_000000.html
Creating t/relative/set1/subset2/teeny_up_one_FFFFFF.html
Creating t/relative/set1/subset2/small_up_one_FFFFFF.html
Creating t/relative/set1/subset2/medium_up_one_FFFFFF.html
Creating t/relative/set1/subset2/large_up_one_FFFFFF.html
Creating t/relative/set2/teeny_index.html
Creating t/relative/set2/small_index.html
Creating t/relative/set2/index.html
Creating t/relative/set2/medium_index.html
Creating t/relative/set2/large_index.html
Creating t/relative/set2/teeny_line_FFFFFF.html
Creating t/relative/set2/small_line_FFFFFF.html
Creating t/relative/set2/medium_line_FFFFFF.html
Creating t/relative/set2/large_line_FFFFFF.html
Creating t/relative/set2/teeny_up_one_FFFFFF.html
Creating t/relative/set2/small_up_one_FFFFFF.html
Creating t/relative/set2/medium_up_one_FFFFFF.html
Creating t/relative/set2/large_up_one_FFFFFF.html
mkdir t/relative/icons
Creating t/relative/icons/line_000000.gif
Creating t/relative/icons/line_FFFFFF.gif
Creating t/relative/icons/nothing.gif
Creating t/relative/icons/up_one_000000.gif
Creating t/relative/icons/up_one_FFFFFF.gif
EOF
}
