#!/usr/bin/perl -w

use strict;
use lib qw( t t/lib );

use constant MIN => 88;
use constant MAX => 139;
use constant FILES => 30;

use SpidyTest;
use Test::More tests => $SpidyTest::TEST_URL ? MAX : MIN; #'no_plan';

SpidyTest::skipping( MAX - MIN ) unless $SpidyTest::TEST_URL;
     
use Cwd;
my $path = cwd();

SpidyTest::cleanup( files(), dirs() );


is_deeply( [ split /\n/, `/usr/bin/perl -I$path ./spider --file t/xml/urls.xml \\
                             --filePath t/urls \\
                             --inputImagePath ./Spidy/Icons \\
                             --sizes small \\
                             --baseUrl file://$path/t/urls \\
                             --outputImagePath t/urls/output_images \\
                             --imageUrl output_images \\
                             --inputFilePath t` ], output(), "creating test \"urls with baseUrl\" gallery");

SpidyTest::count("$path/t/urls", FILES );

SpidyTest::check_files( files(), dirs() );

SpidyTest::check_url( "$path/t/urls/index.html" ) if $SpidyTest::TEST_URL;

SpidyTest::cleanup( files(), dirs() );

# /usr/bin/perl -I`pwd` ./spider --file t/xml/urls.xml \
#                                 --filePath t/urls \
#                                 --inputImagePath ./Spidy/Icons \
#                                 --sizes small \
#                                 --outputImagePath t/urls/output_images \
#                                 --imageUrl file://`pwd`/t/urls/output_images \
#                                 --inputFilePath t

is_deeply( [ split /\n/, `/usr/bin/perl -I$path ./spider --file t/xml/urls.xml \\
                             --filePath t/urls \\
                             --inputImagePath ./Spidy/Icons \\
                             --sizes small \\
                             --outputImagePath t/urls/output_images \\
                             --imageUrl file://$path/t/urls/output_images \\
                             --inputFilePath t` ], output(), "creating test \"urls with imageUrl\" gallery");

SpidyTest::count("$path/t/urls", FILES );

SpidyTest::check_files( files(), dirs() );

SpidyTest::check_url( "$path/t/urls/index.html" ) if $SpidyTest::TEST_URL;

SpidyTest::check_image_count( "$path/t/urls/index.html", 5 );
SpidyTest::check_image_count( "$path/t/urls/top/index.html", 2, 2, 1 );

SpidyTest::cleanup( files(), dirs() );

sub files {
  return [ qw( 
    t/urls/output_images/thumb/000000/line_000000.gif
    t/urls/output_images/thumb/000000/line_FFFFFF.gif
    t/urls/output_images/thumb/000000/nothing.gif
    t/urls/output_images/thumb/000000/up_one_000000.gif
    t/urls/output_images/thumb/000000/up_one_FFFFFF.gif
    t/urls/output_images/small/line_000000.gif
    t/urls/output_images/small/line_FFFFFF.gif
    t/urls/output_images/small/nothing.gif
    t/urls/output_images/small/up_one_000000.gif
    t/urls/output_images/small/up_one_FFFFFF.gif
    t/urls/top/set1/index.html
    t/urls/top/set1/small_index.html
    t/urls/top/set1/small_line_000000.html
    t/urls/top/set1/small_line_FFFFFF.html
    t/urls/top/set2/index.html
    t/urls/top/set2/small_index.html
    t/urls/top/set2/small_nothing.html
    t/urls/top/set2/small_up_one_000000.html
    t/urls/top/set3/index.html
    t/urls/top/set3/small_index.html
    t/urls/top/set3/small_up_one_FFFFFF.html
    t/urls/top/small_index.html
    t/urls/top/index.html
    t/urls/icons/line_000000.gif
    t/urls/icons/line_FFFFFF.gif
    t/urls/icons/nothing.gif
    t/urls/icons/up_one_000000.gif
    t/urls/icons/up_one_FFFFFF.gif
    t/urls/small_index.html
    t/urls/index.html
  ) ];
}

sub dirs {
  return [ reverse qw(
    t/urls
    t/urls/output_images
    t/urls/output_images/thumb
    t/urls/output_images/thumb/000000
    t/urls/output_images/small
    t/urls/top
    t/urls/top/set1
    t/urls/top/set2
    t/urls/top/set3
    t/urls/icons
  ) ];
}

sub output {
  my $convert = SpidyTest::which('convert');
  return [ split /\n/, <<EOF ];
mkdir t/urls
mkdir t/urls/output_images
mkdir t/urls/output_images/thumb
mkdir t/urls/output_images/thumb/000000
creating temporary file t/urls/output_images/thumb/line_000000.gif
$convert -geometry 60x60 -quality 80 ./Spidy/Icons/line_000000.gif t/urls/output_images/thumb/line_000000.gif
$convert -bordercolor #000000 -border 01x29 t/urls/output_images/thumb/line_000000.gif t/urls/output_images/thumb/000000/line_000000.gif
deleting temporary file t/urls/output_images/thumb/line_000000.gif
mkdir t/urls/output_images/small
$convert -geometry 400x300 -quality 80 ./Spidy/Icons/line_000000.gif t/urls/output_images/small/line_000000.gif
creating temporary file t/urls/output_images/thumb/line_FFFFFF.gif
$convert -geometry 60x60 -quality 80 ./Spidy/Icons/line_FFFFFF.gif t/urls/output_images/thumb/line_FFFFFF.gif
$convert -bordercolor #000000 -border 01x29 t/urls/output_images/thumb/line_FFFFFF.gif t/urls/output_images/thumb/000000/line_FFFFFF.gif
deleting temporary file t/urls/output_images/thumb/line_FFFFFF.gif
$convert -geometry 400x300 -quality 80 ./Spidy/Icons/line_FFFFFF.gif t/urls/output_images/small/line_FFFFFF.gif
creating temporary file t/urls/output_images/thumb/nothing.gif
$convert -geometry 60x60 -quality 80 ./Spidy/Icons/nothing.gif t/urls/output_images/thumb/nothing.gif
$convert -bordercolor #000000 -border 01x01 t/urls/output_images/thumb/nothing.gif t/urls/output_images/thumb/000000/nothing.gif
deleting temporary file t/urls/output_images/thumb/nothing.gif
$convert -geometry 400x300 -quality 80 ./Spidy/Icons/nothing.gif t/urls/output_images/small/nothing.gif
creating temporary file t/urls/output_images/thumb/up_one_000000.gif
$convert -geometry 60x60 -quality 80 ./Spidy/Icons/up_one_000000.gif t/urls/output_images/thumb/up_one_000000.gif
$convert -bordercolor #000000 -border 01x01 t/urls/output_images/thumb/up_one_000000.gif t/urls/output_images/thumb/000000/up_one_000000.gif
deleting temporary file t/urls/output_images/thumb/up_one_000000.gif
$convert -geometry 400x300 -quality 80 ./Spidy/Icons/up_one_000000.gif t/urls/output_images/small/up_one_000000.gif
creating temporary file t/urls/output_images/thumb/up_one_FFFFFF.gif
$convert -geometry 60x60 -quality 80 ./Spidy/Icons/up_one_FFFFFF.gif t/urls/output_images/thumb/up_one_FFFFFF.gif
$convert -bordercolor #000000 -border 01x01 t/urls/output_images/thumb/up_one_FFFFFF.gif t/urls/output_images/thumb/000000/up_one_FFFFFF.gif
deleting temporary file t/urls/output_images/thumb/up_one_FFFFFF.gif
$convert -geometry 400x300 -quality 80 ./Spidy/Icons/up_one_FFFFFF.gif t/urls/output_images/small/up_one_FFFFFF.gif
Creating t/urls/small_index.html
Loading template $path/Spidy/Templates/group.tmpl
Creating t/urls/index.html
mkdir t/urls/top
Creating t/urls/top/small_index.html
Creating t/urls/top/index.html
mkdir t/urls/top/set1
Creating t/urls/top/set1/small_index.html
Creating t/urls/top/set1/index.html
Creating t/urls/top/set1/small_line_000000.html
Loading template $path/Spidy/Templates/image.tmpl
Creating t/urls/top/set1/small_line_FFFFFF.html
mkdir t/urls/top/set2
Creating t/urls/top/set2/small_index.html
Creating t/urls/top/set2/index.html
Creating t/urls/top/set2/small_nothing.html
Creating t/urls/top/set2/small_up_one_000000.html
mkdir t/urls/top/set3
Creating t/urls/top/set3/small_index.html
Creating t/urls/top/set3/index.html
Creating t/urls/top/set3/small_up_one_FFFFFF.html
mkdir t/urls/icons
Creating t/urls/icons/line_000000.gif
Creating t/urls/icons/line_FFFFFF.gif
Creating t/urls/icons/nothing.gif
Creating t/urls/icons/up_one_000000.gif
Creating t/urls/icons/up_one_FFFFFF.gif
EOF
}
