#!/usr/bin/perl -w

use strict;
use lib qw( t t/lib );
use Test::More tests => 26; #'no_plan';
use SpidyTest;
use File::Copy;

use Cwd;
my $path = cwd();

SpidyTest::cleanup( files(), dirs() );
is( `/usr/bin/perl -I$path ./spider --getTemplates --filePath t/templates`,<<EOF, "testing --getTemplates" );
Creating t/templates/gallery.xml
Creating t/templates/image.tmpl
Creating t/templates/group.tmpl
EOF

SpidyTest::check_files( [ qw(
  t/templates/gallery.xml
  t/templates/image.tmpl
  t/templates/group.tmpl
) ], [ qw(
  t/templates
) ] );

# /usr/bin/perl -I`pwd` ./spider --file t/xml/single.xml \
#                                 --filePath t/templates \
#                                 --inputImagePath ./Spidy/Icons \
#                                 --sizes teeny \
#                                 --defaultSize teeny \
#                                 --tmplPath t/templates

my @return = split /\n/, `/usr/bin/perl -I$path ./spider \\
                             --file t/xml/single.xml \\
                             --filePath t/templates \\
                             --inputImagePath ./Spidy/Icons \\
                             --sizes teeny \\
                             --defaultSize teeny \\
                             --tmplPath t/templates`;

ok( ( grep { m:\bt/templates/group.tmpl: } @return ), "testing --tmplPath" );
ok( ( grep { m:\bt/templates/image.tmpl: } @return ), "testing --tmplPath" );


@return = split /\n/, `/usr/bin/perl -I$path ./spider \\
                             --file t/xml/single.xml \\
                             --filePath t/templates \\
                             --inputImagePath ./Spidy/Icons \\
                             --sizes teeny \\
                             --defaultSize teeny \\
                             --imageTmpl t/templates/image.tmpl`;

ok( ( grep { m:\bSpidy/Templates/group.tmpl: } @return ), "testing --imageTmpl" );
ok( ( grep { m:\bt/templates/image.tmpl: } @return ), "testing --imageTmpl" );

@return = split /\n/, `/usr/bin/perl -I$path ./spider \\
                             --file t/xml/single.xml \\
                             --filePath t/templates \\
                             --inputImagePath ./Spidy/Icons \\
                             --sizes teeny \\
                             --defaultSize teeny \\
                             --groupTmpl t/templates/group.tmpl`;

ok( ( grep { m:\bt/templates/group.tmpl: } @return ), "testing --groupPath" );
ok( ( grep { m:\bSpidy/Templates/image.tmpl: } @return ), "testing --groupPath" );

unlink( 't/templates/group.tmpl' );

@return = split /\n/, `/usr/bin/perl -I$path ./spider \\
                             --file t/xml/single.xml \\
                             --filePath t/templates \\
                             --inputImagePath ./Spidy/Icons \\
                             --sizes teeny \\
                             --defaultSize teeny \\
                             --tmplPath t/templates`;

ok( ( grep { m:\bSpidy/Templates/group.tmpl: } @return ), "testing --tmplPath" );
ok( ( grep { m:\bt/templates/image.tmpl: } @return ), "testing --tmplPath" );

File::Copy::move( 't/templates/image.tmpl', 't/templates/im.tmpl' );

@return = split /\n/, `/usr/bin/perl -I$path ./spider \\
                             --file t/xml/single.xml \\
                             --filePath t/templates \\
                             --inputImagePath ./Spidy/Icons \\
                             --sizes teeny \\
                             --defaultSize teeny \\
                             --tmplPath t/templates \\
                             --imageTmpl im.tmpl`;

ok( ( grep { m:\bSpidy/Templates/group.tmpl: } @return ), "testing --tmplPath" );
ok( ( grep { m:\bt/templates/im.tmpl: } @return ), "testing --tmplPath" );

@return = split /\n/, `/usr/bin/perl -I$path ./spider \\
                             --file t/xml/single.xml \\
                             --filePath t/templates \\
                             --inputImagePath ./Spidy/Icons \\
                             --sizes teeny \\
                             --defaultSize teeny \\
                             --imageTmpl t/templates/im.tmpl`;

ok( ( grep { m:\bSpidy/Templates/group.tmpl: } @return ), "testing --imagePath" );
ok( ( grep { m:\bt/templates/im.tmpl: } @return ), "testing --imagePath" );

unlink( 't/templates/im.tmpl' );

SpidyTest::cleanup( files(), dirs() );

is( `/usr/bin/perl -I$path ./spider --getXmlTemplate --filePath t/templates`,<<EOF, "testing --getXmlTemplate" );
Creating t/templates/gallery.xml
EOF

SpidyTest::check_files( ['t/templates/gallery.xml'], [ qw(
  t/templates
) ] );

SpidyTest::cleanup( files(), dirs() );

is( `/usr/bin/perl -I$path ./spider --getImageTemplate --filePath t/templates`,<<EOF, "testing --getImageTemplate" );
Creating t/templates/image.tmpl
EOF

SpidyTest::check_files( ['t/templates/image.tmpl'] , [ qw(
  t/templates
) ] );

SpidyTest::cleanup( files(), dirs() );

is( `/usr/bin/perl -I$path ./spider --getGroupTemplate --filePath t/templates`,<<EOF, "testing --getGroupTempate" );
Creating t/templates/group.tmpl
EOF

SpidyTest::check_files( ['t/templates/group.tmpl'], [ qw(
  t/templates
) ] );

SpidyTest::cleanup( files(), dirs() );



sub files {
  return [ qw( 
    t/templates/gallery.xml
    t/templates/image.tmpl
    t/templates/group.tmpl
    t/templates/images/thumb/000000/nothing.gif
    t/templates/images/teeny/nothing.gif
    t/templates/teeny_index.html
    t/templates/index.html
    t/templates/teeny_nothing.html
    t/templates/icons/line_000000.gif
    t/templates/icons/line_FFFFFF.gif
    t/templates/icons/nothing.gif
    t/templates/icons/up_one_000000.gif
    t/templates/icons/up_one_FFFFFF.gif
  )];
}

sub dirs {
  return [ reverse qw(
    t/templates
    t/templates/images
    t/templates/images/thumb
    t/templates/images/thumb/000000
    t/templates/images/teeny
    t/templates/icons
  ) ];
}
