package Spidy::GraphicsBuilder::perlmagick;

use Spidy::GraphicsBuilder;
use Image::Magick;
@ISA = qw( Spidy::GraphicsBuilder );

use strict;

sub resize_image {
  my $self = shift;
  my %args = @_;

  my $x = $args{'width'} || $args{size}->{'max_width'};
  my $y = $args{'height'} || $args{size}->{'max_height'};
  my $geom = "${x}x$y";
  my $qual = $args{size}->{'quality'};

  my $error;
  
  my $img = Image::Magick->new();
  $error = $img->Read( $args{input_image} );
  die $error if $error;
  
  $error = $img->Scale(
    geometry => $geom
  );
  die $error if $error;
  
  $error = $img->Write(
    filename => $args{output_image},
    quality => $qual,
  );
  die $error if $error;

  print "resize_image\n"  unless $ENV{'GATEWAY_INTERFACE'} =~ /CGI/;
  return
}

sub resize_padded_image {
  my $self = shift;
  my %args = @_;
  
  my $x = $args{'width'} || $args{size}->{'max_width'};
  my $y = $args{'height'} || $args{size}->{'max_height'};
  my $geom = "${x}x$y";
  my $qual = $args{size}->{'quality'};

  my $error;
  
  my $img = Image::Magick->new();
  $error = $img->Read( $args{input_image} );
  die $error if $error;
  
  $error = $img->Scale(
    geometry => $geom
  );
  die $error if $error;
  
  my $h = int((100 - $img->Get("height"))/2);
  my $w = int((100 - $img->Get("width"))/2);

  $error = $img->Border(
    height => $h,
    width => $w,
    fill => "#$args{color}",
  );
  die $error if $error;

  $error = $img->Write(
    filename => $args{output_image},
    quality => $qual,
  );
  die $error if $error;

  print "resize_padded_image\n"  unless $ENV{'GATEWAY_INTERFACE'} =~ /CGI/;
  return;
}        

my $watermark;
sub watermark {
  my $self = shift;
  my %args = shift;
  
  if( defined($args{size}->{'watermark'}) 
      && $args{size}->{'watermark'} =~ /$Spidy::GraphicsBuilder::rxTrue/
      && $self->{'watermark'} ) {
      my $x = $args{'width'} || $args{size}->{'max_width'};
      my $y = $args{'height'} || $args{size}->{'max_height'};
      my $geom = "${x}x$y";
      my $qual = $args{size}->{'quality'};

      my $error;

      my $img = Image::Magick->new();
      $error = $img->Read( $args{output_image} );
      die $error if $error;
      
      unless( $watermark ) {
        $watermark = Image::Magick->new();
        $error = $watermark->Read( $self->{'watermark'} );
        die $error if $error;
      }

      $error = $img->Composite(
        gravity => "center",
        compose => "over",
        image => $watermark,
      );
      warn $error if $error;

      $error = $img->Write(
        filename => $args{output_image},
        quality => $qual,
      );
      die $error if $error;
      print "watermark image\n"  unless $ENV{'GATEWAY_INTERFACE'} =~ /CGI/;
  }
  return;
}

1;
